/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

#ifndef _FILEIDX_H_
#define _FILEIDX_H_
#include <windows.h>

//--------------------------------------------------------------------
// @struct FILEDEX | Simple structure used to maintain file offset and
// deletion status for the rows.
//
typedef struct {
	ULONG	ulOffset;			//@field Offset into file
	BYTE	bStatus;			//@field Deletion Status
	} FILEDEX, FAR * LPFILEDEX;


//--------------------------------------------------------------------
// @class CFileIdx | Manages the array of offsets into a file.  This 
// maintains whether the row has been deleted and where the row begins.
// 
// @hungarian 
//
class CFileIdx
{
	START_CLASS(); 

private: //@access private
	//@cmember Array of Offset and Status flags
	LPFILEDEX	m_rgDex;
	//@cmember Current number of rows allocated 
	ULONG		m_ulDexCnt;
	//@cmember Reallocation Routine
	BOOL ReAlloc(ULONG ulRows);

public: //@access public
	//@cmember Class Constructor
	CFileIdx(void);	 
	//@cmember Class Destructor
	~CFileIdx(void);
	//@cmember Initialization Routine
	BOOL fInit(void);
	//@cmember Sets file offset of a particular index
	BOOL SetIndex(ULONG ulDex,	ULONG ulOffset);
	//@cmember Sets the delete flag for a particular row
	BOOL DeleteRow(ULONG ulDex);
	//@cmember Has the Row been deleted
	BOOL IsDeleted(ULONG ulDex);
	//@cmember Returns the offset in the file for a particular row
	ULONG GetRowOffset(ULONG ulDex);

	FINISH_CLASS(); 
};


#endif

