/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

// Includes ------------------------------------------------------------------

#include "hfiles.h"
#include "headers.h"

//----------------------------------------------------------------------------
// CImpIConvertType::CanConvert
//
// @mfunc Used by consumer to determine provider support for a conversion
//
// @rdesc HRESULT indicating the status of the method
//		@flag S_OK | Conversion supported
//		@flag S_FALSE | Conversion unsupported
//		@flag DB_E_BADCONVERTFLAG | dwConvertFlags was invalid
//		@flag DB_E_BADCONVERTFLAG | called on rowset for DBCONVERTFLAG_PARAMETER
//		@flag OTHER | HRESULTS returned from support functions
//
STDMETHODIMP CImpIConvertType::CanConvert
	(
	DBTYPE			wFromType,		//@parm IN | src type
	DBTYPE			wToType,		//@parm IN | dst type
	DBCONVERTFLAGS	dwConvertFlags	//@parm IN | conversion flags
	)
{
	INTERFACE_METHOD_START( "IConvertType::CanConvert" );

	//Flags > 0x0F are not supported
	if ((dwConvertFlags & 0xFFFFFFF0) != 0)
		return DB_E_BADCONVERTFLAG;

	//We do not support parameters
	//if (dwConvertFlags & DBCONVERTFLAGS_PARAMETER)
	//	return DB_E_BADCONVERTFLAG;

	//Special behavior for DBCONVERTFLAGS_ISLONG flag
	if (dwConvertFlags & DBCONVERTFLAGS_ISLONG)
	{
		//Remove any modificator first
		DBTYPE wType = wFromType & ~(DBTYPE_BYREF | DBTYPE_ARRAY | DBTYPE_VECTOR);

		//Check if it is variable type
		if (wType != DBTYPE_STR &&
			wType != DBTYPE_WSTR &&
			wType != DBTYPE_BYTES &&
			wType != DBTYPE_VARNUMERIC)
		{
			return DB_E_BADCONVERTFLAG;
		}
	}

	//Variant checking
	if ((dwConvertFlags & DBCONVERTFLAGS_FROMVARIANT) &&
			!((wFromType >= DBTYPE_EMPTY && wFromType <= DBTYPE_UI8) ||
			   wFromType == DBTYPE_ARRAY	||
			   wFromType == DBTYPE_BYREF	||
			   wFromType == DBTYPE_BYREF	||
			   wFromType == DBTYPE_GUID		|| 
			   wFromType == DBTYPE_VECTOR	||
			   wFromType == DBTYPE_FILETIME ||
			   wFromType == DBTYPE_RESERVED	||
			   wFromType == VT_INT ||
			   wFromType == VT_RECORD))
	{
		return DB_E_BADTYPE;
	}

	//Note that DBTYPE_UI8 and DBTYPE_I8 are not supported
	//Ask the conversion library for the answer
	if (wToType == DBTYPE_WSTR)
		return S_OK;
	else
		return g_pIDataConvert->CanConvert(wFromType, wToType);

	INTERFACE_METHOD_END();
}
