/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */


#include "hfiles.h"
#include "headers.h"
#include <time.h>
#include "asserts.h"

//#ifdef DEBUG    // only compile for debug!
#define HARD_TRACE "c:\\SWSTPROV_DEBUG.TXT"

#ifdef HARD_TRACE

void debug_print(char* str)
{
	FILE* file;
	file = fopen( HARD_TRACE, "a+");
	if( file == NULL ) return;
	fprintf( file, str );
	fprintf( file, "\n" );
	fclose( file );
}

void debug_reset()
{
	FILE* file;
	file = fopen(HARD_TRACE, "w");
	if( file == NULL ) return;
	fclose( file );
}

#endif

//--------------------------------------------------------------------
// @func Variable argument formatter and Dump routine for messages
//
// @rdesc NONE
//
void OLEDB_Trace
    (
    const char *format,     //@parm IN | Format String
    ...                     //@parm IN | Variable Arg List
    )
{
    if( format == NULL )
	{
#ifdef HARD_TRACE	
		debug_reset();
#endif
		return;
	}

	
	char buff[1024 ];
    int cBytesWritten;
    va_list argptr;

    // If this overflows, it will wipe out the return stack.
    // However, we have a wonderful version that ensures no overwrite.
    // Nice because we can't do anything about errors here.

    va_start( argptr, format );
    cBytesWritten = _vsnprintf( buff, sizeof( buff ), format, argptr );
    va_end( argptr );

    // assert would report overflow first, recursively, but don't bother.
    // Would be OK, since this assert could be proven
    // not to overflow temp buffer in assert.
    //assert( cBytesWritten < sizeof(buff) );

	OutputDebugString( buff );
    // go to new line
	OutputDebugString( "\n" );
#ifdef HARD_TRACE	
	debug_print( buff );
#endif
}

//--------------------------------------------------------------------
// @func This an internal assertion routine that dumps more information
// than the normal assertion routines..
//
// @rdesc NONE
//
void OLEDB_Assert
    (
    LPSTR expression,   //@parm IN | Expression to assert on
    LPSTR filename,     //@parm IN | Filname where assertion occurred
    long linenum        //@parm IN | Line number where assertion occurred
    )
{
    char          szbuff[350 ];
    int           cBytesWritten;
    volatile int  fAbort;

    // If this overflows, it will wipe out the return stack.
    // However, we have a wonderful version that ensures no overwrite.
    // Good thing, because we can't do much about overflows here anyway.
    // (However, use of "%.nns" works well.)

    cBytesWritten = _snprintf( szbuff, sizeof( szbuff ),
        "Assertion error!\n  File '%.50s', line '%ld'\n  Expression '%.200s'\n",
        filename, linenum, expression );

    TRACE( szbuff );

    // We're a DLL (therefore Windows), so may not have an output stream we can write to.
    ::MessageBox(
        NULL,   // HWND, which we don't have
        szbuff, // Text
        "Assertion Error",  // Title
        MB_SYSTEMMODAL | MB_ICONHAND | MB_OK );

    // Break and let the user get a crack at it.
    // You can set fAbort=0 to continue merrily along.
    fAbort = 1;
    if (fAbort) 
        {
        abort();    // Raises SIGABRT
        }
}
//#endif

