/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

#pragma once

typedef struct 
{
	SQLCHAR		szName[ 50 ];
	SQLSMALLINT iOdbcType;
	WORD		wOleDbType;
	SQLINTEGER uiLength;
	SQLSMALLINT iDec;
	
	DWORD		dwOffset;

	SQLSMALLINT iNullable;
	LONG		iUpdatable;

	BYTE		bInChangeQuery;
	SQLSMALLINT iOrigOdbcType;
	BOOL		bIsBlob;
	SQLINTEGER	bIsAutoInc;
} MYSQLCOLUMNINFO;

struct SWSTFILEtag;

class CMySql : public CData
{
	START_CLASS(); 

public: // virtual overrides
	// Invalidate buffers
	HRESULT SetMoveInfo( HRESULT hr );
	//@cmember Move relative
	HRESULT MovePending(LONG lRows, BOOL bSaveCurrentPosition );
	//@cmember Move relative
	HRESULT GetFetchedData(LONG lRow, DWORD* pdwBmk);
	//@cmember Move to first row
	HRESULT MoveFirst();
	//@cmember Move to last row
	HRESULT MoveLast();
	//@cmember Move to specified bookmark
	HRESULT MoveBookmark(ULONG* pulBookmark);

	//@cmember Find row from current position
	HRESULT Find(ULONG icol, PCOLUMNDATA pDst/*void* pvValue*/,	DBCOMPAREOP	CompareOp, DBTYPE dbType, bool bForward);

	//@cmember Return the number of rows in the table	
	HRESULT GetRowCnt(DWORD* pdwRows);
	//@cmember Get relative position (by percentage) of the row in table
	HRESULT GetPercentage(ULONG* pulBookmark, double *pdfPPos);
	//@cmember Get bookmark for current row
	HRESULT GetBookmark(ULONG *pulBookmark);
	//@cmember Retrieve number of columns
	HRESULT GetColumnCnt(DWORD* pdwCount);
	//@cmember Retrieve column information
	HRESULT GetColumnInfo(DWORD dwCol, DBCOLUMNINFO* pInfo);
	
	//@cmember Fetch row data
	HRESULT GetRow(ULONG* ulOffset, BYTE* pbProvRow);

	//@cmember Update the current rows values
	HRESULT UpdateRow(ULONG* pulBookmark, ULONG* ulOffset, BYTE* pbProvRow, PACCESSOR	pAccessor, BYTE* pbProvRowOld);
	//@cmember Insert new row
	HRESULT InsertRow(ULONG* ulOffset, BYTE* pbProvRow, PACCESSOR pAccessor);
	//@cmember Remove row with the bmk
	HRESULT DeleteRow(ULONG* pulBookmark);

public:
	CMySql();
	~CMySql();

	//Initialize object and execute query
	HRESULT Init(CDataSource* pDataSource, LPCOLESTR pszCat, LPCSTR szSQL, DWORD* pdwAffectedRows);

protected:
	//@cmember Converts  position to bookmark
	inline ULONG Pos2Bmk(ULONG ulPos) { return (ulPos + NUM_OF_RESERVED_BOOKMARKS); }
	//@cmember Converts bookmark to  position  
	inline ULONG Bmk2Pos(ULONG ulBmk) { return (ulBmk - NUM_OF_RESERVED_BOOKMARKS); }
	//@cmember rebind buffers
	HRESULT ReBind(ULONG nRows, ULONG nShift);
	// Allocate a statement to change the recordset
	HRESULT AllocChangeStmt();
	// Apply an OLEDB buffer + accessor to internal buffer
	HRESULT	GetDataFromRow(DWORD dwUseRowInArray, ULONG* ulOffset, BYTE* pbProvRow, PACCESSOR pAccessor, BOOL bOverwriteAutoinc, ULONG ulMaxBind = (ULONG)-1);
	// Set up what fields to be used in SET and WHERE clauses
	void FindIndexFields();
	// Some data types require to be be converted on get
	HRESULT CorrectData(DWORD dwUseRowInArray);

protected:

	class Holder
	{
		CMySql* m_parent;
	public:
		Holder( CMySql* parent );
		DWORD& RowId( DWORD dwRow );
		SQLUSMALLINT& Status( DWORD dwRow );
		SQLUSMALLINT* StatusArray();
		SQLINTEGER& Hint( DWORD dwRow, DWORD dwColumn );
		SQLINTEGER* HintArray( DWORD dwColumn );
		BYTE* RowColumn( DWORD dwRow, DWORD dwColumn );
		HRESULT Realloc( DWORD dwElems );
		BOOL HintIsNull( DWORD dwRow, DWORD dwColumn ) { return Hint( dwRow, dwColumn ) == SQL_NULL_DATA; }

	};
	friend class Holder;

	enum EnumOperations { eNOTDONE, eINSERT, eINSERT_JUSTDONE, eUPDATE, eDELETE };
	enum EnumUseParams { eNONE = 0, eSET = 1, eWHERE = 2, eALL = -1 };

protected:

	DWORD	m_dwCurrentRowInArray;
	DWORD	m_dwValidRowsInArray;
	DWORD	m_dwTotalRowsInArray;
	DWORD	m_dwWasShifted;
	BYTE*	m_myArray;
	
	DWORD	m_dwCurrentRow;	
	DWORD	m_dwRowSize;
	DWORD	m_dwTotalRows;
	DWORD	m_dwCols;
	DWORD   m_dwRowsInserted;
	MYSQLCOLUMNINFO*	m_pColumnInfo;

	SQLHSTMT	m_hstmt;
	SQLHSTMT	m_hstmtChange;
	SQLHDBC		m_hdbc;
	SQLHENV		m_henv;

	HRESULT		m_hrLastMoveInfo;

	SWSTFILEtag	*m_pUpdateFileInfo;
	EnumOperations	m_enumLastChange;
	
	FINISH_CLASS(); 
};

