/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//cache_openfile.cpp

/** @pkg cache_val.openfile */

#include "hfiles.h"
#include "headers.h"
#include "cache_openfile.h"

CacheVal< OpenFileOut, OpenFileParams > file_open_cache;

/////
OpenFileParams::OpenFileParams( CHAR *lpcaOwner, MT_WORD *lpdataLen, MT_CHAR *lppath_buffer, MT_WORD wOpenMode ) {
	CLEAR_CONSTRUCT(OpenFileParams);
    strcpy0( m_caOwner, lpcaOwner, MAXSTR(m_caOwner) );
    m_dataLen = *lpdataLen;
    memcpy( m_path_buffer, lppath_buffer, _MAX_PATH );
    m_wOpenMode = wOpenMode;
}

/////
bool OpenFileParams::operator ==( const OpenFileParams& cmp ) const {
    return 
        strcmp( m_path_buffer, cmp.m_path_buffer ) == 0 &&
        m_dataLen == cmp.m_dataLen &&
        memcmp( m_caOwner, cmp.m_caOwner, m_dataLen ) == 0 &&
        m_wOpenMode == cmp.m_wOpenMode;
}


/////
void OpenFileOut::update( OpenFileParams& in ) {
    if(m_pOpenSwstFile) m_pOpenSwstFile->Release();
    m_pOpenSwstFile = new OpenSwstFile();
    m_bstatus = m_pOpenSwstFile->open( in );
}

/////
void OpenFileOut::decode( OpenSwstFile **pOpenSwstFile, MT_BYTE *posBlock, CLIENT_ID &clientID, MT_SINT &bstatus ) {
    *pOpenSwstFile = m_pOpenSwstFile;
    m_pOpenSwstFile->AddRef();
    memcpy( posBlock, m_pOpenSwstFile->m_posBlock, sizeof(m_pOpenSwstFile->m_posBlock) );
    memcpy( &clientID, &m_pOpenSwstFile->m_clientID, sizeof(m_pOpenSwstFile->m_clientID) );
    bstatus = m_bstatus;
}
