#ifndef __LF_CODE_EDITOR_H__
#define __LF_CODE_EDITOR_H__

#include "mforms/code_editor.h"
#include "lf_view.h"

#include "Scintilla.h"
#define PLAT_GTK 2
#define GTK
#include "ScintillaWidget.h"

namespace mforms
{
namespace gtk
{

typedef std::map<std::string, int>  StyleNameMap;

class CodeEditorImpl : public ViewImpl
{
  public:
    CodeEditorImpl(CodeEditor* self);
    virtual ~CodeEditorImpl();
    static void init();

    virtual Gtk::Widget *get_outer() const;

    void notify(Scintilla::SCNotification *event);

  private:
    // private data
    GtkWidget         *_sci_gtk_widget;
    Gtk::Widget       *_sci_gtkmm_widget;
    ScintillaObject   *_sci;
    CodeEditor        *_owner;

    static bool create(CodeEditor* self);
    static sptr_t send_editor(CodeEditor* self, unsigned int msg, uptr_t uparam, sptr_t sparam);
    static void show_find_panel(CodeEditor *self, bool show);
    static void set_status_text(CodeEditor *self, const std::string &text);
};

}//end of namespace gtk
}//end of namespace mforms

#endif
