#include "linux_utilities/plugin_editor_base.h"
#include "../backend/wb_editor_storednote.h"
#include "gtk_helpers.h"
#include <gtkmm/textview.h>
#include <gtkmm/button.h>
#include <gtkmm/entry.h>
#include <gtkmm/box.h>
#include <gtkmm/messagedialog.h>

class StoredNoteEditor : public PluginEditorBase
{
  StoredNoteEditorBE *_be;
  Glib::RefPtr<Gtk::Builder> _xml;

  virtual bec::BaseEditor *get_be()
  {
    return _be;
  }
  
  void load();
  void save();
  void apply();
  void discard();
 
  virtual bool can_close();
public:
  StoredNoteEditor(grt::Module *m, bec::GRTManager *grtm, const grt::BaseListRef &args)
    : PluginEditorBase(m, grtm, args), _be(0)
  {
    set_border_width(8);
    
    _xml= Gtk::Builder::create_from_file(grtm->get_data_file_path("modules/data/editor_storednote.glade"));

    Gtk::VBox* box(0);
    _xml->get_widget("vbox1", box);
    box->reparent(*this);

    show_all();
    
    switch_edited_object(grtm, args);
    
    Gtk::Button* btn(0);
    _xml->get_widget("load", btn);
    btn->signal_clicked().connect(sigc::mem_fun(this, &StoredNoteEditor::load));

    _xml->get_widget("save", btn);
    btn->signal_clicked().connect(sigc::mem_fun(this, &StoredNoteEditor::save));

    _xml->get_widget("apply", btn);
    btn->signal_clicked().connect(sigc::mem_fun(this, &StoredNoteEditor::apply));

    _xml->get_widget("discard", btn);
    btn->signal_clicked().connect(sigc::mem_fun(this, &StoredNoteEditor::discard));
  }

  virtual ~StoredNoteEditor()
  {
    delete _be;
  }
  
  virtual bool switch_edited_object(bec::GRTManager *grtm, const grt::BaseListRef &args)
  {    
    Gtk::VBox *vbox;
    _xml->get_widget("editor_placeholder", vbox);
 
    delete _be;
    _be = new StoredNoteEditorBE(grtm, GrtStoredNoteRef::cast_from(args[0]));

    embed_code_editor(_be->get_sql_editor()->get_editor_control(), vbox, false);
    _be->load_text();
    return true;
  }
  
};

//------------------------------------------------------------------------------
void StoredNoteEditor::load()
{
  const std::string file = open_file_chooser();
  if ( !file.empty() )
  {
    _be->load_file(file);
    do_refresh_form_data();
  }
}

//------------------------------------------------------------------------------
void StoredNoteEditor::save()
{
  const std::string file = save_file_chooser();
  if ( !file.empty() )
  { 
    apply();
    _be->save_file(file);
  }
}

//------------------------------------------------------------------------------
void StoredNoteEditor::apply()
{
  _be->commit_changes();
}

//------------------------------------------------------------------------------
void StoredNoteEditor::discard()
{
  _be->load_text();
}

//------------------------------------------------------------------------------
bool StoredNoteEditor::can_close()
{
  if (!_be->can_close())
  {
    Gtk::MessageDialog dlg("<b>There are unsaved changes in the editor</b>\nPlease Apply or Revert these changes before closing.",
                           true, Gtk::MESSAGE_WARNING, Gtk::BUTTONS_OK, true);

    dlg.run();
    return false;
  }

  return true;
}

extern "C" 
{
  GUIPluginBase *createStoredNoteEditor(grt::Module *m, bec::GRTManager *grtm, const grt::BaseListRef &args)
  {
    return Gtk::manage(new StoredNoteEditor(m, grtm, args));
  }
};
