#ifndef __WB_MYSQL_TABLE_EDITOR_H__
#define __WB_MYSQL_TABLE_EDITOR_H__

#include "wb_config.h"
#include <gtkmm/notebook.h>
#include "linux_utilities/plugin_editor_base.h"
#include "../backend/mysql_table_editor.h"

#include <gtkmm/notebook.h>

class DbMySQLTableEditorColumnPage;
class DbMySQLTableEditorIndexPage;
class DbMySQLTableEditorFKPage;
class DbMySQLTableEditorTriggerPage;
class DbMySQLTableEditorPartPage;
class DbMySQLTableEditorOptPage;
class RecordsetView;
class DbMySQLEditorPrivPage;

//==============================================================================
//
//==============================================================================
class DbMySQLTableEditor : public PluginEditorBase
{
  friend class DbMySQLTableEditorColumnPage;
  
  MySQLTableEditorBE                *_be;
  DbMySQLTableEditorColumnPage      *_columns_page;
  DbMySQLTableEditorIndexPage       *_indexes_page;
  DbMySQLTableEditorFKPage          *_fks_page;
  DbMySQLTableEditorTriggerPage     *_triggers_page;
  DbMySQLTableEditorPartPage        *_part_page;
  DbMySQLTableEditorOptPage         *_opts_page;
  RecordsetView                     *_inserts_page;
  DbMySQLEditorPrivPage             *_privs_page;

  void create_table_page();

  void refresh_table_page();
  void partial_refresh(const int what);

  void set_table_collation(Gtk::ComboBoxEntryText* combo);
  void set_table_engine(Gtk::ComboBoxEntryText* combo);

  virtual bec::BaseEditor *get_be();

  bool event_from_table_name_entry(GdkEvent*);

  void page_changed(GtkNotebookPage* page, guint page_num);

  void set_table_name(const std::string &);

  //TESTING
  void refresh_indices();
  //\TESTING
  void set_table_option_by_name(const std::string& name, const std::string& value);
  void set_comment(const std::string& cmt);

  void toggle_header_part();

 protected:
  virtual void decorate_object_editor();

 public:
  DbMySQLTableEditor(grt::Module *m, bec::GRTManager *grtm, const grt::BaseListRef &args);

  virtual ~DbMySQLTableEditor();
  virtual void do_refresh_form_data(); // That's called from PluginEditorBase::refresh_form_data
                                       // which is passed to the backend refresh slot
  virtual bool can_close();
  virtual bool switch_edited_object(bec::GRTManager *grtm, const grt::BaseListRef &args); 
};

#endif
