/* 
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WF_TEXTENTRY_H_
#define _WF_TEXTENTRY_H_

/**
 * Declaration of the Windows wrapper for the mforms TextEntry class.
 */
using namespace System;
using namespace Windows::Forms;

namespace MySQL {
  namespace Forms {

    public ref class TextEntryImpl : public ViewImpl
    {
      String ^_placeholder;
      bool _has_real_text;
      bool _changing_text;

      static bool create(::mforms::TextEntry *self, ::mforms::TextEntryType type);
      static void set_text(::mforms::TextEntry *self, const std::string &text);
      static void set_placeholder_text(::mforms::TextEntry *self, const std::string &text);
      static std::string get_text(::mforms::TextEntry *self);
      static void set_max_length(::mforms::TextEntry *self, int length);
      static void set_read_only(::mforms::TextEntry *self, bool flag);

      void change(Object^ sender, EventArgs^ args);
      void key_pressed(Object^ sender, KeyEventArgs^ args);
      void focus_in(Object^ sender, EventArgs^ args);
      void focus_out(Object^ sender, EventArgs^ args);
    public:
      TextEntryImpl(::mforms::TextEntry *text);

      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK2(bool, ::mforms::TextEntry*, ::mforms::TextEntryType, mgr, f->_textentry_impl, TextEntryImpl, create);
        DEF_CALLBACK2(void, ::mforms::TextEntry*, const std::string&, mgr, f->_textentry_impl, TextEntryImpl, set_text);
        DEF_CALLBACK2(void, ::mforms::TextEntry*, const std::string&, mgr, f->_textentry_impl, TextEntryImpl, set_placeholder_text);
        DEF_CALLBACK1(std::string, ::mforms::TextEntry*, mgr, f->_textentry_impl, TextEntryImpl, get_text);
        DEF_CALLBACK2(void, ::mforms::TextEntry*, int, mgr, f->_textentry_impl, TextEntryImpl, set_max_length);
        DEF_CALLBACK2(void, ::mforms::TextEntry*, bool, mgr, f->_textentry_impl, TextEntryImpl, set_read_only);
      }
    };

  };
};

#endif
