/* 
 * Copyright (c) 2011, 2012 Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
/**
 * Implementation of the label wrapper for the mforms library.
 */

#include "stdafx.h"

#include "mforms/mforms.h"
#include "wf_view.h"
#include "wf_hypertext.h"

#include "base/log.h"
#include "ConvUtils.h"

using namespace Windows::Forms;

using namespace MySQL::Forms;
using namespace MySQL::Utilities;

DEFAULT_LOG_DOMAIN(DOMAIN_MFORMS_WRAPPER)

//----------------- Static functions ---------------------------------------------------------------

bool HyperTextImpl::create(mforms::HyperText *self)
{
  HyperTextImpl^ hyperText= gcnew HyperTextImpl(self);

  if (hyperText != nullptr)
  {
    HtmlLabel^ label = ViewImpl::create<HtmlLabel>(self, hyperText);
    label->AutoScroll = true;
    label->UrlClicked += gcnew System::EventHandler<UrlClickEventArgs^>(&HyperTextImpl::LinkClicked);

    // Default font. Can be overridden in the HTML code as usual.
    try
    {
      label->Font = ControlUtilities::GetFont("Tahoma", 8.25f, FontStyle::Regular);
    }
    catch (System::ArgumentException^ e)
    {
      // Argument exception pops up when the system cannot find the Regular font style (corrupt font).
      log_error("HyperTextImpl::set_monospaced failed. %s\n", e->Message);
    }

    return true;
  }
  return false;
}

//--------------------------------------------------------------------------------------------------

void HyperTextImpl::set_markup_text(mforms::HyperText *self, const std::string &text)
{
  HyperTextImpl^ hyperText= (HyperTextImpl^)ObjectImpl::FromUnmanaged(self);

  if (hyperText != nullptr)
  {
    hyperText->SetMarkupText(text);
  }
}

//----------------- Actual implementation ----------------------------------------------------------

HyperTextImpl::HyperTextImpl(mforms::HyperText *self)
  : ViewImpl(self)
{
}

//--------------------------------------------------------------------------------------------------

void HyperTextImpl::SetMarkupText(const std::string &text)
{
  String^ newText= CppStringToNative(text);
  HtmlLabel^ box= get_control<HtmlLabel>();
  box->Text = newText;
}

//--------------------------------------------------------------------------------------------------

void HyperTextImpl::LinkClicked(Object^ sender, UrlClickEventArgs^ args)
{
  HtmlLabel^ box = (HtmlLabel^) sender;

  if (box->Tag != nullptr)
  {
    ::mforms::HyperText* hyperText = ViewImpl::get_backend_control<::mforms::HyperText>(box);
    if (hyperText != NULL)
    {
      hyperText->handle_url_click(NativeToCppString(args->URL));
      args->Processed = true;
    }
  }
}

//--------------------------------------------------------------------------------------------------
