/* Copyright (C) 2005 MySQL AB

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA */

#include "platform_def.h"
#include <stdio.h>
#include <wchar.h>
#include "windows.h"

FILE* fopen_(const char *filename, const char *mode)
{
  WCHAR wsz_filename[MAX_PATH+1];
  WCHAR wsz_mode[256];

  utf8_to_wc(filename, wsz_filename, ARR_CAPACITY(wsz_filename));
  utf8_to_wc(mode, wsz_mode, ARR_CAPACITY(wsz_mode));

  return _wfopen(wsz_filename, wsz_mode);
}

errno_t fopen_s_(FILE** file, const char *filename, const char *mode)
{
  WCHAR wsz_filename[MAX_PATH+1];
  WCHAR wsz_mode[256];

  utf8_to_wc(filename, wsz_filename, ARR_CAPACITY(wsz_filename));
  utf8_to_wc(mode, wsz_mode, ARR_CAPACITY(wsz_mode));

  return _wfopen_s(file, wsz_filename, wsz_mode);
}
