/* A Bison parser, made by GNU Bison 3.0.4.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.4"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         MYSQLparse
#define yylex           MYSQLlex
#define yyerror         MYSQLerror
#define yydebug         MYSQLdebug
#define yynerrs         MYSQLnerrs


/* Copy the first part of user declarations.  */
#line 31 "/var/lib/pb2/sb_1-6464259-1647856786.57/mysql-cluster-7.4.36-release-export-1734044_gpl/sql/sql_yacc.yy" /* yacc.c:339  */

/*
Note: YYTHD is passed as an argument to yyparse(), and subsequently to yylex().
*/
#define YYLIP (& YYTHD->m_parser_state->m_lip)
#define YYPS (& YYTHD->m_parser_state->m_yacc)
#define YYCSCL  YYTHD->variables.character_set_client

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200                        /* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "sql_priv.h"
#include "unireg.h"                    // REQUIRED: for other includes
#include "sql_parse.h"                        /* comp_*_creator */
#include "sql_table.h"                        /* primary_key_name */
#include "sql_partition.h"  /* mem_alloc_error, partition_info, HASH_PARTITION */
#include "sql_acl.h"                          /* *_ACL */
#include "password.h"       /* my_make_scrambled_password_323, my_make_scrambled_password */
#include "sql_class.h"      /* Key_part_spec, enum_filetype, Diag_condition_item_name */
#include "rpl_slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_instr.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include "sql_alter.h"                         // Sql_cmd_alter_table*
#include "sql_truncate.h"                      // Sql_cmd_truncate_table
#include "sql_admin.h"                         // Sql_cmd_analyze/Check..._table
#include "sql_partition_admin.h"               // Sql_cmd_alter_table_*_part.
#include "sql_handler.h"                       // Sql_cmd_handler_*
#include "sql_signal.h"
#include "sql_get_diagnostics.h"               // Sql_cmd_get_diagnostics
#include "event_parse_data.h"
#include <myisam.h>
#include <myisammrg.h>
#include "keycaches.h"
#include "set_var.h"
#include "opt_explain_traditional.h"
#include "opt_explain_json.h"
#include "lex_token.h"

/* this is to get the bison compilation windows warnings out */
#ifdef _MSC_VER
/* warning C4065: switch statement contains 'default' but no 'case' labels */
#pragma warning (disable : 4065)
#endif

using std::min;
using std::max;

int yylex(void *yylval, void *yythd);

#define yyoverflow(A,B,C,D,E,F)               \
  {                                           \
    ulong val= *(F);                          \
    if (my_yyoverflow((B), (D), &val))        \
    {                                         \
      yyerror(YYTHD, (char*) (A));            \
      return 2;                               \
    }                                         \
    else                                      \
    {                                         \
      *(F)= (YYSIZE_T)val;                    \
    }                                         \
  }

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

/*
  Work around for broken code generated by bison 1.875.

  The code generated by bison 1.875a and later, bison 2.1 and bison 2.2 is ok.
  With bison 1.875 however, the generated code contains:
<pre>
  yyerrlab1:
  #if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
    MY_ATTRIBUTE ((__unused__))
  #endif
</pre>
  This usage of MY_ATTRIBUTE is illegal, so we remove it.
  See the following references for details:
  http://lists.gnu.org/archive/html/bug-bison/2004-02/msg00014.html
  http://gcc.gnu.org/bugzilla/show_bug.cgi?id=14273
*/

#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
#undef MY_ATTRIBUTE
#define MY_ATTRIBUTE(X)
#endif


#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= & thd->m_parser_state->m_lip;

  const char *yytext= lip->get_tok_start();
  if (!yytext)
    yytext= "";

  /* Push an error into the error stack */
  ErrConvString err(yytext, thd->variables.character_set_client);
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  err.ptr(), lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(THD *thd, const char *s)
{
  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif

static bool is_native_function(THD *thd, const LEX_STRING *name)
{
  if (find_native_function_builder(thd, *name))
    return true;

  if (is_lex_native_function(name))
    return true;

  return false;
}


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param thd thread handler
*/

void case_stmt_action_case(THD *thd)
{
  LEX *lex= thd->lex;
  sp_head *sp= lex->sphead;
  sp_pcontext *pctx= lex->get_sp_current_parsing_ctx();

  sp->m_parser_data.new_cont_backpatch();

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  pctx->push_label(thd, EMPTY_STR, sp->instructions());
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

bool case_stmt_action_then(THD *thd, LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *pctx= lex->get_sp_current_parsing_ctx();

  sp_instr_jump *i =
    new (thd->mem_root) sp_instr_jump(sp->instructions(), pctx);

  if (!i || sp->add_instr(thd, i))
    return true;

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->m_parser_data.do_backpatch(pctx->pop_label(), sp->instructions());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  return sp->m_parser_data.add_backpatch_entry(i, pctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *pctx= lex->get_sp_current_parsing_ctx();

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  sp->m_parser_data.do_backpatch(pctx->pop_label(), sp->instructions());

  if (simple)
    pctx->pop_case_expr_id();

  sp->m_parser_data.do_cont_backpatch(sp->instructions());
}


static bool
find_sys_var_null_base(THD *thd, struct sys_var_with_base *tmp)
{
  tmp->var= find_sys_var(thd, tmp->base_name.str, tmp->base_name.length);

  if (tmp->var == NULL)
    my_error(ER_UNKNOWN_SYSTEM_VARIABLE, MYF(0), tmp->base_name.str);
  else
    tmp->base_name= null_lex_str;

  return thd->is_error();
}


/**
  Helper action for a SET statement.
  Used to push a system variable into the assignment list.

  @param thd      the current thread
  @param tmp      the system variable with base name
  @param var_type the scope of the variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_system_variable(THD *thd, struct sys_var_with_base *tmp,
                    enum enum_var_type var_type, Item *val)
{
  set_var *var;
  LEX *lex= thd->lex;
  sp_head *sp= lex->sphead;
  sp_pcontext *pctx= lex->get_sp_current_parsing_ctx();

  /* No AUTOCOMMIT from a stored function or trigger. */
  if (pctx && tmp->var == Sys_autocommit_ptr)
    sp->m_flags|= sp_head::HAS_SET_AUTOCOMMIT_STMT;

#ifdef HAVE_REPLICATION
  if (lex->uses_stored_routines() &&
      ((tmp->var == Sys_gtid_next_ptr
#ifdef HAVE_GTID_NEXT_LIST
       || tmp->var == Sys_gtid_next_list_ptr
#endif
       ) ||
       Sys_gtid_purged_ptr == tmp->var))
  {
    my_error(ER_SET_STATEMENT_CANNOT_INVOKE_FUNCTION, MYF(0),
             tmp->var->name.str);
    return TRUE;
  }
#endif

  if (val && val->type() == Item::FIELD_ITEM &&
      ((Item_field*)val)->table_name)
  {
    my_error(ER_WRONG_TYPE_FOR_VAR, MYF(0), tmp->var->name.str);
    return TRUE;
  }

  if (! (var= new set_var(var_type, tmp->var, &tmp->base_name, val)))
    return TRUE;

  return lex->var_list.push_back(var);
}


/**
  Helper action for a SET statement.
  Used to SET a field of NEW row.

  @param thd                thread handler
  @param trigger_field_name the NEW-row field name
  @param expr_item          the value expression being assigned
  @param expr_query         the value expression query

  @return error status (true if error, false otherwise).
*/

static bool set_trigger_new_row(THD *thd,
                                LEX_STRING trigger_field_name,
                                Item *expr_item,
                                LEX_STRING expr_query)
{
  LEX *lex= thd->lex;
  sp_head *sp= lex->sphead;

  DBUG_ASSERT(expr_item);
  DBUG_ASSERT(sp->m_trg_chistics.action_time == TRG_ACTION_BEFORE &&
              (sp->m_trg_chistics.event == TRG_EVENT_INSERT ||
               sp->m_trg_chistics.event == TRG_EVENT_UPDATE));

  Item_trigger_field *trg_fld=
    new (thd->mem_root) Item_trigger_field(lex->current_context(),
                                           Item_trigger_field::NEW_ROW,
                                           trigger_field_name.str,
                                           UPDATE_ACL, false);

  if (!trg_fld)
    return true;

  sp_instr_set_trigger_field *i=
    new (thd->mem_root)
      sp_instr_set_trigger_field(sp->instructions(),
                                 lex,
                                 trigger_field_name,
                                 trg_fld, expr_item,
                                 expr_query);

  if (!i)
    return true;

  /*
    Let us add this item to list of all Item_trigger_field
    objects in trigger.
  */
  sp->m_cur_instr_trig_field_items.link_in_list(trg_fld,
                                                &trg_fld->next_trg_field);

  return sp->add_instr(thd, i);
}


/**
  Create an object to represent a SP variable in the Item-hierarchy.

  @param thd              The current thread.
  @param name             The SP variable name.
  @param spv              The SP variable (optional).
  @param query_start_ptr  Start of the SQL-statement query string (optional).
  @param start_in_q       Start position of the SP variable name in the query.
  @param end_in_q         End position of the SP variable name in the query.

  @remark If spv is not specified, the name is used to search for the
          variable in the parse-time context. If the variable does not
          exist, a error is set and NULL is returned to the caller.

  @return An Item_splocal object representing the SP variable, or NULL on error.
*/
static Item_splocal* create_item_for_sp_var(THD *thd,
                                            LEX_STRING name,
                                            sp_variable *spv,
                                            const char *query_start_ptr,
                                            const char *start_in_q,
                                            const char *end_in_q)
{
  LEX *lex= thd->lex;
  uint spv_pos_in_query= 0;
  uint spv_len_in_query= 0;
  sp_pcontext *pctx= lex->get_sp_current_parsing_ctx();

  /* If necessary, look for the variable. */
  if (pctx && !spv)
    spv= pctx->find_variable(name, false);

  if (!spv)
  {
    my_error(ER_SP_UNDECLARED_VAR, MYF(0), name.str);
    return NULL;
  }

  DBUG_ASSERT(pctx && spv);

  if (query_start_ptr)
  {
    /* Position and length of the SP variable name in the query. */
    spv_pos_in_query= start_in_q - query_start_ptr;
    spv_len_in_query= end_in_q - start_in_q;
  }

  Item_splocal *item=
    new (thd->mem_root) Item_splocal(
      name, spv->offset, spv->type, spv_pos_in_query, spv_len_in_query);

#ifndef DBUG_OFF
  if (item)
    item->m_sp= lex->sphead;
#endif

  return item;
}


/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}

/**
   @brief Creates a new SELECT_LEX for a UNION branch.

   Sets up and initializes a SELECT_LEX structure for a query once the parser
   discovers a UNION token. The current SELECT_LEX is pushed on the stack and
   the new SELECT_LEX becomes the current one.

   @param lex The parser state.

   @param is_union_distinct True if the union preceding the new select statement
   uses UNION DISTINCT.

   @param is_top_level This should be @c TRUE if the newly created SELECT_LEX
   is a non-nested statement.

   @return <code>false</code> if successful, <code>true</code> if an error was
   reported. In the latter case parsing should stop.
 */
bool add_select_to_union_list(LEX *lex, bool is_union_distinct, 
                              bool is_top_level)
{
  /* 
     Only the last SELECT can have INTO. Since the grammar won't allow INTO in
     a nested SELECT, we make this check only when creating a top-level SELECT.
  */
  if (is_top_level && lex->result)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "UNION", "INTO");
    return TRUE;
  }
  if (lex->proc_analyse)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "UNION", "SELECT ... PROCEDURE ANALYSE()");
    return TRUE;
  }
  if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  /* This counter shouldn't be incremented for UNION parts */
  lex->nest_level--;
  if (mysql_new_select(lex, 0))
    return TRUE;
  mysql_init_select(lex);
  lex->current_select->linkage=UNION_TYPE;
  if (is_union_distinct) /* UNION DISTINCT - remember position */
    lex->current_select->master_unit()->union_distinct=
      lex->current_select;
  return FALSE;
}

/**
   @brief Initializes a SELECT_LEX for a query within parentheses (aka
   braces).

   @return false if successful, true if an error was reported. In the latter
   case parsing should stop.
 */
bool setup_select_in_parentheses(LEX *lex) 
{
  SELECT_LEX * sel= lex->current_select;
  if (sel->set_braces(1))
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      !sel->master_unit()->first_select()->braces &&
      sel->master_unit()->first_select()->linkage ==
      UNION_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      sel->olap != UNSPECIFIED_OLAP_TYPE &&
      sel->master_unit()->fake_select_lex)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "CUBE/ROLLUP", "ORDER BY");
    return TRUE;
  }
  /* select in braces, can't contain global parameters */
  if (sel->master_unit()->fake_select_lex)
    sel->master_unit()->global_parameters=
      sel->master_unit()->fake_select_lex;
  return FALSE;
}

static bool add_create_index_prepare (LEX *lex, Table_ident *table)
{
  lex->sql_command= SQLCOM_CREATE_INDEX;
  if (!lex->current_select->add_table_to_list(lex->thd, table, NULL,
                                              TL_OPTION_UPDATING,
                                              TL_READ_NO_INSERT,
                                              MDL_SHARED_UPGRADABLE))
    return TRUE;
  lex->alter_info.reset();
  lex->alter_info.flags= Alter_info::ALTER_ADD_INDEX;
  lex->col_list.empty();
  lex->change= NullS;
  return FALSE;
}

static bool add_create_index (LEX *lex, Key::Keytype type,
                              const LEX_STRING &name,
                              KEY_CREATE_INFO *info= NULL, bool generated= 0)
{
  Key *key;
  key= new Key(type, name, info ? info : &lex->key_create_info, generated, 
               lex->col_list);
  if (key == NULL)
    return TRUE;

  lex->alter_info.key_list.push_back(key);
  lex->col_list.empty();
  return FALSE;
}

/**
  Make a new string allocated on THD's mem-root.

  @param thd        thread handler.
  @param start_ptr  start of the new string.
  @param end_ptr    end of the new string.

  @return LEX_STRING object, containing a pointer to a newly
  constructed/allocated string, and its length. The pointer is NULL
  in case of out-of-memory error.
*/
static LEX_STRING make_string(THD *thd,
                              const char *start_ptr,
                              const char *end_ptr)
{
  LEX_STRING s;

  s.length= end_ptr - start_ptr;
  s.str= (char *) thd->alloc(s.length + 1);

  if (s.str)
    strmake(s.str, start_ptr, s.length);

  return s;
}

/*
  The start is either lip->ptr, if there was no lookahead, lip->tok_start
  otherwise.
*/
#define YY_TOKEN_START \
  ((yychar == YYEMPTY) ?  YYLIP->get_ptr() : YYLIP->get_tok_start())

/*
   The end is either lip->ptr, if there was no lookahead,
   or lip->tok_end otherwise.
*/

#define YY_TOKEN_END \
  ((yychar == YYEMPTY) ?  YYLIP->get_ptr() : YYLIP->get_tok_end())

/**
  Create a separate LEX for each assignment if in SP.

  If we are in SP we want have own LEX for each assignment.
  This is mostly because it is hard for several sp_instr_set
  and sp_instr_set_trigger instructions share one LEX.
  (Well, it is theoretically possible but adds some extra
  overhead on preparation for execution stage and IMO less
  robust).

  @see sp_create_assignment_instr

  @param thd        Thread context
  @param option_ptr Option-value-expression start pointer
*/

static void sp_create_assignment_lex(THD *thd, const char *option_ptr)
{
  LEX *lex= thd->lex;
  sp_head *sp= lex->sphead;

  /*
    We can come here in the following cases:

      1. it's a regular SET statement outside stored programs
        (lex->sphead is NULL);

      2. we're parsing a stored program normally (loading from mysql.proc, ...);

      3. we're re-parsing SET-statement with a user variable after meta-data
        change. It's guaranteed, that:
        - this SET-statement deals with a user/system variable (otherwise, it
          would be a different SP-instruction, and we would parse an expression);
        - this SET-statement has a single user/system variable assignment
          (that's how we generate sp_instr_stmt-instructions for SET-statements).
        So, in this case, even if lex->sphead is set, we should not process
        further.
  */

  if (!sp ||            // case #1
      sp->is_invoked()) // case #3
  {
    return;
  }

  LEX *old_lex= lex;
  sp->reset_lex(thd);
  lex= thd->lex;

  /* Set new LEX as if we at start of set rule. */
  mysql_init_select(lex);
  lex->sql_command= SQLCOM_SET_OPTION;
  lex->var_list.empty();
  lex->one_shot_set= 0;
  lex->autocommit= 0;

  /*
    It's a SET statement within SP. It will be either translated
    into one or more sp_instr_stmt instructions, or it will be
    sp_instr_set / sp_instr_set_trigger_field instructions.
    In any case, position of SP-variable can not be determined
    reliably. So, we set the start pointer of the current statement
    to NULL.
  */
  sp->m_parser_data.set_current_stmt_start_ptr(NULL);
  sp->m_parser_data.set_option_start_ptr(option_ptr);

  /* Inherit from outer lex. */
  lex->option_type= old_lex->option_type;
}


/**
  Create a SP instruction for a SET assignment.

  @see sp_create_assignment_lex

  @param thd           Thread context
  @param expr_end_ptr  Option-value-expression end pointer

  @return false if success, true otherwise.
*/

static bool sp_create_assignment_instr(THD *thd, const char *expr_end_ptr)
{
  LEX *lex= thd->lex;
  sp_head *sp= lex->sphead;

  /*
    We can come here in the following cases:

      1. it's a regular SET statement outside stored programs
        (lex->sphead is NULL);

      2. we're parsing a stored program normally (loading from mysql.proc, ...);

      3. we're re-parsing SET-statement with a user variable after meta-data
        change. It's guaranteed, that:
        - this SET-statement deals with a user/system variable (otherwise, it
          would be a different SP-instruction, and we would parse an expression);
        - this SET-statement has a single user/system variable assignment
          (that's how we generate sp_instr_stmt-instructions for SET-statements).
        So, in this case, even if lex->sphead is set, we should not process
        further.
  */

  if (!sp ||            // case #1
      sp->is_invoked()) // case #3
  {
    return false;
  }

  if (!lex->var_list.is_empty())
  {
    /* Extract expression string. */

    const char *expr_start_ptr= sp->m_parser_data.get_option_start_ptr();

    LEX_STRING expr;
    expr.str= (char *) expr_start_ptr;
    expr.length= expr_end_ptr - expr_start_ptr;

    /* Construct SET-statement query. */

    LEX_STRING set_stmt_query;

    set_stmt_query.length= expr.length + 3;
    set_stmt_query.str= (char *) thd->alloc(set_stmt_query.length + 1);

    if (!set_stmt_query.str)
      return true;

    strmake(strmake(set_stmt_query.str, "SET", 3),
            expr.str, expr.length);

    /*
      We have assignment to user or system variable or option setting, so we
      should construct sp_instr_stmt for it.
    */

    sp_instr_stmt *i=
      new (thd->mem_root)
        sp_instr_stmt(sp->instructions(), lex, set_stmt_query);

    if (!i || sp->add_instr(thd, i))
      return true;
  }

  /* Remember option_type of the currently parsed LEX. */
  enum_var_type inner_option_type= lex->option_type;

  if (sp->restore_lex(thd))
    return true;

  /* Copy option_type to outer lex in case it has changed. */
  thd->lex->option_type= inner_option_type;

  return false;
}

/**
  Compare a LEX_USER against the current user as defined by the exact user and
  host used during authentication.

  @param user A pointer to a user which needs to be matched against the
              current.

  @see SET PASSWORD rules

  @retval true The specified user is the authorized user
  @retval false The user doesn't match
*/

bool match_authorized_user(Security_context *ctx, LEX_USER *user)
{
  if(user->user.str && my_strcasecmp(system_charset_info,
                                     ctx->priv_user,
                                     user->user.str) == 0)
  {
    /*
      users match; let's compare hosts.
      1. first compare with the host we actually authorized,
      2. then see if we match the host mask of the priv_host
    */
    if (user->host.str && my_strcasecmp(system_charset_info,
                                        user->host.str,
                                        ctx->priv_host) == 0)
    {
      /* specified user exactly match the authorized user */
      return true;
    }
  }
  return false;
}



#line 1017 "/var/lib/pb2/sb_1-6464259-1647856786.57/dist_GPL/sql/sql_yacc.cc" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* In a future release of Bison, this section will be replaced
   by #include "sql_yacc.h".  */
#ifndef YY_MYSQL_VAR_LIB_PB2_SB_1_6464259_1647856786_57_DIST_GPL_SQL_SQL_YACC_H_INCLUDED
# define YY_MYSQL_VAR_LIB_PB2_SB_1_6464259_1647856786_57_DIST_GPL_SQL_SQL_YACC_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int MYSQLdebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    ABORT_SYM = 258,
    ACCESSIBLE_SYM = 259,
    ACTION = 260,
    ADD = 261,
    ADDDATE_SYM = 262,
    AFTER_SYM = 263,
    AGAINST = 264,
    AGGREGATE_SYM = 265,
    ALGORITHM_SYM = 266,
    ALL = 267,
    ALTER = 268,
    ANALYSE_SYM = 269,
    ANALYZE_SYM = 270,
    AND_AND_SYM = 271,
    AND_SYM = 272,
    ANY_SYM = 273,
    AS = 274,
    ASC = 275,
    ASCII_SYM = 276,
    ASENSITIVE_SYM = 277,
    AT_SYM = 278,
    AUTOEXTEND_SIZE_SYM = 279,
    AUTO_INC = 280,
    AVG_ROW_LENGTH = 281,
    AVG_SYM = 282,
    BACKUP_SYM = 283,
    BEFORE_SYM = 284,
    BEGIN_SYM = 285,
    BETWEEN_SYM = 286,
    BIGINT = 287,
    BINARY = 288,
    BINLOG_SYM = 289,
    BIN_NUM = 290,
    BIT_AND = 291,
    BIT_OR = 292,
    BIT_SYM = 293,
    BIT_XOR = 294,
    BLOB_SYM = 295,
    BLOCK_SYM = 296,
    BOOLEAN_SYM = 297,
    BOOL_SYM = 298,
    BOTH = 299,
    BTREE_SYM = 300,
    BY = 301,
    BYTE_SYM = 302,
    CACHE_SYM = 303,
    CALL_SYM = 304,
    CASCADE = 305,
    CASCADED = 306,
    CASE_SYM = 307,
    CAST_SYM = 308,
    CATALOG_NAME_SYM = 309,
    CHAIN_SYM = 310,
    CHANGE = 311,
    CHANGED = 312,
    CHARSET = 313,
    CHAR_SYM = 314,
    CHECKSUM_SYM = 315,
    CHECK_SYM = 316,
    CIPHER_SYM = 317,
    CLASS_ORIGIN_SYM = 318,
    CLIENT_SYM = 319,
    CLOSE_SYM = 320,
    COALESCE = 321,
    CODE_SYM = 322,
    COLLATE_SYM = 323,
    COLLATION_SYM = 324,
    COLUMNS = 325,
    COLUMN_SYM = 326,
    COLUMN_FORMAT_SYM = 327,
    COLUMN_NAME_SYM = 328,
    COMMENT_SYM = 329,
    COMMITTED_SYM = 330,
    COMMIT_SYM = 331,
    COMPACT_SYM = 332,
    COMPLETION_SYM = 333,
    COMPRESSED_SYM = 334,
    CONCURRENT = 335,
    CONDITION_SYM = 336,
    CONNECTION_SYM = 337,
    CONSISTENT_SYM = 338,
    CONSTRAINT = 339,
    CONSTRAINT_CATALOG_SYM = 340,
    CONSTRAINT_NAME_SYM = 341,
    CONSTRAINT_SCHEMA_SYM = 342,
    CONTAINS_SYM = 343,
    CONTEXT_SYM = 344,
    CONTINUE_SYM = 345,
    CONVERT_SYM = 346,
    COUNT_SYM = 347,
    CPU_SYM = 348,
    CREATE = 349,
    CROSS = 350,
    CUBE_SYM = 351,
    CURDATE = 352,
    CURRENT_SYM = 353,
    CURRENT_USER = 354,
    CURSOR_SYM = 355,
    CURSOR_NAME_SYM = 356,
    CURTIME = 357,
    DATABASE = 358,
    DATABASES = 359,
    DATAFILE_SYM = 360,
    DATA_SYM = 361,
    DATETIME = 362,
    DATE_ADD_INTERVAL = 363,
    DATE_SUB_INTERVAL = 364,
    DATE_SYM = 365,
    DAY_HOUR_SYM = 366,
    DAY_MICROSECOND_SYM = 367,
    DAY_MINUTE_SYM = 368,
    DAY_SECOND_SYM = 369,
    DAY_SYM = 370,
    DEALLOCATE_SYM = 371,
    DECIMAL_NUM = 372,
    DECIMAL_SYM = 373,
    DECLARE_SYM = 374,
    DEFAULT = 375,
    DEFAULT_AUTH_SYM = 376,
    DEFINER_SYM = 377,
    DELAYED_SYM = 378,
    DELAY_KEY_WRITE_SYM = 379,
    DELETE_SYM = 380,
    DESC = 381,
    DESCRIBE = 382,
    DES_KEY_FILE = 383,
    DETERMINISTIC_SYM = 384,
    DIAGNOSTICS_SYM = 385,
    DIRECTORY_SYM = 386,
    DISABLE_SYM = 387,
    DISCARD = 388,
    DISK_SYM = 389,
    DISTINCT = 390,
    DIV_SYM = 391,
    DOUBLE_SYM = 392,
    DO_SYM = 393,
    DROP = 394,
    DUAL_SYM = 395,
    DUMPFILE = 396,
    DUPLICATE_SYM = 397,
    DYNAMIC_SYM = 398,
    EACH_SYM = 399,
    ELSE = 400,
    ELSEIF_SYM = 401,
    ENABLE_SYM = 402,
    ENCLOSED = 403,
    END = 404,
    ENDS_SYM = 405,
    END_OF_INPUT = 406,
    ENGINES_SYM = 407,
    ENGINE_SYM = 408,
    ENUM = 409,
    EQ = 410,
    EQUAL_SYM = 411,
    ERROR_SYM = 412,
    ERRORS = 413,
    ESCAPED = 414,
    ESCAPE_SYM = 415,
    EVENTS_SYM = 416,
    EVENT_SYM = 417,
    EVERY_SYM = 418,
    EXCHANGE_SYM = 419,
    EXECUTE_SYM = 420,
    EXISTS = 421,
    EXIT_SYM = 422,
    EXPANSION_SYM = 423,
    EXPIRE_SYM = 424,
    EXPORT_SYM = 425,
    EXTENDED_SYM = 426,
    EXTENT_SIZE_SYM = 427,
    EXTRACT_SYM = 428,
    FALSE_SYM = 429,
    FAST_SYM = 430,
    FAULTS_SYM = 431,
    FETCH_SYM = 432,
    FILE_SYM = 433,
    FIRST_SYM = 434,
    FIXED_SYM = 435,
    FLOAT_NUM = 436,
    FLOAT_SYM = 437,
    FLUSH_SYM = 438,
    FORCE_SYM = 439,
    FOREIGN = 440,
    FOR_SYM = 441,
    FORMAT_SYM = 442,
    FOUND_SYM = 443,
    FROM = 444,
    FULL = 445,
    FULLTEXT_SYM = 446,
    FUNCTION_SYM = 447,
    GE = 448,
    GENERAL = 449,
    GEOMETRYCOLLECTION = 450,
    GEOMETRY_SYM = 451,
    GET_FORMAT = 452,
    GET_SYM = 453,
    GLOBAL_SYM = 454,
    GRANT = 455,
    GRANTS = 456,
    GROUP_SYM = 457,
    GROUP_CONCAT_SYM = 458,
    GT_SYM = 459,
    HANDLER_SYM = 460,
    HASH_SYM = 461,
    HAVING = 462,
    HELP_SYM = 463,
    HEX_NUM = 464,
    HIGH_PRIORITY = 465,
    HOST_SYM = 466,
    HOSTS_SYM = 467,
    HOUR_MICROSECOND_SYM = 468,
    HOUR_MINUTE_SYM = 469,
    HOUR_SECOND_SYM = 470,
    HOUR_SYM = 471,
    IDENT = 472,
    IDENTIFIED_SYM = 473,
    IDENT_QUOTED = 474,
    IF = 475,
    IGNORE_SYM = 476,
    IGNORE_SERVER_IDS_SYM = 477,
    IMPORT = 478,
    INDEXES = 479,
    INDEX_SYM = 480,
    INFILE = 481,
    INITIAL_SIZE_SYM = 482,
    INNER_SYM = 483,
    INOUT_SYM = 484,
    INSENSITIVE_SYM = 485,
    INSERT = 486,
    INSERT_METHOD = 487,
    INSTALL_SYM = 488,
    INTERVAL_SYM = 489,
    INTO = 490,
    INT_SYM = 491,
    INVOKER_SYM = 492,
    IN_SYM = 493,
    IO_AFTER_GTIDS = 494,
    IO_BEFORE_GTIDS = 495,
    IO_SYM = 496,
    IPC_SYM = 497,
    IS = 498,
    ISOLATION = 499,
    ISSUER_SYM = 500,
    ITERATE_SYM = 501,
    JOIN_SYM = 502,
    KEYS = 503,
    KEY_BLOCK_SIZE = 504,
    KEY_SYM = 505,
    KILL_SYM = 506,
    LANGUAGE_SYM = 507,
    LAST_SYM = 508,
    LE = 509,
    LEADING = 510,
    LEAVES = 511,
    LEAVE_SYM = 512,
    LEFT = 513,
    LESS_SYM = 514,
    LEVEL_SYM = 515,
    LEX_HOSTNAME = 516,
    LIKE = 517,
    LIMIT = 518,
    LINEAR_SYM = 519,
    LINES = 520,
    LINESTRING = 521,
    LIST_SYM = 522,
    LOAD = 523,
    LOCAL_SYM = 524,
    LOCATOR_SYM = 525,
    LOCKS_SYM = 526,
    LOCK_SYM = 527,
    LOGFILE_SYM = 528,
    LOGS_SYM = 529,
    LONGBLOB = 530,
    LONGTEXT = 531,
    LONG_NUM = 532,
    LONG_SYM = 533,
    LOOP_SYM = 534,
    LOW_PRIORITY = 535,
    LT = 536,
    MASTER_AUTO_POSITION_SYM = 537,
    MASTER_BIND_SYM = 538,
    MASTER_CONNECT_RETRY_SYM = 539,
    MASTER_DELAY_SYM = 540,
    MASTER_HOST_SYM = 541,
    MASTER_LOG_FILE_SYM = 542,
    MASTER_LOG_POS_SYM = 543,
    MASTER_PASSWORD_SYM = 544,
    MASTER_PORT_SYM = 545,
    MASTER_RETRY_COUNT_SYM = 546,
    MASTER_SERVER_ID_SYM = 547,
    MASTER_SSL_CAPATH_SYM = 548,
    MASTER_SSL_CA_SYM = 549,
    MASTER_SSL_CERT_SYM = 550,
    MASTER_SSL_CIPHER_SYM = 551,
    MASTER_SSL_CRL_SYM = 552,
    MASTER_SSL_CRLPATH_SYM = 553,
    MASTER_SSL_KEY_SYM = 554,
    MASTER_SSL_SYM = 555,
    MASTER_SSL_VERIFY_SERVER_CERT_SYM = 556,
    MASTER_SYM = 557,
    MASTER_USER_SYM = 558,
    MASTER_HEARTBEAT_PERIOD_SYM = 559,
    MATCH = 560,
    MAX_CONNECTIONS_PER_HOUR = 561,
    MAX_QUERIES_PER_HOUR = 562,
    MAX_ROWS = 563,
    MAX_SIZE_SYM = 564,
    MAX_SYM = 565,
    MAX_UPDATES_PER_HOUR = 566,
    MAX_USER_CONNECTIONS_SYM = 567,
    MAX_VALUE_SYM = 568,
    MEDIUMBLOB = 569,
    MEDIUMINT = 570,
    MEDIUMTEXT = 571,
    MEDIUM_SYM = 572,
    MEMORY_SYM = 573,
    MERGE_SYM = 574,
    MESSAGE_TEXT_SYM = 575,
    MICROSECOND_SYM = 576,
    MIGRATE_SYM = 577,
    MINUTE_MICROSECOND_SYM = 578,
    MINUTE_SECOND_SYM = 579,
    MINUTE_SYM = 580,
    MIN_ROWS = 581,
    MIN_SYM = 582,
    MODE_SYM = 583,
    MODIFIES_SYM = 584,
    MODIFY_SYM = 585,
    MOD_SYM = 586,
    MONTH_SYM = 587,
    MULTILINESTRING = 588,
    MULTIPOINT = 589,
    MULTIPOLYGON = 590,
    MUTEX_SYM = 591,
    MYSQL_ERRNO_SYM = 592,
    NAMES_SYM = 593,
    NAME_SYM = 594,
    NATIONAL_SYM = 595,
    NATURAL = 596,
    NCHAR_STRING = 597,
    NCHAR_SYM = 598,
    NDBCLUSTER_SYM = 599,
    NE = 600,
    NEG = 601,
    NEW_SYM = 602,
    NEXT_SYM = 603,
    NODEGROUP_SYM = 604,
    NONE_SYM = 605,
    NOT2_SYM = 606,
    NOT_SYM = 607,
    NOW_SYM = 608,
    NO_SYM = 609,
    NO_WAIT_SYM = 610,
    NO_WRITE_TO_BINLOG = 611,
    NULL_SYM = 612,
    NUM = 613,
    NUMBER_SYM = 614,
    NUMERIC_SYM = 615,
    NVARCHAR_SYM = 616,
    OFFLINE_SYM = 617,
    OFFSET_SYM = 618,
    OLD_PASSWORD = 619,
    ON = 620,
    ONE_SYM = 621,
    ONLINE_SYM = 622,
    ONLY_SYM = 623,
    OPEN_SYM = 624,
    OPTIMIZE = 625,
    OPTIONS_SYM = 626,
    OPTION = 627,
    OPTIONALLY = 628,
    OR2_SYM = 629,
    ORDER_SYM = 630,
    OR_OR_SYM = 631,
    OR_SYM = 632,
    OUTER = 633,
    OUTFILE = 634,
    OUT_SYM = 635,
    OWNER_SYM = 636,
    PACK_KEYS_SYM = 637,
    PAGE_SYM = 638,
    PARAM_MARKER = 639,
    PARSER_SYM = 640,
    PARTIAL = 641,
    PARTITION_SYM = 642,
    PARTITIONS_SYM = 643,
    PARTITIONING_SYM = 644,
    PASSWORD = 645,
    PHASE_SYM = 646,
    PLUGIN_DIR_SYM = 647,
    PLUGIN_SYM = 648,
    PLUGINS_SYM = 649,
    POINT_SYM = 650,
    POLYGON = 651,
    PORT_SYM = 652,
    POSITION_SYM = 653,
    PRECISION = 654,
    PREPARE_SYM = 655,
    PRESERVE_SYM = 656,
    PREV_SYM = 657,
    PRIMARY_SYM = 658,
    PRIVILEGES = 659,
    PROCEDURE_SYM = 660,
    PROCESS = 661,
    PROCESSLIST_SYM = 662,
    PROFILE_SYM = 663,
    PROFILES_SYM = 664,
    PROXY_SYM = 665,
    PURGE = 666,
    QUARTER_SYM = 667,
    QUERY_SYM = 668,
    QUICK = 669,
    RANGE_SYM = 670,
    READS_SYM = 671,
    READ_ONLY_SYM = 672,
    READ_SYM = 673,
    READ_WRITE_SYM = 674,
    REAL = 675,
    REBUILD_SYM = 676,
    RECOVER_SYM = 677,
    REDOFILE_SYM = 678,
    REDO_BUFFER_SIZE_SYM = 679,
    REDUNDANT_SYM = 680,
    REFERENCES = 681,
    REGEXP = 682,
    RELAY = 683,
    RELAYLOG_SYM = 684,
    RELAY_LOG_FILE_SYM = 685,
    RELAY_LOG_POS_SYM = 686,
    RELAY_THREAD = 687,
    RELEASE_SYM = 688,
    RELOAD = 689,
    REMOVE_SYM = 690,
    RENAME = 691,
    REORGANIZE_SYM = 692,
    REPAIR = 693,
    REPEATABLE_SYM = 694,
    REPEAT_SYM = 695,
    REPLACE = 696,
    REPLICATION = 697,
    REQUIRE_SYM = 698,
    RESET_SYM = 699,
    RESIGNAL_SYM = 700,
    RESOURCES = 701,
    RESTORE_SYM = 702,
    RESTRICT = 703,
    RESUME_SYM = 704,
    RETURNED_SQLSTATE_SYM = 705,
    RETURNS_SYM = 706,
    RETURN_SYM = 707,
    REVERSE_SYM = 708,
    REVOKE = 709,
    RIGHT = 710,
    ROLLBACK_SYM = 711,
    ROLLUP_SYM = 712,
    ROUTINE_SYM = 713,
    ROWS_SYM = 714,
    ROW_FORMAT_SYM = 715,
    ROW_SYM = 716,
    ROW_COUNT_SYM = 717,
    RTREE_SYM = 718,
    SAVEPOINT_SYM = 719,
    SCHEDULE_SYM = 720,
    SCHEMA_NAME_SYM = 721,
    SECOND_MICROSECOND_SYM = 722,
    SECOND_SYM = 723,
    SECURITY_SYM = 724,
    SELECT_SYM = 725,
    SENSITIVE_SYM = 726,
    SEPARATOR_SYM = 727,
    SERIALIZABLE_SYM = 728,
    SERIAL_SYM = 729,
    SESSION_SYM = 730,
    SERVER_SYM = 731,
    SERVER_OPTIONS = 732,
    SET = 733,
    SET_VAR = 734,
    SHARE_SYM = 735,
    SHIFT_LEFT = 736,
    SHIFT_RIGHT = 737,
    SHOW = 738,
    SHUTDOWN = 739,
    SIGNAL_SYM = 740,
    SIGNED_SYM = 741,
    SIMPLE_SYM = 742,
    SLAVE = 743,
    SLOW = 744,
    SMALLINT = 745,
    SNAPSHOT_SYM = 746,
    SOCKET_SYM = 747,
    SONAME_SYM = 748,
    SOUNDS_SYM = 749,
    SOURCE_SYM = 750,
    SPATIAL_SYM = 751,
    SPECIFIC_SYM = 752,
    SQLEXCEPTION_SYM = 753,
    SQLSTATE_SYM = 754,
    SQLWARNING_SYM = 755,
    SQL_AFTER_GTIDS = 756,
    SQL_AFTER_MTS_GAPS = 757,
    SQL_BEFORE_GTIDS = 758,
    SQL_BIG_RESULT = 759,
    SQL_BUFFER_RESULT = 760,
    SQL_CACHE_SYM = 761,
    SQL_CALC_FOUND_ROWS = 762,
    SQL_NO_CACHE_SYM = 763,
    SQL_SMALL_RESULT = 764,
    SQL_SYM = 765,
    SQL_THREAD = 766,
    SSL_SYM = 767,
    STARTING = 768,
    STARTS_SYM = 769,
    START_SYM = 770,
    STATS_AUTO_RECALC_SYM = 771,
    STATS_PERSISTENT_SYM = 772,
    STATS_SAMPLE_PAGES_SYM = 773,
    STATUS_SYM = 774,
    STDDEV_SAMP_SYM = 775,
    STD_SYM = 776,
    STOP_SYM = 777,
    STORAGE_SYM = 778,
    STRAIGHT_JOIN = 779,
    STRING_SYM = 780,
    SUBCLASS_ORIGIN_SYM = 781,
    SUBDATE_SYM = 782,
    SUBJECT_SYM = 783,
    SUBPARTITIONS_SYM = 784,
    SUBPARTITION_SYM = 785,
    SUBSTRING = 786,
    SUM_SYM = 787,
    SUPER_SYM = 788,
    SUSPEND_SYM = 789,
    SWAPS_SYM = 790,
    SWITCHES_SYM = 791,
    SYSDATE = 792,
    TABLES = 793,
    TABLESPACE = 794,
    TABLE_REF_PRIORITY = 795,
    TABLE_SYM = 796,
    TABLE_CHECKSUM_SYM = 797,
    TABLE_NAME_SYM = 798,
    TEMPORARY = 799,
    TEMPTABLE_SYM = 800,
    TERMINATED = 801,
    TEXT_STRING = 802,
    TEXT_SYM = 803,
    THAN_SYM = 804,
    THEN_SYM = 805,
    TIMESTAMP = 806,
    TIMESTAMP_ADD = 807,
    TIMESTAMP_DIFF = 808,
    TIME_SYM = 809,
    TINYBLOB = 810,
    TINYINT = 811,
    TINYTEXT = 812,
    TO_SYM = 813,
    TRAILING = 814,
    TRANSACTION_SYM = 815,
    TRIGGERS_SYM = 816,
    TRIGGER_SYM = 817,
    TRIM = 818,
    TRUE_SYM = 819,
    TRUNCATE_SYM = 820,
    TYPES_SYM = 821,
    TYPE_SYM = 822,
    UDF_RETURNS_SYM = 823,
    ULONGLONG_NUM = 824,
    UNCOMMITTED_SYM = 825,
    UNDEFINED_SYM = 826,
    UNDERSCORE_CHARSET = 827,
    UNDOFILE_SYM = 828,
    UNDO_BUFFER_SIZE_SYM = 829,
    UNDO_SYM = 830,
    UNICODE_SYM = 831,
    UNINSTALL_SYM = 832,
    UNION_SYM = 833,
    UNIQUE_SYM = 834,
    UNKNOWN_SYM = 835,
    UNLOCK_SYM = 836,
    UNSIGNED = 837,
    UNTIL_SYM = 838,
    UPDATE_SYM = 839,
    UPGRADE_SYM = 840,
    USAGE = 841,
    USER = 842,
    USE_FRM = 843,
    USE_SYM = 844,
    USING = 845,
    UTC_DATE_SYM = 846,
    UTC_TIMESTAMP_SYM = 847,
    UTC_TIME_SYM = 848,
    VALUES = 849,
    VALUE_SYM = 850,
    VARBINARY = 851,
    VARCHAR = 852,
    VARIABLES = 853,
    VARIANCE_SYM = 854,
    VARYING = 855,
    VAR_SAMP_SYM = 856,
    VIEW_SYM = 857,
    WAIT_SYM = 858,
    WARNINGS = 859,
    WEEK_SYM = 860,
    WEIGHT_STRING_SYM = 861,
    WHEN_SYM = 862,
    WHERE = 863,
    WHILE_SYM = 864,
    WITH = 865,
    WITH_CUBE_SYM = 866,
    WITH_ROLLUP_SYM = 867,
    WORK_SYM = 868,
    WRAPPER_SYM = 869,
    WRITE_SYM = 870,
    X509_SYM = 871,
    XA_SYM = 872,
    XML_SYM = 873,
    XOR = 874,
    YEAR_MONTH_SYM = 875,
    YEAR_SYM = 876,
    ZEROFILL = 877
  };
#endif
/* Tokens.  */
#define ABORT_SYM 258
#define ACCESSIBLE_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYSE_SYM 269
#define ANALYZE_SYM 270
#define AND_AND_SYM 271
#define AND_SYM 272
#define ANY_SYM 273
#define AS 274
#define ASC 275
#define ASCII_SYM 276
#define ASENSITIVE_SYM 277
#define AT_SYM 278
#define AUTOEXTEND_SIZE_SYM 279
#define AUTO_INC 280
#define AVG_ROW_LENGTH 281
#define AVG_SYM 282
#define BACKUP_SYM 283
#define BEFORE_SYM 284
#define BEGIN_SYM 285
#define BETWEEN_SYM 286
#define BIGINT 287
#define BINARY 288
#define BINLOG_SYM 289
#define BIN_NUM 290
#define BIT_AND 291
#define BIT_OR 292
#define BIT_SYM 293
#define BIT_XOR 294
#define BLOB_SYM 295
#define BLOCK_SYM 296
#define BOOLEAN_SYM 297
#define BOOL_SYM 298
#define BOTH 299
#define BTREE_SYM 300
#define BY 301
#define BYTE_SYM 302
#define CACHE_SYM 303
#define CALL_SYM 304
#define CASCADE 305
#define CASCADED 306
#define CASE_SYM 307
#define CAST_SYM 308
#define CATALOG_NAME_SYM 309
#define CHAIN_SYM 310
#define CHANGE 311
#define CHANGED 312
#define CHARSET 313
#define CHAR_SYM 314
#define CHECKSUM_SYM 315
#define CHECK_SYM 316
#define CIPHER_SYM 317
#define CLASS_ORIGIN_SYM 318
#define CLIENT_SYM 319
#define CLOSE_SYM 320
#define COALESCE 321
#define CODE_SYM 322
#define COLLATE_SYM 323
#define COLLATION_SYM 324
#define COLUMNS 325
#define COLUMN_SYM 326
#define COLUMN_FORMAT_SYM 327
#define COLUMN_NAME_SYM 328
#define COMMENT_SYM 329
#define COMMITTED_SYM 330
#define COMMIT_SYM 331
#define COMPACT_SYM 332
#define COMPLETION_SYM 333
#define COMPRESSED_SYM 334
#define CONCURRENT 335
#define CONDITION_SYM 336
#define CONNECTION_SYM 337
#define CONSISTENT_SYM 338
#define CONSTRAINT 339
#define CONSTRAINT_CATALOG_SYM 340
#define CONSTRAINT_NAME_SYM 341
#define CONSTRAINT_SCHEMA_SYM 342
#define CONTAINS_SYM 343
#define CONTEXT_SYM 344
#define CONTINUE_SYM 345
#define CONVERT_SYM 346
#define COUNT_SYM 347
#define CPU_SYM 348
#define CREATE 349
#define CROSS 350
#define CUBE_SYM 351
#define CURDATE 352
#define CURRENT_SYM 353
#define CURRENT_USER 354
#define CURSOR_SYM 355
#define CURSOR_NAME_SYM 356
#define CURTIME 357
#define DATABASE 358
#define DATABASES 359
#define DATAFILE_SYM 360
#define DATA_SYM 361
#define DATETIME 362
#define DATE_ADD_INTERVAL 363
#define DATE_SUB_INTERVAL 364
#define DATE_SYM 365
#define DAY_HOUR_SYM 366
#define DAY_MICROSECOND_SYM 367
#define DAY_MINUTE_SYM 368
#define DAY_SECOND_SYM 369
#define DAY_SYM 370
#define DEALLOCATE_SYM 371
#define DECIMAL_NUM 372
#define DECIMAL_SYM 373
#define DECLARE_SYM 374
#define DEFAULT 375
#define DEFAULT_AUTH_SYM 376
#define DEFINER_SYM 377
#define DELAYED_SYM 378
#define DELAY_KEY_WRITE_SYM 379
#define DELETE_SYM 380
#define DESC 381
#define DESCRIBE 382
#define DES_KEY_FILE 383
#define DETERMINISTIC_SYM 384
#define DIAGNOSTICS_SYM 385
#define DIRECTORY_SYM 386
#define DISABLE_SYM 387
#define DISCARD 388
#define DISK_SYM 389
#define DISTINCT 390
#define DIV_SYM 391
#define DOUBLE_SYM 392
#define DO_SYM 393
#define DROP 394
#define DUAL_SYM 395
#define DUMPFILE 396
#define DUPLICATE_SYM 397
#define DYNAMIC_SYM 398
#define EACH_SYM 399
#define ELSE 400
#define ELSEIF_SYM 401
#define ENABLE_SYM 402
#define ENCLOSED 403
#define END 404
#define ENDS_SYM 405
#define END_OF_INPUT 406
#define ENGINES_SYM 407
#define ENGINE_SYM 408
#define ENUM 409
#define EQ 410
#define EQUAL_SYM 411
#define ERROR_SYM 412
#define ERRORS 413
#define ESCAPED 414
#define ESCAPE_SYM 415
#define EVENTS_SYM 416
#define EVENT_SYM 417
#define EVERY_SYM 418
#define EXCHANGE_SYM 419
#define EXECUTE_SYM 420
#define EXISTS 421
#define EXIT_SYM 422
#define EXPANSION_SYM 423
#define EXPIRE_SYM 424
#define EXPORT_SYM 425
#define EXTENDED_SYM 426
#define EXTENT_SIZE_SYM 427
#define EXTRACT_SYM 428
#define FALSE_SYM 429
#define FAST_SYM 430
#define FAULTS_SYM 431
#define FETCH_SYM 432
#define FILE_SYM 433
#define FIRST_SYM 434
#define FIXED_SYM 435
#define FLOAT_NUM 436
#define FLOAT_SYM 437
#define FLUSH_SYM 438
#define FORCE_SYM 439
#define FOREIGN 440
#define FOR_SYM 441
#define FORMAT_SYM 442
#define FOUND_SYM 443
#define FROM 444
#define FULL 445
#define FULLTEXT_SYM 446
#define FUNCTION_SYM 447
#define GE 448
#define GENERAL 449
#define GEOMETRYCOLLECTION 450
#define GEOMETRY_SYM 451
#define GET_FORMAT 452
#define GET_SYM 453
#define GLOBAL_SYM 454
#define GRANT 455
#define GRANTS 456
#define GROUP_SYM 457
#define GROUP_CONCAT_SYM 458
#define GT_SYM 459
#define HANDLER_SYM 460
#define HASH_SYM 461
#define HAVING 462
#define HELP_SYM 463
#define HEX_NUM 464
#define HIGH_PRIORITY 465
#define HOST_SYM 466
#define HOSTS_SYM 467
#define HOUR_MICROSECOND_SYM 468
#define HOUR_MINUTE_SYM 469
#define HOUR_SECOND_SYM 470
#define HOUR_SYM 471
#define IDENT 472
#define IDENTIFIED_SYM 473
#define IDENT_QUOTED 474
#define IF 475
#define IGNORE_SYM 476
#define IGNORE_SERVER_IDS_SYM 477
#define IMPORT 478
#define INDEXES 479
#define INDEX_SYM 480
#define INFILE 481
#define INITIAL_SIZE_SYM 482
#define INNER_SYM 483
#define INOUT_SYM 484
#define INSENSITIVE_SYM 485
#define INSERT 486
#define INSERT_METHOD 487
#define INSTALL_SYM 488
#define INTERVAL_SYM 489
#define INTO 490
#define INT_SYM 491
#define INVOKER_SYM 492
#define IN_SYM 493
#define IO_AFTER_GTIDS 494
#define IO_BEFORE_GTIDS 495
#define IO_SYM 496
#define IPC_SYM 497
#define IS 498
#define ISOLATION 499
#define ISSUER_SYM 500
#define ITERATE_SYM 501
#define JOIN_SYM 502
#define KEYS 503
#define KEY_BLOCK_SIZE 504
#define KEY_SYM 505
#define KILL_SYM 506
#define LANGUAGE_SYM 507
#define LAST_SYM 508
#define LE 509
#define LEADING 510
#define LEAVES 511
#define LEAVE_SYM 512
#define LEFT 513
#define LESS_SYM 514
#define LEVEL_SYM 515
#define LEX_HOSTNAME 516
#define LIKE 517
#define LIMIT 518
#define LINEAR_SYM 519
#define LINES 520
#define LINESTRING 521
#define LIST_SYM 522
#define LOAD 523
#define LOCAL_SYM 524
#define LOCATOR_SYM 525
#define LOCKS_SYM 526
#define LOCK_SYM 527
#define LOGFILE_SYM 528
#define LOGS_SYM 529
#define LONGBLOB 530
#define LONGTEXT 531
#define LONG_NUM 532
#define LONG_SYM 533
#define LOOP_SYM 534
#define LOW_PRIORITY 535
#define LT 536
#define MASTER_AUTO_POSITION_SYM 537
#define MASTER_BIND_SYM 538
#define MASTER_CONNECT_RETRY_SYM 539
#define MASTER_DELAY_SYM 540
#define MASTER_HOST_SYM 541
#define MASTER_LOG_FILE_SYM 542
#define MASTER_LOG_POS_SYM 543
#define MASTER_PASSWORD_SYM 544
#define MASTER_PORT_SYM 545
#define MASTER_RETRY_COUNT_SYM 546
#define MASTER_SERVER_ID_SYM 547
#define MASTER_SSL_CAPATH_SYM 548
#define MASTER_SSL_CA_SYM 549
#define MASTER_SSL_CERT_SYM 550
#define MASTER_SSL_CIPHER_SYM 551
#define MASTER_SSL_CRL_SYM 552
#define MASTER_SSL_CRLPATH_SYM 553
#define MASTER_SSL_KEY_SYM 554
#define MASTER_SSL_SYM 555
#define MASTER_SSL_VERIFY_SERVER_CERT_SYM 556
#define MASTER_SYM 557
#define MASTER_USER_SYM 558
#define MASTER_HEARTBEAT_PERIOD_SYM 559
#define MATCH 560
#define MAX_CONNECTIONS_PER_HOUR 561
#define MAX_QUERIES_PER_HOUR 562
#define MAX_ROWS 563
#define MAX_SIZE_SYM 564
#define MAX_SYM 565
#define MAX_UPDATES_PER_HOUR 566
#define MAX_USER_CONNECTIONS_SYM 567
#define MAX_VALUE_SYM 568
#define MEDIUMBLOB 569
#define MEDIUMINT 570
#define MEDIUMTEXT 571
#define MEDIUM_SYM 572
#define MEMORY_SYM 573
#define MERGE_SYM 574
#define MESSAGE_TEXT_SYM 575
#define MICROSECOND_SYM 576
#define MIGRATE_SYM 577
#define MINUTE_MICROSECOND_SYM 578
#define MINUTE_SECOND_SYM 579
#define MINUTE_SYM 580
#define MIN_ROWS 581
#define MIN_SYM 582
#define MODE_SYM 583
#define MODIFIES_SYM 584
#define MODIFY_SYM 585
#define MOD_SYM 586
#define MONTH_SYM 587
#define MULTILINESTRING 588
#define MULTIPOINT 589
#define MULTIPOLYGON 590
#define MUTEX_SYM 591
#define MYSQL_ERRNO_SYM 592
#define NAMES_SYM 593
#define NAME_SYM 594
#define NATIONAL_SYM 595
#define NATURAL 596
#define NCHAR_STRING 597
#define NCHAR_SYM 598
#define NDBCLUSTER_SYM 599
#define NE 600
#define NEG 601
#define NEW_SYM 602
#define NEXT_SYM 603
#define NODEGROUP_SYM 604
#define NONE_SYM 605
#define NOT2_SYM 606
#define NOT_SYM 607
#define NOW_SYM 608
#define NO_SYM 609
#define NO_WAIT_SYM 610
#define NO_WRITE_TO_BINLOG 611
#define NULL_SYM 612
#define NUM 613
#define NUMBER_SYM 614
#define NUMERIC_SYM 615
#define NVARCHAR_SYM 616
#define OFFLINE_SYM 617
#define OFFSET_SYM 618
#define OLD_PASSWORD 619
#define ON 620
#define ONE_SYM 621
#define ONLINE_SYM 622
#define ONLY_SYM 623
#define OPEN_SYM 624
#define OPTIMIZE 625
#define OPTIONS_SYM 626
#define OPTION 627
#define OPTIONALLY 628
#define OR2_SYM 629
#define ORDER_SYM 630
#define OR_OR_SYM 631
#define OR_SYM 632
#define OUTER 633
#define OUTFILE 634
#define OUT_SYM 635
#define OWNER_SYM 636
#define PACK_KEYS_SYM 637
#define PAGE_SYM 638
#define PARAM_MARKER 639
#define PARSER_SYM 640
#define PARTIAL 641
#define PARTITION_SYM 642
#define PARTITIONS_SYM 643
#define PARTITIONING_SYM 644
#define PASSWORD 645
#define PHASE_SYM 646
#define PLUGIN_DIR_SYM 647
#define PLUGIN_SYM 648
#define PLUGINS_SYM 649
#define POINT_SYM 650
#define POLYGON 651
#define PORT_SYM 652
#define POSITION_SYM 653
#define PRECISION 654
#define PREPARE_SYM 655
#define PRESERVE_SYM 656
#define PREV_SYM 657
#define PRIMARY_SYM 658
#define PRIVILEGES 659
#define PROCEDURE_SYM 660
#define PROCESS 661
#define PROCESSLIST_SYM 662
#define PROFILE_SYM 663
#define PROFILES_SYM 664
#define PROXY_SYM 665
#define PURGE 666
#define QUARTER_SYM 667
#define QUERY_SYM 668
#define QUICK 669
#define RANGE_SYM 670
#define READS_SYM 671
#define READ_ONLY_SYM 672
#define READ_SYM 673
#define READ_WRITE_SYM 674
#define REAL 675
#define REBUILD_SYM 676
#define RECOVER_SYM 677
#define REDOFILE_SYM 678
#define REDO_BUFFER_SIZE_SYM 679
#define REDUNDANT_SYM 680
#define REFERENCES 681
#define REGEXP 682
#define RELAY 683
#define RELAYLOG_SYM 684
#define RELAY_LOG_FILE_SYM 685
#define RELAY_LOG_POS_SYM 686
#define RELAY_THREAD 687
#define RELEASE_SYM 688
#define RELOAD 689
#define REMOVE_SYM 690
#define RENAME 691
#define REORGANIZE_SYM 692
#define REPAIR 693
#define REPEATABLE_SYM 694
#define REPEAT_SYM 695
#define REPLACE 696
#define REPLICATION 697
#define REQUIRE_SYM 698
#define RESET_SYM 699
#define RESIGNAL_SYM 700
#define RESOURCES 701
#define RESTORE_SYM 702
#define RESTRICT 703
#define RESUME_SYM 704
#define RETURNED_SQLSTATE_SYM 705
#define RETURNS_SYM 706
#define RETURN_SYM 707
#define REVERSE_SYM 708
#define REVOKE 709
#define RIGHT 710
#define ROLLBACK_SYM 711
#define ROLLUP_SYM 712
#define ROUTINE_SYM 713
#define ROWS_SYM 714
#define ROW_FORMAT_SYM 715
#define ROW_SYM 716
#define ROW_COUNT_SYM 717
#define RTREE_SYM 718
#define SAVEPOINT_SYM 719
#define SCHEDULE_SYM 720
#define SCHEMA_NAME_SYM 721
#define SECOND_MICROSECOND_SYM 722
#define SECOND_SYM 723
#define SECURITY_SYM 724
#define SELECT_SYM 725
#define SENSITIVE_SYM 726
#define SEPARATOR_SYM 727
#define SERIALIZABLE_SYM 728
#define SERIAL_SYM 729
#define SESSION_SYM 730
#define SERVER_SYM 731
#define SERVER_OPTIONS 732
#define SET 733
#define SET_VAR 734
#define SHARE_SYM 735
#define SHIFT_LEFT 736
#define SHIFT_RIGHT 737
#define SHOW 738
#define SHUTDOWN 739
#define SIGNAL_SYM 740
#define SIGNED_SYM 741
#define SIMPLE_SYM 742
#define SLAVE 743
#define SLOW 744
#define SMALLINT 745
#define SNAPSHOT_SYM 746
#define SOCKET_SYM 747
#define SONAME_SYM 748
#define SOUNDS_SYM 749
#define SOURCE_SYM 750
#define SPATIAL_SYM 751
#define SPECIFIC_SYM 752
#define SQLEXCEPTION_SYM 753
#define SQLSTATE_SYM 754
#define SQLWARNING_SYM 755
#define SQL_AFTER_GTIDS 756
#define SQL_AFTER_MTS_GAPS 757
#define SQL_BEFORE_GTIDS 758
#define SQL_BIG_RESULT 759
#define SQL_BUFFER_RESULT 760
#define SQL_CACHE_SYM 761
#define SQL_CALC_FOUND_ROWS 762
#define SQL_NO_CACHE_SYM 763
#define SQL_SMALL_RESULT 764
#define SQL_SYM 765
#define SQL_THREAD 766
#define SSL_SYM 767
#define STARTING 768
#define STARTS_SYM 769
#define START_SYM 770
#define STATS_AUTO_RECALC_SYM 771
#define STATS_PERSISTENT_SYM 772
#define STATS_SAMPLE_PAGES_SYM 773
#define STATUS_SYM 774
#define STDDEV_SAMP_SYM 775
#define STD_SYM 776
#define STOP_SYM 777
#define STORAGE_SYM 778
#define STRAIGHT_JOIN 779
#define STRING_SYM 780
#define SUBCLASS_ORIGIN_SYM 781
#define SUBDATE_SYM 782
#define SUBJECT_SYM 783
#define SUBPARTITIONS_SYM 784
#define SUBPARTITION_SYM 785
#define SUBSTRING 786
#define SUM_SYM 787
#define SUPER_SYM 788
#define SUSPEND_SYM 789
#define SWAPS_SYM 790
#define SWITCHES_SYM 791
#define SYSDATE 792
#define TABLES 793
#define TABLESPACE 794
#define TABLE_REF_PRIORITY 795
#define TABLE_SYM 796
#define TABLE_CHECKSUM_SYM 797
#define TABLE_NAME_SYM 798
#define TEMPORARY 799
#define TEMPTABLE_SYM 800
#define TERMINATED 801
#define TEXT_STRING 802
#define TEXT_SYM 803
#define THAN_SYM 804
#define THEN_SYM 805
#define TIMESTAMP 806
#define TIMESTAMP_ADD 807
#define TIMESTAMP_DIFF 808
#define TIME_SYM 809
#define TINYBLOB 810
#define TINYINT 811
#define TINYTEXT 812
#define TO_SYM 813
#define TRAILING 814
#define TRANSACTION_SYM 815
#define TRIGGERS_SYM 816
#define TRIGGER_SYM 817
#define TRIM 818
#define TRUE_SYM 819
#define TRUNCATE_SYM 820
#define TYPES_SYM 821
#define TYPE_SYM 822
#define UDF_RETURNS_SYM 823
#define ULONGLONG_NUM 824
#define UNCOMMITTED_SYM 825
#define UNDEFINED_SYM 826
#define UNDERSCORE_CHARSET 827
#define UNDOFILE_SYM 828
#define UNDO_BUFFER_SIZE_SYM 829
#define UNDO_SYM 830
#define UNICODE_SYM 831
#define UNINSTALL_SYM 832
#define UNION_SYM 833
#define UNIQUE_SYM 834
#define UNKNOWN_SYM 835
#define UNLOCK_SYM 836
#define UNSIGNED 837
#define UNTIL_SYM 838
#define UPDATE_SYM 839
#define UPGRADE_SYM 840
#define USAGE 841
#define USER 842
#define USE_FRM 843
#define USE_SYM 844
#define USING 845
#define UTC_DATE_SYM 846
#define UTC_TIMESTAMP_SYM 847
#define UTC_TIME_SYM 848
#define VALUES 849
#define VALUE_SYM 850
#define VARBINARY 851
#define VARCHAR 852
#define VARIABLES 853
#define VARIANCE_SYM 854
#define VARYING 855
#define VAR_SAMP_SYM 856
#define VIEW_SYM 857
#define WAIT_SYM 858
#define WARNINGS 859
#define WEEK_SYM 860
#define WEIGHT_STRING_SYM 861
#define WHEN_SYM 862
#define WHERE 863
#define WHILE_SYM 864
#define WITH 865
#define WITH_CUBE_SYM 866
#define WITH_ROLLUP_SYM 867
#define WORK_SYM 868
#define WRAPPER_SYM 869
#define WRITE_SYM 870
#define X509_SYM 871
#define XA_SYM 872
#define XML_SYM 873
#define XOR 874
#define YEAR_MONTH_SYM 875
#define YEAR_SYM 876
#define ZEROFILL 877

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED

union YYSTYPE
{
#line 975 "/var/lib/pb2/sb_1-6464259-1647856786.57/mysql-cluster-7.4.36-release-export-1734044_gpl/sql/sql_yacc.yy" /* yacc.c:355  */

  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  longlong longlong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  Key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  handlerton *db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_ha_read_modes ha_read_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  const CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  class sp_condition_value *spcondvalue;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  LEX *lex;
  sp_head *sphead;
  struct p_elem_val *p_elem_value;
  enum index_hint_type index_hint;
  enum enum_filetype filetype;
  enum Foreign_key::fk_option m_fk_option;
  enum enum_yes_no_unknown m_yes_no_unk;
  Diag_condition_item_name diag_condition_item_name;
  Diagnostics_information::Which_area diag_area;
  Diagnostics_information *diag_info;
  Statement_information_item *stmt_info_item;
  Statement_information_item::Name stmt_info_item_name;
  List<Statement_information_item> *stmt_info_list;
  Condition_information_item *cond_info_item;
  Condition_information_item::Name cond_info_item_name;
  List<Condition_information_item> *cond_info_list;
  /* #ifndef MCP_WL3749 */
  Alter_info::enum_alter_table_algorithm online_offline;
  /* #endif */
  bool is_not_empty;

#line 2362 "/var/lib/pb2/sb_1-6464259-1647856786.57/dist_GPL/sql/sql_yacc.cc" /* yacc.c:355  */
};

typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif



int MYSQLparse (class THD *YYTHD);

#endif /* !YY_MYSQL_VAR_LIB_PB2_SB_1_6464259_1647856786_57_DIST_GPL_SQL_SQL_YACC_H_INCLUDED  */

/* Copy the second part of user declarations.  */
#line 1036 "/var/lib/pb2/sb_1-6464259-1647856786.57/mysql-cluster-7.4.36-release-export-1734044_gpl/sql/sql_yacc.yy" /* yacc.c:358  */

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);

#line 2381 "/var/lib/pb2/sb_1-6464259-1647856786.57/dist_GPL/sql/sql_yacc.cc" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  593
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   55705

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  642
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  954
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2674
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  4536

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   877

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   635,     2,     2,     2,   629,   624,     2,
     632,   633,   627,   626,   634,   625,   640,   628,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   641,   638,
       2,     2,     2,     2,   639,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   630,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   636,   623,   637,   631,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1989,  1989,  2002,  2001,  2026,  2033,  2035,  2039,  2040,
    2045,  2046,  2047,  2048,  2049,  2050,  2051,  2052,  2053,  2054,
    2055,  2056,  2057,  2058,  2059,  2060,  2061,  2062,  2063,  2064,
    2065,  2066,  2067,  2068,  2069,  2070,  2071,  2072,  2073,  2074,
    2075,  2076,  2077,  2078,  2079,  2080,  2081,  2082,  2083,  2084,
    2085,  2086,  2087,  2088,  2089,  2090,  2091,  2092,  2093,  2094,
    2095,  2096,  2100,  2110,  2111,  2115,  2135,  2142,  2153,  2152,
    2163,  2165,  2169,  2170,  2174,  2187,  2186,  2206,  2205,  2223,
    2224,  2228,  2232,  2236,  2240,  2245,  2249,  2253,  2258,  2271,
    2276,  2280,  2284,  2288,  2292,  2296,  2301,  2305,  2310,  2341,
    2346,  2353,  2356,  2358,  2359,  2363,  2377,  2381,  2397,  2401,
    2414,  2413,  2463,  2474,  2459,  2489,  2500,  2484,  2515,  2526,
    2510,  2536,  2535,  2548,  2547,  2555,  2559,  2563,  2567,  2574,
    2592,  2593,  2597,  2601,  2605,  2609,  2613,  2618,  2622,  2630,
    2629,  2661,  2660,  2667,  2674,  2675,  2681,  2687,  2697,  2703,
    2709,  2711,  2718,  2719,  2723,  2729,  2738,  2739,  2747,  2747,
    2802,  2803,  2804,  2805,  2806,  2807,  2808,  2809,  2810,  2811,
    2812,  2813,  2814,  2819,  2833,  2847,  2866,  2867,  2871,  2872,
    2877,  2879,  2881,  2883,  2885,  2887,  2889,  2895,  2896,  2897,
    2901,  2905,  2913,  2912,  2925,  2927,  2930,  2932,  2936,  2940,
    2947,  2949,  2953,  2954,  2959,  2978,  3008,  3010,  3014,  3015,
    3019,  3048,  3049,  3050,  3051,  3055,  3056,  3060,  3061,  3066,
    3069,  3096,  3095,  3220,  3237,  3236,  3311,  3310,  3383,  3384,
    3389,  3391,  3396,  3419,  3430,  3434,  3456,  3457,  3461,  3465,
    3478,  3484,  3490,  3499,  3514,  3540,  3546,  3547,  3553,  3556,
    3560,  3568,  3588,  3590,  3608,  3614,  3616,  3618,  3620,  3622,
    3624,  3626,  3628,  3630,  3632,  3634,  3636,  3641,  3657,  3673,
    3674,  3679,  3685,  3694,  3700,  3709,  3717,  3746,  3755,  3757,
    3766,  3771,  3777,  3786,  3794,  3796,  3798,  3800,  3802,  3804,
    3806,  3808,  3810,  3812,  3814,  3816,  3818,  3823,  3843,  3867,
    3869,  3868,  3875,  3876,  3877,  3878,  3879,  3880,  3881,  3882,
    3883,  3884,  3885,  3886,  3887,  3892,  3891,  3902,  3902,  3959,
    3958,  4015,  4015,  4037,  4096,  4146,  4171,  4170,  4196,  4219,
    4221,  4222,  4226,  4244,  4265,  4274,  4310,  4265,  4339,  4341,
    4342,  4346,  4347,  4352,  4363,  4351,  4414,  4413,  4427,  4428,
    4432,  4433,  4438,  4447,  4437,  4496,  4505,  4495,  4549,  4562,
    4567,  4566,  4604,  4605,  4610,  4609,  4643,  4643,  4662,  4661,
    4711,  4728,  4737,  4727,  4791,  4800,  4790,  4840,  4842,  4847,
    4849,  4851,  4868,  4873,  4879,  4886,  4887,  4895,  4901,  4910,
    4916,  4922,  4923,  4927,  4927,  4932,  4933,  4934,  4938,  4939,
    4940,  4943,  4945,  4949,  4950,  4951,  4955,  4956,  4957,  4958,
    4959,  4960,  4961,  4962,  4965,  4967,  4971,  4972,  4973,  4977,
    4978,  4979,  4980,  4981,  4984,  4986,  4990,  4991,  4992,  4996,
    4997,  4998,  4999,  5000,  5001,  5002,  5005,  5007,  5011,  5012,
    5013,  5017,  5018,  5019,  5024,  5032,  5040,  5048,  5060,  5072,
    5077,  5082,  5090,  5098,  5106,  5114,  5122,  5130,  5138,  5151,
    5164,  5178,  5183,  5196,  5197,  5248,  5249,  5252,  5267,  5285,
    5290,  5288,  5295,  5297,  5296,  5300,  5299,  5305,  5342,  5343,
    5348,  5347,  5366,  5385,  5384,  5401,  5405,  5413,  5412,  5415,
    5417,  5419,  5421,  5426,  5427,  5433,  5434,  5451,  5452,  5456,
    5457,  5461,  5480,  5490,  5501,  5510,  5511,  5527,  5529,  5528,
    5533,  5531,  5542,  5543,  5547,  5565,  5581,  5582,  5598,  5613,
    5635,  5636,  5641,  5640,  5664,  5680,  5699,  5698,  5713,  5712,
    5729,  5751,  5755,  5784,  5796,  5797,  5802,  5813,  5801,  5838,
    5839,  5843,  5856,  5877,  5890,  5916,  5917,  5922,  5921,  5958,
    5971,  5972,  5976,  5977,  5981,  5983,  5989,  5991,  5993,  5995,
    5997,  5999,  6009,  6024,  6008,  6038,  6039,  6043,  6044,  6048,
    6049,  6053,  6054,  6058,  6059,  6063,  6064,  6068,  6072,  6073,
    6076,  6078,  6082,  6083,  6087,  6088,  6089,  6093,  6098,  6103,
    6108,  6113,  6118,  6123,  6128,  6143,  6149,  6164,  6169,  6184,
    6190,  6208,  6213,  6218,  6223,  6228,  6234,  6233,  6259,  6260,
    6261,  6266,  6271,  6276,  6278,  6280,  6282,  6288,  6296,  6314,
    6331,  6357,  6375,  6376,  6377,  6378,  6379,  6380,  6384,  6385,
    6386,  6390,  6391,  6395,  6396,  6397,  6398,  6403,  6410,  6411,
    6415,  6416,  6420,  6421,  6428,  6433,  6439,  6445,  6451,  6470,
    6476,  6478,  6482,  6486,  6487,  6491,  6496,  6495,  6537,  6538,
    6539,  6540,  6545,  6549,  6554,  6559,  6563,  6568,  6573,  6579,
    6584,  6590,  6594,  6599,  6604,  6622,  6624,  6626,  6642,  6644,
    6649,  6654,  6666,  6671,  6676,  6681,  6683,  6685,  6687,  6689,
    6691,  6693,  6695,  6698,  6697,  6702,  6701,  6705,  6707,  6716,
    6717,  6718,  6724,  6725,  6726,  6727,  6728,  6732,  6736,  6737,
    6741,  6742,  6746,  6747,  6748,  6749,  6750,  6754,  6755,  6756,
    6757,  6758,  6762,  6767,  6769,  6775,  6776,  6778,  6783,  6793,
    6794,  6798,  6799,  6800,  6808,  6809,  6813,  6814,  6818,  6819,
    6820,  6824,  6825,  6826,  6827,  6830,  6831,  6835,  6836,  6840,
    6841,  6845,  6846,  6850,  6851,  6852,  6857,  6858,  6859,  6865,
    6871,  6877,  6883,  6884,  6897,  6903,  6909,  6915,  6920,  6925,
    6934,  6955,  6963,  6964,  6969,  6970,  6974,  6982,  6986,  6987,
    6991,  6992,  6996,  7005,  7009,  7010,  7014,  7022,  7023,  7027,
    7028,  7032,  7033,  7038,  7039,  7043,  7050,  7059,  7064,  7072,
    7073,  7074,  7075,  7076,  7077,  7082,  7090,  7091,  7096,  7095,
    7108,  7109,  7113,  7116,  7117,  7118,  7119,  7123,  7131,  7138,
    7139,  7143,  7153,  7154,  7158,  7159,  7162,  7164,  7168,  7180,
    7181,  7185,  7192,  7205,  7206,  7208,  7210,  7216,  7221,  7227,
    7233,  7240,  7250,  7251,  7252,  7253,  7254,  7258,  7262,  7263,
    7267,  7268,  7272,  7273,  7277,  7278,  7279,  7283,  7284,  7288,
    7292,  7305,  7317,  7318,  7322,  7323,  7327,  7328,  7332,  7333,
    7337,  7338,  7342,  7343,  7347,  7348,  7352,  7353,  7357,  7359,
    7363,  7364,  7368,  7372,  7373,  7386,  7387,  7388,  7392,  7393,
    7397,  7403,  7417,  7418,  7422,  7423,  7427,  7428,  7440,  7436,
    7492,  7491,  7505,  7517,  7516,  7535,  7534,  7553,  7552,  7571,
    7565,  7585,  7584,  7617,  7622,  7627,  7632,  7637,  7644,  7651,
    7656,  7664,  7665,  7666,  7667,  7671,  7672,  7684,  7685,  7689,
    7690,  7693,  7695,  7703,  7711,  7713,  7715,  7716,  7724,  7725,
    7729,  7738,  7736,  7750,  7764,  7763,  7777,  7775,  7789,  7796,
    7807,  7808,  7838,  7841,  7849,  7861,  7868,  7872,  7877,  7876,
    7892,  7894,  7899,  7907,  7906,  7922,  7926,  7925,  7937,  7938,
    7942,  7957,  7958,  7962,  7971,  7975,  7980,  7986,  7985,  7996,
    8005,  7995,  8040,  8049,  8058,  8067,  8076,  8082,  8088,  8097,
    8106,  8134,  8155,  8165,  8169,  8174,  8175,  8178,  8180,  8181,
    8182,  8183,  8186,  8191,  8202,  8207,  8218,  8219,  8223,  8224,
    8228,  8229,  8230,  8234,  8235,  8240,  8248,  8249,  8250,  8251,
    8256,  8255,  8284,  8294,  8311,  8314,  8321,  8325,  8332,  8336,
    8340,  8347,  8352,  8355,  8362,  8365,  8372,  8375,  8382,  8385,
    8393,  8396,  8403,  8407,  8414,  8418,  8425,  8426,  8451,  8452,
    8453,  8458,  8463,  8471,  8470,  8482,  8483,  8484,  8489,  8488,
    8510,  8511,  8515,  8516,  8520,  8521,  8522,  8527,  8526,  8548,
    8557,  8556,  8583,  8584,  8588,  8589,  8593,  8594,  8595,  8596,
    8597,  8598,  8603,  8602,  8624,  8625,  8626,  8631,  8630,  8636,
    8643,  8648,  8656,  8657,  8661,  8675,  8674,  8687,  8688,  8692,
    8693,  8697,  8707,  8717,  8718,  8723,  8722,  8733,  8734,  8738,
    8739,  8743,  8753,  8764,  8763,  8771,  8771,  8782,  8783,  8788,
    8789,  8798,  8807,  8808,  8812,  8817,  8822,  8827,  8832,  8831,
    8851,  8859,  8851,  8866,  8867,  8868,  8869,  8870,  8874,  8881,
    8888,  8890,  8901,  8902,  8906,  8907,  8935,  8965,  8967,  8976,
    8989,  8990,  8991,  9006,  9013,  9038,  9044,  9050,  9051,  9052,
    9053,  9054,  9058,  9059,  9064,  9115,  9122,  9165,  9171,  9177,
    9183,  9189,  9195,  9201,  9207,  9211,  9217,  9223,  9229,  9235,
    9241,  9245,  9251,  9261,  9267,  9275,  9281,  9291,  9297,  9306,
    9316,  9322,  9332,  9338,  9347,  9351,  9357,  9363,  9369,  9375,
    9381,  9387,  9393,  9399,  9405,  9411,  9417,  9423,  9429,  9435,
    9439,  9440,  9444,  9445,  9449,  9450,  9454,  9455,  9459,  9460,
    9461,  9462,  9463,  9464,  9468,  9469,  9473,  9474,  9475,  9476,
    9477,  9478,  9490,  9491,  9492,  9493,  9494,  9500,  9504,  9510,
    9516,  9522,  9528,  9530,  9537,  9544,  9550,  9591,  9600,  9607,
    9615,  9621,  9628,  9634,  9648,  9655,  9671,  9677,  9683,  9691,
    9697,  9703,  9709,  9715,  9730,  9742,  9748,  9754,  9760,  9766,
    9772,  9778,  9784,  9790,  9796,  9802,  9808,  9814,  9820,  9826,
    9832,  9838,  9846,  9867,  9874,  9880,  9887,  9894,  9901,  9908,
    9914,  9920,  9925,  9931,  9938,  9944,  9950,  9956,  9962,  9968,
    9986,  9992,  9998, 10005, 10012, 10027, 10033, 10039, 10045, 10051,
   10058, 10064, 10070, 10076, 10082, 10088, 10096, 10109, 10115, 10121,
   10127, 10133, 10141, 10147, 10159, 10165, 10171, 10179, 10189, 10195,
   10211, 10217, 10224, 10231, 10238, 10245, 10252, 10256, 10276, 10275,
   10348, 10388, 10390, 10395, 10396, 10400, 10401, 10405, 10406, 10410,
   10417, 10425, 10451, 10457, 10463, 10469, 10475, 10481, 10490, 10497,
   10499, 10496, 10506, 10517, 10523, 10529, 10535, 10541, 10547, 10553,
   10559, 10565, 10572, 10571, 10591, 10590, 10605, 10616, 10624, 10640,
   10641, 10646, 10651, 10654, 10657, 10656, 10673, 10675, 10681, 10680,
   10697, 10699, 10701, 10703, 10705, 10707, 10709, 10711, 10713, 10715,
   10717, 10722, 10723, 10727, 10734, 10742, 10743, 10747, 10754, 10762,
   10763, 10767, 10768, 10772, 10780, 10791, 10792, 10801, 10812, 10813,
   10819, 10820, 10840, 10842, 10846, 10844, 10861, 10859, 10877, 10875,
   10882, 10891, 10889, 10907, 10906, 10916, 10927, 10925, 10944, 10943,
   10954, 10965, 10966, 10967, 10975, 10976, 10980, 10995, 10995, 11010,
   11050, 11123, 11134, 11139, 11131, 11158, 11178, 11186, 11178, 11195,
   11194, 11217, 11234, 11217, 11241, 11245, 11271, 11272, 11277, 11280,
   11281, 11282, 11286, 11287, 11292, 11291, 11297, 11296, 11304, 11305,
   11308, 11310, 11310, 11314, 11314, 11319, 11320, 11324, 11326, 11331,
   11332, 11336, 11347, 11360, 11361, 11362, 11363, 11364, 11365, 11366,
   11367, 11368, 11369, 11370, 11371, 11375, 11376, 11377, 11378, 11379,
   11380, 11381, 11382, 11383, 11387, 11388, 11389, 11390, 11393, 11395,
   11396, 11400, 11401, 11409, 11411, 11415, 11417, 11416, 11430, 11433,
   11432, 11447, 11453, 11468, 11470, 11474, 11476, 11481, 11482, 11502,
   11533, 11537, 11538, 11542, 11555, 11557, 11562, 11561, 11596, 11598,
   11603, 11604, 11605, 11610, 11616, 11620, 11621, 11625, 11632, 11639,
   11646, 11656, 11683, 11687, 11693, 11699, 11709, 11713, 11723, 11724,
   11725, 11726, 11727, 11728, 11732, 11733, 11734, 11735, 11736, 11740,
   11741, 11742, 11743, 11744, 11748, 11749, 11750, 11751, 11755, 11760,
   11761, 11764, 11767, 11766, 11800, 11801, 11805, 11813, 11826, 11826,
   11836, 11837, 11841, 11860, 11900, 11899, 11912, 11920, 11911, 11922,
   11934, 11946, 11945, 11963, 11962, 11974, 11978, 11974, 12003, 12010,
   12031, 12052, 12064, 12069, 12068, 12078, 12084, 12091, 12096, 12101,
   12111, 12112, 12116, 12127, 12140, 12141, 12145, 12156, 12157, 12161,
   12162, 12165, 12167, 12170, 12171, 12172, 12176, 12177, 12185, 12193,
   12184, 12203, 12210, 12202, 12220, 12232, 12233, 12246, 12250, 12251,
   12267, 12268, 12272, 12281, 12282, 12283, 12285, 12284, 12295, 12296,
   12300, 12301, 12303, 12302, 12306, 12305, 12311, 12312, 12316, 12317,
   12321, 12331, 12332, 12336, 12337, 12342, 12341, 12355, 12356, 12360,
   12365, 12373, 12374, 12382, 12384, 12384, 12392, 12400, 12391, 12422,
   12423, 12427, 12435, 12436, 12440, 12450, 12451, 12458, 12457, 12473,
   12472, 12486, 12485, 12497, 12496, 12510, 12511, 12515, 12528, 12544,
   12545, 12549, 12550, 12554, 12555, 12556, 12561, 12560, 12582, 12584,
   12587, 12589, 12592, 12593, 12596, 12600, 12604, 12608, 12612, 12616,
   12620, 12624, 12628, 12636, 12639, 12649, 12648, 12663, 12670, 12678,
   12686, 12694, 12702, 12710, 12717, 12719, 12721, 12730, 12734, 12739,
   12738, 12744, 12743, 12748, 12757, 12764, 12769, 12771, 12773, 12775,
   12777, 12785, 12796, 12804, 12806, 12814, 12821, 12828, 12838, 12845,
   12851, 12860, 12868, 12872, 12876, 12883, 12890, 12896, 12903, 12910,
   12915, 12920, 12928, 12930, 12932, 12937, 12938, 12941, 12943, 12947,
   12948, 12952, 12953, 12957, 12958, 12962, 12963, 12967, 12968, 12971,
   12973, 12980, 12991, 12990, 13006, 13005, 13012, 13013, 13014, 13015,
   13016, 13020, 13021, 13026, 13030, 13036, 13042, 13064, 13065, 13066,
   13081, 13080, 13093, 13102, 13092, 13104, 13108, 13109, 13121, 13120,
   13142, 13143, 13148, 13150, 13152, 13154, 13156, 13158, 13160, 13162,
   13164, 13166, 13168, 13170, 13172, 13177, 13178, 13183, 13182, 13192,
   13193, 13197, 13197, 13199, 13200, 13204, 13205, 13210, 13209, 13220,
   13224, 13228, 13240, 13250, 13251, 13252, 13258, 13270, 13282, 13292,
   13302, 13269, 13310, 13311, 13315, 13316, 13320, 13321, 13333, 13337,
   13338, 13339, 13342, 13344, 13348, 13349, 13353, 13358, 13365, 13370,
   13377, 13379, 13383, 13384, 13388, 13393, 13401, 13402, 13405, 13407,
   13415, 13417, 13421, 13422, 13423, 13427, 13429, 13434, 13435, 13444,
   13445, 13449, 13450, 13454, 13474, 13498, 13510, 13521, 13540, 13548,
   13560, 13575, 13596, 13597, 13598, 13607, 13608, 13609, 13610, 13625,
   13631, 13637, 13643, 13649, 13680, 13713, 13723, 13733, 13739, 13748,
   13760, 13766, 13772, 13788, 13789, 13793, 13802, 13818, 13822, 13873,
   13877, 13895, 13899, 13979, 14004, 14035, 14036, 14052, 14062, 14066,
   14072, 14078, 14088, 14094, 14103, 14113, 14114, 14144, 14157, 14173,
   14189, 14206, 14207, 14218, 14219, 14230, 14231, 14232, 14236, 14263,
   14296, 14311, 14312, 14313, 14314, 14315, 14316, 14317, 14318, 14319,
   14320, 14321, 14322, 14323, 14324, 14325, 14326, 14327, 14328, 14329,
   14330, 14331, 14332, 14333, 14334, 14335, 14336, 14337, 14338, 14339,
   14340, 14341, 14342, 14343, 14344, 14345, 14346, 14347, 14348, 14349,
   14350, 14351, 14352, 14353, 14354, 14355, 14356, 14357, 14358, 14359,
   14360, 14370, 14371, 14372, 14373, 14374, 14375, 14376, 14377, 14378,
   14379, 14380, 14381, 14382, 14383, 14384, 14385, 14386, 14387, 14388,
   14389, 14390, 14391, 14392, 14393, 14394, 14395, 14396, 14397, 14398,
   14399, 14400, 14401, 14402, 14403, 14404, 14405, 14406, 14407, 14408,
   14409, 14410, 14411, 14412, 14413, 14414, 14419, 14420, 14421, 14422,
   14423, 14424, 14425, 14426, 14427, 14428, 14429, 14430, 14431, 14432,
   14433, 14434, 14435, 14436, 14437, 14438, 14439, 14440, 14441, 14442,
   14443, 14444, 14445, 14446, 14447, 14448, 14449, 14450, 14451, 14452,
   14453, 14454, 14455, 14456, 14457, 14458, 14459, 14460, 14461, 14462,
   14463, 14464, 14465, 14466, 14467, 14468, 14469, 14470, 14471, 14472,
   14473, 14474, 14475, 14476, 14477, 14478, 14479, 14480, 14481, 14482,
   14483, 14484, 14485, 14486, 14487, 14488, 14489, 14490, 14491, 14492,
   14493, 14494, 14495, 14496, 14497, 14498, 14499, 14500, 14501, 14502,
   14503, 14504, 14505, 14506, 14507, 14508, 14509, 14510, 14511, 14512,
   14513, 14514, 14515, 14516, 14517, 14518, 14519, 14520, 14521, 14522,
   14523, 14524, 14525, 14526, 14527, 14528, 14529, 14530, 14531, 14532,
   14533, 14534, 14535, 14536, 14537, 14538, 14539, 14540, 14541, 14542,
   14543, 14544, 14545, 14546, 14547, 14548, 14549, 14550, 14551, 14552,
   14553, 14554, 14555, 14556, 14557, 14558, 14559, 14560, 14561, 14562,
   14563, 14564, 14565, 14566, 14567, 14568, 14569, 14570, 14571, 14572,
   14573, 14574, 14575, 14576, 14577, 14578, 14579, 14580, 14581, 14582,
   14583, 14584, 14585, 14586, 14587, 14588, 14589, 14590, 14591, 14592,
   14593, 14594, 14595, 14596, 14597, 14598, 14599, 14600, 14601, 14602,
   14603, 14604, 14605, 14606, 14607, 14608, 14609, 14610, 14611, 14612,
   14613, 14614, 14615, 14616, 14617, 14618, 14619, 14620, 14621, 14622,
   14623, 14624, 14625, 14626, 14627, 14628, 14629, 14630, 14631, 14632,
   14633, 14634, 14635, 14636, 14637, 14638, 14639, 14640, 14641, 14642,
   14643, 14644, 14645, 14646, 14647, 14648, 14649, 14650, 14651, 14652,
   14653, 14654, 14655, 14656, 14657, 14658, 14659, 14660, 14661, 14662,
   14663, 14664, 14665, 14666, 14667, 14668, 14669, 14670, 14671, 14672,
   14673, 14674, 14686, 14685, 14705, 14704, 14711, 14710, 14720, 14719,
   14730, 14729, 14735, 14743, 14745, 14750, 14750, 14759, 14758, 14772,
   14771, 14776, 14780, 14781, 14782, 14786, 14787, 14788, 14789, 14793,
   14794, 14795, 14796, 14801, 14827, 14826, 14926, 14938, 14937, 14958,
   14974, 14987, 15009, 15045, 15087, 15115, 15161, 15175, 15176, 15177,
   15178, 15182, 15200, 15218, 15219, 15223, 15224, 15225, 15226, 15230,
   15231, 15249, 15263, 15264, 15265, 15271, 15277, 15289, 15288, 15304,
   15305, 15309, 15310, 15314, 15327, 15328, 15329, 15334, 15339, 15338,
   15358, 15374, 15391, 15390, 15429, 15430, 15434, 15435, 15439, 15440,
   15441, 15442, 15444, 15443, 15457, 15458, 15459, 15460, 15461, 15467,
   15467, 15472, 15477, 15487, 15497, 15501, 15510, 15510, 15515, 15521,
   15532, 15543, 15551, 15553, 15557, 15564, 15571, 15573, 15577, 15578,
   15583, 15582, 15586, 15585, 15589, 15588, 15592, 15591, 15594, 15595,
   15596, 15597, 15598, 15599, 15600, 15601, 15602, 15603, 15604, 15605,
   15606, 15607, 15608, 15609, 15610, 15611, 15612, 15613, 15614, 15615,
   15616, 15617, 15618, 15619, 15623, 15624, 15628, 15629, 15633, 15643,
   15653, 15666, 15681, 15694, 15707, 15719, 15724, 15732, 15737, 15745,
   15763, 15783, 15795, 15808, 15817, 15821, 15825, 15826, 15830, 15857,
   15859, 15863, 15867, 15871, 15878, 15879, 15883, 15884, 15888, 15889,
   15893, 15894, 15900, 15906, 15912, 15922, 15921, 15931, 15932, 15937,
   15938, 15939, 15944, 15945, 15946, 15950, 15951, 15955, 15967, 15976,
   15986, 15995, 16009, 16010, 16015, 16014, 16030, 16031, 16032, 16036,
   16037, 16041, 16041, 16065, 16066, 16070, 16071, 16072, 16076, 16080,
   16087, 16090, 16088, 16104, 16111, 16132, 16158, 16160, 16164, 16165,
   16169, 16170, 16178, 16179, 16180, 16181, 16187, 16193, 16203, 16205,
   16207, 16212, 16213, 16214, 16215, 16216, 16220, 16221, 16222, 16223,
   16224, 16225, 16235, 16236, 16241, 16254, 16267, 16269, 16271, 16276,
   16281, 16283, 16285, 16291, 16292, 16294, 16300, 16299, 16317, 16318,
   16322, 16327, 16335, 16335, 16361, 16360, 16377, 16381, 16386, 16391,
   16390, 16402, 16403, 16405, 16407, 16425, 16431, 16436, 16418, 16499,
   16517, 16542, 16574, 16579, 16587, 16610, 16538, 16676, 16696, 16709,
   16719, 16675, 16740, 16744, 16748, 16752, 16756, 16760, 16767, 16774,
   16781, 16791, 16792, 16796, 16797, 16798, 16802, 16803, 16808, 16810,
   16809, 16815, 16816, 16820, 16830
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT_SYM", "ACCESSIBLE_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYSE_SYM", "ANALYZE_SYM",
  "AND_AND_SYM", "AND_SYM", "ANY_SYM", "AS", "ASC", "ASCII_SYM",
  "ASENSITIVE_SYM", "AT_SYM", "AUTOEXTEND_SIZE_SYM", "AUTO_INC",
  "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM", "BEGIN_SYM",
  "BETWEEN_SYM", "BIGINT", "BINARY", "BINLOG_SYM", "BIN_NUM", "BIT_AND",
  "BIT_OR", "BIT_SYM", "BIT_XOR", "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM",
  "BOOL_SYM", "BOTH", "BTREE_SYM", "BY", "BYTE_SYM", "CACHE_SYM",
  "CALL_SYM", "CASCADE", "CASCADED", "CASE_SYM", "CAST_SYM",
  "CATALOG_NAME_SYM", "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET",
  "CHAR_SYM", "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM",
  "CLASS_ORIGIN_SYM", "CLIENT_SYM", "CLOSE_SYM", "COALESCE", "CODE_SYM",
  "COLLATE_SYM", "COLLATION_SYM", "COLUMNS", "COLUMN_SYM",
  "COLUMN_FORMAT_SYM", "COLUMN_NAME_SYM", "COMMENT_SYM", "COMMITTED_SYM",
  "COMMIT_SYM", "COMPACT_SYM", "COMPLETION_SYM", "COMPRESSED_SYM",
  "CONCURRENT", "CONDITION_SYM", "CONNECTION_SYM", "CONSISTENT_SYM",
  "CONSTRAINT", "CONSTRAINT_CATALOG_SYM", "CONSTRAINT_NAME_SYM",
  "CONSTRAINT_SCHEMA_SYM", "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM",
  "CONVERT_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_SYM", "CURRENT_USER", "CURSOR_SYM",
  "CURSOR_NAME_SYM", "CURTIME", "DATABASE", "DATABASES", "DATAFILE_SYM",
  "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL", "DATE_SUB_INTERVAL",
  "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM", "DAY_MINUTE_SYM",
  "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM", "DECIMAL_NUM",
  "DECIMAL_SYM", "DECLARE_SYM", "DEFAULT", "DEFAULT_AUTH_SYM",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_KEY_FILE", "DETERMINISTIC_SYM",
  "DIAGNOSTICS_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD", "DISK_SYM",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSE",
  "ELSEIF_SYM", "ENABLE_SYM", "ENCLOSED", "END", "ENDS_SYM",
  "END_OF_INPUT", "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM",
  "ERROR_SYM", "ERRORS", "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM",
  "EVENT_SYM", "EVERY_SYM", "EXCHANGE_SYM", "EXECUTE_SYM", "EXISTS",
  "EXIT_SYM", "EXPANSION_SYM", "EXPIRE_SYM", "EXPORT_SYM", "EXTENDED_SYM",
  "EXTENT_SIZE_SYM", "EXTRACT_SYM", "FALSE_SYM", "FAST_SYM", "FAULTS_SYM",
  "FETCH_SYM", "FILE_SYM", "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM",
  "FLOAT_SYM", "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FOR_SYM",
  "FORMAT_SYM", "FOUND_SYM", "FROM", "FULL", "FULLTEXT_SYM",
  "FUNCTION_SYM", "GE", "GENERAL", "GEOMETRYCOLLECTION", "GEOMETRY_SYM",
  "GET_FORMAT", "GET_SYM", "GLOBAL_SYM", "GRANT", "GRANTS", "GROUP_SYM",
  "GROUP_CONCAT_SYM", "GT_SYM", "HANDLER_SYM", "HASH_SYM", "HAVING",
  "HELP_SYM", "HEX_NUM", "HIGH_PRIORITY", "HOST_SYM", "HOSTS_SYM",
  "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM", "HOUR_SECOND_SYM", "HOUR_SYM",
  "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED", "IF", "IGNORE_SYM",
  "IGNORE_SERVER_IDS_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE",
  "INITIAL_SIZE_SYM", "INNER_SYM", "INOUT_SYM", "INSENSITIVE_SYM",
  "INSERT", "INSERT_METHOD", "INSTALL_SYM", "INTERVAL_SYM", "INTO",
  "INT_SYM", "INVOKER_SYM", "IN_SYM", "IO_AFTER_GTIDS", "IO_BEFORE_GTIDS",
  "IO_SYM", "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM", "ITERATE_SYM",
  "JOIN_SYM", "KEYS", "KEY_BLOCK_SIZE", "KEY_SYM", "KILL_SYM",
  "LANGUAGE_SYM", "LAST_SYM", "LE", "LEADING", "LEAVES", "LEAVE_SYM",
  "LEFT", "LESS_SYM", "LEVEL_SYM", "LEX_HOSTNAME", "LIKE", "LIMIT",
  "LINEAR_SYM", "LINES", "LINESTRING", "LIST_SYM", "LOAD", "LOCAL_SYM",
  "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM", "LOGFILE_SYM", "LOGS_SYM",
  "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM",
  "LOW_PRIORITY", "LT", "MASTER_AUTO_POSITION_SYM", "MASTER_BIND_SYM",
  "MASTER_CONNECT_RETRY_SYM", "MASTER_DELAY_SYM", "MASTER_HOST_SYM",
  "MASTER_LOG_FILE_SYM", "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM",
  "MASTER_PORT_SYM", "MASTER_RETRY_COUNT_SYM", "MASTER_SERVER_ID_SYM",
  "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM",
  "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_CRL_SYM", "MASTER_SSL_CRLPATH_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM",
  "MASTER_SSL_VERIFY_SERVER_CERT_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MASTER_HEARTBEAT_PERIOD_SYM", "MATCH", "MAX_CONNECTIONS_PER_HOUR",
  "MAX_QUERIES_PER_HOUR", "MAX_ROWS", "MAX_SIZE_SYM", "MAX_SYM",
  "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS_SYM", "MAX_VALUE_SYM",
  "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM",
  "MERGE_SYM", "MESSAGE_TEXT_SYM", "MICROSECOND_SYM", "MIGRATE_SYM",
  "MINUTE_MICROSECOND_SYM", "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS",
  "MIN_SYM", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MULTILINESTRING", "MULTIPOINT", "MULTIPOLYGON",
  "MUTEX_SYM", "MYSQL_ERRNO_SYM", "NAMES_SYM", "NAME_SYM", "NATIONAL_SYM",
  "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM", "NE", "NEG",
  "NEW_SYM", "NEXT_SYM", "NODEGROUP_SYM", "NONE_SYM", "NOT2_SYM",
  "NOT_SYM", "NOW_SYM", "NO_SYM", "NO_WAIT_SYM", "NO_WRITE_TO_BINLOG",
  "NULL_SYM", "NUM", "NUMBER_SYM", "NUMERIC_SYM", "NVARCHAR_SYM",
  "OFFLINE_SYM", "OFFSET_SYM", "OLD_PASSWORD", "ON", "ONE_SYM",
  "ONLINE_SYM", "ONLY_SYM", "OPEN_SYM", "OPTIMIZE", "OPTIONS_SYM",
  "OPTION", "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM",
  "OUTER", "OUTFILE", "OUT_SYM", "OWNER_SYM", "PACK_KEYS_SYM", "PAGE_SYM",
  "PARAM_MARKER", "PARSER_SYM", "PARTIAL", "PARTITION_SYM",
  "PARTITIONS_SYM", "PARTITIONING_SYM", "PASSWORD", "PHASE_SYM",
  "PLUGIN_DIR_SYM", "PLUGIN_SYM", "PLUGINS_SYM", "POINT_SYM", "POLYGON",
  "PORT_SYM", "POSITION_SYM", "PRECISION", "PREPARE_SYM", "PRESERVE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE_SYM", "PROCESS",
  "PROCESSLIST_SYM", "PROFILE_SYM", "PROFILES_SYM", "PROXY_SYM", "PURGE",
  "QUARTER_SYM", "QUERY_SYM", "QUICK", "RANGE_SYM", "READS_SYM",
  "READ_ONLY_SYM", "READ_SYM", "READ_WRITE_SYM", "REAL", "REBUILD_SYM",
  "RECOVER_SYM", "REDOFILE_SYM", "REDO_BUFFER_SIZE_SYM", "REDUNDANT_SYM",
  "REFERENCES", "REGEXP", "RELAY", "RELAYLOG_SYM", "RELAY_LOG_FILE_SYM",
  "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM", "RELOAD",
  "REMOVE_SYM", "RENAME", "REORGANIZE_SYM", "REPAIR", "REPEATABLE_SYM",
  "REPEAT_SYM", "REPLACE", "REPLICATION", "REQUIRE_SYM", "RESET_SYM",
  "RESIGNAL_SYM", "RESOURCES", "RESTORE_SYM", "RESTRICT", "RESUME_SYM",
  "RETURNED_SQLSTATE_SYM", "RETURNS_SYM", "RETURN_SYM", "REVERSE_SYM",
  "REVOKE", "RIGHT", "ROLLBACK_SYM", "ROLLUP_SYM", "ROUTINE_SYM",
  "ROWS_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "ROW_COUNT_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SCHEDULE_SYM", "SCHEMA_NAME_SYM",
  "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM", "SELECT_SYM",
  "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM", "SERIAL_SYM",
  "SESSION_SYM", "SERVER_SYM", "SERVER_OPTIONS", "SET", "SET_VAR",
  "SHARE_SYM", "SHIFT_LEFT", "SHIFT_RIGHT", "SHOW", "SHUTDOWN",
  "SIGNAL_SYM", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE", "SLOW", "SMALLINT",
  "SNAPSHOT_SYM", "SOCKET_SYM", "SONAME_SYM", "SOUNDS_SYM", "SOURCE_SYM",
  "SPATIAL_SYM", "SPECIFIC_SYM", "SQLEXCEPTION_SYM", "SQLSTATE_SYM",
  "SQLWARNING_SYM", "SQL_AFTER_GTIDS", "SQL_AFTER_MTS_GAPS",
  "SQL_BEFORE_GTIDS", "SQL_BIG_RESULT", "SQL_BUFFER_RESULT",
  "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM",
  "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD", "SSL_SYM", "STARTING",
  "STARTS_SYM", "START_SYM", "STATS_AUTO_RECALC_SYM",
  "STATS_PERSISTENT_SYM", "STATS_SAMPLE_PAGES_SYM", "STATUS_SYM",
  "STDDEV_SAMP_SYM", "STD_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBCLASS_ORIGIN_SYM", "SUBDATE_SYM", "SUBJECT_SYM",
  "SUBPARTITIONS_SYM", "SUBPARTITION_SYM", "SUBSTRING", "SUM_SYM",
  "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM", "SWITCHES_SYM", "SYSDATE",
  "TABLES", "TABLESPACE", "TABLE_REF_PRIORITY", "TABLE_SYM",
  "TABLE_CHECKSUM_SYM", "TABLE_NAME_SYM", "TEMPORARY", "TEMPTABLE_SYM",
  "TERMINATED", "TEXT_STRING", "TEXT_SYM", "THAN_SYM", "THEN_SYM",
  "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB",
  "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING", "TRANSACTION_SYM",
  "TRIGGERS_SYM", "TRIGGER_SYM", "TRIM", "TRUE_SYM", "TRUNCATE_SYM",
  "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM", "ULONGLONG_NUM",
  "UNCOMMITTED_SYM", "UNDEFINED_SYM", "UNDERSCORE_CHARSET", "UNDOFILE_SYM",
  "UNDO_BUFFER_SIZE_SYM", "UNDO_SYM", "UNICODE_SYM", "UNINSTALL_SYM",
  "UNION_SYM", "UNIQUE_SYM", "UNKNOWN_SYM", "UNLOCK_SYM", "UNSIGNED",
  "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM", "USAGE", "USER", "USE_FRM",
  "USE_SYM", "USING", "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM",
  "VALUES", "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES",
  "VARIANCE_SYM", "VARYING", "VAR_SAMP_SYM", "VIEW_SYM", "WAIT_SYM",
  "WARNINGS", "WEEK_SYM", "WEIGHT_STRING_SYM", "WHEN_SYM", "WHERE",
  "WHILE_SYM", "WITH", "WITH_CUBE_SYM", "WITH_ROLLUP_SYM", "WORK_SYM",
  "WRAPPER_SYM", "WRITE_SYM", "X509_SYM", "XA_SYM", "XML_SYM", "XOR",
  "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL", "'|'", "'&'", "'-'", "'+'",
  "'*'", "'/'", "'%'", "'^'", "'~'", "'('", "')'", "','", "'!'", "'{'",
  "'}'", "';'", "'@'", "'.'", "':'", "$accept", "query", "$@1",
  "opt_end_of_input", "verb_clause", "statement", "deallocate",
  "deallocate_or_drop", "prepare", "prepare_src", "execute", "$@2",
  "execute_using", "execute_var_list", "execute_var_ident", "help", "$@3",
  "change", "$@4", "master_defs", "master_def", "ignore_server_id_list",
  "ignore_server_id", "master_file_def", "create", "$@5", "$@6", "$@7",
  "$@8", "$@9", "$@10", "$@11", "$@12", "$@13", "server_def",
  "server_options_list", "server_option", "event_tail", "$@14",
  "ev_schedule_time", "$@15", "opt_ev_status", "ev_starts", "ev_ends",
  "opt_ev_on_completion", "ev_on_completion", "opt_ev_comment",
  "ev_sql_stmt", "$@16", "ev_sql_stmt_inner", "clear_privileges",
  "sp_name", "sp_a_chistics", "sp_c_chistics", "sp_chistic",
  "sp_c_chistic", "sp_suid", "call", "$@17", "opt_sp_cparam_list",
  "opt_sp_cparams", "sp_cparams", "sp_fdparam_list", "sp_fdparams",
  "sp_init_param", "sp_fdparam", "sp_pdparam_list", "sp_pdparams",
  "sp_pdparam", "sp_opt_inout", "sp_proc_stmts", "sp_proc_stmts1",
  "sp_decls", "sp_decl", "$@18", "$@19", "$@20", "sp_handler_type",
  "sp_hcond_list", "sp_hcond_element", "sp_cond", "sqlstate", "opt_value",
  "sp_hcond", "signal_stmt", "signal_value", "opt_signal_value",
  "opt_set_signal_information", "signal_information_item_list",
  "signal_allowed_expr", "signal_condition_information_item_name",
  "resignal_stmt", "get_diagnostics", "which_area",
  "diagnostics_information", "statement_information",
  "statement_information_item", "simple_target_specification",
  "statement_information_item_name", "condition_number",
  "condition_information", "condition_information_item",
  "condition_information_item_name", "sp_decl_idents", "sp_opt_default",
  "$@21", "sp_proc_stmt", "sp_proc_stmt_if", "$@22",
  "sp_proc_stmt_statement", "$@23", "sp_proc_stmt_return", "$@24",
  "sp_proc_stmt_unlabeled", "$@25", "sp_proc_stmt_leave",
  "sp_proc_stmt_iterate", "sp_proc_stmt_open", "sp_proc_stmt_fetch",
  "$@26", "sp_proc_stmt_close", "sp_opt_fetch_noise", "sp_fetch_list",
  "sp_if", "$@27", "$@28", "$@29", "sp_elseifs", "case_stmt_specification",
  "simple_case_stmt", "$@30", "$@31", "searched_case_stmt", "$@32",
  "simple_when_clause_list", "searched_when_clause_list",
  "simple_when_clause", "$@33", "$@34", "searched_when_clause", "$@35",
  "$@36", "else_clause_opt", "sp_labeled_control", "$@37", "sp_opt_label",
  "sp_labeled_block", "$@38", "sp_unlabeled_block", "$@39",
  "sp_block_content", "$@40", "sp_unlabeled_control", "$@41", "$@42",
  "$@43", "$@44", "trg_action_time", "trg_event",
  "change_tablespace_access", "change_tablespace_info", "tablespace_info",
  "opt_logfile_group_name", "alter_tablespace_info", "logfile_group_info",
  "alter_logfile_group_info", "add_log_file", "change_ts_option_list",
  "$@45", "change_ts_options", "change_ts_option",
  "tablespace_option_list", "tablespace_options", "tablespace_option",
  "alter_tablespace_option_list", "alter_tablespace_options",
  "alter_tablespace_option", "logfile_group_option_list",
  "logfile_group_options", "logfile_group_option",
  "alter_logfile_group_option_list", "alter_logfile_group_options",
  "alter_logfile_group_option", "ts_datafile", "lg_undofile",
  "lg_redofile", "tablespace_name", "logfile_group_name", "ts_access_mode",
  "opt_ts_initial_size", "opt_ts_autoextend_size", "opt_ts_max_size",
  "opt_ts_extent_size", "opt_ts_undo_buffer_size",
  "opt_ts_redo_buffer_size", "opt_ts_nodegroup", "opt_ts_comment",
  "opt_ts_engine", "ts_wait", "size_number", "create2", "create2a", "$@46",
  "create3", "$@47", "$@48", "opt_create_partitioning", "opt_partitioning",
  "partitioning", "$@49", "have_partitioning", "partition_entry", "$@50",
  "partition", "part_type_def", "$@51", "opt_linear", "opt_key_algo",
  "part_field_list", "part_field_item_list", "part_field_item",
  "part_column_list", "part_func", "sub_part_func", "opt_num_parts",
  "opt_sub_part", "$@52", "$@53", "sub_part_field_list",
  "sub_part_field_item", "part_func_expr", "opt_num_subparts", "part_defs",
  "part_def_list", "part_definition", "$@54", "part_name",
  "opt_part_values", "$@55", "$@56", "part_func_max", "part_values_in",
  "part_value_list", "part_value_item", "$@57", "$@58",
  "part_value_item_list", "part_value_expr_item", "opt_sub_partition",
  "sub_part_list", "sub_part_definition", "$@59", "sub_name",
  "opt_part_options", "opt_part_option_list", "opt_part_option",
  "create_select", "$@60", "$@61", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "$@62", "default_charset",
  "default_collation", "storage_engines", "known_storage_engines",
  "row_types", "merge_insert_types", "opt_select_from", "udf_type",
  "create_field_list", "field_list", "field_list_item", "column_def",
  "key_def", "opt_check_constraint", "check_constraint", "opt_constraint",
  "constraint", "field_spec", "$@63", "type", "$@64", "$@65",
  "spatial_type", "char", "nchar", "varchar", "nvarchar", "int_type",
  "real_type", "float_options", "precision", "type_datetime_precision",
  "func_datetime_precision", "field_options", "field_opt_list",
  "field_option", "field_length", "opt_field_length", "opt_precision",
  "opt_attribute", "opt_attribute_list", "attribute",
  "type_with_opt_collate", "now", "now_or_signed_literal", "charset",
  "charset_name", "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "ascii", "unicode", "opt_binary", "opt_bin_mod",
  "ws_nweights", "$@66", "ws_level_flag_desc", "ws_level_flag_reverse",
  "ws_level_flags", "ws_level_number", "ws_level_list_item",
  "ws_level_list", "ws_level_range", "ws_level_list_or_range",
  "opt_ws_levels", "opt_primary", "references", "opt_ref_list", "ref_list",
  "opt_match_clause", "opt_on_update_delete", "delete_option",
  "normal_key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique", "fulltext", "spatial",
  "init_key_options", "key_alg", "normal_key_options",
  "fulltext_key_options", "spatial_key_options", "normal_key_opts",
  "spatial_key_opts", "fulltext_key_opts", "key_using_alg", "all_key_opt",
  "normal_key_opt", "spatial_key_opt", "fulltext_key_opt",
  "btree_or_rtree", "key_list", "key_part", "opt_ident", "opt_component",
  "string_list", "alter", "$@67", "$@68", "$@69", "$@70", "$@71", "$@72",
  "$@73", "alter_user_list", "ev_alter_on_schedule_completion",
  "opt_ev_rename_to", "opt_ev_sql_stmt", "ident_or_empty",
  "alter_commands", "$@74", "$@75", "$@76", "opt_online_offline",
  "remove_partitioning", "all_or_alt_part_name_list", "add_partition_rule",
  "$@77", "add_part_extra", "reorg_partition_rule", "$@78",
  "reorg_parts_rule", "$@79", "alt_part_name_list", "alt_part_name_item",
  "alter_list", "add_column", "alter_list_item", "$@80", "$@81", "$@82",
  "opt_index_lock_algorithm", "alter_algorithm_option",
  "alter_lock_option", "opt_column", "opt_ignore", "opt_restrict",
  "opt_place", "opt_to", "slave", "$@83", "start",
  "opt_start_transaction_option_list", "start_transaction_option_list",
  "start_transaction_option", "slave_connection_opts",
  "slave_user_name_opt", "slave_user_pass_opt", "slave_plugin_auth_opt",
  "slave_plugin_dir_opt", "opt_slave_thread_option_list",
  "slave_thread_option_list", "slave_thread_option", "slave_until",
  "slave_until_opts", "checksum", "$@84", "opt_checksum_type", "repair",
  "$@85", "opt_mi_repair_type", "mi_repair_types", "mi_repair_type",
  "analyze", "$@86", "binlog_base64_event", "check", "$@87",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "$@88", "opt_no_write_to_binlog", "rename", "$@89", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "$@90",
  "keycache_list_or_parts", "keycache_list", "assign_to_keycache",
  "assign_to_keycache_parts", "key_cache_name", "preload", "$@91",
  "preload_list_or_parts", "preload_list", "preload_keys",
  "preload_keys_parts", "adm_partition", "$@92", "cache_keys_spec", "$@93",
  "cache_key_list_or_empty", "opt_ignore_leaves", "select", "select_init",
  "select_paren", "select_paren_derived", "select_init2", "$@94",
  "select_part2", "$@95", "$@96", "select_into", "select_from",
  "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_alias", "optional_braces", "expr", "bool_pri",
  "predicate", "bit_expr", "or", "and", "not", "not2", "comp_op",
  "all_or_any", "simple_expr", "function_call_keyword",
  "function_call_nonkeyword", "function_call_conflict",
  "geometry_function", "function_call_generic", "@97", "fulltext_options",
  "opt_natural_language_mode", "opt_query_expansion", "opt_udf_expr_list",
  "udf_expr_list", "udf_expr", "sum_expr", "$@98", "$@99", "$@100",
  "variable", "$@101", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "$@102", "gorder_list",
  "in_sum_expr", "$@103", "cast_type", "opt_expr_list", "expr_list",
  "ident_list_arg", "ident_list", "opt_expr", "opt_else", "when_list",
  "table_ref", "join_table_list", "esc_table_ref", "derived_table_list",
  "join_table", "$@104", "$@105", "$@106", "$@107", "$@108", "$@109",
  "$@110", "normal_join", "opt_use_partition", "use_partition",
  "table_factor", "$@111", "select_derived_union", "$@112", "$@113",
  "select_init2_derived", "select_part2_derived", "$@114", "$@115",
  "select_derived", "$@116", "select_derived2", "$@117", "$@118",
  "get_select_lex", "select_derived_init", "opt_outer",
  "index_hint_clause", "index_hint_type", "index_hint_definition", "$@119",
  "$@120", "index_hints_list", "opt_index_hints_list", "$@121",
  "opt_key_definition", "$@122", "opt_key_usage_list", "key_usage_element",
  "key_usage_list", "using_list", "interval", "interval_time_stamp",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "$@123", "having_clause", "$@124", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "$@125", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "real_ulong_num", "ulonglong_num", "real_ulonglong_num", "dec_num_error",
  "dec_num", "procedure_analyse_clause", "$@126",
  "opt_procedure_analyse_params", "procedure_analyse_param",
  "select_var_list_init", "$@127", "select_var_list", "select_var_ident",
  "into", "$@128", "into_destination", "$@129", "$@130", "do", "$@131",
  "drop", "$@132", "$@133", "$@134", "$@135", "table_list", "table_name",
  "table_name_with_opt_use_partition", "table_alias_ref_list",
  "table_alias_ref", "if_exists", "opt_temporary", "drop_ts_options_list",
  "drop_ts_options", "drop_ts_option", "insert", "$@136", "$@137",
  "replace", "$@138", "$@139", "insert_lock_option", "replace_lock_option",
  "insert2", "insert_table", "insert_field_spec", "$@140", "fields",
  "insert_values", "$@141", "$@142", "values_list", "ident_eq_list",
  "ident_eq_value", "equal", "opt_equal", "no_braces", "$@143",
  "opt_values", "values", "expr_or_default", "opt_insert_update", "$@144",
  "update", "$@145", "$@146", "update_list", "update_elem",
  "insert_update_list", "insert_update_elem", "opt_low_priority", "delete",
  "$@147", "single_multi", "$@148", "$@149", "$@150", "table_wild_list",
  "table_wild_one", "opt_wild", "opt_delete_options", "opt_delete_option",
  "truncate", "$@151", "opt_table_sym", "opt_profile_defs", "profile_defs",
  "profile_def", "opt_profile_args", "show", "$@152", "show_param",
  "$@153", "$@154", "show_engine_param", "master_or_binary", "opt_storage",
  "opt_db", "opt_full", "from_or_in", "binlog_in", "binlog_from",
  "wild_and_where", "describe", "$@155", "$@156", "explanable_command",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "$@157", "flush_options", "$@158", "$@159", "opt_flush_lock",
  "$@160", "flush_options_list", "flush_option", "opt_table_list", "reset",
  "$@161", "reset_options", "reset_option", "$@162", "slave_reset_options",
  "purge", "$@163", "purge_options", "purge_option", "kill", "kill_option",
  "use", "load", "$@164", "$@165", "$@166", "$@167", "data_or_xml",
  "opt_local", "load_data_lock", "opt_duplicate", "opt_field_term",
  "field_term_list", "field_term", "opt_line_term", "line_term_list",
  "line_term", "opt_xml_rows_identified_by", "opt_ignore_lines",
  "lines_or_rows", "opt_field_or_var_spec", "fields_or_vars",
  "field_or_var", "opt_load_data_set_spec", "load_data_set_list",
  "load_data_set_elem", "text_literal", "text_string", "param_marker",
  "signed_literal", "literal", "NUM_literal", "temporal_literal",
  "insert_ident", "table_wild", "order_ident", "simple_ident",
  "simple_ident_nospvar", "simple_ident_q", "field_ident", "table_ident",
  "table_ident_opt_wild", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys_nonewline", "TEXT_STRING_sys", "TEXT_STRING_literal",
  "TEXT_STRING_filesystem", "ident", "label_ident", "ident_or_text",
  "user", "keyword", "keyword_sp", "set", "$@168",
  "start_option_value_list", "$@169", "$@170", "$@171",
  "start_option_value_list_following_option_type", "$@172",
  "option_value_list_continued", "option_value_list", "$@173", "$@174",
  "option_value", "$@175", "option_type", "opt_var_type",
  "opt_var_ident_type", "option_value_following_option_type",
  "option_value_no_option_type", "$@176", "$@177",
  "internal_variable_name", "transaction_characteristics",
  "transaction_access_mode", "isolation_level",
  "transaction_access_mode_types", "isolation_types", "text_or_password",
  "set_expr_or_default", "lock", "$@178", "table_or_tables",
  "table_lock_list", "table_lock", "lock_option", "unlock", "$@179",
  "handler", "$@180", "handler_read_or_scan", "handler_scan_function",
  "handler_rkey_function", "$@181", "handler_rkey_mode", "revoke", "$@182",
  "revoke_command", "grant", "$@183", "grant_command", "opt_table",
  "grant_privileges", "opt_privileges", "object_privilege_list",
  "object_privilege", "$@184", "$@185", "$@186", "$@187", "opt_and",
  "require_list", "require_list_element", "grant_ident", "user_list",
  "grant_list", "grant_user", "opt_column_list", "column_list",
  "column_list_id", "require_clause", "grant_options", "opt_grant_option",
  "grant_option_list", "grant_option", "begin", "$@188", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "$@189",
  "union_opt", "opt_union_order_or_limit", "union_order_or_limit", "$@190",
  "order_or_limit", "union_option", "query_specification",
  "query_expression_body", "$@191", "subselect", "subselect_start",
  "subselect_end", "opt_query_expression_options",
  "query_expression_option_list", "query_expression_option",
  "view_or_trigger_or_sp_or_event", "definer_tail", "no_definer_tail",
  "definer_opt", "no_definer", "definer", "view_replace_or_algorithm",
  "view_replace", "view_algorithm", "view_suid", "view_tail", "$@192",
  "view_list_opt", "view_list", "view_select", "$@193", "view_select_aux",
  "$@194", "create_view_select_paren", "create_view_select", "$@195",
  "view_check_option", "trigger_tail", "$@196", "$@197", "$@198",
  "udf_tail", "sf_tail", "$@199", "$@200", "$@201", "$@202", "$@203",
  "sp_tail", "$@204", "$@205", "$@206", "$@207", "xa", "xid",
  "begin_or_start", "opt_join_or_resume", "opt_one_phase", "opt_suspend",
  "$@208", "opt_migrate", "install", "uninstall", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   124,    38,    45,    43,    42,    47,    37,
      94,   126,    40,    41,    44,    33,   123,   125,    59,    64,
      46,    58
};
# endif

#define YYPACT_NINF -3726

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-3726)))

#define YYTABLE_NINF -2614

#define yytable_value_is_error(Yytable_value) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const int yypact[] =
{
    4323,  2777,    91, -3726,  -140,   822, 47704,   772,  1356,  1356,
     516,  3928, -3726, -3726, -3726, -3726, -3726,  3157, -3726, 47704,
      91,  1049, -3726, 23693, -3726, -3726,   963,   174,   167,  1356,
      91, -3726, 47704, -3726,   966,  1438,    91, -3726, -3726, 41554,
   -3726,   516, 47704, -3726, -3726, -3726, 41554,  -126,   787,   894,
    1050, -3726, -3726, 47704,  2346,   494,  1452,  1335, -3726, -3726,
    1255, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, 24311, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726,  1457, 47704,  1469, 47704,  1458,
   -3726, -3726, 47704, 39709, 47704, -3726,  1445,  1512, -3726, -3726,
    1569, -3726, -3726,  1356,   516, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726,  1065, -3726, -3726,  1185, -3726, -3726, -3726, -3726,
   -3726,  1740,  1559,  1611, 39709, 47704, -3726, -3726,   233, -3726,
    1263, -3726,  1278,   944,   117, 11140,  1622,  1622,  1622,  1682,
    1622,  1622, 47704, -3726,  1622, -3726,  1622,  1606,  1356, -3726,
   -3726, -3726,  1766, -3726, 47704,  1539,   230,   646, 39709,  1583,
   47704, -3726, -3726, 11140, -3726,  1667, -3726, -3726, -3726,  1356,
    1880,  1741,  1082, 47704, -3726, -3726,  1356,  1416,  1273,  1343,
   -3726, -3726,  1483, -3726, -3726,   191, -3726, -3726, -3726,  2319,
   26165,  5927,  1483,   -38,   -98,   -38, -3726, -3726, 47704,  1356,
    1687, -3726, -3726,   179,   179,   179, -3726,   179, -3726,   179,
   -3726,   494,  1354, -3726, -3726,  1362, 47704,   797,  1859,  1087,
   -3726, -3726,  1370,   -34, -3726,  1461, 36634, -3726, 47704, -3726,
   -3726, -3726, -3726,  1671, -3726, -3726, -3726,  2107, -3726, 36634,
   -3726,  1523, 47704,  1560, -3726, -3726, -3726, 23693,  1460, 47704,
   -3726, 23693, 23693,   213,    13,   988, 47704, 47704,  1892, -3726,
    2083, 36634,  1653, -3726,   338,  -109,  1569,  2088, -3726,  1559,
   -3726, -3726, -3726, -3726,  1882,  1889,  1891, -3726, -3726, -3726,
   42169,   117,  1486,  1491,  1507, 15592, -3726,  1511,  1515,  1518,
   11140,  1532,  1545,  1556,  1572,  1581,  1584,  1586,  1592,  1612,
    1612,  1619,  1645,  1674,  1685,  -191,  1720, -3726,  1727,  1730,
    1732, -3726, -3726,  1743,  1746,  1757,  1762, -3726,  1768,  1772,
    1778, 11776,  1781,  1795, -3726, 20594,  1797,  1826,  1837,  1846,
    1858,  1861,  1865,  1871,  1874, -3726, -3726, 11140,  1619, -3726,
   -3726,  1877, -3726,  1890,  1895,  1909,  1928,  1932,  1936,  1941,
    1945,  1950,  1954,  1957,  1963,  1965,  1969,  1973,  1975,  1981,
    1619, -3726,  1085,  1985,  1993,  1171,  1995, -3726,  1998, -3726,
     226,  2000,  1612,  1619,  1619,  2007,  2009,  2023,  2025,  2029,
    2036, 15592, 15592, 15592, 11140, -3726, 47704, -3726, 47704, -3726,
     959,  2923, -3726,  2857, 15592,   857, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726,  1557,  1588, -3726, -3726, -3726, -3726, -3726,
   -3726,  2040,  1497,  2104, 47704, 47704, 47704, 47704, 47704, 39709,
     900, 47704, 36634, -3726, 47704,  1622,  1695,  2909, 29250,  3686,
   -3726,   139, -3726, -3726, 47704, -3726, -3726, -3726, -3726,  1445,
    1761,   959,  2245,   227, 23693, -3726,  1616, -3726,  -196, -3726,
   -3726,  2052, -3726, -3726, 36634, 23693, -3726, -3726, -3726, 21214,
   -3726, -3726,  2289, -3726,  1738, -3726, -3726,  1588,  3559, -3726,
    4266,  2050,    13,  1942, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726,  1806,  2319, -3726, -3726,   513,  2060,
    1912,   718,   818, 34174,  1001,   927,    60, 26782, 34789,  2026,
   -3726, -3726, -3726,   456,  2516, -3726,    55,  2049,   744,    55,
   37249,  2426,   180, -3726,   304, -3726,  2507, -3726, -3726, -3726,
   -3726,  2183,  2159, -3726, -3726,   375,   209, -3726,  2556, -3726,
    1014, -3726,  2187,  2426,    55,   180, -3726,  2446,  2576,   811,
     597, -3726, -3726, -3726, -3726,  2103, -3726,   -93,  2662, -3726,
    2120, -3726, -3726, 23693, -3726, -3726,  1445, -3726, -3726, -3726,
    2128, -3726,  2413,  2247, -3726, -3726,    35, -3726,  2151,   -16,
    2636, -3726, 39709,  1136, 37864, -3726, -3726, -3726,  2673,  2708,
    1612,  2165, -3726, -3726, -3726,  2824, -3726, -3726,  2210,  2745,
    2745,  2745,  2851, -3726, -3726, -3726,  2224,  2483, 23693, -3726,
    2408,  2282, -3726,  1560, 23693,  2648,  2268, -3726, -3726,  2521,
   11140, -3726, -3726,  5087,    48, -3726, -3726,  1219, -3726,  2856,
    2480, -3726, -3726, -3726, -3726,  2751, -3726, -3726,  2824,  2818,
    2745,  2707,  2313, -3726, -3726, -3726, -3726, -3726, -3726,   219,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726,  1596, -3726, -3726,
   -3726, -3726, -3726,  1560, -3726, 23693, 47704, 47704, 47704, 23693,
   -3726,  2325, -3726,  2297, -3726, 11140, 11140,   329,  2885,  2949,
    2949,  2949,   959,  2356, 11140, 11140, 11140, 11140, 11140, 11140,
   11140,   330,  2332, -3726, -3726,   -65, -3726,  2335, 11140, 11140,
   -3726, 11140, 11140, 24929, -3726,  3477, 11140, 11140,  1209,  2831,
   11140, 11140, 11140, 11140,  3813, 11140, 11140, 24929,  2963,  2344,
   -3726,  2342,   342, 11140, 11140,  1433, 11140, 11140, 11140, 11140,
   11140, -3726, -3726, 11140, 11140, 11140, 11140, 15592, 11140, 11140,
   11140, 11140, 11140, 11140,  2352, 11140,  2949,  2949, 11140, 11140,
    1462, -3726, -3726, 11140,  2251,  2251, -3726, 11140,  7960, 11140,
   -3726, -3726, -3726,  2357, -3726, -3726, -3726, 24929,  2949,  2949,
   11140, 11140, 11140,  2885,  2885,  2885,   222,  2361,   664, 11140,
   27399,  2355, -3726, -3726, -3726, -3726, 11140, 11140, 11140, -3726,
   15592, -3726, -3726,  1133, -3726, -3726, -3726, 12412, 15592, 15592,
    2364, 15592, 15592, 15592, 15592, 15592,  2735, 15592, 15592, 16228,
   16864, 15592, 15592, 15592, 15592,  1388,  2885, 39709, 15592, 11140,
   -3726, -3726, 47704, -3726, -3726, -3726,  2359,   900, -3726, -3726,
   -3726, -3726, -3726, -3726,  2367,   900, -3726,  2850, -3726, -3726,
    2370, 23693,  2643, -3726,  2372, -3726,  2738, -3726,  2739,  2741,
    2742, -3726, -3726, -3726,  2969,  2746, -3726,  2750, -3726, -3726,
    2393, -3726, -3726, 17500, 39709, -3726,  2398, -3726,  2878, -3726,
    2630,  2581,  1661, -3726, -3726, -3726, -3726, -3726,  2669, -3726,
   -3726,  2504, -3726,  2678, -3726, -3726,   419, -3726,   118, -3726,
   -3726, -3726, -3726, -3726, -3726,  2680,  2417, -3726, -3726, -3726,
   47704, -3726, 48319, -3726, 21214,  -140, -3726, -3726, -3726,  2785,
     268,  2423, -3726, 23693, -3726,   120,   120,  2670,   974, 39709,
   -3726, -3726,   164,  2427,  2505,  2431, -3726,  2509, 23693, 23693,
   -3726, -3726, -3726,  2685, -3726,  3064,  1273, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
    2447,  2925,  2630,  2718, -3726,  2729, -3726, 47704, -3726,  1503,
   -3726, -3726, -3726,  2462, -3726, 11140, -3726, -3726, 47704, -3726,
   -3726, -3726, -3726, -3726,  3030, 11140, -3726, 36634,   -33,    74,
      80,   456, -3726, -3726, -3726, -3726, -3726, 47704, 42784,  2466,
   -3726,  2864,  -140, 11140, -3726,  2477,  1559, 47704, 47704, 47704,
   23693, 47704, 23693, -3726,  1130,  1130, -3726, 35404, -3726, -3726,
   -3726, -3726,    55, 47704, 47704,    55, 36634, -3726,   180, 47704,
      55, -3726,  2866,  2569, -3726, -3726, -3726,  2947, -3726, -3726,
    2938,  2491, -3726,  2864, -3726, -3726,   180, -3726, -3726, 23693,
   -3726, -3726,   180, -3726,   180,   180,    55,    55,  2548,   -38,
   -3726, -3726,  2642,   -98, -3726,  1041,   179,  2743, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,   757, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726,   108, -3726, -3726, -3726,  2073,  3005, -3726, 39709,
    2546,   617,   916,  2546,  1638,  -140,  2005, -3726,  2005, -3726,
   36634,  2971, -3726,  2776,   215, 23693, -3726,  2508, 43399, 23693,
   -3726, -3726, -3726,   177,  2514,  2517,   959,  2993,  2997,  3009,
    3013,  3015,  3016,  3017,  3018,  3021,  3024,  3025,  3026,  3029,
    3034,  3035,  3036,  3037,  3038,  3040,  3042,  3043,  3045,  3046,
    3050,  2525, -3726, -3726, -3726, -3726, 23693, -3726, -3726, -3726,
   -3726,  2575, -3726, -3726, -3726, -3726,  2333, -3726, -3726, -3726,
     116,  2075,  2592,  2621,   131, 36634,  3019, 47704, 47704,  1559,
   47704, 47704, -3726, -3726, -3726, -3726, -3726,  2573, -3726,  2685,
   -3726,  -173, 47704,  3028, 31099, -3726,   404,   347, -3726,  2949,
    2580, -3726,  2582,  2585,  2589, 11140,   223,   363,   368,  1404,
     740,   465,   535,   267, -3726,  2590,  2598, -3726,  2594, -3726,
   -3726,   542,   544,  1034,  1213,  2595,  2596, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726,  3041, -3726,   581,
    1424, -3726, -3726, -3726, -3726,  2599, -3726, -3726,  1224,   829,
     836,   232,  2608,   842,  1447,  1540,  2603, 24929, 47704,  2949,
    2605,  1228,  1236,  2949,  2606,   858,  1241,  1568,  1589,  1602,
    1253,  1257,   860,  1699,  2463,  1262,   862,   874,  1274,   882,
     886, -3726,  1284,  2613,  2619,   907,   307,  2949,  2622,   298,
    2602,  2620,  1295,  9232,  9868, 10504,   328,   940, -3726,  2623,
   -3726,  2342,  2624,  2628,   438,   152,  1310, -3726, 11140, -3726,
   -3726,   898,   897,  2686,   217,    80, -3726,  2784, 47704,  2034,
     185, -3726, -3726, -3726, -3726, -3726, -3726,   795, -3726,  2633,
   -3726,  2637,  2192,  2646, 11140,  1492,  2646,  3276,  2180,  2180,
   15592,  3479,  2704, 11776,  1107, 11776,  1107,  2646,  2646,  2646,
   -3726, 15592,  2649, 15592, 15592, -3726,  2885,   959,  2634,   912,
   47704,  2367,   -63, -3726,   456, 36634,   132, 23693, 23693, 39709,
    2653, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,  4081,
   23693,  2733,  2736,  2744, -3726, 29867, -3726, -3726, -3726, -3726,
   29867,   -23, -3726, -3726, -3726, -3726, -3726,  2752, -3726, -3726,
   -3726,  2661, -3726, 36634,  2661, -3726, -3726,  2661, -3726, -3726,
    2661,    86,  4651, -3726,  1162,  1280,  3389,  2689, -3726, -3726,
   -3726, 23693, -3726,  3068,   831, 23693,  2508,  2666, -3726, -3726,
   -3726, -3726, -3726,  2437,  2769, -3726,  3290, -3726, 11140,  -140,
   -3726, 36634, 36634, 23693, 23693,   965, -3726,  1972,  2671, -3726,
   -3726, -3726, -3726, -3726,  3559, 17500,  2668, 36634,   910, -3726,
   -3726, -3726, -3726, -3726,  1351,   959, -3726,  2681, -3726, 38479,
   -3726,   959,   456,  2676,  2677, -3726, -3726,  3065,   592, -3726,
    2693,  2702, -3726,  2706,  2710,  2714, 44014, 11140, -3726,    74,
   -3726, -3726,   456, -3726, -3726,  8596,  -140,  3121, -3726,   959,
    2709, 47704, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726,   794, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726,    55, -3726, -3726, -3726, -3726,
   -3726,  2934,  2426,   209,  3121,    55,   180, 23693,    55,    55,
   -3726, -3726,  2772,  2761, -3726, -3726, -3726, -3726, -3726, 47704,
    2688,  2880, -3726,  2722, -3726, -3726, 23693, -3726,  2725, -3726,
    3175,  3316,  2426, -3726, -3726, -3726,   456,   456,  3032, -3726,
    -140,  2853,  2855,  2858,  2862,  2867,  2907, -3726, -3726,  -140,
    -140, -3726, -3726,   456, -3726,  1838, -3726, -3726, -3726, -3726,
    -140,  -140,  -140,  -140,  2748,  -140,  -140,  1701, -3726, -3726,
     456,   456, -3726,   277, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726,  1115, -3726,  2988, -3726,  2410,   153, -3726,  2944, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726,  2749, -3726, -3726, 11140,  2753,  2748,  -140,  2748,  2748,
    -140,  -140,  1906,  -140,  2748,  2748,  -140,  -140,  -140,  -140,
    -140,  -140,  -140,  2748,  2748,  -140,  2381,  -140,  2748,  5087,
   -3726, -3726, -3726, -3726,   123,   456,   456,   456,   456, -3726,
    2028, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, 39709,
    3111,  2062,  1230, 39709, -3726, 47704, -3726,  1815, 47704,  2754,
    -139,  3315,  1320,  3022,  3027,  3031, 47704,  2800, -3726, 31099,
   -3726, -3726,  1041, -3726,  2755, 13048, -3726,  2760, -3726, 11140,
   -3726, -3726, -3726,   433, 11140, 11140,  3245,  2058, -3726, 39094,
   -3726, -3726, -3726, 11140, 39094,  2058, 11140, -3726,  2771, -3726,
    3168,  3171, -3726, -3726, -3726, -3726, 11140, 11140, -3726, 11140,
   11140, -3726, 11140, 11140, 11140, 11140, 11140, -3726, -3726, 15592,
   -3726,  2766,  2775, -3726, -3726, -3726,  2778, -3726, 11140, -3726,
   -3726, -3726, -3726, -3726, -3726, 11140, -3726, 11140, -3726, 11140,
   11140, -3726, 11140, 11140, -3726, -3726, -3726, 13684, 11140, 11140,
    2780, -3726, -3726, 11140, 11140, 11140, -3726, 11140,  1801, 11140,
    1996, 11140,  2010, 11140, -3726, 11140, -3726, -3726, -3726, -3726,
   11140,  1629,  2437,  2748,  2781, -3726,  1713, -3726, -3726,  2267,
   -3726,   898,  2782, -3726, -3726,  1503, -3726, -3726, 39709, 11140,
   -3726, -3726, -3726, -3726, -3726, -3726, 15592,   458,  2786, 15592,
   -3726,  3276,  3813,  3813,  2209, 11140,  1492,  3276, 11140,  2787,
    2789, -3726, 11140, 47704, -3726, -3726, -3726, 39709, -3726, -3726,
   -3726, -3726, -3726,   132, -3726,  2372, -3726,  2508, -3726,  3254,
    2791, -3726, -3726, -3726, -3726, -3726, -3726, 47704, -3726,  2860,
   -3726, -3726, -3726, 21832, 21832, -3726, 21832, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
    2426,  1972, -3726,  2793, -3726, -3726,  2521,  2882,  2817,  3164,
   -3726, -3726, -3726, 47704, 15592, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726,  3391,  2808,  2811,  3289,  2813,   959,
   -3726,  2897, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
     803, -3726, -3726,  2828,  2828, 19356, -3726, -3726, -3726, 47704,
    3306, -3726,  3262,  3274, 21832, 21832, 21832,   979, -3726,   317,
   -3726,  1417,  3229,  2426, -3726,  3278, 40324, -3726, 31714, -3726,
   -3726, -3726, -3726,   -33,  2922,  2926,   -35, -3726, -3726,  3230,
    3057, -3726, -3726, -3726, -3726,   959, -3726,  2466,  8596,  2845,
   28016, -3726, 15592,  1727, -3726,   959, -3726, -3726,  1906, -3726,
      65, -3726, 35404, 35404, -3726,  3131, -3726, -3726, -3726, -3726,
    2689,   180, -3726, -3726,  3336, -3726,  3337, -3726,  2859,  3339,
   -3726,  3106, -3726,  1084,  3250,  3252, -3726,  3124,    58,  3124,
    1084,  1084, 24929,  1041,  2685, -3726,  2748,  3181, -3726, -3726,
   -3726, 38479, 36019, -3726, -3726, -3726, -3726,  3398, -3726,  3400,
     231, -3726, -3726,  2298,   686, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
    1638,  2298,  2298,  1264, -3726,   149, -3726, -3726, -3726, -3726,
    3338,  2553,   456,  3438,  3125,   456,   456,  3438,   456,  3128,
    3130,   456,   456,  2953,  3390,   456,  3277,  2983,  2178,  3279,
     456,  3143, -3726,  2995,  3401,   456,   456,   456,   456,   456,
    3438,  3148,  3490,   456, -3726,   456,  3150,  3149,   192,  3154,
    3155,   456,   456,   456,   456,   187, 47704,   456,  3156,   456,
   -3726, -3726,  6050, -3726, -3726, -3726, -3726, -3726, -3726,   947,
   22453, -3726, -3726, -3726, -3726,   707,   303,  2987,  1664,  2914,
    2916, 44629,   959,  2748, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726,  -140,  2437,  2298,  2298,  2147, -3726,
    3178,  3348,   456, -3726,  1987, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726,  3006, -3726,  3532,  3101,  2924, -3726,
   -3726,   225, -3726, -3726,   989, 23693, 18120, -3726,  3172, -3726,
    3246,  1074,  1074, -3726, 23693, 23693, 23693, -3726,  2915,  1041,
    2689,  1237,  2689,  2931, -3726, 11776,  1321, -3726,   959, 11140,
     959,  1306, -3726,  2929,  2929,  2937, -3726,  2939,  2929,  3327,
    2937,  3334,  2940,  2942,  1327,  2943,  2945,  1557, -3726, 11140,
   11140,  1338,   508,  1353,   -89,   973,  1073,   560, -3726,  1376,
    3085, -3726, -3726,  1397,  1399,  1401,  1420,  1080,  1471,  1715,
   11776,  1496,   928,   565, -3726,  1501,  1121,  1150,  1505, 11140,
    1547, 11140,  1579, 11140,  1600,  1628,  1647,  2951,  2951,   154,
   -3726,  2950, -3726, -3726, -3726,  2952, -3726, -3726,  1806,  2267,
   -3726, -3726,  2961, -3726, -3726,  2955,   959,  2964, -3726, -3726,
   11140, -3726,   857, -3726, -3726, 15592,   808,  2965, -3726,   959,
   -3726, -3726,  2970,  1557, -3726, -3726, -3726, -3726, -3726, -3726,
      49,  3599, 29867, -3726,  1721, -3726, 36634,  2966, -3726,  2974,
    3047,  3058,  3059,  2972, 11140, -3726, -3726,  3222, 23693, -3726,
    3397, -3726, -3726, -3726, -3726,  2986,  2990, -3726, -3726, -3726,
    3276,  3356,  3238, -3726, -3726,  2437, 47704, 36634, -3726,  2319,
   24929, -3726,  2992, -3726,  2992,  1371,  2994,  1735, -3726, -3726,
   -3726,  2989,  1942,  1774, -3726, 17500,  3258, 36634,  3442,  3445,
    3446, -3726,  2689,  2689,  1163,  3053,  3410, -3726, -3726, -3726,
   -3726, 45244, -3726, -3726, -3726, -3726,  1266, -3726,  3007,  3033,
     195,  3220, -3726, -3726, -3726, -3726,   456, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726,  2426, -3726, -3726, -3726, -3726, -3726,
    2426, -3726,    55,  -140,  -140,  1696,  -140,  3484,  3528,  -208,
     897, -3726,  1959, -3726, -3726, -3726,  3403,  1084,  3124,  3124,
    3404,  3287,  1091,  3039, -3726,   456, -3726,  1407, -3726,  2319,
   -3726, -3726, 11140, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726,  1115, -3726, -3726, -3726, 25547,    91, -3726,   325, -3726,
   25547, -3726,   177,   177, -3726, 45859, 25547,    91,  1906,  2748,
   25547,  2748, 46474,    91,  -140,  -140,  2171,   456,  2748, -3726,
   -3726,  3405, 47704,  3411, 25547, 25547, -3726, 39709, 47704, -3726,
     456,  1393,  2748, 47089,  1906,  1906, 25547,    91, 24929,  2486,
   -3726,  -140,    91, -3726, -3726, -3726, -3726, 23693,    91,    91,
    2549,  2798,  2838,  2901, -3726, -3726, -3726,  2748, 46474, -3726,
   -3726,  5756, -3726, -3726, -3726, 18738, 47704,   951,   502, -3726,
    3023,  3263, -3726, 11140, 11140,  3302, 47704,  3303, -3726,  3597,
   47704,  3655, 46474, -3726,  3044, -3726,  3049, -3726,  1785, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726,  3048, 47704,  2298,  1835,
   -3726, -3726,  -140,   989, -3726, -3726, -3726, -3726,  3310,  3311,
   47704, -3726, -3726, -3726, -3726,  3185, -3726, 23693, -3726,  3211,
   -3726,  3054,  3055, -3726, -3726, -3726,  1021,  5042, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, 31099,  2689,  3313,
   -3726, -3726,  3813, -3726,   959, 11140,   896, -3726, -3726,   194,
    3344, -3726,  1054, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726,  3061,  3813,  3813, -3726, -3726,
   11140, -3726,  3657,  3232, 11140, 11140, -3726, 11140, -3726,   198,
    3084,  3108, -3726, -3726, -3726, -3726, 11140, -3726, -3726,  3813,
   -3726, 11140, -3726, -3726, 11140, -3726, 11140, 11140, -3726,  1659,
   -3726,  1692, -3726,  1694, -3726, -3726, -3726,  2437,  3087,  3461,
   -3726, -3726, -3726,  2437,  3269, -3726, -3726,  2437,  2748,  2462,
   -3726, -3726,   664, 47704, -3726, -3726,  1813, -3726, -3726, 11140,
   -3726, 40324, -3726, -3726,   270, -3726,  3305, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, 47704,  -215,  3099, 32329, 36634, 36634,
   36634, 14320,   959,  3585, -3726, -3726, -3726,  3397,  3472, -3726,
     919, -3726, 47704,  3097,  1533, -3726,  1823, -3726, -3726,  3100,
   -3726,  1806,  3098, -3726,   456, 14320,  2828,  3211, -3726, -3726,
    1371, 24929, 31714, -3726, -3726, 47704, -3726,  3545,  2313, 36634,
   36634, 36634,  2426,  3533,  2882,  2882, -3726, 28633, -3726, -3726,
    3256, -3726, -3726, 32944, -3726, -3726, -3726, -3726, -3726,  8596,
   28016, 44014, -3726, -3726, -3726, -3726, -3726, -3726, -3726,  -140,
    3583,  3347,  1503,  2436, -3726,  1041, -3726,  1084, -3726,  3493,
    3494,  1084, -3726, -3726, -3726, 24929,  2689, 14320, -3726,  1806,
     959,  3109,  1439, -3726, -3726, -3726, -3726,  3113,  3496,  3498,
     177, -3726, 25547, -3726, -3726, 25547, 25547, -3726, -3726,   137,
   46474, -3726, -3726, -3726, -3726, -3726, -3726,  3115, -3726, -3726,
    2437, -3726, -3726, 36019,  -140, -3726, 25547,  3115, -3726, -3726,
     447, -3726,  3141,  -140, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, 46474,  3118, -3726,  1439, -3726, -3726,
    1880, -3726, 46474, -3726, -3726, -3726, 46474, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726,  3129,  2698,  2057, -3726,  3127, -3726, 47704, -3726,
   -3726, 23693, -3726, -3726, -3726,  4804, 47704, -3726,   959,  3813,
    3687, -3726, -3726,  3280,  -140,  3628, -3726,  1829, -3726,  3134,
   -3726, 44629, -3726,  2748,  1638, -3726, -3726, -3726, -3726,  3281,
    1119, -3726,  3307,  3137,  3139, -3726, -3726,  -140,  3138,  3144,
    6050, 18738, -3726, -3726, -3726,  3757, -3726,  3146,  3147,  3151,
    2755, -3726,  3518,  -217,   959,  3153,  3159,  3160,  3166,  3751,
     171, -3726,  3754, 39094, -3726, -3726, -3726,  3170,  1840, -3726,
    3173,  3180,  1705, -3726,   179,  3183,  1748,  1206,  1848,  3476,
    3537, -3726,  3392, -3726,  1793,   374,  1812,  1818,  1820,  1888,
   -3726, -3726, -3726, -3726, -3726,  3184, -3726, -3726,   204, -3726,
    3174,   169,   897, -3726, -3726,  1855, -3726, -3726,  3542,  3808,
    3651,  3550, -3726,  3623, -3726, -3726, -3726,  -154,  -154,  -154,
    1727,   959,  1879, -3726, -3726, -3726, -3726,  3593, -3726, -3726,
    3202,  3290, 47704, -3726,  3238, -3726,  2462, 24929, 14320,  3203,
    3201, -3726,   -16, -3726, -3726,  3197, -3726, -3726, 36634,  2313,
    2313,  2313, -3726,  3794,  3634, -3726, -3726, 39709,  3209, -3726,
   -3726,  3516, -3726, -3726, -3726, -3726, -3726,  -140,  3690, -3726,
   -3726, -3726,  2722,  2528,  3257,  1084,  1084,  3004,  3259, 11140,
   11140,  3214, -3726,  3313, -3726, -3726,   999,  2462, 11140, -3726,
   -3726, -3726,   618, 11140, 25547, -3726, -3726, -3726,  3221, -3726,
   -3726,  3735,  3736, -3726, 25547,  2333, 47704, -3726,  3030, -3726,
   -3726, -3726,  3317, -3726,  4804, -3726, 24929, -3726, -3726, -3726,
   47704, -3726, 23693, -3726, -3726,  3227, -3726,  2929,  2929,  2929,
   -3726, -3726, -3726,  2937, -3726,  2939,  3462, -3726,  2939,  2939,
   -3726, -3726, -3726, -3726, -3726,   194,   412, -3726, -3726,   194,
   -3726, -3726, -3726,   119,  1459,  2939, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726,  2929,  2937,  2937, -3726, -3726,   194,  2929,
   -3726,  2929,  2635, -3726,   199,   142,  2929,  2929,  2929,  3228,
    3223, -3726, -3726, -3726, -3726, -3726, -3726, 47704, -3726,  1134,
   -3726, -3726, -3726,  1902,  -140, -3726, -3726, -3726,  3233,  3231,
   -3726, -3726, -3726,   303, -3726, 47704,  4804, -3726, -3726, -3726,
    3172, -3726, -3726,  1167, 47704, 47704, 47704, 35404, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, 39094, -3726,  3829,
   -3726,  3509, -3726, -3726, -3726, 11140, -3726, -3726, -3726, 11140,
   -3726, -3726,  3543,  3706, -3726, -3726, -3726, -3726, -3726, -3726,
    3244, -3726,  2748,  1417,  1417, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726,  3510,   299,  3271,  3271,  3271, -3726, 14320,  3633,
    3343, -3726, -3726,  3255,  3296, -3726, -3726,   169, -3726, -3726,
   -3726, -3726,  2313, 11140, -3726,  3313,  2171, -3726, 28633, -3726,
   -3726,  -140,   664, -3726,  3301, -3726, -3726, -3726,  3304,   959,
     959, 47704,  3518, -3726,  1212,   169,  1439,  2437,  3238, -3726,
    1899,  3260,  3265, 47704,  3275,  3282, -3726,  3243,   951, -3726,
   -3726, -3726, 23693,  2635,    91, -3726, -3726,  3115,   803,  3283,
   47704,  3590, -3726, -3726, -3726, -3726,  1242, -3726,  3286,  1242,
    1242, -3726,  2060, -3726,  3308,   194, -3726, -3726,  3309, -3726,
   -3726, -3726,  1242,  3288,   194, -3726, -3726, -3726, -3726,  1242,
   -3726, 39709,  1769,  -140,  2954, -3726,  3326, -3726,  3793,   188,
    3665, -3726,  2635, -3726,  3671,  3565, -3726,   194, -3726, -3726,
    3829, -3726,   194,  3829,  1242,  3571, -3726,  1242, 47704,  3409,
   -3726, 53854, -3726, -3726,  1170,  3320, -3726, -3726, -3726, -3726,
      96, 47704, 23693,  3302,  3480, -3726,  3030, -3726,   -16,  1021,
    3211, -3726,  1922,  1439,  3300,  1925,  2011, -3726, -3726, -3726,
    3323,  3299,  1439,  1920, -3726, -3726, -3726,  3324, -3726, -3726,
   -3726,  3387,  3388, -3726, -3726,  3395, -3726, -3726,   146,  1652,
   -3726, -3726, -3726, -3726,  3353, 23693, 15592,  3417, 47704,  1714,
    2545, -3726,   318,  1439, 11140,  2426, 36019, -3726, -3726, -3726,
   -3726, 11140,  3330, 11140,  3333,  2014, -3726, -3726, -3726,   177,
     177, -3726,  1212, -3726, -3726, -3726,  2020, -3726, 47704, 47704,
    2042, 47704, 47704,  2733,  2736,  2744,  2381,  2381, -3726, -3726,
   -3726, -3726, -3726, -3726,  3704, -3726, -3726,  2051, -3726,  1198,
    3594, -3726, -3726, -3726, -3726,  1242, -3726,   179, -3726, -3726,
   -3726, -3726, -3726,   179, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726,  3595,  3373, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,  3335, -3726,
   -3726, 11140,  3820,  3366, 47704,   917, -3726, 55084, 55084, 47704,
   -3726, -3726, -3726, -3726,  5413, -3726, -3726,  1189, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,  3944,
   -3726,  3341, -3726, -3726,  1170,  3346, -3726,   252, -3726,  1942,
   -3726, -3726,  4804,  3797,  1664, -3726, -3726, -3726, -3726, -3726,
    3351,  1942,   253, 47704, -3726,  3627,   138,   236, -3726, 11140,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726,   273,  3614,  2748,
    2748,  2748,  2748,  1652, -3726, 24929,  2685, -3726,  2437, -3726,
    2053, -3726, -3726, -3726,  3441,   456,  3865,  3866,   456,   456,
     456,   456,  3379,  2545, -3726,  3859, -3726, -3726, 11140, -3726,
   -3726,   959,  3610, -3726,  3946,   897,   959, 47704,   959, 47704,
   -3726,  3833,  3833, -3726, -3726,  2071,  2077,   253,  2082,  2089,
   -3726, -3726, -3726,   951,  3406, -3726, 47704, -3726, -3726, -3726,
     266, -3726, -3726,  2091, -3726,  2093, -3726, -3726,   959, 11140,
   -3726, 11140,  3413, -3726, -3726,  3832, 47704, -3726, -3726, -3726,
   -3726, 11140, -3726, 53854, 53854, -3726, -3726, -3726, -3726,  4000,
   -3726,  3407,   -16,  3972,  3662,  3978, -3726,  3402, -3726, -3726,
    3597,  4804, -3726, -3726,  -140,   456, -3726,   253, -3726, -3726,
   -3726,  1439,  3412,  3663, -3726,   138, -3726, -3726, -3726,   236,
   -3726, -3726,  1439, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
    3416, -3726,   456, -3726,  3414, -3726, -3726, 47704,  3422, -3726,
    -140,   456,   456,  2618,  2618,  2437, 39709,  3526, -3726, -3726,
     456,  1439,  4043, -3726,  1003,  3796, -3726,  2099,  2108,  1476,
   -3726, -3726,  3632,   253, -3726,   138,   236, -3726,  3238, -3726,
     847,   847,   194,   179,   194,   959,   959, -3726,   254, -3726,
   -3726,  3824,  3922, 11140,   959, 50779,  3443, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   54469, 11140, -3726,  1189,  3944, -3726, -3726,  3714, -3726,  3715,
   -3726, -3726, -3726,  3959, 53854, -3726,  3951, -3726,   -16, -3726,
    2748,   270, -3726, -3726, -3726,  1731,   270, -3726,   270, -3726,
   -3726, 24929, 14320,  2171, -3726,  3417, -3726,  3458, -3726, -3726,
     671, -3726,  -140,  -140, -3726, -3726, -3726, -3726, -3726,  2119,
   -3726, 39709, -3726, -3726,  4045,  4047,  3947,  4048,  1003, -3726,
    -120, -3726, -3726, -3726,  4053, -3726,  4054,  3469,  3478, -3726,
   -3726, -3726, -3726,  2124, -3726,  4106, -3726,   925,  3748,  3750,
   -3726, -3726, -3726,  3511, 11140, 53854, -3726,  3967, -3726,  3897,
     959,  3842,  3485, -3726,  3481,   959,  4005, 55084, 55084, -3726,
   -3726, -3726, -3726,  3982, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726,  2127, -3726, 14956,
   -3726, -3726, -3726, -3726, -3726, 39709, -3726,  3526, -3726,  3495,
     179,   179,  4084,   179, -3726,  4085,  4086,  -120, -3726, -3726,
   -3726, 44629, 44629, -3726, -3726, -3726, -3726,  3549,  4010, -3726,
     286, -3726,   959, 51394,  4087, 47704, -3726,  3596, -3726, -3726,
   11140,  4002, 40939, 52009,  3505, -3726, -3726, -3726,  3683, -3726,
    3402,  3689, -3726,  3458, -3726,  3515, -3726,  3276,  2545, -3726,
   -3726,  3806, -3726, -3726,   179, -3726,   179,   179, -3726,  3522,
    2133,   847,   847, 11140, -3726,  4016,  3617, -3726,  3538, -3726,
   53854,   959, 53854, -3726, -3726,  3966,  3539,  1425, -3726,  3536,
   -3726, -3726, 53854,  3957,  3946, -3726, 14956,  3544, -3726, -3726,
    3546,  3547, -3726, -3726, -3726, -3726, -3726, -3726, -3726,   959,
    4124, 53854, 47704, 48934,  4029, 52624,  3994, 47704,  4804,  3996,
    3997, -3726, 53854, -3726,  4138,  3796, -3726, -3726, -3726,  3806,
    3636, -3726, 49549, -3726,  2303,  3749,  3579, -3726, -3726,  4071,
    2471, -3726, -3726,   179,  3971, -3726, 53854, 53854, -3726, -3726,
   -3726, -3726, 33559, -3726, -3726, -3726, -3726, -3726,   979, -3726,
    3835,  3562, 50164, 53239, -3726, -3726, -3726, 30484, -3726, -3726,
   -3726,  4008, -3726, 11140, -3726,    44, 19974,  3719, 33559, -3726,
   -3726,   959, -3726, -3726, -3726, -3726, 39709,  2156, -3726, -3726,
   24929, -3726, -3726, -3726, -3726, 23073,  3564, -3726,   456, -3726,
   24929, -3726, -3726, 14320, -3726, -3726
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,  2604,  1084,  2535,     0,     0,     0,     0,     0,     0,
    2537,   123,    63,  1707,  1821,  1822,  1611,  1639,     2,     0,
    1084,   269,   173,     0,    75,  1648,     0,  1873,     0,     0,
    1084,   483,     0,  1867,     0,     0,  1084,  1651,  1857,   246,
     173,  2537,     0,  1130,  2342,  1745,     0,     0,     0,  1728,
       0,  2418,  1696,     0,     0,     0,     0,     3,     8,    19,
       0,    39,    24,    29,    14,    18,    13,    52,    46,    26,
      37,    10,    54,    55,    16,    43,    11,    12,    15,    35,
      42,    36,    38,    50,  1121,    22,    23,    30,    44,    59,
      20,    56,    53,    21,  1823,    25,    45,    40,    32,    60,
      33,    51,    34,    58,    28,    47,    27,     9,    17,    48,
      49,    41,    61,    31,    57,     0,   929,     0,     0,     0,
     954,   953,     0,     0,     0,   173,  1008,   909,  2602,  2603,
    2604,  1086,  1085,     0,  2537,  1978,  1069,  1095,  2041,  2042,
    2043,  2044,  2045,  2046,  2047,  2048,  1992,  2049,  2051,  2050,
    2052,  2053,  1993,  1994,  2054,  2055,  2056,  2058,  2057,  2059,
    1995,  1996,  2060,  2061,  2062,  2063,  1997,  1998,  2064,  2066,
    2065,  1999,  2067,  2068,  2069,  2072,  2071,  2070,  2000,  2073,
    2001,  2074,  2075,  2076,  2077,  2078,  2079,  2080,  2082,  2081,
    2002,  2083,  2084,  2085,  2086,  2087,  2089,  2088,  2090,  2091,
    2092,  2003,  2093,  2094,  2095,  2096,  2097,  2098,  2099,  2100,
    2101,  2004,  2102,  2103,  2104,  2124,  2005,  2105,  2108,  2107,
    2106,  2109,  2110,  2111,  2113,  2112,  2114,  2115,  2006,  2116,
    2117,  2118,  2119,  2120,  2122,  2121,  2126,  2127,  2128,  2007,
    2008,  2123,  2125,  2322,  2129,  2131,  2130,  2132,  2134,  2133,
    2009,  2135,  2010,  2011,  2136,  2137,  1975,  2138,  1976,  2139,
    2141,  2142,  2143,  2148,  2012,  2140,  2144,  2145,  2146,  2147,
    2149,  2013,  2150,  2151,  2152,  2153,  2154,  2155,  2156,  2157,
    2158,  2159,  2181,  2170,  2172,  2163,  2165,  2166,  2168,  2164,
    2171,  2169,  2175,  2174,  2176,  2177,  2178,  2179,  2180,  2173,
    2161,  2167,  2162,  2182,  2183,  2160,  2184,  2185,  2186,  2187,
    2188,  2189,  2190,  2191,  2192,  2193,  2194,  2196,  2195,  2197,
    2198,  2199,  2200,  2201,  2202,  2204,  2203,  2205,  2206,  2207,
    2209,  2208,  2211,  2212,  2014,  2210,  2213,  2214,  2215,  2216,
    2217,  2218,  2015,  2016,  2017,  2219,  2220,  2018,  2221,  2223,
    2222,  2224,  2225,  2226,  2227,  2228,  2229,  2230,  2019,  2020,
    2231,  2232,  2233,  2234,  2235,  2236,  2237,  2238,  2239,  2240,
    2241,  2242,  2243,  2244,  2246,  2245,  2247,  2248,  2249,  2250,
    2251,  2252,  2253,  2021,  2254,  2022,  2255,  2256,  2023,  2257,
    2024,  2258,  2259,  2260,  2261,  2025,  2262,  2263,  2264,  2266,
    2267,  2265,  2268,  2026,  2269,  2270,  2271,  2027,  2273,  2272,
    2274,  2028,  2276,  2277,  2029,  2275,  2031,  2278,  2279,  2030,
    2032,  2280,  2281,  2282,  2283,  2284,  2286,  2285,  2287,  2288,
    2289,  2033,  2290,  2291,  2292,  2293,  2034,  2294,  2295,  2296,
    2297,  2298,  2300,  2299,  2301,  2302,  2303,  2304,  2306,  2308,
    2307,  2305,  2309,  2310,  2311,  2312,  2315,  2316,  2317,  2318,
    2313,  2314,  2035,  2319,  2320,  2321,  2323,  2324,  2326,  2325,
    2036,  2037,  2327,  2328,  2040,  2329,  2330,  2333,  2331,  2332,
    2335,  2334,  2336,  2338,  2337,  2038,  2339,  2039,  2340,  2341,
     192,  1981,   175,  1982,  1991,     0,  2410,  2409,  1053,  1070,
    2538,  2539,   578,     0,     0,     0,   577,   173,  2604,   128,
       0,   574,   575,   857,  1721,     0,  1637,  1637,  1637,     0,
    1637,  1637,     0,  1640,  1637,   173,  1637,     0,     0,    68,
    1830,   270,     0,  2446,     0,     0,     0,  1974,     0,  1654,
       0,  1874,  1875,     0,  1882,     0,  1883,  1877,  2407,     0,
       0,     0,     0,     0,   173,  1087,     0,  1705,     0,   236,
     245,   247,   248,   244,  2439,  2539,  2550,  1122,  1128,  1140,
       0,  1801,   248,  1040,  1024,  1040,  1729,  1726,     0,     0,
    1705,  1876,  2661,     0,     0,     0,  2657,     0,  2662,     0,
    1130,     0,     0,     1,     5,     0,     0,  2119,  2008,  2223,
    1814,  1812,  1969,     0,   900,   930,     0,   905,     0,   903,
    1987,  1986,  1985,     0,   916,   915,   913,     0,   447,     0,
    1009,     0,     0,  2613,   907,  1067,  2536,     0,   194,     0,
      77,     0,     0,     0,  2542,     0,     0,     0,     0,   127,
       0,     0,     0,   124,  1155,  1155,  2604,  2606,  2608,   578,
     576,   859,   860,   858,     0,     0,     0,  1725,  1724,  1723,
       0,  1721,  2042,  1992,  2053,     0,  1942,     0,     0,     0,
    1409,     0,  1997,     0,  2067,  2069,  2002,     0,     0,  1162,
    1162,   731,     0,     0,     0,  2091,  2092,  1948,     0,     0,
       0,  1939,  1949,  2008,  2131,  2132,     0,  1941,  2137,     0,
       0,     0,     0,  2154,  1946,     0,     0,  2191,  2193,     0,
       0,  2197,  2198,  2199,  2200,  1925,  1217,     0,   731,  1938,
    1945,  2216,  1931,  2224,  2229,  2230,     0,  2239,     0,     0,
    2261,     0,  2267,  2265,  2271,     0,     0,  2297,     0,     0,
     731,  1924,  2315,  2316,  2317,  2318,     0,  1940,  2035,  1947,
       0,  2329,  1162,   731,   731,     0,     0,     0,  2336,  2338,
    2341,     0,     0,     0,  2574,  1216,     0,  1374,     0,  1291,
    1403,  1174,  1180,  1194,     0,  1209,  1227,  1228,  1230,  1329,
    1229,  1235,  1234,  1612,  1935,  1233,  1232,  1936,  1937,  1226,
    1959,  1981,  1958,     0,     0,     0,     0,     0,     0,     0,
    1641,     0,     0,  1623,     0,  1637,    70,     0,     0,     0,
    1971,  1518,  2421,  2422,     0,    76,  1656,  1657,  1655,  1008,
       0,  1872,     0,  1886,     0,  1082,   493,   484,     0,  1796,
    1795,     0,  1868,  2551,     0,     0,  1058,  1659,  1706,     0,
    1658,  1863,     0,  1861,  1858,  1860,   237,     0,     0,   267,
       0,  2545,  2542,  2552,  2587,  2582,  2581,  2584,  2585,  1146,
    2586,  1145,  2583,  2580,  1155,  1141,  1143,  1144,   775,     0,
       0,  2362,  2363,  2204,  2224,  2364,  2313,     0,     0,  2384,
    2343,  2348,  2344,     0,     0,   775,  1809,     0,     0,  1809,
       0,  1553,  1799,  1802,     0,  2366,  1777,   856,   855,   854,
    2367,  1795,     0,  1753,  1765,     0,  1730,  1770,     0,  2368,
       0,  1798,     0,  1553,  1809,     0,  1746,     0,     0,     0,
       0,   243,  1045,  1044,  1020,  1041,  1042,     0,     0,  1023,
    1025,  1026,  1022,     0,  2674,  2419,  1008,  1930,  1929,  1979,
    2658,  1928,  2666,  2668,  2654,  2656,  2663,  1124,     0,  2556,
       6,    62,     0,     0,  1827,  2611,  2612,  2610,   791,     0,
    1162,  1988,  2605,   176,   914,     0,   448,   176,     0,     0,
       0,     0,     0,   449,   450,   382,   918,     0,     0,   911,
       0,     0,   910,  2613,     0,     0,  1097,  1099,  1098,  1115,
     196,   193,   174,     0,  1055,  1630,  1632,  1072,  2541,     0,
       0,  2543,  2547,  1215,  1214,     0,   121,   126,     0,     0,
       0,  2513,   125,  2507,  2609,  1155,  1155,  1155,  2601,     0,
    2589,  2596,  2597,  2600,  2599,  2598,  2595,     0,  2588,  2591,
    2592,  2594,  2593,  2613,  2607,     0,     0,     0,     0,     0,
    1708,  1711,  1715,  1719,  1722,     0,     0,  1523,  1248,  1523,
    1523,  1523,  1410,     0,     0,     0,     0,     0,     0,     0,
       0,  1523,     0,  1285,  1258,     0,  1286,     0,     0,     0,
    1950,     0,     0,     0,  2574,     0,     0,     0,     0,  1379,
       0,     0,     0,  2574,     0,     0,     0,     0,     0,  1405,
    1407,  1958,  1523,     0,     0,  1523,     0,     0,     0,     0,
       0,  1167,   771,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1523,  1523,     0,     0,
    1523,  1299,  1952,     0,     0,     0,  1951,     0,     0,     0,
    1944,  1943,  1926,     0,  1302,  1304,  1303,     0,  1523,  1523,
       0,     0,     0,  1238,  1237,  1239,     0,     0,     0,     0,
       0,     0,  1213,  1212,  1211,  1210,     0,     0,     0,  1218,
       0,  1219,  1220,     0,  1221,  1222,  1223,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1240,     0,     0,     0,
    1927,  1338,     0,  1638,  1618,  1625,  1620,  1641,  1621,  1629,
     462,   461,  1646,  1647,  1627,  1642,  1643,     0,  1626,  2505,
    1622,     0,     0,  1613,     0,    69,     0,  1853,     0,     0,
       0,  1849,  1851,  1850,     0,     0,  1854,     0,  1852,  1831,
    1835,  1841,  1832,     0,     0,   268,   271,   273,     0,   276,
    2456,  2471,  2472,  2468,  2473,  2491,  2474,  2478,     0,  2470,
    2462,     0,  2477,     0,  2466,  2475,     0,  2460,     0,  2476,
    2481,  2492,  2464,  2469,  2447,     0,  2454,  2458,  1519,  1520,
       0,  2420,     0,  1970,     0,     0,  1105,  1887,  1888,  1884,
    1518,  2408,  2411,     0,   494,     0,     0,   505,     0,     0,
      65,    66,     0,  1089,     0,  1088,  1092,     0,     0,     0,
    1662,  1652,  1661,  1444,  1864,  1865,     0,   235,   260,   255,
     263,   257,   259,   258,   264,   265,   266,   261,   256,   262,
     249,     0,  2456,     0,  2440,     0,  2546,     0,  2548,  2565,
    1129,  2553,  1152,  1131,  1151,     0,  1142,   774,     0,   777,
     779,  1681,  1682,   778,   787,     0,   776,     0,     0,     0,
    2369,     0,   783,   785,   784,  2379,   782,     0,     0,  2353,
    2374,  1805,     0,     0,  1776,     0,   578,     0,     0,     0,
       0,     0,     0,  1747,     0,     0,   621,     0,  1769,  1554,
    1803,  1804,  1809,     0,     0,  1809,     0,  1782,  1799,     0,
    1809,  1742,     0,     0,  1734,  1739,  1735,     0,  1741,  1740,
    1743,  1731,  1732,  1805,  1758,  1783,  1799,  1768,  1775,     0,
    1757,  1764,     0,  1773,  1799,  1799,  1809,  1809,  1046,     0,
    1029,  1030,     0,     0,  1727,  1447,     0,     0,  2655,  2669,
    2653,  2664,  2665,  2652,  1125,  2557,  1123,  2558,     0,     7,
       4,  1826,  1816,  1817,  1818,  1819,  1820,  1815,  1813,  1828,
    1829,   792,   791,   569,   572,   571,     0,     0,  1990,     0,
     906,     0,   436,   904,     0,     0,   414,   393,   414,   451,
       0,     0,   898,   921,     0,     0,   908,  1068,     0,     0,
     482,  1115,  1101,  1117,     0,   197,   199,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    78,    79,   101,  1057,  1056,     0,  1054,  1080,  1079,
    1077,     0,  1078,  1076,  1071,  1073,  1074,  2540,  2544,   579,
     791,   424,     0,   385,     0,     0,     0,     0,     0,   578,
       0,     0,  2590,   110,   861,   861,   861,  1713,  1634,  1444,
    1636,  1969,     0,     0,     0,  1717,     0,     0,  1524,  1523,
       0,  1388,     0,     0,     0,     0,  1411,     0,     0,     0,
       0,     0,     0,     0,  1359,     0,  1388,  1163,     0,   732,
    1309,     0,     0,     0,     0,     0,     0,  1494,  1495,  1496,
    1497,  1505,  1498,  1499,  1500,  1507,  1512,  1501,  1502,  1508,
    1509,  1510,  1503,  1511,  1506,  1504,  1513,     0,  1493,     0,
       0,  1517,  1514,  1516,  1515,     0,  1380,  1372,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1523,
       0,     0,     0,  1523,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1321,     0,     0,     0,     0,     0,  1523,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1281,     0,
    1961,  1960,     0,     0,     0,   824,     0,  1242,     0,  1241,
    1456,     0,  2559,  2575,     0,  2369,  1375,  1377,     0,  1165,
    1164,  1166,  1177,  1170,  1175,  1168,  1172,     0,  1224,  2048,
    1178,     0,     0,  1206,  2574,  1532,  1207,  1192,  1197,  1198,
       0,  1195,  1196,     0,  1200,     0,  1199,  1203,  1204,  1205,
    1208,     0,     0,     0,     0,  1231,  1236,  1404,  1155,  1962,
       0,  1628,  1797,  1644,  1683,     0,  1010,     0,     0,     0,
      71,    73,  1846,  1843,  1842,  1844,  1848,  1847,  1845,     0,
    1855,  2091,  2315,  2318,   280,     0,   253,   252,   254,   277,
       0,     0,  2457,  2455,  2489,  2488,  2493,     0,  2490,  2486,
    2479,  2514,  2483,     0,  2514,  2485,  2484,  2514,  2480,  2487,
    2514,  2452,     0,  1522,  2127,  2208,     0,  1525,  2424,  1649,
    2673,     0,  1885,     0,     0,     0,  1083,     0,  1155,   492,
     491,   490,   489,     0,   507,   487,   495,    67,     0,     0,
    1869,     0,     0,     0,     0,  1060,  1660,     0,     0,  1633,
    1445,  1866,  1862,  1859,     0,     0,  2455,     0,  2452,  2549,
    2567,  2566,  2554,  1155,  1544,  1156,  1156,  1958,  2386,     0,
    2381,  2380,     0,     0,     0,  2399,  2382,     0,     0,  2347,
    2387,  2388,  2391,     0,     0,     0,     0,     0,  2385,  2313,
    2349,  2350,     0,  2355,  2345,     0,     0,  1807,  1810,  1811,
       0,     0,  1791,  1785,  1784,  1780,  1786,  1781,  1794,  1793,
    1792,  1755,  1754,  1564,  1565,  1563,  1557,  1558,  1562,  1561,
    1750,  1800,  1790,  1788,  1778,  1809,  1789,  1787,  1736,  1737,
    1738,     0,  1553,     0,  1807,  1809,  1799,     0,  1809,  1809,
    1772,  1774,     0,  1032,  1043,  1028,  1027,  1465,  1464,     0,
    1418,     0,  1420,  1417,  1416,  1415,     0,  1464,  2659,  2667,
    2671,     0,  1553,  2564,  2562,   570,  1683,  1683,     0,  1989,
       0,     0,     0,     0,     0,     0,     0,   177,   186,     0,
       0,   391,   392,  1683,   390,   437,   438,   441,   442,   443,
       0,     0,     0,     0,     0,     0,     0,     0,   130,   444,
    1683,  1683,   387,   415,   416,   419,   420,   421,   422,   423,
     383,     0,   388,     0,   919,   791,     0,   923,   925,  2614,
    2615,  2616,  1104,  1096,  1103,  1100,  1115,  1113,  1102,   851,
     850,     0,  1116,   195,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1631,  1081,  1075,   122,   791,  1683,  1683,  1683,  1683,   389,
     425,   426,   429,   430,   431,   432,   435,   433,   434,     0,
       0,   401,     0,     0,  2508,     0,  2647,     0,     0,     0,
     175,   580,   862,     0,     0,     0,     0,     0,  1709,     0,
    1972,  1716,  1447,  1720,  1719,     0,  1305,     0,  1352,     0,
    1354,  1355,  1356,     0,     0,     0,     0,     0,  1306,     0,
    1256,  1307,  1308,     0,     0,     0,     0,  1358,     0,   733,
       0,     0,  1259,  1260,  1253,  1245,     0,     0,  1331,     0,
       0,  1261,     0,     0,     0,     0,     0,  1332,  1406,     0,
    1408,  1962,     0,  1364,  1313,  1266,     0,  1362,     0,  1267,
    1333,  1334,  1335,  1315,  1316,     0,  1337,     0,  1317,     0,
       0,  1320,     0,     0,  1269,  1368,  1366,     0,     0,     0,
       0,  1370,  1271,     0,     0,     0,  1270,     0,     0,     0,
       0,     0,     0,     0,  1273,     0,  1254,  1367,  1369,  1323,
       0,     0,     0,     0,     0,  1282,     0,  2568,  1455,  2576,
    1456,     0,     0,  2570,  2560,  2565,  2573,  1246,     0,     0,
    1963,  1171,  1176,  1169,  1173,  2574,     0,     0,     0,     0,
    1190,  1189,     0,     0,     0,  2574,  1532,  1193,     0,     0,
    1348,  1349,  1401,     0,  1619,  1645,  1684,     0,  2506,  1012,
    1011,  1624,  1615,  1010,    74,     0,  1840,  1856,  1833,     0,
     272,   281,   274,   278,   279,   275,  2482,     0,  2463,     0,
    2467,  2461,  2465,     0,     0,  2453,     0,  2459,  2434,  2428,
    2435,  2437,  2431,  2436,  2438,  2429,  2430,  2425,  2432,  1526,
    1555,     0,  1106,  1108,  1109,  1107,  1115,     0,     0,  2414,
    2415,  2413,  2412,   497,     0,  1589,  1590,  1575,  1576,  1574,
    1577,   506,  1578,  1588,     0,   518,     0,     0,     0,  1871,
    1870,     0,  1090,  1093,  1094,  1065,  1064,  1066,  1059,  1061,
    1062,   562,  1666,     0,     0,     0,  1672,  1653,  1663,     0,
       0,   250,     0,     0,     0,     0,     0,     0,  1150,  1447,
    1604,  1147,  1135,  1555,  1545,  1134,  1157,  1153,     0,   790,
     789,   788,   786,     0,     0,     0,     0,  2393,  2394,     0,
       0,  2370,  2371,  2372,  2377,  2376,  2352,  2353,     0,  2354,
       0,  2405,  2406,  2403,  2404,  2402,  2375,  1806,     0,  1759,
       0,  1779,     0,     0,  1752,     0,  1771,  1733,  1761,  1751,
    1525,  1799,  1748,  1749,     0,  1052,     0,  1048,  1047,     0,
    1021,  1034,  1464,  1447,     0,     0,  1441,  1466,     0,  1466,
    1447,  1447,     0,  1447,  1444,  1461,     0,     0,  2670,  1546,
    2563,     0,     0,   902,   180,   183,   181,     0,   182,     0,
       0,   446,   445,     0,  1797,   439,   134,   133,   135,   136,
    1572,  1573,  1569,  1570,  1568,  1571,   138,   137,   132,   917,
       0,     0,     0,  1797,   417,   394,   395,   398,   399,   400,
       0,  1006,  1683,  1006,     0,  1683,  1683,  1006,  1683,     0,
       0,  1683,  1683,     0,     0,  1683,     0,     0,  1006,     0,
    1683,     0,   993,     0,     0,  1683,  1683,  1683,  1683,  1683,
    1006,     0,     0,  1683,   482,  1683,     0,     0,  1016,     0,
       0,  1683,  1683,  1683,  1683,     0,     0,  1683,     0,  1683,
     937,   992,   582,   608,   609,   899,   936,   938,   950,   478,
       0,   971,   995,   996,   994,     0,     0,     0,   144,  2618,
       0,  1485,   198,   102,   100,    82,  1977,    86,    88,    81,
     106,  1582,  1583,  1581,  1579,  1580,   107,    84,    85,    87,
      91,    90,    92,    93,    96,    97,    94,    89,    95,    83,
      98,   108,   109,    80,     0,     0,     0,     0,  1797,   427,
       0,     0,  1683,   384,   402,   403,   406,   407,   408,   409,
     410,   413,   411,   412,     0,  2509,  2511,     0,     0,   378,
     377,     0,   139,  2641,     0,     0,   653,   111,   478,   581,
     584,     0,     0,   863,     0,     0,     0,  1635,  1719,  1447,
    1525,  1970,  1525,     0,  1718,     0,     0,  1353,  1389,     0,
    1412,     0,  1250,   745,   745,   729,  1397,   725,   745,  1393,
     729,  1395,     0,     0,     0,     0,     0,  1360,  1357,     0,
       0,     0,     0,     0,  1383,     0,     0,     0,  1255,     0,
    1343,  1365,  1363,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1371,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   813,
     819,   822,   823,   825,   817,     0,  1325,  1243,  1155,  2577,
    2579,  1126,     0,  2569,  2571,   894,  1376,     0,  1187,  1183,
       0,  1181,  1531,  1202,  1201,     0,     0,     0,  1191,  1156,
    1339,  1155,     0,  1402,  1964,   460,   620,  1616,  1614,    72,
    1836,     0,     0,  2518,     0,  2517,     0,  2501,  2504,  1969,
       0,     0,     0,     0,     0,  2423,  1556,  1693,     0,  1115,
    1119,  1980,  1878,  2416,  2417,     0,   498,   499,   501,  1156,
     515,   493,     0,   485,   488,     0,   497,     0,  1063,  1140,
       0,  1685,  1670,  1677,  1671,     0,     0,     0,  1669,  1954,
    1953,  1960,  2552,     0,  1491,     0,     0,     0,     0,     0,
       0,  2555,  1525,  1525,  1598,     0,     0,  1132,  1137,  1133,
    1136,     0,  1154,  1161,  1160,  1955,  1962,  2383,     0,     0,
       0,     0,  2398,  2392,  2389,  2390,     0,  2351,  2373,  2357,
    2356,  2359,  2361,  1808,  1553,  1767,  1766,  1560,  1559,  1744,
    1553,  1763,  1809,     0,     0,     0,     0,     0,  1036,     0,
    2559,  1459,     0,  1443,  1442,  1467,     0,  1447,  1466,  1466,
       0,  1423,  1422,  1697,  1700,     0,  1421,  1518,  1449,  1140,
    2660,  2672,     0,   619,   618,   185,   184,   190,   191,  1586,
    1584,  1585,   452,   463,  1587,   464,   440,   131,   453,   454,
     418,     0,   396,   920,  1007,   892,  1084,   975,     0,   654,
     892,   847,   852,   852,   973,     0,     0,  1084,     0,     0,
       0,     0,     0,  1084,     0,     0,     0,  1683,     0,   986,
     932,     0,     0,     0,     0,     0,   987,     0,     0,   933,
    1683,     0,     0,     0,     0,     0,     0,  1084,     0,     0,
     480,     0,  1084,   482,  1019,  1018,  1017,     0,  1084,  1084,
       0,     0,     0,     0,   614,   615,   613,     0,     0,   606,
     583,   791,   934,   479,   935,   653,     0,  1013,   650,   656,
    1965,     0,   154,     0,     0,   922,     0,   147,   145,   156,
       0,     0,     0,  1488,     0,  1489,  1486,  1487,     0,   103,
     105,   459,   458,   457,   456,   428,     0,     0,     0,  1797,
     404,  2510,     0,     0,  2648,   381,   379,   380,     0,     0,
     200,   635,   636,   634,   633,     0,   467,     0,   465,     0,
     477,     0,   637,   638,   640,   641,  1889,   791,   585,   885,
     887,   886,   877,   876,   112,   115,   118,     0,  1525,  1544,
    1973,  1712,     0,  1283,  1413,     0,     0,   746,  1390,   799,
       0,  1399,     0,  1400,   727,   726,  1392,  1394,  1398,  1396,
    1249,  1257,  1330,  1252,  1251,     0,     0,     0,  1289,  1311,
       0,  1290,     0,  1381,     0,     0,  1263,     0,  1265,     0,
       0,  1345,  1314,  1336,  1292,  1318,     0,  1268,  1244,     0,
    1293,     0,  1298,  1296,     0,  1272,     0,     0,  1279,     0,
    1277,     0,  1278,     0,  1280,  1322,  1324,     0,     0,   824,
     810,   811,   812,     0,   814,   816,   818,     0,     0,  1457,
    2578,  1127,     0,     0,  1378,  1179,     0,  1188,  1185,     0,
    1182,  1157,  1350,  1340,   997,  1838,     0,  1834,   289,   284,
     292,   286,   288,   287,   293,   294,   295,   296,   290,   285,
     291,   283,   282,  2515,     0,  2526,     0,     0,     0,     0,
       0,     0,  1527,     0,  1650,  1110,  1115,  1119,     0,  1111,
    1889,   502,     0,     0,     0,   522,     0,   520,   496,     0,
    1091,  1155,  1667,  1679,     0,  1687,     0,     0,  1664,  1674,
       0,     0,     0,  1673,   482,     0,   251,     0,  2445,     0,
       0,     0,  1555,  1533,     0,     0,  1610,     0,  1605,  1148,
       0,  1159,  1158,     0,  2401,  2400,  2396,  2395,  2397,     0,
       0,     0,  1760,  1762,  1756,  1051,  1050,  1049,  1033,     0,
       0,  1038,  2565,  1518,  1451,  1447,  1419,  1447,  1430,     0,
       0,  1447,  1426,  1424,  1428,     0,  1525,     0,  1483,  1155,
    1957,  1547,  1550,   397,   655,   893,   958,     0,     0,     0,
     852,   649,   892,   861,   853,   892,   892,  1002,  1003,     0,
       0,   593,   590,   977,   602,   956,   944,   957,   968,   970,
       0,   592,   616,     0,     0,   604,     0,   939,   984,   985,
    1010,   587,     0,     0,   629,   630,   628,   610,   617,  1004,
    1005,   588,   589,   979,     0,  1540,  1542,  1550,   595,   594,
       0,   591,     0,   955,   990,   963,     0,   627,   625,   622,
     624,   623,   626,   605,   597,   596,   599,   598,   601,   600,
     603,   949,     0,  1006,  1006,   972,     0,  1968,     0,  1015,
     974,     0,   642,   651,   643,     0,     0,   155,   143,     0,
       0,   924,   926,     0,     0,   927,  2620,     0,  2622,     0,
    1118,     0,    99,     0,     0,   386,   455,   405,  2512,     0,
     211,  1155,     0,     0,   201,   203,   204,     0,     0,     0,
     580,   653,  1891,  1890,   466,   565,   586,     0,     0,     0,
    1719,  1714,  1566,     0,  1414,     0,     0,     0,     0,   793,
     804,   802,   796,     0,   800,   801,  1391,     0,     0,  1361,
       0,     0,     0,  1384,     0,     0,     0,     0,     0,     0,
       0,  1247,     0,  1341,     0,     0,     0,     0,     0,     0,
    1276,  1274,  1275,   808,  1327,     0,   821,   815,   813,   820,
       0,  1555,  2559,   895,  1184,     0,  1351,  1617,   999,   998,
       0,     0,  2516,     0,  2451,  2503,  2502,  2519,  2519,  2519,
    1692,  1691,     0,  1690,  1694,  1112,  1120,     0,   500,   503,
       0,   495,     0,   519,     0,   486,   563,     0,     0,     0,
    1688,  1676,  2556,  1665,  1668,  1962,  1446,  1492,     0,  2442,
    2443,  2441,  1139,     0,  1528,  1609,  1606,     0,  1599,  1601,
    1603,     0,  1956,  2378,  2358,  2360,  1035,     0,     0,  1031,
    1452,  1450,  1460,     0,  1415,  1447,  1447,     0,  1415,     0,
       0,     0,  1699,  1544,  1701,  1448,  1480,  1462,     0,  1551,
    1552,  1549,   960,     0,   892,   848,   849,   861,     0,   861,
     861,     0,     0,   943,     0,  1072,     0,   948,   787,   611,
     983,   982,     0,   612,     0,   941,     0,  1543,   481,   940,
     965,   946,  1855,   976,  1014,   829,   721,   670,   661,   745,
     664,   663,   707,   729,   675,   725,   723,   693,   725,   725,
     700,   699,   717,   703,   683,   799,   799,   682,   720,   799,
     704,   702,   706,     0,   708,   725,   713,   701,   705,   722,
     698,   695,   719,   745,   729,   729,   679,   718,   799,     0,
     711,   745,   749,   681,   799,   806,     0,     0,   745,   747,
    1967,   141,   146,   157,   158,   912,  2619,     0,  2617,     0,
    1114,  1490,   104,     0,     0,   214,   212,   213,     0,   207,
     209,   204,  2635,     0,  2642,     0,     0,  2640,   468,   470,
     478,   639,   566,     0,     0,     0,     0,     0,  1710,  1284,
     743,   741,   744,   742,   795,   794,   798,     0,   797,   806,
     730,     0,  1287,  1288,  1312,     0,  1382,  1373,  1310,     0,
    1264,  1342,     0,     0,  1319,  1294,  1297,  1295,  1300,  1301,
       0,  1326,     0,  1147,  1147,   631,  2572,  1186,  1001,  1000,
    1839,  1837,     0,     0,  2524,  2524,  2524,  2433,     0,     0,
       0,  1155,   508,     0,   525,   524,   521,  1555,  1678,  1680,
    1686,  1675,  2444,     0,  1529,  1544,   780,  1602,     0,  1149,
    1037,     0,     0,  1431,     0,  1435,  1440,  1436,     0,  1427,
    1425,     0,  1566,  1484,     0,  1555,  1550,     0,     0,   959,
       0,     0,     0,     0,     0,     0,   989,     0,  1013,   945,
     969,   991,     0,   749,  1084,  1541,   964,   966,  1060,     0,
       0,   833,   669,   662,   680,   678,   734,   724,     0,   734,
     734,   689,   707,   684,     0,   799,   697,   688,   709,   712,
     714,   716,   734,     0,   799,   677,   676,   686,   673,   734,
     757,     0,     0,     0,     0,   753,     0,   827,     0,     0,
     760,   657,   750,   752,     0,     0,   710,   799,   666,   807,
     806,   668,   799,   806,   734,     0,   748,   734,     0,   148,
     928,   317,  2621,  2629,     0,  2631,  2624,   129,  2639,  2649,
     211,     0,     0,   152,     0,   202,   787,   205,  2556,  1889,
       0,   473,     0,  1550,   890,     0,     0,  1567,   805,   803,
       0,  1385,  1550,     0,  1344,  1346,   809,     0,  1458,   632,
    2527,     0,     0,  2523,  2521,     0,  2522,  2520,  2494,     0,
    2449,  2450,  2448,  1689,     0,     0,     0,   516,     0,     0,
     550,   564,  1537,  1550,     0,  1555,     0,  1607,  1600,  1039,
    1453,     0,     0,     0,     0,     0,  1698,  1472,  1473,     0,
       0,  1478,  1482,  1463,  1548,   962,     0,   652,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   988,  1932,
     978,   482,   980,   942,     0,   947,   607,     0,   832,     0,
     837,   738,   739,   740,   690,   735,   737,     0,   692,   660,
     685,   715,   691,     0,   687,   674,   763,   764,   766,   765,
     762,   772,   755,   773,     0,     0,   767,   768,   769,   761,
     751,   759,   754,   665,   667,   671,   672,   658,     0,   659,
    1966,     0,   150,   343,     0,   329,   315,     0,     0,     0,
     319,   159,   162,   160,     0,   161,   167,     0,   168,   169,
     170,   171,   172,   163,   341,   342,   166,   164,   165,     0,
    1983,     0,  1984,  1130,     0,     0,  2627,     0,  2623,  2552,
     178,   208,     0,     0,   144,   153,  2643,   770,   471,   469,
       0,  2552,   864,     0,   889,     0,   866,   868,   728,     0,
    1387,  1262,  1328,  2500,  2499,  2498,  2495,     0,     0,     0,
       0,     0,     0,  2525,  2529,     0,  1444,  1156,     0,   509,
       0,   512,   514,   528,     0,  1683,     0,     0,  1683,  1683,
    1683,  1683,   543,   551,   553,     0,  1538,  1539,     0,  1534,
    1536,  1530,  1591,   781,  1892,  2559,  1432,     0,  1437,     0,
    1429,  1468,  1468,  1479,   961,     0,     0,   864,     0,     0,
    1934,  1933,   951,  1013,     0,   830,     0,   834,   835,   836,
       0,   828,   736,     0,   896,     0,   756,   758,   149,     0,
     142,     0,     0,   328,   331,     0,     0,   334,   324,   323,
     325,     0,   318,   317,   317,   371,   322,   368,   367,   360,
    2630,     0,  2556,     0,     0,     0,  2625,  2650,   210,  1155,
     156,     0,   475,   474,     0,  1683,   113,   865,   881,   880,
     870,  1550,     0,     0,   116,   867,   883,   874,   119,   869,
     882,   872,  1550,  2496,  2530,  2533,  2531,  2532,  2534,  2528,
    1695,  1703,     0,  1879,     0,   517,   510,     0,     0,   526,
       0,  1683,  1683,     0,     0,     0,     0,     0,   523,   552,
    1683,  1550,     0,  1138,     0,  1900,  1454,     0,     0,     0,
    1476,  1474,     0,   864,   644,   866,   868,   981,     0,   831,
       0,     0,   799,     0,   799,   151,   344,   355,   358,   350,
     330,     0,     0,     0,   320,   317,     0,   304,   302,   303,
     309,   310,   311,   312,   313,   314,   305,   308,   306,   307,
     317,     0,   219,     0,     0,  2628,  2626,     0,  2632,     0,
     188,   187,   179,     0,   317,  2636,     0,  2644,  2556,   879,
       0,   997,   871,   888,   891,     0,   997,   875,   997,   873,
    1386,     0,     0,   780,   504,   516,   513,   536,   529,   532,
       0,   561,     0,     0,   557,   558,   556,   554,   547,     0,
     545,     0,  1535,  1592,     0,     0,     0,     0,  1893,  1895,
       0,  1608,  1434,  1439,     0,  1469,     0,     0,     0,   648,
     647,   645,   646,     0,   843,     0,   842,     0,   839,   838,
     694,   897,   696,     0,     0,   317,   351,     0,   326,     0,
     335,     0,     0,   217,   374,   372,   215,   362,   362,  2633,
    2634,   189,  2651,     0,   158,   178,   476,   878,   114,   884,
     117,   120,  1702,  1704,  1880,   511,   536,     0,   534,     0,
     530,   527,   531,   559,   560,     0,   544,     0,   555,     0,
       0,     0,     0,     0,  1894,     0,     0,  1901,  1903,  1471,
    1470,  1485,     0,   967,   845,   846,   844,     0,     0,   352,
     358,   348,   356,   317,     0,     0,   316,     0,   370,   218,
       0,     0,     0,   317,     0,   361,   363,   365,     0,   140,
    2645,  1906,   533,     0,   541,   537,   539,   542,   550,   549,
     546,  1594,  1898,  1899,     0,  1896,     0,     0,  1902,     0,
       0,     0,     0,     0,   349,     0,     0,   347,   327,   332,
     317,   375,   317,   229,   228,     0,   221,   297,   369,     0,
     220,  2637,   317,     0,  1892,   535,     0,     0,   548,  1597,
       0,  1595,  1897,  1905,  1904,  1477,  1475,   841,   840,   353,
       0,   317,     0,   317,     0,   317,     0,     0,     0,     0,
       0,   216,   317,  2646,     0,  1900,   540,   538,  1593,     0,
       0,   345,   317,   333,   338,     0,     0,   224,   298,   299,
       0,   226,  2638,     0,  1908,  1596,   317,   317,   334,   337,
     376,   373,     0,   300,   222,   223,   234,   233,     0,  1907,
       0,  1912,   317,   317,   339,   242,   240,   317,   230,   238,
     232,     0,   239,     0,   227,     0,     0,  1919,     0,   225,
     241,   301,  1910,  1911,  1909,  1914,     0,     0,  1916,  1917,
       0,  1881,   231,  1918,  1913,     0,  1920,  1922,     0,  1915,
       0,  1155,  1921,     0,  1156,  1923
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -3726, -3726, -3726, -3726, -3726,   245, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726,  1977, -3726, -3726, -3726, -3726, -3726,
    2174, -3726,   877, -1784, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726,   880,  1775,  3561, -3726,   604,
   -3726,   224, -3726, -3726, -3726, -2789,   100,  -103, -3726, -3726,
     953,    18,  3247,  -102, -3169, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726,   611,   610, -3726, -3726,   416, -3726,
   -3726, -2126, -3726, -3726, -3726, -3726, -3726, -3726, -3726,  -291,
    -252,  1654, -3726, -3726, -3726,  4174, -3726,  3650, -3726, -1692,
    2399, -3726, -3726, -3726, -3726, -3726,  2464, -1646, -3726, -3726,
   -3726,  1524, -3726, -3726, -3726, -3726,  -178,   436, -3726,   437,
   -3726,   440, -3726,   441, -3726,   442,   445,   446,   448, -3726,
     450, -3726, -3726,  -249, -3726, -3726, -3726, -3726,   451, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726,  -117, -3726, -3726,    57,
   -3726, -3726,  -113,   455, -3726,   -58,   460, -3726,   461, -3726,
      39, -3726,    41, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726,  3249, -3726, -3726, -3726,
   -2229, -3726, -3726, -2039,  2792, -3726, -1756, -3726, -3726, -1815,
   -3726, -3726, -1577,  1102, -3726, -3726,  -100,  -318, -3726, -1380,
   -1847, -1846, -3726, -3726, -3726, -1920, -1889, -1390, -1389, -2132,
   -3726, -3726, -3726,   452, -3726, -3726, -2489,  1760,  2277, -3726,
   -2416, -3726, -3726,   993, -3726, -3726,  1535,   833,  1537, -3726,
    1137,  2982, -1182, -3726, -3726, -3726, -3726, -3726, -3726,   124,
     430,    32, -3726, -3420,   848, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -2328, -3726, -3726, -3726,  -143, -3726, -3726,
     -51, -3726, -3726,   -99, -3726,   255, -2260, -3726, -3726, -3726,
   -3726,  2762, -1267, -3726,  3779, -3726,  -497,   954,  1804, -2329,
   -1855, -3726,  -838,  -832, -2817, -3726, -3726, -3726, -3277,  1334,
    1373, -3726,   958,  1800, -2297, -3726,  1374, -3726, -3726,   800,
   -3726, -3014, -3726, -3726, -3726,   755, -3726,   759, -3726, -3726,
   -3726, -1557,   727, -2465,  1565,  -622, -3726,   402, -2452, -2483,
   -3726,   585, -3726,   537, -3642, -3435, -3726,  -564, -2033, -2347,
      67, -3726, -3726,   550, -2575,  1911, -3726, -3726, -3726, -3379,
   -1988,  1655, -3726, -3726,  1243, -3726, -1219,  1239, -3726, -3726,
   -3726,  1249, -3726,   148, -3726, -3726, -3726, -3726, -2699, -3726,
   -3726, -1464, -2647, -3726, -3726,  3809,  3810, -1511, -2978, -3725,
     150,   145, -3726, -3726, -3726,  2262, -1145,   210,   197,   203,
    1749,  -593,   337, -2672, -3726,   420, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726,  1534,  1833,  -739, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -2726, -2709, -3726, -3726,  1413, -3726, -3726,
   -3726, -2232, -1926, -1919, -2267,  -473, -2117, -3458, -3726, -3726,
   -3726, -3726, -3726, -3726,  2912, -3726, -3726, -3726, -3726, -3726,
    3762, -3726,  2920, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
     612,  2041, -3726, -3726, -3726, -3726, -3726, -3726,   837,  2821,
   -3726, -3726, -3726,     1, -3726, -3726, -3726, -3726,  2530, -3726,
   -3726, -3726, -3726,  2865, -3726, -3726, -3726, -3726, -3726, -3726,
    1630, -3726,  2085, -3726, -1432, -3726, -3726,  1222,  -949,  2035,
    3763,  2175, -3726, -3726,  -582, -3726, -3726, -3726, -1572, -2400,
   -3726,  3497, -1061, -2474,  2531,  -643, -1821,  1267,   648,  3586,
   -3726, -1103, -1082, -3726, -3726,  -630, -3726, -3726, -3726,  -614,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726,  1670, -3726, -3726, -3726, -3726, -1189, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726,  1348, -3726,  2270, -3726,  -453, -3726,
    3291, -3726, -3726, -3726, -2230, -1875,  1970,  1172, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -1531, -3726, -2287,
   -3726, -3726, -3726, -3726, -3726,  2188, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -1538, -3726, -2163,   321, -3726,   497, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726,    19,  1053,    23, -3430,
   -1057,  1688, -3726, -3726, -1251,  3319, -2184, -3726, -3726, -3726,
    2170, -3726, -3726, -3726, -3726, -3726,   861, -2845,  2948, -3726,
   -3726, -3135,  -867, -2208,  -853, -3726, -2282,   679, -1901, -1773,
   -2006, -1291, -2363, -3726, -3726, -3726, -3726,   -77, -3726, -3726,
   -3726,   697,  2067, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726,  -547,  -761, -3726, -3726,  2324,  2724,
   -3726,  3195, -3726, -1009,  3440, -3726, -3726,  3444, -3726, -3726,
   -3726, -3726,  3120,  3096,  2135, -3726, -3726, -2199, -3726, -3726,
    2094, -3726,   964,  -863, -1772,  1254, -3726, -3726,  1258, -3132,
   -3726, -3726,  3453, -3726, -3726, -3726,  1202, -3726,   168,  3828,
    3457, -3726, -3726, -3726, -3726, -3726, -3726,  2861, -1020,  3753,
   -3726, -3726, -3726, -3726, -3726, -3726,  2512, -3726, -3726, -3726,
   -3726, -3726, -3726,  3051,  3840,  -568, -1277, -3726,  -673,  3020,
    2515,  -847, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726,  2663,   899, -3726,
   -3726, -3726,  3110, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
    1290,    -2, -3726,   157,   -28, -3726,    82, -3726, -3726, -3726,
   -3726, -3726,   -95, -3726, -3726,   -92, -3726,  -940, -1345,   673,
   -1217, -1987, -3726,  1289,  3107, -3270,  -677, -1072, -1084, -2376,
      25, -3726, -3726,  2895,  2141,   135,  -407,  -268,    -6, -2527,
    -114,  -565, -3726, -2202, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726,  2096, -3726, -3726, -3726,  1265, -3726,  3876, -3726,
    2767,  1270,  3877, -3726, -3726, -1315,  2597,  2095,  2114, -3726,
   -3726,  2121, -2198, -3726, -3726,   178, -3726,  2660, -3726, -3726,
   -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726,  2629,  3608,  3142, -3726,  2683, -3726,
   -3726, -3726, -3726, -3726,   463, -3726,    77, -3726, -2429,  2928,
     524, -3726,  1345,  -514,  -744, -3726, -3726,   462, -3726, -3726,
     302,  3903,  3619, -3726, -3726, -3726, -3726, -3726, -2681,  -841,
   -3726, -3285, -2736, -1660, -3726, -3726, -2091, -2923, -3726, -3726,
    -991, -3726, -3726, -3726, -3726, -1969, -3726, -3726, -3726,    79,
    3965,  3969, -3726, -3726,  -175, -3726,  -390, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726,   504,   890, -3726, -3726,  3836, -3726,
   -3726, -3726, -3726,  3837, -3726, -3726, -3726, -3726, -3726,  3838,
   -3726, -3726, -3726, -3726, -3726,  1961, -3726, -3726, -3726, -3726,
   -3726, -3726, -3726, -3726
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    56,   595,  1440,    57,    58,    59,    60,    61,  1290,
      62,   806,  1215,  1740,  1741,    63,   538,    64,   993,  1511,
    1512,  2948,  2949,  1513,    65,  2061,  3347,  4231,  3348,  4236,
    3349,  4238,  1530,   508,   509,  1967,  1968,  1018,  2969,  2935,
    3789,  2939,  3942,  4080,  3984,  1987,  3315,  3790,  3791,  3951,
     533,  2059,  1460,  4107,  1947,  4222,  1948,    66,   628,   991,
    1484,  1485,  3333,  3334,  3606,  3335,  3598,  3599,  3600,  3601,
    4373,  4195,  4306,  4374,  4448,  4482,  4488,  4415,  4497,  4498,
    4499,  4486,   847,  4500,    67,   561,   562,   849,  1320,  1754,
    1321,    68,    69,   532,  1235,  1236,  1237,  1238,  2235,  1755,
    2230,  2231,  3111,  4416,  4484,  4503,  4196,  4197,  4087,  4198,
    3954,  4199,  4091,  4200,  3957,  4201,  4202,  4203,  4204,  4365,
    4205,  4086,  4408,  4192,  4193,  4367,  4464,  4479,  4206,  3964,
    4081,  4293,  3965,  4082,  4360,  4188,  4361,  4403,  4460,  4189,
    4294,  4406,  4297,  4207,  4213,  4375,  4208,  4214,  4209,  3969,
    4098,  4212,  4096,  4211,  4371,  4370,  4444,  2571,  2968,   614,
     615,   639,  2051,   616,  1007,   964,  1462,  1980,  1981,  2435,
    2436,  2553,  2554,  2555,  1972,  1973,  1974,  2039,  2040,  2041,
    1954,  1955,  1956,  1466,  1951,  1952,   617,   965,   975,  1975,
    1976,  1977,  2559,  2043,  2044,  2045,  2046,  1202,  1203,  2842,
    2577,  2978,  3808,  3344,  3991,  4228,  2979,  2980,  2923,  3270,
    1997,    70,   550,   827,  1287,  2286,  1288,  2288,  2725,  2726,
    2727,  1799,  1800,  3672,  1804,  2285,  3847,  4245,  4020,  4021,
    2729,  4019,  2733,  3136,  3137,  3432,  3674,  3850,  4250,  4148,
    4331,  4248,  4327,  4249,  4329,  4427,  4385,  4386,  4158,  4259,
    4260,  4335,  4388,  4032,  4033,  4034,  2306,  2739,  3677,  3613,
    2033,  1452,  1453,   510,   511,   512,   636,  2578,  2491,  2579,
    2580,  3292,  2493,  2494,  2695,  1375,  3283,  3257,  3653,  2975,
    2981,  2982,  2983,  2984,  2985,  3302,  3221,  2858,  2859,  2928,
    3305,  3806,  3738,  3753,  3573,  3574,  3575,  3576,  3577,  3578,
    3579,  3013,  3014,  3011,  1066,  3904,  3905,  3906,  3007,  3008,
    3787,  3771,  3772,  3773,  3807,   769,  3922,  3363,  1343,  1344,
    3857,  1354,  1355,  2330,  1840,  2331,  1456,  3364,  3365,  3366,
    3781,  3068,  3650,  3074,  3075,  3076,  2659,  2660,  2661,  2662,
    2663,  2174,  3774,  3304,  3731,  3897,  3900,  4071,  4288,  2860,
    3222,  2861,  3225,   915,   654,  2862,  2863,  2062,  2063,  4116,
    4124,  4128,  4117,  4129,  4125,  4118,  4119,  4120,  4131,  4127,
    2992,  3812,  3813,  3214,  3084,  4073,    71,  1985,   958,   967,
     963,   983,   623,  1473,   976,  1988,  2508,  3585,   604,  2495,
    3724,  3505,  3728,   126,  2496,  3236,  2497,  3492,  3709,  2498,
    3520,  3726,  3894,  3237,  3238,  2499,  2500,  2501,  3504,  3514,
    4063,  3407,  3408,  3409,  2864,   621,  2221,  3300,  2907,    72,
    1418,    73,   929,   930,   931,  2380,  2381,  2808,  3191,  3469,
     924,   925,   926,  1913,  2378,    74,   631,  1517,    75,  1298,
    2298,  2299,  2300,    76,   984,    77,    78,   632,  1524,  1525,
    1526,    79,  1283,   133,    80,   835,  1293,  1295,  1296,    81,
     627,   985,   986,   987,   988,  1993,    82,  1791,  2262,  2263,
    2264,  2265,  1481,  2510,  1482,  1483,  2002,  3129,    83,    84,
     592,  2182,   567,   853,   568,   569,  1834,  2321,  3654,   864,
     865,   866,  2767,  1333,  1334,  1335,  2326,  2772,  1063,   770,
     771,   772,   773,  1157,  1158,  3775,   774,  1167,  1701,   775,
     776,   777,   778,   779,   780,  1728,  3040,  3041,  3383,  2209,
    2210,  2211,   781,  2096,  3025,  2110,   782,  1150,  1686,  1617,
    3375,  3033,  3635,  3821,  1560,  2079,  2612,  2692,  2176,  1088,
    1089,  1053,  2086,  1566,  1920,  1921,  1922,  1923,  1924,  3480,
    3479,  3481,  3861,  3694,  3863,  3698,  2391,  1819,  1820,  1925,
    1926,  2809,  3692,  4045,  2177,  2178,  2179,  3401,  2810,  3195,
    2828,  2829,  3705,  2382,  1927,  2816,  4170,  3870,  3871,  4278,
    4277,  3872,  3703,  3704,  3485,  3486,  2944,  2945,  2946,  2753,
    1607,  1608,  1615,  1270,  1271,  1561,  2260,  2714,  3685,  3854,
    2200,  3454,  3852,  4039,  2504,  3265,  3266,  2323,  2324,  2832,
    3211,  3491,  1378,  3655,  2716,  1886,  1887,  3618,  4487,  2664,
    2526,  2843,  2282,  2283,  4163,  4339,  4430,  4431,  3166,  3167,
    3458,  3459,  2325,  2764,  3168,  3686,  4044,    85,   515,    86,
    1738,  2697,  3094,  1211,  2227,   995,  1300,  1547,  1548,   794,
     528,  1204,  1205,  1206,    87,   539,  2261,    88,   557,  1817,
     819,   839,  1301,  1302,  2307,  2740,  2747,  2308,  2752,  3442,
    2742,  3142,  3143,  2216,  2217,  2743,  3145,  3439,  3422,  3423,
    3124,  3669,    89,   580,  3206,  2823,  2824,  4140,  4141,   840,
      90,   514,  1040,  2590,  1553,  2067,  1041,  1042,  2070,   660,
     661,    91,   933,   577,  1400,  1401,  1402,  1902,    92,   571,
     916,  2794,  2800,  1881,   831,  1207,  1382,   919,  1383,  1867,
    2359,  1364,    93,   954,   953,  1447,    94,   600,  1448,    95,
     807,  1229,  1750,  2700,  3097,  3410,  1230,  1231,  2228,    96,
     558,   844,   845,  1305,  1822,    97,   552,   832,  1810,    98,
     543,    99,   100,   823,  3130,  4243,  4381,   547,  1793,  1279,
    3345,  4165,  4268,  4269,  4271,  4347,  4348,  4424,  4491,  4514,
    4507,  4517,  4518,  4521,  4526,  4527,   784,   940,   785,  3888,
     786,   787,   788,  2748,  2749,  3212,   789,  2750,   790,  3215,
     996,  1550,   536,   491,  2515,   611,   941,  2722,   792,  3971,
     961,  1011,   493,   494,   101,   570,   880,  1359,  1349,  1358,
    1860,  2347,  1864,  2349,  2350,  3180,  2790,  3181,  2791,   920,
    1856,  1861,  2792,  1865,  2786,   883,  1849,  1850,  1851,  1852,
    2783,  1846,  2356,   102,   824,   498,  1281,  1282,  2271,   103,
     579,   104,  1272,  1787,  1788,  2257,  2713,  2258,   105,   850,
    1324,   106,   809,  1264,  2246,  1265,  1763,  1266,  1267,  1777,
    1771,  1780,  1774,  4007,  3837,  3838,  2710,  1210,  1012,  1013,
    2238,  2704,  2705,  3664,  3840,  3414,  4013,  4014,   107,   134,
     501,   634,  1002,  1327,   108,   109,   110,   111,  1330,  1435,
    2317,  1436,  2183,  1437,  1438,  1934,  1832,  1682,  1683,  3082,
    1147,  1148,  2186,  2668,  2669,   867,   643,  1028,  1020,   127,
     128,   129,   646,   647,   130,   981,   982,  2509,  2941,  3317,
    3588,  3589,  3795,  3979,  3975,  3976,  3973,  3978,  1022,  3802,
    4313,  4452,  1023,  1024,  2970,  3804,  4111,  4315,  4422,  1025,
    2568,  3330,  3980,  4224,   112,   942,   589,  1433,  1428,  1430,
    1930,  2398,   113,   114
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     492,  1019,  1027,   918,  1442,  1005,   878,   914,   947,   613,
    1345,  1348,  1331,   529,  1449,  2327,  1757,   537,  2068,  2001,
    1360,   530,  2184,  1555,   490,  1644,   551,  1622,  1090,  1794,
    2281,   549,  1888,   563,  2064,  2065,   566,   556,  1379,  2540,
     563,   962,  1373,  1862,  1756,  2746,  1407,   581,   535,  1998,
    2844,  1048,  2715,  1670,   977,  2834,  2613,  1692,  2900,  2502,
    1379,  2615,   783,  2426,  1700,  1669,  2503,  1408,  2844,  2844,
    3251,  3153,  1958,  1959,  3194,  3484,  1978,  1979,  1978,  1979,
    2797,  2798,  1957,  1586,   994,   997,  1702,  1703,   602,  2986,
    1706,  1707,  1708,  1709,  2674,  1711,  1712,  1714,  1716,  1717,
    1718,  1719,  1720,  2821,  1802,  2514,  2698,  2517,  2518,  2229,
     605,  1895,   492,  2528,  2529,  2769,   492,   612,   618,   601,
    1454,  3009,  2537,  2538,  2929,  3016,  1455,  2542,  2377,  1905,
    2492,  2560,  3517,  2311,  2438,  2439,   607,  1908,  1909,   136,
     609,  2047,  2048,  1185,  2857,  3018,  3311,  1143,  1144,  1145,
    2788,  2042,  1035,  2812,  3352,  3015,  3247,  3681,  1268,  3402,
    1186,  2822,  2561,  4006,  2401,  2402,  3741,  3746,  1152,  1153,
    3747,  2171,  1424,  1970,  3070,  3779,  2866,  2052,  3748,  3252,
    2870,  2413,  2219,  2844,  2844,  1935,  2801,   499,  3223,  3757,
    1797,  2885,  3625,  1808,  3079,  3778,  1733,  2592,  2431,  2432,
    2929,  1152,  1153,  2896,  2557,  2558,  2852,   548,   633,   624,
    2670,  2904,  4114,   555,   937,  3359,  3226,  2434,  3706,  1514,
    3359,  1391,  1778,  2795,  3070,  2549,  2820,  3360,  1451,   885,
     869,  2505,  3360,  1152,  1153,  3095,  1451,  1209,  1152,  1153,
    3379,  3361,  1409,  1451,   115,  3498,  3361, -2561,  1152,  1153,
    1392,  2988,   885,   869,  1021,  1029,   541,   885,   869,  -901,
    3890,  1130,  2322,  2544,  2545,  2546,  2547,  -567,   998,  1294,
    3176,  3865,  2665,   544,  -568,  1420,  3501,  3115,  2243,  1853,
    3071,  2442,  1431,  1152,  1153,   955,  3032,  1268,  3876,  3663,
   -1521,  3572,  1200,  1578,  1269,   812,  1016, -2497,  1393,  2848,
    2849,  1970,  1394,  4103, -2346,  2817,  3679,  1277,  3926,  4512,
    4114,   625,  2574,  4104,  1152,  1153,  2818,  1362,  1847,  1008,
     927,  2914,  3927,  1152,  1153,  3595,  2933,  4114,  3158,  3921,
    3071,  1843,  4174,   648,  3596,  3831,  2233,  1989,   657,  3141,
    4108,  1558,  1558,   565,  1152,  1153,  1274,  2905,  1015,  1854,
    2965,   135,  2793,  2837,  1558,   117,  1070,  1844,  2319, -2561,
     131,  3831,   573,  1152,  1153,  3822,  3910,  1000,  2084,  1380,
    3192,  1384,  1536,  1537,  1538,  3914,  1953,  1190,  2415,  1152,
    1153,  1539,  2087,  2780,  1152,  1153,  3217,  4115,   938,  2395,
     638,  4180,   545,  4345,   922,  3413,  1585,   658,  3933,  4295,
    3851,   980,  1999,  3935,  2781,   640,  2999,   135,  3001,  2115,
    1090,  1540,  2172,  3853,  2953,  2954,  3619, -1719,  1381,  1535,
    1152,  1153,   800,  1269,   815,  3193,  4346,  2000,  3873,  3209,
   -1797,  4295,  1377,  3359,   574,  1131,   626,  1477,  2782,  2234,
    1307,  1071,  1389,  1289,  2763,  3360,  1001,   132,  4280,  1152,
    1153,  1395,  1990,  1017,  1152,  1153,  2966,  2762,  1971,  3361,
     911, -1719,  1515,  1425,  1559,  1574,  2934,  2069,  2838,  4227,
     885,  3742,  1034,   923,  1152,  1153,  3597,  1629, -2346,  1197,
    1535,  1152,  1153,  1775,  1432,  4115,  1928,  3273,  1857,  4076,
    3229,  2244,  1848, -2613,  3233,  2830,  2148,  2219,   612,   618,
    3723,   629,  4115,  4513,  1953,  2915,  3928,  1278,  3249,  3250,
    3218,   956,   928,  2819,  1845,  2960,   618,  2163,  3832,  3712,
    3263,  4105,  1421,  3988,  1152,  1153,  1154,  1396,   810,  1155,
    3198,   659,   612,  1697,   820,  1890,  3843,   957,  1893,  3380,
    1201,  2344,  2467,  1897,  3832,  1189,  3148,   833, -1521,  2929,
    3497,  1152,  1153,  3499,  3500,  1855,  1758,  1705,  1152,  1153,
    1152,  1153,  1329,  3217,   879,  1958,  1959,   999,  1579,  1910,
    1911,  3874,   934,  3496,  1726,  1957,  1152,  1153,  3162,  3163,
    2220,  1152,  1153,  1978,  1979,  1933,  1971,   542,  2438,  2439,
     951,  1154,  1397,  1476,  1155,  2844,  1154,  1152,  1153,  1155,
     612,  2437,   966,  1569,  1570,  4177,  1154,  3072,  1757,  1155,
     642,  1341,  2950,   612,  1454,  3502,   492,  4167,  2506,  4168,
    1455,   602,  3213,   992,  1610,   602,   602,  2245,  2201,  2370,
    1006,   966,  1200,  1624,  2560,   612,  1756,  2492,  3702,  2204,
     979,  1154,  2207,  1542,  1155,  1637,  1638,  1639,   813,  3833,
    2047,  2048,   989,  1643,  1043,  3199,  3200,  3072,  3346,  3096,
    2042,  2562,  2563,  1363,  1736,  2561,  3656,  3436, -1997,  2796,
    2865,  2556,  1154,  2868,  2869,  1155,  2871,  2850,  3994,  2874,
    2875,  1154,  1516,  2878,  1155,  1199, -1521,  4000,  2887,  3417,
    3418,  3419,  1454,  2891,  2892,  2893,  2894,  2895,  1455,  1091,
    3080,  2899,  1154,  2901,  1398,  1155,   805,  2557,  2558,  2910,
    2911,  2912,  2913,  2198,  2998,  2917,  3749,  2919,  4040,  3339,
    1779,  1154,  1809,  2215,  1155,  1033,   939,   825,  3219,  4132,
    3449,  3450,  3451,  2955,   836,  3487,  1796,  1154,  3446,  1907,
    1155,  2053,  1154,  1016,  1399,  1155,  -901,  3626,  4123,   851,
    2906,  1815,  1798,  2770,  -567,  2030, -2497,   935,  4283,  1346,
    1149,  -568,  1151,  1351,  1356,  3177,  1516,  1935,  4161,  3860,
    3362,  1156,  2952,  1132,  3006,  3362,  1376, -1521,  1154,  3073,
    2958,  1155,  1842,  2851, -2497,   546,  2173,  1917,  1194,   492,
    1196,   966,   492,   612,  3727,   492,   612,  3720,  1212,  3776,
     911,  3835,  1239,  4290,  1156,  4292,  4469,  1154,  1273,  2967,
    1155,  3834,  1154,  1195,  3351,  1155,  1198,  4216,   602,  1208,
    2581,  1894,  3711,  1385,  1152,  1153,  3326,  3835,   612,   602,
    2085,  3006,  1154,   602,  2720,  1155,  1156,  2846,  1441,  1154,
    3855,  1156,  1155,  2582,  2811,  1152,  1153,  1366,   980,  1280,
    4181,  1156,  1152,  1153,  2187,  1677,  1678,  2094,  1152,  1153,
    1297,  4187,  3231,  2827,  1303,  1677,  2114,   612,  3091,  1871,
    3510,   612,   612, -2134,  1152,  1153,  1152,  1153,  1152,  1153,
    1201,  1412,  1154, -1521,   612,  1155,  1156,  2746,  3261,  3262,
    1152,  1153,  1937,  4359,  1390,  2220,  3508,  4284,  1152,  1153,
    1017,  2095,  1152,  1153,  3220,  1983,  1367,  1776,  3133,  1154,
    3474,  2433,  1155,  1953,  3478,  3836,  1154,  1156,  1154,  1155,
    3327,  1155, -1824,  1152,  1153,  1187,  1156,   602,  3301,  4036,
    4037,  2152,  2153,  3721,  1154,  1342,  1368,  1155,  4221,  1154,
   -2613,  2149,  1155,  4316,  1152,  1153,   612,  1156,  1450,  1918,
    2120,  3443,  4038,  1919,  3452,  1154,  1152,  1153,  1155,  3298,
    2337,  2164,  3138,  1291,   590,  2929,  1156,  3473,  3232,  2191,
    3234,  3477,   602, -2156,  2295,  1152,  1153,  3245,   602,  2333,
    2076,  3463,  1156,  2599,  4330,  1232,  4233,  1156,  3362,  1152,
    1153,  3258, -1997,   564,  2884,  2502,  2857,  4240,  3269,  2348,
    2115,  2088,  2503,  1472,  2438,  2439,  3707,  3645,  3743,  3570,
    3285,  3287,  3289,  3355,  3985, -1969,  3290,  1888,  1888,  3682,
    1377,  3187,  3483,  1156,  1958,  1959,  4262,  2885, -1824,   602,
    1544,  1545,  1546,  1551,  1957,  2366,  1687,  2630,  2075,  2560,
    1949,  1200,  2058,  1978,  1979,  4355,  3734,   137,  2364,  1379,
    1152,  1153,  1156, -1797,  2594,  2437,  2229,  1156,  2369,  2931,
    1543,  2372,  2373,  3156,  1549,  2400,  2492,  1091,  3735, -1797,
    2561,  2169,  2170,  1725,   495,  3732,  3733,  1156,   619,  1379,
    3754,  1091, -2274,  3015,  1156,  2208,  3015,  3015,  3759,  1152,
    1153,  2679,  2680,  2678,  2802,  3784,  1152,  1153,  2092,  3755,
    3756,  3470,  2314,  3015,  2734,  3244,  4084,  2971,  2932,  2206,
    4323,  2268,  2557,  2558,  3051,   829,  1416,  3758,  3253,  2989,
    1759,  3809,  3777,  3780,  3782,  3783,   591,  1156,  2929,   500,
    3299,  1671,  1931,  3511,  1680,   651,  2295,  1152,  1153,  1970,
    3342,  3029,  3030,  1953,   612,  2683,  2684,   531,  1758,  1369,
    2184,  4264,  2192, -1997,  1156,  2274,  1341,  2362,  2047,  2048,
   -2561,  1156,  4265,  1156,  2562,  2563,  1152,  1153,  2042,  2093,
    2218,  3355,  -472,  3356,  2556,  1807,  2100,  3400,  2101,  1156,
    1805,   612,  1154, -1481,  1156,  1155,  1729,  1347,  3695,  3696,
    1950,  2223,  2730,  3036,  3037,  1417,  1454, -2134,  3053,  3054,
    1156,  4285,  1455,  1154,  2677,   602,  1155,  2338,  2239,   911,
    1154,  4221, -1825,  1155,  2687,  2107,  1154,  2296,  1413,  1155,
   -1481,  1670,  1152,  1153,  1806,  2972,  1404,  1091,   612,  1152,
    1153,  3987,  1154,  1188,  1154,  1155,  1154,  1155, -1824,  1155,
    1152,  1153,  3342,  1169,  1152,  1153,  2291,  2292,  1154,  2269,
    3708,  1155,  1152,  1153,  3357,  1200,  1154,  1152,  1153,  1155,
    1154,    13,  2313,  1155,  1783,  4085,  1786, -1824,   602,  1152,
    1153,  1200, -2561,  1152,  1153,   575,  1518,   602,  1152,  1153,
    2990,  1154,  4356,   612,  1155,  1370,   814,  3127,  1970,  1201,
    1152,  1153,   602,   602,  3393,  4286,  1681, -2156,  4106,  1303,
    1152,  1153,  1154,  4326,  3164,  1155,  1371,  1693,  1670,  4166,
    4113,  1152,  1153, -2426,  1154,  2315,  1611,  1155, -1825,  1612,
    2825,  1829,  1152,  1153,  1303,  4287,  1152,  1153,  1064,  1837,
    3629,  3356,  1838,  1154,  2474,  3817,  1155,  1152,  1153,  1003,
    1004,   612,  1953,  1152,  1153,  1939,  1372,  1154,  3595,  1414,
    1155,  1858,   879,  3811,  1152,  1153,   540,  3596, -2134,  2193,
    3343,   492,   492,   492,   602,   492,   602,    25,  2180,  1152,
    1153,  1889,  1415,  2091,  1189,  2194,  4266,  1891,   492,  2296,
     612, -1824,  2477,   492,   830,  1872,  1873,  1874,  4067,  1876,
    1519,  2297,  1152,  1153,  1520,  1875,  3867,  1877,  3224,  3224,
    1134,  4534,  1892,   602,  1878,  1521, -2274,  1896,  1154,  2973,
    1790,  1155,  3368,  1152,  1153,  1152,  1153,  1152,  1153,  1721,
    4088,  4089,  2950,   911,  1971, -2426,  1268,  1156,  2363, -1824,
     553, -2427,  2388,  3868,  1906,   576,  1152,  1153,  1172,   911,
     652,  3088,  3089,   578,  4338,  1558,  2270,  1154,  1156,    43,
    1155,  2245,   593,   612,  1154,  1156,  3203,  1155, -2156,  3489,
     641,  1156,  3343,  2112,   612,  3358,  1879,  3507,  4093,   602,
    2113,  2437,  1994,   602,  1558,  4062,  2116,  1156,   802,  1156,
    1342,  1156,  4289,  3659,  1003,  1004,   594,  1152,  1153,  3658,
    1694,  1953,  2128,  1156,  2135,  1154,  2139,  1868,  1155,  3597,
    1991,  1156, -1521,  1201,  1996,  1156,  4449,   834,  2140,  4043,
     602,  1917,  1152,  1153,  2974,  1830,  2142,  1152,  1153,  1201,
    2143,  1152,  1153,   653,  1154,  4450,  1156,  1155, -1825,   612,
    2181,   492,   492,  1405,  2060,   492,  1522,  2991,  1757,   837,
    2319,  2147,  3165, -2427,  2212,   513,  1043,  1156,  2074,  4267,
    3990,   527,  2213,  2297,  1917,  2056,  2057, -1825, -1521,  1156,
    1187,  3052,  1269,  1152,  1153,  3490,  1756, -2274,  1633,  2562,
    2563,  3000,  3254,  1971,  2165,   841,  3208,    37,  1156,  2556,
    1154,  2921,  3087,  1155,  4068,  2682,  2320,  1154, -1481,  3972,
    1155, -1521,  1156, -1521,  3818,  1152,  1153,  1657,  1154,  1516,
    1969,  1155,  1154,  2765,  3793,  1155,    43,  3034,  1458, -1521,
    1154,    55,   603,  1155, -1521,  1154,  1152,  1153,  1155,  1200,
    2564,  1091,  2121,  3358,   606,  2224,  1722,  1154, -1521,  4094,
    1155,  1154,  1122,  1523,  1155, -1521,  1154,  2301,  1831,  1155,
    3793,  3819, -1521,  2617,  1152,  1153,  3255,  4042,  1154,  1880,
    1723,  1155,  2199,  1156, -1521,   596,  1670,  2624,  1154,  -472,
     608,  1155,  2657,  1152,  1153, -1521,   620,  2102,  3144,  1154,
   -1521, -1825,  1155,  1918,   622,  1152,  1153,  1919,  4274, -1521,
    1154,  3204,  2190,  1155,  1154,  4069,   842,  1155,  2658,  2766,
    2639,   117,  1156,   560,  2720,  1154,   838,  1695,  1155,  1156,
     560,  1154,  4437,  4438,  1155,   629,   816,  3035,  1152,  1153,
    1152,  1153,  1154,  1696,  3046,  1155,  1918,  1123,  1126, -1825,
      52,  1152,  1153,  4275,  2214,  2332,  1931,  1154,  3901,   612,
    1155,   602,   602,   612,  1181,  1182,  1183,  1184,  1048,  3430,
    1156,  1960,  2184,   630,   602,  3972,  3972,  3256, -1521,  1239,
    1154,  3827,  -206,  1155,  1239,  3056,  3224,   633,  1539,  2693,
    1613,   843,  2222,  1614,  1152,  1153,  3794,   612,    55,  1156,
   -2426,  1154, -1521,  1154,  1155,  1154,  1155,  2565,  1155,   635,
    4376,  4376, -1521,  3431,  3057,   602,   878,   911,  1541,   602,
    2844,  2844,  3934,   817,  1154,  3936,  2937,  1155,  4095,  3810,
   -2426,  3869,  3974,  1127,   649,   612,   612,   602,   602,  1152,
    1153,  2938, -1521,   637,  1670,  1724,  2266,  1152,  1153,  1091,
    1280,   612,   506,  2569,  3902,  1156,  3267, -1719,  1152,  1153,
    2884,   804,  1156,   612,  1152,  1153,  1152,  1153,  1297,  2294,
    3639,  2301,   793,  1156,  2570,  1154,  2103,  1156,  1155,  1961,
     879,  4276,  4008,  1516,  3396,  1156,  3005,  2111,  3398,  1970,
    1156,  2124, -1521,   818,  3903,  2361,  1862,  1201,  1188,  2125,
    1154, -1719,  1156,  1155,  2129,  1154,  1156,  2593,  1155,  1154,
    1284,  1156,  1155,  1285,   797, -1521,  2133,  2581, -2427,  3917,
    2134,  3972,  3972,  1156,   496,  2138,   808,   497,  2212,  4060,
    4061,   602,   822,  1156,  1152,  1153,  3173,  2141,   811,  2035,
    2582,  1331,  3918,  2383,  1156,  1152,  1153,  2144, -2427,  4328,
     602,  1154,  4332,  3179,  1155,  1156,   826,  3182,  2156,  1156,
     828, -1521,  2371,  3183,  3875,  2550,  1152,  1153,   846,  2566,
    1156,  1379,  3471,  2175,  2290,  3353,  1156,  1379,   256,  3919,
     258,  2394,  4023,  1154,  3003,  3184,  1155,  1156,  4009,  4010,
    3022,   848,  3207,  4011,  4012,  2303,  2304,   838,  4210,  3370,
    3371,  3028,  1156,  4024,  1154,  1346,   496,  1155,  3736,   497,
    1346,  3739,  3740,  1493,  1494, -1521,  3031,   949,  3714,  3715,
    2649, -1797,  3385,  3972,  2089,  1156, -1521, -1521,  3752,  4318,
     950,  2357,  1154,  3147,  4320,  1155,  4321,  2552,  3972,  3038,
     814,  1970,  1152,  1153,   952, -1521,  1156, -1521,  1156,  1962,
    1156,  1154,  3972,  2521,  1155,   554,  1152,  1153,  1963,  1970,
    3042,  1286,  3043,  1154,  3044,  1964,  1155,  2090,  1189,  1156,
   -1521, -1521,   968,   612, -1521, -1521,   959,   612,  2208,  2567,
    1152,  1153,   492,  3045,  2384,  4425,  3750,  2108,  1189,  3751,
    2588,  2035,  1953,  2591,   978,  1953,  1154,  1670,  1154,  1155,
     980,  1155,  1467,  1468,  2675,  2404,  2572,  1009,  1758,  1154,
    2117,  1189,  1155,   612,  2411,  2412,  1970,  2522,   612,  1010,
    1156,  2603,   990,  3972,  1014,  2416,  2417,  2418,  2419,   115,
    2427,  2428,  2035,  2696,  3047,  3972,  3972,  1036,  4135,  4136,
    4137,  4138,  1533,   969,  1037,  1156,  1038,  2604,  1045,  1765,
    1156,  1670,  1154,  1046,  1156,  1155,  1509,  1510,  2854,  3050,
    1965,   885,   869,  2825,  3055,   939,  2035,  1192,  3058,  1047,
   -1797,  1936,  2516,  1049,  1971,  2516,  2516,  1050,  2516,  2035,
    1051,  2516,  2516,  2516,  2516,  2516,  2516,  2516, -1797,  2552,
    2516,  3972,  2516,   970,  1054,  2605,  1156,  1154,  2606,  4363,
    1155,  3972,  3140,  2118,  1627,  1154,  2607,  1055,  1155,  3291,
    3060, -1797,   612,  2523,  2036,  2651,  1154,  2385,  1056,  1155,
    1200,  1189,  1154,  1200,  1154,  1155,  4144,  1155,  1156,  2653,
    1766,  2130,  1189,  3319,  1057,  1767,  2386,  2694,  3972,  2196,
    3972,   612,  3062,  1058,  1953, -1797,  1059,  2387,  1060,  1156,
    3972,  2035,  2131,  1189,  1061,  1966,  2685,  3086, -1797,   885,
     869,  2703,  1953,  3064,  2552,  2132,  1189,  2709,  2709,  3972,
    2709,  3972,  2881,  3972,  1062,  4145,   971,  1156,  1768,  2854,
    3972,  1065,  3581,  4150,  1275,  1953,  4153,  4154,  4155,  4156,
    3972,  3065,  1154,  1769,  2524,  1155,  1156,  2728,  2708,  2708,
    1193,  2708,  1888,  1154,  3972,  3972,  1155,  1067,  1156,   854,
    3066,  3438,  1999,  1102,  4443,  1214,  4445,  2332,  1346,  1953,
    3972,  3972,  3390,  1276,  1154,  3972,  1971,  1155,  2240,  2751,
    2388,  2241,  1953,  2754,  2242,  1121,  1068,  2000,  2709,  2709,
    2709,  1156,  3243,  1156,  1971,  4462,  1169,  1069,  1135,  1136,
    2774,  2711,  2776,  2712,  1156,  3391,  1292,  3392,  1169,  4317,
    3000,   854,  2136,  1189,  2429,  2430,  2036,  1304,  3634,  2708,
    2708,  2708,  1200,  4230,   879,  1169,  2667,  1189,  3048,  1189,
    4492,  4493,  1072,  1670,  3113,  3114,  1889,  1889,   911,  1073,
    1200,   911,  1074,  2881,  1075,  3144,  1591,  1156,  3150,  3151,
    1154,  1971,  1306,  1155,  1953,  1076,   582,  2036,  1077,  4252,
    4253,  3638,  4256,  1200,  1154,  2184,  1671,  1155,  4261,  1078,
    1518,  2758,  2759,  2760,  1079,   612,   612,  1562,  1563,  1564,
    1080,  2608,   855,  1999,  1081,  4051,  4052,  3154,  3155,  1575,
    1082,  2036,  1156,  1085,  2389,  2275,  2441,  1200,  3322,  3323,
    1156,  2442,   583,  2443,  2036,  2444,  3644,  1086,  2000,  1092,
    1200,  1156,  1670,  1332,  3636,  2445,  2446,  1156,  1201,  1156,
    1630,  1201,  2301,  1634,  3267,  3646,  3404,  1189,  4477,  4478,
    2302,  3647,  2037,  3648,   855,  1268,  3433,  3434,  1093,   972,
    2883,  2773,  3586,  3587,  1653,  1654,  2447,  1595,  1658,  1094,
    2448,  2449,  2414,  3622,  3631,  2525,  2450,   856,  1095,  2276,
    2916,  3640,  1189,  2390,  2451,  4143,  1672,  1673,  3657,  1189,
    1096,  3503,  2452,  1097,  2930,   584,  2036,  1098,   687,  2037,
    3889,  2453,  1200,  1099,  1519,  2947,  1100,  1156,  1520,  1103,
     911,  1172,  3667,  3668,  1326,   256,  2454,   258,  1156,  1521,
    1329,  3649,  1104,  1172,   973,  3515,   974,  1105,   911,   856,
    1451, -1521,  3877,  3519,  2455,  3797,  2430,  3521,  1337,  1156,
    1172,  1106,  2456,  2457,  2609,   943,   944,  3889,   945,  2458,
     946,   911,  1338,  4001,  2275,  3992,  3993,  2459,  3996,  3993,
    1107,  -931,   692,  2460,  1108,  2882,  2303,  2304,  1109,   602,
    2930,  2037,  1596,  1110,  2461,  2839,  1599,  1111,   602,   602,
     602,  2883,  1112,  1600,  3378,   911,  1113, -1521,  2420,  1114,
    1201,  1269,  3828,  3829,  2462,  1115,  3196,  1116,   911,  1169,
    2976,  1117,  2038,  2420,  2305,  1118,  3268,  1119,  1201,  2994,
    2995,  2996,  2610,  1120,  -653,  1156,   878,  1124,  2276,  4025,
    1940,  2959, -1521,  2384,  2854,  1125,  3277,  1128,  3278,  1156,
    1129,  1201,  1133,  2463,  1941,  2464,  3405,  2855, -1521,  1137,
    2611,  1138,  2465, -1521,  3997,  3993,  2277,  4050,  3155,  2038,
    1522,  4026,  2421,  4054,  3434,  1139,  2840,  1140,   704,  2466,
    3760,  1141,  2548,  1601, -1521,  1201,  1357,  2421,  1142,  3279,
     911, -1521,  1191,  1174,  1175,  4057,  3993,  1361,  1201,  2951,
    2422,  1365,  2467, -1521,  4065,  4066,  4146,  4147,  3602,  1377,
    1174,  1175,  3280,  1386, -1521,  2422,  1239,  1388, -1797, -1521,
     612,  2137,  1387,  3761,  4172,  3993,  1406,  3762, -1521,  3763,
    4173,  3993,   602,  4535,  2278,  4175,  3993,  1403,  2468,  1603,
    1410,  2038,  4176,  3993,  4182,  4183,  4184,  4183,  1411,  3281,
    2728,   612,  4272,  3155,  1671,  2275,  2469,  1419,  -653,   720,
    2470,  4273,  3155,  3126,   651,  1422,   585,  1523,  2423,  1091,
    1201,   612,  4336,  4337,  1423,  3764,  2385,  4353,  3434,  -653,
    4382,  4383,  1426,  2423,  2730,  3172,  4436,  3321,   586,  2854,
    4027,   857,   858,  2696,   860,  2386,   862, -1521,  1999,  1427,
    2471,  1429,  2855,  2384,  1434,  2472,  2387,  1439,   115,  4524,
    4525,   863,  2473,  1451,  1172,  2279,  3627,  2474,  1942,  2276,
    2475, -1521,   587,  2000,  1459,  1179,  1180,  1181,  1182,  1183,
    1184, -1521,  1660,  1661,  1457,  1177,  1178,  1179,  1180,  1181,
    1182,  1183,  1184,   857,   858,   859,   860,   861,   862,  2424,
    1461,  2476,  1177,  1178,  1179,  1180,  1181,  1182,  1183,  1184,
    1169, -1521,  1464,   863,  2424,  2477,  2478,  2479,  2480,  2930,
    1465,  4126,  4130,  4028,  2930,  1469,  1604,  3216,  1470,  3228,
    2930,   588,  4254,  4255,  2930,  2420,  3239,  2841,  3230,  2388,
    2481,  4029,  1606,  1471,  3240,  1943,  3239,  1474,  2930,  2930,
     116,   612,  3239,  -653,  1475,  -826,  1478,  3260,  1168,   651,
    2930, -1521,  1671,  3693,  4030,  2839,  3455,  3456,  3264,   117,
    1944,   602,  1479,  3272,  3665,  3666,  3171,  2077,  1480,  3275,
    3276,  1527,  3239,  1528, -1521,  2420,  2385,  1529,  3284,  2930,
    3297,  3841,  3842,  1999,  1532,  1534,  2482,  2483,  2484,  2421,
     492,  1670,  3274,  2485,  3316,  2386,  3239,  1554,  3185,  3186,
    2856,  3188,  1216,  4142,  1174,  1175,  2387,  1535,  2000,  2486,
     749,  3325,  2487,  1187,  3312,  2420,  -653,  2422,  3286,  1552,
   -1521,  1558,  1945,  1565,  3336,  1577,  1616,  4074,  1580,   118,
     559,   602,  1626,  4074,  3282,  2488,  2840,  2122,  1627,  2421,
    4126,  2126,  1628,  2389,  4130,  1651,  1003,  1004,  2489,   666,
    1668,  3350,  3765,  1169,  1679,  1688,  1704,  1710,  -952,  1730,
    3766,  1732,  3338,  1734,  1735,  2150,  2280,  2422,  1737,  3241,
    3242,  1739,  1742,  1743, -1521,  1744,  1745,  1746,  2420,  2421,
    1747,  3288,  3815,  3816,  1748,  2423, -1521,  1749,  3846,  2388,
    4126,  4130,  1760,  1761,  1762,  1172,  3271,  1217,  3767,  1764,
    2425,  1770,  1772,  1773, -1521,  1781, -1521,  2422,  -931,   652,
     119,  1782,  2390,  3460,  1792,  2425,  1946,  1795,  1803,  1493,
    1494,  1811,  1218,  1812,  3883,  1813,  1219,  1814,   911, -1521,
   -1521,   687,  1818, -1521, -1521,  2423,  1821,  3403,  1159,  1160,
    1825,  1824,  2421,  1827,  4031,  2774,  1177,  1178,  1179,  1180,
    1181,  1182,  1183,  1184,  1828,  1170,  1833,  3328,  1839,  2384,
    1863,  -653,  1866,  1220,  1870,  1899,  2424,  1898,  2703,  3768,
    2422,  1273,   612,   612,   612,  2423,  1161,  3908,  3909,  1171,
    3880,  1221,  3856,  1900,  1901,  1903,  2728,  1162,   691,  1346,
    3912,  1912,  -653,  1915,  1929,   692,  1938,  3915,  1331,   120,
    1984,  1986,  1516,  2389,   121,  2751,  3445,  2003,  2005,  3447,
    1331,  2004,  2006,   612,   612,   612,  2424,  1670,  3769,  2029,
    2031,   612,  3937,   697,  2007,  3939,  1163,  2694,  2008,  4142,
    2009,  2010,  2011,  2012,   879,   879,  2013,  1164,  2423,  2014,
    2015,  2016,   122,  1222,  2017,  1174,  1175,  2841,  1172,  2018,
    2019,  2020,  2021,  2022,   652,  2023,  2424,  2024,  2025,  1671,
    2026,  2027,  1509,  1510,  1165,  2028,  2049,  2066,  1003,  1004,
    2050,  2055,  2390,  2078,  3770,  2080,  2930,  2072,  2081,  2930,
    2930,  1169,  2082,  2097,  3239,  2098,  2773,  2099,  2104,  2105,
    2106,   704,  2385,  2109,  2115,  2119,  2154,   612,  2123,  2127,
    2930,   795,   796,  4291,   798,   799,  2145,  4387,   801,  1346,
     803,  2386,  2146,   123,  2155,  2151,  2166,  2167,  3239,  2424,
     516,  2168,  2387,  2189,  2185, -1225,  3239, -1347,  1166,  2195,
    3239,  2445,  2446,  2374,  2375,  2376,  1184,  -653,   666,  4242,
    1070,  2205,  4035,  1122,  1173,  4055,  4056,  2225,  4058,  4059,
    2236,  1126,  3524,  2237,  2267,   602,   715,  2259,  2273,  2284,
    3580,  2287,  2312,  2309,  -791,  -791,  2448,   718,  2334,  2335,
    2358,   719,   720,  1223,  -791,  2947,   124,  2425,  -952,   517,
    2451,  2328,  1224,  3039,  3466,  2336,  3525,  2339,  2452,  1179,
    1180,  1181,  1182,  1183,  1184,  2930,  2340,  1225,  1174,  1175,
    2445,  2446,  2360,  3687,  4387,  2388,  2341,  2365,  2379,   518,
    2342,  1176,  2454,  3883,  2343,  1226,  2393,   612,  2392,  2396,
     687,  2397,  2399,  2405,   125,  2406,  1451,  2425,  2407,  3697,
    2455,  2403,  2408,  -791,  -791,  2448,  2410,  2409,  2440,  3509,
    2507,  2511,  -952,  -791,  2551,  2513,  2573,  2584,  3513,  2451,
    2589,  4100,  2585,  2597,  2602,  2593,  2586,  2452,  1227,  2460,
    4392,  4393,  2619,  4395,  2618,  2620,  2213,  2425,  2631,  2701,
     791,  2632,  1169,  2644,  2666,  2673,  1172,   691,  2706,  2681,
    2690,  2454,  1670,  2691,   692,  2702,  3675,  2718,  1228,  2721,
     519,  1671,  2723,  2724,  4519,  1451,  1670,  2731,   791,  2455,
    2732,  1670,   612,  1798,  2735,  2736,  1670,   496,  4528,  3583,
     497,   612,   697,  4519,  4432,  2737,  4433,  4434,  4528,  2389,
    2741,  2755,  2756,  2757,  2320,  4035,  4225,  2319,  2460,  2778,
    2425,  2464,  3607,  2779,  1847,  1848,  1940,  4223,  2465,  2789,
    1177,  1178,  1179,  1180,  1181,  1182,  1183,  1184,  2930,  2799,
    1941,  2803,  2804,  2805,  2806,  2466,  2807,  2813,  2930,  2814,
    3239,   741,  2815,  2831,  2835,  3884,  2836,  2853,  3885,  2854,
    1671,  2876,  2867,  1346,  3239,  2872,   602,  2873,   747,   120,
     704,  2877,  2880,   749,   121,  2879,   750,  2886,  2390,  1213,
    2888,  4220,  2890,  4489,  2889,  2897,  2898,  2902,  2903,  4504,
    2464,  2908,  2909,  2918,  2248,  2936,  2940,  2465,  2942,  2956,
    2957,  2962,  2963,  2961,  2468,  2997,  2964,   -64,  2073,  2474,
     791,  3006,   520,  3017,  2466,   791,  1174,  1175,  2249,  3010,
    3019,  3012,  2469,  3020,  3460,  3021,  3023,  2575,  3024,  3886,
    3887,  3792,  2250,  3067,  3077,   715,  3078,  3123,  1587,  1588,
    1589,  1590,  1591,  2251,  3081,  3083,   791,  3085,  3090,  3336,
     719,   720,  3690,  3093,  3121,  3118,  3116,  1172,  3814,  3814,
    3814,  1889,   791,  1308,  3117,  1169,  3119,  3120,  3128,  3131,
    1284,   612,  1309,  2468,  3132,  3135,  3146,  3149,  2473,  3152,
    3157,  3159,  1310,   521,  3160,  3161,  2475,  3169,  3178,  3189,
    3174,  2469,  2252,  2253,  1311,  1312,  1313,  2332,  3170,  3190,
    3197,  3201,  3202,  3098,  1942,  3246,   791,   791,   791,   791,
    1314,  3248,  3099,  3306,  3307,  4531,  3175,  3310,  3313,   791,
    2254,  3314,  3100,  3205,  3318,  3331,  3332,  3320,  3337,  3856,
    3324,  2301,   612,  3321,  3101,  3102,  3103,  3340,  1931,  3341,
    1592,  1593,  1594,  1595,  3369,  2754,   522,  2473,  1240,  1241,
    3104,   523,  3367,  3373,  3374,  2475,  2481,  3814,  1177,  1178,
    1179,  1180,  1181,  1182,  1183,  1184,   602,  3381,  3382,   524,
    3394,  2172,  3072,  3411,  3898,  3893,  3415,  3424,  3426,  3798,
    3429,  1943,  3437,  3435,  3448,  3453,  3461,  2255,  3467,  3468,
    3475,  3476,  1346,  3488,   525,  3493,  3494,  3891,  3495,  3506,
    4223,  3512,  3516,  1003,  1004,   612,  1944,  1174,  1175,   526,
    3523,  3522,  2482,  2483,  2484,  2505,  3584,  3590,  3582,  2485,
    3604,  3608,  3603,  3605,  3594,  2481,  3612,  3609,  3614,  3615,
    1242,  3617,  3940,  3616,  3624,  2486,  3620,  3628,  2487,  3642,
     741,  2256,  3621,  3622,  3884,  3982,   602,  3885,  1596,  3623,
    1597,  1598,  1599,  3630,  3641,  3643,  3632,   747,  3652,  1600,
    1172,  1243,   749,  3633,  2467,   750,  3637,  3651,  1945,  2442,
    4035,  3660,  3661,  3662,  2489,  1244,  3859,  3983,  3670,  1152,
    1153,  2482,  2483,  2484,  3671,  3668,  3680,  3173,  2485,   602,
    3683,  3684,  4022,  3688,  3689,  3691,  3701, -1433,  1245, -1438,
     612,  1246,  4501,  3713,  2486,  3716,  3717,  2487,  3722,  3730,
    3785,  3737,  3779,  3788,  1247,  3800,  3799,  3820,  3886,  3887,
    4016,  3824,  3814,  3814,  3825,  3814,  3814,  3826,  4501,  1315,
    2987,  3839,  3830,  3844,  3845,   791,  1248,  3848,  4533,  1601,
    3849,  3862,  3878,  2489,  3864,  3899,  1316,  3879,  3920,  1177,
    1178,  1179,  1180,  1181,  1182,  1183,  1184,  3881,  3776,  3911,
    3924,  1249,  1946,  3925,  3882,  3929,  3896,  1250,  3907,  3105,
    3913,  3931,  3932,  3941,  1587,  1588,  1589,  1590,  1591,  3938,
    3977,  3986,  3995,  3999,  4003,  4004,  3106,  4015,  4083,  4064,
     791,   791,  4005,  4090,  1602,  1603,  4018,  2576,   718,   791,
     791,   791,   791,   791,   791,   791,  3998,  4002,  1251,  4070,
    1174,  1175,  4047,   791,   791,  4049,   791,   791,  4077,  3631,
    4079,   791,   791,  -346,  4097,   791,   791,   791,   791,  4102,
     791,   791,  4099,  4109,  4112,  4122,  4134,  3814,   791,   791,
    4149,   791,   791,   791,   791,   791,  4151,  4152,   791,   791,
     791,   791,   791,   791,   791,   791,   791,   791,   791,  1671,
     791,  4157,  4160,   791,   791,  4162,  4164,  4302,   791,  4169,
    4187,  4190,   791,   791,   791,  1317,  1592,  1593,  1594,  1595,
    -364,   502,  4302,  4217,  4218,   791,   791,   791,  4178,  4219,
    4215,  2754,  4257,  2754,   791,  4234,  4312,  4244,  4235,  3107,
    4241,   791,   791,   791,  4247,   791,  4258,  4263,  3301,  4298,
    4179,  4270,   791,   791,   791,  3108,   791,   791,   791,   791,
     791,  4299,   791,   791,   791,   791,   791,   791,   791,   791,
    4191,  4303,  1604,   791,   791,  1318,  4309,  4310,  4311,  4314,
    4326,  4340,  1252,  4341,  4343,  4342,  1253,  1605,  1606,  4349,
    4350,  4351,  1319,  1178,  1179,  1180,  1181,  1182,  1183,  1184,
    4352,  4354,  1254,  4357,  1216,  4358,  4364,  4366,  4359,  -952,
    1255,  4368, -2328,  4369,  4372,  3109,  4378,  4391,  1256,   821,
    4394,  4396,  4397,  4401,  1596,  4402,  1597,  1598,  1599,  4407,
    4412,  4022,  3110,  4420,  4421,  1600,  4410,  2696,  4423,  4426,
     612,  2519,  2520,  -952,  2527,  4435,  1257,  2530,  2531,  2532,
    2533,  2534,  2535,  2536,  4429,  4440,  2539,  4441,  2541,  1258,
    1259,  4446,  4442,  4447,  4451,  4454,  4461,  4457,  4465,  4458,
    4467,  4459,  4470,  4471,  4473,  4302,  4476,  1154,  4481,  4480,
    1155,  4483,  4490,  4505,  4506,  4419,  4510,  4520,  4530,  4092,
    3592,   503,  2699,  2543,  3593,  2847,  1026,  3803,  4110,  1217,
    4226,  4379,  3801,  4380,  1463,  3805,  3981,  4522,  4485,  1260,
     572,  4389,   921,  2310,  2232,  1601,  3112,  3952,  3953,  4494,
     791,  3955,  3956,  3958,  1218,  1671,  3959,  3960,  1219,  3961,
     791,  3962,  3963,  4404,  4453,  4296,  3966,  4405,  1261,  4229,
    4377,  3967,  3968,  4308,  4307,   612,  1052,  1531,   791,  2922,
    1982,  3989,  2490,  3518,  3673,  4302,  3134,  4302,  1801,  3428,
    1262,  4246,  1263,  3139,  4472,  1220,  4017,  4325,  1322,  1241,
    1602,  1603,  3676,  4456,  4302,  4251,  4390,  1084,  4159,  4428,
     120,   650,  2034,  1221,  3610,   121,  2920,  3329,  3296,  3611,
    2927,  3744,  3303,  1101,  3718,  3745,  3786,  4072,  3892,  3930,
    4324,  3916,  2833,  3069,  4302,  4302,  3399,  3397,  3395,  4509,
    4279,  4282,   655,   656,  2583,  4281,  4239,  4232,  4237,   612,
    4121,  2993,  2924,  4075,  3295,  1916,     1,   932,     2,  1914,
    3895,  2738,  3719,  2293,  1995,  2947,  2947,  2032,  3125,  3425,
    1146,  2719,  2761,     3,   948,  1222,  2672,     4,  3406,  4409,
    1242,  3092,  1336,  2826,  2318,  2616,  4417,  3472,  2671,  4053,
    4399,     5,     6,  4171,  3591,  4400,  2688,  3725,  1625,     7,
    1576,  3866,  4475,     8,     9,  3858,  1932,  4333,  4334,  2768,
    2587,  1243,  1731,  1443,  1789,  1816,  2717,  1444,  2744,    10,
    3441,  3678,  4523,  3440,   504,  1244,  1445,  3482,   936,  4322,
    1446,   917,  2226,  2071,  1044,  2367,  1823,    11,  1604,  2368,
    3427,  3729,  4455,  1904,  -952,  4344,  1882,  4474,  1245,  4398,
    4529,  1246,  1156,  1605,  1606,  2785,  4463,  3923,  4532,    12,
    3444,  4468,  1836,  2787,  1247,  3464,   881,   882,    13,    14,
      15,  3465,  2188,  2784,  2777,  2272,  2346,  2316,  1325,  3412,
     791,    16,    17,  2054,  1826,  2247,  1248,   505,   852,  -573,
    4133,  1328,   506,   644,    18,  4139,  4502,   645,  4101,  3796,
       0,  1030,  1031,  1032,     0,  1223,     0,     0,    19,     0,
       0,  1249,     0,     0,  1224,     0,     0,  1250,     0,     0,
    1671,     0,  4502,     0,     0,     0,    20,  -952,     0,  1225,
     612,     0,     0,     0,  1671,   507,     0,     0,     0,  1671,
       0,    21,     0,    22,  1671,     0,     0,  1226,    23,     0,
       0,    24,     0,     0,     0,     0,     0,     0,  1251,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    25,     0,    26,     0,   791,   791,
     791,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1227,     0,     0,   791,    27,     0,  1486,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    28,     0,     0,     0,    29,     0,     0,     0,   791,
    1228,     0,     0,     0,     0,   791,     0,     0,   791,     0,
     791,     0,     0,     0,     0,     0,   791,     0,   791,   791,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1556,  1557,     0,     0,     0,     0,     0,     0,     0,
    1567,  1568,     0,     0,  1571,  1572,  1573,     0,     0,     0,
       0,     0,     0,     0,  1581,  1582,     0,  1583,  1584,     0,
       0,     0,  1609,     0,  1241,     0,  1618,  1619,  1620,  1621,
       0,  1623,  1252,     0,     0,     0,  1323,     0,     0,  1631,
    1632,     0,  1635,  1636,     0,     0,     0,     0,     0,  1640,
    1641,  1642,  1254,    30,  1645,  1646,  1647,  1648,  1649,  1650,
    1255,  1652,     0,   791,  1655,  1656,     0,     0,  1256,  1659,
      31,     0,     0,  1662,  1666,  1667,     0,     0,     0,     0,
       0,     0,     0,    32,     0,     0,  1674,  1675,  1676,     0,
       0,     0,     0,     0,    33,  1684,  1257,     0,     0,     0,
       0,     0,  1689,  1690,  1691,  1242,     0,     0,     0,  1258,
    1259,     0,   791,     0,     0,     0,    34,     0,     0,    35,
     791,    36,     0,     0,    37,     0,     0,    38,    39,     0,
       0,     0,     0,     0,     0,  1727,  1243,    40,     0,    41,
       0,     0,     0,     0,     0,     0,     0,    42,     0,     0,
    1244,     0,     0,    43,     0,     0,     0,     0,     0,  1260,
       0,    44,     0,     0,     0,     0,    45,     0,    46,     0,
       0,     0,     0,  1245,     0,     0,  1246,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1261,  1247,
       0,     0,     0,     0,     0,     0,  3526,  3527,    47,     0,
       0,     0,  3528,     0,  3529,    48,  3530,  3531,     0,     0,
    1262,  1248,  1263,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3532,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1249,     0,     0,     0,
       0,     0,  1250,     0,     0,     0,     0,     0,    49,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   791,
      50,     0,     0,     0,    51,     0,     0,    52,     0,     0,
       0,  3533,    53,     0,  3534,     0,     0,     0,     0,     0,
       0,  1835,  3535,  1251,     0,     0,     0,     0,     0,     0,
       0,  1841,     0,     0,     0,     0,     0,     0,     0,     0,
      54,  3536,     0,     0,     0,     0,     0,     0,     0,  1869,
       0,     0,     0,     0,     0,    55,     0,     0,  3537,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     791,     0,     0,     0,   791,     0,     0,     0,     0,   791,
     791,     0,     0,     0,  3538,     0,  3539,     0,   791,     0,
       0,   791,     0,     0,     0,     0,     0,     0,     0,  3540,
    3541,   791,   791,     0,   791,   791,     0,   791,   791,   791,
     791,   791,     0,     0,   791,     0,     0,     0,     0,     0,
       0,     0,     0,   791,     0,     0,     0,     0,     0,     0,
     791,     0,   791,     0,   791,   791,     0,   791,   791,     0,
    3542,     0,   791,   791,   791,     0,     0,     0,   791,   791,
     791,     0,   791,     0,   791,     0,   791,  1252,   791,     0,
     791,     0,     0,     0,     0,   791,     0,  2445,  2446,     0,
    3543,     0,     0,     0,     0,     0,     0,  1254,     0,  3544,
    3545,     0,  3546,     0,   791,  1255,     0,     0,     0,     0,
       0,   791,     0,  1256,   791,     0,     0,     0,     0,     0,
     791,     0,  2448,   791,     0,     0,     0,   791,     0,     0,
       0,     0,     0,     0,     0,     0,  2451,     0,  3547,  3548,
    3549,  1257,     0,     0,  2452,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1258,  1259,     0,  3550,  3551,  3552,
       0,     0,     0,     0,  3553,     0,     0,  3554,  2454,     0,
       0,  2083,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1451,     0,  3555,  3556,  2455,     0,     0,   791,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1260,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2460,     0,     0,     0,  3557,
    3558,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1261,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3559,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1262,     0,  1263,     0,     0,
       0,     0,     0,   791,     0,     0,     0,   791,     0,  2158,
    2160,  2162,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2464,     0,     0,
       0,     0,     0,     0,  2465,     0,     0,     0,  3560,     0,
       0,     0,  3561,     0,     0,     0,     0,     0,     0,     0,
    2197,  2466,     0,     0,  3562,     0,     0,     0,     0,  2202,
       0,  2203,     0,     0,     0,     0,     0,     0,  2845,  1487,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2845,  2845,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2468,     0,  3563,     0,     0,  3564,     0,     0,  3565,  3566,
    3567,  3568,     0,     0,     0,     0,     0,     0,  2469,  1488,
    1489,  1490,  1491,  1492,  1493,  1494,  1495,  1496,  1497,     0,
    1498,  1499,  1500,  1501,  1502,  1503,  1504,  1505,  1506,     0,
    1507,  1508,     0,     0,  2289,     0,     0,     0,     0,     0,
    3569,  3570,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2473,  3571,     1,     0,     2,     0,
       0,     0,  2475,     0,     0,     0,     0,     0,     0,     0,
       0,  2845,  2845,  2345,     0,     0,     0,     4,     0,     0,
       0,  2355,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     5,     6,     0,     0,     0,     0,     0,     0,     7,
       0,     0,     0,     8,     9,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    10,
     791,     0,     0,     0,   791,     0,     0,     0,     0,     0,
       0,     0,  2481,     0,     0,     0,     0,    11,     0,     0,
       0,     0,     0,     0,   791,   791,     0,  1509,  1510,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    12,
       0,     0,     0,     0,     0,   791,     0,     0,    13,    14,
      15,     0,     0,     0,   791,     0,   791,     0,   791,     0,
       0,    16,    17,     0,     0,     0,     0,     0,  2482,  2483,
    2484,     0,     0,     0,     0,  2485,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   791,     0,     0,    19,     0,
     791,  2486,     0,     0,  2487,     0,     0,     0,     0,     0,
    2512,     0,     0,     0,     0,     0,    20,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   791,
       0,    21,     0,    22,     0,     0,     0,     0,    23,     0,
    2489,    24,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    25,     0,    26,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2596,     0,     0,    27,  2598,     0,     0,     0,     0,
    2600,  2601,     0,     0,     0,     0,     0,     0,     0,  2614,
       0,    28,     0,     0,     0,    29,     0,     0,     0,     0,
       0,     0,  2621,  2622,     0,  2623,     0,     0,  2625,  2626,
    2627,  2628,  2629,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2633,     0,     0,     0,     0,     0,
       0,  2634,     0,  2635,     0,  2636,  2637,   791,  2638,     0,
       0,     0,     0,  2641,  2642,  2643,     0,     0,     0,  2645,
    2646,  2647,     0,  2648,     0,  2650,     0,  2652,     0,  2654,
       0,  2655,     0,     0,     0,     0,  2656,     0,     0,     0,
       0,     0,  3293,     0,     0,     0,     0,  2442,     0,  2443,
       0,     0,     0,     0,     0,  2676,     0,     0,     0,     0,
       0,  2445,  2446,    30,     0,     0,     0,     0,     0,     0,
       0,  2686,     0,     0,  2689,     0,     0,     0,     0,     0,
      31,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2447,    32,     0,     0,  2448,     0,     0,     0,
       0,     0,     0,     0,    33,     0,     0,     0,   791,   791,
    2451,     0,     0,     0,     0,     0,     0,     0,  2452,     0,
       0,     0,     0,     0,     0,     0,    34,  2453,     0,    35,
       0,    36,     0,  2845,    37,     0,     0,    38,    39,     0,
       0,     0,  2454,     0,     0,     0,     0,    40,     0,    41,
       0,     0,     0,     0,     0,     0,  1451,    42,     0,     0,
    2455,     0,     0,    43,     0,     0,     0,     0,  2456,     0,
       0,    44,     0,     0,     0,  3294,    45,     0,    46,     0,
     791,     0,     0,  2459,     0,     0,     0,     0,     0,  2460,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   791,     0,     0,    47,   791,
     791,     0,   791,     0,  2355,    48,     0,     0,     0,     0,
    2462,   791,     0,     0,     0,     0,   791,     0,     0,   791,
       0,   791,   791,     0,     0,     0,     0,     0,     0,     0,
     829,   884,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    49,     0,
       0,  2464,     0,     0,   791,   885,   869,     0,  2465,     0,
      50,     0,     0,     0,    51,     0,   886,    52,     0,     0,
       0,     0,    53,     0,     0,  2466,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   791,     0,     0,   887,
       0,   888,     0,     0,     0,     0,     0,     0,  2467,     0,
      54,   889,     0,     0,     0,     0,     0,     0,     0,     0,
     791,     0,     0,     0,     0,    55,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2468,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   791,  2445,  2446,     0,     0, -1797,
     890,     0,  2469,     0,     0,   891,  2470,     0,   892,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   791,     0,     0,     0,     0,     0,  -791,  -791,
    2448,     0,     0,     0,     0,     0,     0,   893,  -791,   894,
       0,     0,     0,     0,  2451,     0,   895,     0,   896,     0,
       0,  2472,  2452,     0,     0,     0,     0,     0,  2473,     0,
       0,     0,     0,     0,     0,     0,  2475,     0,     0,     0,
       0,   897,   898,     0,     0,     0,  2454,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1451,     0,     0,     0,  2455,   899,     0,     0,     0,     0,
       0,  3002,     0,     0,     0,  3004,     0,     0,     0,     0,
       0,     0,  2478,     0,     0,     0,   900,     0,     0,     0,
       0,     0,     0,  2460,     0,  3026,  3027,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2481,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3049,     0,     0,   901,
       0,     0,     0,     0,     0,  3059,     0,  3061,     0,  3063,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2482,  2483,  2484,  2464,     0,     0,     0,  2485,
       0,     0,  2465,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2486,   902,     0,  2487,  2466,
    3122,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   903,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   904,   905,   791,  2489,   906,   907,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   908,     0,  2468,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   791,   791,  2469,     0,     0,     0,
       0,     0,     0,   791,     0,     0,     0,     0,   791,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   909,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   910,     0,     0,  3210,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2473,     0,     0,     0,     0,     0,     0,     0,
    2475,     0,     0,     0,     0,     0, -2365,     0,     0,     0,
     911,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   912,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2481,     0,     0,     0,     0,     0,     0,     0,     0,  3308,
    3309,     0,     0,     0,     0, -2365,     0,     0,     0,     0,
     791,   913,     0,     0,   791,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   791,     0,     0,  2482,  2483,  2484,     0,
       0,     0,     0,  2485,     0,     0,     0,     0,   791,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2486,
       0,  3354,  2487,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3372,     0,     0,     0,
    3376,  3377,     0,     0,     0,     0,     0,     0,  2489,     0,
       0,     0,  3384,     0,     0,     0,     0,  3386,     0,     0,
    3387,     0,  3388,  3389,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3970,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3421,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3421,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   791,     0,     0,     0,     0,     0,     0,     0,   791,
       0,     0,     0,     0,     0,     0,   791,     0,   791,     0,
       0,     0,     0,     0,     0,  2355,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3421,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   791,     0,     0,     0,
       0,     0,  3970,  3970,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   791,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   791,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   791,     0,   791,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   791,     0,  3970,  3970,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3421,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3699,  3700,     0,     0,     0,
       0,     0,     0,     0,  3210,     0,     0,     0,     0,  3710,
       0,     0,     0,     0,     0,     0,     0,     0,   791,     0,
    3970,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3970,   791,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3970,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4319,     0,     0,     0,     0,     0,     0,   791,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   791,
    3970,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3970,  3970,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3210,     0,     0,   791,  3823,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3421,     0,     0,     0,  3970,     0,
       0,     0,     0,     0,     0,   791,     0,     0,  3970,  3210,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   791,     0,
       0,     0,     0,     0,     0,  3970,     0,  3970,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3970,     0,     0,
       0,   791,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3970,     0,  3970,     0,
    3970,     0,     0,     0,     0,     0,     0,  3970,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3970,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3970,  3970,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3970,  3970,     0,
       0,     0,  3970,     0,     0,     0,     0,     0,   791,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   791,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4041,     0,     0,     0,     0,     0,     0,  4046,     0,  4048,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4078,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3210,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3210,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4185,     0,  4186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4300,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4305,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3421,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4362,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4411,     0,     0,     0,
       0,     0,     0,     0,     0,   138,     0,   662,   140,   141,
     142,   143,     0,     0,   144,     0,     0,     0,   145,     0,
       0,   663,     0,   147,   148,   149,   150,   664,   152,  4439,
     153,     0,     0,   665,   154,   666,   667,   668,   155,   669,
       0,   156,   157,   158,  1663,   159,     0,   160,   161,     0,
       0,   162,   670,   671,   163,   164,     0,   165,   672,   673,
     167,     0,   168,   169,   170,   171,   674,   173,     0,   675,
     175,     0,   176,   177,   178,   179,   180,   181,   182,   183,
     184,     0,   185,   186,     0,   187,   188,   189,   676,   191,
       0,   677,   678,   192,     0,     0,   193,   679,   194,   680,
       0,   195,   681,   682,     0,   196,   197,   198,   683,   684,
     685,     0,     0,     0,     0,   686,   201,   687,     0,     0,
     688,   202,   203,     0,   204,     0,     0,     0,   205,  4511,
     206,   207,   208,   209,   210,     0,     0,     0,   211,     0,
       0,   212,   213,   214,     0,     0,     0,   215,     0,   216,
     217,     0,   218,   219,   220,     0,     0,   221,   222,  3421,
     223,   224,   225,   226,   227,   228,   689,     0,   229,   230,
     231,   232,   233,   690,   691,   234,   235,     0,   236,   237,
     238,   692,     0,   239,     0,     0,     0,   693,   241,     0,
     242,     0,   243,     0,   244,   694,   246,   695,     0,   248,
       0,   249,     0,   696,     0,   250,   251,     0,   252,   697,
       0,   253,   254,     0,     0,     0,   698,   256,   257,   258,
     699,     0,   259,   260,   261,     0,     0,   262,     0,     0,
       0,   700,   263,   264,   701,     0,     0,   265,     0,     0,
       0,   266,   267,     0,   268,   269,     0,     0,     0,   270,
       0,     0,   271,   272,     0,  1664,   273,     0,   702,   274,
     275,     0,     0,     0,     0,     0,   703,   277,     0,   278,
       0,   279,     0,   280,   281,     0,     0,   704,     0,     0,
       0,     0,   282,     0,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,     0,   300,   301,   302,   705,   303,   304,   305,   306,
     706,   307,   308,     0,     0,     0,     0,   309,   310,   311,
     312,   707,   314,     0,     0,   708,   316,   709,   317,     0,
     318,   710,   711,   712,   713,   714,   323,   324,   325,   326,
     327,     0,   715,   328,   329,     0,     0,   330,   331,   332,
     333,   716,   717,   718,   334,   335,     0,   719,   720,   336,
       0,   337,     0,   338,   721,     0,   340,     0,   341,   342,
       0,   343,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   344,   345,   346,   722,   347,   348,     0,   349,   350,
     723,   352,   353,   354,   355,   724,   725,   358,   726,     0,
     359,   360,   361,     0,   362,     0,   363,   364,   365,   366,
     367,     0,   727,   369,   370,     0,     0,   371,     0,     0,
       0,   372,   373,   374,   375,   376,     0,     0,   377,   378,
     379,   380,   381,     0,   382,   383,     0,   384,   385,   386,
     728,   729,   387,     0,   388,     0,   389,   390,     0,   391,
     392,   393,     0,   730,     0,   731,   395,   396,   397,   398,
     399,   732,   733,   402,   403,   404,   405,     0,   734,   407,
       0,     0,     0,   408,   409,   410,   411,     0,     0,     0,
     412,     0,     0,     0,   413,     0,   414,   415,   416,   417,
       0,   418,   419,   420,   421,   422,     0,     0,     0,     0,
       0,   423,   424,   425,     0,   426,   427,     0,   428,     0,
       0,   429,     0,     0,   430,   431,   432,   433,   434,   435,
     735,   736,   436,   437,     0,   438,   439,   737,   441,   442,
     443,   738,   739,   444,   445,   446,   447,   740,   448,   449,
       0,     0,   450,   451,   452,   453,     0,   741,   454,   455,
       0,   742,   743,   744,   745,     0,     0,     0,     0,  1665,
     460,   461,     0,   746,   747,   748,   463,   464,   465,   749,
     466,   467,   750,   468,   469,     0,   470,   471,     0,     0,
     472,     0,     0,   473,     0,   474,     0,   751,   476,     0,
       0,   752,   753,   754,   755,   477,     0,     0,   478,   756,
       0,   757,   479,   480,   481,   758,   759,     0,     0,     0,
       0,     0,     0,   484,   485,     0,   486,   487,   488,     0,
       0,   760,     0,     0,     0,   761,   762,     0,     0,     0,
       0,   763,   764,     0,     0,   765,   766,     0,     0,   767,
     768,   138,     0,   662,   140,   141,   142,   143,  2351,     0,
     144,     0,     0,     0,   145,     0,     0,   663,     0,   147,
     148,   149,   150,   664,   152,     0,   153,     0,     0,  2352,
     154,   666,   667,   668,   155,   669,     0,   156,   157,   158,
       0,   159,     0,   160,   161,     0,     0,   162,   670,   671,
     163,   164,     0,   165,   672,   673,   167,     0,   168,   169,
     170,   171,   674,   173,     0,   675,   175,     0,   176,   177,
     178,   179,   180,   181,   182,   183,   184,     0,   185,   186,
       0,   187,   188,   189,   676,   191,     0,   677,   678,   192,
       0,     0,   193,   679,   194,   680,     0,   195,   681,   682,
       0,   196,   197,   198,   683,   684,   685,     0,     0,     0,
       0,   686,   201,   687,     0,     0,  2353,   202,   203,     0,
     204,     0,     0,     0,   205,     0,   206,   207,   208,   209,
     210,     0,     0,     0,   211,     0,     0,   212,   213,   214,
       0,     0,     0,   215,     0,   216,   217,     0,   218,   219,
     220,     0,     0,   221,   222,     0,   223,   224,   225,   226,
     227,   228,   689,     0,   229,   230,   231,   232,   233,   690,
     691,   234,   235,     0,   236,   237,   238,   692,     0,   239,
       0,     0,     0,   693,   241,     0,   242,     0,   243,     0,
     244,   694,   246,   695,     0,   248,     0,   249,     0,   696,
       0,   250,   251,     0,   252,   697,     0,   253,   254,     0,
       0,     0,   698,   256,   257,   258,   699,     0,   259,   260,
     261,     0,     0,   262,     0,     0,     0,   700,   263,   264,
     701,     0,     0,   265,     0,     0,     0,   266,   267,     0,
     268,   269,     0,     0,     0,   270,     0,     0,   271,   272,
       0,     0,   273,     0,   702,   274,   275,     0,     0,     0,
       0,     0,   703,   277,     0,   278,     0,   279,     0,   280,
     281,     0,     0,   704,     0,     0,     0,     0,   282,     0,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,     0,   300,   301,
     302,   705,   303,   304,   305,   306,   706,   307,   308,     0,
       0,     0,     0,   309,   310,   311,   312,   707,   314,     0,
       0,   708,   316,   709,   317,     0,   318,   710,   711,   712,
     713,   714,   323,   324,   325,   326,   327,     0,   715,   328,
     329,     0,     0,   330,   331,   332,   333,   716,   717,   718,
     334,   335,     0,   719,   720,   336,     0,   337,     0,   338,
     721,  2354,   340,     0,   341,   342,     0,   343,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   344,   345,   346,
     722,   347,   348,     0,   349,   350,   723,   352,   353,   354,
     355,   724,   725,   358,   726,     0,   359,   360,   361,     0,
     362,     0,   363,   364,   365,   366,   367,     0,   727,   369,
     370,     0,     0,   371,     0,     0,     0,   372,   373,   374,
     375,   376,     0,     0,   377,   378,   379,   380,   381,     0,
     382,   383,     0,   384,   385,   386,   728,   729,   387,     0,
     388,     0,   389,   390,     0,   391,   392,   393,     0,   730,
       0,   731,   395,   396,   397,   398,   399,   732,   733,   402,
     403,   404,   405,     0,   734,   407,     0,     0,     0,   408,
     409,   410,   411,     0,     0,     0,   412,     0,     0,     0,
     413,     0,   414,   415,   416,   417,     0,   418,   419,   420,
     421,   422,     0,     0,     0,     0,     0,   423,   424,   425,
       0,   426,   427,     0,   428,     0,     0,   429,     0,     0,
     430,   431,   432,   433,   434,   435,   735,   736,   436,   437,
       0,   438,   439,   737,   441,   442,   443,   738,   739,   444,
     445,   446,   447,   740,   448,   449,     0,     0,   450,   451,
     452,   453,     0,   741,   454,   455,     0,   742,   743,   744,
     745,     0,     0,     0,     0,     0,   460,   461,     0,   746,
     747,   748,   463,   464,   465,   749,   466,   467,   750,   468,
     469,     0,   470,   471,     0,     0,   472,     0,     0,   473,
       0,   474,     0,   751,   476,     0,     0,   752,   753,   754,
     755,   477,     0,     0,   478,   756,     0,   757,   479,   480,
     481,   758,   759,     0,     0,     0,     0,     0,     0,   484,
     485,     0,   486,   487,   488,     0,     0,   760,     0,     0,
       0,   761,   762,     0,     0,     0,     0,   763,   764,     0,
       0,   765,   766,     0,     0,   767,   768,   138,     0,   662,
     140,   141,   142,   143,     0,     0,   144,     0,     0,     0,
     145,     0,     0,   663,     0,   147,   148,   149,   150,   664,
     152,     0,   153,     0,     0,   665,   154,   666,   667,   668,
     155,   669,     0,   156,   157,   158,     0,   159,     0,   160,
     161,     0,     0,   162,   670,   671,   163,   164,     0,   165,
     672,   673,   167,     0,   168,   169,   170,   171,   674,   173,
       0,   675,   175,     0,   176,   177,   178,   179,   180,   181,
     182,   183,   184,     0,   185,   186,     0,   187,   188,   189,
     676,   191,     0,   677,   678,   192,     0,     0,   193,   679,
     194,   680,     0,   195,   681,   682,     0,   196,   197,   198,
     683,   684,   685,     0,     0,     0,     0,   686,   201,   687,
       0,     0,   688,   202,   203,     0,   204,     0,     0,     0,
     205,     0,   206,   207,   208,   209,   210,     0,     0,     0,
     211,     0,     0,   212,   213,   214,     0,     0,     0,   215,
       0,   216,   217,     0,   218,   219,   220,     0,     0,   221,
     222,     0,   223,   224,   225,   226,   227,   228,   689,     0,
     229,   230,   231,   232,   233,   690,   691,   234,   235,     0,
     236,   237,   238,   692,     0,   239,     0,     0,     0,   693,
     241,  2157,   242,     0,   243,     0,   244,   694,   246,   695,
       0,   248,     0,   249,     0,   696,     0,   250,   251,     0,
     252,   697,     0,   253,   254,     0,     0,     0,   698,   256,
     257,   258,   699,     0,   259,   260,   261,     0,     0,   262,
       0,     0,     0,   700,   263,   264,   701,     0,     0,   265,
       0,     0,     0,   266,   267,     0,   268,   269,     0,     0,
       0,   270,     0,     0,   271,   272,     0,     0,   273,     0,
     702,   274,   275,     0,     0,     0,     0,     0,   703,   277,
       0,   278,     0,   279,     0,   280,   281,     0,     0,   704,
       0,     0,     0,     0,   282,     0,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,     0,   300,   301,   302,   705,   303,   304,
     305,   306,   706,   307,   308,     0,     0,     0,     0,   309,
     310,   311,   312,   707,   314,     0,     0,   708,   316,   709,
     317,     0,   318,   710,   711,   712,   713,   714,   323,   324,
     325,   326,   327,     0,   715,   328,   329,     0,     0,   330,
     331,   332,   333,   716,   717,   718,   334,   335,     0,   719,
     720,   336,     0,   337,     0,   338,   721,     0,   340,     0,
     341,   342,     0,   343,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   344,   345,   346,   722,   347,   348,     0,
     349,   350,   723,   352,   353,   354,   355,   724,   725,   358,
     726,     0,   359,   360,   361,     0,   362,     0,   363,   364,
     365,   366,   367,     0,   727,   369,   370,     0,     0,   371,
       0,     0,     0,   372,   373,   374,   375,   376,     0,     0,
     377,   378,   379,   380,   381,     0,   382,   383,     0,   384,
     385,   386,   728,   729,   387,     0,   388,     0,   389,   390,
       0,   391,   392,   393,     0,   730,     0,   731,   395,   396,
     397,   398,   399,   732,   733,   402,   403,   404,   405,     0,
     734,   407,     0,     0,     0,   408,   409,   410,   411,     0,
       0,     0,   412,     0,     0,     0,   413,     0,   414,   415,
     416,   417,     0,   418,   419,   420,   421,   422,     0,     0,
       0,     0,     0,   423,   424,   425,     0,   426,   427,     0,
     428,     0,     0,   429,     0,     0,   430,   431,   432,   433,
     434,   435,   735,   736,   436,   437,     0,   438,   439,   737,
     441,   442,   443,   738,   739,   444,   445,   446,   447,   740,
     448,   449,     0,     0,   450,   451,   452,   453,     0,   741,
     454,   455,     0,   742,   743,   744,   745,     0,     0,     0,
       0,     0,   460,   461,     0,   746,   747,   748,   463,   464,
     465,   749,   466,   467,   750,   468,   469,     0,   470,   471,
       0,     0,   472,     0,     0,   473,     0,   474,     0,   751,
     476,     0,     0,   752,   753,   754,   755,   477,     0,     0,
     478,   756,     0,   757,   479,   480,   481,   758,   759,     0,
       0,     0,     0,     0,     0,   484,   485,     0,   486,   487,
     488,     0,     0,   760,     0,     0,     0,   761,   762,     0,
       0,     0,     0,   763,   764,     0,     0,   765,   766,     0,
       0,   767,   768,   138,     0,   662,   140,   141,   142,   143,
       0,     0,   144,     0,     0,     0,   145,     0,     0,   663,
       0,   147,   148,   149,   150,   664,   152,     0,   153,     0,
       0,   665,   154,   666,   667,   668,   155,   669,     0,   156,
     157,   158,     0,   159,     0,   160,   161,     0,     0,   162,
     670,   671,   163,   164,     0,   165,   672,   673,   167,     0,
     168,   169,   170,   171,   674,   173,     0,   675,   175,     0,
     176,   177,   178,   179,   180,   181,   182,   183,   184,     0,
     185,   186,     0,   187,   188,   189,   676,   191,     0,   677,
     678,   192,     0,     0,   193,   679,   194,   680,     0,   195,
     681,   682,     0,   196,   197,   198,   683,   684,   685,     0,
       0,     0,     0,   686,   201,   687,     0,     0,   688,   202,
     203,     0,   204,     0,     0,     0,   205,     0,   206,   207,
     208,   209,   210,     0,     0,     0,   211,     0,     0,   212,
     213,   214,     0,     0,     0,   215,     0,   216,   217,     0,
     218,   219,   220,     0,     0,   221,   222,     0,   223,   224,
     225,   226,   227,   228,   689,     0,   229,   230,   231,   232,
     233,   690,   691,   234,   235,     0,   236,   237,   238,   692,
       0,   239,     0,     0,     0,   693,   241,  2159,   242,     0,
     243,     0,   244,   694,   246,   695,     0,   248,     0,   249,
       0,   696,     0,   250,   251,     0,   252,   697,     0,   253,
     254,     0,     0,     0,   698,   256,   257,   258,   699,     0,
     259,   260,   261,     0,     0,   262,     0,     0,     0,   700,
     263,   264,   701,     0,     0,   265,     0,     0,     0,   266,
     267,     0,   268,   269,     0,     0,     0,   270,     0,     0,
     271,   272,     0,     0,   273,     0,   702,   274,   275,     0,
       0,     0,     0,     0,   703,   277,     0,   278,     0,   279,
       0,   280,   281,     0,     0,   704,     0,     0,     0,     0,
     282,     0,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,     0,
     300,   301,   302,   705,   303,   304,   305,   306,   706,   307,
     308,     0,     0,     0,     0,   309,   310,   311,   312,   707,
     314,     0,     0,   708,   316,   709,   317,     0,   318,   710,
     711,   712,   713,   714,   323,   324,   325,   326,   327,     0,
     715,   328,   329,     0,     0,   330,   331,   332,   333,   716,
     717,   718,   334,   335,     0,   719,   720,   336,     0,   337,
       0,   338,   721,     0,   340,     0,   341,   342,     0,   343,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   344,
     345,   346,   722,   347,   348,     0,   349,   350,   723,   352,
     353,   354,   355,   724,   725,   358,   726,     0,   359,   360,
     361,     0,   362,     0,   363,   364,   365,   366,   367,     0,
     727,   369,   370,     0,     0,   371,     0,     0,     0,   372,
     373,   374,   375,   376,     0,     0,   377,   378,   379,   380,
     381,     0,   382,   383,     0,   384,   385,   386,   728,   729,
     387,     0,   388,     0,   389,   390,     0,   391,   392,   393,
       0,   730,     0,   731,   395,   396,   397,   398,   399,   732,
     733,   402,   403,   404,   405,     0,   734,   407,     0,     0,
       0,   408,   409,   410,   411,     0,     0,     0,   412,     0,
       0,     0,   413,     0,   414,   415,   416,   417,     0,   418,
     419,   420,   421,   422,     0,     0,     0,     0,     0,   423,
     424,   425,     0,   426,   427,     0,   428,     0,     0,   429,
       0,     0,   430,   431,   432,   433,   434,   435,   735,   736,
     436,   437,     0,   438,   439,   737,   441,   442,   443,   738,
     739,   444,   445,   446,   447,   740,   448,   449,     0,     0,
     450,   451,   452,   453,     0,   741,   454,   455,     0,   742,
     743,   744,   745,     0,     0,     0,     0,     0,   460,   461,
       0,   746,   747,   748,   463,   464,   465,   749,   466,   467,
     750,   468,   469,     0,   470,   471,     0,     0,   472,     0,
       0,   473,     0,   474,     0,   751,   476,     0,     0,   752,
     753,   754,   755,   477,     0,     0,   478,   756,     0,   757,
     479,   480,   481,   758,   759,     0,     0,     0,     0,     0,
       0,   484,   485,     0,   486,   487,   488,     0,     0,   760,
       0,     0,     0,   761,   762,     0,     0,     0,     0,   763,
     764,     0,     0,   765,   766,     0,     0,   767,   768,   138,
       0,   662,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,     0,     0,   663,     0,   147,   148,   149,
     150,   664,   152,     0,   153,     0,     0,   665,   154,   666,
     667,   668,   155,   669,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,   670,   671,   163,   164,
       0,   165,   672,   673,   167,     0,   168,   169,   170,   171,
     674,   173,     0,   675,   175,     0,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,   676,   191,     0,   677,   678,   192,     0,     0,
     193,   679,   194,   680,     0,   195,   681,   682,     0,   196,
     197,   198,   683,   684,   685,     0,     0,     0,     0,   686,
     201,   687,     0,     0,   688,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,   211,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,   216,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,   228,
     689,     0,   229,   230,   231,   232,   233,   690,   691,   234,
     235,     0,   236,   237,   238,   692,     0,   239,     0,     0,
       0,   693,   241,  2161,   242,     0,   243,     0,   244,   694,
     246,   695,     0,   248,     0,   249,     0,   696,     0,   250,
     251,     0,   252,   697,     0,   253,   254,     0,     0,     0,
     698,   256,   257,   258,   699,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,   700,   263,   264,   701,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,   271,   272,     0,     0,
     273,     0,   702,   274,   275,     0,     0,     0,     0,     0,
     703,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,   704,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,   705,
     303,   304,   305,   306,   706,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   707,   314,     0,     0,   708,
     316,   709,   317,     0,   318,   710,   711,   712,   713,   714,
     323,   324,   325,   326,   327,     0,   715,   328,   329,     0,
       0,   330,   331,   332,   333,   716,   717,   718,   334,   335,
       0,   719,   720,   336,     0,   337,     0,   338,   721,     0,
     340,     0,   341,   342,     0,   343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,   346,   722,   347,
     348,     0,   349,   350,   723,   352,   353,   354,   355,   724,
     725,   358,   726,     0,   359,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   727,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,   383,
       0,   384,   385,   386,   728,   729,   387,     0,   388,     0,
     389,   390,     0,   391,   392,   393,     0,   730,     0,   731,
     395,   396,   397,   398,   399,   732,   733,   402,   403,   404,
     405,     0,   734,   407,     0,     0,     0,   408,   409,   410,
     411,     0,     0,     0,   412,     0,     0,     0,   413,     0,
     414,   415,   416,   417,     0,   418,   419,   420,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,   433,   434,   435,   735,   736,   436,   437,     0,   438,
     439,   737,   441,   442,   443,   738,   739,   444,   445,   446,
     447,   740,   448,   449,     0,     0,   450,   451,   452,   453,
       0,   741,   454,   455,     0,   742,   743,   744,   745,     0,
       0,     0,     0,     0,   460,   461,     0,   746,   747,   748,
     463,   464,   465,   749,   466,   467,   750,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   751,   476,     0,     0,   752,   753,   754,   755,   477,
       0,     0,   478,   756,     0,   757,   479,   480,   481,   758,
     759,     0,     0,     0,     0,     0,     0,   484,   485,     0,
     486,   487,   488,     0,     0,   760,     0,     0,     0,   761,
     762,     0,     0,     0,     0,   763,   764,     0,     0,   765,
     766,     0,     0,   767,   768,   138,     0,   662,   140,   141,
     142,   143,     0,     0,   144,     0,     0,     0,   145,     0,
       0,   663,     0,   147,   148,   149,   150,   664,   152,     0,
     153,     0,     0,   665,   154,   666,   667,   668,   155,   669,
       0,   156,   157,   158,     0,   159,     0,   160,   161,     0,
       0,   162,   670,   671,   163,   164,     0,   165,   672,   673,
     167,     0,   168,   169,   170,   171,   674,   173,     0,   675,
     175,     0,   176,   177,   178,   179,   180,   181,   182,   183,
     184,     0,   185,   186,     0,   187,   188,   189,   676,   191,
       0,   677,   678,   192,     0,     0,   193,   679,   194,   680,
       0,   195,   681,   682,     0,   196,   197,   198,   683,   684,
     685,     0,     0,     0,     0,   686,   201,   687,     0,     0,
     688,   202,   203,     0,   204,     0,     0,     0,   205,     0,
     206,   207,   208,   209,   210,     0,     0,     0,   211,     0,
       0,   212,   213,   214,     0,     0,     0,   215,     0,   216,
     217,     0,   218,   219,   220,     0,     0,   221,   222,     0,
     223,   224,   225,   226,   227,   228,   689,     0,   229,   230,
     231,   232,   233,   690,   691,   234,   235,     0,   236,   237,
     238,   692,     0,   239,     0,     0,     0,   693,   241,     0,
     242,     0,   243,     0,   244,   694,   246,   695,     0,   248,
       0,   249,     0,   696,     0,   250,   251,     0,   252,   697,
       0,   253,   254,     0,     0,     0,   698,   256,   257,   258,
     699,     0,   259,   260,   261,     0,     0,   262,     0,     0,
       0,   700,   263,   264,   701,     0,     0,   265,     0,     0,
       0,   266,   267,     0,   268,   269,     0,     0,     0,   270,
       0,     0,   271,   272,     0,     0,   273,     0,   702,   274,
     275,     0,     0,     0,     0,     0,   703,   277,     0,   278,
       0,   279,     0,   280,   281,     0,     0,   704,     0,     0,
       0,     0,   282,     0,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,     0,   300,   301,   302,   705,   303,   304,   305,   306,
     706,   307,   308,     0,     0,     0,     0,   309,   310,   311,
     312,   707,   314,     0,     0,   708,   316,   709,   317,     0,
     318,   710,   711,   712,   713,   714,   323,   324,   325,   326,
     327,     0,   715,   328,   329,     0,     0,   330,   331,   332,
     333,   716,   717,   718,   334,   335,     0,   719,   720,   336,
       0,   337,     0,   338,   721,     0,   340,     0,   341,   342,
       0,   343,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   344,   345,   346,   722,   347,   348,     0,   349,   350,
     723,   352,   353,   354,   355,   724,   725,   358,   726,     0,
     359,   360,   361,     0,   362,     0,   363,   364,   365,   366,
     367,     0,   727,   369,   370,     0,     0,   371,     0,     0,
       0,   372,   373,   374,   375,   376,     0,     0,   377,   378,
     379,   380,   381,     0,   382,   383,     0,   384,   385,   386,
     728,   729,   387,     0,   388,     0,   389,   390,     0,   391,
     392,   393,     0,   730,     0,   731,   395,   396,   397,   398,
     399,   732,   733,   402,   403,   404,   405,     0,   734,   407,
       0,     0,     0,   408,   409,   410,   411,     0,     0,     0,
     412,     0,     0,     0,   413,     0,   414,   415,   416,   417,
       0,   418,   419,   420,   421,   422,     0,     0,     0,     0,
       0,   423,   424,   425,     0,   426,   427,     0,   428,     0,
       0,   429,     0,     0,   430,   431,   432,   433,   434,   435,
     735,   736,   436,   437,     0,   438,   439,   737,   441,   442,
     443,   738,   739,   444,   445,   446,   447,   740,   448,   449,
       0,     0,   450,   451,   452,   453,     0,   741,   454,   455,
       0,   742,   743,   744,   745,     0,     0,     0,     0,     0,
     460,   461,     0,   746,   747,   748,   463,   464,   465,   749,
     466,   467,   750,   468,   469,     0,   470,   471,     0,     0,
     472,     0,     0,   473,     0,   474,     0,   751,   476,     0,
       0,   752,   753,   754,   755,   477,     0,     0,   478,   756,
       0,   757,   479,   480,   481,   758,   759,     0,     0,     0,
       0,     0,     0,   484,   485,     0,   486,   487,   488,     0,
       0,   760,     0,     0,     0,   761,   762,     0,     0,     0,
       0,   763,   764,     0,     0,   765,   766,     0,     0,   767,
     768,   138,     0,   662,   140,   141,   142,   143,     0,     0,
     144,     0,     0,     0,   145,     0,     0,   663,     0,   147,
     148,   149,   150,   664,   152,     0,   153,     0,     0,   665,
     154,   666,   667,   668,   155,   669,     0,   156,   157,   158,
       0,   159,     0,   160,   161,     0,     0,   162,   670,   671,
     163,   164,     0,   165,   672,   673,   167,     0,   168,   169,
     170,   171,   674,   173,     0,   675,   175,     0,   176,   177,
     178,   179,   180,   181,   182,   183,   184,     0,   185,   186,
       0,   187,   188,   189,   676,   191,     0,   677,   678,   192,
       0,     0,   193,   679,   194,   680,     0,   195,   681,   682,
       0,   196,   197,   198,   683,   684,   685,     0,     0,     0,
       0,   686,   201,   687,     0,     0,   688,   202,   203,     0,
     204,     0,     0,     0,   205,     0,   206,   207,   208,   209,
     210,     0,     0,     0,   211,     0,     0,   212,   213,   214,
       0,     0,     0,   215,     0,   216,   217,     0,   218,   219,
     220,     0,     0,   221,   222,     0,   223,   224,   225,   226,
     227,   228,   689,     0,   229,   230,   231,   232,   233,   690,
     691,   234,   235,     0,   236,   237,   238,   692,     0,   239,
       0,     0,     0,   693,   241,     0,   242,     0,   243,     0,
     244,   694,   246,   695,     0,   248,     0,   249,     0,   696,
       0,   250,   251,     0,   252,   697,     0,   253,   254,     0,
       0,     0,   698,   256,   257,   258,   699,     0,   259,   260,
     261,     0,     0,   262,     0,     0,     0,   700,   263,   264,
     701,     0,     0,   265,     0,     0,     0,   266,   267,     0,
     268,   269,     0,     0,     0,   270,     0,     0,   271,   272,
       0,     0,   273,     0,   702,   274,   275,     0,     0,     0,
       0,     0,   703,   277,     0,   278,     0,   279,     0,   280,
     281,     0,     0,   704,     0,     0,     0,     0,   282,     0,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,     0,   300,   301,
     302,   705,   303,   304,   305,   306,   706,   307,   308,     0,
       0,     0,     0,   309,   310,   311,   312,   707,   314,     0,
       0,   708,   316,   709,   317,     0,   318,   710,   711,   712,
     713,   714,   323,   324,   325,   326,   327,     0,   715,   328,
     329,     0,     0,   330,   331,   332,   333,   716,   717,   718,
     334,   335,     0,   719,   720,   336,     0,   337,     0,   338,
     721,     0,   340,     0,   341,   342,     0,   343,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   344,   345,   346,
     722,   347,   348,     0,   349,   350,   723,   352,   353,   354,
     355,   724,   725,   358,   726,     0,   359,   360,   361,     0,
     362,     0,   363,   364,   365,   366,   367,     0,   727,   369,
     370,     0,     0,   371,     0,     0,     0,   372,   373,   374,
     375,   376,     0,     0,   377,   378,   379,   380,   381,     0,
     382,   383,     0,   384,   385,   386,   728,   729,   387,     0,
     388,     0,   389,   390,     0,   391,   392,   393,     0,   730,
       0,   731,   395,   396,   397,   398,   399,   732,   733,   402,
     403,   404,   405,     0,   734,   407,     0,     0,     0,   408,
     409,   410,   411,     0,     0,     0,   412,     0,     0,     0,
     413,     0,   414,   415,   416,   417,     0,   418,   419,   420,
     421,   422,     0,     0,     0,     0,     0,   423,   424,   425,
       0,   426,   427,     0,   428,     0,     0,   429,     0,     0,
     430,   431,   432,   433,   434,   435,   735,   736,   436,   437,
       0,   438,   439,   737,   441,   442,   443,   738,   739,   444,
     445,   446,   447,   740,   448,   449,     0,     0,   450,   451,
     452,   453,     0,   741,   454,   455,     0,   742,   743,   744,
     745,     0,     0,     0,     0,     0,   460,   461,     0,   746,
     747,   748,   463,   464,   465,   749,   466,   467,   750,   468,
     469,     0,   470,   471,     0,     0,   472,     0,     0,   473,
       0,   474,     0,   751,   476,     0,     0,   752,   753,   754,
     755,   477,     0,     0,   478,   756,     0,   757,   479,   480,
     481,   758,   759,     0,     0,     0,     0,     0,     0,   484,
     485,     0,   486,   487,   488,     0,     0,   760,     0,     0,
       0,   761,   762,     0,     0,     0,     0,   763,  1083,     0,
       0,   765,   766,     0,     0,   767,   768,   138,     0,   662,
     140,   141,   142,   143,  1698,     0,   144,     0,     0,     0,
    1699,     0,     0,   663,     0,   147,   148,   149,   150,   664,
     152,     0,   153,     0,     0,   665,   154,   666,   667,   668,
     155,   669,     0,   156,   157,   158,     0,   159,     0,   160,
     161,     0,     0,   162,   670,   671,   163,   164,     0,   165,
     672,   673,   167,     0,   168,   169,   170,   171,   674,   173,
       0,   675,   175,     0,   176,   177,   178,   179,   180,   181,
     182,   183,   184,     0,   185,   186,     0,   187,   188,   189,
     676,   191,     0,   677,   678,   192,     0,     0,   193,   679,
     194,   680,     0,   195,   681,   682,     0,   196,   197,   198,
     683,   684,   685,     0,     0,     0,     0,   686,   201,   687,
       0,     0,   688,   202,   203,     0,   204,     0,     0,     0,
     205,     0,   206,   207,   208,   209,   210,     0,     0,     0,
     211,     0,     0,   212,   213,   214,     0,     0,     0,   215,
       0,   216,   217,     0,   218,   219,   220,     0,     0,   221,
     222,     0,   223,   224,   225,   226,   227,   228,   689,     0,
     229,   230,   231,   232,   233,   690,   691,   234,   235,     0,
     236,   237,   238,   692,     0,   239,     0,     0,     0,   693,
     241,     0,   242,     0,   243,     0,   244,   694,   246,   695,
       0,   248,     0,   249,     0,   696,     0,   250,   251,     0,
     252,   697,     0,   253,   254,     0,     0,     0,   698,   256,
     257,   258,   699,     0,   259,   260,   261,     0,     0,   262,
       0,     0,     0,   700,   263,   264,   701,     0,     0,   265,
       0,     0,     0,   266,   267,     0,   268,   269,     0,     0,
       0,   270,     0,     0,   271,   272,     0,     0,   273,     0,
     702,   274,   275,     0,     0,     0,     0,     0,   703,   277,
       0,   278,     0,   279,     0,   280,   281,     0,     0,   704,
       0,     0,     0,     0,   282,     0,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,     0,   300,   301,   302,   705,   303,   304,
     305,   306,   706,   307,   308,     0,     0,     0,     0,   309,
     310,   311,   312,   707,   314,     0,     0,   708,   316,   709,
     317,     0,   318,   710,   711,   712,   713,   714,   323,   324,
     325,   326,   327,     0,   715,   328,   329,     0,     0,   330,
     331,   332,   333,   716,     0,   718,   334,   335,     0,   719,
     720,   336,     0,   337,     0,   338,   721,     0,   340,     0,
     341,   342,     0,   343,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   344,   345,   346,   722,   347,   348,     0,
     349,   350,   723,   352,   353,   354,   355,   724,   725,   358,
     726,     0,   359,   360,   361,     0,   362,     0,   363,   364,
     365,   366,   367,     0,   727,   369,   370,     0,     0,   371,
       0,     0,     0,   372,   373,   374,   375,   376,     0,     0,
     377,   378,   379,   380,   381,     0,   382,   383,     0,   384,
     385,   386,   728,   729,   387,     0,   388,     0,   389,   390,
       0,   391,   392,   393,     0,   730,     0,   731,   395,   396,
     397,   398,   399,   732,   733,   402,   403,   404,   405,     0,
     734,   407,     0,     0,     0,   408,   409,   410,   411,     0,
       0,     0,   412,     0,     0,     0,   413,     0,   414,   415,
     416,   417,     0,   418,   419,   420,   421,   422,     0,     0,
       0,     0,     0,   423,   424,   425,     0,   426,   427,     0,
     428,     0,     0,   429,     0,     0,   430,   431,   432,   433,
     434,   435,   735,   736,   436,   437,     0,   438,   439,   737,
     441,   442,   443,   738,   739,   444,   445,   446,   447,   740,
     448,   449,     0,     0,   450,   451,   452,   453,     0,   741,
     454,   455,     0,   742,   743,   744,   745,     0,     0,     0,
       0,     0,   460,   461,     0,   746,   747,   748,   463,   464,
     465,   749,   466,   467,   750,   468,   469,     0,   470,   471,
       0,     0,   472,     0,     0,   473,     0,   474,     0,   751,
     476,     0,     0,   752,   753,   754,   755,   477,     0,     0,
     478,   756,     0,   757,   479,   480,   481,   758,   759,     0,
       0,     0,     0,     0,     0,   484,   485,     0,   486,   487,
     488,     0,     0,   760,     0,     0,     0,   761,   762,     0,
       0,     0,     0,   763,   764,     0,     0,   765,   766,     0,
       0,   767,   768,   138,     0,   662,   140,   141,   142,   143,
       0,     0,   144,     0,     0,     0,   145,     0,     0,   663,
       0,   147,   148,   149,   150,   664,   152,     0,   153,     0,
       0,   665,   154,   666,   667,   668,   155,   669,     0,   156,
     157,   158,     0,   159,     0,   160,   161,     0,     0,   162,
     670,   671,   163,   164,     0,   165,   672,   673,   167,     0,
     168,   169,   170,   171,   674,   173,     0,   675,   175,     0,
     176,   177,   178,   179,   180,   181,   182,   183,   184,     0,
     185,   186,     0,   187,   188,   189,   676,   191,     0,   677,
     678,   192,     0,     0,   193,   679,   194,   680,     0,   195,
     681,   682,     0,   196,   197,   198,   683,   684,   685,     0,
       0,     0,     0,   686,   201,   687,     0,     0,   688,   202,
     203,     0,   204,     0,     0,     0,   205,     0,   206,   207,
     208,   209,   210,     0,     0,     0,   211,     0,     0,   212,
     213,   214,     0,     0,     0,   215,     0,   216,   217,     0,
     218,   219,   220,     0,     0,   221,   222,     0,   223,   224,
     225,   226,   227,   228,   689,     0,   229,   230,   231,   232,
     233,   690,   691,   234,   235,     0,   236,   237,   238,   692,
       0,   239,     0,     0,     0,   693,   241,     0,   242,     0,
     243,     0,   244,   694,   246,   695,     0,   248,     0,   249,
       0,   696,     0,   250,   251,     0,   252,   697,     0,   253,
     254,     0,     0,     0,   698,   256,   257,   258,   699,     0,
     259,   260,   261,     0,     0,   262,     0,     0,     0,   700,
     263,   264,  2595,     0,     0,   265,     0,     0,     0,   266,
     267,     0,   268,   269,     0,     0,     0,   270,     0,     0,
     271,   272,     0,     0,   273,     0,   702,   274,   275,     0,
       0,     0,     0,     0,   703,   277,     0,   278,     0,   279,
       0,   280,   281,     0,     0,   704,     0,     0,     0,     0,
     282,     0,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,     0,
     300,   301,   302,   705,   303,   304,   305,   306,   706,   307,
     308,     0,     0,     0,     0,   309,   310,   311,   312,   707,
     314,     0,     0,   708,   316,   709,   317,     0,   318,   710,
     711,   712,   713,   714,   323,   324,   325,   326,   327,     0,
     715,   328,   329,     0,     0,   330,   331,   332,   333,   716,
     717,   718,   334,   335,     0,   719,   720,   336,     0,   337,
       0,   338,   721,     0,   340,     0,   341,   342,     0,   343,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   344,
     345,   346,   722,   347,   348,     0,   349,   350,   723,   352,
     353,   354,   355,   724,   725,   358,   726,     0,   359,   360,
     361,     0,   362,     0,   363,   364,   365,   366,   367,     0,
     727,   369,   370,     0,     0,   371,     0,     0,     0,   372,
     373,   374,   375,   376,     0,     0,   377,   378,   379,   380,
     381,     0,   382,   383,     0,   384,   385,   386,   728,   729,
     387,     0,   388,     0,   389,   390,     0,   391,   392,   393,
       0,   730,     0,   731,   395,   396,   397,   398,   399,   732,
     733,   402,   403,   404,   405,     0,   734,   407,     0,     0,
       0,   408,   409,   410,   411,     0,     0,     0,   412,     0,
       0,     0,   413,     0,   414,   415,   416,   417,     0,   418,
     419,   420,   421,   422,     0,     0,     0,     0,     0,   423,
     424,   425,     0,   426,   427,     0,   428,     0,     0,   429,
       0,     0,   430,   431,   432,   433,   434,   435,   735,   736,
     436,   437,     0,   438,   439,   737,   441,   442,   443,   738,
     739,   444,   445,   446,   447,   740,   448,   449,     0,     0,
     450,   451,   452,   453,     0,   741,   454,   455,     0,   742,
     743,   744,   745,     0,     0,     0,     0,     0,   460,   461,
       0,   746,   747,   748,   463,   464,   465,   749,   466,   467,
     750,   468,   469,     0,   470,   471,     0,     0,   472,     0,
       0,   473,     0,   474,     0,   751,   476,     0,     0,   752,
     753,   754,   755,   477,     0,     0,   478,   756,     0,   757,
     479,   480,   481,   758,   759,     0,     0,     0,     0,     0,
       0,   484,   485,     0,   486,   487,   488,     0,     0,   760,
       0,     0,     0,   761,   762,     0,     0,     0,     0,   763,
     764,     0,     0,   765,   766,     0,     0,   767,   768,   138,
       0,   662,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,     0,     0,   663,     0,   147,   148,   149,
     150,   664,   152,     0,   153,     0,     0,   665,   154,   666,
     667,   668,   155,   669,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,   670,   671,   163,   164,
       0,   165,   672,   673,   167,     0,   168,   169,   170,   171,
     674,   173,     0,   675,   175,     0,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,   676,   191,     0,   677,   678,   192,     0,     0,
     193,   679,   194,   680,     0,   195,   681,   682,     0,   196,
     197,   198,   683,   684,   685,     0,     0,     0,     0,   686,
     201,   687,     0,     0,   688,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,   211,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,   216,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,   228,
     689,     0,   229,   230,   231,   232,   233,   690,   691,   234,
     235,     0,   236,   237,   238,   692,     0,   239,     0,     0,
       0,   693,   241,     0,   242,     0,   243,     0,   244,   694,
     246,   695,     0,   248,     0,   249,     0,   696,     0,   250,
     251,     0,   252,   697,     0,   253,   254,     0,     0,     0,
     698,   256,   257,   258,   699,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,   700,   263,   264,  2640,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,   271,   272,     0,     0,
     273,     0,   702,   274,   275,     0,     0,     0,     0,     0,
     703,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,   704,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,   705,
     303,   304,   305,   306,   706,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   707,   314,     0,     0,   708,
     316,   709,   317,     0,   318,   710,   711,   712,   713,   714,
     323,   324,   325,   326,   327,     0,   715,   328,   329,     0,
       0,   330,   331,   332,   333,   716,   717,   718,   334,   335,
       0,   719,   720,   336,     0,   337,     0,   338,   721,     0,
     340,     0,   341,   342,     0,   343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,   346,   722,   347,
     348,     0,   349,   350,   723,   352,   353,   354,   355,   724,
     725,   358,   726,     0,   359,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   727,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,   383,
       0,   384,   385,   386,   728,   729,   387,     0,   388,     0,
     389,   390,     0,   391,   392,   393,     0,   730,     0,   731,
     395,   396,   397,   398,   399,   732,   733,   402,   403,   404,
     405,     0,   734,   407,     0,     0,     0,   408,   409,   410,
     411,     0,     0,     0,   412,     0,     0,     0,   413,     0,
     414,   415,   416,   417,     0,   418,   419,   420,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,   433,   434,   435,   735,   736,   436,   437,     0,   438,
     439,   737,   441,   442,   443,   738,   739,   444,   445,   446,
     447,   740,   448,   449,     0,     0,   450,   451,   452,   453,
       0,   741,   454,   455,     0,   742,   743,   744,   745,     0,
       0,     0,     0,     0,   460,   461,     0,   746,   747,   748,
     463,   464,   465,   749,   466,   467,   750,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   751,   476,     0,     0,   752,   753,   754,   755,   477,
       0,     0,   478,   756,     0,   757,   479,   480,   481,   758,
     759,     0,     0,     0,     0,     0,     0,   484,   485,     0,
     486,   487,   488,     0,     0,   760,     0,     0,     0,   761,
     762,     0,     0,     0,     0,   763,   764,     0,     0,   765,
     766,     0,     0,   767,   768,   138,     0,   662,   140,   141,
     142,   143,     0,     0,   144,     0,     0,     0,   145,     0,
       0,   663,     0,   147,   148,   149,   150,   664,   152,     0,
     153,     0,     0,   665,   154,   666,   667,   668,   155,   669,
       0,   156,   157,   158,     0,   159,     0,   160,   161,     0,
       0,   162,   670,   671,   163,   164,     0,   165,   672,   673,
     167,     0,   168,   169,   170,   171,   674,   173,     0,   675,
     175,     0,   176,   177,   178,   179,   180,   181,   182,   183,
     184,     0,   185,   186,     0,   187,   188,   189,   676,   191,
       0,   677,   678,   192,     0,     0,   193,   679,   194,   680,
       0,   195,   681,   682,     0,   196,   197,   198,   683,   684,
     685,     0,     0,     0,     0,   686,   201,   687,     0,     0,
    3420,   202,   203,     0,   204,     0,     0,     0,   205,     0,
     206,   207,   208,   209,   210,     0,     0,     0,   211,     0,
       0,   212,   213,   214,     0,     0,     0,   215,     0,   216,
     217,     0,   218,   219,   220,     0,     0,   221,   222,     0,
     223,   224,   225,   226,   227,   228,   689,     0,   229,   230,
     231,   232,   233,   690,   691,   234,   235,     0,   236,   237,
     238,   692,     0,   239,     0,     0,     0,   693,   241,     0,
     242,     0,   243,     0,   244,   694,   246,   695,     0,   248,
       0,   249,     0,   696,     0,   250,   251,     0,   252,   697,
       0,   253,   254,     0,     0,     0,   698,   256,   257,   258,
     699,     0,   259,   260,   261,     0,     0,   262,     0,     0,
       0,   700,   263,   264,   701,     0,     0,   265,     0,     0,
       0,   266,   267,     0,   268,   269,     0,     0,     0,   270,
       0,     0,   271,   272,     0,     0,   273,     0,   702,   274,
     275,     0,     0,     0,     0,     0,   703,   277,     0,   278,
       0,   279,     0,   280,   281,     0,     0,   704,     0,     0,
       0,     0,   282,     0,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,     0,   300,   301,   302,   705,   303,   304,   305,   306,
     706,   307,   308,     0,     0,     0,     0,   309,   310,   311,
     312,   707,   314,     0,     0,   708,   316,   709,   317,     0,
     318,   710,   711,   712,   713,   714,   323,   324,   325,   326,
     327,     0,   715,   328,   329,     0,     0,   330,   331,   332,
     333,   716,   717,   718,   334,   335,     0,   719,   720,   336,
       0,   337,     0,   338,   721,     0,   340,     0,   341,   342,
       0,   343,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   344,   345,   346,   722,   347,   348,     0,   349,   350,
     723,   352,   353,   354,   355,   724,   725,   358,   726,     0,
     359,   360,   361,     0,   362,     0,   363,   364,   365,   366,
     367,     0,   727,   369,   370,     0,     0,   371,     0,     0,
       0,   372,   373,   374,   375,   376,     0,     0,   377,   378,
     379,   380,   381,     0,   382,   383,     0,   384,   385,   386,
     728,   729,   387,     0,   388,     0,   389,   390,     0,   391,
     392,   393,     0,   730,     0,   731,   395,   396,   397,   398,
     399,   732,   733,   402,   403,   404,   405,     0,   734,   407,
       0,     0,     0,   408,   409,   410,   411,     0,     0,     0,
     412,     0,     0,     0,   413,     0,   414,   415,   416,   417,
       0,   418,   419,   420,   421,   422,     0,     0,     0,     0,
       0,   423,   424,   425,     0,   426,   427,     0,   428,     0,
       0,   429,     0,     0,   430,   431,   432,   433,   434,   435,
     735,   736,   436,   437,     0,   438,   439,   737,   441,   442,
     443,   738,   739,   444,   445,   446,   447,   740,   448,   449,
       0,     0,   450,   451,   452,   453,     0,   741,   454,   455,
       0,   742,   743,   744,   745,     0,     0,     0,     0,     0,
     460,   461,     0,   746,   747,   748,   463,   464,   465,   749,
     466,   467,   750,   468,   469,     0,   470,   471,     0,     0,
     472,     0,     0,   473,     0,   474,     0,   751,   476,     0,
       0,   752,   753,   754,   755,   477,     0,     0,   478,   756,
       0,   757,   479,   480,   481,   758,   759,     0,     0,     0,
       0,     0,     0,   484,   485,     0,   486,   487,   488,     0,
       0,   760,     0,     0,     0,   761,   762,     0,     0,     0,
       0,   763,   764,     0,     0,   765,   766,     0,     0,   767,
     768,   138,     0,   662,   140,   141,   142,   143,     0,     0,
     144,     0,     0,     0,   145,     0,     0,   663,     0,   147,
     148,   149,   150,   664,   152,     0,   153,     0,     0,   665,
     154,   666,   667,   668,   155,   669,     0,   156,   157,   158,
       0,   159,     0,   160,   161,     0,     0,   162,   670,   671,
     163,   164,     0,   165,   672,   673,   167,     0,   168,   169,
     170,   171,   674,   173,     0,   675,   175,     0,   176,   177,
     178,   179,   180,   181,   182,   183,   184,     0,   185,   186,
       0,   187,   188,   189,   676,   191,     0,   677,   678,   192,
       0,     0,   193,   679,   194,   680,     0,   195,   681,   682,
       0,   196,   197,   198,   683,   684,   685,     0,     0,     0,
       0,   686,   201,   687,     0,     0,   688,   202,   203,     0,
     204,     0,     0,     0,   205,     0,   206,   207,   208,   209,
     210,     0,     0,     0,   211,     0,     0,   212,   213,   214,
       0,     0,     0,   215,     0,   216,   217,     0,   218,   219,
     220,     0,     0,   221,   222,     0,   223,   224,   225,   226,
     227,   228,   689,     0,   229,   230,   231,   232,   233,   690,
     691,   234,   235,     0,   236,   237,   238,   692,     0,   239,
       0,     0,     0,   693,   241,     0,   242,     0,   243,     0,
     244,   694,   246,   695,     0,   248,     0,   249,     0,   696,
       0,   250,   251,     0,   252,   697,     0,   253,   254,     0,
       0,     0,   698,   256,   257,   258,   699,     0,   259,   260,
     261,     0,     0,   262,     0,     0,     0,   700,   263,   264,
     701,     0,     0,   265,     0,     0,     0,   266,   267,     0,
     268,   269,     0,     0,     0,   270,     0,     0,   271,   272,
       0,     0,   273,     0,   702,   274,   275,     0,     0,     0,
       0,     0,   703,   277,     0,   278,     0,   279,     0,   280,
     281,     0,     0,   704,     0,     0,     0,     0,   282,     0,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,     0,   300,   301,
     302,   705,   303,   304,   305,   306,   706,   307,   308,  4384,
       0,     0,     0,   309,   310,   311,   312,   707,   314,     0,
       0,   708,   316,   709,   317,     0,   318,   710,   711,   712,
     713,   714,   323,   324,   325,   326,   327,     0,   715,   328,
     329,     0,     0,   330,   331,   332,   333,   716,     0,   718,
     334,   335,     0,   719,   720,   336,     0,   337,     0,   338,
     721,     0,   340,     0,   341,   342,     0,   343,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   344,   345,   346,
     722,   347,   348,     0,   349,   350,   723,   352,   353,   354,
     355,   724,   725,   358,   726,     0,   359,   360,   361,     0,
     362,     0,   363,   364,   365,   366,   367,     0,   727,   369,
     370,     0,     0,   371,     0,     0,     0,   372,   373,   374,
     375,   376,     0,     0,   377,   378,   379,   380,   381,     0,
     382,   383,     0,   384,   385,   386,   728,   729,   387,     0,
     388,     0,   389,   390,     0,   391,   392,   393,     0,   730,
       0,   731,   395,   396,   397,   398,   399,   732,   733,   402,
     403,   404,   405,     0,   734,   407,     0,     0,     0,   408,
     409,   410,   411,     0,     0,     0,   412,     0,     0,     0,
     413,     0,   414,   415,   416,   417,     0,   418,   419,   420,
     421,   422,     0,     0,     0,     0,     0,   423,   424,   425,
       0,   426,   427,     0,   428,     0,     0,   429,     0,     0,
     430,   431,   432,   433,   434,   435,   735,   736,   436,   437,
       0,   438,   439,   737,   441,   442,   443,   738,   739,   444,
     445,   446,   447,   740,   448,   449,     0,     0,   450,   451,
     452,   453,     0,   741,   454,   455,     0,   742,   743,   744,
     745,     0,     0,     0,     0,     0,   460,   461,     0,   746,
     747,   748,   463,   464,   465,   749,   466,   467,   750,   468,
     469,     0,   470,   471,     0,     0,   472,     0,     0,   473,
       0,   474,     0,   751,   476,     0,     0,   752,   753,   754,
     755,   477,     0,     0,   478,   756,     0,   757,   479,   480,
     481,   758,   759,     0,     0,     0,     0,     0,     0,   484,
     485,     0,   486,   487,   488,     0,     0,   760,     0,     0,
       0,   761,   762,     0,     0,     0,     0,   763,   764,     0,
       0,   765,   766,     0,     0,   767,   768,   138,     0,   662,
     140,   141,   142,   143,     0,     0,   144,     0,     0,     0,
     145,     0,     0,   663,     0,   147,   148,   149,   150,   664,
     152,     0,   153,     0,     0,   665,   154,   666,   667,   668,
     155,   669,     0,   156,   157,   158,     0,   159,     0,   160,
     161,     0,     0,   162,   670,   671,   163,   164,     0,   165,
     672,   673,   167,     0,   168,   169,   170,   171,   674,   173,
       0,   675,   175,     0,   176,   177,   178,   179,   180,   181,
     182,   183,   184,     0,   185,   186,     0,   187,   188,   189,
     676,   191,     0,   677,   678,   192,     0,     0,   193,   679,
     194,   680,     0,   195,   681,   682,     0,   196,   197,   198,
     683,   684,   685,     0,     0,     0,     0,   686,   201,   687,
       0,     0,   688,   202,   203,     0,   204,     0,     0,     0,
     205,     0,   206,   207,   208,   209,   210,     0,     0,     0,
     211,     0,     0,   212,   213,   214,     0,     0,     0,   215,
       0,   216,   217,     0,   218,   219,   220,     0,     0,   221,
     222,     0,   223,   224,   225,   226,   227,   228,   689,     0,
     229,   230,   231,   232,   233,   690,   691,   234,   235,     0,
     236,   237,   238,   692,     0,   239,     0,     0,     0,   693,
     241,     0,   242,     0,   243,     0,   244,   694,   246,   695,
       0,   248,     0,   249,     0,   696,     0,   250,   251,     0,
     252,   697,     0,   253,   254,     0,     0,     0,   698,   256,
     257,   258,   699,     0,   259,   260,   261,     0,     0,   262,
       0,     0,     0,   700,   263,   264,   701,     0,     0,   265,
       0,     0,     0,   266,   267,     0,   268,   269,     0,     0,
       0,   270,     0,     0,   271,   272,     0,     0,   273,     0,
     702,   274,   275,     0,     0,     0,     0,     0,   703,   277,
       0,   278,     0,   279,     0,   280,   281,     0,     0,   704,
       0,     0,     0,     0,   282,     0,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,     0,   300,   301,   302,   705,   303,   304,
     305,   306,   706,   307,   308,     0,     0,     0,     0,   309,
     310,   311,   312,   707,   314,     0,     0,   708,   316,   709,
     317,     0,   318,   710,   711,   712,   713,   714,   323,   324,
     325,   326,   327,     0,   715,   328,   329,     0,     0,   330,
     331,   332,   333,   716,     0,   718,   334,   335,     0,   719,
     720,   336,     0,   337,     0,   338,   721,     0,   340,     0,
     341,   342,     0,   343,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   344,   345,   346,   722,   347,   348,     0,
     349,   350,   723,   352,   353,   354,   355,   724,   725,   358,
     726,     0,   359,   360,   361,     0,   362,     0,   363,   364,
     365,   366,   367,     0,   727,   369,   370,     0,     0,   371,
       0,     0,     0,   372,   373,   374,   375,   376,     0,     0,
     377,   378,   379,   380,   381,     0,   382,   383,     0,   384,
     385,   386,   728,   729,   387,     0,   388,     0,   389,   390,
       0,   391,   392,   393,     0,   730,     0,   731,   395,   396,
     397,   398,   399,   732,   733,   402,   403,   404,   405,     0,
     734,   407,     0,     0,     0,   408,   409,   410,   411,     0,
       0,     0,   412,     0,     0,     0,   413,     0,   414,   415,
     416,   417,     0,   418,   419,   420,   421,   422,     0,     0,
       0,     0,     0,   423,   424,   425,     0,   426,   427,     0,
     428,     0,     0,   429,     0,     0,   430,   431,   432,   433,
     434,   435,   735,   736,   436,   437,     0,   438,   439,   737,
     441,   442,   443,   738,   739,   444,   445,   446,   447,   740,
     448,   449,     0,     0,   450,   451,   452,   453,     0,   741,
     454,   455,     0,   742,   743,   744,   745,     0,     0,     0,
       0,     0,   460,   461,     0,   746,   747,   748,   463,   464,
     465,   749,   466,   467,   750,   468,   469,     0,   470,   471,
       0,     0,   472,     0,     0,   473,     0,   474,     0,   751,
     476,     0,     0,   752,   753,   754,   755,   477,     0,     0,
     478,   756,     0,   757,   479,   480,   481,   758,   759,     0,
       0,     0,     0,     0,     0,   484,   485,     0,   486,   487,
     488,     0,     0,   760,     0,     0,     0,   761,   762,     0,
       0,     0,     0,   763,   764,     0,     0,   765,   766,     0,
       0,   767,   768,   138,     0,   662,   140,   141,   142,   143,
       0,     0,   144,     0,     0,     0,   145,     0,     0,   663,
       0,   147,   148,   149,   150,   664,   152,     0,   153,     0,
       0,   665,   154,   666,   667,   668,   155,   669,     0,   156,
     157,   158,     0,   159,     0,   160,   161,     0,     0,   162,
     670,   671,   163,   164,     0,   165,   672,   673,   167,     0,
     168,   169,   170,   171,   674,   173,     0,   675,   175,     0,
     176,   177,   178,   179,   180,   181,   182,   183,   184,     0,
     185,   186,     0,   187,   188,   189,   676,   191,     0,   677,
     678,   192,     0,     0,   193,   679,   194,   680,     0,   195,
     681,   682,     0,   196,   197,   198,   683,   684,   685,     0,
       0,     0,     0,   686,   201,   687,     0,     0,   688,   202,
     203,     0,   204,     0,     0,     0,   205,     0,   206,   207,
     208,   209,   210,     0,     0,     0,   211,     0,     0,   212,
     213,   214,     0,     0,     0,   215,     0,   216,   217,     0,
     218,   219,   220,     0,     0,   221,   222,     0,   223,   224,
     225,   226,   227,   228,   689,     0,   229,   230,   231,   232,
     233,   690,   691,   234,   235,     0,   236,   237,   238,   692,
       0,   239,     0,     0,     0,   693,   241,     0,   242,     0,
     243,     0,   244,   694,   246,   695,     0,   248,     0,   249,
       0,   696,     0,   250,   251,     0,   252,   697,     0,   253,
     254,     0,     0,     0,   698,   256,   257,   258,   699,     0,
     259,   260,   261,     0,     0,   262,     0,     0,     0,   700,
     263,   264,  1713,     0,     0,   265,     0,     0,     0,   266,
     267,     0,   268,   269,     0,     0,     0,   270,     0,     0,
     271,   272,     0,     0,   273,     0,   702,   274,   275,     0,
       0,     0,     0,     0,   703,   277,     0,   278,     0,   279,
       0,   280,   281,     0,     0,   704,     0,     0,     0,     0,
     282,     0,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,     0,
     300,   301,   302,   705,   303,   304,   305,   306,   706,   307,
     308,     0,     0,     0,     0,   309,   310,   311,   312,   707,
     314,     0,     0,   708,   316,   709,   317,     0,   318,   710,
     711,   712,   713,   714,   323,   324,   325,   326,   327,     0,
     715,   328,   329,     0,     0,   330,   331,   332,   333,   716,
       0,   718,   334,   335,     0,   719,   720,   336,     0,   337,
       0,   338,   721,     0,   340,     0,   341,   342,     0,   343,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   344,
     345,   346,   722,   347,   348,     0,   349,   350,   723,   352,
     353,   354,   355,   724,   725,   358,   726,     0,   359,   360,
     361,     0,   362,     0,   363,   364,   365,   366,   367,     0,
     727,   369,   370,     0,     0,   371,     0,     0,     0,   372,
     373,   374,   375,   376,     0,     0,   377,   378,   379,   380,
     381,     0,   382,   383,     0,   384,   385,   386,   728,   729,
     387,     0,   388,     0,   389,   390,     0,   391,   392,   393,
       0,   730,     0,   731,   395,   396,   397,   398,   399,   732,
     733,   402,   403,   404,   405,     0,   734,   407,     0,     0,
       0,   408,   409,   410,   411,     0,     0,     0,   412,     0,
       0,     0,   413,     0,   414,   415,   416,   417,     0,   418,
     419,   420,   421,   422,     0,     0,     0,     0,     0,   423,
     424,   425,     0,   426,   427,     0,   428,     0,     0,   429,
       0,     0,   430,   431,   432,   433,   434,   435,   735,   736,
     436,   437,     0,   438,   439,   737,   441,   442,   443,   738,
     739,   444,   445,   446,   447,   740,   448,   449,     0,     0,
     450,   451,   452,   453,     0,   741,   454,   455,     0,   742,
     743,   744,   745,     0,     0,     0,     0,     0,   460,   461,
       0,   746,   747,   748,   463,   464,   465,   749,   466,   467,
     750,   468,   469,     0,   470,   471,     0,     0,   472,     0,
       0,   473,     0,   474,     0,   751,   476,     0,     0,   752,
     753,   754,   755,   477,     0,     0,   478,   756,     0,   757,
     479,   480,   481,   758,   759,     0,     0,     0,     0,     0,
       0,   484,   485,     0,   486,   487,   488,     0,     0,   760,
       0,     0,     0,   761,   762,     0,     0,     0,     0,   763,
     764,     0,     0,   765,   766,     0,     0,   767,   768,   138,
       0,   662,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,     0,     0,   663,     0,   147,   148,   149,
     150,   664,   152,     0,   153,     0,     0,   665,   154,   666,
     667,   668,   155,   669,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,   670,   671,   163,   164,
       0,   165,   672,   673,   167,     0,   168,   169,   170,   171,
     674,   173,     0,   675,   175,     0,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,   676,   191,     0,   677,   678,   192,     0,     0,
     193,   679,   194,   680,     0,   195,   681,   682,     0,   196,
     197,   198,   683,   684,   685,     0,     0,     0,     0,   686,
     201,   687,     0,     0,   688,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,   211,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,   216,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,   228,
     689,     0,   229,   230,   231,   232,   233,   690,   691,   234,
     235,     0,   236,   237,   238,   692,     0,   239,     0,     0,
       0,   693,   241,     0,   242,     0,   243,     0,   244,   694,
     246,   695,     0,   248,     0,   249,     0,   696,     0,   250,
     251,     0,   252,   697,     0,   253,   254,     0,     0,     0,
     698,   256,   257,   258,   699,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,   700,   263,   264,  1715,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,   271,   272,     0,     0,
     273,     0,   702,   274,   275,     0,     0,     0,     0,     0,
     703,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,   704,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,   705,
     303,   304,   305,   306,   706,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   707,   314,     0,     0,   708,
     316,   709,   317,     0,   318,   710,   711,   712,   713,   714,
     323,   324,   325,   326,   327,     0,   715,   328,   329,     0,
       0,   330,   331,   332,   333,   716,     0,   718,   334,   335,
       0,   719,   720,   336,     0,   337,     0,   338,   721,     0,
     340,     0,   341,   342,     0,   343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,   346,   722,   347,
     348,     0,   349,   350,   723,   352,   353,   354,   355,   724,
     725,   358,   726,     0,   359,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   727,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,   383,
       0,   384,   385,   386,   728,   729,   387,     0,   388,     0,
     389,   390,     0,   391,   392,   393,     0,   730,     0,   731,
     395,   396,   397,   398,   399,   732,   733,   402,   403,   404,
     405,     0,   734,   407,     0,     0,     0,   408,   409,   410,
     411,     0,     0,     0,   412,     0,     0,     0,   413,     0,
     414,   415,   416,   417,     0,   418,   419,   420,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,   433,   434,   435,   735,   736,   436,   437,     0,   438,
     439,   737,   441,   442,   443,   738,   739,   444,   445,   446,
     447,   740,   448,   449,     0,     0,   450,   451,   452,   453,
       0,   741,   454,   455,     0,   742,   743,   744,   745,     0,
       0,     0,     0,     0,   460,   461,     0,   746,   747,   748,
     463,   464,   465,   749,   466,   467,   750,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   751,   476,     0,     0,   752,   753,   754,   755,   477,
       0,     0,   478,   756,     0,   757,   479,   480,   481,   758,
     759,     0,     0,     0,     0,     0,     0,   484,   485,     0,
     486,   487,   488,     0,     0,   760,     0,     0,     0,   761,
     762,     0,     0,     0,     0,   763,   764,     0,     0,   765,
     766,     0,     0,   767,   768,   138,     0,   139,   140,   141,
     142,   143,     0,     0,   144,     0,     0,     0,   145,     0,
       0,   146,     0,   147,   148,   149,   150,   151,   152,     0,
     153,     0,     0,     0,   154,   666,     0,     0,   155,     0,
       0,   156,   157,   158,     0,   159,     0,   160,   161,     0,
       0,   162,     0,     0,   163,   164,     0,   165,   166,     0,
     167,     0,   168,   169,   170,   171,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,   183,
     184,     0,   185,   186,     0,   187,   188,   189,   190,   191,
       0,     0,     0,   192,     0,     0,   193,     0,   194,     0,
       0,   195,     0,     0,     0,   196,   197,   198,     0,     0,
    1751,     0,     0,     0,     0,   200,   201,   687,     0,     0,
       0,   202,   203,     0,   204,     0,     0,     0,   205,     0,
     206,   207,   208,   209,   210,     0,     0,     0,   211,     0,
       0,   212,   213,   214,     0,     0,     0,   215,     0,   216,
     217,     0,   218,   219,   220,     0,     0,   221,   222,     0,
     223,   224,   225,   226,   227,   228,     0,     0,   229,   230,
     231,   232,   233,     0,   691,   234,   235,     0,   236,   237,
     238,   692,     0,   239,     0,     0,     0,   240,   241,     0,
     242,     0,   243,     0,   244,   245,   246,   247,     0,   248,
       0,   249,     0,     0,     0,   250,   251,     0,   252,   697,
       0,   253,   254,     0,     0,     0,   255,   256,   257,   258,
       0,     0,   259,   260,   261,     0,     0,   262,     0,     0,
       0,     0,   263,   264,     0,     0,     0,   265,     0,     0,
       0,   266,   267,     0,   268,   269,     0,     0,     0,   270,
       0,     0,   271,   272,     0,     0,   273,     0,     0,   274,
     275,     0,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,     0,   280,   281,     0,     0,   704,     0,     0,
       0,     0,   282,     0,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,     0,   300,   301,   302,     0,   303,   304,   305,   306,
       0,   307,   308,     0,     0,     0,     0,   309,   310,   311,
     312,   313,   314,     0,     0,   315,   316,     0,   317,     0,
     318,     0,   319,   320,   321,   322,   323,   324,   325,   326,
     327,     0,   715,   328,   329,     0,     0,   330,   331,   332,
     333,     0,     0,     0,   334,   335,     0,   719,   720,   336,
       0,   337,     0,   338,   339,     0,   340,     0,   341,   342,
       0,   343,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   344,   345,   346,     0,   347,   348,     0,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,     0,     0,
     359,   360,   361,     0,   362,     0,   363,   364,   365,   366,
     367,     0,   368,   369,   370,     0,     0,   371,     0,     0,
       0,   372,   373,   374,   375,   376,     0,     0,   377,   378,
     379,   380,   381,     0,   382,   383,     0,   384,   385,   386,
       0,     0,   387,     0,   388,     0,   389,   390,     0,   391,
     392,   393,     0,   394,     0,     0,   395,   396,   397,   398,
     399,   400,   401,   402,   403,   404,   405,     0,   406,   407,
       0,     0,     0,   408,   409,   410,   411,     0,     0,     0,
     412,     0,     0,     0,   413,     0,   414,   415,   416,   417,
       0,   418,   419,   420,   421,   422,     0,     0,     0,     0,
       0,   423,   424,   425,     0,   426,   427,     0,   428,     0,
       0,   429,     0,     0,   430,   431,   432,   433,   434,   435,
       0,     0,   436,   437,     0,   438,   439,   440,   441,   442,
     443,     0,     0,   444,   445,   446,   447,     0,   448,   449,
       0,     0,   450,   451,   452,   453,     0,   741,   454,   455,
       0,  1752,   457,   458,  1753,     0,     0,     0,     0,     0,
     460,   461,     0,     0,   747,   462,   463,   464,   465,   749,
     466,   467,   750,   468,   469,     0,   470,   471,     0,     0,
     472,     0,     0,   473,     0,   474,     0,   475,   476,     0,
       0,     0,     0,     0,     0,   477,     0,     0,   478,     0,
       0,     0,   479,   480,   481,   482,   483,     0,     0,     0,
       0,     0,     0,   484,   485,     0,   486,   487,   488,     0,
       0,   489,     0,     0,     0,   138,     0,   139,   140,   141,
     142,   143,     0,     0,   144,     0,     0,     0,   145,   767,
     768,   146,     0,   147,   148,   149,   150,   151,   152,     0,
     153,     0,     0,     0,   154,     0,     0,     0,   155,     0,
       0,   156,   157,   158,     0,   159,     0,   160,   161,     0,
       0,   162,     0,     0,   163,   164,     0,   165,   166,     0,
     167,     0,   168,   169,   170,   171,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,   183,
     184,     0,   185,   186,  2855,   187,   188,   189,   190,   191,
       0,     0,     0,   192,     0,     0,   193,     0,   194,     0,
       0,   195,     0,     0,     0,   196,   197,   198,     0,     0,
     199,     0,     0,     0,     0,   200,   201,     0,     0,     0,
       0,   202,   203,     0,   204,     0,     0,     0,   205,     0,
     206,   207,   208,   209,   210,     0,     0,     0,   211,     0,
       0,   212,   213,   214,     0,     0,     0,   215,     0,   216,
     217,     0,   218,   219,   220,     0,     0,   221,   222,     0,
     223,   224,   225,   226,   227,   228,     0,     0,   229,   230,
     231,   232,   233,     0,     0,   234,   235,     0,   236,   237,
     238,     0,     0,   239,     0,     0,     0,   240,   241,     0,
     242,   651,   243,     0,   244,   245,   246,   247,     0,   248,
       0,   249,     0,     0,     0,   250,   251,     0,   252,     0,
       0,   253,   254,     0,     0,     0,   255,   256,   257,   258,
       0,     0,   259,   260,   261,  1999,     0,   262,     0,     0,
       0,     0,   263,   264,     0,     0,     0,   265,     0,     0,
       0,   266,   267,     0,   268,   269,     0,     0,     0,   270,
    2000,     0,   271,   272,     0,     0,   273,     0,     0,   274,
     275,     0,  2977,     0,     0,     0,   276,   277,     0,   278,
       0,   279,     0,   280,   281,     0,     0,     0,     0,     0,
       0,     0,   282,     0,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,     0,   300,   301,   302,     0,   303,   304,   305,   306,
       0,   307,   308,     0,     0,     0,     0,   309,   310,   311,
     312,   313,   314,     0,     0,   315,   316,     0,   317,     0,
     318,     0,   319,   320,   321,   322,   323,   324,   325,   326,
     327,     0,     0,   328,   329,     0,     0,   330,   331,   332,
     333,     0,     0,     0,   334,   335,     0,     0,     0,   336,
       0,   337,     0,   338,   339,     0,   340,     0,   341,   342,
       0,   343,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   344,   345,   346,     0,   347,   348,  2474,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,     0,     0,
     359,   360,   361,     0,   362,     0,   363,   364,   365,   366,
     367,     0,   368,   369,   370,     0,     0,   371,     0,     0,
       0,   372,   373,   374,   375,   376,     0,     0,   377,   378,
     379,   380,   381,     0,   382,   383,     0,   384,   385,   386,
       0,     0,   387,     0,   388,     0,   389,   390,     0,   391,
     392,   393,     0,   394,     0,     0,   395,   396,   397,   398,
     399,   400,   401,   402,   403,   404,   405,     0,   406,   407,
    -478,     0,     0,   408,   409,   410,   411,     0,     0,     0,
     412,     0,     0,     0,   413,     0,   414,   415,   416,   417,
       0,   418,   419,   420,   421,   422,   652,     0,     0,     0,
       0,   423,   424,   425,     0,   426,   427,     0,   428,     0,
       0,   429,     0,     0,   430,   431,   432,   433,   434,   435,
       0,     0,   436,   437,     0,   438,   439,   440,   441,   442,
     443,     0,     0,   444,   445,   446,   447,     0,   448,   449,
       0,     0,   450,   451,   452,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,     0,     0,     0,     0,     0,
     460,   461,     0,     0,     0,   462,   463,   464,   465,     0,
     466,   467,     0,   468,   469,     0,   470,   471,     0,     0,
     472,     0,     0,   473,     0,   474,     0,   475,   476,     0,
       0,     0,     0,     0,     0,   477,     0,     0,   478,     0,
       0,     0,   479,   480,   481,   482,   483,     0,     0,     0,
       0,     0,     0,   484,   485,     0,   486,   487,   488,     0,
       0,   489,     0,   138,     0,   139,   140,   141,   142,   143,
       0,     0,   144,     0,     0,     0,   145,     0,     0,   146,
    2926,   147,   148,   149,   150,   151,   152,     0,   153,     0,
       0,     0,   154,     0,     0,     0,   155,     0,     0,   156,
     157,   158,     0,   159,     0,   160,   161,     0,     0,   162,
       0,     0,   163,   164,     0,   165,   166,     0,   167,     0,
     168,   169,   170,   171,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,   183,   184,     0,
     185,   186,  2855,   187,   188,   189,   190,   191,     0,     0,
       0,   192,     0,     0,   193,     0,   194,     0,     0,   195,
       0,     0,     0,   196,   197,   198,     0,     0,   199,     0,
       0,     0,     0,   200,   201,     0,     0,     0,     0,   202,
     203,     0,   204,     0,     0,     0,   205,     0,   206,   207,
     208,   209,   210,     0,     0,     0,   211,     0,     0,   212,
     213,   214,     0,     0,     0,   215,     0,   216,   217,     0,
     218,   219,   220,     0,     0,   221,   222,     0,   223,   224,
     225,   226,   227,   228,     0,     0,   229,   230,   231,   232,
     233,     0,     0,   234,   235,     0,   236,   237,   238,     0,
       0,   239,     0,     0,     0,   240,   241,     0,   242,   651,
     243,     0,   244,   245,   246,   247,     0,   248,     0,   249,
       0,     0,     0,   250,   251,     0,   252,     0,     0,   253,
     254,     0,     0,     0,   255,   256,   257,   258,     0,     0,
     259,   260,   261,  1999,     0,   262,     0,     0,     0,     0,
     263,   264,     0,     0,     0,   265,     0,     0,     0,   266,
     267,     0,   268,   269,     0,     0,     0,   270,  2000,     0,
     271,   272,     0,     0,   273,     0,     0,   274,   275,     0,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
       0,   280,   281,     0,     0,     0,     0,     0,     0,     0,
     282,     0,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,     0,
     300,   301,   302,     0,   303,   304,   305,   306,     0,   307,
     308,     0,     0,     0,     0,   309,   310,   311,   312,   313,
     314,     0,     0,   315,   316,     0,   317,     0,   318,     0,
     319,   320,   321,   322,   323,   324,   325,   326,   327,     0,
       0,   328,   329,     0,     0,   330,   331,   332,   333,     0,
       0,     0,   334,   335,     0,     0,     0,   336,     0,   337,
       0,   338,   339,     0,   340,     0,   341,   342,     0,   343,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   344,
     345,   346,     0,   347,   348,     0,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,     0,     0,   359,   360,
     361,     0,   362,     0,   363,   364,   365,   366,   367,     0,
     368,   369,   370,     0,     0,   371,     0,     0,     0,   372,
     373,   374,   375,   376,     0,     0,   377,   378,   379,   380,
     381,     0,   382,   383,     0,   384,   385,   386,     0,     0,
     387,     0,   388,     0,   389,   390,     0,   391,   392,   393,
       0,   394,     0,     0,   395,   396,   397,   398,   399,   400,
     401,   402,   403,   404,   405,     0,   406,   407,     0,     0,
       0,   408,   409,   410,   411,     0,     0,     0,   412,     0,
       0,     0,   413,     0,   414,   415,   416,   417,     0,   418,
     419,   420,   421,   422,   652,     0,     0,     0,     0,   423,
     424,   425,     0,   426,   427,     0,   428,     0,     0,   429,
       0,     0,   430,   431,   432,   433,   434,   435,     0,     0,
     436,   437,     0,   438,   439,   440,   441,   442,   443,     0,
       0,   444,   445,   446,   447,     0,   448,   449,     0,     0,
     450,   451,   452,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,     0,     0,     0,     0,     0,   460,   461,
       0,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,   469,     0,   470,   471,     0,     0,   472,     0,
       0,   473,     0,   474,     0,   475,   476,     0,     0,     0,
       0,     0,     0,   477,     0,     0,   478,     0,     0,     0,
     479,   480,   481,   482,   483,     0,     0,     0,     0,     0,
       0,   484,   485,     0,   486,   487,   488,     0,     0,   489,
       0,   138,     0,   139,   140,   141,   142,   143,     0,     0,
     144,     0,     0,     0,   145,     0,     0,   146,  2926,   147,
     148,   149,   150,   151,   152,     0,   153,     0,     0,     0,
     154,     0,     0,     0,   155,     0,     0,   156,   157,   158,
       0,   159,     0,   160,   161,     0,     0,   162,     0,     0,
     163,   164,     0,   165,   166,     0,   167,     0,   168,   169,
     170,   171,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,   183,   184,     0,   185,   186,
       0,   187,   188,   189,   190,   191,     0,     0,     0,   192,
       0,     0,   193,     0,   194,     0,     0,   195,     0,     0,
       0,   196,   197,   198,     0,     0,   199,     0,     0,     0,
       0,   200,   201,     0,     0,     0,     0,   202,   203,     0,
     204,     0,     0,     0,   205,     0,   206,   207,   208,   209,
     210,     0,     0,     0,   211,     0,     0,   212,   213,   214,
       0,     0,     0,   215,     0,   216,   217,     0,   218,   219,
     220,     0,     0,   221,   222,     0,   223,   224,   225,   226,
     227,   228,     0,     0,   229,   230,   231,   232,   233,     0,
       0,   234,   235,     0,   236,   237,   238,     0,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,   243,     0,
     244,   245,   246,   247,     0,   248,     0,   249,     0,     0,
       0,   250,   251,     0,   252,     0,     0,   253,   254,     0,
       0,     0,   255,   256,   257,   258,     0,     0,   259,   260,
     261,     0,     0,   262,     0,     0,     0,     0,   263,   264,
       0,     0,     0,   265,     0,     0,     0,   266,   267,     0,
     268,   269,     0,     0,     0,   270,     0,     0,   271,   272,
       0,     0,   273,     0,     0,   274,   275,     0,     0,     0,
       0,     0,   276,   277,     0,   278,     0,   279,     0,   280,
     281,     0,     0,     0,     0,     0,     0,     0,   282,     0,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,     0,   300,   301,
     302,     0,   303,   304,   305,   306,     0,   307,   308,     0,
       0,     0,     0,   309,   310,   311,   312,   313,   314,     0,
       0,   315,   316,     0,   317,     0,   318,     0,   319,   320,
     321,   322,   323,   324,   325,   326,   327,     0,     0,   328,
     329,     0,     0,   330,   331,   332,   333,     0,     0,     0,
     334,   335,     0,     0,     0,   336,     0,   337,     0,   338,
     339,     0,   340,     0,   341,   342,     0,   343,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   344,   345,   346,
       0,   347,   348,     0,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,     0,     0,   359,   360,   361,     0,
     362,     0,   363,   364,   365,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,     0,     0,   372,   373,   374,
     375,   376,     0,     0,   377,   378,   379,   380,   381,     0,
     382,   383,     0,   384,   385,   386,     0,     0,   387,     0,
     388,     0,   389,   390,     0,   391,   392,   393,     0,   394,
       0,     0,   395,   396,   397,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,  2301,     0,     0,   408,
     409,   410,   411,     0,     0,     0,   412,     0,     0,     0,
     413,     0,   414,   415,   416,   417,     0,   418,   419,   420,
     421,   422,     0,     0,     0,     0,     0,   423,   424,   425,
       0,   426,   427,     0,   428,     0,     0,   429,     0,     0,
     430,   431,   432,   433,   434,   435,     0,     0,   436,   437,
       0,   438,   439,   440,   441,   442,   443,     0,     0,   444,
     445,   446,   447,     0,   448,   449,     0,     0,   450,   451,
     452,   453,     0,     0,   454,   455,     0,   456,   457,   458,
     459,     0,     0,     0,     0,     0,   460,   461,     0,     0,
       0,   462,   463,   464,   465,     0,   466,   467,     0,   468,
     469,     0,   470,   471,     0,     0,   472,     0,     0,   473,
       0,   474,     0,   475,   476,     0,     0,     0,     0,     0,
       0,   477,     0,     0,   478,     0,     0,     0,   479,   480,
     481,   482,   483,     0,     0,     0,     0,     0,     0,   484,
     485,     0,   486,   487,   488,     0,     0,   489,     0,   138,
       0,   139,   140,   141,   142,   143,     0,     0,   144,  2745,
       0,     0,   145,     0,     0,   146,   768,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,   164,
       0,   165,   166,     0,   167,     0,   168,   169,   170,   171,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,   190,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
     201,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,   211,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,   216,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,   228,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,     0,     0,   239,     0,     0,
       0,   240,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,   250,
     251,     0,   252,     0,     0,   253,   254,     0,     0,     0,
     255,   256,   257,   258,     0,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,   264,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,   271,   272,     0,     0,
     273,     0,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,   334,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,   342,     0,   343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,   346,     0,   347,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,     0,     0,   359,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,   383,
       0,   384,   385,   386,     0,     0,   387,     0,   388,     0,
     389,   390,     0,   391,   392,   393,     0,   394,     0,     0,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,     0,     0,     0,   408,   409,   410,
     411,     0,     0,     0,   412,     0,     0,     0,   413,     0,
     414,   415,   416,   417,     0,   418,   419,   420,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,     0,     0,     0,     0,   484,   485,     0,
     486,   487,   488,     0,     0,   489,     0,     0,     0,   138,
       0,   139,   140,   141,   142,   143,     0,  4515,   144,     0,
       0,     0,   145,  4516,   768,   146,     0,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,   164,
       0,   165,   166,     0,   167,     0,   168,   169,   170,   171,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,   190,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
     201,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,   211,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,   216,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,   228,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,     0,     0,   239,     0,     0,
       0,   240,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,   250,
     251,     0,   252,     0,     0,   253,   254,     0,     0,     0,
     255,   256,   257,   258,     0,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,   264,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,   271,   272,     0,     0,
     273,     0,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,   334,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,   342,     0,   343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,   346,     0,   347,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,     0,     0,   359,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,   383,
       0,   384,   385,   386,     0,     0,   387,     0,   388,     0,
     389,   390,     0,   391,   392,   393,     0,   394,     0,     0,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,     0,     0,     0,   408,   409,   410,
     411,     0,     0,     0,   412,     0,     0,     0,   413,     0,
     414,   415,   416,   417,     0,   418,   419,   420,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,     0,     0,     0,     0,   484,   485,     0,
     486,   487,   488,     0,     0,   489,     0,     0,     0,   138,
       0,   139,   140,   141,   142,   143,  1087,     0,   144,     0,
       0,     0,   145,     0,   768,   146,     0,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,   164,
       0,   165,   166,     0,   167,     0,   168,   169,   170,   171,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,   190,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
     201,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,   211,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,   216,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,   228,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,     0,     0,   239,     0,     0,
       0,   240,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,   250,
     251,     0,   252,     0,     0,   253,   254,     0,     0,     0,
     255,   256,   257,   258,     0,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,   264,     0,  1299,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,   271,   272,     0,     0,
     273,     0,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,   334,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,   342,     0,   343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,   346,     0,   347,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,     0,     0,   359,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,   383,
       0,   384,   385,   386,     0,     0,   387,     0,   388,     0,
     389,   390,     0,   391,   392,   393,     0,   394,     0,     0,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,     0,     0,     0,   408,   409,   410,
     411,     0,     0,     0,   412,     0,     0,     0,   413,     0,
     414,   415,   416,   417,     0,   418,   419,   420,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,     0,     0,     0,     0,   484,   485,     0,
     486,   487,   488,     0,     0,   489,     0,   138,     0,   139,
     140,   141,   142,   143,     0,     0,   144,     0,     0,     0,
     145,     0,     0,   146,   534,   147,   148,   149,   150,   151,
     152,     0,   153,     0,     0,     0,   154,     0,     0,     0,
     155,     0,     0,   156,   157,   158,     0,   159,     0,   160,
     161,     0,     0,   162,     0,     0,   163,   164,     0,   165,
     166,     0,   167,     0,   168,   169,   170,   171,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,   183,   184,     0,   185,   186,     0,   187,   188,   189,
     190,   191,     0,     0,     0,   192,     0,     0,   193,     0,
     194,     0,     0,   195,     0,     0,     0,   196,   197,   198,
       0,     0,   199,     0,     0,     0,     0,   200,   201,     0,
       0,     0,     0,   202,   203,     0,   204,     0,     0,     0,
     205,     0,   206,   207,   208,   209,   210,     0,     0,     0,
     211,     0,     0,   212,   213,   214,     0,     0,     0,   215,
       0,   216,   217,     0,   218,   219,   220,     0,     0,   221,
     222,     0,   223,   224,   225,   226,   227,   228,     0,     0,
     229,   230,   231,   232,   233,     0,     0,   234,   235,     0,
     236,   237,   238,     0,     0,   239,     0,     0,     0,   240,
     241,     0,   242,     0,   243,     0,   244,   245,   246,   247,
       0,   248,     0,   249,     0,     0,     0,   250,   251,     0,
     252,     0,     0,   253,   254,     0,     0,     0,   255,   256,
     257,   258,     0,     0,   259,   260,   261,     0,     0,   262,
       0,     0,     0,     0,   263,   264,     0,     0,     0,   265,
       0,     0,     0,   266,   267,     0,   268,   269,     0,     0,
       0,   270,     0,     0,   271,   272,     0,     0,   273,     0,
       0,   274,   275,     0,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,     0,   280,   281,     0,     0,     0,
       0,     0,     0,     0,   282,     0,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,     0,   300,   301,   302,     0,   303,   304,
     305,   306,     0,   307,   308,     0,     0,     0,     0,   309,
     310,   311,   312,   313,   314,     0,     0,   315,   316,     0,
     317,     0,   318,     0,   319,   320,   321,   322,   323,   324,
     325,   326,   327,     0,     0,   328,   329,     0,     0,   330,
     331,   332,   333,     0,     0,     0,   334,   335,     0,     0,
       0,   336,     0,   337,     0,   338,   339,     0,   340,     0,
     341,   342,     0,   343,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   344,   345,   346,     0,   347,   348,     0,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
       0,     0,   359,   360,   361,     0,   362,     0,   363,   364,
     365,   366,   367,     0,   368,   369,   370,     0,     0,   371,
       0,     0,     0,   372,   373,   374,   375,   376,     0,     0,
     377,   378,   379,   380,   381,     0,   382,   383,     0,   384,
     385,   386,     0,     0,   387,     0,   388,     0,   389,   390,
       0,   391,   392,   393,     0,   394,     0,     0,   395,   396,
     397,   398,   399,   400,   401,   402,   403,   404,   405,     0,
     406,   407,     0,     0,     0,   408,   409,   410,   411,     0,
       0,     0,   412,     0,     0,     0,   413,     0,   414,   415,
     416,   417,     0,   418,   419,   420,   421,   422,     0,     0,
       0,     0,     0,   423,   424,   425,     0,   426,   427,     0,
     428,     0,     0,   429,     0,     0,   430,   431,   432,   433,
     434,   435,     0,     0,   436,   437,     0,   438,   439,   440,
     441,   442,   443,     0,     0,   444,   445,   446,   447,     0,
     448,   449,     0,     0,   450,   451,   452,   453,     0,     0,
     454,   455,     0,   456,   457,   458,   459,     0,     0,     0,
       0,     0,   460,   461,     0,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,   469,     0,   470,   471,
       0,     0,   472,     0,     0,   473,     0,   474,     0,   475,
     476,     0,     0,     0,     0,     0,     0,   477,     0,     0,
     478,     0,     0,     0,   479,   480,   481,   482,   483,     0,
       0,     0,     0,     0,     0,   484,   485,     0,   486,   487,
     488,     0,     0,   489,     0,     0,     0,     0,   138,  2707,
     139,   140,   141,   142,   143,     0,     0,   144,     0,     0,
       0,   145,   534,     0,   146,     0,   147,   148,   149,   150,
     151,   152,     0,   153,     0,     0,     0,   154,     0,     0,
       0,   155,     0,     0,   156,   157,   158,     0,   159,     0,
     160,   161,     0,     0,   162,     0,     0,   163,   164,     0,
     165,   166,     0,   167,     0,   168,   169,   170,   171,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,   183,   184,     0,   185,   186,     0,   187,   188,
     189,   190,   191,     0,     0,     0,   192,     0,     0,   193,
       0,   194,     0,     0,   195,     0,     0,     0,   196,   197,
     198,     0,     0,   199,     0,     0,     0,     0,   200,   201,
       0,     0,     0,     0,   202,   203,     0,   204,     0,     0,
       0,   205,     0,   206,   207,   208,   209,   210,     0,     0,
       0,   211,     0,     0,   212,   213,   214,     0,     0,     0,
     215,     0,   216,   217,     0,   218,   219,   220,     0,     0,
     221,   222,     0,   223,   224,   225,   226,   227,   228,     0,
       0,   229,   230,   231,   232,   233,     0,     0,   234,   235,
       0,   236,   237,   238,     0,     0,   239,     0,     0,     0,
     240,   241,     0,   242,     0,   243,     0,   244,   245,   246,
     247,     0,   248,     0,   249,     0,     0,     0,   250,   251,
       0,   252,     0,     0,   253,   254,     0,     0,     0,   255,
     256,   257,   258,     0,     0,   259,   260,   261,     0,     0,
     262,     0,     0,     0,     0,   263,   264,     0,     0,     0,
     265,     0,     0,     0,   266,   267,     0,   268,   269,     0,
       0,     0,   270,     0,     0,   271,   272,     0,     0,   273,
       0,     0,   274,   275,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,     0,   280,   281,     0,     0,
       0,     0,     0,     0,     0,   282,     0,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,     0,   300,   301,   302,     0,   303,
     304,   305,   306,     0,   307,   308,     0,     0,     0,     0,
     309,   310,   311,   312,   313,   314,     0,     0,   315,   316,
       0,   317,     0,   318,     0,   319,   320,   321,   322,   323,
     324,   325,   326,   327,     0,     0,   328,   329,     0,     0,
     330,   331,   332,   333,     0,     0,     0,   334,   335,     0,
       0,     0,   336,     0,   337,     0,   338,   339,     0,   340,
       0,   341,   342,     0,   343,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   344,   345,   346,     0,   347,   348,
       0,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,     0,     0,   359,   360,   361,     0,   362,     0,   363,
     364,   365,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,     0,     0,   372,   373,   374,   375,   376,     0,
       0,   377,   378,   379,   380,   381,     0,   382,   383,     0,
     384,   385,   386,     0,     0,   387,     0,   388,     0,   389,
     390,     0,   391,   392,   393,     0,   394,     0,     0,   395,
     396,   397,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,     0,     0,     0,   408,   409,   410,   411,
       0,     0,     0,   412,     0,     0,     0,   413,     0,   414,
     415,   416,   417,     0,   418,   419,   420,   421,   422,     0,
       0,     0,     0,     0,   423,   424,   425,     0,   426,   427,
       0,   428,     0,     0,   429,     0,     0,   430,   431,   432,
     433,   434,   435,     0,     0,   436,   437,     0,   438,   439,
     440,   441,   442,   443,     0,     0,   444,   445,   446,   447,
       0,   448,   449,     0,     0,   450,   451,   452,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,     0,     0,
       0,     0,     0,   460,   461,     0,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,   469,     0,   470,
     471,     0,     0,   472,     0,     0,   473,     0,   474,     0,
     475,   476,     0,     0,     0,     0,     0,     0,   477,     0,
       0,   478,     0,     0,     0,   479,   480,   481,   482,   483,
       0,     0,     0,     0,     0,     0,   484,   485,     0,   486,
     487,   488,     0,     0,   489,     0,     0,     0,   138,     0,
     139,   140,   141,   142,   143,  2925,     0,   144,     0,     0,
       0,   145,     0,  2926,   146,     0,   147,   148,   149,   150,
     151,   152,     0,   153,     0,     0,     0,   154,     0,     0,
       0,   155,     0,     0,   156,   157,   158,     0,   159,     0,
     160,   161,     0,     0,   162,     0,     0,   163,   164,     0,
     165,   166,     0,   167,     0,   168,   169,   170,   171,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,   183,   184,     0,   185,   186,     0,   187,   188,
     189,   190,   191,     0,     0,     0,   192,     0,     0,   193,
       0,   194,     0,     0,   195,     0,     0,     0,   196,   197,
     198,     0,     0,   199,     0,     0,     0,     0,   200,   201,
       0,     0,     0,     0,   202,   203,     0,   204,     0,     0,
       0,   205,     0,   206,   207,   208,   209,   210,     0,     0,
       0,   211,     0,     0,   212,   213,   214,     0,     0,     0,
     215,     0,   216,   217,     0,   218,   219,   220,     0,     0,
     221,   222,     0,   223,   224,   225,   226,   227,   228,     0,
       0,   229,   230,   231,   232,   233,     0,     0,   234,   235,
       0,   236,   237,   238,     0,     0,   239,     0,     0,     0,
     240,   241,     0,   242,     0,   243,     0,   244,   245,   246,
     247,     0,   248,     0,   249,     0,     0,     0,   250,   251,
       0,   252,     0,     0,   253,   254,     0,     0,     0,   255,
     256,   257,   258,     0,     0,   259,   260,   261,     0,     0,
     262,     0,     0,     0,     0,   263,   264,     0,     0,     0,
     265,     0,     0,     0,   266,   267,     0,   268,   269,     0,
       0,     0,   270,     0,     0,   271,   272,     0,     0,   273,
       0,     0,   274,   275,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,     0,   280,   281,     0,     0,
       0,     0,     0,     0,     0,   282,     0,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,     0,   300,   301,   302,     0,   303,
     304,   305,   306,     0,   307,   308,     0,     0,     0,     0,
     309,   310,   311,   312,   313,   314,     0,     0,   315,   316,
       0,   317,     0,   318,     0,   319,   320,   321,   322,   323,
     324,   325,   326,   327,     0,     0,   328,   329,     0,     0,
     330,   331,   332,   333,     0,     0,     0,   334,   335,     0,
       0,     0,   336,     0,   337,     0,   338,   339,     0,   340,
       0,   341,   342,     0,   343,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   344,   345,   346,     0,   347,   348,
       0,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,     0,     0,   359,   360,   361,     0,   362,     0,   363,
     364,   365,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,     0,     0,   372,   373,   374,   375,   376,     0,
       0,   377,   378,   379,   380,   381,     0,   382,   383,     0,
     384,   385,   386,     0,     0,   387,     0,   388,     0,   389,
     390,     0,   391,   392,   393,     0,   394,     0,     0,   395,
     396,   397,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,     0,     0,     0,   408,   409,   410,   411,
       0,     0,     0,   412,     0,     0,     0,   413,     0,   414,
     415,   416,   417,     0,   418,   419,   420,   421,   422,     0,
       0,     0,     0,     0,   423,   424,   425,     0,   426,   427,
       0,   428,     0,     0,   429,     0,     0,   430,   431,   432,
     433,   434,   435,     0,     0,   436,   437,     0,   438,   439,
     440,   441,   442,   443,     0,     0,   444,   445,   446,   447,
       0,   448,   449,     0,     0,   450,   451,   452,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,     0,     0,
       0,     0,     0,   460,   461,     0,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,   469,     0,   470,
     471,     0,     0,   472,     0,     0,   473,     0,   474,     0,
     475,   476,     0,     0,     0,     0,     0,     0,   477,     0,
       0,   478,     0,     0,     0,   479,   480,   481,   482,   483,
       0,     0,     0,     0,     0,     0,   484,   485,     0,   486,
     487,   488,     0,     0,   489,     0,     0,     0,   138,     0,
     139,   140,   141,   142,   143,     0,     0,   144,     0,     0,
       0,   145,  4516,   768,   146,     0,   147,   148,   149,   150,
     151,   152,     0,   153,     0,     0,     0,   154,     0,     0,
       0,   155,     0,     0,   156,   157,   158,     0,   159,     0,
     160,   161,     0,     0,   162,     0,     0,   163,   164,     0,
     165,   166,     0,   167,     0,   168,   169,   170,   171,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,   183,   184,     0,   185,   186,     0,   187,   188,
     189,   190,   191,     0,     0,     0,   192,     0,     0,   193,
       0,   194,     0,     0,   195,     0,     0,     0,   196,   197,
     198,     0,     0,   199,     0,     0,     0,     0,   200,   201,
       0,     0,     0,     0,   202,   203,     0,   204,     0,     0,
       0,   205,     0,   206,   207,   208,   209,   210,     0,     0,
       0,   211,     0,     0,   212,   213,   214,     0,     0,     0,
     215,     0,   216,   217,     0,   218,   219,   220,     0,     0,
     221,   222,     0,   223,   224,   225,   226,   227,   228,     0,
       0,   229,   230,   231,   232,   233,     0,     0,   234,   235,
       0,   236,   237,   238,     0,     0,   239,     0,     0,     0,
     240,   241,     0,   242,     0,   243,     0,   244,   245,   246,
     247,     0,   248,     0,   249,     0,     0,     0,   250,   251,
       0,   252,     0,     0,   253,   254,     0,     0,     0,   255,
     256,   257,   258,     0,     0,   259,   260,   261,     0,     0,
     262,     0,     0,     0,     0,   263,   264,     0,     0,     0,
     265,     0,     0,     0,   266,   267,     0,   268,   269,     0,
       0,     0,   270,     0,     0,   271,   272,     0,     0,   273,
       0,     0,   274,   275,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,     0,   280,   281,     0,     0,
       0,     0,     0,     0,     0,   282,     0,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,     0,   300,   301,   302,     0,   303,
     304,   305,   306,     0,   307,   308,     0,     0,     0,     0,
     309,   310,   311,   312,   313,   314,     0,     0,   315,   316,
       0,   317,     0,   318,     0,   319,   320,   321,   322,   323,
     324,   325,   326,   327,     0,     0,   328,   329,     0,     0,
     330,   331,   332,   333,     0,     0,     0,   334,   335,     0,
       0,     0,   336,     0,   337,     0,   338,   339,     0,   340,
       0,   341,   342,     0,   343,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   344,   345,   346,     0,   347,   348,
       0,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,     0,     0,   359,   360,   361,     0,   362,     0,   363,
     364,   365,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,     0,     0,   372,   373,   374,   375,   376,     0,
       0,   377,   378,   379,   380,   381,     0,   382,   383,     0,
     384,   385,   386,     0,     0,   387,     0,   388,     0,   389,
     390,     0,   391,   392,   393,     0,   394,     0,     0,   395,
     396,   397,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,     0,     0,     0,   408,   409,   410,   411,
       0,     0,     0,   412,     0,     0,     0,   413,     0,   414,
     415,   416,   417,     0,   418,   419,   420,   421,   422,     0,
       0,     0,     0,     0,   423,   424,   425,     0,   426,   427,
       0,   428,     0,     0,   429,     0,     0,   430,   431,   432,
     433,   434,   435,     0,     0,   436,   437,     0,   438,   439,
     440,   441,   442,   443,     0,     0,   444,   445,   446,   447,
       0,   448,   449,     0,     0,   450,   451,   452,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,     0,     0,
       0,     0,     0,   460,   461,     0,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,   469,     0,   470,
     471,     0,     0,   472,     0,     0,   473,     0,   474,     0,
     475,   476,     0,     0,     0,     0,     0,     0,   477,     0,
       0,   478,     0,     0,     0,   479,   480,   481,   482,   483,
       0,     0,     0,     0,     0,     0,   484,   485,     0,   486,
     487,   488,     0,     0,   489,     0,   138,     0,   139,   140,
     141,   142,   143,     0,     0,   144,     0,     0,     0,   145,
       0,     0,   146,   534,   147,   148,   149,   150,   151,   152,
       0,   153,     0,     0,     0,   154,     0,     0,     0,   155,
       0,     0,   156,   157,   158,     0,   159,     0,   160,   161,
       0,     0,   162,     0,     0,   163,   164,     0,   165,   166,
       0,   167,     0,   168,   169,   170,   171,   172,   173,     0,
     174,   175,     0,   176,   177,   178,   179,   180,   181,   182,
     183,   184,     0,   185,   186,     0,   187,   188,   189,   190,
     191,     0,     0,     0,   192,     0,     0,   193,     0,   194,
       0,     0,   195,     0,     0,     0,   196,   197,   198,     0,
       0,   199,     0,     0,     0,     0,   200,   201,     0,     0,
       0,     0,   202,   203,     0,   204,     0,     0,     0,   205,
       0,   206,   207,   208,   209,   210,     0,     0,     0,   211,
       0,     0,   212,   213,   214,     0,     0,     0,   215,     0,
     216,   217,     0,   218,   219,   220,     0,     0,   221,   222,
       0,   223,   224,   225,   226,   227,   228,     0,     0,   229,
     230,   231,   597,   233,     0,     0,   234,   235,     0,   236,
     237,   238,     0,     0,   239,     0,     0,     0,   598,   241,
       0,   242,     0,   243,     0,   244,   245,   246,   247,     0,
     248,     0,   249,     0,     0,     0,   250,   251,     0,   252,
       0,     0,   253,   254,     0,     0,     0,   255,   256,   257,
     258,     0,     0,   259,   260,   261,     0,     0,   262,     0,
       0,     0,     0,   263,   264,     0,     0,     0,   265,     0,
       0,     0,   266,   267,     0,   268,   269,     0,     0,     0,
     270,     0,     0,   271,   272,     0,     0,   273,     0,     0,
     274,   275,     0,     0,     0,     0,     0,   276,   277,     0,
     278,     0,   279,     0,   280,   281,     0,     0,     0,     0,
       0,     0,     0,   282,     0,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,     0,   300,   301,   302,     0,   303,   304,   305,
     306,     0,   307,   308,     0,     0,     0,     0,   309,   310,
     311,   312,   313,   314,     0,     0,   315,   316,     0,   317,
       0,   318,     0,   319,   320,   321,   322,   323,   324,   325,
     326,   327,     0,     0,   328,   329,     0,     0,   330,   331,
     332,   333,     0,     0,     0,   334,   335,     0,     0,     0,
     336,     0,   337,     0,   338,   339,     0,   340,     0,   341,
     342,     0,   343,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   344,   345,   346,     0,   347,   348,     0,   599,
     350,   351,   352,   353,   354,   355,   356,   357,   358,     0,
       0,   359,   360,   361,     0,   362,     0,   363,   364,   365,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
       0,     0,   372,   373,   374,   375,   376,     0,     0,   377,
     378,   379,   380,   381,     0,   382,   383,     0,   384,   385,
     386,     0,     0,   387,     0,   388,     0,   389,   390,     0,
     391,   392,   393,     0,   394,     0,     0,   395,   396,   397,
     398,   399,   400,   401,   402,   403,   404,   405,     0,   406,
     407,     0,     0,     0,   408,   409,   410,   411,     0,     0,
       0,   412,     0,     0,     0,   413,     0,   414,   415,   416,
     417,     0,   418,   419,   420,   421,   422,     0,     0,     0,
       0,     0,   423,   424,   425,     0,   426,   427,     0,   428,
       0,     0,   429,     0,     0,   430,   431,   432,   433,   434,
     435,     0,     0,   436,   437,     0,   438,   439,   440,   441,
     442,   443,     0,     0,   444,   445,   446,   447,     0,   448,
     449,     0,     0,   450,   451,   452,   453,     0,     0,   454,
     455,     0,   456,   457,   458,   459,     0,     0,     0,     0,
       0,   460,   461,     0,     0,     0,   462,   463,   464,   465,
       0,   466,   467,     0,   468,   469,     0,   470,   471,     0,
       0,   472,     0,     0,   473,     0,   474,     0,   475,   476,
       0,     0,     0,     0,     0,     0,   477,     0,     0,   478,
       0,     0,     0,   479,   480,   481,   482,   483,     0,     0,
       0,     0,     0,     0,   484,   485,     0,   486,   487,   488,
       0,     0,   489,     0,   138,     0,   139,   140,   141,   142,
     143,     0,     0,   144,     0,     0,     0,   145,     0,     0,
     146,   534,   147,   148,   149,   150,   151,   152,     0,   153,
       0,     0,     0,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,   160,   161,     0,     0,
     162,     0,     0,   163,   164,     0,   165,   166,     0,   167,
       0,   168,   169,   170,   171,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,   190,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,   201,     0,     0,     0,     0,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,   211,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,   216,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,   228,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
       0,     0,   239,     0,     0,     0,   240,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,   250,   251,     0,   252,     0,     0,
     253,   254,     0,     0,     0,   255,   256,   257,   258,     0,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,   264,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,     0,     0,     0,   270,     0,
       0,   271,   272,     0,     0,   273,     0,     0,   274,   275,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,     0,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
       0,     0,     0,   334,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,   342,     0,
     343,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,   345,   346,     0,   347,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,     0,     0,   359,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,   383,     0,   384,   385,   386,     0,
       0,   387,     0,   388,     0,   389,   390,     0,   391,   392,
     393,     0,   394,     0,     0,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,     0,
       0,     0,   408,   409,   410,   411,     0,     0,     0,   412,
       0,     0,     0,   413,     0,   414,   415,   416,   417,     0,
     418,   419,   420,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,     0,     0,
       0,     0,   484,   485,     0,   486,   487,   488,     0,     0,
     489,     0,   138,     0,   139,   140,   141,   142,   143,     0,
       0,   144,     0,     0,     0,   145,     0,     0,   146,   768,
     147,   148,   149,   150,   151,   152,     0,   153,     0,     0,
       0,   154,     0,     0,     0,   155,     0,     0,   156,   157,
     158,     0,   159,     0,   160,   161,     0,     0,   162,     0,
       0,   163,   164,     0,   165,   166,     0,   167,     0,   168,
     169,   170,   171,   172,   173,     0,   174,   175,     0,   176,
     177,   178,   179,   180,   181,   182,   183,   184,     0,   185,
     186,     0,   187,   188,   189,   190,   191,     0,     0,     0,
     192,     0,     0,   193,     0,   194,     0,     0,   195,     0,
       0,     0,   196,   197,   198,     0,     0,   199,     0,     0,
       0,     0,   200,   201,     0,     0,     0,     0,   202,   203,
       0,   204,     0,     0,     0,   205,     0,   206,   207,   208,
     209,   210,     0,     0,     0,   211,     0,     0,   212,   213,
     214,     0,     0,     0,   215,     0,   216,   217,     0,   218,
     219,   220,     0,     0,   221,   222,     0,   223,   224,   225,
     226,   227,   228,     0,     0,   229,   230,   231,   232,   233,
       0,     0,   234,   235,     0,   236,   237,   238,     0,     0,
     239,     0,     0,     0,   240,   241,     0,   242,     0,   243,
       0,   244,   245,   246,   247,     0,   248,     0,   249,     0,
       0,     0,   250,   251,     0,   252,     0,     0,   253,   254,
       0,     0,     0,   255,   256,   257,   258,     0,     0,   259,
     260,   261,     0,     0,   262,     0,     0,     0,     0,   263,
     264,     0,     0,     0,   265,     0,     0,     0,   266,   267,
       0,   268,   269,     0,     0,     0,   270,     0,     0,   271,
     272,     0,     0,   273,     0,     0,   274,   275,     0,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,     0,
     280,   281,     0,     0,     0,     0,     0,     0,     0,   282,
       0,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,     0,   300,
     301,   302,     0,   303,   304,   305,   306,     0,   307,   308,
       0,     0,     0,     0,   309,   310,   311,   312,   313,   314,
       0,     0,   315,   316,     0,   317,     0,   318,     0,   319,
     320,   321,   322,   323,   324,   325,   326,   327,     0,     0,
     328,   329,     0,     0,   330,   331,   332,   333,     0,     0,
       0,   334,   335,     0,     0,     0,   336,     0,   337,     0,
     338,   339,     0,   340,     0,   341,   342,     0,   343,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   344,   345,
     346,     0,   347,   348,     0,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,     0,     0,   359,   360,   361,
       0,   362,     0,   363,   364,   365,   366,   367,     0,   368,
     369,   370,     0,     0,   371,     0,     0,     0,   372,   373,
     374,   375,   376,     0,     0,   377,   378,   379,   380,   381,
       0,   382,   383,     0,   384,   385,   386,     0,     0,   387,
       0,   388,     0,   389,   390,     0,   391,   392,   393,     0,
     394,     0,     0,   395,   396,   397,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,     0,     0,     0,
     408,   409,   410,   411,     0,     0,     0,   412,     0,     0,
       0,   413,     0,   414,   415,   416,   417,     0,   418,   419,
     420,   421,   422,     0,     0,     0,     0,     0,   423,   424,
     425,     0,   426,   427,     0,   428,     0,     0,   429,     0,
       0,   430,   431,   432,   433,   434,   435,     0,     0,   436,
     437,     0,   438,   439,   440,   441,   442,   443,     0,     0,
     444,   445,   446,   447,     0,   448,   449,     0,     0,   450,
     451,   452,   453,     0,     0,   454,   455,     0,   456,   457,
     458,   459,     0,     0,     0,     0,     0,   460,   461,     0,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,   469,     0,   470,   471,     0,     0,   472,     0,     0,
     473,     0,   474,     0,   475,   476,     0,     0,     0,     0,
       0,     0,   477,     0,     0,   478,     0,     0,     0,   479,
     480,   481,   482,   483,     0,     0,     0,     0,     0,     0,
     484,   485,     0,   486,   487,   488,     0,     0,   489,     0,
     138,     0,   139,   140,   141,   142,   143,     0,     0,   144,
       0,     0,     0,   145,     0,     0,   146,  2926,   147,   148,
     149,   150,   151,   152,     0,   153,     0,     0,     0,   154,
       0,     0,     0,   155,     0,     0,   156,   157,   158,     0,
     159,     0,   160,   161,     0,     0,   162,     0,     0,   163,
     164,     0,   165,   868,   869,   167,     0,   168,   169,   170,
     171,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,   183,   184,     0,   185,   186,     0,
     187,   188,   189,   190,   191,     0,     0,     0,   192,     0,
       0,   193,     0,   194,     0,     0,   195,     0,     0,     0,
     196,   197,   198,     0,     0,   199,     0,     0,     0,     0,
     200,   201,     0,     0,     0,   870,   202,   203,     0,   204,
       0,     0,     0,   205,     0,   206,   207,   208,   209,   210,
       0,     0,     0,   211,     0,     0,   212,   213,   214,     0,
       0,     0,   215,     0,   216,   217,     0,   218,   219,   220,
       0,     0,   221,   222,     0,   223,   224,   225,   226,   227,
     228,     0,     0,   229,   230,   231,   232,   233,     0,     0,
     234,   235,     0,   236,   237,   238,     0,     0,   239,     0,
       0,     0,   240,   241,     0,   242,     0,   243,     0,   244,
     245,   246,   247,     0,   871,     0,   249,     0,     0,     0,
     250,   251,     0,   252,     0,     0,   253,   254,     0,     0,
       0,   255,   256,   257,   258,     0,     0,   259,   260,   261,
       0,     0,   262,     0,     0,     0,     0,   263,   264,     0,
       0,     0,   265,     0,     0,     0,   266,   267,     0,   268,
     269,     0,     0,     0,   270,     0,     0,   271,   272,     0,
       0,   273,     0,     0,   274,   275,     0,     0,     0,     0,
       0,   276,   277,     0,   872,     0,   279,     0,   280,   281,
       0,     0,     0,     0,     0,     0,     0,   282,     0,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,     0,   300,   301,   302,
       0,   303,   304,   305,   306,     0,   307,   308,     0,     0,
       0,     0,   309,   310,   311,   312,   313,   314,     0,     0,
     315,   316,     0,   317,     0,   318,     0,   319,   320,   321,
     322,   323,   324,   873,   326,   327,     0,     0,   328,   329,
       0,     0,   330,   331,   332,   333,     0,     0,     0,   334,
     335,     0,     0,     0,   336,     0,   337,     0,   338,   339,
       0,   340,     0,   341,   342,     0,   343,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   344,   345,   346,     0,
     347,   348,     0,   349,   350,   874,   352,   353,   354,   355,
     356,   357,   358,     0,     0,   359,   360,   361,     0,   362,
       0,   363,   364,   365,   366,   367,     0,   368,   369,   370,
       0,     0,   371,     0,     0,     0,   372,   373,   374,   375,
     376,     0,     0,   377,   378,   379,   380,   381,     0,   382,
     383,     0,   384,   385,   386,     0,     0,   387,     0,   388,
       0,   389,   390,     0,   391,   392,   393,     0,   394,     0,
       0,   395,   396,   397,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,     0,     0,     0,   408,   409,
     875,   411,     0,     0,     0,   412,     0,     0,     0,   413,
       0,   414,   415,   416,   417,     0,   418,   419,   420,   421,
     422,     0,     0,     0,     0,     0,   423,   424,   425,     0,
     426,   427,     0,   428,     0,     0,   429,     0,     0,   430,
     431,   432,   433,   434,   435,     0,     0,   436,   437,     0,
     438,   439,   440,   441,   442,   443,     0,     0,   444,   445,
     446,   447,     0,   448,   449,     0,     0,   450,   451,   452,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
       0,     0,     0,     0,     0,   876,   461,     0,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,   469,
       0,   470,   471,     0,     0,   472,     0,     0,   473,     0,
     474,     0,   475,   476,     0,     0,     0,     0,     0,     0,
     477,     0,     0,   478,     0,     0,     0,   479,   480,   481,
     482,   483,     0,     0,     0,     0,     0,     0,   484,   485,
       0,   486,   487,   488,     0,     0,   489,   138,     0,   139,
     140,   141,   142,   143,     0,     0,   144,     0,     0,     0,
     145,     0,     0,   146,   877,   147,   148,   149,   150,   151,
     152,     0,   153,     0,     0,     0,   154,     0,     0,     0,
     155,     0,     0,   156,   157,   158,     0,   159,     0,   160,
     161,     0,     0,   162,     0,     0,   163,   164,     0,   165,
     166,     0,   167,     0,   168,   169,   170,   171,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,   183,   184,     0,   185,   186,     0,   187,   188,   189,
     190,   191,     0,     0,     0,   192,     0,     0,   193,     0,
     194,     0,     0,   195,     0,     0,     0,   196,   197,   198,
       0,     0,   199,     0,     0,     0,     0,   200,   201,     0,
       0,     0,     0,   202,   203,     0,   204,     0,     0,     0,
     205,     0,   206,   207,   208,   209,   210,     0,     0,     0,
     211,     0,     0,   212,   213,   214,     0,     0,     0,   215,
       0,   216,   217,     0,   218,   219,   220,     0,     0,   221,
     222,     0,   223,   224,   225,   226,   227,   228,     0,     0,
     229,   230,   231,   232,   233,     0,     0,   234,   235,     0,
     236,   237,   238,     0,     0,   239,     0,     0,     0,   240,
     241,     0,   242,     0,   243,     0,   244,   245,   246,   247,
       0,   248,     0,   249,     0,     0,     0,   250,   251,     0,
     252,     0,     0,   253,   254,     0,     0,     0,   255,   256,
     257,   258,     0,     0,   259,   260,   261,     0,     0,   262,
       0,     0,     0,     0,   263,   264,     0,     0,     0,   265,
       0,     0,     0,   266,   267,     0,   268,   269,     0,     0,
       0,   270,     0,     0,   271,   272,     0,     0,   273,     0,
       0,   274,   275,   610,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,     0,   280,   281,     0,     0,     0,
       0,     0,     0,     0,   282,     0,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,     0,   300,   301,   302,     0,   303,   304,
     305,   306,     0,   307,   308,     0,     0,     0,     0,   309,
     310,   311,   312,   313,   314,     0,     0,   315,   316,     0,
     317,     0,   318,     0,   319,   320,   321,   322,   323,   324,
     325,   326,   327,     0,     0,   328,   329,     0,     0,   330,
     331,   332,   333,     0,     0,     0,   334,   335,     0,     0,
       0,   336,     0,   337,     0,   338,   339,     0,   340,     0,
     341,   342,     0,   343,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   344,   345,   346,     0,   347,   348,     0,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
       0,     0,   359,   360,   361,     0,   362,     0,   363,   364,
     365,   366,   367,     0,   368,   369,   370,     0,     0,   371,
       0,     0,     0,   372,   373,   374,   375,   376,     0,     0,
     377,   378,   379,   380,   381,     0,   382,   383,     0,   384,
     385,   386,     0,     0,   387,     0,   388,     0,   389,   390,
       0,   391,   392,   393,     0,   394,     0,     0,   395,   396,
     397,   398,   399,   400,   401,   402,   403,   404,   405,     0,
     406,   407,     0,     0,     0,   408,   409,   410,   411,     0,
       0,     0,   412,     0,     0,     0,   413,     0,   414,   415,
     416,   417,     0,   418,   419,   420,   421,   422,     0,     0,
       0,     0,     0,   423,   424,   425,     0,   426,   427,     0,
     428,     0,     0,   429,     0,     0,   430,   431,   432,   433,
     434,   435,     0,     0,   436,   437,     0,   438,   439,   440,
     441,   442,   443,     0,     0,   444,   445,   446,   447,     0,
     448,   449,     0,     0,   450,   451,   452,   453,     0,   135,
     454,   455,     0,   456,   457,   458,   459,     0,     0,     0,
       0,     0,   460,   461,     0,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,   469,     0,   470,   471,
       0,     0,   472,     0,     0,   473,     0,   474,     0,   475,
     476,     0,     0,     0,     0,     0,     0,   477,     0,     0,
     478,     0,     0,     0,   479,   480,   481,   482,   483,     0,
       0,     0,     0,     0,     0,   484,   485,     0,   486,   487,
     488,     0,     0,   489,   138,     0,   139,   140,   141,   142,
     143,     0,     0,   144,     0,     0,     0,   145,     0,     0,
     146,  1350,   147,   148,   149,   150,   151,   152,     0,   153,
       0,     0,     0,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,   160,   161,     0,     0,
     162,     0,     0,   163,   164,     0,   165,   166,     0,   167,
       0,   168,   169,   170,   171,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,   190,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,   201,     0,     0,     0,     0,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,   211,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,   216,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,   228,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
       0,     0,   239,     0,     0,     0,   240,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,   250,   251,     0,   252,     0,     0,
     253,   254,     0,     0,     0,   255,   256,   257,   258,     0,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,   264,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,     0,     0,     0,   270,     0,
       0,   271,   272,     0,     0,   273,     0,     0,   274,   275,
     610,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,     0,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
       0,     0,     0,   334,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,   342,     0,
     343,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,   345,   346,     0,   347,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,     0,     0,   359,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,   383,     0,   384,   385,   386,     0,
       0,   387,     0,   388,     0,   389,   390,     0,   391,   392,
     393,     0,   394,     0,     0,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,     0,
       0,     0,   408,   409,   410,   411,     0,     0,     0,   412,
       0,     0,     0,   413,     0,   414,   415,   416,   417,     0,
     418,   419,   420,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,   135,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,     0,     0,
       0,     0,   484,   485,     0,   486,   487,   488,     0,     0,
     489,   138,     0,   139,   140,   141,   142,   143,     0,     0,
     144,     0,     0,     0,   145,     0,     0,   146,  1685,   147,
     148,   149,   150,   151,   152,     0,   153,     0,     0,     0,
     154,     0,     0,     0,   155,     0,     0,   156,   157,   158,
       0,   159,     0,   160,   161,     0,     0,   162,     0,     0,
     163,   164,     0,   165,   868,   869,   167,     0,   168,   169,
     170,   171,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,   183,   184,     0,   185,   186,
       0,   187,   188,   189,   190,   191,     0,     0,     0,   192,
       0,     0,   193,     0,   194,     0,     0,   195,     0,     0,
       0,   196,   197,   198,     0,     0,   199,     0,     0,     0,
       0,   200,   201,     0,     0,     0,   870,   202,   203,     0,
     204,     0,     0,     0,   205,     0,   206,   207,   208,   209,
     210,     0,     0,     0,   211,     0,     0,   212,   213,   214,
       0,     0,     0,   215,     0,   216,   217,     0,   218,   219,
     220,     0,     0,   221,   222,     0,   223,   224,   225,   226,
     227,   228,     0,     0,   229,   230,   231,   232,   233,     0,
       0,   234,   235,     0,   236,   237,   238,     0,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,   243,     0,
     244,   245,   246,   247,     0,   871,     0,   249,     0,     0,
       0,   250,   251,     0,   252,     0,     0,   253,   254,     0,
       0,     0,   255,   256,   257,   258,     0,     0,   259,   260,
     261,     0,     0,   262,     0,     0,     0,     0,   263,   264,
       0,     0,     0,   265,     0,     0,     0,   266,   267,     0,
     268,   269,     0,     0,     0,   270,     0,     0,   271,   272,
       0,     0,   273,     0,     0,   274,   275,     0,     0,     0,
       0,     0,   276,   277,     0,   872,     0,   279,     0,   280,
     281,     0,     0,     0,     0,     0,     0,     0,   282,     0,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,     0,   300,   301,
     302,     0,   303,   304,   305,   306,     0,   307,   308,     0,
       0,     0,     0,   309,   310,   311,   312,   313,   314,     0,
       0,   315,   316,     0,   317,     0,   318,     0,   319,   320,
     321,   322,   323,   324,   873,   326,   327,     0,     0,   328,
     329,     0,     0,   330,   331,   332,   333,     0,     0,     0,
     334,   335,     0,     0,     0,   336,     0,   337,     0,   338,
     339,     0,   340,     0,   341,   342,     0,   343,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   344,   345,   346,
       0,   347,   348,     0,   349,   350,   874,   352,   353,   354,
     355,   356,   357,   358,     0,     0,   359,   360,   361,     0,
     362,     0,   363,   364,   365,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,     0,     0,   372,   373,   374,
     375,   376,     0,     0,   377,   378,   379,   380,   381,     0,
     382,   383,     0,   384,   385,   386,     0,     0,   387,     0,
     388,     0,   389,   390,     0,   391,   392,   393,     0,   394,
       0,     0,   395,   396,   397,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,     0,     0,     0,   408,
     409,   875,   411,     0,     0,     0,   412,     0,     0,     0,
     413,     0,   414,   415,   416,   417,     0,   418,   419,   420,
     421,   422,     0,     0,     0,     0,     0,   423,   424,   425,
       0,   426,   427,     0,   428,     0,     0,   429,     0,     0,
     430,   431,   432,   433,   434,   435,     0,     0,   436,   437,
       0,   438,   439,   440,   441,   442,   443,     0,     0,   444,
     445,   446,   447,     0,   448,   449,     0,     0,   450,   451,
     452,   453,     0,     0,   454,   455,     0,   456,   457,   458,
     459,     0,     0,     0,     0,     0,   460,   461,     0,     0,
       0,   462,   463,   464,   465,     0,   466,   467,     0,   468,
     469,     0,   470,   471,     0,     0,   472,     0,     0,   473,
       0,   474,     0,   475,   476,     0,     0,     0,     0,     0,
       0,   477,     0,     0,   478,     0,     0,     0,   479,   480,
     481,   482,   483,     0,     0,     0,     0,     0,     0,   484,
     485,     0,   486,   487,   488,     0,     0,   489,   138,     0,
     139,   140,   141,   142,   143,     0,     0,   144,     0,     0,
       0,   145,     0,     0,   146,   877,   147,   148,   149,   150,
     151,   152,     0,   153,     0,     0,     0,   154,     0,     0,
       0,   155,     0,     0,   156,   157,   158,     0,   159,     0,
     160,   161,     0,     0,   162,     0,     0,   163,   164,     0,
     165,   166,     0,   167,     0,   168,   169,   170,   171,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,   183,   184,     0,   185,   186,     0,   187,   188,
     189,   190,   191,     0,     0,     0,   192,     0,     0,   193,
       0,   194,     0,     0,   195,     0,     0,     0,   196,   197,
     198,     0,     0,   199,     0,     0,     0,     0,   200,   201,
       0,     0,     0,     0,   202,   203,     0,   204,     0,     0,
       0,   205,     0,   206,   207,   208,   209,   210,     0,     0,
       0,   211,     0,     0,   212,   213,   214,     0,     0,     0,
     215,     0,   216,   217,     0,   218,   219,   220,     0,     0,
     221,   222,     0,   223,   224,   225,   226,   227,   228,     0,
       0,   229,   230,   231,   232,   233,     0,     0,   234,   235,
       0,   236,   237,   238,     0,     0,   239,     0,     0,     0,
     240,   241,     0,   242,     0,   243,     0,   244,   245,   246,
     247,     0,   248,     0,   249,     0,     0,     0,   250,   251,
       0,   252,     0,     0,   253,   254,     0,     0,     0,   255,
     256,   257,   258,     0,     0,   259,   260,   261,     0,     0,
     262,     0,     0,     0,     0,   263,   264,     0,     0,     0,
     265,     0,     0,     0,   266,   267,     0,   268,   269,     0,
       0,     0,   270,     0,     0,   271,   272,     0,     0,   273,
       0,     0,   274,   275,   610,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,     0,   280,   281,     0,     0,
       0,     0,     0,     0,     0,   282,     0,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,     0,   300,   301,   302,     0,   303,
     304,   305,   306,     0,   307,   308,     0,     0,     0,     0,
     309,   310,   311,   312,   313,   314,     0,     0,   315,   316,
       0,   317,     0,   318,     0,   319,   320,   321,   322,   323,
     324,   325,   326,   327,     0,     0,   328,   329,     0,     0,
     330,   331,   332,   333,     0,     0,     0,   334,   335,     0,
       0,     0,   336,     0,   337,     0,   338,   339,     0,   340,
       0,   341,   342,     0,   343,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   344,   345,   346,     0,   347,   348,
       0,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,     0,     0,   359,   360,   361,     0,   362,     0,   363,
     364,   365,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,     0,     0,   372,   373,   374,   375,   376,     0,
       0,   377,   378,   379,   380,   381,     0,   382,   383,     0,
     384,   385,   386,     0,     0,   387,     0,   388,     0,   389,
     390,     0,   391,   392,   393,     0,   394,     0,     0,   395,
     396,   397,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,     0,     0,     0,   408,   409,   410,   411,
       0,     0,     0,   412,     0,     0,     0,   413,     0,   414,
     415,   416,   417,     0,   418,   419,   420,   421,   422,     0,
       0,     0,     0,     0,   423,   424,   425,     0,   426,   427,
       0,   428,     0,     0,   429,     0,     0,   430,   431,   432,
     433,   434,   435,     0,     0,   436,   437,     0,   438,   439,
     440,   441,   442,   443,     0,     0,   444,   445,   446,   447,
       0,   448,   449,     0,     0,   450,   451,   452,   453,     0,
     135,   454,   455,     0,   456,   457,   458,   459,     0,     0,
       0,     0,     0,   460,   461,     0,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,   469,     0,   470,
     471,     0,     0,   472,     0,     0,   473,     0,   474,     0,
     475,   476,     0,     0,     0,     0,     0,     0,   477,     0,
       0,   478,     0,     0,     0,   479,   480,   481,   482,   483,
       0,     0,     0,     0,     0,     0,   484,   485,     0,   486,
     487,   488,     0,     0,   489,   138,     0,   139,   140,   141,
     142,   143,     0,     0,   144,     0,     0,     0,   145,     0,
       0,   146,  3457,   147,   148,   149,   150,   151,   152,     0,
     153,     0,     0,     0,   154,     0,     0,     0,   155,     0,
       0,   156,   157,   158,     0,   159,     0,   160,   161,     0,
       0,   162,     0,     0,   163,   164,     0,   165,   166,     0,
     167,     0,   168,   169,   170,   171,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,   183,
     184,  1233,   185,   186,     0,   187,   188,   189,   190,   191,
       0,     0,     0,   192,     0,     0,   193,     0,   194,     0,
       0,   195,     0,     0,     0,   196,   197,   198,     0,     0,
     199,     0,     0,     0,     0,   200,   201,     0,     0,     0,
       0,   202,   203,     0,   204,     0,     0,     0,   205,     0,
     206,   207,   208,   209,   210,     0,     0,     0,   211,     0,
       0,   212,   213,   214,     0,     0,     0,   215,     0,   216,
     217,     0,   218,   219,   220,     0,     0,   221,   222,     0,
     223,   224,   225,   226,   227,   228,     0,     0,   229,   230,
     231,   232,   233,     0,     0,   234,   235,     0,   236,   237,
     238,     0,     0,   239,     0,     0,     0,   240,   241,     0,
     242,     0,   243,     0,   244,   245,   246,   247,     0,   248,
       0,   249,     0,     0,     0,   250,   251,     0,   252,     0,
       0,   253,   254,     0,     0,     0,   255,   256,   257,   258,
       0,     0,   259,   260,   261,     0,     0,   262,     0,     0,
       0,     0,   263,   264,     0,     0,     0,   265,     0,     0,
       0,   266,   267,     0,   268,   269,     0,     0,     0,   270,
       0,     0,   271,   272,     0,     0,   273,     0,     0,   274,
     275,     0,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,     0,   280,   281,     0,     0,     0,     0,     0,
       0,     0,   282,     0,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,     0,   300,   301,   302,     0,   303,   304,   305,   306,
       0,   307,   308,     0,     0,     0,     0,   309,   310,   311,
     312,   313,   314,     0,     0,   315,   316,     0,   317,     0,
     318,     0,   319,   320,   321,   322,   323,   324,   325,   326,
     327,     0,     0,   328,   329,     0,     0,   330,   331,   332,
     333,     0,     0,     0,   334,   335,     0,     0,     0,   336,
       0,   337,     0,   338,   339,     0,   340,     0,   341,   342,
       0,   343,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   344,   345,   346,     0,   347,   348,     0,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,     0,     0,
     359,   360,   361,     0,   362,     0,   363,   364,   365,   366,
     367,     0,   368,   369,   370,     0,     0,   371,     0,     0,
       0,   372,   373,   374,   375,   376,     0,     0,   377,   378,
     379,   380,   381,     0,   382,   383,     0,   384,   385,   386,
       0,     0,   387,     0,   388,     0,   389,   390,     0,   391,
     392,   393,     0,   394,     0,     0,   395,   396,   397,   398,
     399,   400,   401,   402,   403,   404,   405,     0,   406,   407,
       0,     0,     0,   408,   409,   410,   411,     0,     0,     0,
     412,     0,     0,     0,   413,     0,   414,   415,   416,   417,
       0,   418,   419,   420,   421,   422,     0,     0,     0,     0,
       0,   423,   424,   425,     0,   426,   427,     0,   428,     0,
       0,   429,     0,     0,   430,   431,   432,   433,   434,   435,
       0,     0,   436,   437,     0,   438,   439,   440,   441,   442,
     443,     0,     0,   444,   445,   446,   447,     0,   448,   449,
       0,     0,   450,   451,   452,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,     0,     0,     0,     0,     0,
     460,   461,     0,     0,     0,   462,   463,   464,   465,     0,
     466,   467,     0,   468,   469,     0,   470,   471,     0,     0,
     472,     0,     0,   473,     0,   474,     0,   475,   476,     0,
       0,     0,     0,     0,     0,   477,     0,     0,   478,     0,
       0,     0,   479,   480,   481,   482,   483,     0,     0,     0,
       0,     0,     0,   484,   485,     0,   486,   487,   488,     0,
       0,   489,   138,     0,   139,   140,   141,   142,   143,     0,
       0,   144,     0,     0,     0,   145,     0,     0,   146,  1234,
     147,   148,   149,   150,   151,   152,     0,   153,     0,     0,
       0,   154,     0,     0,     0,   155,     0,     0,   156,   157,
     158,     0,   159,     0,   160,   161,     0,     0,   162,     0,
       0,   163,   164,     0,   165,   166,     0,   167,     0,   168,
     169,   170,   171,   172,   173,     0,   174,   175,     0,   176,
     177,   178,   179,   180,   181,   182,   183,   184,     0,   185,
     186,     0,   187,   188,   189,   190,   191,     0,     0,     0,
     192,     0,     0,   193,     0,   194,     0,     0,   195,     0,
       0,     0,   196,   197,   198,     0,     0,   199,     0,     0,
       0,     0,   200,   201,     0,     0,     0,     0,   202,   203,
       0,   204,     0,     0,     0,   205,     0,   206,   207,   208,
     209,   210,     0,     0,     0,   211,     0,     0,   212,   213,
     214,     0,     0,     0,   215,     0,   216,   217,     0,   218,
     219,   220,     0,     0,   221,   222,     0,   223,   224,   225,
     226,   227,   228,     0,     0,   229,   230,   231,   232,   233,
       0,     0,   234,   235,     0,   236,   237,   238,     0,     0,
     239,     0,     0,     0,   240,   241,     0,   242,     0,   243,
       0,   244,   245,   246,   247,     0,   248,     0,   249,     0,
       0,     0,   250,   251,     0,   252,     0,     0,   253,   254,
       0,     0,     0,   255,   256,   257,   258,     0,     0,   259,
     260,   261,     0,     0,   262,     0,     0,     0,     0,   263,
     264,     0,     0,     0,   265,     0,     0,     0,   266,   267,
       0,   268,   269,     0,     0,     0,   270,     0,     0,   271,
     272,     0,     0,   273,     0,     0,   274,   275,     0,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,     0,
     280,   281,     0,     0,     0,     0,     0,     0,     0,   282,
       0,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,     0,   300,
     301,   302,     0,   303,   304,   305,   306,     0,   307,   308,
       0,     0,     0,     0,   309,   310,   311,   312,   313,   314,
       0,     0,   315,   316,     0,   317,     0,   318,     0,   319,
     320,   321,   322,   323,   324,   325,   326,   327,     0,     0,
     328,   329,     0,     0,   330,   331,   332,   333,     0,     0,
       0,   334,   335,     0,     0,     0,   336,     0,   337,     0,
     338,   339,     0,   340,     0,   341,   342,     0,   343,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   344,   345,
     346,     0,   347,   348,     0,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,     0,     0,   359,   360,   361,
       0,   362,     0,   363,   364,   365,   366,   367,     0,   368,
     369,   370,     0,     0,   371,     0,     0,     0,   372,   373,
     374,   375,   376,     0,     0,   377,   378,   379,   380,   381,
       0,   382,   383,     0,   384,   385,   386,     0,     0,   387,
       0,   388,     0,   389,   390,     0,   391,   392,   393,     0,
     394,     0,     0,   395,   396,   397,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,     0,     0,     0,
     408,   409,   410,   411,     0,     0,     0,   412,     0,     0,
       0,   413,     0,   414,   415,   416,   417,     0,   418,   419,
     420,   421,   422,     0,     0,     0,     0,     0,   423,   424,
     425,     0,   426,   427,     0,   428,     0,     0,   429,     0,
       0,   430,   431,   432,   433,   434,   435,     0,     0,   436,
     437,     0,   438,   439,   440,   441,   442,   443,     0,     0,
     444,   445,   446,   447,     0,   448,   449,     0,     0,   450,
     451,   452,   453,     0,     0,   454,   455,     0,   456,   457,
     458,   459,     0,     0,     0,     0,     0,   460,   461,     0,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,   469,     0,   470,   471,     0,     0,   472,     0,     0,
     473,     0,   474,     0,   475,   476,     0,     0,     0,     0,
       0,     0,   477,     0,     0,   478,     0,     0,     0,   479,
     480,   481,   482,   483,     0,     0,     0,     0,     0,     0,
     484,   485,     0,   486,   487,   488,     0,     0,   489,   138,
       0,   139,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,     0,     0,     0,  1234,   147,   148,   149,
     150,   151,     0,     0,  -366,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,     0,     0,     0,     0,   162,  3943,     0,   163,   164,
       0,   165,     0,     0,     0,     0,   168,   169,   170,  3944,
     172,   173,     0,   174,   175,     0,   176,   177,     0,   179,
       0,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,     0,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
       0,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,     0,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,     0,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,     0,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,  3945,   236,   237,   238,     0,     0,     0,     0,     0,
       0,     0,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,     0,
     251,     0,     0,     0,     0,     0,   254,     0,     0,     0,
     255,   256,   257,   258,  3946,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,     0,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
    3947,     0,     0,   270,     0,     0,     0,   272,     0,     0,
     273,  3948,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,  -321,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,     0,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,  3949,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   345,   346,     0,     0,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,     0,     0,     0,     0,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,     0,
       0,   384,     0,   386,  -321,     0,   387,     0,     0,     0,
     389,     0,     0,   391,   392,   393,  3950,   394,     0,     0,
       0,   396,   397,   398,   399,   400,   401,   402,     0,   404,
     405,     0,   406,     0,     0,     0,     0,   408,   409,   410,
       0,     0,     0,     0,   412,     0,     0,     0,   413,     0,
       0,   415,     0,   417,     0,   418,     0,     0,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,     0,
     432,   433,   434,   435,     0,     0,     0,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,     0,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
       0,     0,     0,     0,   472,     0,     0,   473,     0,     0,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,  -321,     0,     0,     0,   484,     0,     0,
     486,     0,   488,     0,   138,   489,   139,   140,   141,   142,
     143,     0,     0,   144,     0,     0,     0,   145,  4508,     0,
     146,     0,   147,   148,   149,   150,   151,   152,     0,   153,
       0,     0,     0,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,   160,   161,     0,     0,
     162,     0,     0,   163,   164,     0,   165,   166,     0,   167,
       0,   168,   169,   170,   171,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,   190,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,   201,     0,     0,     0,     0,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,   211,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,   216,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,   228,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
       0,     0,   239,     0,     0,     0,   240,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,   250,   251,     0,   252,     0,     0,
     253,   254,     0,     0,     0,   255,   256,   257,   258,     0,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,   264,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,     0,     0,     0,   270,     0,
       0,   271,   272,     0,     0,   273,     0,     0,   274,   275,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,     0,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
       0,     0,     0,   334,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,   342,     0,
     343,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,   345,   346,     0,   347,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,     0,     0,   359,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,   383,     0,   384,   385,   386,     0,
       0,   387,     0,   388,     0,   389,   390,     0,   391,   392,
     393,     0,   394,     0,     0,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,     0,
       0,     0,   408,   409,   410,   411,     0,     0,     0,   412,
       0,     0,     0,   413,     0,   414,   415,   416,   417,     0,
     418,   419,   420,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,     0,     0,
       0,     0,   484,   485,     0,   486,   487,   488,     0,   138,
     489,   139,   140,   141,   142,   143,  2073,     0,   144,     0,
       0,     0,   145,     0,     0,   146,     0,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,   164,
       0,   165,   166,     0,   167,     0,   168,   169,   170,   171,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,   190,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
     201,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,   211,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,   216,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,   228,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,     0,     0,   239,     0,     0,
       0,   240,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,   250,
     251,     0,   252,     0,     0,   253,   254,     0,     0,     0,
     255,   256,   257,   258,     0,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,   264,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,   271,   272,     0,     0,
     273,     0,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,   334,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,   342,     0,   343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,   346,     0,   347,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,     0,     0,   359,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,   383,
       0,   384,   385,   386,     0,     0,   387,     0,   388,     0,
     389,   390,     0,   391,   392,   393,     0,   394,     0,     0,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,     0,     0,     0,   408,   409,   410,
     411,     0,     0,     0,   412,     0,     0,     0,   413,     0,
     414,   415,   416,   417,     0,   418,   419,   420,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,     0,     0,     0,     0,   484,   485,     0,
     486,   487,   488,     0,   138,   489,   139,   140,   141,   142,
     143,  2775,     0,   144,     0,     0,     0,   145,     0,     0,
     146,     0,   147,   148,   149,   150,   151,   152,     0,   153,
       0,     0,     0,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,   160,   161,     0,     0,
     162,     0,     0,   163,   164,     0,   165,   166,     0,   167,
       0,   168,   169,   170,   171,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,   190,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,   201,     0,     0,     0,     0,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,   211,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,   216,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,   228,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
       0,     0,   239,     0,     0,     0,   240,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,   250,   251,     0,   252,     0,     0,
     253,   254,     0,     0,     0,   255,   256,   257,   258,     0,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,   264,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,     0,     0,     0,   270,     0,
       0,   271,   272,     0,     0,   273,     0,     0,   274,   275,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,     0,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
       0,     0,     0,   334,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,   342,     0,
     343,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,   345,   346,     0,   347,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,     0,     0,   359,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,   383,     0,   384,   385,   386,     0,
       0,   387,     0,   388,     0,   389,   390,     0,   391,   392,
     393,     0,   394,     0,     0,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,     0,
       0,     0,   408,   409,   410,   411,     0,     0,     0,   412,
       0,     0,     0,   413,     0,   414,   415,   416,   417,     0,
     418,   419,   420,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,     0,     0,
       0,     0,   484,   485,     0,   486,   487,   488,     0,   138,
     489,   139,   140,   141,   142,   143,  3416,     0,   144,     0,
       0,     0,   145,     0,     0,   146,     0,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,   164,
       0,   165,   166,     0,   167,     0,   168,   169,   170,   171,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,   190,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
     201,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,   211,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,   216,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,   228,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,     0,     0,   239,     0,     0,
       0,   240,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,   250,
     251,     0,   252,     0,     0,   253,   254,     0,     0,     0,
     255,   256,   257,   258,     0,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,   264,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,   271,   272,     0,     0,
     273,     0,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,   334,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,   342,     0,   343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,   346,     0,   347,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,     0,     0,   359,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,   383,
       0,   384,   385,   386,     0,     0,   387,     0,   388,     0,
     389,   390,     0,   391,   392,   393,     0,   394,     0,     0,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,     0,     0,     0,   408,   409,   410,
     411,     0,     0,     0,   412,     0,     0,     0,   413,     0,
     414,   415,   416,   417,     0,   418,   419,   420,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,     0,     0,     0,     0,   484,   485,     0,
     486,   487,   488,     0,   138,   489,   139,   140,   141,   142,
     143,  3462,     0,   144,     0,     0,     0,   145,     0,     0,
     146,     0,   147,   148,   149,   150,   151,   152,     0,   153,
       0,     0,     0,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,   160,   161,     0,     0,
     162,     0,     0,   163,   164,     0,   165,   166,     0,   167,
       0,   168,   169,   170,   171,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,   190,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,   201,  2420,     0,     0,     0,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,   211,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,   216,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,   228,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
    2421,     0,   239,     0,     0,     0,   240,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,   250,   251,     0,   252,  2422,     0,
     253,   254,     0,     0,     0,   255,   256,   257,   258,     0,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,   264,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,     0,     0,     0,   270,     0,
       0,   271,   272,     0,     0,   273,     0,     0,   274,   275,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,  2423,     0,     0,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
    1003,  1004,     0,   334,   335,     0,     0,  2424,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,   342,     0,
     343,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,   345,   346,     0,   347,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,     0,     0,   359,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,   383,     0,   384,   385,   386,     0,
       0,   387,     0,   388,     0,   389,   390,     0,   391,   392,
     393,     0,   394,     0,     0,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,     0,
       0,     0,   408,   409,   410,   411,     0,     0,     0,   412,
       0,     0,     0,   413,     0,   414,   415,   416,   417,     0,
     418,   419,   420,   421,   422,     0,     0,  4495,   559,  4496,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,   462,   463,   464,   465,  2425,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,     0,     0,
       0,     0,   484,   485,     0,   486,   487,   488,     0,   138,
     489,   139,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,     0,     0,   146,     0,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,  1339,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,   164,
       0,   165,   166,     0,   167,     0,   168,   169,   170,   171,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,   190,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
     201,     0,     0,     0,  1340,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,   211,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,   216,   217,     0,   218,   219,   220,  1341,
       0,   221,   222,     0,   223,   224,   225,   226,   227,   228,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,     0,     0,   239,     0,     0,
       0,   240,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,   250,
     251,     0,   252,     0,     0,   253,   254,     0,     0,     0,
     255,   256,   257,   258,     0,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,   264,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,   271,   272,     0,     0,
     273,     0,     0,   274,   275,   610,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,   334,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,   342,     0,   343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,   346,     0,   347,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,     0,     0,   359,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,   383,
       0,   384,   385,   386,     0,     0,   387,     0,   388,     0,
     389,   390,     0,   391,   392,   393,     0,   394,     0,     0,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,     0,     0,     0,   408,   409,   410,
     411,     0,     0,  1342,   412,     0,     0,     0,   413,     0,
     414,   415,   416,   417,     0,   418,   419,   420,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,   135,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,     0,     0,     0,     0,   484,   485,     0,
     486,   487,   488,     0,   138,   489,   139,   140,   141,   142,
     143,     0,     0,   144,     0,     0,     0,   145,     0,     0,
     146,     0,   147,   148,   149,   150,   151,   152,     0,   153,
       0,     0,  1352,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,   160,   161,     0,     0,
     162,     0,     0,   163,   164,     0,   165,   166,     0,   167,
       0,   168,   169,   170,   171,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,   190,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,   201,     0,     0,     0,  1353,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,   211,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,   216,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,   228,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
       0,     0,   239,     0,     0,     0,   240,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,   250,   251,     0,   252,     0,     0,
     253,   254,     0,     0,     0,   255,   256,   257,   258,     0,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,   264,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,     0,     0,     0,   270,     0,
       0,   271,   272,     0,     0,   273,     0,     0,   274,   275,
     610,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,     0,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
       0,     0,     0,   334,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,   342,     0,
     343,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,   345,   346,     0,   347,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,     0,     0,   359,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,   383,     0,   384,   385,   386,     0,
       0,   387,     0,   388,     0,   389,   390,     0,   391,   392,
     393,     0,   394,     0,     0,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,     0,
       0,     0,   408,   409,   410,   411,     0,     0,     0,   412,
       0,     0,     0,   413,     0,   414,   415,   416,   417,     0,
     418,   419,   420,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,   135,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,     0,     0,
       0,     0,   484,   485,     0,   486,   487,   488,     0,   138,
     489,   139,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,     0,     0,   146,     0,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,   164,
       0,   165,   166,     0,   167,     0,   168,   169,   170,   171,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,   190,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
     201,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,   211,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,   216,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,   228,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,     0,     0,   239,     0,     0,
       0,   240,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,   250,
     251,     0,   252,     0,     0,   253,   254,     0,     0,     0,
     255,   256,   257,   258,     0,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,   264,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,   271,   272,     0,     0,
     273,     0,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,  1883,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,   334,   335,
       0,     0,  1884,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,   342,     0,   343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,   346,   722,   347,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,     0,     0,   359,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,   383,
       0,   384,   385,   386,     0,     0,   387,     0,   388,     0,
     389,   390,     0,   391,   392,   393,     0,   394,     0,     0,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,     0,     0,     0,   408,   409,   410,
     411,     0,     0,     0,   412,     0,     0,     0,   413,     0,
     414,   415,   416,   417,     0,   418,   419,   420,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,   462,
     463,   464,   465,  1885,   466,   467,     0,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,     0,     0,     0,     0,   484,   485,     0,
     486,   487,   488,     0,   138,   489,   139,   140,   141,   142,
     143,     0,     0,   144,     0,     0,     0,   145,     0,     0,
     146,     0,   147,   148,   149,   150,   151,   152,     0,   153,
       0,     0,  1339,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,   160,   161,     0,     0,
     162,     0,     0,   163,   164,     0,   165,   166,     0,   167,
       0,   168,   169,   170,   171,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,   190,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,   201,     0,     0,     0,  1340,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,   211,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,   216,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,   228,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
       0,     0,   239,     0,     0,     0,   240,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,   250,   251,     0,   252,     0,     0,
     253,   254,     0,     0,     0,   255,   256,   257,   258,     0,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,   264,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,     0,     0,     0,   270,     0,
       0,   271,   272,     0,     0,   273,     0,     0,   274,   275,
     610,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,     0,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
       0,     0,     0,   334,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,   342,     0,
     343,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,   345,   346,     0,   347,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,     0,     0,   359,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,   383,     0,   384,   385,   386,     0,
       0,   387,     0,   388,     0,   389,   390,     0,   391,   392,
     393,     0,   394,     0,     0,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,     0,
       0,     0,   408,   409,   410,   411,     0,     0,     0,   412,
       0,     0,     0,   413,     0,   414,   415,   416,   417,     0,
     418,   419,   420,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,   135,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,     0,     0,
       0,     0,   484,   485,     0,   486,   487,   488,     0,   138,
     489,   139,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,     0,     0,   146,     0,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,   164,
       0,   165,   166,     0,   167,     0,   168,   169,   170,   171,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,   190,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,   960,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
     201,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,   211,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,   216,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,   228,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,     0,     0,   239,     0,     0,
       0,   240,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,   250,
     251,     0,   252,     0,     0,   253,   254,     0,     0,     0,
     255,   256,   257,   258,     0,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,   264,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,   271,   272,     0,     0,
     273,     0,     0,   274,   275,   610,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,   334,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,   342,     0,   343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,   346,     0,   347,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,     0,     0,   359,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,   383,
       0,   384,   385,   386,     0,     0,   387,     0,   388,     0,
     389,   390,     0,   391,   392,   393,     0,   394,     0,     0,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,     0,     0,     0,   408,   409,   410,
     411,     0,     0,     0,   412,     0,     0,     0,   413,     0,
     414,   415,   416,   417,     0,   418,   419,   420,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,   135,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,     0,     0,     0,     0,   484,   485,     0,
     486,   487,   488,     0,   138,   489,   139,   140,   141,   142,
     143,  1374,     0,   144,     0,     0,     0,   145,     0,     0,
     146,     0,   147,   148,   149,   150,   151,   152,     0,   153,
       0,     0,     0,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,   160,   161,     0,     0,
     162,     0,     0,   163,   164,     0,   165,   166,     0,   167,
       0,   168,   169,   170,   171,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,   190,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,   201,     0,     0,     0,     0,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,   211,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,   216,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,   228,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
       0,     0,   239,     0,     0,     0,   240,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,   250,   251,     0,   252,     0,     0,
     253,   254,     0,     0,     0,   255,   256,   257,   258,     0,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,   264,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,     0,     0,     0,   270,     0,
       0,   271,   272,     0,     0,   273,     0,     0,   274,   275,
     610,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,     0,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
       0,     0,     0,   334,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,   342,     0,
     343,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,   345,   346,     0,   347,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,     0,     0,   359,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,   383,     0,   384,   385,   386,     0,
       0,   387,     0,   388,     0,   389,   390,     0,   391,   392,
     393,     0,   394,     0,     0,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,     0,
       0,     0,   408,   409,   410,   411,     0,     0,     0,   412,
       0,     0,     0,   413,     0,   414,   415,   416,   417,     0,
     418,   419,   420,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,   135,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,     0,     0,
       0,     0,   484,   485,     0,   486,   487,   488,     0,   138,
     489,   139,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,     0,     0,   146,     0,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,     0,   154,   937,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,   164,
       0,   165,   166,     0,   167,     0,   168,   169,   170,   171,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,   190,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
     201,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,   211,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,   216,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,   228,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,     0,     0,   239,     0,     0,
       0,   240,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,   250,
     251,     0,   252,   938,     0,   253,   254,     0,     0,     0,
     255,   256,   257,   258,     0,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,   264,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,   271,   272,     0,     0,
     273,     0,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,   334,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,   342,     0,   343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,   346,     0,   347,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,     0,     0,   359,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,   383,
       0,   384,   385,   386,     0,     0,   387,     0,   388,     0,
     389,   390,     0,   391,   392,   393,     0,   394,     0,     0,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,     0,     0,     0,   408,   409,   410,
     411,     0,     0,     0,   412,     0,     0,     0,   413,     0,
     414,   415,   416,   417,     0,   418,   419,   420,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,   939,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,     0,     0,     0,     0,   484,   485,     0,
     486,   487,   488,     0,   138,   489,   139,   140,   141,   142,
     143,     0,     0,   144,     0,     0,     0,   145,     0,     0,
     146,     0,   147,   148,   149,   150,   151,   152,     0,   153,
       0,     0,     0,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,   160,   161,     0,     0,
     162,     0,     0,   163,   164,     0,   165,   166,     0,   167,
       0,   168,   169,   170,   171,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,   190,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,   201,     0,     0,     0,  2329,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,   211,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,   216,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,   228,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
       0,     0,   239,     0,     0,     0,   240,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,   250,   251,     0,   252,     0,     0,
     253,   254,     0,     0,     0,   255,   256,   257,   258,     0,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,   264,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,     0,     0,     0,   270,     0,
       0,   271,   272,     0,     0,   273,     0,     0,   274,   275,
     610,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,     0,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
       0,     0,     0,   334,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,   342,     0,
     343,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,   345,   346,     0,   347,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,     0,     0,   359,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,   383,     0,   384,   385,   386,     0,
       0,   387,     0,   388,     0,   389,   390,     0,   391,   392,
     393,     0,   394,     0,     0,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,     0,
       0,     0,   408,   409,   410,   411,     0,     0,     0,   412,
       0,     0,     0,   413,     0,   414,   415,   416,   417,     0,
     418,   419,   420,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,   135,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,     0,     0,
       0,     0,   484,   485,     0,   486,   487,   488,     0,   138,
     489,   139,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,     0,     0,   146,     0,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,  1339,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,   164,
       0,   165,   166,     0,   167,     0,   168,   169,   170,   171,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,   190,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
     201,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,   211,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,   216,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,   228,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,     0,     0,   239,     0,     0,
       0,   240,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,   250,
     251,     0,   252,     0,     0,   253,   254,     0,     0,     0,
     255,   256,   257,   258,     0,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,   264,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,   271,   272,     0,     0,
     273,     0,     0,   274,   275,   610,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,   334,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,   342,     0,   343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,   346,     0,   347,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,     0,     0,   359,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,   383,
       0,   384,   385,   386,     0,     0,   387,     0,   388,     0,
     389,   390,     0,   391,   392,   393,     0,   394,     0,     0,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,     0,     0,     0,   408,   409,   410,
     411,     0,     0,     0,   412,     0,     0,     0,   413,     0,
     414,   415,   416,   417,     0,   418,   419,   420,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,   135,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,     0,     0,     0,     0,   484,   485,     0,
     486,   487,   488,     0,   138,   489,   139,   140,   141,   142,
     143,     0,     0,   144,     0,     0,     0,   145,     0,     0,
     146,     0,   147,   148,   149,   150,   151,   152,     0,   153,
       0,     0,     0,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,   160,   161,     0,     0,
     162,     0,     0,   163,   164,     0,   165,   166,     0,   167,
       0,   168,   169,   170,   171,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,   190,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,   201,     0,     0,     0,     0,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,   211,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,   216,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,   228,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
       0,     0,   239,     0,     0,     0,   240,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,   250,   251,     0,   252,     0,     0,
     253,   254,     0,     0,     0,   255,   256,   257,   258,     0,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,   264,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,     0,     0,     0,   270,     0,
       0,   271,   272,     0,     0,   273,     0,     0,   274,   275,
     610,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,     0,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
       0,     0,     0,   334,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,   342,     0,
     343,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,   345,   346,     0,   347,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,     0,     0,   359,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,   383,     0,   384,   385,   386,     0,
       0,   387,     0,   388,     0,   389,   390,     0,   391,   392,
     393,     0,   394,     0,     0,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,     0,
       0,     0,   408,   409,   410,   411,     0,     0,     0,   412,
       0,     0,     0,   413,     0,   414,   415,   416,   417,     0,
     418,   419,   420,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,   135,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,     0,     0,
       0,     0,   484,   485,     0,   486,   487,   488,     0,   138,
     489,   139,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,  2771,     0,   146,     0,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,   164,
       0,   165,   166,     0,   167,     0,   168,   169,   170,   171,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,   190,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
     201,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,   211,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,   216,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,   228,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,     0,     0,   239,     0,     0,
       0,   240,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,   250,
     251,     0,   252,     0,     0,   253,   254,     0,     0,     0,
     255,   256,   257,   258,     0,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,   264,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,   271,   272,     0,     0,
     273,     0,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,   334,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,   342,     0,   343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,   346,     0,   347,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,     0,     0,   359,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,   383,
       0,   384,   385,   386,     0,     0,   387,     0,   388,     0,
     389,   390,     0,   391,   392,   393,     0,   394,     0,     0,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,     0,     0,     0,   408,   409,   410,
     411,     0,     0,     0,   412,     0,     0,     0,   413,     0,
     414,   415,   416,   417,     0,   418,   419,   420,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,   135,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,     0,     0,     0,     0,   484,   485,     0,
     486,   487,   488,     0,   138,   489,   139,   140,   141,   142,
     143,     0,     0,   144,     0,     0,     0,   145,     0,     0,
     146,     0,   147,   148,   149,   150,   151,   152,     0,   153,
       0,     0,     0,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,   160,   161,     0,     0,
     162,     0,     0,   163,   164,     0,   165,   166,     0,   167,
       0,   168,   169,   170,   171,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,   190,   191,  4413,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,   201,     0,     0,     0,     0,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,   211,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,   216,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,   228,     0,  4414,   229,   230,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
       0,     0,   239,     0,     0,     0,   240,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,   250,   251,     0,   252,     0,     0,
     253,   254,     0,     0,     0,   255,   256,   257,   258,     0,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,   264,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,     0,     0,     0,   270,     0,
       0,   271,   272,     0,     0,   273,     0,     0,   274,   275,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,     0,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
       0,     0,     0,   334,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,   342,     0,
     343,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,   345,   346,     0,   347,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,     0,     0,   359,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,   383,     0,   384,   385,   386,     0,
       0,   387,     0,   388,     0,   389,   390,     0,   391,   392,
     393,     0,   394,     0,     0,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,     0,
       0,     0,   408,   409,   410,   411,     0,     0,     0,   412,
       0,     0,     0,   413,     0,   414,   415,   416,   417,     0,
     418,   419,   420,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,     0,     0,
       0,     0,   484,   485,     0,   486,   487,   488,     0,   138,
     489,   139,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,     0,     0,   146,     0,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,   164,
       0,   165,   166,     0,   167,     0,   168,   169,   170,   171,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,   190,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
     201,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,   211,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,   216,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,   228,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,     0,     0,   239,     0,     0,
       0,   240,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,   250,
     251,     0,   252,     0,     0,   253,   254,     0,     0,     0,
     255,   256,   257,   258,     0,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,   264,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,   271,   272,     0,     0,
     273,     0,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,   334,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,   342,     0,   343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,   346,     0,   347,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,     0,     0,   359,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,   383,
       0,   384,   385,   386,     0,     0,   387,     0,   388,     0,
     389,   390,     0,   391,   392,   393,     0,   394,     0,     0,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,     0,     0,     0,   408,   409,   410,
     411,     0,     0,     0,   412,     0,     0,     0,   413,     0,
     414,   415,   416,   417,     0,   418,   419,   420,   421,   422,
       0,     0,     0,   559,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,     0,     0,     0,     0,   484,   485,     0,
     486,   487,   488,     0,   138,   489,   139,   140,   141,   142,
     143,     0,     0,   144,     0,     0,     0,   145,     0,     0,
     146,     0,   147,   148,   149,   150,   151,   152,     0,   153,
       0,     0,     0,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,   160,   161,     0,     0,
     162,     0,     0,   163,   164,     0,   165,   166,     0,   167,
       0,   168,   169,   170,   171,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,   190,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,   201,     0,     0,     0,     0,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,   211,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,   216,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,   228,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
       0,     0,   239,     0,     0,     0,   240,   241,  1039,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,   250,   251,     0,   252,     0,     0,
     253,   254,     0,     0,     0,   255,   256,   257,   258,     0,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,   264,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,     0,     0,     0,   270,     0,
       0,   271,   272,     0,     0,   273,     0,     0,   274,   275,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,     0,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
       0,     0,     0,   334,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,   342,     0,
     343,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,   345,   346,     0,   347,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,     0,     0,   359,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,   383,     0,   384,   385,   386,     0,
       0,   387,     0,   388,     0,   389,   390,     0,   391,   392,
     393,     0,   394,     0,     0,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,     0,
       0,     0,   408,   409,   410,   411,     0,     0,     0,   412,
       0,     0,     0,   413,     0,   414,   415,   416,   417,     0,
     418,   419,   420,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,     0,     0,
       0,     0,   484,   485,     0,   486,   487,   488,     0,   138,
     489,   139,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,     0,     0,   146,     0,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,   164,
       0,   165,   166,     0,   167,     0,   168,   169,   170,   171,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,   190,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
     201,     0,     0,     0,   870,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,   211,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,   216,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,   228,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,     0,     0,   239,     0,     0,
       0,   240,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,   250,
     251,     0,   252,     0,     0,   253,   254,     0,     0,     0,
     255,   256,   257,   258,     0,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,   264,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,   271,   272,     0,     0,
     273,     0,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,   334,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,   342,     0,   343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,   346,     0,   347,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,     0,     0,   359,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,   383,
       0,   384,   385,   386,     0,     0,   387,     0,   388,     0,
     389,   390,     0,   391,   392,   393,     0,   394,     0,     0,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,     0,     0,     0,   408,   409,   410,
     411,     0,     0,     0,   412,     0,     0,     0,   413,     0,
     414,   415,   416,   417,     0,   418,   419,   420,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,  1859,   461,     0,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,     0,     0,     0,     0,   484,   485,     0,
     486,   487,   488,     0,   138,   489,   139,   140,   141,   142,
     143,     0,     0,   144,     0,     0,     0,   145,     0,     0,
     146,     0,   147,   148,   149,   150,   151,   152,     0,   153,
       0,     0,     0,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,   160,   161,     0,     0,
     162,     0,     0,   163,   164,     0,   165,   166,     0,   167,
       0,   168,   169,   170,   171,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,   190,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,   201,     0,     0,     0,  1992,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,   211,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,   216,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,   228,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
       0,     0,   239,     0,     0,     0,   240,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,   250,   251,     0,   252,     0,     0,
     253,   254,     0,     0,     0,   255,   256,   257,   258,     0,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,   264,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,     0,     0,     0,   270,     0,
       0,   271,   272,     0,     0,   273,     0,     0,   274,   275,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,     0,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
       0,     0,     0,   334,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,   342,     0,
     343,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,   345,   346,     0,   347,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,     0,     0,   359,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,   383,     0,   384,   385,   386,     0,
       0,   387,     0,   388,     0,   389,   390,     0,   391,   392,
     393,     0,   394,     0,     0,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,     0,
       0,     0,   408,   409,   410,   411,     0,     0,     0,   412,
       0,     0,     0,   413,     0,   414,   415,   416,   417,     0,
     418,   419,   420,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,     0,     0,
       0,     0,   484,   485,     0,   486,   487,   488,     0,   138,
     489,   139,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,     0,     0,   146,     0,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,   164,
       0,   165,   166,     0,   167,     0,   168,   169,   170,   171,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,   190,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
     201,     0,     0,     0,   870,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,   211,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,   216,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,   228,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,     0,     0,   239,     0,     0,
       0,   240,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,   250,
     251,     0,   252,     0,     0,   253,   254,     0,     0,     0,
     255,   256,   257,   258,     0,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,   264,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,   271,   272,     0,     0,
     273,     0,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,   334,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,   342,     0,   343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,   346,     0,   347,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,     0,     0,   359,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,   383,
       0,   384,   385,   386,     0,     0,   387,     0,   388,     0,
     389,   390,     0,   391,   392,   393,     0,   394,     0,     0,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,     0,     0,     0,   408,   409,   410,
     411,     0,     0,     0,   412,     0,     0,     0,   413,     0,
     414,   415,   416,   417,     0,   418,   419,   420,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,     0,     0,     0,     0,   484,   485,     0,
     486,   487,   488,     0,   138,   489,   139,   140,   141,   142,
     143,     0,     0,   144,     0,     0,     0,   145,     0,     0,
     146,     0,   147,   148,   149,   150,   151,   152,     0,   153,
       0,     0,     0,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,   160,   161,     0,     0,
     162,     0,     0,   163,   164,     0,   165,   166,     0,   167,
       0,   168,   169,   170,   171,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,   190,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,   201,     0,     0,     0,     0,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,   211,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,   216,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,   228,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
       0,     0,   239,     0,     0,     0,   240,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,   250,   251,     0,   252,     0,     0,
     253,   254,     0,     0,     0,   255,   256,   257,   258,     0,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,   264,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,     0,     0,     0,   270,     0,
       0,   271,   272,     0,     0,   273,     0,     0,   274,   275,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,     0,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
       0,     0,     0,   334,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,   342,     0,
     343,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,   345,   346,     0,   347,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,     0,     0,   359,
     360,   361,  2943,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,   383,     0,   384,   385,   386,     0,
       0,   387,     0,   388,     0,   389,   390,     0,   391,   392,
     393,     0,   394,     0,     0,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,     0,
       0,     0,   408,   409,   410,   411,     0,     0,     0,   412,
       0,     0,     0,   413,     0,   414,   415,   416,   417,     0,
     418,   419,   420,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,     0,     0,
       0,     0,   484,   485,     0,   486,   487,   488,     0,   138,
     489,   139,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,     0,     0,   146,     0,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,   164,
       0,   165,   166,     0,   167,     0,   168,   169,   170,   171,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,   190,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
     201,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,   211,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,   216,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,   228,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,     0,     0,   239,     0,     0,
       0,   240,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,   250,
     251,     0,   252,     0,     0,   253,   254,     0,     0,     0,
     255,   256,   257,   258,     0,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,   264,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,   271,   272,     0,     0,
     273,     0,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,   334,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,   342,     0,   343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,   346,     0,   347,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,     0,     0,   359,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,   383,
       0,   384,   385,   386,     0,     0,   387,     0,   388,     0,
     389,   390,     0,   391,   392,   393,     0,   394,     0,     0,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,     0,     0,     0,   408,   409,   410,
     411,     0,     0,     0,   412,     0,     0,     0,   413,     0,
     414,   415,   416,   417,     0,   418,   419,   420,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,   135,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,     0,     0,     0,     0,   484,   485,     0,
     486,   487,   488,     0,   138,   489,   139,   140,   141,   142,
     143,     0,     0,   144,     0,     0,     0,   145,     0,     0,
     146,     0,   147,   148,   149,   150,   151,   152,     0,   153,
       0,     0,     0,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,   160,   161,     0,     0,
     162,     0,     0,   163,   164,     0,   165,   166,     0,   167,
       0,   168,   169,   170,   171,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,   190,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,   201,     0,     0,     0,  3227,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,   211,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,   216,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,   228,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
       0,     0,   239,     0,     0,     0,   240,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,   250,   251,     0,   252,     0,     0,
     253,   254,     0,     0,     0,   255,   256,   257,   258,     0,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,   264,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,     0,     0,     0,   270,     0,
       0,   271,   272,     0,     0,   273,     0,     0,   274,   275,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,     0,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
       0,     0,     0,   334,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,   342,     0,
     343,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,   345,   346,     0,   347,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,     0,     0,   359,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,   383,     0,   384,   385,   386,     0,
       0,   387,     0,   388,     0,   389,   390,     0,   391,   392,
     393,     0,   394,     0,     0,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,     0,
       0,     0,   408,   409,   410,   411,     0,     0,     0,   412,
       0,     0,     0,   413,     0,   414,   415,   416,   417,     0,
     418,   419,   420,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,     0,     0,
       0,     0,   484,   485,     0,   486,   487,   488,     0,   138,
     489,   139,   140,   141,   142,   143,  3235,     0,   144,     0,
       0,     0,   145,     0,     0,   146,     0,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,   164,
       0,   165,   166,     0,   167,     0,   168,   169,   170,   171,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,   190,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
     201,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,   211,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,   216,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,   228,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,     0,     0,   239,     0,     0,
       0,   240,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,   250,
     251,     0,   252,     0,     0,   253,   254,     0,     0,     0,
     255,   256,   257,   258,     0,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,   264,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,   271,   272,     0,     0,
     273,     0,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,   334,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,   342,     0,   343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,   346,     0,   347,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,     0,     0,   359,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,   383,
       0,   384,   385,   386,     0,     0,   387,     0,   388,     0,
     389,   390,     0,   391,   392,   393,     0,   394,     0,     0,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,     0,     0,     0,   408,   409,   410,
     411,     0,     0,     0,   412,     0,     0,     0,   413,     0,
     414,   415,   416,   417,     0,   418,   419,   420,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,     0,     0,     0,     0,   484,   485,     0,
     486,   487,   488,     0,   138,   489,   139,   140,   141,   142,
     143,     0,     0,   144,     0,     0,     0,   145,     0,     0,
     146,     0,   147,   148,   149,   150,   151,   152,     0,   153,
       0,     0,     0,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,   160,   161,     0,     0,
     162,     0,     0,   163,   164,     0,   165,   166,     0,   167,
       0,   168,   169,   170,   171,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,   190,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,   201,     0,     0,     0,  3259,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,   211,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,   216,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,   228,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
       0,     0,   239,     0,     0,     0,   240,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,   250,   251,     0,   252,     0,     0,
     253,   254,     0,     0,     0,   255,   256,   257,   258,     0,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,   264,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,     0,     0,     0,   270,     0,
       0,   271,   272,     0,     0,   273,     0,     0,   274,   275,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,     0,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
       0,     0,     0,   334,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,   342,     0,
     343,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,   345,   346,     0,   347,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,     0,     0,   359,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,   383,     0,   384,   385,   386,     0,
       0,   387,     0,   388,     0,   389,   390,     0,   391,   392,
     393,     0,   394,     0,     0,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,     0,
       0,     0,   408,   409,   410,   411,     0,     0,     0,   412,
       0,     0,     0,   413,     0,   414,   415,   416,   417,     0,
     418,   419,   420,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,     0,     0,
       0,     0,   484,   485,     0,   486,   487,   488,     0,   138,
     489,   139,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,     0,     0,   146,     0,   147,   148,   149,
     150,   151,   152,     0,   153,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,   160,   161,     0,     0,   162,     0,     0,   163,   164,
       0,   165,   166,     0,   167,     0,   168,   169,   170,   171,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,   190,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
     201,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,   211,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,   216,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,   228,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,     0,     0,   239,     0,     0,
       0,   240,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,   250,
     251,     0,   252,     0,     0,   253,   254,     0,     0,     0,
     255,   256,   257,   258,     0,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,   264,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,   271,   272,     0,     0,
     273,     0,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,   334,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,   342,     0,   343,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,   346,     0,   347,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,     0,     0,   359,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,   383,
       0,   384,   385,   386,     0,     0,   387,     0,   388,     0,
     389,   390,     0,   391,   392,   393,     0,   394,     0,     0,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,     0,     0,     0,   408,   409,   410,
     411,     0,     0,     0,   412,     0,     0,     0,   413,     0,
     414,   415,   416,   417,     0,   418,   419,   420,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,     0,     0,     0,     0,   484,   485,     0,
     486,   487,   488,     0,   138,   489,   139,   140,   141,   142,
     143,     0,     0,   144,     0,     0,     0,   145,     0,     0,
     146,     0,   147,   148,   149,   150,   151,   152,     0,   153,
       0,     0,     0,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,   160,   161,     0,     0,
     162,     0,     0,   163,   164,     0,   165,   166,     0,   167,
       0,   168,   169,   170,   171,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,   190,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,   201,     0,     0,     0,     0,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,   211,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,   216,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,   228,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,     0,   236,  1784,   238,
       0,     0,   239,     0,     0,     0,   240,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,   250,   251,     0,   252,     0,     0,
     253,   254,     0,     0,     0,   255,   256,   257,   258,     0,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,   264,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,     0,     0,     0,   270,     0,
       0,   271,   272,     0,     0,   273,     0,     0,   274,   275,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,     0,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,  1785,   332,   333,
       0,     0,     0,   334,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,   342,     0,
     343,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,   345,   346,     0,   347,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,     0,     0,   359,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,   383,     0,   384,   385,   386,     0,
       0,   387,     0,   388,     0,   389,   390,     0,   391,   392,
     393,     0,   394,     0,     0,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,     0,
       0,     0,   408,   409,   410,   411,     0,     0,     0,   412,
       0,     0,     0,   413,     0,   414,   415,   416,   417,     0,
     418,   419,   420,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,     0,     0,
       0,     0,   484,   485,     0,   486,   487,   488,     0,   138,
     489,   139,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,     0,     0,     0,     0,   147,   148,   149,
     150,   151,     0,     0,  -366,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,     0,     0,     0,     0,   162,  3943,     0,   163,   164,
       0,   165,     0,     0,     0,     0,   168,   169,   170,  3944,
     172,   173,     0,   174,   175,     0,   176,   177,     0,   179,
       0,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,     0,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
       0,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,     0,     0,     0,   212,   213,   214,     0,  -336,
    -336,   215,     0,  -336,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,     0,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,  3945,   236,   237,   238,     0,     0,     0,     0,     0,
       0,     0,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,     0,
     251,     0,     0,     0,     0,     0,   254,     0,     0,     0,
     255,   256,   257,   258,  3946,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,     0,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
    3947,     0,     0,   270,     0,     0,     0,   272,     0,     0,
     273,  3948,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,  -321,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,     0,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,  3949,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   345,   346,     0,     0,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,     0,     0,     0,     0,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,     0,
       0,   384,     0,   386,  -321,     0,   387,     0,     0,     0,
     389,     0,     0,   391,   392,   393,  3950,   394,     0,     0,
       0,   396,   397,   398,   399,   400,   401,   402,     0,   404,
     405,     0,   406,     0,     0,     0,     0,   408,   409,   410,
       0,     0,     0,     0,   412,     0,     0,     0,   413,     0,
       0,   415,     0,   417,     0,   418,     0,     0,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,     0,
     432,   433,   434,   435,     0,     0,     0,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,     0,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
       0,     0,     0,     0,   472,     0,     0,   473,     0,     0,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,  -321,     0,     0,     0,   484,     0,     0,
     486,     0,   488,     0,   138,   489,   139,   140,   141,   142,
     143,     0,     0,   144,     0,     0,     0,   145,     0,     0,
       0,     0,   147,   148,   149,   150,   151,     0,     0,  -366,
       0,     0,     0,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,     0,     0,     0,     0,
     162,  3943,     0,   163,   164,     0,   165,     0,     0,     0,
       0,   168,   169,   170,  3944,   172,   173,     0,   174,   175,
       0,   176,   177,     0,   179,     0,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,     0,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,     0,     0,     0,     0,     0,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,     0,     0,     0,
     212,   213,   214,     0,  -357,     0,   215,     0,  -357,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,     0,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,  3945,   236,   237,   238,
       0,     0,     0,     0,     0,     0,     0,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,     0,   251,     0,     0,     0,     0,
       0,   254,     0,     0,     0,   255,   256,   257,   258,  3946,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,     0,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,  3947,     0,     0,   270,     0,
       0,     0,   272,     0,     0,   273,  3948,     0,   274,   275,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,  -321,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
       0,     0,     0,     0,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,  3949,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   345,   346,     0,     0,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,     0,     0,     0,     0,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,     0,     0,   384,     0,   386,  -321,
       0,   387,     0,     0,     0,   389,     0,     0,   391,   392,
     393,  3950,   394,     0,     0,     0,   396,   397,   398,   399,
     400,   401,   402,     0,   404,   405,     0,   406,     0,     0,
       0,     0,   408,   409,   410,     0,     0,     0,     0,   412,
       0,     0,     0,   413,     0,     0,   415,     0,   417,     0,
     418,     0,     0,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,     0,   432,   433,   434,   435,     0,
       0,     0,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,     0,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,     0,     0,     0,     0,   472,
       0,     0,   473,     0,     0,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,  -357,     0,  -321,     0,
       0,     0,   484,     0,     0,   486,     0,   488,     0,   138,
     489,   139,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,     0,     0,     0,     0,   147,   148,   149,
     150,   151,     0,     0,  -366,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,     0,     0,     0,     0,   162,  3943,     0,   163,   164,
       0,   165,     0,     0,     0,     0,   168,   169,   170,  3944,
     172,   173,     0,   174,   175,     0,   176,   177,     0,   179,
       0,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,     0,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
       0,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,     0,     0,     0,   212,   213,   214,     0,  -354,
       0,   215,     0,  -354,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,     0,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,  3945,   236,   237,   238,     0,     0,     0,     0,     0,
       0,     0,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,     0,
     251,     0,     0,     0,     0,     0,   254,     0,     0,     0,
     255,   256,   257,   258,  3946,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,     0,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
    3947,     0,     0,   270,     0,     0,     0,   272,     0,     0,
     273,  3948,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,  -321,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,     0,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,  3949,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   345,   346,     0,     0,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,     0,     0,     0,     0,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,     0,
       0,   384,     0,   386,  -321,     0,   387,     0,     0,     0,
     389,     0,     0,   391,   392,   393,  3950,   394,     0,     0,
       0,   396,   397,   398,   399,   400,   401,   402,     0,   404,
     405,     0,   406,     0,     0,     0,     0,   408,   409,   410,
       0,     0,     0,     0,   412,     0,     0,     0,   413,     0,
       0,   415,     0,   417,     0,   418,     0,     0,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,     0,
     432,   433,   434,   435,     0,     0,     0,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,     0,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
       0,     0,     0,     0,   472,     0,     0,   473,     0,     0,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,  -354,     0,  -321,     0,     0,     0,   484,     0,     0,
     486,     0,   488,     0,   138,   489,   139,   140,   141,   142,
     143,     0,     0,   144,     0,     0,     0,   145,     0,     0,
       0,     0,   147,   148,   149,   150,   151,     0,     0,  -366,
       0,     0,     0,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,     0,     0,     0,     0,
     162,  3943,     0,   163,   164,     0,   165,     0,     0,     0,
       0,   168,   169,   170,  3944,   172,   173,     0,   174,   175,
       0,   176,   177,     0,   179,     0,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,     0,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,     0,     0,     0,     0,     0,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,     0,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,  4301,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,     0,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,  3945,   236,   237,   238,
       0,     0,     0,     0,     0,     0,     0,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,     0,   251,     0,     0,     0,     0,
       0,   254,     0,     0,     0,   255,   256,   257,   258,  3946,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,     0,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,  3947,     0,     0,   270,     0,
       0,     0,   272,     0,     0,   273,  3948,     0,   274,   275,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,  -321,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
       0,     0,     0,     0,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,  3949,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   345,   346,     0,     0,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,     0,     0,     0,     0,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,     0,     0,   384,     0,   386,  -321,
       0,   387,     0,     0,     0,   389,     0,     0,   391,   392,
     393,  3950,   394,     0,     0,     0,   396,   397,   398,   399,
     400,   401,   402,     0,   404,   405,     0,   406,     0,     0,
       0,     0,   408,   409,   410,     0,     0,     0,     0,   412,
       0,     0,     0,   413,     0,     0,   415,     0,   417,     0,
     418,     0,     0,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,     0,   432,   433,   434,   435,     0,
       0,     0,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,     0,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,     0,     0,     0,     0,   472,
       0,     0,   473,     0,     0,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,  -321,     0,
       0,     0,   484,     0,     0,   486,     0,   488,     0,   138,
     489,   139,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,     0,     0,     0,     0,   147,   148,   149,
     150,   151,     0,     0,  -366,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,     0,     0,     0,     0,   162,  3943,     0,   163,   164,
       0,   165,     0,     0,     0,     0,   168,   169,   170,  3944,
     172,   173,     0,   174,   175,     0,   176,   177,     0,   179,
       0,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,     0,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
       0,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,     0,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,  -359,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,     0,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,  3945,   236,   237,   238,     0,     0,     0,     0,     0,
       0,     0,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,     0,
     251,     0,     0,     0,     0,     0,   254,     0,     0,     0,
     255,   256,   257,   258,  3946,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,     0,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
    3947,     0,     0,   270,     0,     0,     0,   272,     0,     0,
     273,  3948,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,  -321,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,     0,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,  3949,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   345,   346,     0,     0,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,     0,     0,     0,     0,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,     0,
       0,   384,     0,   386,  -321,     0,   387,     0,     0,     0,
     389,     0,     0,   391,   392,   393,  3950,   394,     0,     0,
       0,   396,   397,   398,   399,   400,   401,   402,     0,   404,
     405,     0,   406,     0,     0,     0,     0,   408,   409,   410,
       0,     0,     0,     0,   412,     0,     0,     0,   413,     0,
       0,   415,     0,   417,     0,   418,     0,     0,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,     0,
     432,   433,   434,   435,     0,     0,     0,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,     0,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
       0,     0,     0,     0,   472,     0,     0,   473,     0,     0,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,  -321,     0,     0,     0,   484,     0,     0,
     486,     0,   488,     0,   138,   489,   139,   140,   141,   142,
     143,     0,     0,   144,     0,     0,     0,   145,     0,     0,
       0,     0,   147,   148,   149,   150,   151,     0,     0,  -366,
       0,     0,     0,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,     0,     0,     0,     0,
     162,  3943,     0,   163,   164,     0,   165,     0,     0,     0,
       0,   168,   169,   170,  3944,   172,   173,     0,   174,   175,
       0,   176,   177,     0,   179,     0,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,     0,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,     0,     0,     0,     0,     0,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,     0,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,  4418,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,     0,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,  3945,   236,   237,   238,
       0,     0,     0,     0,     0,     0,     0,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,     0,   251,     0,     0,     0,     0,
       0,   254,     0,     0,     0,   255,   256,   257,   258,  3946,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,     0,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,  3947,     0,     0,   270,     0,
       0,     0,   272,     0,     0,   273,  3948,     0,   274,   275,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,  -321,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
       0,     0,     0,     0,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,  3949,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   345,   346,     0,     0,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,     0,     0,     0,     0,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,     0,     0,   384,     0,   386,  -321,
       0,   387,     0,     0,     0,   389,     0,     0,   391,   392,
     393,  3950,   394,     0,     0,     0,   396,   397,   398,   399,
     400,   401,   402,     0,   404,   405,     0,   406,     0,     0,
       0,     0,   408,   409,   410,     0,     0,     0,     0,   412,
       0,     0,     0,   413,     0,     0,   415,     0,   417,     0,
     418,     0,     0,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,     0,   432,   433,   434,   435,     0,
       0,     0,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,     0,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,     0,     0,     0,     0,   472,
       0,     0,   473,     0,     0,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,  -321,     0,
       0,     0,   484,     0,     0,   486,     0,   488,     0,   138,
     489,   139,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,     0,     0,     0,     0,   147,   148,   149,
     150,   151,     0,     0,  -366,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,     0,     0,     0,     0,   162,  3943,     0,   163,   164,
       0,   165,     0,     0,     0,     0,   168,   169,   170,  3944,
     172,   173,     0,   174,   175,     0,   176,   177,     0,   179,
       0,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,     0,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
       0,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,     0,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,  4466,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,     0,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,  3945,   236,   237,   238,     0,     0,     0,     0,     0,
       0,     0,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,     0,
     251,     0,     0,     0,     0,     0,   254,     0,     0,     0,
     255,   256,   257,   258,  3946,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,     0,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
    3947,     0,     0,   270,     0,     0,     0,   272,     0,     0,
     273,  3948,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,  -321,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,     0,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,  3949,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   345,   346,     0,     0,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,     0,     0,     0,     0,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,     0,
       0,   384,     0,   386,  -321,     0,   387,     0,     0,     0,
     389,     0,     0,   391,   392,   393,  3950,   394,     0,     0,
       0,   396,   397,   398,   399,   400,   401,   402,     0,   404,
     405,     0,   406,     0,     0,     0,     0,   408,   409,   410,
       0,     0,     0,     0,   412,     0,     0,     0,   413,     0,
       0,   415,     0,   417,     0,   418,     0,     0,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,     0,
     432,   433,   434,   435,     0,     0,     0,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,     0,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
       0,     0,     0,     0,   472,     0,     0,   473,     0,     0,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,  -321,     0,     0,     0,   484,     0,     0,
     486,     0,   488,     0,   138,   489,   139,   140,   141,   142,
     143,     0,     0,   144,     0,     0,     0,   145,     0,     0,
       0,     0,   147,   148,   149,   150,   151,     0,     0,  -366,
       0,     0,     0,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,     0,     0,     0,     0,
     162,  3943,     0,   163,   164,     0,   165,     0,     0,     0,
       0,   168,   169,   170,  3944,   172,   173,     0,   174,   175,
       0,   176,   177,     0,   179,     0,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,     0,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,     0,     0,     0,     0,     0,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,     0,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,  -340,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,     0,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,  3945,   236,   237,   238,
       0,     0,     0,     0,     0,     0,     0,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,     0,   251,     0,     0,     0,     0,
       0,   254,     0,     0,     0,   255,   256,   257,   258,  3946,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,     0,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,  3947,     0,     0,   270,     0,
       0,     0,   272,     0,     0,   273,  3948,     0,   274,   275,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,  -321,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
       0,     0,     0,     0,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,  3949,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   345,   346,     0,     0,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,     0,     0,     0,     0,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,     0,     0,   384,     0,   386,  -321,
       0,   387,     0,     0,     0,   389,     0,     0,   391,   392,
     393,  3950,   394,     0,     0,     0,   396,   397,   398,   399,
     400,   401,   402,     0,   404,   405,     0,   406,     0,     0,
       0,     0,   408,   409,   410,     0,     0,     0,     0,   412,
       0,     0,     0,   413,     0,     0,   415,     0,   417,     0,
     418,     0,     0,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,     0,   432,   433,   434,   435,     0,
       0,     0,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,     0,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,     0,     0,     0,     0,   472,
       0,     0,   473,     0,     0,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,  -321,     0,
       0,     0,   484,     0,     0,   486,     0,   488,     0,   138,
     489,   139,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,     0,     0,     0,     0,   147,   148,   149,
     150,   151,     0,     0,  -366,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,     0,     0,     0,     0,   162,  3943,     0,   163,   164,
       0,   165,     0,     0,     0,     0,   168,   169,   170,  3944,
     172,   173,     0,   174,   175,     0,   176,   177,     0,   179,
       0,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,     0,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
       0,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,     0,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,     0,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,     0,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,  3945,   236,   237,   238,     0,     0,     0,     0,     0,
       0,     0,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,     0,
     251,     0,     0,     0,     0,     0,   254,     0,     0,     0,
     255,   256,   257,   258,  3946,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,     0,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
    3947,     0,     0,   270,     0,     0,     0,   272,     0,     0,
     273,  3948,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,  -321,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,     0,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,  3949,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   345,   346,     0,     0,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,     0,     0,     0,     0,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,     0,
       0,   384,     0,   386,  -321,     0,   387,     0,     0,     0,
     389,     0,     0,   391,   392,   393,  3950,   394,     0,     0,
       0,   396,   397,   398,   399,   400,   401,   402,     0,   404,
     405,     0,   406,     0,     0,     0,     0,   408,   409,   410,
       0,     0,     0,     0,   412,     0,     0,     0,   413,     0,
       0,   415,     0,   417,     0,   418,     0,     0,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,     0,
     432,   433,   434,   435,     0,     0,     0,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,     0,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
       0,     0,     0,     0,   472,     0,     0,   473,     0,     0,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,  -321,     0,     0,     0,   484,     0,     0,
     486,     0,   488,     0,   138,   489,   139,   140,   141,   142,
     143,     0,     0,   144,     0,     0,     0,   145,     0,     0,
       0,     0,   147,   148,   149,   150,   151,     0,     0,  -366,
       0,     0,     0,   154,     0,     0,     0,   155,     0,     0,
     156,   157,   158,     0,   159,     0,     0,     0,     0,     0,
     162,  3943,     0,   163,   164,     0,   165,     0,     0,     0,
       0,   168,   169,   170,  3944,   172,   173,     0,   174,   175,
       0,   176,   177,     0,   179,     0,   181,   182,   183,   184,
       0,   185,   186,     0,   187,   188,   189,     0,   191,     0,
       0,     0,   192,     0,     0,   193,     0,   194,     0,     0,
     195,     0,     0,     0,   196,   197,   198,     0,     0,   199,
       0,     0,     0,     0,   200,     0,     0,     0,     0,     0,
     202,   203,     0,   204,     0,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,     0,     0,     0,     0,
     212,   213,   214,     0,     0,     0,   215,     0,     0,   217,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,   227,     0,     0,     0,   229,   230,   231,
     232,   233,     0,     0,   234,   235,  3945,   236,   237,   238,
       0,     0,     0,     0,     0,     0,     0,   241,     0,   242,
       0,   243,     0,   244,   245,   246,   247,     0,   248,     0,
     249,     0,     0,     0,     0,   251,     0,     0,     0,     0,
       0,   254,     0,     0,     0,   255,   256,   257,   258,  3946,
       0,   259,   260,   261,     0,     0,   262,     0,     0,     0,
       0,   263,     0,     0,     0,     0,   265,     0,     0,     0,
     266,   267,     0,   268,   269,  3947,     0,     0,   270,     0,
       0,     0,   272,     0,     0,   273,  3948,     0,   274,   275,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,     0,   280,   281,     0,     0,     0,     0,  -321,     0,
       0,   282,     0,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
       0,   300,   301,   302,     0,   303,   304,   305,   306,     0,
     307,   308,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,     0,     0,   315,   316,     0,   317,     0,   318,
       0,   319,   320,   321,   322,   323,   324,   325,   326,   327,
       0,     0,   328,   329,     0,     0,   330,   331,   332,   333,
       0,     0,     0,     0,   335,     0,     0,     0,   336,     0,
     337,     0,   338,   339,     0,   340,     0,   341,  3949,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   345,   346,     0,     0,   348,     0,   349,   350,   351,
     352,   353,   354,   355,   356,   357,     0,     0,     0,     0,
     360,   361,     0,   362,     0,   363,   364,   365,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,     0,     0,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
     380,   381,     0,   382,     0,     0,   384,     0,   386,  -321,
       0,   387,     0,     0,     0,   389,     0,     0,   391,   392,
     393,  3950,   394,     0,     0,     0,   396,   397,   398,   399,
     400,   401,   402,     0,   404,   405,     0,   406,     0,     0,
       0,     0,   408,   409,   410,     0,     0,     0,     0,   412,
       0,     0,     0,   413,     0,     0,   415,     0,   417,     0,
     418,     0,     0,   421,   422,     0,     0,     0,     0,     0,
     423,   424,   425,     0,   426,   427,     0,   428,     0,     0,
     429,     0,     0,   430,     0,   432,   433,   434,   435,     0,
       0,     0,   437,     0,   438,   439,   440,   441,   442,   443,
       0,     0,   444,   445,   446,   447,     0,   448,   449,     0,
       0,   450,   451,   452,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,     0,     0,     0,     0,     0,   460,
     461,     0,     0,     0,     0,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,     0,     0,     0,     0,   472,
       0,     0,  4304,     0,     0,     0,   475,   476,     0,     0,
       0,     0,     0,     0,   477,     0,     0,   478,     0,     0,
       0,   479,   480,   481,   482,   483,     0,     0,  -321,     0,
       0,     0,   484,     0,     0,   486,     0,   488,     0,   138,
     489,   139,   140,   141,   142,   143,     0,     0,   144,     0,
       0,     0,   145,     0,     0,     0,     0,   147,   148,   149,
     150,   151,     0,     0,     0,     0,     0,     0,   154,     0,
       0,     0,   155,     0,     0,   156,   157,   158,     0,   159,
       0,     0,     0,     0,     0,   162,     0,     0,   163,   164,
       0,   165,     0,     0,     0,     0,   168,   169,   170,     0,
     172,   173,     0,   174,   175,     0,   176,   177,     0,   179,
       0,   181,   182,   183,   184,     0,   185,   186,     0,   187,
     188,   189,     0,   191,     0,     0,     0,   192,     0,     0,
     193,     0,   194,     0,     0,   195,     0,     0,     0,   196,
     197,   198,     0,     0,   199,     0,     0,     0,     0,   200,
       0,     0,     0,     0,     0,   202,   203,     0,   204,     0,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,     0,     0,     0,     0,   212,   213,   214,     0,     0,
       0,   215,     0,     0,   217,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,   227,     0,
       0,     0,   229,   230,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,     0,     0,     0,     0,     0,
       0,     0,   241,     0,   242,     0,   243,     0,   244,   245,
     246,   247,     0,   248,     0,   249,     0,     0,     0,     0,
     251,     0,     0,     0,     0,     0,   254,     0,     0,     0,
     255,   256,   257,   258,     0,     0,   259,   260,   261,     0,
       0,   262,     0,     0,     0,     0,   263,     0,     0,     0,
       0,   265,     0,     0,     0,   266,   267,     0,   268,   269,
       0,     0,     0,   270,     0,     0,     0,   272,     0,     0,
     273,     0,     0,   274,   275,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,     0,   280,   281,     0,
       0,     0,     0,     0,     0,     0,   282,     0,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,     0,   300,   301,   302,     0,
     303,   304,   305,   306,     0,   307,   308,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,     0,     0,   315,
     316,     0,   317,     0,   318,     0,   319,   320,   321,   322,
     323,   324,   325,   326,   327,     0,     0,   328,   329,     0,
       0,   330,   331,   332,   333,     0,     0,     0,     0,   335,
       0,     0,     0,   336,     0,   337,     0,   338,   339,     0,
     340,     0,   341,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   345,   346,     0,     0,
     348,     0,   349,   350,   351,   352,   353,   354,   355,   356,
     357,     0,     0,     0,     0,   360,   361,     0,   362,     0,
     363,   364,   365,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,     0,     0,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,   380,   381,     0,   382,     0,
       0,   384,     0,   386,     0,     0,   387,     0,     0,     0,
     389,     0,     0,   391,   392,   393,     0,   394,     0,     0,
       0,   396,   397,   398,   399,   400,   401,   402,     0,   404,
     405,     0,   406,     0,     0,     0,     0,   408,   409,   410,
       0,     0,     0,     0,   412,     0,     0,     0,   413,     0,
       0,   415,     0,   417,     0,   418,     0,     0,   421,   422,
       0,     0,     0,     0,     0,   423,   424,   425,     0,   426,
     427,     0,   428,     0,     0,   429,     0,     0,   430,     0,
     432,   433,   434,   435,     0,     0,     0,   437,     0,   438,
     439,   440,   441,   442,   443,     0,     0,   444,   445,   446,
     447,     0,   448,   449,     0,     0,   450,   451,   452,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,     0,
       0,     0,     0,     0,   460,   461,     0,     0,     0,     0,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
       0,     0,     0,     0,   472,     0,     0,   473,     0,     0,
       0,   475,   476,     0,     0,     0,     0,     0,     0,   477,
       0,     0,   478,     0,     0,     0,   479,   480,   481,   482,
     483,     0,     0,     0,     0,     0,     0,   484,     0,     0,
     486,     0,   488,     0,     0,   489
};

static const yytype_int16 yycheck[] =
{
       6,   644,   645,   571,   953,   635,   570,   571,   590,   123,
     873,   874,   853,    19,   954,  1836,  1233,    23,  1549,  1483,
     883,    20,  1682,  1043,     6,  1107,    32,  1084,   705,  1280,
    1803,    30,  1377,    39,  1545,  1546,    42,    36,   891,  2026,
      46,   606,   889,  1358,  1233,  2305,   913,    53,    23,  1481,
    2413,   665,  2260,  1137,   619,  2402,  2089,  1160,  2474,  1985,
     913,  2094,   515,  1964,  1167,  1137,  1985,   914,  2431,  2432,
    2887,  2752,  1462,  1462,  2810,  3207,  1466,  1466,  1468,  1468,
    2362,  2363,  1462,  1074,   631,   632,  1168,  1169,    94,  2578,
    1172,  1173,  1174,  1175,  2185,  1177,  1178,  1179,  1180,  1181,
    1182,  1183,  1184,  2390,  1286,  2006,  2223,  2008,  2009,  1755,
     116,  1388,   118,  2014,  2015,  2323,   122,   123,   124,    94,
     958,  2604,  2023,  2024,  2500,  2608,   958,  2028,  1912,  1406,
    1985,  2051,  3267,  1825,  1981,  1981,   118,  1414,  1415,     4,
     122,  1531,  1531,   773,  2441,  2610,  2935,   761,   762,   763,
    2348,  1531,   649,  2383,  2999,  2607,  2882,  3442,    19,  3082,
     774,  2391,  2051,    17,  1936,  1937,  3545,  3546,    16,    17,
    3549,    19,   933,    24,    20,    33,  2443,    46,    59,  2888,
    2447,  1953,    50,  2546,  2547,  1452,  2370,     9,  2860,  3568,
      70,  2458,    21,    29,  2668,  3574,  1205,  2072,  1970,  1971,
    2576,    16,    17,  2470,  2051,  2051,  2435,    29,    17,   130,
    2179,    19,    74,    35,    35,    21,  2863,  1973,  3488,   171,
      21,    12,   104,   158,    20,  2040,  2389,    33,   120,    58,
      59,    78,    33,    16,    17,   186,   120,   802,    16,    17,
      42,    47,   915,   120,    11,  3223,    47,   263,    16,    17,
      41,  2580,    58,    59,   644,   645,    82,    58,    59,   151,
    3718,    35,  1834,  2035,  2036,  2037,  2038,   151,    55,   834,
      75,  3701,  2173,   106,   151,   368,   139,  2706,   192,   199,
     126,    11,   247,    16,    17,   319,   375,    19,  3708,   443,
     151,  3305,   355,   358,   155,    65,   405,   151,    89,  2431,
    2432,    24,    93,    51,   244,   247,  3438,    80,   120,   265,
      74,   133,   451,    61,    16,    17,   258,   262,   244,   637,
     418,   134,   134,    16,    17,   229,    23,    74,  2757,  3764,
     126,   364,  4057,   508,   238,    62,   359,   122,   221,  2739,
    3982,    12,    12,    41,    16,    17,   819,   155,    10,   269,
     125,   547,  2358,   122,    12,   122,   547,   390,   189,   375,
     269,    62,   488,    16,    17,  3635,  3745,   354,   145,   189,
     578,    67,  1015,  1016,  1017,  3754,   227,   784,  1955,    16,
      17,   162,    19,   418,    16,    17,    61,   249,   209,  1927,
     504,   125,   225,   513,   432,   610,  1073,   280,  3777,   145,
    3677,   510,   225,  3782,   439,   505,  2590,   547,  2592,   626,
    1087,   192,   260,  3683,  2546,  2547,   633,   590,   238,   634,
      16,    17,   522,   155,   538,   633,   546,   250,  3705,  2829,
     153,   145,   263,    21,   560,   209,   134,   984,   473,   462,
     847,   632,    67,   639,  2319,    33,   433,   356,  4173,    16,
      17,   242,   237,   562,    16,    17,   231,   140,   309,    47,
     523,   634,   414,   936,   135,   135,   163,   640,   237,  4111,
      58,    59,   647,   511,    16,    17,   380,   135,   418,   797,
     634,    16,    17,    64,   449,   249,  1426,  2903,  1351,  3924,
    2866,   405,   418,   602,  2870,  2396,   189,    50,   504,   505,
    3514,   640,   249,   459,   227,   318,   318,   280,  2884,  2885,
     185,   545,   610,   455,   547,  2554,   522,   189,   245,  3497,
    2896,   269,   615,  3808,    16,    17,   374,   318,   534,   377,
    2817,   414,   538,  1163,   540,  1382,  3668,   571,  1385,   341,
     603,  1856,   272,  1390,   245,   634,  2745,   553,   280,  2925,
    3222,    16,    17,  3225,  3226,   475,  1233,  1171,    16,    17,
      16,    17,   578,    61,   570,  1955,  1955,   354,   633,  1416,
    1417,  3706,   578,  3220,  1188,  1955,    16,    17,  2762,  2763,
     448,    16,    17,  1973,  1973,  1438,   309,   413,  2435,  2435,
     596,   374,   383,   983,   377,  2958,   374,    16,    17,   377,
     606,  1981,   608,  1056,  1057,  4063,   374,   453,  1825,   377,
     377,   155,  2513,   619,  1452,   478,   622,  4047,   465,  4049,
    1452,   627,  2851,   629,  1077,   631,   632,   541,  1710,  1906,
     636,   637,   355,  1086,  2554,   641,  1825,  2492,  3483,  1721,
     622,   374,  1724,  1033,   377,  1098,  1099,  1100,   418,   350,
    2040,  2040,   627,  1106,   660,  2818,  2819,   453,  2987,   610,
    2040,  2051,  2051,   608,  1211,  2554,  3402,  3141,   155,   604,
    2442,  2051,   374,  2445,  2446,   377,  2448,  2433,  3813,  2451,
    2452,   374,   634,  2455,   377,   799,   418,  3822,  2460,  3118,
    3119,  3120,  1530,  2465,  2466,  2467,  2468,  2469,  1530,   705,
    2669,  2473,   374,  2475,   495,   377,   528,  2554,  2554,  2481,
    2482,  2483,  2484,  1704,  2589,  2487,   597,  2489,  3853,  2979,
     602,   374,   558,  1732,   377,   646,   547,   549,   403,  3999,
    3159,  3160,  3161,  2548,   556,  3209,  1283,   374,  3154,  1412,
     377,   610,   374,   405,   535,   377,   638,   576,   610,   558,
     558,  1298,   632,  2325,   638,  1516,   610,   579,  4178,   873,
     766,   638,   768,   877,   878,   570,   634,  2034,  4038,  3692,
     576,   619,  2545,   547,   632,   576,   890,   638,   374,   625,
    2552,   377,  1347,   634,   638,   618,   634,   470,   794,   795,
     796,   797,   798,   799,  3520,   801,   802,  3506,   804,   600,
     523,   528,   808,  4182,   619,  4184,  4448,   374,   814,   584,
     377,   512,   374,   795,  2998,   377,   798,  4102,   824,   801,
     567,  1386,  3494,   519,    16,    17,  2958,   528,   834,   835,
     607,   632,   374,   839,  2266,   377,   619,  2414,   952,   374,
    3685,   619,   377,   590,  2382,    16,    17,   103,   510,   824,
     584,   619,    16,    17,   637,   633,   634,   590,    16,    17,
     835,   607,  2868,  2394,   839,   633,   634,   873,  2689,  1366,
    3246,   877,   878,   155,    16,    17,    16,    17,    16,    17,
     603,    70,   374,   615,   890,   377,   619,  3147,  2894,  2895,
      16,    17,  1456,   607,   519,   448,  3243,    50,    16,    17,
     562,   634,    16,    17,   579,  1470,   162,   488,  2729,   374,
    3197,   634,   377,   227,  3201,   616,   374,   619,   374,   377,
    2959,   377,   125,    16,    17,    68,   619,   933,   426,   611,
     612,   633,   634,  3508,   374,   479,   192,   377,  4107,   374,
     602,   634,   377,  4228,    16,    17,   952,   619,   954,   632,
    1627,  3150,   634,   636,  3162,   374,    16,    17,   377,     8,
     368,   633,  2735,   828,   470,  3341,   619,  3197,  2869,   174,
    2871,  3201,   978,   155,   171,    16,    17,  2878,   984,  1842,
     633,  3179,   619,   550,   313,   807,  4121,   619,   576,    16,
      17,  2892,   479,    40,  2458,  2921,  3293,  4132,  2899,  1862,
     626,   633,  2921,   978,  2851,  2851,   388,   633,   596,   597,
    2911,  2912,  2913,   117,  3803,   369,  2917,  2362,  2363,  3448,
     263,  2805,  3206,   619,  2414,  2414,  4161,  3294,   231,  1035,
    1036,  1037,  1038,  1039,  2414,  1902,  1150,  2119,   634,  2959,
     423,   355,  1539,  2433,  2433,   120,  3529,   225,  1895,  1902,
      16,    17,   619,   153,  2074,  2435,  2702,   619,  1905,   352,
    1035,  1908,  1909,  2755,  1039,  1932,  2921,  1073,  3533,   153,
    2959,   633,   634,  1187,   302,  3527,  3528,   619,   125,  1932,
    3563,  1087,   155,  3535,   619,  1728,  3538,  3539,  3571,    16,
      17,   633,   634,  2196,  2371,  3578,    16,    17,   633,  3564,
    3565,  3192,   192,  3555,  2286,  2877,   189,   118,   401,  1723,
    4242,   280,  2959,  2959,   186,    33,   519,  3569,  2890,    45,
    1234,  3610,  3574,  3575,  3576,  3577,   632,   619,  3504,   613,
     179,  1137,   375,  3250,   470,   191,   171,    16,    17,    24,
     221,   633,   634,   227,  1150,  2202,  2203,    98,  1825,   405,
    2810,   148,   357,   640,   619,  1798,   155,   363,  2548,  2548,
     263,   619,   159,   619,  2554,  2554,    16,    17,  2548,   634,
    1735,   117,   151,   277,  2554,  1289,   634,  3078,   634,   619,
     206,  1187,   374,   184,   619,   377,  1192,   186,  3475,  3476,
     573,  1738,  2274,   633,   634,   598,  2034,   479,   633,   634,
     619,   354,  2034,   374,  2195,  1211,   377,   615,  1773,   523,
     374,  4380,   125,   377,  2205,   634,   374,   414,   407,   377,
     221,  2305,    16,    17,   250,   236,   212,  1233,  1234,    16,
      17,  3806,   374,   376,   374,   377,   374,   377,   441,   377,
      16,    17,   221,   136,    16,    17,  1811,  1812,   374,   418,
     632,   377,    16,    17,   358,   355,   374,    16,    17,   377,
     374,   125,  1827,   377,  1270,   348,  1272,   470,  1274,    16,
      17,   355,   375,    16,    17,   488,    57,  1283,    16,    17,
     206,   374,   357,  1289,   377,   541,   640,  2719,    24,   603,
      16,    17,  1298,  1299,  3067,   448,   632,   479,  3979,  1274,
      16,    17,   374,   632,   141,   377,   562,   174,  2392,  4045,
    3991,    16,    17,   151,   374,   405,   107,   377,   231,   110,
    2392,  1327,    16,    17,  1299,   478,    16,    17,   680,  1335,
    3363,   277,  1338,   374,   387,  3617,   377,    16,    17,   351,
     352,  1347,   227,    16,    17,  1459,   602,   374,   229,   538,
     377,  1357,  1358,  3613,    16,    17,   393,   238,   640,   564,
     441,  1367,  1368,  1369,  1370,  1371,  1372,   231,   470,    16,
      17,  1377,   561,   633,   634,   580,   373,  1383,  1384,   414,
    1386,   584,   435,  1389,   302,  1367,  1368,  1369,   190,  1371,
     171,   588,    16,    17,   175,  1370,   184,  1372,  2862,  2863,
     752,  4533,  1384,  1409,   274,   186,   479,  1389,   374,   420,
    1275,   377,   358,    16,    17,    16,    17,    16,    17,    31,
    3947,  3948,  3323,   523,   309,   263,    19,   619,   634,   632,
     464,   151,   341,   221,  1409,   541,    16,    17,   331,   523,
     496,   633,   634,   393,  4261,    12,   615,   374,   619,   470,
     377,   541,     0,  1459,   374,   619,   365,   377,   640,    20,
     507,   619,   441,   634,  1470,   569,   336,  3240,   279,  1475,
     634,  2851,  1478,  1479,    12,  3891,   634,   619,   525,   619,
     479,   619,  4181,  3409,   351,   352,   151,    16,    17,  3408,
     357,   227,   634,   619,   634,   374,   634,  1362,   377,   380,
    1475,   619,    95,   603,  1479,   619,    81,   554,   634,  3856,
    1516,   470,    16,    17,   525,    12,   634,    16,    17,   603,
     634,    16,    17,   579,   374,   100,   619,   377,   441,  1535,
     632,  1537,  1538,   519,  1540,  1541,   317,   463,  2755,   123,
     189,   634,   379,   263,   632,    11,  1552,   619,  1554,   546,
    3810,    17,   640,   588,   470,  1537,  1538,   470,   151,   619,
      68,   633,   155,    16,    17,   126,  2755,   640,   135,  2959,
    2959,  2591,   179,   309,   634,   302,  2827,   441,   619,  2959,
     374,   634,  2685,   377,   386,  2199,   235,   374,   589,  3791,
     377,   184,   619,   186,  3627,    16,    17,   135,   374,   634,
    1465,   377,   374,   186,   470,   377,   470,   634,   960,   202,
     374,   632,   155,   377,   207,   374,    16,    17,   377,   355,
     390,  1627,  1628,   569,   155,  1739,   238,   374,   221,   440,
     377,   374,   547,   414,   377,   228,   374,   470,   135,   377,
     470,  3629,   235,  2096,    16,    17,   253,  3855,   374,   519,
     262,   377,   160,   619,   247,   400,  2740,  2110,   374,   638,
     202,   377,    33,    16,    17,   258,   221,   633,  2740,   374,
     263,   584,   377,   632,   162,    16,    17,   636,   202,   272,
     374,   590,  1688,   377,   374,   487,   413,   377,    59,   272,
    2143,   122,   619,    39,  3126,   374,   280,   564,   377,   619,
      46,   374,  4401,  4402,   377,   640,   123,   634,    16,    17,
      16,    17,   374,   580,   634,   377,   632,   632,   547,   632,
     584,    16,    17,   247,  1730,  1839,   375,   374,   486,  1735,
     377,  1737,  1738,  1739,   627,   628,   629,   630,  2352,   206,
     619,   103,  3402,   558,  1750,  3947,  3948,   354,   341,  1755,
     374,  3652,   633,   377,  1760,   634,  3220,    17,   162,  2212,
     551,   488,  1737,   554,    16,    17,   632,  1773,   632,   619,
     608,   374,   365,   374,   377,   374,   377,   547,   377,   220,
    4307,  4308,   375,   250,   634,  1791,  2350,   523,   192,  1795,
    4153,  4154,  3780,   210,   374,  3783,   132,   377,   609,   632,
     638,   589,   632,   632,   541,  1811,  1812,  1813,  1814,    16,
      17,   147,   405,   202,  2898,   427,  1791,    16,    17,  1825,
    1795,  1827,   544,     8,   582,   619,  2898,   590,    16,    17,
    3294,   225,   619,  1839,    16,    17,    16,    17,  1813,  1814,
     634,   470,   220,   619,    29,   374,   633,   619,   377,   211,
    1856,   375,   200,   634,  3073,   619,   550,   633,  3077,    24,
     619,   633,   455,   280,   622,  1871,  3181,   603,   376,   633,
     374,   634,   619,   377,   633,   374,   619,   640,   377,   374,
     264,   619,   377,   267,   202,   478,   633,   567,   608,   120,
     633,  4093,  4094,   619,   538,   633,   130,   541,   632,  3886,
    3887,  1907,   235,   619,    16,    17,   640,   633,   369,    74,
     590,  2752,   143,  1919,   619,    16,    17,   633,   638,  4247,
    1926,   374,  4250,  2786,   377,   619,    46,  2794,   633,   619,
     189,   524,  1907,  2800,  3707,  2049,    16,    17,   595,  2053,
     619,  2794,  3193,   633,  1809,  3002,   619,  2800,   217,   180,
     219,  1926,   238,   374,   633,  2802,   377,   619,   306,   307,
     633,   478,  2825,   311,   312,   594,   595,   280,  4094,  3026,
    3027,   633,   619,   259,   374,  2089,   538,   377,  3535,   541,
    2094,  3538,  3539,   287,   288,   578,   633,   633,  3499,  3500,
     189,   153,  3049,  4195,   590,   619,   589,   590,  3555,  4231,
     638,  1866,   374,   632,  4236,   377,  4238,   172,  4210,   633,
     640,    24,    16,    17,   155,   608,   619,   610,   619,   381,
     619,   374,  4224,   117,   377,   587,    16,    17,   390,    24,
     633,   415,   633,   374,   633,   397,   377,   633,   634,   619,
     633,   634,   371,  2049,   637,   638,   585,  2053,  2691,  2055,
      16,    17,  2058,   633,    95,  4383,   597,   633,   634,   600,
    2066,    74,   227,  2069,   541,   227,   374,  3151,   374,   377,
     510,   377,   970,   971,  2188,  1940,  2058,   185,  2755,   374,
     633,   634,   377,  2089,  1949,  1950,    24,   181,  2094,     6,
     619,    33,   632,  4295,   441,  1960,  1961,  1962,  1963,    11,
    1965,  1966,    74,  2217,   633,  4307,  4308,   225,  4009,  4010,
    4011,  4012,  1010,     6,   225,   619,   225,    59,   632,   458,
     619,  3205,   374,   632,   619,   377,   430,   431,    71,   633,
     492,    58,    59,  3205,   633,   547,    74,   640,   633,   632,
     153,    68,  2007,   632,   309,  2010,  2011,   632,  2013,    74,
     632,  2016,  2017,  2018,  2019,  2020,  2021,  2022,   153,   172,
    2025,  4363,  2027,    56,   632,   107,   619,   374,   110,  4295,
     377,  4373,  2737,   633,   634,   374,   118,   632,   377,  2918,
     633,   153,  2188,   277,   349,   189,   374,   228,   632,   377,
     355,   634,   374,   355,   374,   377,  4017,   377,   619,   189,
     539,   633,   634,  2942,   632,   544,   247,  2213,  4410,    17,
    4412,  2217,   633,   632,   227,   153,   632,   258,   632,   619,
    4422,    74,   633,   634,   632,   587,    17,  2680,   153,    58,
      59,  2237,   227,   633,   172,   633,   634,  2243,  2244,  4441,
    2246,  4443,   185,  4445,   632,  4018,   139,   619,   587,    71,
    4452,   632,  3309,  4025,   493,   227,  4028,  4029,  4030,  4031,
    4462,   633,   374,   602,   358,   377,   619,  2273,  2243,  2244,
     166,  2246,  3617,   374,  4476,  4477,   377,   632,   619,    12,
     633,  3144,   225,   718,  4410,   590,  4412,  2401,  2402,   227,
    4492,  4493,   633,    48,   374,  4497,   309,   377,  1774,  2305,
     341,  1777,   227,  2309,  1780,   740,   632,   250,  2314,  2315,
    2316,   619,  2876,   619,   309,  4441,   136,   632,   753,   754,
    2326,  2244,  2328,  2246,   619,   633,   274,   633,   136,  4230,
    3350,    12,   633,   634,   633,   634,   349,    48,   633,  2314,
    2315,  2316,   355,  4115,  2350,   136,   633,   634,   633,   634,
    4476,  4477,   632,  3437,   633,   634,  2362,  2363,   523,   632,
     355,   523,   632,   185,   632,  3437,   115,   619,   633,   634,
     374,   309,   634,   377,   227,   632,    30,   349,   632,  4151,
    4152,   633,  4155,   355,   374,  4045,  2392,   377,  4160,   632,
      57,  2314,  2315,  2316,   632,  2401,  2402,  1049,  1050,  1051,
     632,   343,   135,   225,   632,  3869,  3870,   633,   634,  1061,
     632,   349,   619,   632,   455,   117,     6,   355,   633,   634,
     619,    11,    76,    13,   349,    15,   633,   632,   250,   632,
     355,   619,  3516,   627,  3374,    25,    26,   619,   603,   619,
    1092,   603,   470,  1095,  3516,   633,   633,   634,   145,   146,
     478,   633,   424,   633,   135,    19,   633,   634,   632,   352,
     403,  2326,   633,   634,  1116,  1117,    56,   216,  1120,   632,
      60,    61,   634,   633,   634,   569,    66,   210,   632,   181,
    2486,   633,   634,   524,    74,  4016,  1138,  1139,   633,   634,
     632,  3230,    82,   632,  2500,   149,   349,   632,   117,   424,
    3717,    91,   355,   632,   171,  2511,   632,   619,   175,   632,
     523,   331,   633,   634,   464,   217,   106,   219,   619,   186,
     578,   633,   632,   331,   417,  3264,   419,   632,   523,   210,
     120,    95,   633,  3272,   124,   633,   634,  3276,   478,   619,
     331,   632,   132,   133,   486,   584,   585,  3764,   587,   139,
     589,   523,   640,   633,   117,   633,   634,   147,   633,   634,
     632,   151,   181,   153,   632,   387,   594,   595,   632,  2575,
    2576,   424,   321,   632,   164,   277,   325,   632,  2584,  2585,
    2586,   403,   632,   332,  3037,   523,   632,   151,   117,   632,
     603,   155,  3653,  3654,   184,   632,   637,   632,   523,   136,
    2575,   632,   574,   117,   632,   632,   120,   632,   603,  2584,
    2585,  2586,   554,   632,    61,   619,  3180,   632,   181,    74,
      74,   634,   186,    95,    71,   632,    77,   632,    79,   619,
     632,   603,   632,   223,    88,   225,  3089,    84,   202,   632,
     582,   632,   232,   207,   633,   634,   209,   633,   634,   574,
     317,   106,   181,   633,   634,   632,   358,   632,   277,   249,
      25,   632,   634,   412,   228,   603,   640,   181,   632,   120,
     523,   235,   632,   481,   482,   633,   634,   161,   603,  2544,
     209,   632,   272,   247,   633,   634,   633,   634,  3331,   263,
     481,   482,   143,   186,   258,   209,  2702,   538,   153,   263,
    2706,   238,   519,    68,   633,   634,   519,    72,   272,    74,
     633,   634,  2718,  4534,   277,   633,   634,   161,   308,   468,
     274,   574,   633,   634,   633,   634,   633,   634,   152,   180,
    2736,  2737,   633,   634,  2740,   117,   326,   634,   185,   358,
     330,   633,   634,  2718,   191,    83,   400,   414,   277,  2755,
     603,  2757,   633,   634,   634,   120,   228,   633,   634,    61,
     633,   634,   634,   277,  3846,  2771,   633,   634,   422,    71,
     225,   504,   505,  2887,   507,   247,   509,   341,   225,   366,
     370,   534,    84,    95,   633,   375,   258,   151,    11,   633,
     634,   524,   382,   120,   331,   358,  3360,   387,   252,   181,
     390,   365,   456,   250,   639,   625,   626,   627,   628,   629,
     630,   375,  1124,  1125,   106,   623,   624,   625,   626,   627,
     628,   629,   630,   504,   505,   506,   507,   508,   509,   358,
       6,   421,   623,   624,   625,   626,   627,   628,   629,   630,
     136,   405,   632,   524,   358,   435,   436,   437,   438,  2855,
     105,  3996,  3997,   308,  2860,     4,   605,  2856,   634,  2865,
    2866,   515,  4153,  4154,  2870,   117,  2872,   569,  2867,   341,
     460,   326,   621,   390,  2873,   329,  2882,   469,  2884,  2885,
     103,  2887,  2888,   185,   602,   250,   238,  2893,    31,   191,
    2896,   455,  2898,   365,   349,   277,  3164,  3165,  2897,   122,
     354,  2907,   634,  2902,  3418,  3419,  2771,  1559,   387,  2908,
    2909,    55,  2918,   433,   478,   117,   228,   166,   120,  2925,
    2926,  3665,  3666,   225,   106,   218,   516,   517,   518,   181,
    2936,  4015,  2907,   523,  2940,   247,  2942,   640,  2803,  2804,
     387,  2806,    33,  4015,   481,   482,   258,   634,   250,   539,
     569,  2957,   542,    68,  2936,   117,   403,   209,   120,   634,
     524,    12,   416,   607,  2970,   633,   135,  3907,   633,   192,
     499,  2977,     9,  3913,   425,   565,   358,  1629,   634,   181,
    4125,  1633,   640,   455,  4129,   633,   351,   352,   578,    35,
     633,  2997,   357,   136,   633,   640,   632,   262,   221,   640,
     365,   634,  2977,   153,   634,  1657,   569,   209,   365,  2874,
    2875,   639,   274,   274,   578,   274,   274,    48,   117,   181,
     274,   120,  3615,  3616,   274,   277,   590,   634,  3671,   341,
    4175,  4176,   634,   155,   404,   331,  2901,   128,   403,   458,
     569,   372,   538,   365,   608,   365,   610,   209,   638,   496,
     273,   634,   524,  3167,   269,   569,   510,   634,   388,   287,
     288,   634,   153,   558,   110,   634,   157,   558,   523,   633,
     634,   117,   387,   637,   638,   277,    12,  3083,   155,   156,
     155,   634,   181,   365,   539,  3091,   623,   624,   625,   626,
     627,   628,   629,   630,   365,   238,   634,  2962,    68,    95,
     634,   403,   238,   194,   627,   536,   358,   241,  3114,   474,
     209,  3117,  3118,  3119,  3120,   277,   193,  3739,  3740,   262,
    3713,   212,  3686,   176,   186,   634,  3132,   204,   174,  3243,
    3752,   583,   579,   491,   391,   181,   131,  3759,  3979,   362,
     169,   365,   634,   455,   367,  3151,  3152,   633,   155,  3155,
    3991,   634,   155,  3159,  3160,  3161,   358,  4241,   523,   634,
     585,  3167,  3784,   209,   155,  3787,   243,  3173,   155,  4241,
     155,   155,   155,   155,  3180,  3181,   155,   254,   277,   155,
     155,   155,   405,   274,   155,   481,   482,   569,   331,   155,
     155,   155,   155,   155,   496,   155,   358,   155,   155,  3205,
     155,   155,   430,   431,   281,   155,   614,   634,   351,   352,
     589,   192,   524,   633,   579,   633,  3222,   189,   633,  3225,
    3226,   136,   633,   633,  3230,   627,  3091,   633,   633,   633,
     189,   277,   228,   634,   626,   632,   634,  3243,   633,   633,
    3246,   517,   518,  4183,   520,   521,   633,  4329,   524,  3363,
     526,   247,   633,   476,   634,   633,   633,   633,  3264,   358,
     103,   633,   258,   479,   578,   632,  3272,   633,   345,   632,
    3276,    25,    26,   501,   502,   503,   630,   579,    35,  4142,
     547,   632,  3850,   547,   427,  3878,  3879,   634,  3881,  3882,
     538,   547,  3298,   632,   226,  3301,   342,   608,   632,   530,
    3306,    11,   634,   632,    58,    59,    60,   353,   632,   632,
     189,   357,   358,   404,    68,  3321,   539,   569,   541,   162,
      74,   640,   413,   238,  3189,   260,  3301,   634,    82,   625,
     626,   627,   628,   629,   630,  3341,   634,   428,   481,   482,
      25,    26,   633,  3457,  4426,   341,   640,   413,   587,   192,
     640,   494,   106,   110,   640,   446,   634,  3363,   478,   634,
     117,   186,    46,   510,   587,   510,   120,   569,   510,   365,
     124,   339,   510,    58,    59,    60,   469,   510,   390,  3244,
     436,   632,   225,    68,   273,   632,   632,   365,  3253,    74,
     590,  3973,   365,   633,   149,   640,   365,    82,   489,   153,
    4340,  4341,   234,  4343,   633,   234,   640,   569,   633,   155,
     515,   633,   136,   633,   633,   633,   331,   174,   558,   633,
     633,   106,  4506,   634,   181,   634,  3432,   634,   519,   547,
     273,  3437,   615,   269,  4506,   120,  4520,    46,   543,   124,
     632,  4525,  3448,   632,   155,   632,  4530,   538,  4520,  3314,
     541,  3457,   209,  4525,  4394,   558,  4396,  4397,  4530,   455,
     632,   155,   200,   189,   235,  4033,  4109,   189,   153,   547,
     569,   225,  3337,   547,   244,   418,    74,  4107,   232,   634,
     623,   624,   625,   626,   627,   628,   629,   630,  3494,   358,
      88,   155,   155,   634,   155,   249,   390,   247,  3504,   247,
    3506,   547,   378,   322,   106,   551,   106,   169,   554,    71,
    3516,   558,   387,  3627,  3520,   387,  3522,   387,   564,   362,
     277,   131,   539,   569,   367,   248,   572,   248,   524,   805,
     387,   129,   131,  4473,   539,   387,    46,   387,   389,  4488,
     225,   387,   387,   387,   155,   558,   632,   232,   632,   371,
     202,    19,   451,   547,   308,   640,   632,   400,   627,   387,
     665,   632,   405,   236,   249,   670,   481,   482,   179,   632,
     236,   632,   326,   633,  3688,   633,   633,   262,   633,   625,
     626,  3587,   193,   632,   634,   342,   634,   365,   111,   112,
     113,   114,   115,   204,   633,   640,   701,   633,   633,  3605,
     357,   358,  3467,   633,   632,   558,   640,   331,  3614,  3615,
    3616,  3617,   717,    54,   640,   136,   558,   558,   221,   633,
     264,  3627,    63,   308,   634,   387,   634,   633,   382,   640,
     372,   189,    73,   476,   189,   189,   390,   584,   418,   155,
     633,   326,   253,   254,    85,    86,    87,  3761,   238,   121,
     247,   247,   365,    54,   252,   250,   761,   762,   763,   764,
     101,   250,    63,   640,   401,  4528,   633,   365,   365,   774,
     281,    74,    73,   634,    19,   365,   365,   633,   493,  4243,
     632,   470,  3688,   634,    85,    86,    87,   633,   375,   634,
     213,   214,   215,   216,   633,  3701,   539,   382,    12,    13,
     101,   544,   358,    46,   472,   390,   460,  3713,   623,   624,
     625,   626,   627,   628,   629,   630,  3722,   633,   610,   562,
     633,   260,   453,   418,  3730,  3724,   627,   142,   256,  3594,
     633,   329,   634,   633,   189,   202,   480,   348,   155,   392,
     247,   247,  3856,   634,   587,   632,   250,  3722,   250,   634,
    4380,   610,   634,   351,   352,  3761,   354,   481,   482,   602,
     633,   632,   516,   517,   518,    78,   138,   633,   488,   523,
     633,   633,   465,   634,   493,   460,    19,   633,   632,   632,
      94,   263,  3788,   632,    33,   539,   633,    33,   542,   252,
     547,   402,   633,   633,   551,  3801,  3802,   554,   321,   633,
     323,   324,   325,   633,   328,   413,   633,   564,   634,   332,
     331,   125,   569,   633,   272,   572,   633,   633,   416,    11,
    4388,   170,   272,   200,   578,   139,  3691,  3802,   235,    16,
      17,   516,   517,   518,   632,   634,   633,   640,   523,  3845,
      46,   207,  3848,   634,   328,   155,   632,   590,   162,   590,
    3856,   165,  4482,   632,   539,   120,   120,   542,   541,   632,
     632,   399,    33,   640,   178,   634,   633,   358,   625,   626,
    3845,   328,  3878,  3879,   168,  3881,  3882,   633,  4508,   320,
     634,   610,   372,   250,   541,   990,   200,   632,  4531,   412,
     594,   590,   632,   578,   590,   305,   337,   632,  3763,   623,
     624,   625,   626,   627,   628,   629,   630,   632,   600,   600,
     584,   225,   510,   120,   632,   250,   633,   231,   632,   320,
     632,   250,   357,   514,   111,   112,   113,   114,   115,   358,
     610,   451,   632,   634,   547,   547,   337,   584,  3944,   235,
    1045,  1046,   547,  3949,   467,   468,   529,   632,   353,  1054,
    1055,  1056,  1057,  1058,  1059,  1060,   633,   633,   272,   365,
     481,   482,   632,  1068,  1069,   632,  1071,  1072,   595,   634,
     150,  1076,  1077,   607,    30,  1080,  1081,  1082,  1083,   633,
    1085,  1086,   641,   186,   633,   358,   372,  3993,  1093,  1094,
     549,  1096,  1097,  1098,  1099,  1100,   131,   131,  1103,  1104,
    1105,  1106,  1107,  1108,  1109,  1110,  1111,  1112,  1113,  4015,
    1115,   632,   153,  1118,  1119,   405,    70,  4195,  1123,   186,
     607,   189,  1127,  1128,  1129,   466,   213,   214,   215,   216,
      30,   103,  4210,    61,   372,  1140,  1141,  1142,   632,    61,
     633,  4047,  4156,  4049,  1149,   633,  4224,   633,   385,   450,
     634,  1156,  1157,  1158,   632,  1160,   530,    14,   426,   235,
    4066,   265,  1167,  1168,  1169,   466,  1171,  1172,  1173,  1174,
    1175,   149,  1177,  1178,  1179,  1180,  1181,  1182,  1183,  1184,
    4086,   638,   605,  1188,  1189,   526,   372,   372,   129,   138,
     632,    46,   406,    46,    46,   148,   410,   620,   621,    46,
      46,   632,   543,   624,   625,   626,   627,   628,   629,   630,
     632,     5,   426,   365,    33,   365,   149,   220,   607,   191,
     434,   279,   641,   638,   119,   526,   144,   632,   442,   543,
      46,    46,    46,   584,   321,   125,   323,   324,   325,    52,
     138,  4147,   543,   638,   461,   332,   550,  4261,   459,   634,
    4156,  2010,  2011,   225,  2013,   633,   470,  2016,  2017,  2018,
    2019,  2020,  2021,  2022,   358,   149,  2025,   550,  2027,   483,
     484,   205,   634,   634,   638,   218,    52,   633,   149,   633,
     186,   634,   186,   186,    46,  4363,   550,   374,   609,   440,
     377,   120,   221,   358,   632,  4373,   188,   478,   634,  3954,
    3323,   273,  2225,  2029,  3324,  2430,   645,  3603,  3984,   128,
    4110,  4314,  3601,  4315,   967,  3605,  3800,  4508,  4470,   533,
      46,  4335,   572,  1824,  1760,   412,  2702,  3791,  3791,  4478,
    1335,  3791,  3791,  3791,   153,  4241,  3791,  3791,   157,  3791,
    1345,  3791,  3791,  4360,  4422,  4188,  3791,  4360,   562,  4114,
    4308,  3791,  3791,  4214,  4213,  4261,   670,  1008,  1363,  2499,
    1468,  3809,  1985,  3270,  3431,  4443,  2731,  4445,  1286,  3132,
     584,  4147,   586,  2736,  4452,   194,  3846,  4245,    12,    13,
     467,   468,  3434,  4426,  4462,  4150,  4337,   701,  4033,  4388,
     362,   512,  1530,   212,  3340,   367,  2492,  2963,  2925,  3341,
    2500,  3546,  2928,   717,  3504,  3546,  3579,  3905,  3723,  3772,
    4243,  3761,  2401,  2658,  4492,  4493,  3077,  3074,  3069,  4497,
    4172,  4176,   513,   513,  2062,  4175,  4129,  4117,  4125,  4335,
    3993,  2582,  2499,  3913,  2921,  1423,    13,   575,    15,  1419,
    3728,  2300,  3505,  1813,  1479,  4351,  4352,  1526,  2718,  3127,
     764,  2266,  2317,    30,   591,   274,  2181,    34,  3091,  4365,
      94,  2691,   865,  2393,  1833,  2095,  4372,  3195,  2180,  3872,
    4351,    48,    49,  4052,  3321,  4352,  2206,  3516,  1087,    56,
    1061,  3702,  4459,    60,    61,  3688,  1438,  4252,  4253,  2322,
    2066,   125,  1197,   953,  1274,  1299,  2261,   953,  2304,    76,
    3146,  3437,  4516,  3145,   476,   139,   953,  3205,   580,  4241,
     953,   571,  1749,  1552,   661,  1903,  1306,    94,   605,  1904,
    3130,  3522,  4424,  1403,   496,  4268,  1375,  4455,   162,  4347,
    4525,   165,   619,   620,   621,  2340,  4442,  3764,  4530,   116,
    3151,  4447,  1335,  2347,   178,  3180,   570,   570,   125,   126,
     127,  3181,  1685,  2339,  2333,  1795,  1859,  1828,   850,  3114,
    1565,   138,   139,  1535,  1322,  1782,   200,   539,   565,   541,
    4007,   852,   544,   508,   151,  4013,  4482,   508,  3974,  3589,
      -1,   645,   645,   645,    -1,   404,    -1,    -1,   165,    -1,
      -1,   225,    -1,    -1,   413,    -1,    -1,   231,    -1,    -1,
    4506,    -1,  4508,    -1,    -1,    -1,   183,   579,    -1,   428,
    4516,    -1,    -1,    -1,  4520,   587,    -1,    -1,    -1,  4525,
      -1,   198,    -1,   200,  4530,    -1,    -1,   446,   205,    -1,
      -1,   208,    -1,    -1,    -1,    -1,    -1,    -1,   272,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   231,    -1,   233,    -1,  1663,  1664,
    1665,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     489,    -1,    -1,  1678,   251,    -1,   990,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   268,    -1,    -1,    -1,   272,    -1,    -1,    -1,  1704,
     519,    -1,    -1,    -1,    -1,  1710,    -1,    -1,  1713,    -1,
    1715,    -1,    -1,    -1,    -1,    -1,  1721,    -1,  1723,  1724,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1045,  1046,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1054,  1055,    -1,    -1,  1058,  1059,  1060,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1068,  1069,    -1,  1071,  1072,    -1,
      -1,    -1,  1076,    -1,    13,    -1,  1080,  1081,  1082,  1083,
      -1,  1085,   406,    -1,    -1,    -1,   410,    -1,    -1,  1093,
    1094,    -1,  1096,  1097,    -1,    -1,    -1,    -1,    -1,  1103,
    1104,  1105,   426,   370,  1108,  1109,  1110,  1111,  1112,  1113,
     434,  1115,    -1,  1808,  1118,  1119,    -1,    -1,   442,  1123,
     387,    -1,    -1,  1127,  1128,  1129,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   400,    -1,    -1,  1140,  1141,  1142,    -1,
      -1,    -1,    -1,    -1,   411,  1149,   470,    -1,    -1,    -1,
      -1,    -1,  1156,  1157,  1158,    94,    -1,    -1,    -1,   483,
     484,    -1,  1857,    -1,    -1,    -1,   433,    -1,    -1,   436,
    1865,   438,    -1,    -1,   441,    -1,    -1,   444,   445,    -1,
      -1,    -1,    -1,    -1,    -1,  1189,   125,   454,    -1,   456,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   464,    -1,    -1,
     139,    -1,    -1,   470,    -1,    -1,    -1,    -1,    -1,   533,
      -1,   478,    -1,    -1,    -1,    -1,   483,    -1,   485,    -1,
      -1,    -1,    -1,   162,    -1,    -1,   165,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   562,   178,
      -1,    -1,    -1,    -1,    -1,    -1,    32,    33,   515,    -1,
      -1,    -1,    38,    -1,    40,   522,    42,    43,    -1,    -1,
     584,   200,   586,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   225,    -1,    -1,    -1,
      -1,    -1,   231,    -1,    -1,    -1,    -1,    -1,   565,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2004,
     577,    -1,    -1,    -1,   581,    -1,    -1,   584,    -1,    -1,
      -1,   107,   589,    -1,   110,    -1,    -1,    -1,    -1,    -1,
      -1,  1335,   118,   272,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1345,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     617,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1363,
      -1,    -1,    -1,    -1,    -1,   632,    -1,    -1,   154,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2075,    -1,    -1,    -1,  2079,    -1,    -1,    -1,    -1,  2084,
    2085,    -1,    -1,    -1,   180,    -1,   182,    -1,  2093,    -1,
      -1,  2096,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   195,
     196,  2106,  2107,    -1,  2109,  2110,    -1,  2112,  2113,  2114,
    2115,  2116,    -1,    -1,  2119,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2128,    -1,    -1,    -1,    -1,    -1,    -1,
    2135,    -1,  2137,    -1,  2139,  2140,    -1,  2142,  2143,    -1,
     236,    -1,  2147,  2148,  2149,    -1,    -1,    -1,  2153,  2154,
    2155,    -1,  2157,    -1,  2159,    -1,  2161,   406,  2163,    -1,
    2165,    -1,    -1,    -1,    -1,  2170,    -1,    25,    26,    -1,
     266,    -1,    -1,    -1,    -1,    -1,    -1,   426,    -1,   275,
     276,    -1,   278,    -1,  2189,   434,    -1,    -1,    -1,    -1,
      -1,  2196,    -1,   442,  2199,    -1,    -1,    -1,    -1,    -1,
    2205,    -1,    60,  2208,    -1,    -1,    -1,  2212,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    74,    -1,   314,   315,
     316,   470,    -1,    -1,    82,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   483,   484,    -1,   333,   334,   335,
      -1,    -1,    -1,    -1,   340,    -1,    -1,   343,   106,    -1,
      -1,  1565,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   120,    -1,   360,   361,   124,    -1,    -1,  2274,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   533,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   153,    -1,    -1,    -1,   395,
     396,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   562,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   420,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   584,    -1,   586,    -1,    -1,
      -1,    -1,    -1,  2348,    -1,    -1,    -1,  2352,    -1,  1663,
    1664,  1665,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   225,    -1,    -1,
      -1,    -1,    -1,    -1,   232,    -1,    -1,    -1,   474,    -1,
      -1,    -1,   478,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1704,   249,    -1,    -1,   490,    -1,    -1,    -1,    -1,  1713,
      -1,  1715,    -1,    -1,    -1,    -1,    -1,    -1,  2413,   222,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2431,  2432,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     308,    -1,   548,    -1,    -1,   551,    -1,    -1,   554,   555,
     556,   557,    -1,    -1,    -1,    -1,    -1,    -1,   326,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,    -1,
     293,   294,   295,   296,   297,   298,   299,   300,   301,    -1,
     303,   304,    -1,    -1,  1808,    -1,    -1,    -1,    -1,    -1,
     596,   597,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   382,   621,    13,    -1,    15,    -1,
      -1,    -1,   390,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2546,  2547,  1857,    -1,    -1,    -1,    34,    -1,    -1,
      -1,  1865,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    56,
      -1,    -1,    -1,    60,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,
    2595,    -1,    -1,    -1,  2599,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   460,    -1,    -1,    -1,    -1,    94,    -1,    -1,
      -1,    -1,    -1,    -1,  2619,  2620,    -1,   430,   431,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,
      -1,    -1,    -1,    -1,    -1,  2640,    -1,    -1,   125,   126,
     127,    -1,    -1,    -1,  2649,    -1,  2651,    -1,  2653,    -1,
      -1,   138,   139,    -1,    -1,    -1,    -1,    -1,   516,   517,
     518,    -1,    -1,    -1,    -1,   523,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2680,    -1,    -1,   165,    -1,
    2685,   539,    -1,    -1,   542,    -1,    -1,    -1,    -1,    -1,
    2004,    -1,    -1,    -1,    -1,    -1,   183,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2714,
      -1,   198,    -1,   200,    -1,    -1,    -1,    -1,   205,    -1,
     578,   208,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   231,    -1,   233,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2075,    -1,    -1,   251,  2079,    -1,    -1,    -1,    -1,
    2084,  2085,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2093,
      -1,   268,    -1,    -1,    -1,   272,    -1,    -1,    -1,    -1,
      -1,    -1,  2106,  2107,    -1,  2109,    -1,    -1,  2112,  2113,
    2114,  2115,  2116,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2128,    -1,    -1,    -1,    -1,    -1,
      -1,  2135,    -1,  2137,    -1,  2139,  2140,  2832,  2142,    -1,
      -1,    -1,    -1,  2147,  2148,  2149,    -1,    -1,    -1,  2153,
    2154,  2155,    -1,  2157,    -1,  2159,    -1,  2161,    -1,  2163,
      -1,  2165,    -1,    -1,    -1,    -1,  2170,    -1,    -1,    -1,
      -1,    -1,     6,    -1,    -1,    -1,    -1,    11,    -1,    13,
      -1,    -1,    -1,    -1,    -1,  2189,    -1,    -1,    -1,    -1,
      -1,    25,    26,   370,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2205,    -1,    -1,  2208,    -1,    -1,    -1,    -1,    -1,
     387,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    56,   400,    -1,    -1,    60,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   411,    -1,    -1,    -1,  2933,  2934,
      74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    82,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   433,    91,    -1,   436,
      -1,   438,    -1,  2958,   441,    -1,    -1,   444,   445,    -1,
      -1,    -1,   106,    -1,    -1,    -1,    -1,   454,    -1,   456,
      -1,    -1,    -1,    -1,    -1,    -1,   120,   464,    -1,    -1,
     124,    -1,    -1,   470,    -1,    -1,    -1,    -1,   132,    -1,
      -1,   478,    -1,    -1,    -1,   139,   483,    -1,   485,    -1,
    3005,    -1,    -1,   147,    -1,    -1,    -1,    -1,    -1,   153,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3030,    -1,    -1,   515,  3034,
    3035,    -1,  3037,    -1,  2348,   522,    -1,    -1,    -1,    -1,
     184,  3046,    -1,    -1,    -1,    -1,  3051,    -1,    -1,  3054,
      -1,  3056,  3057,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      33,    34,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   565,    -1,
      -1,   225,    -1,    -1,  3089,    58,    59,    -1,   232,    -1,
     577,    -1,    -1,    -1,   581,    -1,    69,   584,    -1,    -1,
      -1,    -1,   589,    -1,    -1,   249,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3121,    -1,    -1,    92,
      -1,    94,    -1,    -1,    -1,    -1,    -1,    -1,   272,    -1,
     617,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3145,    -1,    -1,    -1,    -1,   632,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   308,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3179,    25,    26,    -1,    -1,   152,
     153,    -1,   326,    -1,    -1,   158,   330,    -1,   161,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3207,    -1,    -1,    -1,    -1,    -1,    58,    59,
      60,    -1,    -1,    -1,    -1,    -1,    -1,   190,    68,   192,
      -1,    -1,    -1,    -1,    74,    -1,   199,    -1,   201,    -1,
      -1,   375,    82,    -1,    -1,    -1,    -1,    -1,   382,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   390,    -1,    -1,    -1,
      -1,   224,   225,    -1,    -1,    -1,   106,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     120,    -1,    -1,    -1,   124,   248,    -1,    -1,    -1,    -1,
      -1,  2595,    -1,    -1,    -1,  2599,    -1,    -1,    -1,    -1,
      -1,    -1,   436,    -1,    -1,    -1,   269,    -1,    -1,    -1,
      -1,    -1,    -1,   153,    -1,  2619,  2620,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   460,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2640,    -1,    -1,   302,
      -1,    -1,    -1,    -1,    -1,  2649,    -1,  2651,    -1,  2653,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   516,   517,   518,   225,    -1,    -1,    -1,   523,
      -1,    -1,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   539,   369,    -1,   542,   249,
    2714,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   394,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   404,   405,  3438,   578,   408,   409,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   429,    -1,   308,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3479,  3480,   326,    -1,    -1,    -1,
      -1,    -1,    -1,  3488,    -1,    -1,    -1,    -1,  3493,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   475,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   488,    -1,    -1,  2832,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   382,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     390,    -1,    -1,    -1,    -1,    -1,   519,    -1,    -1,    -1,
     523,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   541,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     460,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2933,
    2934,    -1,    -1,    -1,    -1,   598,    -1,    -1,    -1,    -1,
    3635,   604,    -1,    -1,  3639,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3668,    -1,    -1,   516,   517,   518,    -1,
      -1,    -1,    -1,   523,    -1,    -1,    -1,    -1,  3683,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   539,
      -1,  3005,   542,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3030,    -1,    -1,    -1,
    3034,  3035,    -1,    -1,    -1,    -1,    -1,    -1,   578,    -1,
      -1,    -1,  3046,    -1,    -1,    -1,    -1,  3051,    -1,    -1,
    3054,    -1,  3056,  3057,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3791,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3121,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3145,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3846,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3854,
      -1,    -1,    -1,    -1,    -1,    -1,  3861,    -1,  3863,    -1,
      -1,    -1,    -1,    -1,    -1,  3179,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3207,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3941,    -1,    -1,    -1,
      -1,    -1,  3947,  3948,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3999,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4038,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4079,    -1,  4081,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4091,    -1,  4093,  4094,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3438,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3479,  3480,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3488,    -1,    -1,    -1,    -1,  3493,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4193,    -1,
    4195,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4210,  4211,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4224,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4235,    -1,    -1,    -1,    -1,    -1,    -1,  4242,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4294,
    4295,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4307,  4308,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3635,    -1,    -1,  4329,  3639,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3668,    -1,    -1,    -1,  4363,    -1,
      -1,    -1,    -1,    -1,    -1,  4370,    -1,    -1,  4373,  3683,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4403,    -1,
      -1,    -1,    -1,    -1,    -1,  4410,    -1,  4412,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4422,    -1,    -1,
      -1,  4426,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4441,    -1,  4443,    -1,
    4445,    -1,    -1,    -1,    -1,    -1,    -1,  4452,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4462,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4476,  4477,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4492,  4493,    -1,
      -1,    -1,  4497,    -1,    -1,    -1,    -1,    -1,  4503,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4533,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3854,    -1,    -1,    -1,    -1,    -1,    -1,  3861,    -1,  3863,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3941,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3999,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4038,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4079,    -1,  4081,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4091,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4193,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4211,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4242,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4294,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4370,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,  4403,
      30,    -1,    -1,    33,    34,    35,    36,    37,    38,    39,
      -1,    41,    42,    43,    44,    45,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    55,    -1,    57,    58,    59,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    -1,    85,    86,    87,    88,    89,
      -1,    91,    92,    93,    -1,    -1,    96,    97,    98,    99,
      -1,   101,   102,   103,    -1,   105,   106,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,   115,   116,   117,    -1,    -1,
     120,   121,   122,    -1,   124,    -1,    -1,    -1,   128,  4503,
     130,   131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,  4533,
     160,   161,   162,   163,   164,   165,   166,    -1,   168,   169,
     170,   171,   172,   173,   174,   175,   176,    -1,   178,   179,
     180,   181,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,
     190,    -1,   192,    -1,   194,   195,   196,   197,    -1,   199,
      -1,   201,    -1,   203,    -1,   205,   206,    -1,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,   219,
     220,    -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,
      -1,   231,   232,   233,   234,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,
      -1,    -1,   252,   253,    -1,   255,   256,    -1,   258,   259,
     260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,
      -1,   271,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
      -1,    -1,   282,    -1,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,    -1,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,
     320,   321,   322,    -1,    -1,   325,   326,   327,   328,    -1,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,   342,   343,   344,    -1,    -1,   347,   348,   349,
     350,   351,   352,   353,   354,   355,    -1,   357,   358,   359,
      -1,   361,    -1,   363,   364,    -1,   366,    -1,   368,   369,
      -1,   371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   381,   382,   383,   384,   385,   386,    -1,   388,   389,
     390,   391,   392,   393,   394,   395,   396,   397,   398,    -1,
     400,   401,   402,    -1,   404,    -1,   406,   407,   408,   409,
     410,    -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,
      -1,   421,   422,   423,   424,   425,    -1,    -1,   428,   429,
     430,   431,   432,    -1,   434,   435,    -1,   437,   438,   439,
     440,   441,   442,    -1,   444,    -1,   446,   447,    -1,   449,
     450,   451,    -1,   453,    -1,   455,   456,   457,   458,   459,
     460,   461,   462,   463,   464,   465,   466,    -1,   468,   469,
      -1,    -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,
     480,    -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,
      -1,   491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,
      -1,   501,   502,   503,    -1,   505,   506,    -1,   508,    -1,
      -1,   511,    -1,    -1,   514,   515,   516,   517,   518,   519,
     520,   521,   522,   523,    -1,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
      -1,    -1,   542,   543,   544,   545,    -1,   547,   548,   549,
      -1,   551,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
     560,   561,    -1,   563,   564,   565,   566,   567,   568,   569,
     570,   571,   572,   573,   574,    -1,   576,   577,    -1,    -1,
     580,    -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,
      -1,   591,   592,   593,   594,   595,    -1,    -1,   598,   599,
      -1,   601,   602,   603,   604,   605,   606,    -1,    -1,    -1,
      -1,    -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,
      -1,   621,    -1,    -1,    -1,   625,   626,    -1,    -1,    -1,
      -1,   631,   632,    -1,    -1,   635,   636,    -1,    -1,   639,
     640,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      -1,    85,    86,    87,    88,    89,    -1,    91,    92,    93,
      -1,    -1,    96,    97,    98,    99,    -1,   101,   102,   103,
      -1,   105,   106,   107,   108,   109,   110,    -1,    -1,    -1,
      -1,   115,   116,   117,    -1,    -1,   120,   121,   122,    -1,
     124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,
     134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,
      -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,
     154,    -1,    -1,   157,   158,    -1,   160,   161,   162,   163,
     164,   165,   166,    -1,   168,   169,   170,   171,   172,   173,
     174,   175,   176,    -1,   178,   179,   180,   181,    -1,   183,
      -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,
     194,   195,   196,   197,    -1,   199,    -1,   201,    -1,   203,
      -1,   205,   206,    -1,   208,   209,    -1,   211,   212,    -1,
      -1,    -1,   216,   217,   218,   219,   220,    -1,   222,   223,
     224,    -1,    -1,   227,    -1,    -1,    -1,   231,   232,   233,
     234,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,
     244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,
      -1,    -1,   256,    -1,   258,   259,   260,    -1,    -1,    -1,
      -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,    -1,    -1,   282,    -1,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,    -1,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,    -1,    -1,   317,   318,   319,   320,   321,   322,    -1,
      -1,   325,   326,   327,   328,    -1,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,   342,   343,
     344,    -1,    -1,   347,   348,   349,   350,   351,   352,   353,
     354,   355,    -1,   357,   358,   359,    -1,   361,    -1,   363,
     364,   365,   366,    -1,   368,   369,    -1,   371,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   381,   382,   383,
     384,   385,   386,    -1,   388,   389,   390,   391,   392,   393,
     394,   395,   396,   397,   398,    -1,   400,   401,   402,    -1,
     404,    -1,   406,   407,   408,   409,   410,    -1,   412,   413,
     414,    -1,    -1,   417,    -1,    -1,    -1,   421,   422,   423,
     424,   425,    -1,    -1,   428,   429,   430,   431,   432,    -1,
     434,   435,    -1,   437,   438,   439,   440,   441,   442,    -1,
     444,    -1,   446,   447,    -1,   449,   450,   451,    -1,   453,
      -1,   455,   456,   457,   458,   459,   460,   461,   462,   463,
     464,   465,   466,    -1,   468,   469,    -1,    -1,    -1,   473,
     474,   475,   476,    -1,    -1,    -1,   480,    -1,    -1,    -1,
     484,    -1,   486,   487,   488,   489,    -1,   491,   492,   493,
     494,   495,    -1,    -1,    -1,    -1,    -1,   501,   502,   503,
      -1,   505,   506,    -1,   508,    -1,    -1,   511,    -1,    -1,
     514,   515,   516,   517,   518,   519,   520,   521,   522,   523,
      -1,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,    -1,    -1,   542,   543,
     544,   545,    -1,   547,   548,   549,    -1,   551,   552,   553,
     554,    -1,    -1,    -1,    -1,    -1,   560,   561,    -1,   563,
     564,   565,   566,   567,   568,   569,   570,   571,   572,   573,
     574,    -1,   576,   577,    -1,    -1,   580,    -1,    -1,   583,
      -1,   585,    -1,   587,   588,    -1,    -1,   591,   592,   593,
     594,   595,    -1,    -1,   598,   599,    -1,   601,   602,   603,
     604,   605,   606,    -1,    -1,    -1,    -1,    -1,    -1,   613,
     614,    -1,   616,   617,   618,    -1,    -1,   621,    -1,    -1,
      -1,   625,   626,    -1,    -1,    -1,    -1,   631,   632,    -1,
      -1,   635,   636,    -1,    -1,   639,   640,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,
      18,    -1,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    55,    -1,    57,
      58,    59,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    -1,    85,    86,    87,
      88,    89,    -1,    91,    92,    93,    -1,    -1,    96,    97,
      98,    99,    -1,   101,   102,   103,    -1,   105,   106,   107,
     108,   109,   110,    -1,    -1,    -1,    -1,   115,   116,   117,
      -1,    -1,   120,   121,   122,    -1,   124,    -1,    -1,    -1,
     128,    -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,
     138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,
      -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,   157,
     158,    -1,   160,   161,   162,   163,   164,   165,   166,    -1,
     168,   169,   170,   171,   172,   173,   174,   175,   176,    -1,
     178,   179,   180,   181,    -1,   183,    -1,    -1,    -1,   187,
     188,   189,   190,    -1,   192,    -1,   194,   195,   196,   197,
      -1,   199,    -1,   201,    -1,   203,    -1,   205,   206,    -1,
     208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,   217,
     218,   219,   220,    -1,   222,   223,   224,    -1,    -1,   227,
      -1,    -1,    -1,   231,   232,   233,   234,    -1,    -1,   237,
      -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,
      -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,
     258,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,
      -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,    -1,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,    -1,    -1,   317,
     318,   319,   320,   321,   322,    -1,    -1,   325,   326,   327,
     328,    -1,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,   342,   343,   344,    -1,    -1,   347,
     348,   349,   350,   351,   352,   353,   354,   355,    -1,   357,
     358,   359,    -1,   361,    -1,   363,   364,    -1,   366,    -1,
     368,   369,    -1,   371,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   381,   382,   383,   384,   385,   386,    -1,
     388,   389,   390,   391,   392,   393,   394,   395,   396,   397,
     398,    -1,   400,   401,   402,    -1,   404,    -1,   406,   407,
     408,   409,   410,    -1,   412,   413,   414,    -1,    -1,   417,
      -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,
     428,   429,   430,   431,   432,    -1,   434,   435,    -1,   437,
     438,   439,   440,   441,   442,    -1,   444,    -1,   446,   447,
      -1,   449,   450,   451,    -1,   453,    -1,   455,   456,   457,
     458,   459,   460,   461,   462,   463,   464,   465,   466,    -1,
     468,   469,    -1,    -1,    -1,   473,   474,   475,   476,    -1,
      -1,    -1,   480,    -1,    -1,    -1,   484,    -1,   486,   487,
     488,   489,    -1,   491,   492,   493,   494,   495,    -1,    -1,
      -1,    -1,    -1,   501,   502,   503,    -1,   505,   506,    -1,
     508,    -1,    -1,   511,    -1,    -1,   514,   515,   516,   517,
     518,   519,   520,   521,   522,   523,    -1,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,    -1,    -1,   542,   543,   544,   545,    -1,   547,
     548,   549,    -1,   551,   552,   553,   554,    -1,    -1,    -1,
      -1,    -1,   560,   561,    -1,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   572,   573,   574,    -1,   576,   577,
      -1,    -1,   580,    -1,    -1,   583,    -1,   585,    -1,   587,
     588,    -1,    -1,   591,   592,   593,   594,   595,    -1,    -1,
     598,   599,    -1,   601,   602,   603,   604,   605,   606,    -1,
      -1,    -1,    -1,    -1,    -1,   613,   614,    -1,   616,   617,
     618,    -1,    -1,   621,    -1,    -1,    -1,   625,   626,    -1,
      -1,    -1,    -1,   631,   632,    -1,    -1,   635,   636,    -1,
      -1,   639,   640,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    33,    34,    35,    36,    37,    38,    39,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    55,    -1,    57,    58,    59,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    -1,    85,    86,    87,    88,    89,    -1,    91,
      92,    93,    -1,    -1,    96,    97,    98,    99,    -1,   101,
     102,   103,    -1,   105,   106,   107,   108,   109,   110,    -1,
      -1,    -1,    -1,   115,   116,   117,    -1,    -1,   120,   121,
     122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,
     132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,
     142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,
     152,   153,   154,    -1,    -1,   157,   158,    -1,   160,   161,
     162,   163,   164,   165,   166,    -1,   168,   169,   170,   171,
     172,   173,   174,   175,   176,    -1,   178,   179,   180,   181,
      -1,   183,    -1,    -1,    -1,   187,   188,   189,   190,    -1,
     192,    -1,   194,   195,   196,   197,    -1,   199,    -1,   201,
      -1,   203,    -1,   205,   206,    -1,   208,   209,    -1,   211,
     212,    -1,    -1,    -1,   216,   217,   218,   219,   220,    -1,
     222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,   231,
     232,   233,   234,    -1,    -1,   237,    -1,    -1,    -1,   241,
     242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,
     252,   253,    -1,    -1,   256,    -1,   258,   259,   260,    -1,
      -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,    -1,    -1,
     282,    -1,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,    -1,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,
     322,    -1,    -1,   325,   326,   327,   328,    -1,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,    -1,
     342,   343,   344,    -1,    -1,   347,   348,   349,   350,   351,
     352,   353,   354,   355,    -1,   357,   358,   359,    -1,   361,
      -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,   371,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   381,
     382,   383,   384,   385,   386,    -1,   388,   389,   390,   391,
     392,   393,   394,   395,   396,   397,   398,    -1,   400,   401,
     402,    -1,   404,    -1,   406,   407,   408,   409,   410,    -1,
     412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,   421,
     422,   423,   424,   425,    -1,    -1,   428,   429,   430,   431,
     432,    -1,   434,   435,    -1,   437,   438,   439,   440,   441,
     442,    -1,   444,    -1,   446,   447,    -1,   449,   450,   451,
      -1,   453,    -1,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   466,    -1,   468,   469,    -1,    -1,
      -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,    -1,
      -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,   491,
     492,   493,   494,   495,    -1,    -1,    -1,    -1,    -1,   501,
     502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,   511,
      -1,    -1,   514,   515,   516,   517,   518,   519,   520,   521,
     522,   523,    -1,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,    -1,    -1,
     542,   543,   544,   545,    -1,   547,   548,   549,    -1,   551,
     552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,   561,
      -1,   563,   564,   565,   566,   567,   568,   569,   570,   571,
     572,   573,   574,    -1,   576,   577,    -1,    -1,   580,    -1,
      -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,   591,
     592,   593,   594,   595,    -1,    -1,   598,   599,    -1,   601,
     602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,    -1,
      -1,   613,   614,    -1,   616,   617,   618,    -1,    -1,   621,
      -1,    -1,    -1,   625,   626,    -1,    -1,    -1,    -1,   631,
     632,    -1,    -1,   635,   636,    -1,    -1,   639,   640,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    33,    34,    35,
      36,    37,    38,    39,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    55,
      -1,    57,    58,    59,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    91,    92,    93,    -1,    -1,
      96,    97,    98,    99,    -1,   101,   102,   103,    -1,   105,
     106,   107,   108,   109,   110,    -1,    -1,    -1,    -1,   115,
     116,   117,    -1,    -1,   120,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
     166,    -1,   168,   169,   170,   171,   172,   173,   174,   175,
     176,    -1,   178,   179,   180,   181,    -1,   183,    -1,    -1,
      -1,   187,   188,   189,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,   203,    -1,   205,
     206,    -1,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,   220,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,   231,   232,   233,   234,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,   258,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,   327,   328,    -1,   330,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,   342,   343,   344,    -1,
      -1,   347,   348,   349,   350,   351,   352,   353,   354,   355,
      -1,   357,   358,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,   382,   383,   384,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,   398,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,   440,   441,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,   453,    -1,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,
     476,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
     486,   487,   488,   489,    -1,   491,   492,   493,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,
     516,   517,   518,   519,   520,   521,   522,   523,    -1,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,   547,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,   563,   564,   565,
     566,   567,   568,   569,   570,   571,   572,   573,   574,    -1,
     576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,
      -1,   587,   588,    -1,    -1,   591,   592,   593,   594,   595,
      -1,    -1,   598,   599,    -1,   601,   602,   603,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,
     616,   617,   618,    -1,    -1,   621,    -1,    -1,    -1,   625,
     626,    -1,    -1,    -1,    -1,   631,   632,    -1,    -1,   635,
     636,    -1,    -1,   639,   640,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    33,    34,    35,    36,    37,    38,    39,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    55,    -1,    57,    58,    59,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    -1,    85,    86,    87,    88,    89,
      -1,    91,    92,    93,    -1,    -1,    96,    97,    98,    99,
      -1,   101,   102,   103,    -1,   105,   106,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,   115,   116,   117,    -1,    -1,
     120,   121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,
     130,   131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,
     160,   161,   162,   163,   164,   165,   166,    -1,   168,   169,
     170,   171,   172,   173,   174,   175,   176,    -1,   178,   179,
     180,   181,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,
     190,    -1,   192,    -1,   194,   195,   196,   197,    -1,   199,
      -1,   201,    -1,   203,    -1,   205,   206,    -1,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,   219,
     220,    -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,
      -1,   231,   232,   233,   234,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,
      -1,    -1,   252,   253,    -1,    -1,   256,    -1,   258,   259,
     260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,
      -1,   271,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
      -1,    -1,   282,    -1,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,    -1,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,
     320,   321,   322,    -1,    -1,   325,   326,   327,   328,    -1,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,   342,   343,   344,    -1,    -1,   347,   348,   349,
     350,   351,   352,   353,   354,   355,    -1,   357,   358,   359,
      -1,   361,    -1,   363,   364,    -1,   366,    -1,   368,   369,
      -1,   371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   381,   382,   383,   384,   385,   386,    -1,   388,   389,
     390,   391,   392,   393,   394,   395,   396,   397,   398,    -1,
     400,   401,   402,    -1,   404,    -1,   406,   407,   408,   409,
     410,    -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,
      -1,   421,   422,   423,   424,   425,    -1,    -1,   428,   429,
     430,   431,   432,    -1,   434,   435,    -1,   437,   438,   439,
     440,   441,   442,    -1,   444,    -1,   446,   447,    -1,   449,
     450,   451,    -1,   453,    -1,   455,   456,   457,   458,   459,
     460,   461,   462,   463,   464,   465,   466,    -1,   468,   469,
      -1,    -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,
     480,    -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,
      -1,   491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,
      -1,   501,   502,   503,    -1,   505,   506,    -1,   508,    -1,
      -1,   511,    -1,    -1,   514,   515,   516,   517,   518,   519,
     520,   521,   522,   523,    -1,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
      -1,    -1,   542,   543,   544,   545,    -1,   547,   548,   549,
      -1,   551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,
     560,   561,    -1,   563,   564,   565,   566,   567,   568,   569,
     570,   571,   572,   573,   574,    -1,   576,   577,    -1,    -1,
     580,    -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,
      -1,   591,   592,   593,   594,   595,    -1,    -1,   598,   599,
      -1,   601,   602,   603,   604,   605,   606,    -1,    -1,    -1,
      -1,    -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,
      -1,   621,    -1,    -1,    -1,   625,   626,    -1,    -1,    -1,
      -1,   631,   632,    -1,    -1,   635,   636,    -1,    -1,   639,
     640,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      -1,    85,    86,    87,    88,    89,    -1,    91,    92,    93,
      -1,    -1,    96,    97,    98,    99,    -1,   101,   102,   103,
      -1,   105,   106,   107,   108,   109,   110,    -1,    -1,    -1,
      -1,   115,   116,   117,    -1,    -1,   120,   121,   122,    -1,
     124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,
     134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,
      -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,
     154,    -1,    -1,   157,   158,    -1,   160,   161,   162,   163,
     164,   165,   166,    -1,   168,   169,   170,   171,   172,   173,
     174,   175,   176,    -1,   178,   179,   180,   181,    -1,   183,
      -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,
     194,   195,   196,   197,    -1,   199,    -1,   201,    -1,   203,
      -1,   205,   206,    -1,   208,   209,    -1,   211,   212,    -1,
      -1,    -1,   216,   217,   218,   219,   220,    -1,   222,   223,
     224,    -1,    -1,   227,    -1,    -1,    -1,   231,   232,   233,
     234,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,
     244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,
      -1,    -1,   256,    -1,   258,   259,   260,    -1,    -1,    -1,
      -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,    -1,    -1,   282,    -1,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,    -1,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,    -1,    -1,   317,   318,   319,   320,   321,   322,    -1,
      -1,   325,   326,   327,   328,    -1,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,   342,   343,
     344,    -1,    -1,   347,   348,   349,   350,   351,   352,   353,
     354,   355,    -1,   357,   358,   359,    -1,   361,    -1,   363,
     364,    -1,   366,    -1,   368,   369,    -1,   371,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   381,   382,   383,
     384,   385,   386,    -1,   388,   389,   390,   391,   392,   393,
     394,   395,   396,   397,   398,    -1,   400,   401,   402,    -1,
     404,    -1,   406,   407,   408,   409,   410,    -1,   412,   413,
     414,    -1,    -1,   417,    -1,    -1,    -1,   421,   422,   423,
     424,   425,    -1,    -1,   428,   429,   430,   431,   432,    -1,
     434,   435,    -1,   437,   438,   439,   440,   441,   442,    -1,
     444,    -1,   446,   447,    -1,   449,   450,   451,    -1,   453,
      -1,   455,   456,   457,   458,   459,   460,   461,   462,   463,
     464,   465,   466,    -1,   468,   469,    -1,    -1,    -1,   473,
     474,   475,   476,    -1,    -1,    -1,   480,    -1,    -1,    -1,
     484,    -1,   486,   487,   488,   489,    -1,   491,   492,   493,
     494,   495,    -1,    -1,    -1,    -1,    -1,   501,   502,   503,
      -1,   505,   506,    -1,   508,    -1,    -1,   511,    -1,    -1,
     514,   515,   516,   517,   518,   519,   520,   521,   522,   523,
      -1,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,    -1,    -1,   542,   543,
     544,   545,    -1,   547,   548,   549,    -1,   551,   552,   553,
     554,    -1,    -1,    -1,    -1,    -1,   560,   561,    -1,   563,
     564,   565,   566,   567,   568,   569,   570,   571,   572,   573,
     574,    -1,   576,   577,    -1,    -1,   580,    -1,    -1,   583,
      -1,   585,    -1,   587,   588,    -1,    -1,   591,   592,   593,
     594,   595,    -1,    -1,   598,   599,    -1,   601,   602,   603,
     604,   605,   606,    -1,    -1,    -1,    -1,    -1,    -1,   613,
     614,    -1,   616,   617,   618,    -1,    -1,   621,    -1,    -1,
      -1,   625,   626,    -1,    -1,    -1,    -1,   631,   632,    -1,
      -1,   635,   636,    -1,    -1,   639,   640,     5,    -1,     7,
       8,     9,    10,    11,    12,    -1,    14,    -1,    -1,    -1,
      18,    -1,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    55,    -1,    57,
      58,    59,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    -1,    85,    86,    87,
      88,    89,    -1,    91,    92,    93,    -1,    -1,    96,    97,
      98,    99,    -1,   101,   102,   103,    -1,   105,   106,   107,
     108,   109,   110,    -1,    -1,    -1,    -1,   115,   116,   117,
      -1,    -1,   120,   121,   122,    -1,   124,    -1,    -1,    -1,
     128,    -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,
     138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,
      -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,   157,
     158,    -1,   160,   161,   162,   163,   164,   165,   166,    -1,
     168,   169,   170,   171,   172,   173,   174,   175,   176,    -1,
     178,   179,   180,   181,    -1,   183,    -1,    -1,    -1,   187,
     188,    -1,   190,    -1,   192,    -1,   194,   195,   196,   197,
      -1,   199,    -1,   201,    -1,   203,    -1,   205,   206,    -1,
     208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,   217,
     218,   219,   220,    -1,   222,   223,   224,    -1,    -1,   227,
      -1,    -1,    -1,   231,   232,   233,   234,    -1,    -1,   237,
      -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,
      -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,
     258,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,
      -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,    -1,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,    -1,    -1,   317,
     318,   319,   320,   321,   322,    -1,    -1,   325,   326,   327,
     328,    -1,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,   342,   343,   344,    -1,    -1,   347,
     348,   349,   350,   351,    -1,   353,   354,   355,    -1,   357,
     358,   359,    -1,   361,    -1,   363,   364,    -1,   366,    -1,
     368,   369,    -1,   371,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   381,   382,   383,   384,   385,   386,    -1,
     388,   389,   390,   391,   392,   393,   394,   395,   396,   397,
     398,    -1,   400,   401,   402,    -1,   404,    -1,   406,   407,
     408,   409,   410,    -1,   412,   413,   414,    -1,    -1,   417,
      -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,
     428,   429,   430,   431,   432,    -1,   434,   435,    -1,   437,
     438,   439,   440,   441,   442,    -1,   444,    -1,   446,   447,
      -1,   449,   450,   451,    -1,   453,    -1,   455,   456,   457,
     458,   459,   460,   461,   462,   463,   464,   465,   466,    -1,
     468,   469,    -1,    -1,    -1,   473,   474,   475,   476,    -1,
      -1,    -1,   480,    -1,    -1,    -1,   484,    -1,   486,   487,
     488,   489,    -1,   491,   492,   493,   494,   495,    -1,    -1,
      -1,    -1,    -1,   501,   502,   503,    -1,   505,   506,    -1,
     508,    -1,    -1,   511,    -1,    -1,   514,   515,   516,   517,
     518,   519,   520,   521,   522,   523,    -1,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,    -1,    -1,   542,   543,   544,   545,    -1,   547,
     548,   549,    -1,   551,   552,   553,   554,    -1,    -1,    -1,
      -1,    -1,   560,   561,    -1,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   572,   573,   574,    -1,   576,   577,
      -1,    -1,   580,    -1,    -1,   583,    -1,   585,    -1,   587,
     588,    -1,    -1,   591,   592,   593,   594,   595,    -1,    -1,
     598,   599,    -1,   601,   602,   603,   604,   605,   606,    -1,
      -1,    -1,    -1,    -1,    -1,   613,   614,    -1,   616,   617,
     618,    -1,    -1,   621,    -1,    -1,    -1,   625,   626,    -1,
      -1,    -1,    -1,   631,   632,    -1,    -1,   635,   636,    -1,
      -1,   639,   640,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    33,    34,    35,    36,    37,    38,    39,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    55,    -1,    57,    58,    59,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    -1,    85,    86,    87,    88,    89,    -1,    91,
      92,    93,    -1,    -1,    96,    97,    98,    99,    -1,   101,
     102,   103,    -1,   105,   106,   107,   108,   109,   110,    -1,
      -1,    -1,    -1,   115,   116,   117,    -1,    -1,   120,   121,
     122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,
     132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,
     142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,
     152,   153,   154,    -1,    -1,   157,   158,    -1,   160,   161,
     162,   163,   164,   165,   166,    -1,   168,   169,   170,   171,
     172,   173,   174,   175,   176,    -1,   178,   179,   180,   181,
      -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,
     192,    -1,   194,   195,   196,   197,    -1,   199,    -1,   201,
      -1,   203,    -1,   205,   206,    -1,   208,   209,    -1,   211,
     212,    -1,    -1,    -1,   216,   217,   218,   219,   220,    -1,
     222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,   231,
     232,   233,   234,    -1,    -1,   237,    -1,    -1,    -1,   241,
     242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,
     252,   253,    -1,    -1,   256,    -1,   258,   259,   260,    -1,
      -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,    -1,    -1,
     282,    -1,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,    -1,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,
     322,    -1,    -1,   325,   326,   327,   328,    -1,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,    -1,
     342,   343,   344,    -1,    -1,   347,   348,   349,   350,   351,
     352,   353,   354,   355,    -1,   357,   358,   359,    -1,   361,
      -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,   371,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   381,
     382,   383,   384,   385,   386,    -1,   388,   389,   390,   391,
     392,   393,   394,   395,   396,   397,   398,    -1,   400,   401,
     402,    -1,   404,    -1,   406,   407,   408,   409,   410,    -1,
     412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,   421,
     422,   423,   424,   425,    -1,    -1,   428,   429,   430,   431,
     432,    -1,   434,   435,    -1,   437,   438,   439,   440,   441,
     442,    -1,   444,    -1,   446,   447,    -1,   449,   450,   451,
      -1,   453,    -1,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   466,    -1,   468,   469,    -1,    -1,
      -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,    -1,
      -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,   491,
     492,   493,   494,   495,    -1,    -1,    -1,    -1,    -1,   501,
     502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,   511,
      -1,    -1,   514,   515,   516,   517,   518,   519,   520,   521,
     522,   523,    -1,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,    -1,    -1,
     542,   543,   544,   545,    -1,   547,   548,   549,    -1,   551,
     552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,   561,
      -1,   563,   564,   565,   566,   567,   568,   569,   570,   571,
     572,   573,   574,    -1,   576,   577,    -1,    -1,   580,    -1,
      -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,   591,
     592,   593,   594,   595,    -1,    -1,   598,   599,    -1,   601,
     602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,    -1,
      -1,   613,   614,    -1,   616,   617,   618,    -1,    -1,   621,
      -1,    -1,    -1,   625,   626,    -1,    -1,    -1,    -1,   631,
     632,    -1,    -1,   635,   636,    -1,    -1,   639,   640,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    33,    34,    35,
      36,    37,    38,    39,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    55,
      -1,    57,    58,    59,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    91,    92,    93,    -1,    -1,
      96,    97,    98,    99,    -1,   101,   102,   103,    -1,   105,
     106,   107,   108,   109,   110,    -1,    -1,    -1,    -1,   115,
     116,   117,    -1,    -1,   120,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
     166,    -1,   168,   169,   170,   171,   172,   173,   174,   175,
     176,    -1,   178,   179,   180,   181,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,   203,    -1,   205,
     206,    -1,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,   220,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,   231,   232,   233,   234,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,   258,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,   327,   328,    -1,   330,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,   342,   343,   344,    -1,
      -1,   347,   348,   349,   350,   351,   352,   353,   354,   355,
      -1,   357,   358,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,   382,   383,   384,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,   398,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,   440,   441,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,   453,    -1,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,
     476,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
     486,   487,   488,   489,    -1,   491,   492,   493,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,
     516,   517,   518,   519,   520,   521,   522,   523,    -1,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,   547,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,   563,   564,   565,
     566,   567,   568,   569,   570,   571,   572,   573,   574,    -1,
     576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,
      -1,   587,   588,    -1,    -1,   591,   592,   593,   594,   595,
      -1,    -1,   598,   599,    -1,   601,   602,   603,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,
     616,   617,   618,    -1,    -1,   621,    -1,    -1,    -1,   625,
     626,    -1,    -1,    -1,    -1,   631,   632,    -1,    -1,   635,
     636,    -1,    -1,   639,   640,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    33,    34,    35,    36,    37,    38,    39,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    55,    -1,    57,    58,    59,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    -1,    85,    86,    87,    88,    89,
      -1,    91,    92,    93,    -1,    -1,    96,    97,    98,    99,
      -1,   101,   102,   103,    -1,   105,   106,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,   115,   116,   117,    -1,    -1,
     120,   121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,
     130,   131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,
     160,   161,   162,   163,   164,   165,   166,    -1,   168,   169,
     170,   171,   172,   173,   174,   175,   176,    -1,   178,   179,
     180,   181,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,
     190,    -1,   192,    -1,   194,   195,   196,   197,    -1,   199,
      -1,   201,    -1,   203,    -1,   205,   206,    -1,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,   219,
     220,    -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,
      -1,   231,   232,   233,   234,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,
      -1,    -1,   252,   253,    -1,    -1,   256,    -1,   258,   259,
     260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,
      -1,   271,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
      -1,    -1,   282,    -1,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,    -1,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,
     320,   321,   322,    -1,    -1,   325,   326,   327,   328,    -1,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,   342,   343,   344,    -1,    -1,   347,   348,   349,
     350,   351,   352,   353,   354,   355,    -1,   357,   358,   359,
      -1,   361,    -1,   363,   364,    -1,   366,    -1,   368,   369,
      -1,   371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   381,   382,   383,   384,   385,   386,    -1,   388,   389,
     390,   391,   392,   393,   394,   395,   396,   397,   398,    -1,
     400,   401,   402,    -1,   404,    -1,   406,   407,   408,   409,
     410,    -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,
      -1,   421,   422,   423,   424,   425,    -1,    -1,   428,   429,
     430,   431,   432,    -1,   434,   435,    -1,   437,   438,   439,
     440,   441,   442,    -1,   444,    -1,   446,   447,    -1,   449,
     450,   451,    -1,   453,    -1,   455,   456,   457,   458,   459,
     460,   461,   462,   463,   464,   465,   466,    -1,   468,   469,
      -1,    -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,
     480,    -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,
      -1,   491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,
      -1,   501,   502,   503,    -1,   505,   506,    -1,   508,    -1,
      -1,   511,    -1,    -1,   514,   515,   516,   517,   518,   519,
     520,   521,   522,   523,    -1,   525,   526,   527,   528,   529,
     530,   531,   532,   533,   534,   535,   536,   537,   538,   539,
      -1,    -1,   542,   543,   544,   545,    -1,   547,   548,   549,
      -1,   551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,
     560,   561,    -1,   563,   564,   565,   566,   567,   568,   569,
     570,   571,   572,   573,   574,    -1,   576,   577,    -1,    -1,
     580,    -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,
      -1,   591,   592,   593,   594,   595,    -1,    -1,   598,   599,
      -1,   601,   602,   603,   604,   605,   606,    -1,    -1,    -1,
      -1,    -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,
      -1,   621,    -1,    -1,    -1,   625,   626,    -1,    -1,    -1,
      -1,   631,   632,    -1,    -1,   635,   636,    -1,    -1,   639,
     640,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      -1,    85,    86,    87,    88,    89,    -1,    91,    92,    93,
      -1,    -1,    96,    97,    98,    99,    -1,   101,   102,   103,
      -1,   105,   106,   107,   108,   109,   110,    -1,    -1,    -1,
      -1,   115,   116,   117,    -1,    -1,   120,   121,   122,    -1,
     124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,
     134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,
      -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,
     154,    -1,    -1,   157,   158,    -1,   160,   161,   162,   163,
     164,   165,   166,    -1,   168,   169,   170,   171,   172,   173,
     174,   175,   176,    -1,   178,   179,   180,   181,    -1,   183,
      -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,
     194,   195,   196,   197,    -1,   199,    -1,   201,    -1,   203,
      -1,   205,   206,    -1,   208,   209,    -1,   211,   212,    -1,
      -1,    -1,   216,   217,   218,   219,   220,    -1,   222,   223,
     224,    -1,    -1,   227,    -1,    -1,    -1,   231,   232,   233,
     234,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,
     244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,
      -1,    -1,   256,    -1,   258,   259,   260,    -1,    -1,    -1,
      -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,
     274,    -1,    -1,   277,    -1,    -1,    -1,    -1,   282,    -1,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,    -1,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
      -1,    -1,    -1,   317,   318,   319,   320,   321,   322,    -1,
      -1,   325,   326,   327,   328,    -1,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,   342,   343,
     344,    -1,    -1,   347,   348,   349,   350,   351,    -1,   353,
     354,   355,    -1,   357,   358,   359,    -1,   361,    -1,   363,
     364,    -1,   366,    -1,   368,   369,    -1,   371,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   381,   382,   383,
     384,   385,   386,    -1,   388,   389,   390,   391,   392,   393,
     394,   395,   396,   397,   398,    -1,   400,   401,   402,    -1,
     404,    -1,   406,   407,   408,   409,   410,    -1,   412,   413,
     414,    -1,    -1,   417,    -1,    -1,    -1,   421,   422,   423,
     424,   425,    -1,    -1,   428,   429,   430,   431,   432,    -1,
     434,   435,    -1,   437,   438,   439,   440,   441,   442,    -1,
     444,    -1,   446,   447,    -1,   449,   450,   451,    -1,   453,
      -1,   455,   456,   457,   458,   459,   460,   461,   462,   463,
     464,   465,   466,    -1,   468,   469,    -1,    -1,    -1,   473,
     474,   475,   476,    -1,    -1,    -1,   480,    -1,    -1,    -1,
     484,    -1,   486,   487,   488,   489,    -1,   491,   492,   493,
     494,   495,    -1,    -1,    -1,    -1,    -1,   501,   502,   503,
      -1,   505,   506,    -1,   508,    -1,    -1,   511,    -1,    -1,
     514,   515,   516,   517,   518,   519,   520,   521,   522,   523,
      -1,   525,   526,   527,   528,   529,   530,   531,   532,   533,
     534,   535,   536,   537,   538,   539,    -1,    -1,   542,   543,
     544,   545,    -1,   547,   548,   549,    -1,   551,   552,   553,
     554,    -1,    -1,    -1,    -1,    -1,   560,   561,    -1,   563,
     564,   565,   566,   567,   568,   569,   570,   571,   572,   573,
     574,    -1,   576,   577,    -1,    -1,   580,    -1,    -1,   583,
      -1,   585,    -1,   587,   588,    -1,    -1,   591,   592,   593,
     594,   595,    -1,    -1,   598,   599,    -1,   601,   602,   603,
     604,   605,   606,    -1,    -1,    -1,    -1,    -1,    -1,   613,
     614,    -1,   616,   617,   618,    -1,    -1,   621,    -1,    -1,
      -1,   625,   626,    -1,    -1,    -1,    -1,   631,   632,    -1,
      -1,   635,   636,    -1,    -1,   639,   640,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,
      18,    -1,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    55,    -1,    57,
      58,    59,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    -1,    85,    86,    87,
      88,    89,    -1,    91,    92,    93,    -1,    -1,    96,    97,
      98,    99,    -1,   101,   102,   103,    -1,   105,   106,   107,
     108,   109,   110,    -1,    -1,    -1,    -1,   115,   116,   117,
      -1,    -1,   120,   121,   122,    -1,   124,    -1,    -1,    -1,
     128,    -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,
     138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,
      -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,   157,
     158,    -1,   160,   161,   162,   163,   164,   165,   166,    -1,
     168,   169,   170,   171,   172,   173,   174,   175,   176,    -1,
     178,   179,   180,   181,    -1,   183,    -1,    -1,    -1,   187,
     188,    -1,   190,    -1,   192,    -1,   194,   195,   196,   197,
      -1,   199,    -1,   201,    -1,   203,    -1,   205,   206,    -1,
     208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,   217,
     218,   219,   220,    -1,   222,   223,   224,    -1,    -1,   227,
      -1,    -1,    -1,   231,   232,   233,   234,    -1,    -1,   237,
      -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,
      -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,
     258,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,
      -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,   277,
      -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,    -1,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,    -1,    -1,   317,
     318,   319,   320,   321,   322,    -1,    -1,   325,   326,   327,
     328,    -1,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,   342,   343,   344,    -1,    -1,   347,
     348,   349,   350,   351,    -1,   353,   354,   355,    -1,   357,
     358,   359,    -1,   361,    -1,   363,   364,    -1,   366,    -1,
     368,   369,    -1,   371,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   381,   382,   383,   384,   385,   386,    -1,
     388,   389,   390,   391,   392,   393,   394,   395,   396,   397,
     398,    -1,   400,   401,   402,    -1,   404,    -1,   406,   407,
     408,   409,   410,    -1,   412,   413,   414,    -1,    -1,   417,
      -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,
     428,   429,   430,   431,   432,    -1,   434,   435,    -1,   437,
     438,   439,   440,   441,   442,    -1,   444,    -1,   446,   447,
      -1,   449,   450,   451,    -1,   453,    -1,   455,   456,   457,
     458,   459,   460,   461,   462,   463,   464,   465,   466,    -1,
     468,   469,    -1,    -1,    -1,   473,   474,   475,   476,    -1,
      -1,    -1,   480,    -1,    -1,    -1,   484,    -1,   486,   487,
     488,   489,    -1,   491,   492,   493,   494,   495,    -1,    -1,
      -1,    -1,    -1,   501,   502,   503,    -1,   505,   506,    -1,
     508,    -1,    -1,   511,    -1,    -1,   514,   515,   516,   517,
     518,   519,   520,   521,   522,   523,    -1,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,    -1,    -1,   542,   543,   544,   545,    -1,   547,
     548,   549,    -1,   551,   552,   553,   554,    -1,    -1,    -1,
      -1,    -1,   560,   561,    -1,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   572,   573,   574,    -1,   576,   577,
      -1,    -1,   580,    -1,    -1,   583,    -1,   585,    -1,   587,
     588,    -1,    -1,   591,   592,   593,   594,   595,    -1,    -1,
     598,   599,    -1,   601,   602,   603,   604,   605,   606,    -1,
      -1,    -1,    -1,    -1,    -1,   613,   614,    -1,   616,   617,
     618,    -1,    -1,   621,    -1,    -1,    -1,   625,   626,    -1,
      -1,    -1,    -1,   631,   632,    -1,    -1,   635,   636,    -1,
      -1,   639,   640,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    33,    34,    35,    36,    37,    38,    39,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    55,    -1,    57,    58,    59,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    -1,    85,    86,    87,    88,    89,    -1,    91,
      92,    93,    -1,    -1,    96,    97,    98,    99,    -1,   101,
     102,   103,    -1,   105,   106,   107,   108,   109,   110,    -1,
      -1,    -1,    -1,   115,   116,   117,    -1,    -1,   120,   121,
     122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,
     132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,
     142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,
     152,   153,   154,    -1,    -1,   157,   158,    -1,   160,   161,
     162,   163,   164,   165,   166,    -1,   168,   169,   170,   171,
     172,   173,   174,   175,   176,    -1,   178,   179,   180,   181,
      -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,
     192,    -1,   194,   195,   196,   197,    -1,   199,    -1,   201,
      -1,   203,    -1,   205,   206,    -1,   208,   209,    -1,   211,
     212,    -1,    -1,    -1,   216,   217,   218,   219,   220,    -1,
     222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,   231,
     232,   233,   234,    -1,    -1,   237,    -1,    -1,    -1,   241,
     242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,
     252,   253,    -1,    -1,   256,    -1,   258,   259,   260,    -1,
      -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,
      -1,   273,   274,    -1,    -1,   277,    -1,    -1,    -1,    -1,
     282,    -1,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,    -1,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,
     322,    -1,    -1,   325,   326,   327,   328,    -1,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,    -1,
     342,   343,   344,    -1,    -1,   347,   348,   349,   350,   351,
      -1,   353,   354,   355,    -1,   357,   358,   359,    -1,   361,
      -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,   371,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   381,
     382,   383,   384,   385,   386,    -1,   388,   389,   390,   391,
     392,   393,   394,   395,   396,   397,   398,    -1,   400,   401,
     402,    -1,   404,    -1,   406,   407,   408,   409,   410,    -1,
     412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,   421,
     422,   423,   424,   425,    -1,    -1,   428,   429,   430,   431,
     432,    -1,   434,   435,    -1,   437,   438,   439,   440,   441,
     442,    -1,   444,    -1,   446,   447,    -1,   449,   450,   451,
      -1,   453,    -1,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   466,    -1,   468,   469,    -1,    -1,
      -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,    -1,
      -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,   491,
     492,   493,   494,   495,    -1,    -1,    -1,    -1,    -1,   501,
     502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,   511,
      -1,    -1,   514,   515,   516,   517,   518,   519,   520,   521,
     522,   523,    -1,   525,   526,   527,   528,   529,   530,   531,
     532,   533,   534,   535,   536,   537,   538,   539,    -1,    -1,
     542,   543,   544,   545,    -1,   547,   548,   549,    -1,   551,
     552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,   561,
      -1,   563,   564,   565,   566,   567,   568,   569,   570,   571,
     572,   573,   574,    -1,   576,   577,    -1,    -1,   580,    -1,
      -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,   591,
     592,   593,   594,   595,    -1,    -1,   598,   599,    -1,   601,
     602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,    -1,
      -1,   613,   614,    -1,   616,   617,   618,    -1,    -1,   621,
      -1,    -1,    -1,   625,   626,    -1,    -1,    -1,    -1,   631,
     632,    -1,    -1,   635,   636,    -1,    -1,   639,   640,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    33,    34,    35,
      36,    37,    38,    39,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    55,
      -1,    57,    58,    59,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    91,    92,    93,    -1,    -1,
      96,    97,    98,    99,    -1,   101,   102,   103,    -1,   105,
     106,   107,   108,   109,   110,    -1,    -1,    -1,    -1,   115,
     116,   117,    -1,    -1,   120,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
     166,    -1,   168,   169,   170,   171,   172,   173,   174,   175,
     176,    -1,   178,   179,   180,   181,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,   203,    -1,   205,
     206,    -1,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,   220,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,   231,   232,   233,   234,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,   258,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,   327,   328,    -1,   330,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,   342,   343,   344,    -1,
      -1,   347,   348,   349,   350,   351,    -1,   353,   354,   355,
      -1,   357,   358,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,   382,   383,   384,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,   398,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,   440,   441,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,   453,    -1,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,
     476,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
     486,   487,   488,   489,    -1,   491,   492,   493,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,
     516,   517,   518,   519,   520,   521,   522,   523,    -1,   525,
     526,   527,   528,   529,   530,   531,   532,   533,   534,   535,
     536,   537,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,   547,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,   563,   564,   565,
     566,   567,   568,   569,   570,   571,   572,   573,   574,    -1,
     576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,
      -1,   587,   588,    -1,    -1,   591,   592,   593,   594,   595,
      -1,    -1,   598,   599,    -1,   601,   602,   603,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,
     616,   617,   618,    -1,    -1,   621,    -1,    -1,    -1,   625,
     626,    -1,    -1,    -1,    -1,   631,   632,    -1,    -1,   635,
     636,    -1,    -1,   639,   640,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    35,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    -1,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,
      -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,    -1,    -1,    -1,    -1,   115,   116,   117,    -1,    -1,
      -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,
     130,   131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,
     160,   161,   162,   163,   164,   165,    -1,    -1,   168,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,   179,
     180,   181,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,
     190,    -1,   192,    -1,   194,   195,   196,   197,    -1,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,   219,
      -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,
      -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,
      -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,
     260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,
      -1,   271,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
      -1,    -1,   282,    -1,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,    -1,   302,   303,   304,    -1,   306,   307,   308,   309,
      -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,
     320,   321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,   342,   343,   344,    -1,    -1,   347,   348,   349,
     350,    -1,    -1,    -1,   354,   355,    -1,   357,   358,   359,
      -1,   361,    -1,   363,   364,    -1,   366,    -1,   368,   369,
      -1,   371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   381,   382,   383,    -1,   385,   386,    -1,   388,   389,
     390,   391,   392,   393,   394,   395,   396,   397,    -1,    -1,
     400,   401,   402,    -1,   404,    -1,   406,   407,   408,   409,
     410,    -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,
      -1,   421,   422,   423,   424,   425,    -1,    -1,   428,   429,
     430,   431,   432,    -1,   434,   435,    -1,   437,   438,   439,
      -1,    -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,
     450,   451,    -1,   453,    -1,    -1,   456,   457,   458,   459,
     460,   461,   462,   463,   464,   465,   466,    -1,   468,   469,
      -1,    -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,
     480,    -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,
      -1,   491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,
      -1,   501,   502,   503,    -1,   505,   506,    -1,   508,    -1,
      -1,   511,    -1,    -1,   514,   515,   516,   517,   518,   519,
      -1,    -1,   522,   523,    -1,   525,   526,   527,   528,   529,
     530,    -1,    -1,   533,   534,   535,   536,    -1,   538,   539,
      -1,    -1,   542,   543,   544,   545,    -1,   547,   548,   549,
      -1,   551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,
     560,   561,    -1,    -1,   564,   565,   566,   567,   568,   569,
     570,   571,   572,   573,   574,    -1,   576,   577,    -1,    -1,
     580,    -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,
      -1,    -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,
      -1,    -1,   602,   603,   604,   605,   606,    -1,    -1,    -1,
      -1,    -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,
      -1,   621,    -1,    -1,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,   639,
     640,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,
      -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,
      -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,
     130,   131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,
     160,   161,   162,   163,   164,   165,    -1,    -1,   168,   169,
     170,   171,   172,    -1,    -1,   175,   176,    -1,   178,   179,
     180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,
     190,   191,   192,    -1,   194,   195,   196,   197,    -1,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,   219,
      -1,    -1,   222,   223,   224,   225,    -1,   227,    -1,    -1,
      -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,
     250,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,
     260,    -1,   262,    -1,    -1,    -1,   266,   267,    -1,   269,
      -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   282,    -1,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,    -1,   302,   303,   304,    -1,   306,   307,   308,   309,
      -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,
     320,   321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,
     350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,
      -1,   361,    -1,   363,   364,    -1,   366,    -1,   368,   369,
      -1,   371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   381,   382,   383,    -1,   385,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,   396,   397,    -1,    -1,
     400,   401,   402,    -1,   404,    -1,   406,   407,   408,   409,
     410,    -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,
      -1,   421,   422,   423,   424,   425,    -1,    -1,   428,   429,
     430,   431,   432,    -1,   434,   435,    -1,   437,   438,   439,
      -1,    -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,
     450,   451,    -1,   453,    -1,    -1,   456,   457,   458,   459,
     460,   461,   462,   463,   464,   465,   466,    -1,   468,   469,
     470,    -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,
     480,    -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,
      -1,   491,   492,   493,   494,   495,   496,    -1,    -1,    -1,
      -1,   501,   502,   503,    -1,   505,   506,    -1,   508,    -1,
      -1,   511,    -1,    -1,   514,   515,   516,   517,   518,   519,
      -1,    -1,   522,   523,    -1,   525,   526,   527,   528,   529,
     530,    -1,    -1,   533,   534,   535,   536,    -1,   538,   539,
      -1,    -1,   542,   543,   544,   545,    -1,    -1,   548,   549,
      -1,   551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,
     560,   561,    -1,    -1,    -1,   565,   566,   567,   568,    -1,
     570,   571,    -1,   573,   574,    -1,   576,   577,    -1,    -1,
     580,    -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,
      -1,    -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,
      -1,    -1,   602,   603,   604,   605,   606,    -1,    -1,    -1,
      -1,    -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,
      -1,   621,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,
     640,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    -1,
      -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,
      -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,   121,
     122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,
     132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,
     142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,
     152,   153,   154,    -1,    -1,   157,   158,    -1,   160,   161,
     162,   163,   164,   165,    -1,    -1,   168,   169,   170,   171,
     172,    -1,    -1,   175,   176,    -1,   178,   179,   180,    -1,
      -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,   191,
     192,    -1,   194,   195,   196,   197,    -1,   199,    -1,   201,
      -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,    -1,
     222,   223,   224,   225,    -1,   227,    -1,    -1,    -1,    -1,
     232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,
     242,    -1,   244,   245,    -1,    -1,    -1,   249,   250,    -1,
     252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,    -1,
      -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,
      -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     282,    -1,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,    -1,
     302,   303,   304,    -1,   306,   307,   308,   309,    -1,   311,
     312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,
     322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,
     332,   333,   334,   335,   336,   337,   338,   339,   340,    -1,
      -1,   343,   344,    -1,    -1,   347,   348,   349,   350,    -1,
      -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,   361,
      -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,   371,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   381,
     382,   383,    -1,   385,   386,    -1,   388,   389,   390,   391,
     392,   393,   394,   395,   396,   397,    -1,    -1,   400,   401,
     402,    -1,   404,    -1,   406,   407,   408,   409,   410,    -1,
     412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,   421,
     422,   423,   424,   425,    -1,    -1,   428,   429,   430,   431,
     432,    -1,   434,   435,    -1,   437,   438,   439,    -1,    -1,
     442,    -1,   444,    -1,   446,   447,    -1,   449,   450,   451,
      -1,   453,    -1,    -1,   456,   457,   458,   459,   460,   461,
     462,   463,   464,   465,   466,    -1,   468,   469,    -1,    -1,
      -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,    -1,
      -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,   491,
     492,   493,   494,   495,   496,    -1,    -1,    -1,    -1,   501,
     502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,   511,
      -1,    -1,   514,   515,   516,   517,   518,   519,    -1,    -1,
     522,   523,    -1,   525,   526,   527,   528,   529,   530,    -1,
      -1,   533,   534,   535,   536,    -1,   538,   539,    -1,    -1,
     542,   543,   544,   545,    -1,    -1,   548,   549,    -1,   551,
     552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,   561,
      -1,    -1,    -1,   565,   566,   567,   568,    -1,   570,   571,
      -1,   573,   574,    -1,   576,   577,    -1,    -1,   580,    -1,
      -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,    -1,
      -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,    -1,
     602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,    -1,
      -1,   613,   614,    -1,   616,   617,   618,    -1,    -1,   621,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      14,    -1,    -1,    -1,    18,    -1,    -1,    21,   640,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      -1,    85,    86,    87,    88,    89,    -1,    -1,    -1,    93,
      -1,    -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,
      -1,   115,   116,    -1,    -1,    -1,    -1,   121,   122,    -1,
     124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,
     134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,
      -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,
     154,    -1,    -1,   157,   158,    -1,   160,   161,   162,   163,
     164,   165,    -1,    -1,   168,   169,   170,   171,   172,    -1,
      -1,   175,   176,    -1,   178,   179,   180,    -1,    -1,   183,
      -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,
     194,   195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,
      -1,   205,   206,    -1,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,   223,
     224,    -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   233,
      -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,
     244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,
      -1,    -1,   256,    -1,    -1,   259,   260,    -1,    -1,    -1,
      -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,
     274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,    -1,   302,   303,
     304,    -1,   306,   307,   308,   309,    -1,   311,   312,    -1,
      -1,    -1,    -1,   317,   318,   319,   320,   321,   322,    -1,
      -1,   325,   326,    -1,   328,    -1,   330,    -1,   332,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,    -1,   343,
     344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,
     354,   355,    -1,    -1,    -1,   359,    -1,   361,    -1,   363,
     364,    -1,   366,    -1,   368,   369,    -1,   371,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   381,   382,   383,
      -1,   385,   386,    -1,   388,   389,   390,   391,   392,   393,
     394,   395,   396,   397,    -1,    -1,   400,   401,   402,    -1,
     404,    -1,   406,   407,   408,   409,   410,    -1,   412,   413,
     414,    -1,    -1,   417,    -1,    -1,    -1,   421,   422,   423,
     424,   425,    -1,    -1,   428,   429,   430,   431,   432,    -1,
     434,   435,    -1,   437,   438,   439,    -1,    -1,   442,    -1,
     444,    -1,   446,   447,    -1,   449,   450,   451,    -1,   453,
      -1,    -1,   456,   457,   458,   459,   460,   461,   462,   463,
     464,   465,   466,    -1,   468,   469,   470,    -1,    -1,   473,
     474,   475,   476,    -1,    -1,    -1,   480,    -1,    -1,    -1,
     484,    -1,   486,   487,   488,   489,    -1,   491,   492,   493,
     494,   495,    -1,    -1,    -1,    -1,    -1,   501,   502,   503,
      -1,   505,   506,    -1,   508,    -1,    -1,   511,    -1,    -1,
     514,   515,   516,   517,   518,   519,    -1,    -1,   522,   523,
      -1,   525,   526,   527,   528,   529,   530,    -1,    -1,   533,
     534,   535,   536,    -1,   538,   539,    -1,    -1,   542,   543,
     544,   545,    -1,    -1,   548,   549,    -1,   551,   552,   553,
     554,    -1,    -1,    -1,    -1,    -1,   560,   561,    -1,    -1,
      -1,   565,   566,   567,   568,    -1,   570,   571,    -1,   573,
     574,    -1,   576,   577,    -1,    -1,   580,    -1,    -1,   583,
      -1,   585,    -1,   587,   588,    -1,    -1,    -1,    -1,    -1,
      -1,   595,    -1,    -1,   598,    -1,    -1,    -1,   602,   603,
     604,   605,   606,    -1,    -1,    -1,    -1,    -1,    -1,   613,
     614,    -1,   616,   617,   618,    -1,    -1,   621,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    14,   633,
      -1,    -1,    18,    -1,    -1,    21,   640,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,
     476,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
     486,   487,   488,   489,    -1,   491,   492,   493,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,
     516,   517,   518,   519,    -1,    -1,   522,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,    -1,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,
     566,   567,   568,    -1,   570,   571,    -1,   573,   574,    -1,
     576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,
     616,   617,   618,    -1,    -1,   621,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,   633,    14,    -1,
      -1,    -1,    18,   639,   640,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,
     476,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
     486,   487,   488,   489,    -1,   491,   492,   493,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,
     516,   517,   518,   519,    -1,    -1,   522,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,    -1,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,
     566,   567,   568,    -1,   570,   571,    -1,   573,   574,    -1,
     576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,
     616,   617,   618,    -1,    -1,   621,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,   632,    -1,    14,    -1,
      -1,    -1,    18,    -1,   640,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,
     476,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
     486,   487,   488,   489,    -1,   491,   492,   493,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,
     516,   517,   518,   519,    -1,    -1,   522,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,    -1,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,
     566,   567,   568,    -1,   570,   571,    -1,   573,   574,    -1,
     576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,
     616,   617,   618,    -1,    -1,   621,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,
      18,    -1,    -1,    21,   640,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,
      58,    -1,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    -1,    85,    86,    87,
      88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,    -1,
      98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,   107,
      -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,    -1,
      -1,    -1,    -1,   121,   122,    -1,   124,    -1,    -1,    -1,
     128,    -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,
     138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,
      -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,   157,
     158,    -1,   160,   161,   162,   163,   164,   165,    -1,    -1,
     168,   169,   170,   171,   172,    -1,    -1,   175,   176,    -1,
     178,   179,   180,    -1,    -1,   183,    -1,    -1,    -1,   187,
     188,    -1,   190,    -1,   192,    -1,   194,   195,   196,   197,
      -1,   199,    -1,   201,    -1,    -1,    -1,   205,   206,    -1,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,   217,
     218,   219,    -1,    -1,   222,   223,   224,    -1,    -1,   227,
      -1,    -1,    -1,    -1,   232,   233,    -1,    -1,    -1,   237,
      -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,
      -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,
      -1,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,
      -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,    -1,   302,   303,   304,    -1,   306,   307,
     308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,   317,
     318,   319,   320,   321,   322,    -1,    -1,   325,   326,    -1,
     328,    -1,   330,    -1,   332,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,
     348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,
      -1,   359,    -1,   361,    -1,   363,   364,    -1,   366,    -1,
     368,   369,    -1,   371,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   381,   382,   383,    -1,   385,   386,    -1,
     388,   389,   390,   391,   392,   393,   394,   395,   396,   397,
      -1,    -1,   400,   401,   402,    -1,   404,    -1,   406,   407,
     408,   409,   410,    -1,   412,   413,   414,    -1,    -1,   417,
      -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,
     428,   429,   430,   431,   432,    -1,   434,   435,    -1,   437,
     438,   439,    -1,    -1,   442,    -1,   444,    -1,   446,   447,
      -1,   449,   450,   451,    -1,   453,    -1,    -1,   456,   457,
     458,   459,   460,   461,   462,   463,   464,   465,   466,    -1,
     468,   469,    -1,    -1,    -1,   473,   474,   475,   476,    -1,
      -1,    -1,   480,    -1,    -1,    -1,   484,    -1,   486,   487,
     488,   489,    -1,   491,   492,   493,   494,   495,    -1,    -1,
      -1,    -1,    -1,   501,   502,   503,    -1,   505,   506,    -1,
     508,    -1,    -1,   511,    -1,    -1,   514,   515,   516,   517,
     518,   519,    -1,    -1,   522,   523,    -1,   525,   526,   527,
     528,   529,   530,    -1,    -1,   533,   534,   535,   536,    -1,
     538,   539,    -1,    -1,   542,   543,   544,   545,    -1,    -1,
     548,   549,    -1,   551,   552,   553,   554,    -1,    -1,    -1,
      -1,    -1,   560,   561,    -1,    -1,    -1,   565,   566,   567,
     568,    -1,   570,   571,    -1,   573,   574,    -1,   576,   577,
      -1,    -1,   580,    -1,    -1,   583,    -1,   585,    -1,   587,
     588,    -1,    -1,    -1,    -1,    -1,    -1,   595,    -1,    -1,
     598,    -1,    -1,    -1,   602,   603,   604,   605,   606,    -1,
      -1,    -1,    -1,    -1,    -1,   613,   614,    -1,   616,   617,
     618,    -1,    -1,   621,    -1,    -1,    -1,    -1,     5,   627,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,   640,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    -1,    85,    86,
      87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,
      -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,
      -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,    -1,
      -1,   128,    -1,   130,   131,   132,   133,   134,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,
     147,    -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,
     157,   158,    -1,   160,   161,   162,   163,   164,   165,    -1,
      -1,   168,   169,   170,   171,   172,    -1,    -1,   175,   176,
      -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,    -1,
     187,   188,    -1,   190,    -1,   192,    -1,   194,   195,   196,
     197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
      -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
     217,   218,   219,    -1,    -1,   222,   223,   224,    -1,    -1,
     227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,
      -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,
      -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,
     267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,    -1,   302,   303,   304,    -1,   306,
     307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,
     317,   318,   319,   320,   321,   322,    -1,    -1,   325,   326,
      -1,   328,    -1,   330,    -1,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,
     347,   348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,
      -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,   366,
      -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   381,   382,   383,    -1,   385,   386,
      -1,   388,   389,   390,   391,   392,   393,   394,   395,   396,
     397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,   406,
     407,   408,   409,   410,    -1,   412,   413,   414,    -1,    -1,
     417,    -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,
      -1,   428,   429,   430,   431,   432,    -1,   434,   435,    -1,
     437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,   446,
     447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   466,
      -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,   476,
      -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,   486,
     487,   488,   489,    -1,   491,   492,   493,   494,   495,    -1,
      -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,   506,
      -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,   516,
     517,   518,   519,    -1,    -1,   522,   523,    -1,   525,   526,
     527,   528,   529,   530,    -1,    -1,   533,   534,   535,   536,
      -1,   538,   539,    -1,    -1,   542,   543,   544,   545,    -1,
      -1,   548,   549,    -1,   551,   552,   553,   554,    -1,    -1,
      -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,   566,
     567,   568,    -1,   570,   571,    -1,   573,   574,    -1,   576,
     577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,    -1,
     587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,    -1,
      -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,   606,
      -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,   616,
     617,   618,    -1,    -1,   621,    -1,    -1,    -1,     5,    -1,
       7,     8,     9,    10,    11,   632,    -1,    14,    -1,    -1,
      -1,    18,    -1,   640,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    -1,    85,    86,
      87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,
      -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,
      -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,    -1,
      -1,   128,    -1,   130,   131,   132,   133,   134,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,
     147,    -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,
     157,   158,    -1,   160,   161,   162,   163,   164,   165,    -1,
      -1,   168,   169,   170,   171,   172,    -1,    -1,   175,   176,
      -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,    -1,
     187,   188,    -1,   190,    -1,   192,    -1,   194,   195,   196,
     197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
      -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
     217,   218,   219,    -1,    -1,   222,   223,   224,    -1,    -1,
     227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,
      -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,
      -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,
     267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,    -1,   302,   303,   304,    -1,   306,
     307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,
     317,   318,   319,   320,   321,   322,    -1,    -1,   325,   326,
      -1,   328,    -1,   330,    -1,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,
     347,   348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,
      -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,   366,
      -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   381,   382,   383,    -1,   385,   386,
      -1,   388,   389,   390,   391,   392,   393,   394,   395,   396,
     397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,   406,
     407,   408,   409,   410,    -1,   412,   413,   414,    -1,    -1,
     417,    -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,
      -1,   428,   429,   430,   431,   432,    -1,   434,   435,    -1,
     437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,   446,
     447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   466,
      -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,   476,
      -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,   486,
     487,   488,   489,    -1,   491,   492,   493,   494,   495,    -1,
      -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,   506,
      -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,   516,
     517,   518,   519,    -1,    -1,   522,   523,    -1,   525,   526,
     527,   528,   529,   530,    -1,    -1,   533,   534,   535,   536,
      -1,   538,   539,    -1,    -1,   542,   543,   544,   545,    -1,
      -1,   548,   549,    -1,   551,   552,   553,   554,    -1,    -1,
      -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,   566,
     567,   568,    -1,   570,   571,    -1,   573,   574,    -1,   576,
     577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,    -1,
     587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,    -1,
      -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,   606,
      -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,   616,
     617,   618,    -1,    -1,   621,    -1,    -1,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,   639,   640,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    -1,    85,    86,
      87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,
      -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,
      -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,    -1,
      -1,   128,    -1,   130,   131,   132,   133,   134,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,
     147,    -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,
     157,   158,    -1,   160,   161,   162,   163,   164,   165,    -1,
      -1,   168,   169,   170,   171,   172,    -1,    -1,   175,   176,
      -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,    -1,
     187,   188,    -1,   190,    -1,   192,    -1,   194,   195,   196,
     197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
      -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
     217,   218,   219,    -1,    -1,   222,   223,   224,    -1,    -1,
     227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,
      -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,
      -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,
     267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,    -1,   302,   303,   304,    -1,   306,
     307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,
     317,   318,   319,   320,   321,   322,    -1,    -1,   325,   326,
      -1,   328,    -1,   330,    -1,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,
     347,   348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,
      -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,   366,
      -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   381,   382,   383,    -1,   385,   386,
      -1,   388,   389,   390,   391,   392,   393,   394,   395,   396,
     397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,   406,
     407,   408,   409,   410,    -1,   412,   413,   414,    -1,    -1,
     417,    -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,
      -1,   428,   429,   430,   431,   432,    -1,   434,   435,    -1,
     437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,   446,
     447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   466,
      -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,   476,
      -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,   486,
     487,   488,   489,    -1,   491,   492,   493,   494,   495,    -1,
      -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,   506,
      -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,   516,
     517,   518,   519,    -1,    -1,   522,   523,    -1,   525,   526,
     527,   528,   529,   530,    -1,    -1,   533,   534,   535,   536,
      -1,   538,   539,    -1,    -1,   542,   543,   544,   545,    -1,
      -1,   548,   549,    -1,   551,   552,   553,   554,    -1,    -1,
      -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,   566,
     567,   568,    -1,   570,   571,    -1,   573,   574,    -1,   576,
     577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,    -1,
     587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,    -1,
      -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,   606,
      -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,   616,
     617,   618,    -1,    -1,   621,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    21,   640,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    -1,    85,    86,    87,    88,
      89,    -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,
      -1,    -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,
      -1,    -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,
      -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,
     149,   150,    -1,   152,   153,   154,    -1,    -1,   157,   158,
      -1,   160,   161,   162,   163,   164,   165,    -1,    -1,   168,
     169,   170,   171,   172,    -1,    -1,   175,   176,    -1,   178,
     179,   180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,
      -1,   190,    -1,   192,    -1,   194,   195,   196,   197,    -1,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,
     219,    -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,
      -1,    -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,
     249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,
     259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,
     269,    -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,    -1,   302,   303,   304,    -1,   306,   307,   308,
     309,    -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,
     319,   320,   321,   322,    -1,    -1,   325,   326,    -1,   328,
      -1,   330,    -1,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,
     349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,
     359,    -1,   361,    -1,   363,   364,    -1,   366,    -1,   368,
     369,    -1,   371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   381,   382,   383,    -1,   385,   386,    -1,   388,
     389,   390,   391,   392,   393,   394,   395,   396,   397,    -1,
      -1,   400,   401,   402,    -1,   404,    -1,   406,   407,   408,
     409,   410,    -1,   412,   413,   414,    -1,    -1,   417,    -1,
      -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,   428,
     429,   430,   431,   432,    -1,   434,   435,    -1,   437,   438,
     439,    -1,    -1,   442,    -1,   444,    -1,   446,   447,    -1,
     449,   450,   451,    -1,   453,    -1,    -1,   456,   457,   458,
     459,   460,   461,   462,   463,   464,   465,   466,    -1,   468,
     469,    -1,    -1,    -1,   473,   474,   475,   476,    -1,    -1,
      -1,   480,    -1,    -1,    -1,   484,    -1,   486,   487,   488,
     489,    -1,   491,   492,   493,   494,   495,    -1,    -1,    -1,
      -1,    -1,   501,   502,   503,    -1,   505,   506,    -1,   508,
      -1,    -1,   511,    -1,    -1,   514,   515,   516,   517,   518,
     519,    -1,    -1,   522,   523,    -1,   525,   526,   527,   528,
     529,   530,    -1,    -1,   533,   534,   535,   536,    -1,   538,
     539,    -1,    -1,   542,   543,   544,   545,    -1,    -1,   548,
     549,    -1,   551,   552,   553,   554,    -1,    -1,    -1,    -1,
      -1,   560,   561,    -1,    -1,    -1,   565,   566,   567,   568,
      -1,   570,   571,    -1,   573,   574,    -1,   576,   577,    -1,
      -1,   580,    -1,    -1,   583,    -1,   585,    -1,   587,   588,
      -1,    -1,    -1,    -1,    -1,    -1,   595,    -1,    -1,   598,
      -1,    -1,    -1,   602,   603,   604,   605,   606,    -1,    -1,
      -1,    -1,    -1,    -1,   613,   614,    -1,   616,   617,   618,
      -1,    -1,   621,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,   640,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,    -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,    -1,   400,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,   435,    -1,   437,   438,   439,    -1,
      -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,   450,
     451,    -1,   453,    -1,    -1,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   466,    -1,   468,   469,    -1,
      -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,
      -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,
     491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,    -1,
     501,   502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,
     511,    -1,    -1,   514,   515,   516,   517,   518,   519,    -1,
      -1,   522,   523,    -1,   525,   526,   527,   528,   529,   530,
      -1,    -1,   533,   534,   535,   536,    -1,   538,   539,    -1,
      -1,   542,   543,   544,   545,    -1,    -1,   548,   549,    -1,
     551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,
     561,    -1,    -1,    -1,   565,   566,   567,   568,    -1,   570,
     571,    -1,   573,   574,    -1,   576,   577,    -1,    -1,   580,
      -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,
      -1,   602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,
      -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,    -1,
     621,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,   640,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    -1,    85,    86,    87,    88,    89,    -1,    -1,    -1,
      93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,    -1,
      -1,    -1,   115,   116,    -1,    -1,    -1,    -1,   121,   122,
      -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,
     133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,
     153,   154,    -1,    -1,   157,   158,    -1,   160,   161,   162,
     163,   164,   165,    -1,    -1,   168,   169,   170,   171,   172,
      -1,    -1,   175,   176,    -1,   178,   179,   180,    -1,    -1,
     183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,
      -1,   194,   195,   196,   197,    -1,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,    -1,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,
     223,   224,    -1,    -1,   227,    -1,    -1,    -1,    -1,   232,
     233,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,
     253,    -1,    -1,   256,    -1,    -1,   259,   260,    -1,    -1,
      -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,
     273,   274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,
      -1,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,    -1,   302,
     303,   304,    -1,   306,   307,   308,   309,    -1,   311,   312,
      -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,   322,
      -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,    -1,
     343,   344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,
      -1,   354,   355,    -1,    -1,    -1,   359,    -1,   361,    -1,
     363,   364,    -1,   366,    -1,   368,   369,    -1,   371,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   381,   382,
     383,    -1,   385,   386,    -1,   388,   389,   390,   391,   392,
     393,   394,   395,   396,   397,    -1,    -1,   400,   401,   402,
      -1,   404,    -1,   406,   407,   408,   409,   410,    -1,   412,
     413,   414,    -1,    -1,   417,    -1,    -1,    -1,   421,   422,
     423,   424,   425,    -1,    -1,   428,   429,   430,   431,   432,
      -1,   434,   435,    -1,   437,   438,   439,    -1,    -1,   442,
      -1,   444,    -1,   446,   447,    -1,   449,   450,   451,    -1,
     453,    -1,    -1,   456,   457,   458,   459,   460,   461,   462,
     463,   464,   465,   466,    -1,   468,   469,    -1,    -1,    -1,
     473,   474,   475,   476,    -1,    -1,    -1,   480,    -1,    -1,
      -1,   484,    -1,   486,   487,   488,   489,    -1,   491,   492,
     493,   494,   495,    -1,    -1,    -1,    -1,    -1,   501,   502,
     503,    -1,   505,   506,    -1,   508,    -1,    -1,   511,    -1,
      -1,   514,   515,   516,   517,   518,   519,    -1,    -1,   522,
     523,    -1,   525,   526,   527,   528,   529,   530,    -1,    -1,
     533,   534,   535,   536,    -1,   538,   539,    -1,    -1,   542,
     543,   544,   545,    -1,    -1,   548,   549,    -1,   551,   552,
     553,   554,    -1,    -1,    -1,    -1,    -1,   560,   561,    -1,
      -1,    -1,   565,   566,   567,   568,    -1,   570,   571,    -1,
     573,   574,    -1,   576,   577,    -1,    -1,   580,    -1,    -1,
     583,    -1,   585,    -1,   587,   588,    -1,    -1,    -1,    -1,
      -1,    -1,   595,    -1,    -1,   598,    -1,    -1,    -1,   602,
     603,   604,   605,   606,    -1,    -1,    -1,    -1,    -1,    -1,
     613,   614,    -1,   616,   617,   618,    -1,    -1,   621,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,   640,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      55,    -1,    57,    58,    59,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    -1,
      85,    86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,
      -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,
     115,   116,    -1,    -1,    -1,   120,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
      -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
     165,    -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,
     175,   176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,
      -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,   217,   218,   219,    -1,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,
      -1,   256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
      -1,   306,   307,   308,   309,    -1,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,    -1,   328,    -1,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,    -1,   343,   344,
      -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,
     355,    -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,
      -1,   366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   381,   382,   383,    -1,
     385,   386,    -1,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,    -1,    -1,   400,   401,   402,    -1,   404,
      -1,   406,   407,   408,   409,   410,    -1,   412,   413,   414,
      -1,    -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,
     425,    -1,    -1,   428,   429,   430,   431,   432,    -1,   434,
     435,    -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,
      -1,   446,   447,    -1,   449,   450,   451,    -1,   453,    -1,
      -1,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,
     475,   476,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,
      -1,   486,   487,   488,   489,    -1,   491,   492,   493,   494,
     495,    -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,
     505,   506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,
     515,   516,   517,   518,   519,    -1,    -1,   522,   523,    -1,
     525,   526,   527,   528,   529,   530,    -1,    -1,   533,   534,
     535,   536,    -1,   538,   539,    -1,    -1,   542,   543,   544,
     545,    -1,    -1,   548,   549,    -1,   551,   552,   553,   554,
      -1,    -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,
     565,   566,   567,   568,    -1,   570,   571,    -1,   573,   574,
      -1,   576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,
     585,    -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,
     595,    -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,
     605,   606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,
      -1,   616,   617,   618,    -1,    -1,   621,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,
      18,    -1,    -1,    21,   639,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,
      58,    -1,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    -1,    85,    86,    87,
      88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,    -1,
      98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,   107,
      -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,    -1,
      -1,    -1,    -1,   121,   122,    -1,   124,    -1,    -1,    -1,
     128,    -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,
     138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,
      -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,   157,
     158,    -1,   160,   161,   162,   163,   164,   165,    -1,    -1,
     168,   169,   170,   171,   172,    -1,    -1,   175,   176,    -1,
     178,   179,   180,    -1,    -1,   183,    -1,    -1,    -1,   187,
     188,    -1,   190,    -1,   192,    -1,   194,   195,   196,   197,
      -1,   199,    -1,   201,    -1,    -1,    -1,   205,   206,    -1,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,   217,
     218,   219,    -1,    -1,   222,   223,   224,    -1,    -1,   227,
      -1,    -1,    -1,    -1,   232,   233,    -1,    -1,    -1,   237,
      -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,
      -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,
      -1,   259,   260,   261,    -1,    -1,    -1,    -1,   266,   267,
      -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,    -1,   302,   303,   304,    -1,   306,   307,
     308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,   317,
     318,   319,   320,   321,   322,    -1,    -1,   325,   326,    -1,
     328,    -1,   330,    -1,   332,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,
     348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,
      -1,   359,    -1,   361,    -1,   363,   364,    -1,   366,    -1,
     368,   369,    -1,   371,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   381,   382,   383,    -1,   385,   386,    -1,
     388,   389,   390,   391,   392,   393,   394,   395,   396,   397,
      -1,    -1,   400,   401,   402,    -1,   404,    -1,   406,   407,
     408,   409,   410,    -1,   412,   413,   414,    -1,    -1,   417,
      -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,
     428,   429,   430,   431,   432,    -1,   434,   435,    -1,   437,
     438,   439,    -1,    -1,   442,    -1,   444,    -1,   446,   447,
      -1,   449,   450,   451,    -1,   453,    -1,    -1,   456,   457,
     458,   459,   460,   461,   462,   463,   464,   465,   466,    -1,
     468,   469,    -1,    -1,    -1,   473,   474,   475,   476,    -1,
      -1,    -1,   480,    -1,    -1,    -1,   484,    -1,   486,   487,
     488,   489,    -1,   491,   492,   493,   494,   495,    -1,    -1,
      -1,    -1,    -1,   501,   502,   503,    -1,   505,   506,    -1,
     508,    -1,    -1,   511,    -1,    -1,   514,   515,   516,   517,
     518,   519,    -1,    -1,   522,   523,    -1,   525,   526,   527,
     528,   529,   530,    -1,    -1,   533,   534,   535,   536,    -1,
     538,   539,    -1,    -1,   542,   543,   544,   545,    -1,   547,
     548,   549,    -1,   551,   552,   553,   554,    -1,    -1,    -1,
      -1,    -1,   560,   561,    -1,    -1,    -1,   565,   566,   567,
     568,    -1,   570,   571,    -1,   573,   574,    -1,   576,   577,
      -1,    -1,   580,    -1,    -1,   583,    -1,   585,    -1,   587,
     588,    -1,    -1,    -1,    -1,    -1,    -1,   595,    -1,    -1,
     598,    -1,    -1,    -1,   602,   603,   604,   605,   606,    -1,
      -1,    -1,    -1,    -1,    -1,   613,   614,    -1,   616,   617,
     618,    -1,    -1,   621,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,   639,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
     261,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,    -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,    -1,   400,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,   435,    -1,   437,   438,   439,    -1,
      -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,   450,
     451,    -1,   453,    -1,    -1,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   466,    -1,   468,   469,    -1,
      -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,
      -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,
     491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,    -1,
     501,   502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,
     511,    -1,    -1,   514,   515,   516,   517,   518,   519,    -1,
      -1,   522,   523,    -1,   525,   526,   527,   528,   529,   530,
      -1,    -1,   533,   534,   535,   536,    -1,   538,   539,    -1,
      -1,   542,   543,   544,   545,    -1,   547,   548,   549,    -1,
     551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,
     561,    -1,    -1,    -1,   565,   566,   567,   568,    -1,   570,
     571,    -1,   573,   574,    -1,   576,   577,    -1,    -1,   580,
      -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,
      -1,   602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,
      -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,    -1,
     621,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      14,    -1,    -1,    -1,    18,    -1,    -1,    21,   639,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    59,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      -1,    85,    86,    87,    88,    89,    -1,    -1,    -1,    93,
      -1,    -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,
      -1,   115,   116,    -1,    -1,    -1,   120,   121,   122,    -1,
     124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,
     134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,
      -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,
     154,    -1,    -1,   157,   158,    -1,   160,   161,   162,   163,
     164,   165,    -1,    -1,   168,   169,   170,   171,   172,    -1,
      -1,   175,   176,    -1,   178,   179,   180,    -1,    -1,   183,
      -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,
     194,   195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,
      -1,   205,   206,    -1,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,   223,
     224,    -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   233,
      -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,
     244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,
      -1,    -1,   256,    -1,    -1,   259,   260,    -1,    -1,    -1,
      -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,
     274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,    -1,   302,   303,
     304,    -1,   306,   307,   308,   309,    -1,   311,   312,    -1,
      -1,    -1,    -1,   317,   318,   319,   320,   321,   322,    -1,
      -1,   325,   326,    -1,   328,    -1,   330,    -1,   332,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,    -1,   343,
     344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,
     354,   355,    -1,    -1,    -1,   359,    -1,   361,    -1,   363,
     364,    -1,   366,    -1,   368,   369,    -1,   371,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   381,   382,   383,
      -1,   385,   386,    -1,   388,   389,   390,   391,   392,   393,
     394,   395,   396,   397,    -1,    -1,   400,   401,   402,    -1,
     404,    -1,   406,   407,   408,   409,   410,    -1,   412,   413,
     414,    -1,    -1,   417,    -1,    -1,    -1,   421,   422,   423,
     424,   425,    -1,    -1,   428,   429,   430,   431,   432,    -1,
     434,   435,    -1,   437,   438,   439,    -1,    -1,   442,    -1,
     444,    -1,   446,   447,    -1,   449,   450,   451,    -1,   453,
      -1,    -1,   456,   457,   458,   459,   460,   461,   462,   463,
     464,   465,   466,    -1,   468,   469,    -1,    -1,    -1,   473,
     474,   475,   476,    -1,    -1,    -1,   480,    -1,    -1,    -1,
     484,    -1,   486,   487,   488,   489,    -1,   491,   492,   493,
     494,   495,    -1,    -1,    -1,    -1,    -1,   501,   502,   503,
      -1,   505,   506,    -1,   508,    -1,    -1,   511,    -1,    -1,
     514,   515,   516,   517,   518,   519,    -1,    -1,   522,   523,
      -1,   525,   526,   527,   528,   529,   530,    -1,    -1,   533,
     534,   535,   536,    -1,   538,   539,    -1,    -1,   542,   543,
     544,   545,    -1,    -1,   548,   549,    -1,   551,   552,   553,
     554,    -1,    -1,    -1,    -1,    -1,   560,   561,    -1,    -1,
      -1,   565,   566,   567,   568,    -1,   570,   571,    -1,   573,
     574,    -1,   576,   577,    -1,    -1,   580,    -1,    -1,   583,
      -1,   585,    -1,   587,   588,    -1,    -1,    -1,    -1,    -1,
      -1,   595,    -1,    -1,   598,    -1,    -1,    -1,   602,   603,
     604,   605,   606,    -1,    -1,    -1,    -1,    -1,    -1,   613,
     614,    -1,   616,   617,   618,    -1,    -1,   621,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,   639,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    -1,    85,    86,
      87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,
      -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,
      -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,    -1,
      -1,   128,    -1,   130,   131,   132,   133,   134,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,
     147,    -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,
     157,   158,    -1,   160,   161,   162,   163,   164,   165,    -1,
      -1,   168,   169,   170,   171,   172,    -1,    -1,   175,   176,
      -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,    -1,
     187,   188,    -1,   190,    -1,   192,    -1,   194,   195,   196,
     197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
      -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
     217,   218,   219,    -1,    -1,   222,   223,   224,    -1,    -1,
     227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,
      -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,
      -1,    -1,   259,   260,   261,    -1,    -1,    -1,    -1,   266,
     267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,    -1,   302,   303,   304,    -1,   306,
     307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,
     317,   318,   319,   320,   321,   322,    -1,    -1,   325,   326,
      -1,   328,    -1,   330,    -1,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,
     347,   348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,
      -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,   366,
      -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   381,   382,   383,    -1,   385,   386,
      -1,   388,   389,   390,   391,   392,   393,   394,   395,   396,
     397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,   406,
     407,   408,   409,   410,    -1,   412,   413,   414,    -1,    -1,
     417,    -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,
      -1,   428,   429,   430,   431,   432,    -1,   434,   435,    -1,
     437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,   446,
     447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   466,
      -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,   476,
      -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,   486,
     487,   488,   489,    -1,   491,   492,   493,   494,   495,    -1,
      -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,   506,
      -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,   516,
     517,   518,   519,    -1,    -1,   522,   523,    -1,   525,   526,
     527,   528,   529,   530,    -1,    -1,   533,   534,   535,   536,
      -1,   538,   539,    -1,    -1,   542,   543,   544,   545,    -1,
     547,   548,   549,    -1,   551,   552,   553,   554,    -1,    -1,
      -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,   566,
     567,   568,    -1,   570,   571,    -1,   573,   574,    -1,   576,
     577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,    -1,
     587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,    -1,
      -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,   606,
      -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,   616,
     617,   618,    -1,    -1,   621,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    21,   639,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    -1,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,
      -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,
      -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,
     130,   131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,
     160,   161,   162,   163,   164,   165,    -1,    -1,   168,   169,
     170,   171,   172,    -1,    -1,   175,   176,    -1,   178,   179,
     180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,
     190,    -1,   192,    -1,   194,   195,   196,   197,    -1,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,   219,
      -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,
      -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,
      -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,
     260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,
      -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   282,    -1,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,    -1,   302,   303,   304,    -1,   306,   307,   308,   309,
      -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,
     320,   321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,
     350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,
      -1,   361,    -1,   363,   364,    -1,   366,    -1,   368,   369,
      -1,   371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   381,   382,   383,    -1,   385,   386,    -1,   388,   389,
     390,   391,   392,   393,   394,   395,   396,   397,    -1,    -1,
     400,   401,   402,    -1,   404,    -1,   406,   407,   408,   409,
     410,    -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,
      -1,   421,   422,   423,   424,   425,    -1,    -1,   428,   429,
     430,   431,   432,    -1,   434,   435,    -1,   437,   438,   439,
      -1,    -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,
     450,   451,    -1,   453,    -1,    -1,   456,   457,   458,   459,
     460,   461,   462,   463,   464,   465,   466,    -1,   468,   469,
      -1,    -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,
     480,    -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,
      -1,   491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,
      -1,   501,   502,   503,    -1,   505,   506,    -1,   508,    -1,
      -1,   511,    -1,    -1,   514,   515,   516,   517,   518,   519,
      -1,    -1,   522,   523,    -1,   525,   526,   527,   528,   529,
     530,    -1,    -1,   533,   534,   535,   536,    -1,   538,   539,
      -1,    -1,   542,   543,   544,   545,    -1,    -1,   548,   549,
      -1,   551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,
     560,   561,    -1,    -1,    -1,   565,   566,   567,   568,    -1,
     570,   571,    -1,   573,   574,    -1,   576,   577,    -1,    -1,
     580,    -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,
      -1,    -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,
      -1,    -1,   602,   603,   604,   605,   606,    -1,    -1,    -1,
      -1,    -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,
      -1,   621,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,   639,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    -1,    85,    86,    87,    88,    89,    -1,    -1,    -1,
      93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,    -1,
      -1,    -1,   115,   116,    -1,    -1,    -1,    -1,   121,   122,
      -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,
     133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,
     153,   154,    -1,    -1,   157,   158,    -1,   160,   161,   162,
     163,   164,   165,    -1,    -1,   168,   169,   170,   171,   172,
      -1,    -1,   175,   176,    -1,   178,   179,   180,    -1,    -1,
     183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,
      -1,   194,   195,   196,   197,    -1,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,    -1,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,
     223,   224,    -1,    -1,   227,    -1,    -1,    -1,    -1,   232,
     233,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,
     253,    -1,    -1,   256,    -1,    -1,   259,   260,    -1,    -1,
      -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,
     273,   274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,
      -1,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,    -1,   302,
     303,   304,    -1,   306,   307,   308,   309,    -1,   311,   312,
      -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,   322,
      -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,    -1,
     343,   344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,
      -1,   354,   355,    -1,    -1,    -1,   359,    -1,   361,    -1,
     363,   364,    -1,   366,    -1,   368,   369,    -1,   371,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   381,   382,
     383,    -1,   385,   386,    -1,   388,   389,   390,   391,   392,
     393,   394,   395,   396,   397,    -1,    -1,   400,   401,   402,
      -1,   404,    -1,   406,   407,   408,   409,   410,    -1,   412,
     413,   414,    -1,    -1,   417,    -1,    -1,    -1,   421,   422,
     423,   424,   425,    -1,    -1,   428,   429,   430,   431,   432,
      -1,   434,   435,    -1,   437,   438,   439,    -1,    -1,   442,
      -1,   444,    -1,   446,   447,    -1,   449,   450,   451,    -1,
     453,    -1,    -1,   456,   457,   458,   459,   460,   461,   462,
     463,   464,   465,   466,    -1,   468,   469,    -1,    -1,    -1,
     473,   474,   475,   476,    -1,    -1,    -1,   480,    -1,    -1,
      -1,   484,    -1,   486,   487,   488,   489,    -1,   491,   492,
     493,   494,   495,    -1,    -1,    -1,    -1,    -1,   501,   502,
     503,    -1,   505,   506,    -1,   508,    -1,    -1,   511,    -1,
      -1,   514,   515,   516,   517,   518,   519,    -1,    -1,   522,
     523,    -1,   525,   526,   527,   528,   529,   530,    -1,    -1,
     533,   534,   535,   536,    -1,   538,   539,    -1,    -1,   542,
     543,   544,   545,    -1,    -1,   548,   549,    -1,   551,   552,
     553,   554,    -1,    -1,    -1,    -1,    -1,   560,   561,    -1,
      -1,    -1,   565,   566,   567,   568,    -1,   570,   571,    -1,
     573,   574,    -1,   576,   577,    -1,    -1,   580,    -1,    -1,
     583,    -1,   585,    -1,   587,   588,    -1,    -1,    -1,    -1,
      -1,    -1,   595,    -1,    -1,   598,    -1,    -1,    -1,   602,
     603,   604,   605,   606,    -1,    -1,    -1,    -1,    -1,    -1,
     613,   614,    -1,   616,   617,   618,    -1,    -1,   621,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    -1,   639,    23,    24,    25,
      26,    27,    -1,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    54,    55,
      -1,    57,    -1,    -1,    -1,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    -1,    75,
      -1,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    -1,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
      -1,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,    -1,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,    -1,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,    -1,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,   177,   178,   179,   180,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,    -1,
     206,    -1,    -1,    -1,    -1,    -1,   212,    -1,    -1,    -1,
     216,   217,   218,   219,   220,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,    -1,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
     246,    -1,    -1,   249,    -1,    -1,    -1,   253,    -1,    -1,
     256,   257,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,   279,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,    -1,   355,
      -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,    -1,    -1,    -1,    -1,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,    -1,
      -1,   437,    -1,   439,   440,    -1,   442,    -1,    -1,    -1,
     446,    -1,    -1,   449,   450,   451,   452,   453,    -1,    -1,
      -1,   457,   458,   459,   460,   461,   462,   463,    -1,   465,
     466,    -1,   468,    -1,    -1,    -1,    -1,   473,   474,   475,
      -1,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
      -1,   487,    -1,   489,    -1,   491,    -1,    -1,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,    -1,
     516,   517,   518,   519,    -1,    -1,    -1,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,    -1,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,    -1,
     566,   567,   568,    -1,   570,   571,    -1,   573,   574,    -1,
      -1,    -1,    -1,    -1,   580,    -1,    -1,   583,    -1,    -1,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,    -1,    -1,   609,    -1,    -1,    -1,   613,    -1,    -1,
     616,    -1,   618,    -1,     5,   621,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,   634,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,    -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,    -1,   400,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,   435,    -1,   437,   438,   439,    -1,
      -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,   450,
     451,    -1,   453,    -1,    -1,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   466,    -1,   468,   469,    -1,
      -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,
      -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,
     491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,    -1,
     501,   502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,
     511,    -1,    -1,   514,   515,   516,   517,   518,   519,    -1,
      -1,   522,   523,    -1,   525,   526,   527,   528,   529,   530,
      -1,    -1,   533,   534,   535,   536,    -1,   538,   539,    -1,
      -1,   542,   543,   544,   545,    -1,    -1,   548,   549,    -1,
     551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,
     561,    -1,    -1,    -1,   565,   566,   567,   568,    -1,   570,
     571,    -1,   573,   574,    -1,   576,   577,    -1,    -1,   580,
      -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,
      -1,   602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,
      -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,     5,
     621,     7,     8,     9,    10,    11,   627,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,
     476,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
     486,   487,   488,   489,    -1,   491,   492,   493,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,
     516,   517,   518,   519,    -1,    -1,   522,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,    -1,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,
     566,   567,   568,    -1,   570,   571,    -1,   573,   574,    -1,
     576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,
     616,   617,   618,    -1,     5,   621,     7,     8,     9,    10,
      11,   627,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,    -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,    -1,   400,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,   435,    -1,   437,   438,   439,    -1,
      -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,   450,
     451,    -1,   453,    -1,    -1,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   466,    -1,   468,   469,    -1,
      -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,
      -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,
     491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,    -1,
     501,   502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,
     511,    -1,    -1,   514,   515,   516,   517,   518,   519,    -1,
      -1,   522,   523,    -1,   525,   526,   527,   528,   529,   530,
      -1,    -1,   533,   534,   535,   536,    -1,   538,   539,    -1,
      -1,   542,   543,   544,   545,    -1,    -1,   548,   549,    -1,
     551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,
     561,    -1,    -1,    -1,   565,   566,   567,   568,    -1,   570,
     571,    -1,   573,   574,    -1,   576,   577,    -1,    -1,   580,
      -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,
      -1,   602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,
      -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,     5,
     621,     7,     8,     9,    10,    11,   627,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,
     476,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
     486,   487,   488,   489,    -1,   491,   492,   493,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,
     516,   517,   518,   519,    -1,    -1,   522,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,    -1,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,
     566,   567,   568,    -1,   570,   571,    -1,   573,   574,    -1,
     576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,
     616,   617,   618,    -1,     5,   621,     7,     8,     9,    10,
      11,   627,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,   117,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
     181,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
     351,   352,    -1,   354,   355,    -1,    -1,   358,   359,    -1,
     361,    -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,    -1,   400,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,   435,    -1,   437,   438,   439,    -1,
      -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,   450,
     451,    -1,   453,    -1,    -1,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   466,    -1,   468,   469,    -1,
      -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,
      -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,
     491,   492,   493,   494,   495,    -1,    -1,   498,   499,   500,
     501,   502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,
     511,    -1,    -1,   514,   515,   516,   517,   518,   519,    -1,
      -1,   522,   523,    -1,   525,   526,   527,   528,   529,   530,
      -1,    -1,   533,   534,   535,   536,    -1,   538,   539,    -1,
      -1,   542,   543,   544,   545,    -1,    -1,   548,   549,    -1,
     551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,
     561,    -1,    -1,    -1,   565,   566,   567,   568,   569,   570,
     571,    -1,   573,   574,    -1,   576,   577,    -1,    -1,   580,
      -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,
      -1,   602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,
      -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,     5,
     621,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    33,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,   120,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,   155,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,   261,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,
     476,    -1,    -1,   479,   480,    -1,    -1,    -1,   484,    -1,
     486,   487,   488,   489,    -1,   491,   492,   493,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,
     516,   517,   518,   519,    -1,    -1,   522,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,   547,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,
     566,   567,   568,    -1,   570,   571,    -1,   573,   574,    -1,
     576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,
     616,   617,   618,    -1,     5,   621,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    33,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,   120,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
     261,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,    -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,    -1,   400,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,   435,    -1,   437,   438,   439,    -1,
      -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,   450,
     451,    -1,   453,    -1,    -1,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   466,    -1,   468,   469,    -1,
      -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,
      -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,
     491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,    -1,
     501,   502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,
     511,    -1,    -1,   514,   515,   516,   517,   518,   519,    -1,
      -1,   522,   523,    -1,   525,   526,   527,   528,   529,   530,
      -1,    -1,   533,   534,   535,   536,    -1,   538,   539,    -1,
      -1,   542,   543,   544,   545,    -1,   547,   548,   549,    -1,
     551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,
     561,    -1,    -1,    -1,   565,   566,   567,   568,    -1,   570,
     571,    -1,   573,   574,    -1,   576,   577,    -1,    -1,   580,
      -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,
      -1,   602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,
      -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,     5,
     621,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,   277,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,   358,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,   382,   383,   384,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,
     476,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
     486,   487,   488,   489,    -1,   491,   492,   493,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,
     516,   517,   518,   519,    -1,    -1,   522,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,    -1,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,
     566,   567,   568,   569,   570,   571,    -1,   573,   574,    -1,
     576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,
     616,   617,   618,    -1,     5,   621,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    33,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,   120,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
     261,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,    -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,    -1,   400,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,   435,    -1,   437,   438,   439,    -1,
      -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,   450,
     451,    -1,   453,    -1,    -1,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   466,    -1,   468,   469,    -1,
      -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,
      -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,
     491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,    -1,
     501,   502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,
     511,    -1,    -1,   514,   515,   516,   517,   518,   519,    -1,
      -1,   522,   523,    -1,   525,   526,   527,   528,   529,   530,
      -1,    -1,   533,   534,   535,   536,    -1,   538,   539,    -1,
      -1,   542,   543,   544,   545,    -1,   547,   548,   549,    -1,
     551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,
     561,    -1,    -1,    -1,   565,   566,   567,   568,    -1,   570,
     571,    -1,   573,   574,    -1,   576,   577,    -1,    -1,   580,
      -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,
      -1,   602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,
      -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,     5,
     621,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    99,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,   261,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,
     476,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
     486,   487,   488,   489,    -1,   491,   492,   493,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,
     516,   517,   518,   519,    -1,    -1,   522,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,   547,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,
     566,   567,   568,    -1,   570,   571,    -1,   573,   574,    -1,
     576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,
     616,   617,   618,    -1,     5,   621,     7,     8,     9,    10,
      11,    12,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
     261,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,    -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,    -1,   400,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,   435,    -1,   437,   438,   439,    -1,
      -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,   450,
     451,    -1,   453,    -1,    -1,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   466,    -1,   468,   469,    -1,
      -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,
      -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,
     491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,    -1,
     501,   502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,
     511,    -1,    -1,   514,   515,   516,   517,   518,   519,    -1,
      -1,   522,   523,    -1,   525,   526,   527,   528,   529,   530,
      -1,    -1,   533,   534,   535,   536,    -1,   538,   539,    -1,
      -1,   542,   543,   544,   545,    -1,   547,   548,   549,    -1,
     551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,
     561,    -1,    -1,    -1,   565,   566,   567,   568,    -1,   570,
     571,    -1,   573,   574,    -1,   576,   577,    -1,    -1,   580,
      -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,
      -1,   602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,
      -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,     5,
     621,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    35,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,
     476,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
     486,   487,   488,   489,    -1,   491,   492,   493,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,
     516,   517,   518,   519,    -1,    -1,   522,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,   547,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,
     566,   567,   568,    -1,   570,   571,    -1,   573,   574,    -1,
     576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,
     616,   617,   618,    -1,     5,   621,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,   120,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
     261,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,    -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,    -1,   400,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,   435,    -1,   437,   438,   439,    -1,
      -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,   450,
     451,    -1,   453,    -1,    -1,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   466,    -1,   468,   469,    -1,
      -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,
      -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,
     491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,    -1,
     501,   502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,
     511,    -1,    -1,   514,   515,   516,   517,   518,   519,    -1,
      -1,   522,   523,    -1,   525,   526,   527,   528,   529,   530,
      -1,    -1,   533,   534,   535,   536,    -1,   538,   539,    -1,
      -1,   542,   543,   544,   545,    -1,   547,   548,   549,    -1,
     551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,
     561,    -1,    -1,    -1,   565,   566,   567,   568,    -1,   570,
     571,    -1,   573,   574,    -1,   576,   577,    -1,    -1,   580,
      -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,
      -1,   602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,
      -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,     5,
     621,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    33,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,   261,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,
     476,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
     486,   487,   488,   489,    -1,   491,   492,   493,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,
     516,   517,   518,   519,    -1,    -1,   522,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,   547,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,
     566,   567,   568,    -1,   570,   571,    -1,   573,   574,    -1,
     576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,
     616,   617,   618,    -1,     5,   621,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
     261,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,    -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,    -1,   400,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,   435,    -1,   437,   438,   439,    -1,
      -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,   450,
     451,    -1,   453,    -1,    -1,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   466,    -1,   468,   469,    -1,
      -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,
      -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,
     491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,    -1,
     501,   502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,
     511,    -1,    -1,   514,   515,   516,   517,   518,   519,    -1,
      -1,   522,   523,    -1,   525,   526,   527,   528,   529,   530,
      -1,    -1,   533,   534,   535,   536,    -1,   538,   539,    -1,
      -1,   542,   543,   544,   545,    -1,   547,   548,   549,    -1,
     551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,
     561,    -1,    -1,    -1,   565,   566,   567,   568,    -1,   570,
     571,    -1,   573,   574,    -1,   576,   577,    -1,    -1,   580,
      -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,
      -1,   602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,
      -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,     5,
     621,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,
     476,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
     486,   487,   488,   489,    -1,   491,   492,   493,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,
     516,   517,   518,   519,    -1,    -1,   522,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,   547,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,
     566,   567,   568,    -1,   570,   571,    -1,   573,   574,    -1,
     576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,
     616,   617,   618,    -1,     5,   621,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    90,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,   167,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,    -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,    -1,   400,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,   435,    -1,   437,   438,   439,    -1,
      -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,   450,
     451,    -1,   453,    -1,    -1,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   466,    -1,   468,   469,    -1,
      -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,
      -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,
     491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,    -1,
     501,   502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,
     511,    -1,    -1,   514,   515,   516,   517,   518,   519,    -1,
      -1,   522,   523,    -1,   525,   526,   527,   528,   529,   530,
      -1,    -1,   533,   534,   535,   536,    -1,   538,   539,    -1,
      -1,   542,   543,   544,   545,    -1,    -1,   548,   549,    -1,
     551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,
     561,    -1,    -1,    -1,   565,   566,   567,   568,    -1,   570,
     571,    -1,   573,   574,    -1,   576,   577,    -1,    -1,   580,
      -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,
      -1,   602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,
      -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,     5,
     621,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,
     476,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
     486,   487,   488,   489,    -1,   491,   492,   493,   494,   495,
      -1,    -1,    -1,   499,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,
     516,   517,   518,   519,    -1,    -1,   522,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,    -1,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,
     566,   567,   568,    -1,   570,   571,    -1,   573,   574,    -1,
     576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,
     616,   617,   618,    -1,     5,   621,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,   189,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,    -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,    -1,   400,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,   435,    -1,   437,   438,   439,    -1,
      -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,   450,
     451,    -1,   453,    -1,    -1,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   466,    -1,   468,   469,    -1,
      -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,
      -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,
     491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,    -1,
     501,   502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,
     511,    -1,    -1,   514,   515,   516,   517,   518,   519,    -1,
      -1,   522,   523,    -1,   525,   526,   527,   528,   529,   530,
      -1,    -1,   533,   534,   535,   536,    -1,   538,   539,    -1,
      -1,   542,   543,   544,   545,    -1,    -1,   548,   549,    -1,
     551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,
     561,    -1,    -1,    -1,   565,   566,   567,   568,    -1,   570,
     571,    -1,   573,   574,    -1,   576,   577,    -1,    -1,   580,
      -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,
      -1,   602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,
      -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,     5,
     621,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,   120,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,
     476,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
     486,   487,   488,   489,    -1,   491,   492,   493,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,
     516,   517,   518,   519,    -1,    -1,   522,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,    -1,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,
     566,   567,   568,    -1,   570,   571,    -1,   573,   574,    -1,
     576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,
     616,   617,   618,    -1,     5,   621,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,   120,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,    -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,    -1,   400,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,   435,    -1,   437,   438,   439,    -1,
      -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,   450,
     451,    -1,   453,    -1,    -1,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   466,    -1,   468,   469,    -1,
      -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,
      -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,
     491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,    -1,
     501,   502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,
     511,    -1,    -1,   514,   515,   516,   517,   518,   519,    -1,
      -1,   522,   523,    -1,   525,   526,   527,   528,   529,   530,
      -1,    -1,   533,   534,   535,   536,    -1,   538,   539,    -1,
      -1,   542,   543,   544,   545,    -1,    -1,   548,   549,    -1,
     551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,
     561,    -1,    -1,    -1,   565,   566,   567,   568,    -1,   570,
     571,    -1,   573,   574,    -1,   576,   577,    -1,    -1,   580,
      -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,
      -1,   602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,
      -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,     5,
     621,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,   120,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,
     476,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
     486,   487,   488,   489,    -1,   491,   492,   493,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,
     516,   517,   518,   519,    -1,    -1,   522,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,    -1,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,
     566,   567,   568,    -1,   570,   571,    -1,   573,   574,    -1,
     576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,
     616,   617,   618,    -1,     5,   621,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,    -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,    -1,   400,
     401,   402,   403,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,   435,    -1,   437,   438,   439,    -1,
      -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,   450,
     451,    -1,   453,    -1,    -1,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   466,    -1,   468,   469,    -1,
      -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,
      -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,
     491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,    -1,
     501,   502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,
     511,    -1,    -1,   514,   515,   516,   517,   518,   519,    -1,
      -1,   522,   523,    -1,   525,   526,   527,   528,   529,   530,
      -1,    -1,   533,   534,   535,   536,    -1,   538,   539,    -1,
      -1,   542,   543,   544,   545,    -1,    -1,   548,   549,    -1,
     551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,
     561,    -1,    -1,    -1,   565,   566,   567,   568,    -1,   570,
     571,    -1,   573,   574,    -1,   576,   577,    -1,    -1,   580,
      -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,
      -1,   602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,
      -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,     5,
     621,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,
     476,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
     486,   487,   488,   489,    -1,   491,   492,   493,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,
     516,   517,   518,   519,    -1,    -1,   522,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,   547,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,
     566,   567,   568,    -1,   570,   571,    -1,   573,   574,    -1,
     576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,
     616,   617,   618,    -1,     5,   621,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,   120,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,    -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,    -1,   400,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,   435,    -1,   437,   438,   439,    -1,
      -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,   450,
     451,    -1,   453,    -1,    -1,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   466,    -1,   468,   469,    -1,
      -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,
      -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,
     491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,    -1,
     501,   502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,
     511,    -1,    -1,   514,   515,   516,   517,   518,   519,    -1,
      -1,   522,   523,    -1,   525,   526,   527,   528,   529,   530,
      -1,    -1,   533,   534,   535,   536,    -1,   538,   539,    -1,
      -1,   542,   543,   544,   545,    -1,    -1,   548,   549,    -1,
     551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,
     561,    -1,    -1,    -1,   565,   566,   567,   568,    -1,   570,
     571,    -1,   573,   574,    -1,   576,   577,    -1,    -1,   580,
      -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,
      -1,   602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,
      -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,     5,
     621,     7,     8,     9,    10,    11,    12,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,
     476,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
     486,   487,   488,   489,    -1,   491,   492,   493,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,
     516,   517,   518,   519,    -1,    -1,   522,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,    -1,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,
     566,   567,   568,    -1,   570,   571,    -1,   573,   574,    -1,
     576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,
     616,   617,   618,    -1,     5,   621,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,   120,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,    -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,    -1,   400,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,   435,    -1,   437,   438,   439,    -1,
      -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,   450,
     451,    -1,   453,    -1,    -1,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   466,    -1,   468,   469,    -1,
      -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,
      -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,
     491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,    -1,
     501,   502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,
     511,    -1,    -1,   514,   515,   516,   517,   518,   519,    -1,
      -1,   522,   523,    -1,   525,   526,   527,   528,   529,   530,
      -1,    -1,   533,   534,   535,   536,    -1,   538,   539,    -1,
      -1,   542,   543,   544,   545,    -1,    -1,   548,   549,    -1,
     551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,
     561,    -1,    -1,    -1,   565,   566,   567,   568,    -1,   570,
     571,    -1,   573,   574,    -1,   576,   577,    -1,    -1,   580,
      -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,
      -1,   602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,
      -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,     5,
     621,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,   382,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,   453,    -1,    -1,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,   468,   469,    -1,    -1,    -1,   473,   474,   475,
     476,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
     486,   487,   488,   489,    -1,   491,   492,   493,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,   515,
     516,   517,   518,   519,    -1,    -1,   522,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,    -1,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,   565,
     566,   567,   568,    -1,   570,   571,    -1,   573,   574,    -1,
     576,   577,    -1,    -1,   580,    -1,    -1,   583,    -1,   585,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,   614,    -1,
     616,   617,   618,    -1,     5,   621,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,    -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,    -1,   400,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,   435,    -1,   437,   438,   439,    -1,
      -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,   450,
     451,    -1,   453,    -1,    -1,   456,   457,   458,   459,   460,
     461,   462,   463,   464,   465,   466,    -1,   468,   469,    -1,
      -1,    -1,   473,   474,   475,   476,    -1,    -1,    -1,   480,
      -1,    -1,    -1,   484,    -1,   486,   487,   488,   489,    -1,
     491,   492,   493,   494,   495,    -1,    -1,    -1,    -1,    -1,
     501,   502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,
     511,    -1,    -1,   514,   515,   516,   517,   518,   519,    -1,
      -1,   522,   523,    -1,   525,   526,   527,   528,   529,   530,
      -1,    -1,   533,   534,   535,   536,    -1,   538,   539,    -1,
      -1,   542,   543,   544,   545,    -1,    -1,   548,   549,    -1,
     551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,
     561,    -1,    -1,    -1,   565,   566,   567,   568,    -1,   570,
     571,    -1,   573,   574,    -1,   576,   577,    -1,    -1,   580,
      -1,    -1,   583,    -1,   585,    -1,   587,   588,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,
      -1,   602,   603,   604,   605,   606,    -1,    -1,    -1,    -1,
      -1,    -1,   613,   614,    -1,   616,   617,   618,    -1,     5,
     621,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    -1,    -1,    23,    24,    25,
      26,    27,    -1,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    54,    55,
      -1,    57,    -1,    -1,    -1,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    -1,    75,
      -1,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    -1,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
      -1,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,    -1,    -1,    -1,   141,   142,   143,    -1,   145,
     146,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,    -1,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,   177,   178,   179,   180,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,    -1,
     206,    -1,    -1,    -1,    -1,    -1,   212,    -1,    -1,    -1,
     216,   217,   218,   219,   220,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,    -1,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
     246,    -1,    -1,   249,    -1,    -1,    -1,   253,    -1,    -1,
     256,   257,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,   279,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,    -1,   355,
      -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,    -1,    -1,    -1,    -1,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,    -1,
      -1,   437,    -1,   439,   440,    -1,   442,    -1,    -1,    -1,
     446,    -1,    -1,   449,   450,   451,   452,   453,    -1,    -1,
      -1,   457,   458,   459,   460,   461,   462,   463,    -1,   465,
     466,    -1,   468,    -1,    -1,    -1,    -1,   473,   474,   475,
      -1,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
      -1,   487,    -1,   489,    -1,   491,    -1,    -1,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,    -1,
     516,   517,   518,   519,    -1,    -1,    -1,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,    -1,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,    -1,
     566,   567,   568,    -1,   570,   571,    -1,   573,   574,    -1,
      -1,    -1,    -1,    -1,   580,    -1,    -1,   583,    -1,    -1,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,    -1,    -1,   609,    -1,    -1,    -1,   613,    -1,    -1,
     616,    -1,   618,    -1,     5,   621,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      -1,    -1,    23,    24,    25,    26,    27,    -1,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    -1,    -1,    -1,    -1,
      51,    52,    -1,    54,    55,    -1,    57,    -1,    -1,    -1,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    -1,    75,    -1,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    -1,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,    -1,    -1,    -1,
     141,   142,   143,    -1,   145,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,    -1,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,   177,   178,   179,   180,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,    -1,   206,    -1,    -1,    -1,    -1,
      -1,   212,    -1,    -1,    -1,   216,   217,   218,   219,   220,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,   246,    -1,    -1,   249,    -1,
      -1,    -1,   253,    -1,    -1,   256,   257,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,   279,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,    -1,   355,    -1,    -1,    -1,   359,    -1,
     361,    -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,    -1,    -1,    -1,    -1,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,    -1,    -1,   437,    -1,   439,   440,
      -1,   442,    -1,    -1,    -1,   446,    -1,    -1,   449,   450,
     451,   452,   453,    -1,    -1,    -1,   457,   458,   459,   460,
     461,   462,   463,    -1,   465,   466,    -1,   468,    -1,    -1,
      -1,    -1,   473,   474,   475,    -1,    -1,    -1,    -1,   480,
      -1,    -1,    -1,   484,    -1,    -1,   487,    -1,   489,    -1,
     491,    -1,    -1,   494,   495,    -1,    -1,    -1,    -1,    -1,
     501,   502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,
     511,    -1,    -1,   514,    -1,   516,   517,   518,   519,    -1,
      -1,    -1,   523,    -1,   525,   526,   527,   528,   529,   530,
      -1,    -1,   533,   534,   535,   536,    -1,   538,   539,    -1,
      -1,   542,   543,   544,   545,    -1,    -1,   548,   549,    -1,
     551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,
     561,    -1,    -1,    -1,    -1,   566,   567,   568,    -1,   570,
     571,    -1,   573,   574,    -1,    -1,    -1,    -1,    -1,   580,
      -1,    -1,   583,    -1,    -1,    -1,   587,   588,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,
      -1,   602,   603,   604,   605,   606,   607,    -1,   609,    -1,
      -1,    -1,   613,    -1,    -1,   616,    -1,   618,    -1,     5,
     621,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    -1,    -1,    23,    24,    25,
      26,    27,    -1,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    54,    55,
      -1,    57,    -1,    -1,    -1,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    -1,    75,
      -1,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    -1,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
      -1,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,    -1,    -1,    -1,   141,   142,   143,    -1,   145,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,    -1,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,   177,   178,   179,   180,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,    -1,
     206,    -1,    -1,    -1,    -1,    -1,   212,    -1,    -1,    -1,
     216,   217,   218,   219,   220,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,    -1,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
     246,    -1,    -1,   249,    -1,    -1,    -1,   253,    -1,    -1,
     256,   257,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,   279,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,    -1,   355,
      -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,    -1,    -1,    -1,    -1,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,    -1,
      -1,   437,    -1,   439,   440,    -1,   442,    -1,    -1,    -1,
     446,    -1,    -1,   449,   450,   451,   452,   453,    -1,    -1,
      -1,   457,   458,   459,   460,   461,   462,   463,    -1,   465,
     466,    -1,   468,    -1,    -1,    -1,    -1,   473,   474,   475,
      -1,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
      -1,   487,    -1,   489,    -1,   491,    -1,    -1,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,    -1,
     516,   517,   518,   519,    -1,    -1,    -1,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,    -1,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,    -1,
     566,   567,   568,    -1,   570,   571,    -1,   573,   574,    -1,
      -1,    -1,    -1,    -1,   580,    -1,    -1,   583,    -1,    -1,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,   607,    -1,   609,    -1,    -1,    -1,   613,    -1,    -1,
     616,    -1,   618,    -1,     5,   621,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      -1,    -1,    23,    24,    25,    26,    27,    -1,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    -1,    -1,    -1,    -1,
      51,    52,    -1,    54,    55,    -1,    57,    -1,    -1,    -1,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    -1,    75,    -1,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    -1,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,    -1,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,    -1,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,   177,   178,   179,   180,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,    -1,   206,    -1,    -1,    -1,    -1,
      -1,   212,    -1,    -1,    -1,   216,   217,   218,   219,   220,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,   246,    -1,    -1,   249,    -1,
      -1,    -1,   253,    -1,    -1,   256,   257,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,   279,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,    -1,   355,    -1,    -1,    -1,   359,    -1,
     361,    -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,    -1,    -1,    -1,    -1,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,    -1,    -1,   437,    -1,   439,   440,
      -1,   442,    -1,    -1,    -1,   446,    -1,    -1,   449,   450,
     451,   452,   453,    -1,    -1,    -1,   457,   458,   459,   460,
     461,   462,   463,    -1,   465,   466,    -1,   468,    -1,    -1,
      -1,    -1,   473,   474,   475,    -1,    -1,    -1,    -1,   480,
      -1,    -1,    -1,   484,    -1,    -1,   487,    -1,   489,    -1,
     491,    -1,    -1,   494,   495,    -1,    -1,    -1,    -1,    -1,
     501,   502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,
     511,    -1,    -1,   514,    -1,   516,   517,   518,   519,    -1,
      -1,    -1,   523,    -1,   525,   526,   527,   528,   529,   530,
      -1,    -1,   533,   534,   535,   536,    -1,   538,   539,    -1,
      -1,   542,   543,   544,   545,    -1,    -1,   548,   549,    -1,
     551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,
     561,    -1,    -1,    -1,    -1,   566,   567,   568,    -1,   570,
     571,    -1,   573,   574,    -1,    -1,    -1,    -1,    -1,   580,
      -1,    -1,   583,    -1,    -1,    -1,   587,   588,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,
      -1,   602,   603,   604,   605,   606,    -1,    -1,   609,    -1,
      -1,    -1,   613,    -1,    -1,   616,    -1,   618,    -1,     5,
     621,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    -1,    -1,    23,    24,    25,
      26,    27,    -1,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    54,    55,
      -1,    57,    -1,    -1,    -1,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    -1,    75,
      -1,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    -1,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
      -1,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,    -1,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,    -1,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,   177,   178,   179,   180,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,    -1,
     206,    -1,    -1,    -1,    -1,    -1,   212,    -1,    -1,    -1,
     216,   217,   218,   219,   220,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,    -1,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
     246,    -1,    -1,   249,    -1,    -1,    -1,   253,    -1,    -1,
     256,   257,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,   279,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,    -1,   355,
      -1,    -1,    -1,   359,    -1,   361,    -1,   363,   364,    -1,
     366,    -1,   368,   369,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,    -1,   388,   389,   390,   391,   392,   393,   394,   395,
     396,    -1,    -1,    -1,    -1,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,    -1,
      -1,   437,    -1,   439,   440,    -1,   442,    -1,    -1,    -1,
     446,    -1,    -1,   449,   450,   451,   452,   453,    -1,    -1,
      -1,   457,   458,   459,   460,   461,   462,   463,    -1,   465,
     466,    -1,   468,    -1,    -1,    -1,    -1,   473,   474,   475,
      -1,    -1,    -1,    -1,   480,    -1,    -1,    -1,   484,    -1,
      -1,   487,    -1,   489,    -1,   491,    -1,    -1,   494,   495,
      -1,    -1,    -1,    -1,    -1,   501,   502,   503,    -1,   505,
     506,    -1,   508,    -1,    -1,   511,    -1,    -1,   514,    -1,
     516,   517,   518,   519,    -1,    -1,    -1,   523,    -1,   525,
     526,   527,   528,   529,   530,    -1,    -1,   533,   534,   535,
     536,    -1,   538,   539,    -1,    -1,   542,   543,   544,   545,
      -1,    -1,   548,   549,    -1,   551,   552,   553,   554,    -1,
      -1,    -1,    -1,    -1,   560,   561,    -1,    -1,    -1,    -1,
     566,   567,   568,    -1,   570,   571,    -1,   573,   574,    -1,
      -1,    -1,    -1,    -1,   580,    -1,    -1,   583,    -1,    -1,
      -1,   587,   588,    -1,    -1,    -1,    -1,    -1,    -1,   595,
      -1,    -1,   598,    -1,    -1,    -1,   602,   603,   604,   605,
     606,    -1,    -1,   609,    -1,    -1,    -1,   613,    -1,    -1,
     616,    -1,   618,    -1,     5,   621,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      -1,    -1,    23,    24,    25,    26,    27,    -1,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    -1,    -1,    -1,    -1,
      51,    52,    -1,    54,    55,    -1,    57,    -1,    -1,    -1,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    -1,    75,    -1,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    -1,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,    -1,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,    -1,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,   177,   178,   179,   180,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,    -1,   206,    -1,    -1,    -1,    -1,
      -1,   212,    -1,    -1,    -1,   216,   217,   218,   219,   220,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,   246,    -1,    -1,   249,    -1,
      -1,    -1,   253,    -1,    -1,   256,   257,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,   279,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,    -1,   355,    -1,    -1,    -1,   359,    -1,
     361,    -1,   363,   364,    -1,   366,    -1,   368,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,    -1,    -1,    -1,    -1,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,    -1,    -1,   437,    -1,   439,   440,
      -1,   442,    -1,    -1,    -1,   446,    -1,    -1,   449,   450,
     451,   452,   453,    -1,    -1,    -1,   457,   458,   459,   460,
     461,   462,   463,    -1,   465,   466,    -1,   468,    -1,    -1,
      -1,    -1,   473,   474,   475,    -1,    -1,    -1,    -1,   480,
      -1,    -1,    -1,   484,    -1,    -1,   487,    -1,   489,    -1,
     491,    -1,    -1,   494,   495,    -1,    -1,    -1,    -1,    -1,
     501,   502,   503,    -1,   505,   506,    -1,   508,    -1,    -1,
     511,    -1,    -1,   514,    -1,   516,   517,   518,   519,    -1,
      -1,    -1,   523,    -1,   525,   526,   527,   528,   529,   530,
      -1,    -1,   533,   534,   535,   536,    -1,   538,   539,    -1,
      -1,   542,   543,   544,   545,    -1,    -1,   548,   549,    -1,
     551,   552,   553,   554,    -1,    -1,    -1,    -1,    -1,   560,
     561,    -1,    -1,    -1,    -1,   566,   567,   568,    -1,   570,
     571,    -1,   573,   574,    -1,    -1,    -1,    -1,    -1,   580,
      -1,    -1,   583,    -1,    -1,    -1,   587,   588,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,   598,    -1,    -1,
      -1,   602,   603,   604,   605,   606,    -1,    -1,   609,    -1,
      -1,    -1,   613,    -1,    -1,   616,    -1,   618,    -1,     5,
     621,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    -1,    -1,    23,    24,    25,
      26,    27,    -1,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    54,    55,
      -1,    57,    -1,    -1,    -1,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    -1,    75,
      -1,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    -1,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    