/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.jpatest;

import com.mysql.clusterj.jpatest.AbstractJPABaseTest;
import com.mysql.clusterj.jpatest.model.BytePK;
import java.util.ArrayList;
import java.util.List;

public class BytePKTest
extends AbstractJPABaseTest {
    protected byte NUMBER_TO_INSERT = (byte)10;
    protected List<BytePK> instances = new ArrayList<BytePK>();

    @Override
    protected boolean getDebug() {
        return false;
    }

    public void test() {
        this.createInstances(this.NUMBER_TO_INSERT);
        this.remove();
        this.insert();
        this.update();
        this.failOnError();
    }

    protected void remove() {
        this.removeAll(BytePK.class);
    }

    protected void insert() {
        this.tx = this.em.getTransaction();
        this.tx.begin();
        int n = 0;
        for (byte by = 0; by < this.NUMBER_TO_INSERT; by = (byte)(by + 1)) {
            this.em.persist((Object)this.instances.get(by));
            ++n;
        }
        this.tx.commit();
    }

    protected void update() {
        byte by;
        BytePK bytePK;
        byte by2;
        this.tx.begin();
        for (by2 = 0; by2 < 10; by2 = (byte)(by2 + 1)) {
            bytePK = (BytePK)this.em.find(BytePK.class, (Object)by2);
            by = bytePK.getId();
            if (by != by2) {
                this.error("Expected BytePK.id " + by2 + " but got " + by);
            }
            bytePK.setByte_null_none((byte)(by2 + 10));
            bytePK.setByte_null_btree((byte)(by2 + 10));
            bytePK.setByte_null_hash((byte)(by2 + 10));
            bytePK.setByte_null_both((byte)(by2 + 10));
        }
        this.tx.commit();
        this.tx.begin();
        for (by2 = 0; by2 < this.NUMBER_TO_INSERT; by2 = (byte)(by2 + 1)) {
            bytePK = (BytePK)this.em.find(BytePK.class, (Object)by2);
            by = bytePK.getId();
            if (by != by2) {
                this.error("Expected BlobTypes.id " + by2 + " but got " + by);
            }
            this.errorIfNotEqual("Mismatch in byte_null_none", (byte)(by2 + 10), bytePK.getByte_null_none());
            this.errorIfNotEqual("Mismatch in byte_null_btree", (byte)(by2 + 10), bytePK.getByte_null_btree());
            this.errorIfNotEqual("Mismatch in byte_null_hash", (byte)(by2 + 10), bytePK.getByte_null_hash());
            this.errorIfNotEqual("Mismatch in byte_null_both", (byte)(by2 + 10), bytePK.getByte_null_both());
        }
        this.tx.commit();
    }

    protected void createInstances(int n) {
        for (byte by = 0; by < n; by = (byte)(by + 1)) {
            BytePK bytePK = new BytePK();
            bytePK.setId(by);
            bytePK.setByte_null_none(by);
            bytePK.setByte_null_btree(by);
            bytePK.setByte_null_hash(by);
            bytePK.setByte_null_both(by);
            this.instances.add(bytePK);
        }
    }
}

