/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.ScanOperationImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbIndexScanOperation;
import java.math.BigDecimal;
import java.math.BigInteger;

class IndexScanOperationImpl
extends ScanOperationImpl
implements IndexScanOperation {
    static final I18NHelper local = I18NHelper.getInstance(IndexScanOperationImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(IndexScanOperationImpl.class);
    private NdbIndexScanOperation ndbIndexScanOperation;

    public IndexScanOperationImpl(Table table, NdbIndexScanOperation ndbIndexScanOperation, ClusterTransactionImpl clusterTransactionImpl) {
        super(table, ndbIndexScanOperation, clusterTransactionImpl);
        this.ndbIndexScanOperation = ndbIndexScanOperation;
    }

    @Override
    public void setBoundBigInteger(Column column, IndexScanOperation.BoundType boundType, BigInteger bigInteger) {
        int n = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), Utility.convertValue(column, bigInteger));
        this.handleError(n, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundByte(Column column, IndexScanOperation.BoundType boundType, byte by) {
        int n = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), Utility.convertValue(column, by));
        this.handleError(n, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundBytes(Column column, IndexScanOperation.BoundType boundType, byte[] byArray) {
        int n = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), Utility.convertValue(column, byArray));
        this.handleError(n, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundDecimal(Column column, IndexScanOperation.BoundType boundType, BigDecimal bigDecimal) {
        int n = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), Utility.convertValue(column, bigDecimal));
        this.handleError(n, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundDouble(Column column, IndexScanOperation.BoundType boundType, Double d) {
        int n = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), Utility.convertValue(column, d));
        this.handleError(n, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundFloat(Column column, IndexScanOperation.BoundType boundType, Float f) {
        int n = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), Utility.convertValue(column, f.floatValue()));
        this.handleError(n, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundShort(Column column, IndexScanOperation.BoundType boundType, short s) {
        int n = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), Utility.convertValue(column, s));
        this.handleError(n, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundInt(Column column, IndexScanOperation.BoundType boundType, Integer n) {
        int n2 = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), Utility.convertValue(column, n));
        this.handleError(n2, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundLong(Column column, IndexScanOperation.BoundType boundType, long l) {
        int n = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), Utility.convertValue(column, l));
        this.handleError(n, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundString(Column column, IndexScanOperation.BoundType boundType, String string) {
        int n = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), Utility.convertValue(column, string));
        this.handleError(n, this.ndbIndexScanOperation);
    }

    private int convertBoundType(IndexScanOperation.BoundType boundType) {
        switch (boundType) {
            case BoundEQ: {
                return 4;
            }
            case BoundGE: {
                return 2;
            }
            case BoundGT: {
                return 3;
            }
            case BoundLE: {
                return 0;
            }
            case BoundLT: {
                return 1;
            }
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public void endBound(int n) {
        if (logger.isDetailEnabled()) {
            logger.detail("IndexScanOperationImpl.endBound(" + n + ")");
        }
        int n2 = this.ndbIndexScanOperation.end_of_bound(n);
        this.handleError(n2, this.ndbIndexScanOperation);
    }
}

