/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbScanFilter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;

class ScanFilterImpl
implements ScanFilter {
    static final I18NHelper local = I18NHelper.getInstance(ScanFilterImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(ScanFilterImpl.class);
    private NdbScanFilter ndbScanFilter;

    public ScanFilterImpl(NdbScanFilter ndbScanFilter) {
        this.ndbScanFilter = ndbScanFilter;
    }

    @Override
    public void begin() {
        int n = this.ndbScanFilter.begin(1);
        ScanFilterImpl.handleError(n, this.ndbScanFilter);
    }

    @Override
    public void begin(ScanFilter.Group group) {
        int n = this.ndbScanFilter.begin(this.convertGroup(group));
        ScanFilterImpl.handleError(n, this.ndbScanFilter);
    }

    @Override
    public void cmpBigInteger(ScanFilter.BinaryCondition binaryCondition, Column column, BigInteger bigInteger) {
        ByteBuffer byteBuffer = Utility.convertValue(column, bigInteger);
        int n = this.ndbScanFilter.cmp(this.convertCondition(binaryCondition), column.getColumnId(), byteBuffer, byteBuffer.capacity());
        ScanFilterImpl.handleError(n, this.ndbScanFilter);
    }

    @Override
    public void cmpBoolean(ScanFilter.BinaryCondition binaryCondition, Column column, boolean bl) {
        byte by = bl ? (byte)1 : 0;
        this.cmpByte(binaryCondition, column, by);
    }

    @Override
    public void cmpByte(ScanFilter.BinaryCondition binaryCondition, Column column, byte by) {
        ByteBuffer byteBuffer = Utility.convertValue(column, by);
        int n = this.ndbScanFilter.cmp(this.convertCondition(binaryCondition), column.getColumnId(), byteBuffer, byteBuffer.capacity());
        ScanFilterImpl.handleError(n, this.ndbScanFilter);
    }

    @Override
    public void cmpBytes(ScanFilter.BinaryCondition binaryCondition, Column column, byte[] byArray) {
        ByteBuffer byteBuffer = binaryCondition == ScanFilter.BinaryCondition.COND_LIKE ? Utility.convertValueForLikeFilter(column, byArray) : Utility.convertValue(column, byArray);
        int n = this.ndbScanFilter.cmp(this.convertCondition(binaryCondition), column.getColumnId(), byteBuffer, byteBuffer.capacity());
        ScanFilterImpl.handleError(n, this.ndbScanFilter);
    }

    @Override
    public void cmpDecimal(ScanFilter.BinaryCondition binaryCondition, Column column, BigDecimal bigDecimal) {
        ByteBuffer byteBuffer = Utility.convertValue(column, bigDecimal);
        int n = this.ndbScanFilter.cmp(this.convertCondition(binaryCondition), column.getColumnId(), byteBuffer, byteBuffer.capacity());
        ScanFilterImpl.handleError(n, this.ndbScanFilter);
    }

    @Override
    public void cmpDouble(ScanFilter.BinaryCondition binaryCondition, Column column, double d) {
        ByteBuffer byteBuffer = Utility.convertValue(column, d);
        int n = this.ndbScanFilter.cmp(this.convertCondition(binaryCondition), column.getColumnId(), byteBuffer, byteBuffer.capacity());
        ScanFilterImpl.handleError(n, this.ndbScanFilter);
    }

    @Override
    public void cmpFloat(ScanFilter.BinaryCondition binaryCondition, Column column, float f) {
        ByteBuffer byteBuffer = Utility.convertValue(column, f);
        int n = this.ndbScanFilter.cmp(this.convertCondition(binaryCondition), column.getColumnId(), byteBuffer, byteBuffer.capacity());
        ScanFilterImpl.handleError(n, this.ndbScanFilter);
    }

    @Override
    public void cmpShort(ScanFilter.BinaryCondition binaryCondition, Column column, short s) {
        ByteBuffer byteBuffer = Utility.convertValue(column, s);
        int n = this.ndbScanFilter.cmp(this.convertCondition(binaryCondition), column.getColumnId(), byteBuffer, byteBuffer.capacity());
        ScanFilterImpl.handleError(n, this.ndbScanFilter);
    }

    @Override
    public void cmpInt(ScanFilter.BinaryCondition binaryCondition, Column column, int n) {
        ByteBuffer byteBuffer = Utility.convertValue(column, n);
        int n2 = this.ndbScanFilter.cmp(this.convertCondition(binaryCondition), column.getColumnId(), byteBuffer, byteBuffer.capacity());
        ScanFilterImpl.handleError(n2, this.ndbScanFilter);
    }

    @Override
    public void cmpLong(ScanFilter.BinaryCondition binaryCondition, Column column, long l) {
        int n;
        ByteBuffer byteBuffer = Utility.convertValue(column, l);
        if (logger.isDetailEnabled()) {
            n = byteBuffer.limit() - byteBuffer.position();
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            byteBuffer.flip();
            logger.detail("column: " + column.getName() + " condition: " + binaryCondition.toString() + " value: " + l + Arrays.toString(byArray) + "(" + byteBuffer.capacity() + ")");
        }
        n = this.ndbScanFilter.cmp(this.convertCondition(binaryCondition), column.getColumnId(), byteBuffer, byteBuffer.capacity());
        ScanFilterImpl.handleError(n, this.ndbScanFilter);
    }

    @Override
    public void cmpString(ScanFilter.BinaryCondition binaryCondition, Column column, String string) {
        if (logger.isDebugEnabled()) {
            logger.debug(column.getName() + " " + (Object)((Object)binaryCondition) + " " + string);
        }
        ByteBuffer byteBuffer = binaryCondition == ScanFilter.BinaryCondition.COND_LIKE ? Utility.convertValueForLikeFilter(column, string) : Utility.convertValue(column, string);
        int n = this.ndbScanFilter.cmp(this.convertCondition(binaryCondition), column.getColumnId(), byteBuffer, byteBuffer.limit());
        ScanFilterImpl.handleError(n, this.ndbScanFilter);
    }

    @Override
    public void isNull(Column column) {
        int n = this.ndbScanFilter.isnull(column.getColumnId());
        ScanFilterImpl.handleError(n, this.ndbScanFilter);
    }

    @Override
    public void isNotNull(Column column) {
        int n = this.ndbScanFilter.isnotnull(column.getColumnId());
        ScanFilterImpl.handleError(n, this.ndbScanFilter);
    }

    @Override
    public void end() {
        int n = this.ndbScanFilter.end();
        ScanFilterImpl.handleError(n, this.ndbScanFilter);
    }

    private int convertCondition(ScanFilter.BinaryCondition binaryCondition) {
        switch (binaryCondition) {
            case COND_EQ: {
                return 4;
            }
            case COND_LE: {
                return 0;
            }
            case COND_LT: {
                return 1;
            }
            case COND_GE: {
                return 2;
            }
            case COND_GT: {
                return 3;
            }
            case COND_LIKE: {
                return 6;
            }
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    private int convertGroup(ScanFilter.Group group) {
        switch (group) {
            case GROUP_AND: {
                return 1;
            }
            case GROUP_NAND: {
                return 3;
            }
            case GROUP_OR: {
                return 2;
            }
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    protected static void handleError(int n, NdbScanFilter ndbScanFilter) {
        if (n == 0) {
            return;
        }
        Utility.throwError(n, ndbScanFilter.getNdbError());
    }

    protected static void handleError(Object object, NdbScanFilter ndbScanFilter) {
        if (object != null) {
            return;
        }
        Utility.throwError(null, ndbScanFilter.getNdbError());
    }

    @Override
    public void delete() {
        NdbScanFilter.delete(this.ndbScanFilter);
    }
}

