/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/*
** INFO.C - This is the ODBC sample driver code for
** exeting information functions.
*/

#include "myodbc.h"
#include <m_ctype.h>

uchar allowed_chars[]= {
  '\307','\374','\351','\342','\344','\340','\345','\347','\352','\353',
  '\350','\357','\356','\354','\304','\305','\311','\346','\306','\364',
  '\366','\362','\373','\371','\377','\326','\334','\341','\355','\363',
  '\372','\361','\321',0};

SQLRETURN SQL_API SQLGetInfo(SQLHDBC hdbc, SQLUSMALLINT fInfoType,
			     SQLPOINTER rgbInfoValue,
			     SQLSMALLINT cbInfoValueMax,
			     SQLSMALLINT FAR *pcbInfoValue)
{
  DBC FAR *dbc=(DBC FAR*) hdbc;
  char dummy2[16];
  SQLSMALLINT dummy;
  bool using_323;
  DBUG_ENTER("SQLGetInfo");
  DBUG_PRINT("enter",("fInfoType: %d",fInfoType));

  if (cbInfoValueMax)
    cbInfoValueMax--;
  if (!pcbInfoValue)
    pcbInfoValue=&dummy;
  if (!rgbInfoValue)
  {						/* This is because of VB5 */
    rgbInfoValue=dummy2;
    cbInfoValueMax=sizeof(dummy2)-1;
  }
  switch (fInfoType) {
  case SQL_MAX_USER_NAME_LEN:
#ifndef _UNIX_
    *(UNALIGNED SQLSMALLINT FAR *) rgbInfoValue = 16;
#endif /* IS NOT UNIX */

#ifdef _UNIX_
    *(SQLSMALLINT FAR *) rgbInfoValue = 16;
#endif /* IS UNIX */
    break;
  case SQL_DRIVER_ODBC_VER:
    *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,SQL_SPEC_STRING,
				   cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_ACTIVE_CONNECTIONS:
  case SQL_ACTIVE_STATEMENTS:
    *((SQLSMALLINT*) rgbInfoValue)=0;			/* No limits */
    break;
#ifdef SQL_ASYNC_MODE
  case SQL_ASYNC_MODE:
    *((SQLUINTEGER*) rgbInfoValue)= SQL_AM_NONE;
    break;
#endif
#ifdef SQL_CREATE_TABLE
  case SQL_CREATE_TABLE:
    *((SQLUINTEGER*) rgbInfoValue)= SQL_CT_CREATE_TABLE | SQL_CT_COLUMN_DEFAULT;
    break;
#endif
  case SQL_DATA_SOURCE_NAME:
    *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,dbc->dsn,
				   cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_DATABASE_NAME:
    *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,dbc->database,
				   cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_DRIVER_NAME:
    *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,"myodbc.dll",
				   cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_DBMS_VER:
    *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,
					 mysql_get_server_info(&dbc->mysql),
					 cbInfoValueMax)
				 - (char*) rgbInfoValue);
    break;
  case SQL_DRIVER_VER:
    *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,DRIVER_VERSION,
				   cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;

  case SQL_FETCH_DIRECTION:
    *((long*) rgbInfoValue)=SQL_FD_FETCH_NEXT | SQL_FD_FETCH_FIRST |
      SQL_FD_FETCH_LAST | SQL_FD_FETCH_PRIOR | SQL_FD_FETCH_ABSOLUTE |
      SQL_FD_FETCH_RELATIVE;
    if (dbc->flag & FLAG_NO_DEFAULT_CURSOR)
     *((long*) rgbInfoValue)&= ~ (long) SQL_FD_FETCH_PRIOR;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_ODBC_VER:
    *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,DRIVER_VERSION,
				   cbInfoValueMax)
			   - (char*) rgbInfoValue);
    *pcbInfoValue=sizeof(SQLSMALLINT);
    break;
  case SQL_ODBC_SAG_CLI_CONFORMANCE:
    *((SQLSMALLINT*) rgbInfoValue)=SQL_OSCC_COMPLIANT;
    *pcbInfoValue=sizeof(SQLSMALLINT);
    break;
  case SQL_SERVER_NAME:
    *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,
					 dbc->mysql.host_info,
					 cbInfoValueMax)
				 - (char*) rgbInfoValue);
    break;
  case SQL_SEARCH_PATTERN_ESCAPE:
    *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,"\\",cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_ODBC_SQL_CONFORMANCE:
  case SQL_ODBC_API_CONFORMANCE:
    *((SQLSMALLINT*) rgbInfoValue)=SQL_OAC_LEVEL1;	/* Lie to make things work */
    *pcbInfoValue=sizeof(SQLSMALLINT);
    break;
  case SQL_DBMS_NAME:
    *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,"MySQL",cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_ROW_UPDATES:
  case SQL_ACCESSIBLE_PROCEDURES:
  case SQL_PROCEDURES:
  case SQL_EXPRESSIONS_IN_ORDERBY:
  case SQL_NEED_LONG_DATA_LEN:
  case SQL_DATA_SOURCE_READ_ONLY:
  case SQL_ODBC_SQL_OPT_IEF:
  case SQL_LIKE_ESCAPE_CLAUSE:
  case SQL_ORDER_BY_COLUMNS_IN_SELECT:
   *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,"N",cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_OUTER_JOINS:
     if (dbc->mysql.protocol_version == MYSQL_3_21_PROTOCOL)   /* MySQL 3.21 */
       *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,
					    (dbc->flag & FLAG_OLD_ODBC_PROG) ?
					    "Y" : "F",
					    cbInfoValueMax)
				    - (char*) rgbInfoValue);
     else
      *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,"N",
					   cbInfoValueMax)
				   - (char*) rgbInfoValue);
     break;
#ifdef SQL_OJ_CAPABILITIES
  case SQL_OJ_CAPABILITIES:
    using_323=is_prefix(mysql_get_server_info(&dbc->mysql),"3.23");
    *((SQLUINTEGER*) rgbInfoValue)= (SQL_OJ_LEFT | SQL_OJ_NESTED |
				     SQL_OJ_NOT_ORDERED |
				     SQL_OJ_INNER | SQL_OJ_ALL_COMPARISON_OPS |
				     (using_323 ? SQL_OJ_RIGHT : 0));
    *pcbInfoValue=sizeof(SQLUINTEGER);
    break;
#endif
  case SQL_COLUMN_ALIAS:
  case SQL_ACCESSIBLE_TABLES:
  case SQL_MULT_RESULT_SETS:
  case SQL_MULTIPLE_ACTIVE_TXN:
  case SQL_MAX_ROW_SIZE_INCLUDES_LONG:
    *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,"Y",cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
#ifdef SQL_MAX_IDENTIFIER_LEN
  case SQL_MAX_IDENTIFIER_LEN:
    *((SQLUSMALLINT*) rgbInfoValue)=NAME_LEN;
    break;
#endif
  case SQL_CONCAT_NULL_BEHAVIOR:
    *((SQLSMALLINT*) rgbInfoValue)=SQL_CB_NULL;
    *pcbInfoValue=sizeof(SQLSMALLINT);
    break;
  case SQL_CURSOR_COMMIT_BEHAVIOR:		/* Lie */
  case SQL_CURSOR_ROLLBACK_BEHAVIOR:
    *((SQLSMALLINT*) rgbInfoValue)=SQL_CB_PRESERVE;
    *pcbInfoValue=sizeof(SQLSMALLINT);
    break;
#ifdef SQL_CURSOR_SENSITIVITY
  case SQL_CURSOR_SENSITIVITY:
    *((SQLUINTEGER*) rgbInfoValue)=SQL_UNSPECIFIED;
    break
#endif
  case SQL_DEFAULT_TXN_ISOLATION:
    *((long*) rgbInfoValue)= SQL_TXN_READ_UNCOMMITTED;
    *pcbInfoValue=sizeof(long);
    break;
#ifdef SQL_DESCRIBE_PARAMETER
  case SQL_DESCRIBE_PARAMETER:
    *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,"N",cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
#endif
  case SQL_TXN_ISOLATION_OPTION:
    *((long*) rgbInfoValue)= SQL_TXN_READ_UNCOMMITTED;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_IDENTIFIER_CASE:
    *((SQLSMALLINT*) rgbInfoValue)=SQL_IC_MIXED;
    *pcbInfoValue=sizeof(SQLSMALLINT);
    break;

  case SQL_IDENTIFIER_QUOTE_CHAR:
    using_323=is_prefix(mysql_get_server_info(&dbc->mysql),"3.23");
    *pcbInfoValue=(SQLSMALLINT)
      (strmake((char*) rgbInfoValue, (using_323 ? "`" : " "), cbInfoValueMax)
       - (char*) rgbInfoValue);
    break;
  case SQL_MAX_COLUMN_NAME_LEN:
   *((SQLSMALLINT*) rgbInfoValue)=NAME_LEN;
   *pcbInfoValue=sizeof(SQLSMALLINT);
   break;
  case SQL_MAX_CURSOR_NAME_LEN:
    *((SWORD*) rgbInfoValue)=NAME_LEN;
    *pcbInfoValue=sizeof(SWORD);
    break;
  case SQL_MAX_OWNER_NAME_LEN:
  case SQL_MAX_PROCEDURE_NAME_LEN:
  case SQL_MAX_QUALIFIER_NAME_LEN:
    *((SQLSMALLINT*) rgbInfoValue)=0;
    break;
  case SQL_MAX_TABLE_NAME_LEN:
    *((SQLSMALLINT*) rgbInfoValue)=NAME_LEN;
    break;
  case SQL_OWNER_TERM:
    *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,"owner",cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_PROCEDURE_TERM:
    *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,"procedure",
				   cbInfoValueMax) - (char*) rgbInfoValue);
    break;
  case SQL_QUALIFIER_NAME_SEPARATOR:
    *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,".", cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_QUALIFIER_TERM:
    *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,"database",cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_QUALIFIER_USAGE:
    *((long*) rgbInfoValue)=SQL_QU_DML_STATEMENTS | SQL_QU_TABLE_DEFINITION | SQL_QU_INDEX_DEFINITION;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_SCROLL_CONCURRENCY:
    *((long*) rgbInfoValue)=SQL_SCCO_READ_ONLY;
    break;
  case SQL_SCROLL_OPTIONS:
    *((long*) rgbInfoValue)=SQL_SO_STATIC | SQL_SO_FORWARD_ONLY;
    break;
  case SQL_TABLE_TERM:
    *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,"table",cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_TXN_CAPABLE:
    *((SQLSMALLINT*) rgbInfoValue)=SQL_TC_NONE;
    *pcbInfoValue=sizeof(SQLSMALLINT);
    break;
  case SQL_USER_NAME:
    *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,"user",cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_CONVERT_FUNCTIONS:
    *((long*) rgbInfoValue)=0L;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_SYSTEM_FUNCTIONS:
    *((long*) rgbInfoValue)= SQL_FN_SYS_DBNAME | SQL_FN_SYS_IFNULL | SQL_FN_SYS_USERNAME;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_NUMERIC_FUNCTIONS:
    *((long*) rgbInfoValue)=SQL_FN_NUM_ABS | SQL_FN_NUM_ACOS |
      SQL_FN_NUM_ASIN | SQL_FN_NUM_ATAN | SQL_FN_NUM_ATAN2 |
      SQL_FN_NUM_CEILING | SQL_FN_NUM_COS | SQL_FN_NUM_COT | SQL_FN_NUM_EXP |
      SQL_FN_NUM_FLOOR | SQL_FN_NUM_LOG | SQL_FN_NUM_MOD | SQL_FN_NUM_SIGN |
      SQL_FN_NUM_SIN | SQL_FN_NUM_SQRT | SQL_FN_NUM_TAN | SQL_FN_NUM_PI |
      SQL_FN_NUM_RAND | SQL_FN_NUM_DEGREES | SQL_FN_NUM_LOG10 |
      SQL_FN_NUM_POWER | SQL_FN_NUM_RADIANS | SQL_FN_NUM_ROUND |
      SQL_FN_NUM_TRUNCATE;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_STRING_FUNCTIONS:
    *((long*) rgbInfoValue)=SQL_FN_STR_CONCAT | SQL_FN_STR_INSERT |
      SQL_FN_STR_LEFT | SQL_FN_STR_LTRIM | SQL_FN_STR_LENGTH |
      SQL_FN_STR_LOCATE | SQL_FN_STR_LCASE | SQL_FN_STR_REPEAT |
      SQL_FN_STR_REPLACE | SQL_FN_STR_RIGHT | SQL_FN_STR_RTRIM |
      SQL_FN_STR_SUBSTRING | SQL_FN_STR_UCASE | SQL_FN_STR_ASCII |
      SQL_FN_STR_CHAR | SQL_FN_STR_LOCATE_2 | SQL_FN_STR_SOUNDEX |
      SQL_FN_STR_SPACE;
    *pcbInfoValue=sizeof(long);
     break;
  case SQL_TIMEDATE_FUNCTIONS:
    *((long*) rgbInfoValue)= SQL_FN_TD_NOW | SQL_FN_TD_CURDATE |
      SQL_FN_TD_DAYOFMONTH | SQL_FN_TD_DAYOFWEEK | SQL_FN_TD_DAYOFYEAR |
      SQL_FN_TD_MONTH | SQL_FN_TD_QUARTER | SQL_FN_TD_WEEK | SQL_FN_TD_YEAR |
      SQL_FN_TD_CURTIME | SQL_FN_TD_HOUR | SQL_FN_TD_MINUTE |
      SQL_FN_TD_SECOND | SQL_FN_TD_DAYNAME | SQL_FN_TD_MONTHNAME;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_CONVERT_BIGINT:
  case SQL_CONVERT_BIT:
  case SQL_CONVERT_CHAR:
  case SQL_CONVERT_DATE:
  case SQL_CONVERT_DECIMAL:
  case SQL_CONVERT_DOUBLE:
  case SQL_CONVERT_FLOAT:
  case SQL_CONVERT_INTEGER:
  case SQL_CONVERT_LONGVARCHAR:
  case SQL_CONVERT_NUMERIC:
  case SQL_CONVERT_REAL:
  case SQL_CONVERT_SMALLINT:
  case SQL_CONVERT_TIME:
  case SQL_CONVERT_TIMESTAMP:
  case SQL_CONVERT_TINYINT:
  case SQL_CONVERT_VARCHAR:
     /* lie that we can handle anything */
    *((long*) rgbInfoValue)=SQL_CVT_CHAR | SQL_CVT_NUMERIC | SQL_CVT_DECIMAL |
      SQL_CVT_INTEGER | SQL_CVT_SMALLINT | SQL_CVT_FLOAT | SQL_CVT_REAL |
      SQL_CVT_DOUBLE | SQL_CVT_VARCHAR | SQL_CVT_LONGVARCHAR |
      SQL_CVT_BIT | SQL_CVT_TINYINT | SQL_CVT_BIGINT |
      SQL_CVT_DATE | SQL_CVT_TIME | SQL_CVT_TIMESTAMP;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_CONVERT_BINARY:
  case SQL_CONVERT_VARBINARY:
  case SQL_CONVERT_LONGVARBINARY:
  case SQL_POSITIONED_STATEMENTS:
  case SQL_LOCK_TYPES:
  case SQL_BOOKMARK_PERSISTENCE:
  case SQL_OWNER_USAGE:
  case SQL_SUBQUERIES:
  case SQL_UNION:
  case SQL_TIMEDATE_ADD_INTERVALS:
  case SQL_TIMEDATE_DIFF_INTERVALS:
    *((long*) rgbInfoValue)=0L;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_QUOTED_IDENTIFIER_CASE:
    *((SQLUSMALLINT*) rgbInfoValue)=SQL_IC_SENSITIVE;
    break;
  case SQL_POS_OPERATIONS:
    *((long*) rgbInfoValue)=SQL_POS_POSITION;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_ALTER_TABLE:
    *((long*) rgbInfoValue)=SQL_AT_ADD_COLUMN | SQL_AT_DROP_COLUMN;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_CORRELATION_NAME:
    *((SQLSMALLINT*) rgbInfoValue)=SQL_CN_DIFFERENT;
    *pcbInfoValue=sizeof(SQLSMALLINT);
    break;
  case SQL_NON_NULLABLE_COLUMNS:
    *((SQLSMALLINT*) rgbInfoValue)=SQL_NNC_NON_NULL;
    *pcbInfoValue=sizeof(SQLSMALLINT);
    break;
  case SQL_NULL_COLLATION:
    *((SQLSMALLINT*) rgbInfoValue)=SQL_NC_START;
    *pcbInfoValue=sizeof(SQLSMALLINT);
    break;
  case SQL_MAX_COLUMNS_IN_GROUP_BY:
  case SQL_MAX_COLUMNS_IN_ORDER_BY:
  case SQL_MAX_COLUMNS_IN_SELECT:
  case SQL_MAX_COLUMNS_IN_TABLE:
  case SQL_MAX_ROW_SIZE:
    *((SQLSMALLINT*) rgbInfoValue)=0;
    *pcbInfoValue=sizeof(SQLSMALLINT);
    break;
  case SQL_MAX_TABLES_IN_SELECT:
    *((SQLSMALLINT*) rgbInfoValue)=32;
    *pcbInfoValue=sizeof(SQLSMALLINT);
    break;
  case SQL_MAX_BINARY_LITERAL_LEN:
  case SQL_MAX_CHAR_LITERAL_LEN:
    *((long*) rgbInfoValue)=0;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_MAX_COLUMNS_IN_INDEX:
    *((SQLSMALLINT*) rgbInfoValue)=16;
    *pcbInfoValue=sizeof(SQLSMALLINT);
    break;
  case SQL_MAX_INDEX_SIZE:
    *((long*) rgbInfoValue)=120;
    *pcbInfoValue=sizeof(long);
    break;
#if (ODBCVER >= 0x0300)
  case SQL_MAX_IDENTIFIER_LENGTH:
    *((long*) rgbInfoValue)=NAME_LEN;
    *pcbInfoValue=sizeof(long);
    break;
#endif
  case SQL_MAX_STATEMENT_LEN:
    *((long*) rgbInfoValue)=net_buffer_length;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_QUALIFIER_LOCATION:
    *((SQLSMALLINT*) rgbInfoValue)=SQL_QL_START;
    *pcbInfoValue=sizeof(SQLSMALLINT);
    break;
  case SQL_GETDATA_EXTENSIONS:
   *((long*) rgbInfoValue)= SQL_GD_ANY_COLUMN | SQL_GD_ANY_ORDER |
     SQL_GD_BOUND;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_STATIC_SENSITIVITY:
   // *((long*) rgbInfoValue)=SQL_SS_DELETIONS | SQL_SS_UPDATES;
   *((long*) rgbInfoValue)=0;
    *pcbInfoValue=sizeof(long);
    break;
  case SQL_FILE_USAGE:
    *((SQLSMALLINT*) rgbInfoValue)=SQL_FILE_NOT_SUPPORTED;
    *pcbInfoValue=sizeof(SQLSMALLINT);
    break;
  case SQL_GROUP_BY:
    *((SQLSMALLINT*) rgbInfoValue)=SQL_GB_NO_RELATION;
    *pcbInfoValue=sizeof(SQLSMALLINT);
    break;
  case SQL_KEYWORDS:
    *pcbInfoValue=(SQLSMALLINT) (strmake((char*) rgbInfoValue,
				   "UNIQUE,ZEROFILL,UNSIGNED,BIGINT,BLOB,TINYBLOB,MEDIMUMBLOB,LONGBLOB,MEDIUMINT,PROCEDURE,SHOW,LIMIT,DEFAULT,TABLES,REGEXP,RLIKE,KEYS,TINYTEXT,MEDIUMTEXT",
				   cbInfoValueMax)
			   - (char*) rgbInfoValue);
    break;
  case SQL_SPECIAL_CHARACTERS:
  {
    /* "" */
     *pcbInfoValue=(SQLSMALLINT)
       (strmake((char*) rgbInfoValue,
		(char*) allowed_chars,
		cbInfoValueMax)
	- (char*) rgbInfoValue);
     break;
  }
  default:
  {
    char buff[80];
    sprintf(buff,"Unsupported option: %d to SQLGetInfo",fInfoType);
    DBUG_RETURN(set_dbc_error(dbc,"S1C00",buff,4000));
  }
  }
  DBUG_RETURN(SQL_SUCCESS);
}



/*
**	Function sets up a result set containing details of the types
**	supported by mysql.
*/

MYSQL_FIELD SQL_GET_TYPE_INFO_fields[] = {
  {"TYPE_NAME","GetTypeInfo",NULL,FIELD_TYPE_VAR_STRING,32,32,NOT_NULL_FLAG},
  {"DATA_TYPE","GetTypeInfo",NULL,FIELD_TYPE_SHORT,2,2,NOT_NULL_FLAG},
  {"PRECISION","GetTypeInfo",NULL,FIELD_TYPE_LONG,10,10},
  {"LITERAL_PREFIX","GetTypeInfo",NULL,FIELD_TYPE_VAR_STRING,1,1},
  {"LITERAL_SUFFIX","GetTypeInfo",NULL,FIELD_TYPE_VAR_STRING,1,1},
  {"CREATE_PARAMS","GetTypeInfo",NULL,FIELD_TYPE_VAR_STRING,15,15},
  {"NULLABLE","GetTypeInfo",NULL,FIELD_TYPE_SHORT,2,2,NOT_NULL_FLAG},
  {"CASE_SENSITIVE","GetTypeInfo",NULL,FIELD_TYPE_SHORT,2,2,NOT_NULL_FLAG},
  {"SEARCHABLE","GetTypeInfo",NULL,FIELD_TYPE_SHORT,2,2,NOT_NULL_FLAG},
  {"UNSIGNED_ATTRIBUTE","GetTypeInfo",NULL,FIELD_TYPE_SHORT,2,2},
  {"MONEY","GetTypeInfo",NULL,FIELD_TYPE_SHORT,2,2,NOT_NULL_FLAG},
  {"AUTO_INCREMENT","GetTypeInfo",NULL,FIELD_TYPE_SHORT,2,2},
  {"LOCAL_TYPE_NAME","GetTypeInfo",NULL,FIELD_TYPE_VAR_STRING,60,60},
  {"MINIMUM_SCALE","GetTypeInfo",NULL,FIELD_TYPE_SHORT,2,2},
  {"MAXIMUM_SCALE","GetTypeInfo",NULL,FIELD_TYPE_SHORT,2,2},
};

const uint SQL_GET_TYPE_INFO_FIELDS=array_elements(SQL_GET_TYPE_INFO_fields);
#define MYSQL_DATA_TYPES 33

char sql_searchable[6],sql_unsearchable[6],sql_nullable[6],sql_no_nulls[6],
     sql_bit[6],
     sql_tinyint[6],sql_smallint[6],sql_integer[6],sql_bigint[6],sql_float[6],
     sql_real[6],sql_double[6], sql_char[6],sql_varchar[6],sql_longvarchar[6],
     sql_timestamp[6], sql_decimal[6],sql_numeric[6],sql_varbinary[6],
     sql_time[6],sql_date[6],sql_longvarbinary[6];

char *SQL_GET_TYPE_INFO_values[MYSQL_DATA_TYPES][15]=
{
  {"tinyint",sql_bit,"3",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","Tiny integer",NULL,NULL},

  {"tinyint",sql_tinyint,"3",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","Tiny integer",NULL,NULL},
  {"tinyint unsigned",sql_tinyint,"3",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"1","0","0","Tiny integer unsigned",NULL,NULL},

  {"smallint",sql_smallint,"5",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","Short integer",NULL,NULL},
  {"smallint unsigned",sql_smallint,"5",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"1","0","0","Short integer unsigned",NULL,NULL},

  {"mediumint",sql_integer,"8",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","Medium integer",NULL,NULL},
  {"mediumint unsigned",sql_integer,"8",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"1","0","0","Medium integer unsigned",NULL,NULL},

  {"int",sql_integer,"10",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","integer",NULL,NULL},
  {"int unsigned",sql_integer,"10",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"1","0","0","integer unsigned",NULL,NULL},

  {"integer",sql_integer,"10",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","Integer",NULL,NULL},
  {"integer unsigned",sql_integer,"10",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"1","0","0","Integer unsigned",NULL,NULL},

  {"bigint",sql_bigint,"20",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","Longlong integer",NULL,NULL},
  {"bigint unsigned",sql_bigint,"20",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"1","0","0","Longlong integer unsigned",NULL,NULL},

  {"double",sql_double,"15",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","double","0","4"},
  {"double",sql_float,"15",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","double","0","4"},

  {"float",sql_real,"7",NULL,NULL,NULL,sql_nullable,
   "0",sql_unsearchable,"0","0","0","float","0","2"},

  {"decimal",sql_numeric,"15",NULL,NULL,"precision,scale",sql_nullable,
   "0",sql_searchable,"0","0","0","double","0","6"},
  {"decimal",sql_decimal,"15",NULL,NULL,"precision,scale",sql_nullable,
   "0",sql_searchable,"0","0","0","double","0","6"},

  {"char",sql_char,"255","'","'","maxlength",sql_nullable,
   "0",sql_searchable,"0","0","0","string",NULL,NULL},
  {"varchar",sql_varchar,"255","'","'","maxlength",sql_nullable,
   "0",sql_searchable,"0","0","0","variable length string",NULL,NULL},

  {"blob",sql_longvarbinary,"65535","'","'",NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","binary large object (0-65535)",NULL,NULL},
  {"text",sql_longvarchar,"65535","'","'",NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","large text object (0-65535)",NULL,NULL},
  {"tinyblob",sql_longvarbinary,"255","'","'",NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","binary large object (0-255) ",NULL,NULL},
  {"mediumblob",sql_longvarbinary,"16777215","'","'",NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","binary large object",NULL,NULL},
  {"mediumtext",sql_longvarchar,"16777215","'","'",NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","large text object",NULL,NULL},
  {"longblob",sql_longvarbinary,"2147483647","'","'",NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","binary large object, use mediumblob instead",NULL,NULL},

  {"timestamp",sql_timestamp,"14",NULL,NULL,NULL,sql_no_nulls,
   "0",sql_searchable,"0","0","0","timestamp","0","0"},
  {"time",sql_time,"6",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","time",NULL,NULL},
  {"date",sql_date,"10",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","date",NULL,NULL},
  {"datetime",sql_timestamp,"21",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","datetime","0","0"},
  {"year",sql_smallint,"4",NULL,NULL,NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","year",NULL,NULL},

  {"enum",sql_char,"255","'","'",NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","enum(value1,value2,value3...)",NULL,NULL},
  {"set",sql_char,"255","'","'",NULL,sql_nullable,
   "0",sql_searchable,"0","0","0","set(value1,value2,value3...)",NULL,NULL},
};


SQLRETURN SQL_API SQLGetTypeInfo(SQLHSTMT hstmt, SQLSMALLINT fSqlType)
{
  STMT FAR *stmt=(STMT FAR*) hstmt;
  uint i;
  DBUG_ENTER("SQLGetTypeInfo");
  DBUG_PRINT("enter",("fSqlType: %d",fSqlType));

  my_SQLFreeStmt(hstmt,MYSQL_RESET);
  /* Set up result Data dictionary. */

  stmt->result=(MYSQL_RES*) my_malloc(sizeof(MYSQL_RES),MYF(MY_ZEROFILL));
  stmt->result_array= (char**) my_malloc(sizeof(SQL_GET_TYPE_INFO_values),
					 MYF(MY_FAE | MY_ZEROFILL));

  if (fSqlType == SQL_ALL_TYPES)
  {
    memcpy((byte*) stmt->result_array,(byte*) SQL_GET_TYPE_INFO_values,
	   sizeof(SQL_GET_TYPE_INFO_values));
    stmt->result->row_count=MYSQL_DATA_TYPES;
  }
  else
  {
    for (i=0 ; i < MYSQL_DATA_TYPES ; i++)
    {
      if (atoi(SQL_GET_TYPE_INFO_values[i][1]) == fSqlType)
      {
	memcpy((gptr) &stmt->result_array[stmt->result->row_count++ * SQL_GET_TYPE_INFO_FIELDS],
	       (gptr) &SQL_GET_TYPE_INFO_values[i][0],
	       sizeof(char*)*SQL_GET_TYPE_INFO_FIELDS);
      }
    }
  }
  mysql_link_fields(stmt,SQL_GET_TYPE_INFO_fields,
		    SQL_GET_TYPE_INFO_FIELDS);
  DBUG_RETURN(SQL_SUCCESS);
}


static SQLUSMALLINT exists[100];

void init_getfunctions(void)
{
  DBUG_ENTER("init_getfunctions");
  memset(exists, 0, sizeof(exists));
  exists[SQL_API_SQLALLOCCONNECT]=TRUE;
  exists[SQL_API_SQLFETCH]=TRUE;
  exists[SQL_API_SQLALLOCENV]=TRUE;
  exists[SQL_API_SQLFREECONNECT]=TRUE;
  exists[SQL_API_SQLALLOCSTMT]=TRUE;
  exists[SQL_API_SQLFREEENV]=TRUE;
  exists[SQL_API_SQLBINDCOL]=TRUE;
  exists[SQL_API_SQLFREESTMT]=TRUE;
  exists[SQL_API_SQLCANCEL]=TRUE;       /* Same as SQLFREESTMT */
  exists[SQL_API_SQLGETCURSORNAME]=TRUE;
  exists[SQL_API_SQLCOLATTRIBUTES]=TRUE;
  exists[SQL_API_SQLNUMRESULTCOLS]=TRUE;
  exists[SQL_API_SQLCONNECT]=TRUE;
  exists[SQL_API_SQLPREPARE]=TRUE;
  exists[SQL_API_SQLDESCRIBECOL]=TRUE;
  exists[SQL_API_SQLROWCOUNT]=TRUE;
  exists[SQL_API_SQLDISCONNECT]=TRUE;
  exists[SQL_API_SQLSETCURSORNAME]=FALSE;
  exists[SQL_API_SQLERROR]=TRUE;
  exists[SQL_API_SQLSETPARAM]=TRUE;
  exists[SQL_API_SQLEXECDIRECT]=TRUE;
  exists[SQL_API_SQLTRANSACT]=TRUE;		/* Lie */
  exists[SQL_API_SQLEXECUTE]=TRUE;

  exists[SQL_API_SQLBINDPARAMETER]=TRUE;
  exists[SQL_API_SQLGETTYPEINFO]=TRUE;
  exists[SQL_API_SQLCOLUMNS]=TRUE;
  exists[SQL_API_SQLPARAMDATA]=TRUE;
  exists[SQL_API_SQLDRIVERCONNECT]=TRUE;
  exists[SQL_API_SQLPUTDATA]=TRUE;
  exists[SQL_API_SQLGETCONNECTOPTION]=TRUE;
  exists[SQL_API_SQLSETCONNECTOPTION]=TRUE;	/* Lie */
  exists[SQL_API_SQLGETDATA]=TRUE;
  exists[SQL_API_SQLSETSTMTOPTION]=TRUE;	/* Lie */
  exists[SQL_API_SQLGETFUNCTIONS]=TRUE;
  exists[SQL_API_SQLSPECIALCOLUMNS]=TRUE;
  exists[SQL_API_SQLGETINFO]=TRUE;
  exists[SQL_API_SQLSTATISTICS]=TRUE;
  exists[SQL_API_SQLGETSTMTOPTION]=TRUE;
  exists[SQL_API_SQLTABLES]=TRUE;

  exists[SQL_API_SQLBROWSECONNECT]=FALSE;
  exists[SQL_API_SQLNUMPARAMS]=TRUE;
  exists[SQL_API_SQLCOLUMNPRIVILEGES]=FALSE;
  exists[SQL_API_SQLPARAMOPTIONS]=FALSE;
  exists[SQL_API_SQLDATASOURCES]=TRUE;	/* Implemented by the ODBC manager */
  exists[SQL_API_SQLPRIMARYKEYS]=TRUE;
  exists[SQL_API_SQLDESCRIBEPARAM]=TRUE;
  exists[SQL_API_SQLPROCEDURECOLUMNS]=FALSE;
  exists[SQL_API_SQLDRIVERS]=FALSE;
  exists[SQL_API_SQLPROCEDURES]=FALSE;
  exists[SQL_API_SQLEXTENDEDFETCH]=TRUE;
  exists[SQL_API_SQLSETPOS]=TRUE;
  exists[SQL_API_SQLFOREIGNKEYS]=TRUE;    /* Returns always a empty set */
  exists[SQL_API_SQLSETSCROLLOPTIONS]=TRUE;
  exists[SQL_API_SQLMORERESULTS]=TRUE;
  exists[SQL_API_SQLTABLEPRIVILEGES]=FALSE;
  exists[SQL_API_SQLNATIVESQL]=TRUE;

  /* Make some integers to strings for easy init of string arrays */
  int2str(SQL_SEARCHABLE,sql_searchable,-10);
  int2str(SQL_UNSEARCHABLE,sql_unsearchable,-10);
  int2str(SQL_NULLABLE,sql_nullable,-10);
  int2str(SQL_NO_NULLS,sql_no_nulls,-10);
  int2str(SQL_BIT,sql_bit,-10);
  int2str(SQL_TINYINT,sql_tinyint,-10);
  int2str(SQL_SMALLINT,sql_smallint,-10);
  int2str(SQL_INTEGER,sql_integer,-10);
  int2str(SQL_BIGINT,sql_bigint,-10);
  int2str(SQL_DECIMAL,sql_decimal,-10);
  int2str(SQL_NUMERIC,sql_numeric,-10);
  int2str(SQL_REAL,sql_real,-10);
  int2str(SQL_FLOAT,sql_float,-10);
  int2str(SQL_DOUBLE,sql_double,-10);
  int2str(SQL_CHAR,sql_char,-10);
  int2str(SQL_VARCHAR,sql_varchar,-10);
  int2str(SQL_LONGVARCHAR,sql_longvarchar,-10);
  int2str(SQL_LONGVARBINARY,sql_longvarbinary,-10);
  int2str(SQL_VARBINARY,sql_varbinary,-10);
  int2str(SQL_TIMESTAMP,sql_timestamp,-10);
  int2str(SQL_DATE,sql_date,-10);
  int2str(SQL_TIME,sql_time,-10);
  DBUG_VOID_RETURN;
}



SQLRETURN SQL_API SQLGetFunctions(SQLHDBC hdbc,SQLUSMALLINT fFunction,
				SQLUSMALLINT FAR *pfExists)
{
  DBC FAR *dbc=(DBC FAR*) hdbc;
  DBUG_ENTER("SQLGetFunctions");
  DBUG_PRINT("enter",("fFunction: %d",fFunction));

  if (fFunction == SQL_API_ALL_FUNCTIONS)
  {
    memcpy((char FAR *) pfExists,(char FAR *) exists,sizeof(exists));
  }
  else
  {
    *pfExists=exists[fFunction];
  }
  DBUG_RETURN(SQL_SUCCESS);
}
