// The following code can be used as a template.  Simply
// substitute the appropriate url, login, and password, and then substitute the
// SQL statement you want to send to the database.
                
//----------------------------------------------------------------------------
//
// Module:      testsql.java
//----------------------------------------------------------------------------
package test;
                
import java.net.URL;
import java.sql.*;

class testsql {

public static void main (String args[]) 
{
//        String url   = "jdbc:mysql://143.53.46.2:3333/test";
  String url   = "jdbc:mysql://localhost/test?user=media_user;password=eimc_db";
//  String url = "jdbc:mysql:?user=media_user;password=eimc_db;command=status";
  String query = "SELECT * FROM jdbc";

  try {
    // Load the jdbc-odbc bridge driver
    Class.forName ("gwe.sql.gweMysqlDriver");
    DriverManager.setLogStream(System.out);

    // Attempt to connect to a driver.  Each one
    // of the registered drivers will be loaded until
    // one is found that can process this URL
                
    //Connection con = DriverManager.getConnection (url, "media_user", "eimc_db");
    Connection con = DriverManager.getConnection (url);

                // If we were unable to connect, an exception
                // would have been thrown.  So, if we get here,
                // we are successfully connected to the URL
        
                // Check for, and display and warnings generated
                // by the connect.
        
                checkForWarning (con.getWarnings ());
                
                // Get the DatabaseMetaData object and display
                // some information about the connection

                DatabaseMetaData dma = con.getMetaData ();
                System.out.println("\nConnected to " + dma.getURL());
                System.out.println("Driver       " + dma.getDriverName());
                System.out.println("Version      " + dma.getDriverVersion());
                System.out.println(""); 
ResultSet rs;

rs = dma.getTables(null, null, "%", null);
if (rs != null)
{
  dispResultSet (rs);
  System.out.println("\nabove Tables\n"); 
}

//rs = dma.getIndexInfo(null, null, "jdbc", false, true);
rs = dma.getIndexInfo(null, null, "jdbc", true, true);
if (rs != null)
{
  dispResultSet (rs);
  System.out.println("\nabove IndexInfo\n"); 
}

rs = dma.getPrimaryKeys(null, null, "jdbc");
if (rs != null)
{
  dispResultSet (rs);
  System.out.println("\nabove PrimaryKeys\n"); 
}

rs = dma.getColumns(null, null, "jdbc", "%");
if (rs != null)
{
  dispResultSet (rs);
  System.out.println("\nabove Columns\n"); 
} 

                // Create a Statement object so we can submit
                // SQL statements to the driver 
                
                Statement stmt = con.createStatement ();
                
                // Submit a query, creating a ResultSet object
        
                rs = stmt.executeQuery (query);
                
                // Display all columns and rows from the result set
                
                dispResultSet (rs);
                
                // Close the result set
                
                rs.close();
                        
                // Close the statement
                        
                stmt.close();

                // Close the connection
                
                con.close();
        }       
        catch (SQLException ex) {
                
                // A SQLException was generated.  Catch it and
                // display the error information.  Note that there
                // could be multiple error objects chained
                // together
                
        System.out.println ("\n*** SQLException caught ***\n");
                
        while (ex != null) { 
                System.out.println ("SQLState: " +
                                ex.getSQLState ());
                System.out.println ("Message:  " + ex.getMessage ());
                System.out.println ("Vendor:   " +
                                ex.getErrorCode ());
                ex = ex.getNextException ();
                System.out.println ("");
                }
        }       
        catch (java.lang.Exception ex) {
                
                // Got some other type of exception.  Dump it.
                
                ex.printStackTrace ();
        }       
}               
                
//-------------------------------------------------------------------
// checkForWarning
// Checks for and displays warnings.  Returns true if a warning
// existed
//-------------------------------------------------------------------
                                
private static boolean checkForWarning (SQLWarning warn)
                throws SQLException  {
        boolean rc = false;     
                
        // If a SQLWarning object was given, display the
        // warning messages.  Note that there could be
        // multiple warnings chained together
        
        if (warn != null) {
                System.out.println ("\n *** Warning ***\n");  
                rc = true;
                while (warn != null) {
                        System.out.println ("SQLState: " +
                                warn.getSQLState ());
                        System.out.println ("Message:  " +
                                warn.getMessage ());
                        System.out.println ("Vendor:   " +
                                warn.getErrorCode ());
                        System.out.println ("");
                        warn = warn.getNextWarning ();
                }               
        }
        return rc;
}       
                
//-------------------------------------------------------------------
// dispResultSet
// Displays all columns and rows in the given result set
//-------------------------------------------------------------------
        
private static void dispResultSet (ResultSet rs)
        throws SQLException
{               
        int i;          
                                
        // Get the ResultSetMetaData.  This will be used for
        // the column headings  
                        
        ResultSetMetaData rsmd = rs.getMetaData ();
                        
        // Get the number of columns in the result set
                                
        int numCols = rsmd.getColumnCount ();
        
        // Display column headings
                
        for (i=1; i<=numCols; i++) {
                if (i > 1) System.out.print(",");
                //System.out.print(rsmd.getColumnName(i));
                System.out.print(rsmd.getColumnLabel(i));
        }
        System.out.println("");

        // Display data, fetching until end of the result set
                
        boolean more = rs.next ();
        while (more) {          
        
                // Loop through each column, getting the
                // column data and displaying
        
                for (i=1; i<=numCols; i++) {
                        if (i > 1) System.out.print(",");
                        System.out.print(rs.getString(i));
                }
                System.out.println("");
        
                // Fetch the next result set row
        
                more = rs.next ();
        }       
}       
        
}

