// $Id: test_select.java,v 1.1 1997/11/19 18:19:25 xzhu Exp $
// test_select.java
//
// port from perl script 'test-insert'
//
// Test of selecting on keys that consist of many parts
//
// Author: Xiaokun Kelvin ZHU
// Address: kelvinxz@iname.com
// 1997/11/14
//
// Copyright (C) 1997, X.K.ZHU
//   The `test_select.java' is free software and comes with NO WARRANTY of any
//   kind; you can redistribute it and/or modify it under the terms of the 
//   GNU Library General Public License as published by the Free Software 
//   Foundation; either version 2 of the License, or (at your option) any 
//   later version.
package bench;

import java.net.URL;
import java.sql.*;
import java.io.*;
import zxk.util.*;

public class test_select implements DBugConstant
{
  // Change this to make test harder/easier
  // This is the default value for the count of records used in this test.
  private  int loopCount = 1000;
  private int regions = 6;
  private int grps = 100;

  private long second_orig;
  private InputStream myIn;

  private boolean skipCreate;
  private boolean skipIn;
  private boolean skipDelete;
  private boolean verbose;
  private boolean fastInsert;
  private boolean lockTables;
  private boolean fast;
  private boolean force;
  private String debugStr = null;

  private test_select()
  {
    second_orig = -1;
    myIn = System.in;

    skipCreate = false;
    skipIn = false;
    skipDelete = false;
    verbose = false;
    fastInsert = false;
    lockTables = false;
    fast = false;
    force = false;
  }

  public void doit(String[] args)
  {
    String[] loName = { "fast", "fast_insert", "help", "host", "lock_tables",
      "password", "port", "skip_create", "skip_delete", "skip_in",
      "user", "debug" };
    int[] loHasArg = { GetOpt.NO_ARG, GetOpt.NO_ARG, GetOpt.NO_ARG,
      GetOpt.REQ_ARG, GetOpt.NO_ARG, GetOpt.OPT_ARG, GetOpt.REQ_ARG,
      GetOpt.NO_ARG, GetOpt.NO_ARG, GetOpt.NO_ARG, GetOpt.REQ_ARG,
      GetOpt.REQ_ARG };
    int[] loValue = { 'F', 'i', '?', 'h', 'l', 'p', 'P', 
      'c', 'd', 's', 'u', '#' };
    GetOpt g = new GetOpt();
    g.setInputArgs(args);
    g.setShortOption("#:?cdsiFh:lp::P:u:");
    g.setLongOptionName(loName);
    g.setLongOptionHasArg(loHasArg);
    g.setLongOptionValue(loValue);
    g.setOptionMode(GetOpt.LONG_OPT);

    String host = null;
    String port = null;
    String user = null;
    String password = null;
    String database = new String("test");
    int c;
    boolean tty_password = false;
    boolean error = false;

    try
    {
      while ( (c=g.getopt()) != GetOpt.EOF)
      {
        switch(c)
        {
          case '#':
            debugStr = g.getOptarg();
            break;
	  case 'F':
	    fast = true;
	    break;
	  case 'i':
	    fastInsert = true;
	    break;
	  case 'l':
	    lockTables = true;
	    break;
	  case 'c':
	    skipCreate = true;
	    break;
	  case 'd':
	    skipDelete = true;
	    break;
	  case 's':
	    skipIn = true;
	    break;
          case 'h':
	    host = g.getOptarg();
	    break;
	  case 'p':
	    password = g.getOptarg();
	    if (password == null)
	      tty_password = true;
	    break;
	  case 'u':
	    user = g.getOptarg();
	    break;
	  case 'P':
	    port = g.getOptarg();
	    break;
	  default:
	    String s = new Character((char)c).toString();
	    System.err.println("Illegal option character '" + s + "'");
	  case '?':
	    error = true;
	    break;
        }
      }
    }
    catch (GetOptException e)
    {
      System.err.println(e.getMessage());
      error = true;
    }

    if (error)
    {
      System.out.println("Usage: java test_connect [OPTIONS]");
      System.out.println("\n" +
  "-#, --debug=opt      debug string, default is NO, see DBug.java for details\n" +
  "-?, --help		display this help and exit\n" + 
  "-c, --skip_create	skip create tables\n" +
  "-d, --skip_delete	skip delete tables\n" +
  "-F, --fast		fast drop table.\n" +
  "-h, --host=#		connect to host\n" +
  "-i, --fast_insert	fast insert record\n" +
  "-l, --lock_tables	lock table\n" + 
  "-p, --password[=xxx]	password to use when connecting to server\n" +
  "                     If password is not given it's asked from the tty.\n" +
  "-P  --port=...	Port number to use for connection\n" + 
  "-s, --skip_in	skip `IN' at the select sentence" +
  "-u, --user=#		user for login if not current user\n");
      System.exit(1);
    }

    if (tty_password)
      password = getTtyPassword();
    
    if (debugStr == null)
      debugStr = new String("");
    if (zxk_debug)
      DBug.dbug.dbPush(debugStr);

    Connection conn;
    int rows;

    System.out.println("Testing the speed of selecting on keys that consist of many parts");
    System.out.println("The tests are done with a table that has "+loopCount+" rows.\n");
    //
    // Connect and start timing
    //
    long zsec = System.currentTimeMillis();
    conn = executeConnect(host, port, user, password, database);
    try
    {
      //
      // Create needed tables
      //
      if (!skipCreate)
      {
        System.out.println("Creating table...");
        Statement stmt = conn.createStatement();
        executeQuery("create table test (region char(1),id int(5),rev_id int(5), grp int(5), primary key (region,id), unique(region,rev_id), unique (region,grp,id))", stmt);
	if (lockTables)
          executeQuery("LOCK TABLES test WRITE", stmt);
        //
        // Insert loopCount records with
	// region:   "A" -> "E"
	// id:       0 -> count
	// rev_id:   count -> 0,
	// grp:      distributed values 0 -> count/100
        //
	System.out.println("Inserting " + loopCount + " rows");
        second_orig = System.currentTimeMillis();
	int half_done = loopCount/2;
	int revID = loopCount - 1;
        for (int i=0; i<loopCount; ++i, --revID)
	{
	  StringBuffer sb = null;
	  int grp = i * 3 % grps;
	  byte region = (byte)(65 + i % regions);
	  if (i > half_done)
            sb = new StringBuffer("insert into test (region,id,rev_id,grp) values (");
	  else
            sb = new StringBuffer("insert into test values (");
	  sb.append("'" + region + "'," + i + "," + revID + "," + grp + ')');
          executeQuery(sb.toString(), stmt);
	}
        System.out.println("Time to insert " + loopCount + " rows: " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
      }
      // 
      // Do some selects on the table
      //
      Statement stmt = conn.createStatement();
      System.out.println("Testing big selects on the table");
      second_orig = System.currentTimeMillis();
      for (int i=0; i<50; ++i)
      {
        int grp = i * 11 % grps;
	byte region = (byte)(65 + i % (regions + 1));
	executeQuery("select id from test where region='"+region+"'", stmt);
        executeQuery("select id from test where region='"+region+"' and id="+i,stmt);
        executeQuery("select id from test where region='"+region+"' and rev_id="+i,stmt);
        executeQuery("select id from test where region='"+region+"' and grp="+grp,stmt);
        executeQuery("select id from test where region>='B' and region<='C' and grp="+grp,stmt);
        executeQuery("select id from test where region>='B' and region<='E' and grp="+grp,stmt);
        executeQuery("select id from test where grp="+grp,stmt);//This is hard
      }
      System.out.println("Time for selct_big (50) " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
      //
      // Test select with man OR's
      //
      second_orig = System.currentTimeMillis();
      String s1 = new String("select * from test where ");
      int tmp = 0;
      for(int i=0; i<10; i++)
      {
        byte region = (byte)(65 + i % (regions + 1));
	StringBuffer orPart = new StringBuffer("grp = 1");
	StringBuffer inPart = null;
	StringBuffer orPart2 = new StringBuffer("region='A' and grp = 1");
	if (skipIn)
	  inPart = new StringBuffer("grp IN (1");
        for (int j=0; j<50; ++j)
	{
	  tmp ^= ((tmp + 63) + j) * 3 % 100000;
	  int t = tmp % grps;
	  byte t_region = (byte)(65 + tmp % regions);
	  orPart.append(" or grp=" + t);
	  orPart2.append(" or region='" + tmp + "' and grp=" + t);
	  if (skipIn)
	    inPart.append("," + t);
	}
	for (int j=0; j<5; ++j)
	{
	  executeQuery(s1 + orPart.toString(), stmt);
	  executeQuery(s1 + orPart2.toString(), stmt);
	  if (skipIn)
	    executeQuery(s1 + inPart.toString(), stmt);
	  // Do it a little harder by setting a extra range
	  executeQuery(s1 + "(" + orPart.toString() + ") and id < 50", stmt);
	  executeQuery(s1 + "((" + orPart2.toString() + ") or (region='A' and grp < 10)) and region <='B'", stmt);
	}
      }
      System.out.println("Time for select_range (10x5): " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
      if (lockTables)
        executeQuery("UNLOCK TABLES", stmt);
      if (!skipDelete)
        executeQuery("drop table test", stmt);
    }
    catch (SQLException e)
    {
      System.err.println(e.getMessage());
      e.printStackTrace();
      System.exit(1);
    }
    catch (Exception e)
    {
      System.err.println(e.getMessage());
      e.printStackTrace();
      System.exit(1);
    }
    executeClose(conn);

    // End of the test 
    // Finally print time used to execute the whole test
    System.out.println("Toal time: " + (System.currentTimeMillis() - zsec)/1000.0 + " sec.");
  }

  private Connection executeConnect(String host, String port, String user, 
    String password, String database)
  {
    boolean specialVersion = false;
    try
    {
      Class.forName ("gwe.sql.gweMysqlDriver");

      StringBuffer bufferURL = new StringBuffer();
      bufferURL.append("jdbc:mysql:");
      if (host != null && host.length() != 0)
      {
        bufferURL.append("//" + host);
        if (port != null && port.length() != 0)
          bufferURL.append(":" + port + "/");
        else
          bufferURL.append("/");
      }
      else if (port != null && port.length() != 0)
      {
        bufferURL.append("//localhost:" + port + "/");
      }
      bufferURL.append(database);
      if (user == null || user.length() == 0)
        user = System.getProperty("user.name");
      bufferURL.append("?user=" + user);
      if (password == null)
        password = "";
      bufferURL.append(";password=" + password);
      String url = new String(bufferURL);
//System.out.println(url);

      return DriverManager.getConnection (url);
    } 
    catch (SQLException e) 
    {
      System.out.println (e.getMessage ());
      System.exit(1);
    } 
    catch (Exception e)
    { 
      e.printStackTrace(); 
      System.exit(1);
    }
    return null;
  }

  private void executeClose(Connection conn)
  {
    try
    {
      conn.close();
    } 
    catch (SQLException e)
    { 
      e.printStackTrace();
      System.exit(1);
    }
  }

  private void executeQuery(String query, Statement stmt)
    throws SQLException
  {               
    try 
    {
      int rows = 0;
      if (debugStr.length() != 0)
        System.out.print(query);
      if (stmt.execute(query))
      {
        if (debugStr.length() != 0)
	{
          ResultSet rs = stmt.getResultSet();
          boolean hasMore = rs.next();
          if (hasMore)
          {
            while (hasMore) 
            {          
              rows++;    
	      hasMore = rs.next();
            }
          }       
	}
      }
      if (debugStr.length() != 0)
        System.out.println(": " + rows);
    }       
    catch (SQLException e)
    { throw e; }
  }       

  private String readLine()
  {
    StringBuffer line = new StringBuffer();
    int in = -1;
    
    try
    {
      while ( (in = myIn.read()) != 10 && in != 13 && in != -1)
      {
	//String s = new Character((char)in).toString();
        //System.out.print(" " + s);
        line.append(new Character((char)in));
      }
    } catch (IOException e)
    { e.printStackTrace(); }
    
    if (line.length() == 0 && in == -1)
      return null;
    return line.toString();
  }

  private String getTtyPassword()
  {
    System.out.print("Password:");
    return readLine();
  }

  public static void main (String[] args) 
  {
    test_select admin = new test_select();
    admin.doit(args);
  }
}
