/*
 * Decompiled with CFR 0.152.
 */
package com.ice.sqlclient;

import com.ice.sqlclient.JDBCAdapter;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class SQLClientHandler {
    private static final boolean TRACE_DRIVER = false;
    private static Hashtable handlers = new Hashtable();
    private static SQLClientHandler currentHandler = null;
    protected String name;
    protected boolean isOpen = false;
    protected int port;

    public static SQLClientHandler getCurrentHandler() {
        return currentHandler;
    }

    public static void setCurrentHandler(SQLClientHandler sQLClientHandler) {
        currentHandler = sQLClientHandler;
    }

    public static void addHandler(SQLClientHandler sQLClientHandler) {
        handlers.put(sQLClientHandler.getName(), sQLClientHandler);
    }

    public static SQLClientHandler getHandler(String string) {
        return (SQLClientHandler)handlers.get(string);
    }

    public static String[] getAllHandlerNames() {
        String[] stringArray = new String[handlers.size()];
        Enumeration enumeration = handlers.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public SQLClientHandler(String string) {
        this.name = string;
        handlers.put(string, this);
    }

    public String getName() {
        return this.name;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public abstract void setConnectInfo(String var1, String var2, String var3, String var4, String var5);

    public abstract void openConnection() throws SQLException;

    public abstract void closeConnection();

    public abstract DatabaseMetaData getMetaData() throws SQLException;

    public abstract void setCurrentDatabase(String var1) throws SQLException;

    public abstract boolean performSQLCommand(String var1) throws SQLException;

    public abstract String performSQLQuery(String var1) throws SQLException;

    public abstract JDBCAdapter performTableSQLQuery(String var1) throws SQLException;

    public abstract int performSQLUpdate(String var1) throws SQLException;

    public abstract String[] getDatabaseList() throws SQLException;

    public abstract String[] getDatabaseTableList() throws SQLException;

    public abstract JDBCAdapter getDatabaseTableInfo() throws SQLException;

    public abstract JDBCAdapter getTableColumnInfo(String var1) throws SQLException;

    public abstract void flushAllCaches();

    public abstract void flushTableCaches();

    public abstract int formatResults(ResultSet var1, StringBuffer var2, String var3) throws SQLException;
}

