// LaunchMySQLDlg.h : header file
//

#if !defined(AFX_LAUNCHMYSQLDLG_H__237FBB67_3ACC_11D4_AAB7_A068F5B2DA33__INCLUDED_)
#define AFX_LAUNCHMYSQLDLG_H__237FBB67_3ACC_11D4_AAB7_A068F5B2DA33__INCLUDED_

#include <winsock.h>
#include "c:\MYSQL\include\mysql.h"
#include "c:\MYSQL\include\errmsg.h"

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

// for the tree control...
#define MAX_DEPTH 100

/////////////////////////////////////////////////////////////////////////////
// CLaunchMySQLDlg dialog

class CLaunchMySQLDlg : public CDialog
{
// Construction
public:
	CLaunchMySQLDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CLaunchMySQLDlg)
	enum { IDD = IDD_LAUNCHMYSQL_DIALOG };
	CTreeCtrl	m_TreeCtrl;
	CString	m_Pathname;
	CString	m_AdminPath;
	CString	m_Status;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CLaunchMySQLDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	void setHTreeParent(HTREEITEM it, int level);
	HTREEITEM getHTreeParent(int level);
	void AddToTree(char *data, int level, int isParent);
	HTREEITEM m_ParentArray[MAX_DEPTH];

	void ReadSettings();
	void WriteSettings();
	void PopulateTree();
	void AddMyDataInfoToTree(MYSQL *myData, int BaseLevel);
	void AddOptionsToTree(MYSQL *myData, int BaseLevel);
	void AddNetInfoToTree(MYSQL *myData, int BaseLevel);
	void AddMySqlProcessToTree(MYSQL *myData, int BaseLevel);
	void AddDbToTree(MYSQL* myData, int BaseLevel);
	void AddDbInfoToTree(MYSQL* myData, char *DbName, int BaseLevel);
	void AddTableInfoToTree(MYSQL* myData, char *TableName, int BaseLevel);
	void ShowMySqlError(MYSQL *myData, char *from, char *when, char *remedy);
	bool MySqlConnected();
	void SetConnectStatus();
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CLaunchMySQLDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnButtonLaunch();
	afx_msg void OnButtonBrowse();
	afx_msg void OnButtonBrowse2();
	afx_msg void OnShutdown();
	afx_msg void OnItemexpandedTreeMysql(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnItemexpandingTreeMysql(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnClickTreeMysql(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDblclkTreeMysql(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnMinimize();
	afx_msg void OnStatus();
	afx_msg BOOL OnQueryEndSession();
	virtual void OnOK();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_LAUNCHMYSQLDLG_H__237FBB67_3ACC_11D4_AAB7_A068F5B2DA33__INCLUDED_)
