// LaunchMySQL.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "LaunchMySQL.h"
#include "LaunchMySQLDlg.h"
#include <process.h>
#include <direct.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

const int c_PathBufferSize = 256;
extern void WriteToDebugFile(CString myText);

/////////////////////////////////////////////////////////////////////////////
// CLaunchMySQLApp

BEGIN_MESSAGE_MAP(CLaunchMySQLApp, CWinApp)
	//{{AFX_MSG_MAP(CLaunchMySQLApp)
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLaunchMySQLApp construction

CLaunchMySQLApp::CLaunchMySQLApp()
{
}

/////////////////////////////////////////////////////////////////////////////
// CLaunchMySQLApp implementation


	// the spawn function needed short (8.3 dos style) path names so this was written.
void ConvertLongToShortFileName(CString LongName, CString &ShortName)
{
	char temp[c_PathBufferSize];
	if (GetShortPathName(LongName, temp, c_PathBufferSize) == 0)
		ShortName = LongName;
	else
		ShortName = temp;
}

extern void MergeDirFile(CString Directory, CString FileName, CString &Output);
extern void SplitDirFile(CString &Input, CString &Directory, CString &FileName);

	// a useful function for pathname parsing
void MergeDirFile(CString Directory, CString FileName, CString &Output)
{
	if (Directory.GetLength() > 0)
	{
		if (Directory.Right(1)[0] == '\\')
		{
			Output = Directory + FileName;
		}
		else
		{
			Output = Directory + "\\" + FileName;
		}
	}
	else
		Output = FileName;
}

	// a useful function for pathname parsing
void SplitDirFile(CString &Input, CString &Directory, CString &FileName)
{
	int LastSlash;
	LastSlash = Input.ReverseFind('\\');
	if (LastSlash != -1)
	{
		++LastSlash;
		Directory = Input.Left(LastSlash);
		FileName = Input.Right(Input.GetLength() - LastSlash);
	}
}



/////////////////////////////////////////////////////////////////////////////
// The one and only CLaunchMySQLApp object

CLaunchMySQLApp theApp;

	// get a reasonable default directory for MySQL
	// either /mysql/bin or the program directory
void CLaunchMySQLApp::InitMySqlDirectory()
{
	CFileFind Finder;
	m_MySqlDirectory = "c:\\mysql\\bin";
	if (Finder.FindFile(m_MySqlDirectory) == 0)
		m_MySqlDirectory = m_ProgramDirectory;

}

	// CLaunchMySQLApp initialization... the class wizard supplied
	// this useful description
BOOL CLaunchMySQLApp::InitInstance()
{
	char *buffer;
	buffer = new char[_MAX_PATH];
	_getcwd(buffer, _MAX_PATH);
	m_ProgramDirectory = buffer;
	delete buffer;
	InitMySqlDirectory();
	m_SqlStarted = 0;
	CLaunchMySQLDlg CLMDS;
	CLMDS.DoModal();
	return FALSE;
}

void CLaunchMySQLApp::StartMySqlServer()
{
	if (theApp.m_SqlStarted == 0)
	{
			// fire up the MySQL server by using spawn
		CString ShortName;
		char *args[2];
		ConvertLongToShortFileName(m_Pathname, ShortName);
		args[0] = (char *) LPCTSTR(ShortName);
		args[1] = NULL;
		_spawnv(_P_NOWAIT, ShortName, args);
		++theApp.m_SqlStarted;
	}
}

	// I put this at app level so exit instance could use it...
	// shutdown the MySQL server using the spawn command
bool CLaunchMySQLApp::ShutdownMySqlServer(bool verbose)
{
	bool DoIt = true;
	if (m_SqlStarted > 0)
	{
		if (verbose)
			DoIt = (AfxMessageBox("Press OK to shutdown the MySQL server.", MB_OKCANCEL) == IDOK);
		if (DoIt)
		{
			char *args[5];
			CString ShortName;
			ConvertLongToShortFileName(m_AdminPath, ShortName);
			args[0] = (char *) LPCTSTR(ShortName);
			args[1] = "-u";
			args[2] = "root";
			args[3] = "shutdown";
			args[4] = NULL;
			_spawnv(_P_WAIT, ShortName, args);
			--m_SqlStarted;
		}
	}
	return(DoIt);
}

	// when any of the close buttons is pressed, or
	// the program is stopped from the task manager,
	// this is called
int CLaunchMySQLApp::ExitInstance() 
{
	if (ShutdownMySqlServer(true))
		return CWinApp::ExitInstance();
	else
		return(0);
}
