/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management;

import com.mysql.management.MysqldResource;
import com.mysql.management.trace.Tracer;
import com.mysql.management.util.Files;
import com.mysql.management.util.NullPrintStream;
import com.mysql.management.util.QuietTestCase;
import com.mysql.management.util.Shell;
import com.mysql.management.util.Str;
import com.mysql.management.util.Streams;
import com.mysql.management.util.TestUtil;
import com.mysql.management.util.Threads;
import com.mysql.management.util.Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class MysqldResourceTest
extends QuietTestCase {
    private MysqldResource mysqldResource;
    private TestFileUtil fileUtil;
    private TestUtil testUtil;
    private Utils utils;
    private File baseDir;
    private File dataDir;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;

    protected void setUp() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        super.setUp();
        this.testUtil = new TestUtil();
        this.fileUtil = new TestFileUtil();
        this.utils = new Utils(this.fileUtil, new Shell.Factory(), new Streams(), new Threads(), new Str());
        this.baseDir = new File(this.fileUtil.testDir(), "MRTest");
        this.dataDir = new File(this.baseDir, "data");
        this.fileUtil.deleteTree(this.baseDir);
        if (this.baseDir.exists()) {
            this.warn("residual files");
        }
        this.mysqldResource = new MysqldResource(this.baseDir, this.dataDir, null, System.out, System.err, this.utils);
        this.mysqldResource.setKillDelay(this.testUtil.testKillDelay());
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    protected void tearDown() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.utils.threads().pause(50);
        try {
            if (this.mysqldResource.isRunning()) {
                this.mysqldResource.setKillDelay(this.testUtil.testKillDelay());
                this.mysqldResource.shutdown();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fileUtil.deleteTree(this.baseDir);
        super.tearDown();
        Object var3_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var3_3, joinPoint);
    }

    private void setSystemPropertiesToWinNT() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.mysqldResource.setOsAndArch("Windows NT", "x86");
        MysqldResourceTest.assertTrue((boolean)this.mysqldResource.isWindows());
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    private void setSytemPropertiesToLinux() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.mysqldResource.setOsAndArch("Linux", "i386");
        MysqldResourceTest.assertFalse((boolean)this.mysqldResource.isWindows());
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    public void testLaunch() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        HashMap<String, String> args = new HashMap<String, String>();
        String port = "" + this.testUtil.testPort();
        args.put("port", port);
        String url = "jdbc:mysql://localhost:" + port + "/test";
        String threadName = "testLaunch";
        MysqldResourceTest.assertFalse((String)"mysqld should not be running", (boolean)this.mysqldResource.isRunning());
        this.mysqldResource.start(threadName, args);
        Shell s1 = this.mysqldResource.getShell();
        this.assertRunning();
        int i = 0;
        while (i < 100 && !this.mysqldResource.isReadyForConnections()) {
            this.utils.threads().pause(25);
            ++i;
        }
        this.testUtil.assertConnectViaJDBC(url, true);
        this.mysqldResource.start(threadName, args);
        Shell s2 = this.mysqldResource.getShell();
        MysqldResourceTest.assertEquals((Object)s1, (Object)s2);
        MysqldResourceTest.assertTrue((boolean)s1.isDaemon());
        this.assertRunningThenShutdown();
        Object var8_9 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var8_9, joinPoint);
    }

    public void testUseDatabase() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String url = "jdbc:mysql://localhost:" + this.testUtil.testPort() + "/test";
        String threadName = "testLaunch";
        MysqldResourceTest.assertFalse((String)"mysqld should not be running", (boolean)this.mysqldResource.isRunning());
        this.startMysql(threadName);
        Shell s1 = this.mysqldResource.getShell();
        this.assertRunning();
        int i = 0;
        while (i < 100 && !this.mysqldResource.isReadyForConnections()) {
            this.utils.threads().pause(25);
            ++i;
        }
        this.testUtil.assertConnectViaJDBC(url);
        if (!this.mysqldResource.isWindows()) {
            File sockFile = new File(this.mysqldResource.getDataDir(), "mysql.sock");
            MysqldResourceTest.assertTrue((boolean)sockFile.exists());
        }
        this.mysqldResource.start(threadName, new HashMap());
        Shell s2 = this.mysqldResource.getShell();
        MysqldResourceTest.assertEquals((Object)s1, (Object)s2);
        MysqldResourceTest.assertTrue((boolean)s1.isDaemon());
        this.assertRunningThenShutdown();
        Object var6_8 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var6_8, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void startMysql(String string) {
        void threadName;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this), (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("port", "" + this.testUtil.testPort());
        this.mysqldResource.start((String)threadName, map);
        MysqldResourceTest.assertTrue((boolean)this.mysqldResource.isRunning());
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    public void testGetFileName() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        File mysqld = this.mysqldResource.getMysqldFilePointer();
        MysqldResourceTest.assertNotNull((Object)mysqld);
        String name = mysqld.getPath();
        MysqldResourceTest.assertTrue((String)name, (name.indexOf("mysqld") > 0 ? 1 : 0) != 0);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    public void testWindowsFileName() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.setSystemPropertiesToWinNT();
        String resourceName = this.mysqldResource.getResourceName();
        String fileName = this.mysqldResource.getMysqldFilePointer().getName();
        MysqldResourceTest.assertTrue((resourceName.indexOf("-nt.exe") > 0 ? 1 : 0) != 0);
        MysqldResourceTest.assertTrue((fileName.indexOf("-nt.exe") > 0 ? 1 : 0) != 0);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    public void testUglyPlatformName() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        MysqldResourceTest.assertEquals((String)"a_b_c_d", (String)this.mysqldResource.stripUnwantedChars("a b/c\\d"));
        this.mysqldResource.setOsAndArch("Bogus OS W/ Spaces", "\\Arch in Space");
        String resourceName = this.mysqldResource.getResourceName();
        MysqldResourceTest.assertTrue((resourceName.indexOf(32) == -1 ? 1 : 0) != 0);
        MysqldResourceTest.assertTrue((resourceName.indexOf(92) == -1 ? 1 : 0) != 0);
        String expected = "Bogus_OS_W__Spaces-_Arch_in_Space";
        MysqldResourceTest.assertTrue((resourceName.indexOf(expected) >= -1 ? 1 : 0) != 0);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    private void checkMysqldFile() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        File mysqld = this.mysqldResource.makeMysqld();
        MysqldResourceTest.assertTrue((boolean)mysqld.exists());
        MysqldResourceTest.assertTrue((mysqld.length() > 100L ? 1 : 0) != 0);
        Object var3_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var3_3, joinPoint);
    }

    public void testGetMysqldNative() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkMysqldFile();
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    public void testGetMysqldWinNT() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.setSystemPropertiesToWinNT();
        this.checkMysqldFile();
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    public void testGetMysqldLinux() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.setSytemPropertiesToLinux();
        this.checkMysqldFile();
        MysqldResourceTest.assertTrue((boolean)this.fileUtil.madeExecutable(this.mysqldResource.getMysqldFilePointer()));
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    public void testUnknownOs() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.mysqldResource.setOsAndArch("bogus", "x86");
        MissingResourceException expected = null;
        try {
            this.mysqldResource.makeMysqld();
        }
        catch (MissingResourceException e) {
            expected = e;
        }
        MysqldResourceTest.assertNotNull((String)("" + this.mysqldResource.getMysqldFilePointer()), (Object)expected);
        MysqldResourceTest.assertTrue((expected.getMessage().indexOf("bogus") > 0 ? 1 : 0) != 0);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    public void testCreateDbFiles() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        new Files().deleteTree(this.dataDir);
        File dbDataDir = new File(this.dataDir, "mysql");
        File host_frm = new File(dbDataDir, "host.frm");
        MysqldResourceTest.assertEquals((boolean)false, (boolean)host_frm.exists());
        MysqldResourceTest.assertEquals((boolean)false, (boolean)this.dataDir.exists());
        this.mysqldResource.ensureEssentialFilesExist();
        MysqldResourceTest.assertTrue((boolean)host_frm.exists());
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    private void assertRunningThenShutdown() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.assertRunning();
        this.mysqldResource.shutdown();
        this.assertNotRunning();
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    private void assertNotRunning() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        int i = 0;
        while (i < 500) {
            if (!this.mysqldResource.isRunning()) break;
            this.utils.threads().pause(25);
            ++i;
        }
        MysqldResourceTest.assertFalse((String)"mysqld should not be running", (boolean)this.mysqldResource.isRunning());
        Object var3_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var3_3, joinPoint);
    }

    private void assertRunning() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        int i = 0;
        while (i < 500) {
            if (this.mysqldResource.isRunning()) break;
            this.utils.threads().pause(25);
            ++i;
        }
        MysqldResourceTest.assertTrue((String)"mysqld should be running", (boolean)this.mysqldResource.isRunning());
        Object var3_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var3_3, joinPoint);
    }

    public void testServerOptions() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        Map optionsMap = this.mysqldResource.getServerOptions();
        String expectedBaseDir = this.mysqldResource.getBaseDir().getPath();
        MysqldResourceTest.assertEquals((Object)expectedBaseDir, optionsMap.get("basedir"));
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    public void testTestReporting() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream captured = new PrintStream(baos);
        this.mysqldResource = new MysqldResource(this.baseDir, this.dataDir, null, captured, captured, this.utils);
        this.mysqldResource.reportIfNoPidfile(true);
        captured.flush();
        MysqldResourceTest.assertEquals((String)"", (String)new String(baos.toByteArray()));
        this.mysqldResource.reportIfNoPidfile(false);
        captured.flush();
        String output = new String(baos.toByteArray());
        this.testUtil.assertContainsIgnoreCase(output, "pid-file not found");
        this.testUtil.assertContainsIgnoreCase(output, this.baseDir.toString());
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    public void testForceKill() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.startMysql("killMe");
        MysqldResourceTest.assertTrue((boolean)this.mysqldResource.isRunning());
        this.mysqldResource.issueForceKill();
        MysqldResourceTest.assertFalse((boolean)this.mysqldResource.isRunning());
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    public void testDestroyShell() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.startMysql("DestroyMe");
        MysqldResourceTest.assertTrue((boolean)this.mysqldResource.isRunning());
        this.mysqldResource.destroyShell();
        if (this.mysqldResource.isRunning()) {
            new MysqldResource(this.fileUtil.nullFile()).shutdown();
        }
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    public void testVersion() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        MysqldResourceTest.assertNotNull((Object)this.mysqldResource.getVersion());
        MysqldResourceTest.assertTrue((this.mysqldResource.getVersion().indexOf("5") >= 0 ? 1 : 0) != 0);
        this.mysqldResource.setVersion("5.11.42");
        MysqldResourceTest.assertEquals((String)"5.11.42", (String)this.mysqldResource.getVersion());
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    public void testNoPidFile() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        MysqldResourceTest.assertEquals((String)this.mysqldResource.pid(), (String)"No PID");
        this.startMysql("pid file");
        MysqldResourceTest.assertTrue((Integer.parseInt(this.mysqldResource.pid()) > 0 ? 1 : 0) != 0);
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    public void testTestFinalize() throws Throwable {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream captured = new PrintStream(baos);
        this.mysqldResource = new MysqldResource(this.baseDir, this.dataDir, "", captured, captured, this.utils);
        this.mysqldResource.finalize();
        captured.flush();
        String output = new String(baos.toByteArray());
        MysqldResourceTest.assertEquals((String)"", (String)output);
        NullPrintStream devNull = new NullPrintStream();
        String[] none = new String[]{};
        this.mysqldResource.setShell(new Shell.Default(none, "bogus", devNull, devNull));
        this.mysqldResource.finalize();
        captured.flush();
        output = new String(baos.toByteArray());
        this.testUtil.assertContainsIgnoreCase(output, "MysqldResource.initTrace");
        Object var7_7 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var7_7, joinPoint);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testUsage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream captured = new PrintStream(baos);
        PrintStream stdout = System.out;
        System.setOut(new PrintStream(captured));
        try {
            MysqldResource.main(new String[]{"--help"});
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            System.setOut(stdout);
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        System.setOut(stdout);
        MysqldResourceTest.assertTrue((baos.toString().indexOf("Usage") >= 0 ? 1 : 0) != 0);
        Object var7_8 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var7_8, joinPoint);
    }

    public void testJarName() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.setSystemPropertiesToWinNT();
        MysqldResourceTest.assertEquals((String)"win_share_dir.jar", (String)this.mysqldResource.shareJar());
        this.setSytemPropertiesToLinux();
        MysqldResourceTest.assertEquals((String)"share_dir.jar", (String)this.mysqldResource.shareJar());
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    public void testCanConnectToServer() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        MysqldResourceTest.assertFalse((boolean)this.mysqldResource.canConnectToServer(this.testUtil.testPort(), 1));
        this.startMysql("testCanConnectToServer");
        MysqldResourceTest.assertTrue((boolean)this.mysqldResource.canConnectToServer(this.testUtil.testPort(), 1));
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    public void testPlatformMapProperties() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.mysqldResource.setOsAndArch("Linux", "x86_64");
        MysqldResourceTest.assertEquals((String)"Linux-i386", (String)this.mysqldResource.os_arch());
        this.mysqldResource.setOsAndArch("Linux", "i686");
        MysqldResourceTest.assertEquals((String)"Linux-i386", (String)this.mysqldResource.os_arch());
        this.mysqldResource.setOsAndArch("Windows NT", "x86");
        MysqldResourceTest.assertEquals((String)"Win-x86", (String)this.mysqldResource.os_arch());
        this.mysqldResource.setOsAndArch("Windows XP", "x86");
        MysqldResourceTest.assertEquals((String)"Win-x86", (String)this.mysqldResource.os_arch());
        this.mysqldResource.setOsAndArch("Mac OS X", "i386");
        MysqldResourceTest.assertEquals((String)"Mac_OS_X-i386", (String)this.mysqldResource.os_arch());
        this.mysqldResource.setOsAndArch("Mac OS X", "ppc");
        MysqldResourceTest.assertEquals((String)"Mac_OS_X-ppc", (String)this.mysqldResource.os_arch());
        this.mysqldResource.setOsAndArch("SunOS", "sparc");
        MysqldResourceTest.assertEquals((String)"SunOS-sparc", (String)this.mysqldResource.os_arch());
        this.mysqldResource.setOsAndArch("SunOS", "i386");
        MysqldResourceTest.assertEquals((String)"SunOS-i386", (String)this.mysqldResource.os_arch());
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    public void testGetWindowsKillCommand() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        Properties props = new Properties();
        MysqldResourceTest.assertEquals((String)"kill.exe", (String)this.mysqldResource.getWindowsKillCommand(props));
        props.setProperty("windows-kill-command", " kill.exe ");
        MysqldResourceTest.assertEquals((String)"kill.exe", (String)this.mysqldResource.getWindowsKillCommand(props));
        props.setProperty("windows-kill-command", " ");
        MysqldResourceTest.assertEquals((String)"kill.exe", (String)this.mysqldResource.getWindowsKillCommand(props));
        props.setProperty("windows-kill-command", " foo.bar ");
        MysqldResourceTest.assertEquals((String)"foo.bar", (String)this.mysqldResource.getWindowsKillCommand(props));
        Object var3_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var3_3, joinPoint);
    }

    static {
        Factory factory = new Factory("MysqldResourceTest.java", Class.forName("com.mysql.management.MysqldResourceTest"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-setUp-com.mysql.management.MysqldResourceTest----void-"), 58);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-tearDown-com.mysql.management.MysqldResourceTest----void-"), 77);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkMysqldFile-com.mysql.management.MysqldResourceTest----void-"), 189);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testGetMysqldNative-com.mysql.management.MysqldResourceTest----void-"), 195);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testGetMysqldWinNT-com.mysql.management.MysqldResourceTest----void-"), 199);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testGetMysqldLinux-com.mysql.management.MysqldResourceTest----void-"), 204);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testUnknownOs-com.mysql.management.MysqldResourceTest----void-"), 211);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testCreateDbFiles-com.mysql.management.MysqldResourceTest----void-"), 223);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-assertRunningThenShutdown-com.mysql.management.MysqldResourceTest----void-"), 236);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-assertNotRunning-com.mysql.management.MysqldResourceTest----void-"), 242);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-assertRunning-com.mysql.management.MysqldResourceTest----void-"), 251);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testServerOptions-com.mysql.management.MysqldResourceTest----void-"), 260);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-setSystemPropertiesToWinNT-com.mysql.management.MysqldResourceTest----void-"), 91);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testTestReporting-com.mysql.management.MysqldResourceTest----void-"), 266);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testForceKill-com.mysql.management.MysqldResourceTest----void-"), 283);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testDestroyShell-com.mysql.management.MysqldResourceTest----void-"), 290);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testVersion-com.mysql.management.MysqldResourceTest----void-"), 300);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testNoPidFile-com.mysql.management.MysqldResourceTest----void-"), 307);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testTestFinalize-com.mysql.management.MysqldResourceTest---java.lang.Throwable:-void-"), 313);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testUsage-com.mysql.management.MysqldResourceTest----void-"), 335);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testJarName-com.mysql.management.MysqldResourceTest----void-"), 348);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testCanConnectToServer-com.mysql.management.MysqldResourceTest----void-"), 355);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testPlatformMapProperties-com.mysql.management.MysqldResourceTest----void-"), 361);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-setSytemPropertiesToLinux-com.mysql.management.MysqldResourceTest----void-"), 96);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testGetWindowsKillCommand-com.mysql.management.MysqldResourceTest----void-"), 388);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testLaunch-com.mysql.management.MysqldResourceTest---java.lang.Exception:-void-"), 101);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testUseDatabase-com.mysql.management.MysqldResourceTest---java.lang.Exception:-void-"), 128);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-startMysql-com.mysql.management.MysqldResourceTest-java.lang.String:-threadName:--void-"), 157);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testGetFileName-com.mysql.management.MysqldResourceTest----void-"), 164);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testWindowsFileName-com.mysql.management.MysqldResourceTest----void-"), 171);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testUglyPlatformName-com.mysql.management.MysqldResourceTest----void-"), 179);
    }

    private static class TestFileUtil
    extends Files {
        private List execFiles = new ArrayList();
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        TestFileUtil() {
        }

        /*
         * WARNING - void declaration
         */
        public void addExecutableRights(File file, PrintStream printStream, PrintStream printStream2) {
            void err;
            void out;
            void mysqld;
            File file2 = file;
            PrintStream printStream3 = printStream;
            PrintStream printStream4 = printStream2;
            Object[] objectArray = new Object[]{file2, printStream3, printStream4};
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
            Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
            this.execFiles.add(mysqld);
            super.addExecutableRights((File)mysqld, (PrintStream)out, (PrintStream)err);
            Object var9_9 = null;
            Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var9_9, joinPoint);
        }

        /*
         * WARNING - void declaration
         */
        public boolean madeExecutable(File file) {
            void file2;
            boolean bl;
            boolean bl2;
            File file3 = file;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)file3);
            Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
            boolean bl3 = bl2 = (bl = this.execFiles.contains(file2));
            Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }

        static {
            Factory factory = new Factory("MysqldResourceTest.java", Class.forName("com.mysql.management.MysqldResourceTest$TestFileUtil"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-addExecutableRights-com.mysql.management.MysqldResourceTest$TestFileUtil-java.io.File:java.io.PrintStream:java.io.PrintStream:-mysqld:out:err:--void-"), 403);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-madeExecutable-com.mysql.management.MysqldResourceTest$TestFileUtil-java.io.File:-file:--boolean-"), 409);
        }
    }
}

