/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.jmx.jboss;

import com.mysql.management.MysqldResourceTestImpl;
import com.mysql.management.jmx.TestFactory;
import com.mysql.management.jmx.jboss.JBossMysqldDynamicMBean;
import java.util.HashMap;
import javax.management.Attribute;
import junit.framework.TestCase;

public class JBossMysqldDynamicMBeanTest
extends TestCase {
    private String orig;

    protected void setUp() throws Exception {
        super.setUp();
        this.orig = System.getProperty("c-mxj.files.use-test-dir", "");
        System.setProperty("c-mxj.files.use-test-dir", Boolean.TRUE.toString());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        System.setProperty("c-mxj.files.use-test-dir", this.orig);
    }

    public void testNoAutoStart() throws Exception {
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(new HashMap());
        JBossMysqldDynamicMBean myBean = new JBossMysqldDynamicMBean(new TestFactory(mysqld));
        JBossMysqldDynamicMBeanTest.assertFalse((boolean)mysqld.isRunning());
        myBean.create();
        JBossMysqldDynamicMBeanTest.assertFalse((boolean)mysqld.isRunning());
    }

    public void testAutoStart() throws Exception {
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(new HashMap());
        JBossMysqldDynamicMBean myBean = new JBossMysqldDynamicMBean(new TestFactory(mysqld));
        JBossMysqldDynamicMBeanTest.assertFalse((boolean)mysqld.isRunning());
        String autostart = "autostart";
        String str_true = Boolean.TRUE.toString();
        myBean.setAttribute(new Attribute(autostart, str_true));
        JBossMysqldDynamicMBeanTest.assertFalse((boolean)mysqld.isRunning());
        myBean.create();
        JBossMysqldDynamicMBeanTest.assertTrue((boolean)mysqld.isRunning());
    }

    public void testCreateAndDestroy() throws Exception {
        HashMap<String, String> atts = new HashMap<String, String>();
        atts.put("autostart", Boolean.TRUE.toString());
        MysqldResourceTestImpl mysqld = new MysqldResourceTestImpl(null, null, atts, new HashMap());
        JBossMysqldDynamicMBean myBean = new JBossMysqldDynamicMBean(new TestFactory(mysqld));
        JBossMysqldDynamicMBeanTest.assertFalse((boolean)mysqld.isRunning());
        myBean.invoke("create", null, null);
        JBossMysqldDynamicMBeanTest.assertTrue((boolean)mysqld.isRunning());
        myBean.invoke("destroy", null, null);
        JBossMysqldDynamicMBeanTest.assertFalse((boolean)mysqld.isRunning());
    }
}

