/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.core.util.IAttributeNamesConstants;
import org.eclipse.jdt.core.util.IClassFileAttribute;
import org.eclipse.jdt.core.util.IConstantPool;
import org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.eclipse.jdt.core.util.IConstantValueAttribute;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.eclipse.jdt.internal.core.util.ClassFileAttribute;
import org.eclipse.jdt.internal.core.util.ClassFileStruct;
import org.eclipse.jdt.internal.core.util.ConstantValueAttribute;

public class FieldInfo
extends ClassFileStruct
implements IFieldInfo {
    private boolean isDeprecated;
    private boolean isSynthetic;
    private int accessFlags;
    private char[] name;
    private char[] descriptor;
    private int nameIndex;
    private int descriptorIndex;
    private int attributesCount;
    private int attributeBytes;
    private IConstantValueAttribute constantValueAttribute;
    private IClassFileAttribute[] attributes;

    public FieldInfo(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        this.accessFlags = this.u2At(classFileBytes, 0, offset);
        this.nameIndex = this.u2At(classFileBytes, 2, offset);
        IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.nameIndex);
        if (constantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.name = constantPoolEntry.getUtf8Value();
        this.descriptorIndex = this.u2At(classFileBytes, 4, offset);
        constantPoolEntry = constantPool.decodeEntry(this.descriptorIndex);
        if (constantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.descriptor = constantPoolEntry.getUtf8Value();
        this.attributesCount = this.u2At(classFileBytes, 6, offset);
        this.attributes = ClassFileAttribute.NO_ATTRIBUTES;
        int readOffset = 8;
        if (this.attributesCount != 0) {
            this.attributes = new IClassFileAttribute[this.attributesCount];
        }
        int attributesIndex = 0;
        int i = 0;
        while (i < this.attributesCount) {
            constantPoolEntry = constantPool.decodeEntry(this.u2At(classFileBytes, readOffset, offset));
            if (constantPoolEntry.getKind() != 1) {
                throw new ClassFormatException(3);
            }
            char[] attributeName = constantPoolEntry.getUtf8Value();
            if (this.equals(attributeName, IAttributeNamesConstants.DEPRECATED)) {
                this.isDeprecated = true;
                this.attributes[attributesIndex++] = new ClassFileAttribute(classFileBytes, constantPool, offset + readOffset);
            } else if (this.equals(attributeName, IAttributeNamesConstants.SYNTHETIC)) {
                this.isSynthetic = true;
                this.attributes[attributesIndex++] = new ClassFileAttribute(classFileBytes, constantPool, offset + readOffset);
            } else if (this.equals(attributeName, IAttributeNamesConstants.CONSTANT_VALUE)) {
                this.constantValueAttribute = new ConstantValueAttribute(classFileBytes, constantPool, offset + readOffset);
                this.attributes[attributesIndex++] = this.constantValueAttribute;
            } else {
                this.attributes[attributesIndex++] = new ClassFileAttribute(classFileBytes, constantPool, offset + readOffset);
            }
            readOffset = (int)((long)readOffset + (6L + this.u4At(classFileBytes, readOffset + 2, offset)));
            ++i;
        }
        this.attributeBytes = readOffset;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public IConstantValueAttribute getConstantValueAttribute() {
        return this.constantValueAttribute;
    }

    public char[] getDescriptor() {
        return this.descriptor;
    }

    public char[] getName() {
        return this.name;
    }

    public boolean hasConstantValueAttribute() {
        return this.constantValueAttribute != null;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    int sizeInBytes() {
        return this.attributeBytes;
    }

    public int getAttributeCount() {
        return this.attributesCount;
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public IClassFileAttribute[] getAttributes() {
        return this.attributes;
    }
}

