/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.HashMap;
import java.util.Stack;
import org.eclipse.core.internal.jobs.Deadlock;
import org.eclipse.core.internal.jobs.DeadlockDetector;
import org.eclipse.core.internal.jobs.OrderedLock;
import org.eclipse.core.internal.jobs.Worker;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.LockListener;

public class LockManager {
    protected LockListener lockListener;
    private DeadlockDetector locks = new DeadlockDetector();
    private HashMap suspendedLocks = new HashMap();

    public void aboutToRelease() {
        if (this.lockListener == null) {
            return;
        }
        try {
            this.lockListener.aboutToRelease();
        }
        catch (Exception e) {
            LockManager.handleException(e);
        }
        catch (LinkageError e) {
            LockManager.handleException(e);
        }
    }

    public boolean aboutToWait(Thread lockOwner) {
        if (this.lockListener == null) {
            return false;
        }
        try {
            return this.lockListener.aboutToWait(lockOwner);
        }
        catch (Exception e) {
            LockManager.handleException(e);
        }
        catch (LinkageError e) {
            LockManager.handleException(e);
        }
        return false;
    }

    void addLockThread(Thread thread, ISchedulingRule lock) {
        DeadlockDetector deadlockDetector = this.locks;
        synchronized (deadlockDetector) {
            this.locks.lockAcquired(thread, lock);
        }
    }

    void addLockWaitThread(Thread thread, ISchedulingRule lock) {
        DeadlockDetector deadlockDetector = this.locks;
        synchronized (deadlockDetector) {
            Deadlock found = this.locks.lockWaitStart(thread, lock);
            if (found != null) {
                ISchedulingRule[] toSuspend = found.getLocks();
                LockState[] suspended = new LockState[toSuspend.length];
                int i = 0;
                while (i < toSuspend.length) {
                    suspended[i] = LockState.suspend((OrderedLock)toSuspend[i]);
                    ++i;
                }
                HashMap hashMap = this.suspendedLocks;
                synchronized (hashMap) {
                    Stack<LockState[]> prevLocks = (Stack<LockState[]>)this.suspendedLocks.get(found.getCandidate());
                    if (prevLocks == null) {
                        prevLocks = new Stack<LockState[]>();
                    }
                    prevLocks.push(suspended);
                    this.suspendedLocks.put(found.getCandidate(), prevLocks);
                }
            }
        }
    }

    private static void handleException(Throwable e) {
        Status status;
        String message = Policy.bind("jobs.internalError");
        if (e instanceof CoreException) {
            status = new MultiStatus("org.eclipse.core.runtime", 2, message, e);
            status.merge(((CoreException)e).getStatus());
        } else {
            status = new Status(4, "org.eclipse.core.runtime", 2, message, e);
        }
        InternalPlatform.getDefault().log(status);
    }

    public boolean isEmpty() {
        return this.locks.isEmpty();
    }

    public boolean isLockOwner() {
        Thread current = Thread.currentThread();
        if (current instanceof Worker) {
            return true;
        }
        DeadlockDetector deadlockDetector = this.locks;
        synchronized (deadlockDetector) {
            return this.locks.contains(Thread.currentThread());
        }
    }

    public synchronized OrderedLock newLock() {
        return new OrderedLock(this);
    }

    void removeLockCompletely(Thread thread, ISchedulingRule rule) {
        DeadlockDetector deadlockDetector = this.locks;
        synchronized (deadlockDetector) {
            this.locks.lockReleasedCompletely(thread, rule);
        }
    }

    void removeLockThread(Thread thread, ISchedulingRule lock) {
        DeadlockDetector deadlockDetector = this.locks;
        synchronized (deadlockDetector) {
            this.locks.lockReleased(thread, lock);
        }
    }

    void removeLockWaitThread(Thread thread, ISchedulingRule lock) {
        DeadlockDetector deadlockDetector = this.locks;
        synchronized (deadlockDetector) {
            this.locks.lockWaitStop(thread, lock);
        }
    }

    void resumeSuspendedLocks(Thread owner) {
        LockState[] toResume;
        HashMap hashMap = this.suspendedLocks;
        synchronized (hashMap) {
            Stack prevLocks = (Stack)this.suspendedLocks.get(owner);
            if (prevLocks == null) {
                return;
            }
            toResume = (LockState[])prevLocks.pop();
            if (prevLocks.empty()) {
                this.suspendedLocks.remove(owner);
            }
        }
        int i = 0;
        while (i < toResume.length) {
            toResume[i].resume();
            ++i;
        }
    }

    public void setLockListener(LockListener listener) {
        this.lockListener = listener;
    }

    private static class LockState {
        private int depth;
        private OrderedLock lock;

        LockState() {
        }

        protected static LockState suspend(OrderedLock lock) {
            LockState state = new LockState();
            state.lock = lock;
            state.depth = lock.forceRelease();
            return state;
        }

        public void resume() {
            while (true) {
                try {
                    if (!this.lock.acquire(Long.MAX_VALUE)) continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            this.lock.setDepth(this.depth);
        }
    }
}

