/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class ConnectionProperties {
    private static final ArrayList PROPERTY_LIST = new ArrayList();
    private static final String CONNECTION_AND_AUTH_CATEGORY = "Connection/Authentication";
    private static final String HA_CATEGORY = "High Availability and Clustering";
    private static final String SECURITY_CATEGORY = "Security";
    private static final String PERFORMANCE_CATEGORY = "Performance Extensions";
    private static final String DEBUGING_PROFILING_CATEGORY = "Debuging/Profiling";
    private static final String MISC_CATEGORY = "Miscellaneous";
    private static final String[] propertyCategories = new String[]{"Connection/Authentication", "High Availability and Clustering", "Security", "Performance Extensions", "Debuging/Profiling", "Miscellaneous"};
    protected static final String ZERO_DATETIME_BEHAVIOR_EXCEPTION = "exception";
    protected static final String ZERO_DATETIME_BEHAVIOR_ROUND = "round";
    protected static final String ZERO_DATETIME_BEHAVIOR_CONVERT_TO_NULL = "convertToNull";
    private BooleanConnectionProperty allowLoadLocalInfile = new BooleanConnectionProperty("allowLoadLocalInfile", true, "Should the driver allow use of 'LOAD DATA LOCAL INFILE...' (defaults to 'true').", "3.0.3", "Security", Integer.MAX_VALUE);
    private BooleanConnectionProperty allowNanAndInf = new BooleanConnectionProperty("allowNanAndInf", false, "Should the driver allow NaN or +/- INF values in PreparedStatement.setDouble()?", "3.1.5", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty allowUrlInLocalInfile = new BooleanConnectionProperty("allowUrlInLocalInfile", false, "Should the driver allow URLs in 'LOAD DATA LOCAL INFILE' statements?", "3.1.4", "Security", Integer.MAX_VALUE);
    private BooleanConnectionProperty allowMultiQueries = new BooleanConnectionProperty("allowMultiQueries", false, "Allow the use of ';' to delimit multiple queries during one statement (true/false, defaults to 'false'", "3.1.1", "Security", 1);
    private BooleanConnectionProperty autoDeserialize = new BooleanConnectionProperty("autoDeserialize", false, "Should the driver automatically detect and de-serialize objects stored in BLOB fields?", "3.1.5", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty autoReconnect = new BooleanConnectionProperty("autoReconnect", false, "Should the driver try to re-establish bad connections?", "1.1", "High Availability and Clustering", 0);
    private BooleanConnectionProperty autoReconnectForPools = new BooleanConnectionProperty("autoReconnectForPools", false, "Use a reconnection strategy appropriate for connection pools (defaults to 'false')", "3.1.3", "High Availability and Clustering", 1);
    private BooleanConnectionProperty cacheCallableStatements = new BooleanConnectionProperty("cacheCallableStmts", false, "Should the driver cache the parsing stage of CallableStatements", "3.1.2", "Performance Extensions", Integer.MIN_VALUE);
    private BooleanConnectionProperty cacheServerConfiguration = new BooleanConnectionProperty("cacheServerConfiguration", false, "Should the driver cache the results of 'SHOW VARIABLES' and 'SHOW COLLATION' on a per-URL basis?", "3.1.5", "Performance Extensions", Integer.MIN_VALUE);
    private BooleanConnectionProperty cachePreparedStatements = new BooleanConnectionProperty("cachePrepStmts", false, "Should the driver cache the parsing stage of PreparedStatements?", "3.0.10", "Performance Extensions", Integer.MIN_VALUE);
    private BooleanConnectionProperty cacheResultSetMetadata = new BooleanConnectionProperty("cacheResultSetMetadata", false, "Should the driver cache ResultSetMetaData for Statements and PreparedStatements? (Req. JDK-1.4+, true/false, default 'false')", "3.1.1", "Performance Extensions", Integer.MIN_VALUE);
    private BooleanConnectionProperty capitalizeTypeNames = new BooleanConnectionProperty("capitalizeTypeNames", false, "Capitalize type names in DatabaseMetaData? (usually only useful when using WebObjects, true/false, defaults to 'false')", "2.0.7", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty clobberStreamingResults = new BooleanConnectionProperty("clobberStreamingResults", false, "This will cause a 'streaming' ResultSet to be automatically closed, and any oustanding data still streaming from the server to be discarded if another query is executed before all the data has been read from the server.", "3.0.9", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty continueBatchOnError = new BooleanConnectionProperty("continueBatchOnError", true, "Should the driver continue processing batch commands if one statement fails. The JDBC spec allows either way (defaults to 'true').", "3.0.3", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty detectServerPreparedStmts = new BooleanConnectionProperty("useServerPrepStmts", true, "Use server-side prepared statements if the server supports them? (defaults to 'true').", "3.1.0", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty dontUnpackBinaryResults = new BooleanConnectionProperty("dontUnpackBinaryResults", false, "Should the driver delay unpacking results from server-side prepared statements until the values are asked for?", "3.1.5", "Performance Extensions", Integer.MIN_VALUE);
    private BooleanConnectionProperty dumpQueriesOnException = new BooleanConnectionProperty("dumpQueriesOnException", false, "Should the driver dump the contents of the query sent to the server in the message for SQLExceptions?", "3.1.3", "Debuging/Profiling", Integer.MIN_VALUE);
    private BooleanConnectionProperty dynamicCalendars = new BooleanConnectionProperty("dynamicCalendars", false, "Should the driver retrieve the default calendar when required, or cache it per connection/session?", "3.1.5", "Performance Extensions", Integer.MIN_VALUE);
    private BooleanConnectionProperty elideSetAutoCommits = new BooleanConnectionProperty("elideSetAutoCommits", false, "If using MySQL-4.1 or newer, should the driver only issue 'set autocommit=n' queries when the server's state doesn't match the requested state by Connection.setAutoCommit(boolean)?", "3.1.3", "Performance Extensions", Integer.MIN_VALUE);
    private BooleanConnectionProperty emulateLocators = new BooleanConnectionProperty("emulateLocators", false, "N/A", "3.1.0", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty enablePacketDebug = new BooleanConnectionProperty("enablePacketDebug", false, "When enabled, a ring-buffer of 'packetDebugBufferSize' packets will be kept, and dumped when exceptions are thrown in key areas in the driver's code", "3.1.3", "Debuging/Profiling", Integer.MIN_VALUE);
    private BooleanConnectionProperty explainSlowQueries = new BooleanConnectionProperty("explainSlowQueries", false, "If 'logSlowQueries' is enabled, should the driver automatically issue an 'EXPLAIN' on the server and send the results to the configured log at a WARN level?", "3.1.2", "Debuging/Profiling", Integer.MIN_VALUE);
    private BooleanConnectionProperty failOverReadOnly = new BooleanConnectionProperty("failOverReadOnly", true, "When failing over in autoReconnect mode, should the connection be set to 'read-only'?", "3.0.12", "High Availability and Clustering", 2);
    private BooleanConnectionProperty gatherPerformanceMetrics = new BooleanConnectionProperty("gatherPerfMetrics", false, "Should the driver gather performance metrics, and report them via the configured logger every 'reportMetricsIntervalMillis' milliseconds?", "3.1.2", "Debuging/Profiling", 1);
    private BooleanConnectionProperty ignoreNonTxTables = new BooleanConnectionProperty("ignoreNonTxTables", false, "Ignore non-transactional table warning for rollback? (defaults to 'false').", "3.0.9", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty isInteractiveClient = new BooleanConnectionProperty("interactiveClient", false, "Set the CLIENT_INTERACTIVE flag, which tells MySQL to timeout connections based on INTERACTIVE_TIMEOUT instead of WAIT_TIMEOUT", "3.1.0", "Connection/Authentication", Integer.MIN_VALUE);
    private BooleanConnectionProperty jdbcCompliantTruncation = new BooleanConnectionProperty("jdbcCompliantTruncation", true, "Should the driver throw java.sql.DataTruncation exceptions when data is truncated as is required by the JDBC specification when connected to a server that supports warnings(MySQL 4.1.0 and newer)?", "3.1.2", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty logSlowQueries = new BooleanConnectionProperty("logSlowQueries", false, "Should queries that take longer than 'slowQueryThresholdMillis' be logged?", "3.1.2", "Debuging/Profiling", Integer.MIN_VALUE);
    private BooleanConnectionProperty paranoid = new BooleanConnectionProperty("paranoid", false, "Take measures to prevent exposure sensitive information in error messages and clear data structures holding sensitive data when possible? (defaults to 'false')", "3.0.1", "Security", Integer.MIN_VALUE);
    private BooleanConnectionProperty pedantic = new BooleanConnectionProperty("pedantic", false, "Follow the JDBC spec to the letter.", "3.0.0", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty profileSQL = new BooleanConnectionProperty("profileSQL", false, "Trace queries and their execution/fetch times to the configured logger (true/false) defaults to 'false'", "3.1.0", "Debuging/Profiling", 1);
    private StringConnectionProperty propertiesTransform = new StringConnectionProperty("propertiesTransform", null, "An implementation of com.mysql.jdbc.ConnectionPropertiesTransform that the driver will use to modify URL properties passed to the driver before attempting a connection", "3.1.4", "Connection/Authentication", Integer.MIN_VALUE);
    private BooleanConnectionProperty reconnectAtTxEnd = new BooleanConnectionProperty("reconnectAtTxEnd", false, "If autoReconnect is set to true, should the driver attempt reconnectionsat the end of every transaction?", "3.0.10", "High Availability and Clustering", 4);
    private BooleanConnectionProperty relaxAutoCommit = new BooleanConnectionProperty("relaxAutoCommit", false, "If the version of MySQL the driver connects to does not support transactions, still allow calls to commit(), rollback() and setAutoCommit() (true/false, defaults to 'false')?", "2.0.13", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty requireSSL = new BooleanConnectionProperty("requireSSL", false, "Require SSL connection if useSSL=true? (defaults to 'false').", "3.1.0", "Security", 3);
    private BooleanConnectionProperty rollbackOnPooledClose = new BooleanConnectionProperty("rollbackOnPooledClose", true, "Should the driver issue a rollback() when the logical connection in a pool is closed?", "3.0.15", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty roundRobinLoadBalance = new BooleanConnectionProperty("roundRobinLoadBalance", false, "When autoReconnect is enabled, and failoverReadonly is false, should we pick hosts to connect to on a round-robin basis?", "3.1.2", "High Availability and Clustering", 5);
    private BooleanConnectionProperty strictFloatingPoint = new BooleanConnectionProperty("strictFloatingPoint", false, "Used only in older versions of compliance test", "3.0.0", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty strictUpdates = new BooleanConnectionProperty("strictUpdates", true, "Should the driver do strict checking (all primary keys selected) of updatable result sets (true, false, defaults to 'true')?", "3.0.4", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty traceProtocol = new BooleanConnectionProperty("traceProtocol", false, "Should trace-level network protocol be logged?", "3.1.2", "Debuging/Profiling", Integer.MIN_VALUE);
    private BooleanConnectionProperty tinyInt1isBit = new BooleanConnectionProperty("tinyInt1isBit", true, "Should the driver treat the datatype TINYINT(1) as the BIT type (because the server silently converts BIT -> TINYINT(1) when creating tables)?", "3.0.16", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty useCompression = new BooleanConnectionProperty("useCompression", false, "Use zlib compression when communicating with the server (true/false)? Defaults to 'false'.", "3.1.0", "Connection/Authentication", Integer.MIN_VALUE);
    private StringConnectionProperty useConfig = new StringConnectionProperty("useConfigs", null, "Load the comma-delimited list of configuration properties before parsing the URL or applying user-specified properties. These configurations are explained in the 'Configurations' of the documentation.", "3.1.5", "Connection/Authentication", Integer.MAX_VALUE);
    private BooleanConnectionProperty useFastIntParsing = new BooleanConnectionProperty("useFastIntParsing", true, "Use internal String->Integer conversion routines to avoid excessive object creation?", "3.1.4", "Performance Extensions", Integer.MIN_VALUE);
    private BooleanConnectionProperty useHostsInPrivileges = new BooleanConnectionProperty("useHostsInPrivileges", true, "Add '@hostname' to users in DatabaseMetaData.getColumn/TablePrivileges() (true/false), defaults to 'true'.", "3.0.2", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty useNewIo = new BooleanConnectionProperty("useNewIO", false, "Should the driver use the java.nio.* interfaces for network communication (true/false), defaults to 'false'", "3.1.0", "Performance Extensions", Integer.MIN_VALUE);
    private BooleanConnectionProperty useOnlyServerErrorMessages = new BooleanConnectionProperty("useOnlyServerErrorMessages", true, "Don't prepend 'standard' SQLState error messages to error messages returned by the server.", "3.0.15", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty useReadAheadInput = new BooleanConnectionProperty("useReadAheadInput", true, "Use newer, optimized non-blocking, buffered input stream when reading from the server?", "3.1.5", "Performance Extensions", Integer.MIN_VALUE);
    private BooleanConnectionProperty useSSL = new BooleanConnectionProperty("useSSL", false, "Use SSL when communicating with the server (true/false), defaults to 'false'", "3.0.2", "Security", 2);
    private BooleanConnectionProperty useSqlStateCodes = new BooleanConnectionProperty("useSqlStateCodes", true, "Use SQL Standard state codes instead of 'legacy' X/Open/SQL state codes (true/false), default is 'true'", "3.1.3", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty useStreamLengthsInPrepStmts = new BooleanConnectionProperty("useStreamLengthsInPrepStmts", true, "Honor stream length parameter in PreparedStatement/ResultSet.setXXXStream() method calls (true/false, defaults to 'true')?", "3.0.2", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty useTimezone = new BooleanConnectionProperty("useTimezone", false, "Convert time/date types between client and server timezones (true/false, defaults to 'false')?", "3.0.2", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty useUltraDevWorkAround = new BooleanConnectionProperty("ultraDevHack", false, "Create PreparedStatements for prepareCall() when required, because UltraDev  is broken and issues a prepareCall() for _all_ statements? (true/false, defaults to 'false')", "2.0.3", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty useUnbufferedInput = new BooleanConnectionProperty("useUnbufferedInput", true, "Don't use BufferedInputStream for reading data from the server", "3.0.11", "Miscellaneous", Integer.MIN_VALUE);
    private BooleanConnectionProperty useUnicode = new BooleanConnectionProperty("useUnicode", false, "Should the driver use Unicode character encodings when handling strings? Should only be used when the driver can't determine the character set mapping, or you are trying to 'force' the driver to use a character set that MySQL either doesn't natively support (such as UTF-8), true/false, defaults to 'true'", "1.1g", "Miscellaneous", 0);
    private BooleanConnectionProperty useUsageAdvisor = new BooleanConnectionProperty("useUsageAdvisor", false, "Should the driver issue 'usage' warnings advising proper and efficient usage of JDBC and MySQL Connector/J to the log (true/false, defaults to 'false')?", "3.1.1", "Debuging/Profiling", 10);
    private IntegerConnectionProperty callableStatementCacheSize = new IntegerConnectionProperty("callableStmtCacheSize", 100, 0, Integer.MAX_VALUE, "If 'cacheCallableStmts' is enabled, how many callable statements should be cached?", "3.1.2", "Performance Extensions", 5);
    private IntegerConnectionProperty connectTimeout = new IntegerConnectionProperty("connectTimeout", 0, 0, Integer.MAX_VALUE, "Timeout for socket connect (in milliseconds), with 0 being no timeout. Only works on JDK-1.4 or newer. Defaults to '0'.", "3.0.1", "Connection/Authentication", 9);
    private IntegerConnectionProperty initialTimeout = new IntegerConnectionProperty("initialTimeout", 2, 1, Integer.MAX_VALUE, "If autoReconnect is enabled, the initial time to wait between re-connect attempts (in seconds, defaults to '2').", "1.1", "High Availability and Clustering", 5);
    private IntegerConnectionProperty maxQuerySizeToLog = new IntegerConnectionProperty("maxQuerySizeToLog", 2048, 0, Integer.MAX_VALUE, "Controls the maximum length/size of a query that will get logged when profiling or tracing", "3.1.3", "Debuging/Profiling", 4);
    private IntegerConnectionProperty maxReconnects = new IntegerConnectionProperty("maxReconnects", 3, 1, Integer.MAX_VALUE, "Maximum number of reconnects to attempt if autoReconnect is true, default is '3'.", "1.1", "High Availability and Clustering", 4);
    private IntegerConnectionProperty maxRows = new IntegerConnectionProperty("maxRows", -1, -1, Integer.MAX_VALUE, "The maximum number of rows to return  (0, the default means return all rows).", "all versions", "Miscellaneous", Integer.MIN_VALUE);
    private IntegerConnectionProperty metadataCacheSize = new IntegerConnectionProperty("metadataCacheSize", 50, 1, Integer.MAX_VALUE, "The number of queries to cacheResultSetMetadata for if cacheResultSetMetaData is set to 'true' (default 50)", "3.1.1", "Performance Extensions", 5);
    private IntegerConnectionProperty packetDebugBufferSize = new IntegerConnectionProperty("packetDebugBufferSize", 20, 0, Integer.MAX_VALUE, "The maximum number of packets to retain when 'enablePacketDebug' is true", "3.1.3", "Debuging/Profiling", 7);
    private IntegerConnectionProperty preparedStatementCacheSize = new IntegerConnectionProperty("prepStmtCacheSize", 25, 0, Integer.MAX_VALUE, "If prepared statement caching is enabled, how many prepared statements should be cached?", "3.0.10", "Performance Extensions", 10);
    private IntegerConnectionProperty preparedStatementCacheSqlLimit = new IntegerConnectionProperty("prepStmtCacheSqlLimit", 256, 1, Integer.MAX_VALUE, "If prepared statement caching is enabled, what's the largest SQL the driver will cache the parsing for?", "3.0.10", "Performance Extensions", 11);
    private IntegerConnectionProperty queriesBeforeRetryMaster = new IntegerConnectionProperty("queriesBeforeRetryMaster", 50, 1, Integer.MAX_VALUE, "Number of queries to issue before falling back to master when failed over (when using multi-host failover). Whichever condition is met first, 'queriesBeforeRetryMaster' or 'secondsBeforeRetryMaster' will cause an attempt to be made to reconnect to the master. Defaults to 50.", "3.0.2", "High Availability and Clustering", 7);
    private IntegerConnectionProperty reportMetricsIntervalMillis = new IntegerConnectionProperty("reportMetricsIntervalMillis", 30000, 0, Integer.MAX_VALUE, "If 'gatherPerfMetrics' is enabled, how often should they be logged (in ms)?", "3.1.2", "Debuging/Profiling", 3);
    private IntegerConnectionProperty secondsBeforeRetryMaster = new IntegerConnectionProperty("secondsBeforeRetryMaster", 30, 1, Integer.MAX_VALUE, "How long should the driver wait, when failed over, before attempting to reconnect to the master server? Whichever condition is met first, 'queriesBeforeRetryMaster' or 'secondsBeforeRetryMaster' will cause an attempt to be made to reconnect to the master. Time in seconds, defaults to 30", "3.0.2", "High Availability and Clustering", 8);
    private IntegerConnectionProperty slowQueryThresholdMillis = new IntegerConnectionProperty("slowQueryThresholdMillis", 2000, 0, Integer.MAX_VALUE, "If 'logSlowQueries' is enabled, how long should a query (in ms) before it is logged as 'slow'?", "3.1.2", "Debuging/Profiling", 9);
    private IntegerConnectionProperty socketTimeout = new IntegerConnectionProperty("socketTimeout", 0, 0, Integer.MAX_VALUE, "Timeout on network socket operations (0, the default means no timeout).", "3.0.1", "Connection/Authentication", 10);
    private String characterEncodingAsString = null;
    private StringConnectionProperty characterEncoding = new StringConnectionProperty("characterEncoding", null, "If 'useUnicode' is set to true, what character encoding should the driver use when dealing with strings? (defaults is to 'autodetect')", "1.1g", "Miscellaneous", 5);
    private StringConnectionProperty characterSetResults = new StringConnectionProperty("characterSetResults", null, "Character set to tell the server to return results as.", "3.0.13", "Miscellaneous", 6);
    private StringConnectionProperty connectionCollation = new StringConnectionProperty("connectionCollation", null, "If set, tells the server to use this collation via 'set connection_collation'", "3.0.13", "Miscellaneous", 7);
    private StringConnectionProperty loggerClassName = new StringConnectionProperty("logger", (class$com$mysql$jdbc$log$StandardLogger == null ? (class$com$mysql$jdbc$log$StandardLogger = ConnectionProperties.class$("com.mysql.jdbc.log.StandardLogger")) : class$com$mysql$jdbc$log$StandardLogger).getName(), "The name of a class that implements '" + (class$com$mysql$jdbc$log$Log == null ? (class$com$mysql$jdbc$log$Log = ConnectionProperties.class$("com.mysql.jdbc.log.Log")) : class$com$mysql$jdbc$log$Log).getName() + "' that will be used to log messages to." + "(default is '" + (class$com$mysql$jdbc$log$StandardLogger == null ? (class$com$mysql$jdbc$log$StandardLogger = ConnectionProperties.class$("com.mysql.jdbc.log.StandardLogger")) : class$com$mysql$jdbc$log$StandardLogger).getName() + "', which " + "logs to STDERR)", "3.1.1", "Debuging/Profiling", 0);
    private StringConnectionProperty profileSql = new StringConnectionProperty("profileSql", null, "Deprecated, use 'profileSQL' instead. Trace queries and their execution/fetch times on STDERR (true/false) defaults to 'false'", "2.0.14", "Debuging/Profiling", 3);
    private StringConnectionProperty serverTimezone = new StringConnectionProperty("serverTimezone", null, "Override detection/mapping of timezone. Used when timezone from server doesn't map to Java timezone", "3.0.2", "Miscellaneous", Integer.MIN_VALUE);
    private StringConnectionProperty socketFactoryClassName = new StringConnectionProperty("socketFactory", (class$com$mysql$jdbc$StandardSocketFactory == null ? (class$com$mysql$jdbc$StandardSocketFactory = ConnectionProperties.class$("com.mysql.jdbc.StandardSocketFactory")) : class$com$mysql$jdbc$StandardSocketFactory).getName(), "The name of the class that the driver should use for creating socket connections to the server. This class must implement the interface 'com.mysql.jdbc.SocketFactory' and have public no-args constructor.", "3.0.3", "Connection/Authentication", 4);
    private StringConnectionProperty zeroDateTimeBehavior = new StringConnectionProperty("zeroDateTimeBehavior", "exception", new String[]{"exception", "round", "convertToNull"}, "What should happen when the driver encounters DATETIME values that are composed entirely of zeroes (used by MySQL to represent invalid dates)? Valid values are 'exception', 'round' and 'convertToNull'.", "3.1.4", "Miscellaneous", Integer.MIN_VALUE);
    private boolean autoReconnectForPoolsAsBoolean = false;
    private boolean cacheResultSetMetaDataAsBoolean;
    private boolean highAvailabilityAsBoolean = false;
    private boolean profileSQLAsBoolean = false;
    private boolean reconnectTxAtEndAsBoolean = false;
    private boolean useUnicodeAsBoolean = true;
    private boolean useUsageAdvisorAsBoolean = false;
    private int maxRowsAsInt = -1;
    private BooleanConnectionProperty useOldUTF8Behavior = new BooleanConnectionProperty("useOldUTF8Behavior", false, "Use the UTF-8 behavior the driver did when communicating with 4.0 and older servers", "3.1.6", "Miscellaneous", Integer.MIN_VALUE);
    static /* synthetic */ Class class$com$mysql$jdbc$ConnectionProperties;
    static /* synthetic */ Class class$com$mysql$jdbc$ConnectionProperties$ConnectionProperty;
    static /* synthetic */ Class class$com$mysql$jdbc$log$StandardLogger;
    static /* synthetic */ Class class$com$mysql$jdbc$log$Log;
    static /* synthetic */ Class class$com$mysql$jdbc$StandardSocketFactory;

    public void setAllowLoadLocalInfile(boolean property) {
        this.allowLoadLocalInfile.setValue(property);
    }

    public boolean getAllowLoadLocalInfile() {
        return this.allowLoadLocalInfile.getValueAsBoolean();
    }

    public void setAllowMultiQueries(boolean property) {
        this.allowMultiQueries.setValue(property);
    }

    public boolean getAllowMultiQueries() {
        return this.allowMultiQueries.getValueAsBoolean();
    }

    public void setAutoReconnect(boolean flag) {
        this.autoReconnect.setValue(flag);
    }

    public void setAutoReconnectForConnectionPools(boolean property) {
        this.autoReconnectForPools.setValue(property);
        this.autoReconnectForPoolsAsBoolean = this.autoReconnectForPools.getValueAsBoolean();
    }

    public void setAutoReconnectForPools(boolean flag) {
        this.autoReconnectForPools.setValue(flag);
    }

    public boolean getAutoReconnectForPools() {
        return this.autoReconnectForPoolsAsBoolean;
    }

    public void setCacheCallableStatements(boolean flag) {
        this.cacheCallableStatements.setValue(flag);
    }

    public boolean getCacheCallableStatements() {
        return this.cacheCallableStatements.getValueAsBoolean();
    }

    public void setCachePreparedStatements(boolean flag) {
        this.cachePreparedStatements.setValue(flag);
    }

    public boolean getCachePreparedStatements() {
        return (Boolean)this.cachePreparedStatements.getValueAsObject();
    }

    public void setCacheResultSetMetadata(boolean property) {
        this.cacheResultSetMetadata.setValue(property);
        this.cacheResultSetMetaDataAsBoolean = this.cacheResultSetMetadata.getValueAsBoolean();
    }

    public boolean getCacheResultSetMetadata() {
        return this.cacheResultSetMetaDataAsBoolean;
    }

    public void setCallableStatementCacheSize(int size) {
        this.callableStatementCacheSize.setValue(size);
    }

    public int getCallableStatementCacheSize() {
        return this.callableStatementCacheSize.getValueAsInt();
    }

    public void setCapitalizeDBMDTypes(boolean property) {
        this.capitalizeTypeNames.setValue(property);
    }

    public void setCapitalizeTypeNames(boolean flag) {
        this.capitalizeTypeNames.setValue(flag);
    }

    public boolean getCapitalizeTypeNames() {
        return this.capitalizeTypeNames.getValueAsBoolean();
    }

    public void setCharacterEncoding(String encoding) {
        this.characterEncoding.setValue(encoding);
    }

    public void setCharacterSetResults(String characterSet) {
        this.characterSetResults.setValue(characterSet);
    }

    public String getCharacterSetResults() {
        return this.characterSetResults.getValueAsString();
    }

    public void setClobberStreamingResults(boolean flag) {
        this.clobberStreamingResults.setValue(flag);
    }

    public boolean getClobberStreamingResults() {
        return this.clobberStreamingResults.getValueAsBoolean();
    }

    public void setConnectTimeout(int timeoutMs) {
        this.connectTimeout.setValue(timeoutMs);
    }

    public int getConnectTimeout() {
        return this.connectTimeout.getValueAsInt();
    }

    public void setConnectionCollation(String collation) {
        this.connectionCollation.setValue(collation);
    }

    public String getConnectionCollation() {
        return this.connectionCollation.getValueAsString();
    }

    public void setContinueBatchOnError(boolean property) {
        this.continueBatchOnError.setValue(property);
    }

    public boolean getContinueBatchOnError() {
        return this.continueBatchOnError.getValueAsBoolean();
    }

    public void setDetectServerPreparedStmts(boolean property) {
        this.detectServerPreparedStmts.setValue(property);
    }

    public void setDumpQueriesOnException(boolean flag) {
        this.dumpQueriesOnException.setValue(flag);
    }

    public boolean getDumpQueriesOnException() {
        return this.dumpQueriesOnException.getValueAsBoolean();
    }

    public void setElideSetAutoCommits(boolean flag) {
        this.elideSetAutoCommits.setValue(flag);
    }

    public boolean getElideSetAutoCommits() {
        return this.elideSetAutoCommits.getValueAsBoolean();
    }

    public void setEmulateLocators(boolean property) {
        this.emulateLocators.setValue(property);
    }

    public boolean getEmulateLocators() {
        return this.emulateLocators.getValueAsBoolean();
    }

    public void setEnablePacketDebug(boolean flag) {
        this.enablePacketDebug.setValue(flag);
    }

    public boolean getEnablePacketDebug() {
        return this.enablePacketDebug.getValueAsBoolean();
    }

    public void setEncoding(String property) {
        this.characterEncoding.setValue(property);
        this.characterEncodingAsString = this.characterEncoding.getValueAsString();
    }

    public void setExplainSlowQueries(boolean flag) {
        this.explainSlowQueries.setValue(flag);
    }

    public boolean getExplainSlowQueries() {
        return this.explainSlowQueries.getValueAsBoolean();
    }

    public void setFailOverReadOnly(boolean flag) {
        this.failOverReadOnly.setValue(flag);
    }

    public boolean getFailOverReadOnly() {
        return this.failOverReadOnly.getValueAsBoolean();
    }

    public void setGatherPerformanceMetrics(boolean flag) {
        this.gatherPerformanceMetrics.setValue(flag);
    }

    public boolean getGatherPerformanceMetrics() {
        return this.gatherPerformanceMetrics.getValueAsBoolean();
    }

    public void setIgnoreNonTxTables(boolean property) {
        this.ignoreNonTxTables.setValue(property);
    }

    public boolean getIgnoreNonTxTables() {
        return this.ignoreNonTxTables.getValueAsBoolean();
    }

    public void setInitialTimeout(int property) {
        this.initialTimeout.setValue(property);
    }

    public int getInitialTimeout() {
        return this.initialTimeout.getValueAsInt();
    }

    public boolean getInteractiveClient() {
        return this.isInteractiveClient.getValueAsBoolean();
    }

    public void setIsInteractiveClient(boolean property) {
        this.isInteractiveClient.setValue(property);
    }

    public boolean getIsInteractiveClient() {
        return this.isInteractiveClient.getValueAsBoolean();
    }

    public void setJdbcCompliantTruncation(boolean flag) {
        this.jdbcCompliantTruncation.setValue(flag);
    }

    public boolean getJdbcCompliantTruncation() {
        return this.jdbcCompliantTruncation.getValueAsBoolean();
    }

    public void setLogSlowQueries(boolean flag) {
        this.logSlowQueries.setValue(flag);
    }

    public boolean getLogSlowQueries() {
        return this.logSlowQueries.getValueAsBoolean();
    }

    public void setLogger(String property) {
        this.loggerClassName.setValueAsObject(property);
    }

    public String getLogger() {
        Object loggerValue = this.loggerClassName.getValueAsObject();
        return loggerValue == null ? null : loggerValue.toString();
    }

    public void setLoggerClassName(String className) {
        this.loggerClassName.setValue(className);
    }

    public String getLoggerClassName() {
        return this.loggerClassName.getValueAsString();
    }

    public void setMaxQuerySizeToLog(int sizeInBytes) {
        this.maxQuerySizeToLog.setValue(sizeInBytes);
    }

    public int getMaxQuerySizeToLog() {
        return this.maxQuerySizeToLog.getValueAsInt();
    }

    public void setMaxReconnects(int property) {
        this.maxReconnects.setValue(property);
    }

    public int getMaxReconnects() {
        return this.maxReconnects.getValueAsInt();
    }

    public void setMaxRows(int property) {
        this.maxRows.setValue(property);
        this.maxRowsAsInt = this.maxRows.getValueAsInt();
    }

    public int getMaxRows() {
        return this.maxRowsAsInt;
    }

    public void setMetadataCacheSize(int value) {
        this.metadataCacheSize.setValue(value);
    }

    public int getMetadataCacheSize() {
        return this.metadataCacheSize.getValueAsInt();
    }

    public void setPacketDebugBufferSize(int size) {
        this.packetDebugBufferSize.setValue(size);
    }

    public int getPacketDebugBufferSize() {
        return this.packetDebugBufferSize.getValueAsInt();
    }

    public void setParanoid(boolean property) {
        this.paranoid.setValue(property);
    }

    public boolean getParanoid() {
        return this.paranoid.getValueAsBoolean();
    }

    public void setPedantic(boolean property) {
        this.pedantic.setValue(property);
    }

    public boolean getPedantic() {
        return this.pedantic.getValueAsBoolean();
    }

    public void setPreparedStatementCacheSize(int cacheSize) {
        this.preparedStatementCacheSize.setValue(cacheSize);
    }

    public int getPreparedStatementCacheSize() {
        return (Integer)this.preparedStatementCacheSize.getValueAsObject();
    }

    public void setPreparedStatementCacheSqlLimit(int cacheSqlLimit) {
        this.preparedStatementCacheSqlLimit.setValue(cacheSqlLimit);
    }

    public int getPreparedStatementCacheSqlLimit() {
        return (Integer)this.preparedStatementCacheSqlLimit.getValueAsObject();
    }

    public void setProfileSQL(boolean flag) {
        this.profileSQL.setValue(flag);
    }

    public boolean getProfileSQL() {
        return this.profileSQL.getValueAsBoolean();
    }

    public void setProfileSql(boolean property) {
        this.profileSQL.setValue(property);
        this.profileSQLAsBoolean = this.profileSQL.getValueAsBoolean();
    }

    public boolean getProfileSql() {
        return this.profileSQLAsBoolean;
    }

    public void setQueriesBeforeRetryMaster(int property) {
        this.queriesBeforeRetryMaster.setValue(property);
    }

    public int getQueriesBeforeRetryMaster() {
        return this.queriesBeforeRetryMaster.getValueAsInt();
    }

    public void setReconnectAtTxEnd(boolean property) {
        this.reconnectAtTxEnd.setValue(property);
        this.reconnectTxAtEndAsBoolean = this.reconnectAtTxEnd.getValueAsBoolean();
    }

    public boolean getReconnectAtTxEnd() {
        return this.reconnectTxAtEndAsBoolean;
    }

    public void setRelaxAutoCommit(boolean property) {
        this.relaxAutoCommit.setValue(property);
    }

    public boolean getRelaxAutoCommit() {
        return this.relaxAutoCommit.getValueAsBoolean();
    }

    public void setReportMetricsIntervalMillis(int millis) {
        this.reportMetricsIntervalMillis.setValue(millis);
    }

    public int getReportMetricsIntervalMillis() {
        return this.reportMetricsIntervalMillis.getValueAsInt();
    }

    public void setRequireSSL(boolean property) {
        this.requireSSL.setValue(property);
    }

    public boolean getRequireSSL() {
        return this.requireSSL.getValueAsBoolean();
    }

    public void setRoundRobinLoadBalance(boolean flag) {
        this.roundRobinLoadBalance.setValue(flag);
    }

    public boolean getRoundRobinLoadBalance() {
        return this.roundRobinLoadBalance.getValueAsBoolean();
    }

    public void setSecondsBeforeRetryMaster(int property) {
        this.secondsBeforeRetryMaster.setValue(property);
    }

    public int getSecondsBeforeRetryMaster() {
        return this.secondsBeforeRetryMaster.getValueAsInt();
    }

    public void setServerTimezone(String property) {
        this.serverTimezone.setValue(property);
    }

    public String getServerTimezone() {
        return this.serverTimezone.getValueAsString();
    }

    public void setSlowQueryThresholdMillis(int millis) {
        this.slowQueryThresholdMillis.setValue(millis);
    }

    public int getSlowQueryThresholdMillis() {
        return this.slowQueryThresholdMillis.getValueAsInt();
    }

    public void setSocketFactoryClassName(String property) {
        this.socketFactoryClassName.setValue(property);
    }

    public String getSocketFactoryClassName() {
        return this.socketFactoryClassName.getValueAsString();
    }

    public void setSocketTimeout(int property) {
        this.socketTimeout.setValue(property);
    }

    public int getSocketTimeout() {
        return this.socketTimeout.getValueAsInt();
    }

    public void setStrictFloatingPoint(boolean property) {
        this.strictFloatingPoint.setValue(property);
    }

    public boolean getStrictFloatingPoint() {
        return this.strictFloatingPoint.getValueAsBoolean();
    }

    public void setStrictUpdates(boolean property) {
        this.strictUpdates.setValue(property);
    }

    public boolean getStrictUpdates() {
        return this.strictUpdates.getValueAsBoolean();
    }

    public void setTraceProtocol(boolean flag) {
        this.traceProtocol.setValue(flag);
    }

    public boolean getTraceProtocol() {
        return this.traceProtocol.getValueAsBoolean();
    }

    public void setUseCompression(boolean property) {
        this.useCompression.setValue(property);
    }

    public boolean getUseCompression() {
        return this.useCompression.getValueAsBoolean();
    }

    public void setUseHostsInPrivileges(boolean property) {
        this.useHostsInPrivileges.setValue(property);
    }

    public boolean getUseHostsInPrivileges() {
        return this.useHostsInPrivileges.getValueAsBoolean();
    }

    public void setUseNewIo(boolean property) {
        this.useNewIo.setValue(property);
    }

    public boolean getUseNewIo() {
        return this.useNewIo.getValueAsBoolean();
    }

    public void setUseSSL(boolean property) {
        this.useSSL.setValue(property);
    }

    public boolean getUseSSL() {
        return this.useSSL.getValueAsBoolean();
    }

    public void setUseServerPreparedStmts(boolean flag) {
        this.detectServerPreparedStmts.setValue(flag);
    }

    public boolean getUseServerPreparedStmts() {
        return this.detectServerPreparedStmts.getValueAsBoolean();
    }

    public void setUseSqlStateCodes(boolean flag) {
        this.useSqlStateCodes.setValue(flag);
    }

    public boolean getUseSqlStateCodes() {
        return this.useSqlStateCodes.getValueAsBoolean();
    }

    public void setUseStreamLengthsInPrepStmts(boolean property) {
        this.useStreamLengthsInPrepStmts.setValue(property);
    }

    public boolean getUseStreamLengthsInPrepStmts() {
        return this.useStreamLengthsInPrepStmts.getValueAsBoolean();
    }

    public void setUseTimezone(boolean property) {
        this.useTimezone.setValue(property);
    }

    public boolean getUseTimezone() {
        return this.useTimezone.getValueAsBoolean();
    }

    public void setUseUltraDevWorkAround(boolean property) {
        this.useUltraDevWorkAround.setValue(property);
    }

    public boolean getUseUltraDevWorkAround() {
        return this.useUltraDevWorkAround.getValueAsBoolean();
    }

    public void setUseUnbufferedInput(boolean flag) {
        this.useUnbufferedInput.setValue(flag);
    }

    public boolean getUseUnbufferedInput() {
        return this.useUnbufferedInput.getValueAsBoolean();
    }

    public void setUseUnicode(boolean flag) {
        this.useUnicode.setValue(flag);
        this.useUnicodeAsBoolean = this.useUnicode.getValueAsBoolean();
    }

    public boolean getUseUnicode() {
        return this.useUnicodeAsBoolean;
    }

    public void setUseUsageAdvisor(boolean useUsageAdvisorFlag) {
        this.useUsageAdvisor.setValue(useUsageAdvisorFlag);
        this.useUsageAdvisorAsBoolean = this.useUsageAdvisor.getValueAsBoolean();
    }

    public boolean getUseUsageAdvisor() {
        return this.useUsageAdvisorAsBoolean;
    }

    public String exposeAsXml() throws SQLException {
        StringBuffer xmlBuf = new StringBuffer();
        xmlBuf.append("<ConnectionProperties>");
        int numPropertiesToSet = PROPERTY_LIST.size();
        int numCategories = propertyCategories.length;
        HashMap<String, Map[]> propertyListByCategory = new HashMap<String, Map[]>();
        for (int i = 0; i < numCategories; ++i) {
            propertyListByCategory.put(propertyCategories[i], new Map[]{new TreeMap(), new TreeMap()});
        }
        StringConnectionProperty userProp = new StringConnectionProperty("user", null, "The user to connect as", "all", CONNECTION_AND_AUTH_CATEGORY, -2147483647);
        StringConnectionProperty passwordProp = new StringConnectionProperty("password", null, "The password to use when connecting", "all", CONNECTION_AND_AUTH_CATEGORY, -2147483646);
        Map[] connectionSortMaps = (Map[])propertyListByCategory.get(CONNECTION_AND_AUTH_CATEGORY);
        connectionSortMaps[0].put(new Integer(userProp.getOrder()), userProp);
        connectionSortMaps[0].put(new Integer(passwordProp.getOrder()), passwordProp);
        try {
            for (int i = 0; i < numPropertiesToSet; ++i) {
                Field propertyField = (Field)PROPERTY_LIST.get(i);
                ConnectionProperty propToGet = (ConnectionProperty)propertyField.get(this);
                Map[] sortMaps = (Map[])propertyListByCategory.get(propToGet.getCategoryName());
                int orderInCategory = propToGet.getOrder();
                if (orderInCategory == Integer.MIN_VALUE) {
                    sortMaps[1].put(propToGet.getPropertyName(), propToGet);
                    continue;
                }
                sortMaps[0].put(new Integer(orderInCategory), propToGet);
            }
            for (int j = 0; j < numCategories; ++j) {
                Map[] sortMaps = (Map[])propertyListByCategory.get(propertyCategories[j]);
                Iterator orderedIter = sortMaps[0].values().iterator();
                Iterator alphaIter = sortMaps[1].values().iterator();
                xmlBuf.append("\n <PropertyCategory name=\"");
                xmlBuf.append(propertyCategories[j]);
                xmlBuf.append("\">");
                while (orderedIter.hasNext()) {
                    ConnectionProperty propToGet = (ConnectionProperty)orderedIter.next();
                    propToGet.syncDriverPropertyInfo();
                    xmlBuf.append("\n  <Property name=\"");
                    xmlBuf.append(propToGet.getPropertyName());
                    xmlBuf.append("\" required=\"");
                    xmlBuf.append(propToGet.required ? "Yes" : "No");
                    xmlBuf.append("\" default=\"");
                    if (propToGet.getDefaultValue() != null) {
                        xmlBuf.append(propToGet.getDefaultValue());
                    }
                    xmlBuf.append("\" sortOrder=\"");
                    xmlBuf.append(propToGet.getOrder());
                    xmlBuf.append("\" since=\"");
                    xmlBuf.append(propToGet.sinceVersion);
                    xmlBuf.append("\">\n");
                    xmlBuf.append("    ");
                    xmlBuf.append(propToGet.description);
                    xmlBuf.append("\n  </Property>");
                }
                while (alphaIter.hasNext()) {
                    ConnectionProperty propToGet = (ConnectionProperty)alphaIter.next();
                    propToGet.syncDriverPropertyInfo();
                    xmlBuf.append("\n  <Property name=\"");
                    xmlBuf.append(propToGet.getPropertyName());
                    xmlBuf.append("\" required=\"");
                    xmlBuf.append(propToGet.required ? "Yes" : "No");
                    xmlBuf.append("\" default=\"");
                    if (propToGet.getDefaultValue() != null) {
                        xmlBuf.append(propToGet.getDefaultValue());
                    }
                    xmlBuf.append("\" sortOrder=\"alpha\" since=\"");
                    xmlBuf.append(propToGet.sinceVersion);
                    xmlBuf.append("\">\n");
                    xmlBuf.append("    ");
                    xmlBuf.append(propToGet.description);
                    xmlBuf.append("\n  </Property>");
                }
                xmlBuf.append("\n </PropertyCategory>");
            }
        }
        catch (IllegalAccessException iae) {
            throw new SQLException("Internal properties failure", "S1000");
        }
        xmlBuf.append("\n</ConnectionProperties>");
        return xmlBuf.toString();
    }

    protected String getEncoding() {
        return this.characterEncodingAsString;
    }

    protected static DriverPropertyInfo[] exposeAsDriverPropertyInfo(Properties info, int slotsToReserve) throws SQLException {
        return new ConnectionProperties(){}.exposeAsDriverPropertyInfoInternal(info, slotsToReserve);
    }

    protected void setDoUnicode(boolean property) {
        this.useUnicode.setValue(property);
    }

    protected void setHighAvailability(boolean property) {
        this.autoReconnect.setValue(property);
        this.highAvailabilityAsBoolean = this.autoReconnect.getValueAsBoolean();
    }

    protected boolean getHighAvailability() {
        return this.highAvailabilityAsBoolean;
    }

    protected DriverPropertyInfo[] exposeAsDriverPropertyInfoInternal(Properties info, int slotsToReserve) throws SQLException {
        this.initializeProperties(info);
        int numProperties = PROPERTY_LIST.size();
        int listSize = numProperties + slotsToReserve;
        DriverPropertyInfo[] driverProperties = new DriverPropertyInfo[listSize];
        for (int i = slotsToReserve; i < listSize; ++i) {
            Field propertyField = (Field)PROPERTY_LIST.get(i - slotsToReserve);
            try {
                ConnectionProperty propToExpose = (ConnectionProperty)propertyField.get(this);
                if (info != null) {
                    propToExpose.initializeFrom(info);
                }
                propToExpose.syncDriverPropertyInfo();
                driverProperties[i] = propToExpose;
                continue;
            }
            catch (IllegalAccessException iae) {
                throw new SQLException("Internal properties failure", "S1000");
            }
        }
        return driverProperties;
    }

    protected Properties exposeAsProperties(Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        int numPropertiesToSet = PROPERTY_LIST.size();
        for (int i = 0; i < numPropertiesToSet; ++i) {
            Field propertyField = (Field)PROPERTY_LIST.get(i);
            try {
                ConnectionProperty propToGet = (ConnectionProperty)propertyField.get(this);
                Object propValue = propToGet.getValueAsObject();
                if (propValue == null) continue;
                info.setProperty(propToGet.getPropertyName(), propValue.toString());
                continue;
            }
            catch (IllegalAccessException iae) {
                throw new SQLException("Internal properties failure", "S1000");
            }
        }
        return info;
    }

    protected void initializeFromRef(Reference ref) throws SQLException {
        int numPropertiesToSet = PROPERTY_LIST.size();
        for (int i = 0; i < numPropertiesToSet; ++i) {
            Field propertyField = (Field)PROPERTY_LIST.get(i);
            try {
                ConnectionProperty propToSet = (ConnectionProperty)propertyField.get(this);
                if (ref == null) continue;
                propToSet.initializeFrom(ref);
                continue;
            }
            catch (IllegalAccessException iae) {
                throw new SQLException("Internal properties failure", "S1000");
            }
        }
        this.postInitialization();
    }

    protected void initializeProperties(Properties info) throws SQLException {
        if (info != null) {
            String profileSqlLc = info.getProperty("profileSql");
            if (profileSqlLc != null) {
                info.put("profileSQL", profileSqlLc);
            }
            Properties infoCopy = (Properties)info.clone();
            infoCopy.remove("HOST");
            infoCopy.remove("user");
            infoCopy.remove("password");
            infoCopy.remove("DBNAME");
            infoCopy.remove("PORT");
            infoCopy.remove("profileSql");
            int numPropertiesToSet = PROPERTY_LIST.size();
            for (int i = 0; i < numPropertiesToSet; ++i) {
                Field propertyField = (Field)PROPERTY_LIST.get(i);
                try {
                    ConnectionProperty propToSet = (ConnectionProperty)propertyField.get(this);
                    propToSet.initializeFrom(infoCopy);
                    continue;
                }
                catch (IllegalAccessException iae) {
                    throw new SQLException("Unable to initialize driver properties due to " + iae.toString(), "S1000");
                }
            }
            this.postInitialization();
        }
    }

    protected void postInitialization() throws SQLException {
        String testEncoding;
        if (this.profileSql.getValueAsObject() != null) {
            this.profileSQL.initializeFrom(this.profileSql.getValueAsObject().toString());
        }
        this.reconnectTxAtEndAsBoolean = (Boolean)this.reconnectAtTxEnd.getValueAsObject();
        if (this.getMaxRows() == 0) {
            this.maxRows.setValueAsObject(new Integer(-1));
        }
        if ((testEncoding = this.getEncoding()) != null) {
            try {
                String testString = "abc";
                testString.getBytes(testEncoding);
            }
            catch (UnsupportedEncodingException UE) {
                throw new SQLException("Unsupported character encoding '" + testEncoding + "'.", "0S100");
            }
        }
        if (((Boolean)this.cacheResultSetMetadata.getValueAsObject()).booleanValue()) {
            try {
                Class.forName("java.util.LinkedHashMap");
            }
            catch (ClassNotFoundException cnfe) {
                this.cacheResultSetMetadata.setValue(false);
            }
        }
        this.cacheResultSetMetaDataAsBoolean = (Boolean)this.cacheResultSetMetadata.getValueAsObject();
        this.useUnicodeAsBoolean = (Boolean)this.useUnicode.getValueAsObject();
        this.characterEncodingAsString = (String)this.characterEncoding.getValueAsObject();
        this.highAvailabilityAsBoolean = (Boolean)this.autoReconnect.getValueAsObject();
        this.autoReconnectForPoolsAsBoolean = (Boolean)this.autoReconnectForPools.getValueAsObject();
        this.maxRowsAsInt = (Integer)this.maxRows.getValueAsObject();
        this.profileSQLAsBoolean = (Boolean)this.profileSQL.getValueAsObject();
        this.useUsageAdvisorAsBoolean = (Boolean)this.useUsageAdvisor.getValueAsObject();
    }

    protected void storeToRef(Reference ref) throws SQLException {
        int numPropertiesToSet = PROPERTY_LIST.size();
        for (int i = 0; i < numPropertiesToSet; ++i) {
            Field propertyField = (Field)PROPERTY_LIST.get(i);
            try {
                ConnectionProperty propToStore = (ConnectionProperty)propertyField.get(this);
                if (ref == null) continue;
                propToStore.storeTo(ref);
                continue;
            }
            catch (IllegalAccessException iae) {
                throw new SQLException("Huh?");
            }
        }
    }

    protected boolean useUnbufferedInput() {
        return this.useUnbufferedInput.getValueAsBoolean();
    }

    public boolean getRollbackOnPooledClose() {
        return this.rollbackOnPooledClose.getValueAsBoolean();
    }

    public void setRollbackOnPooledClose(boolean flag) {
        this.rollbackOnPooledClose.setValue(flag);
    }

    public boolean getUseFastIntParsing() {
        return this.useFastIntParsing.getValueAsBoolean();
    }

    public void setUseFastIntParsing(boolean flag) {
        this.useFastIntParsing.setValue(flag);
    }

    public boolean getUseOnlyServerErrorMessages() {
        return this.useOnlyServerErrorMessages.getValueAsBoolean();
    }

    public void setUseOnlyServerErrorMessages(boolean flag) {
        this.useOnlyServerErrorMessages.setValue(flag);
    }

    public String getPropertiesTransform() {
        return this.propertiesTransform.getValueAsString();
    }

    public void setPropertiesTransform(String value) {
        this.propertiesTransform.setValue(value);
    }

    public boolean getAllowUrlInLocalInfile() {
        return this.allowUrlInLocalInfile.getValueAsBoolean();
    }

    public void setAllowUrlInLocalInfile(boolean flag) {
        this.allowUrlInLocalInfile.setValue(flag);
    }

    public String getZeroDateTimeBehavior() {
        return this.zeroDateTimeBehavior.getValueAsString();
    }

    public void setZeroDateTimeBehavior(String behavior) {
        this.zeroDateTimeBehavior.setValue(behavior);
    }

    public boolean getTinyInt1isBit() {
        return this.tinyInt1isBit.getValueAsBoolean();
    }

    public void setTinyInt1isBit(boolean flag) {
        this.tinyInt1isBit.setValue(flag);
    }

    public boolean getCacheServerConfiguration() {
        return this.cacheServerConfiguration.getValueAsBoolean();
    }

    public void setCacheServerConfiguration(boolean flag) {
        this.cacheServerConfiguration.setValue(flag);
    }

    protected boolean getAllowNanAndInf() {
        return this.allowNanAndInf.getValueAsBoolean();
    }

    protected void setAllowNanAndInf(boolean flag) {
        this.allowNanAndInf.setValue(flag);
    }

    public boolean getDynamicCalendars() {
        return this.dynamicCalendars.getValueAsBoolean();
    }

    public void setDynamicCalendars(boolean flag) {
        this.dynamicCalendars.setValue(flag);
    }

    public boolean getDontUnpackBinaryResults() {
        return this.dontUnpackBinaryResults.getValueAsBoolean();
    }

    public void setDontUnpackBinaryResults(boolean flag) {
        this.dontUnpackBinaryResults.setValue(flag);
    }

    public boolean getAutoDeserialize() {
        return this.autoDeserialize.getValueAsBoolean();
    }

    public void setAutoDeserialize(boolean flag) {
        this.autoDeserialize.setValue(flag);
    }

    public boolean getUseReadAheadInput() {
        return this.useReadAheadInput.getValueAsBoolean();
    }

    public void setUseReadAheadInput(boolean flag) {
        this.useReadAheadInput.setValue(flag);
    }

    public boolean getUseOldUTF8Behavior() {
        return this.useOldUTF8Behavior.getValueAsBoolean();
    }

    public void setUseOldUTF8Behavior(boolean flag) {
        this.useOldUTF8Behavior.setValue(flag);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Field[] declaredFields = (class$com$mysql$jdbc$ConnectionProperties == null ? (class$com$mysql$jdbc$ConnectionProperties = ConnectionProperties.class$("com.mysql.jdbc.ConnectionProperties")) : class$com$mysql$jdbc$ConnectionProperties).getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                if (!(class$com$mysql$jdbc$ConnectionProperties$ConnectionProperty == null ? ConnectionProperties.class$("com.mysql.jdbc.ConnectionProperties$ConnectionProperty") : class$com$mysql$jdbc$ConnectionProperties$ConnectionProperty).isAssignableFrom(declaredFields[i].getType())) continue;
                PROPERTY_LIST.add(declaredFields[i]);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    class StringConnectionProperty
    extends ConnectionProperty {
        StringConnectionProperty(String propertyNameToSet, String defaultValueToSet, String[] allowableValuesToSet, String descriptionToSet, String sinceVersionToSet, String category, int orderInCategory) {
            super(propertyNameToSet, defaultValueToSet, allowableValuesToSet, 0, 0, descriptionToSet, sinceVersionToSet, category, orderInCategory);
        }

        StringConnectionProperty(String propertyNameToSet, String defaultValueToSet, String descriptionToSet, String sinceVersionToSet, String category, int orderInCategory) {
            this(propertyNameToSet, defaultValueToSet, null, descriptionToSet, sinceVersionToSet, category, orderInCategory);
        }

        boolean isRangeBased() {
            return false;
        }

        void setValue(String valueFlag) {
            this.valueAsObject = valueFlag;
        }

        String getValueAsString() {
            return (String)this.valueAsObject;
        }

        boolean hasValueConstraints() {
            return this.allowableValues != null && this.allowableValues.length > 0;
        }

        void initializeFrom(String extractedValue) throws SQLException {
            if (extractedValue != null) {
                this.validateStringValues(extractedValue);
                this.valueAsObject = extractedValue;
            } else {
                this.valueAsObject = this.defaultValue;
            }
        }
    }

    class IntegerConnectionProperty
    extends ConnectionProperty {
        IntegerConnectionProperty(String propertyNameToSet, int defaultValueToSet, String descriptionToSet, String sinceVersionToSet, String category, int orderInCategory) {
            this(propertyNameToSet, defaultValueToSet, 0, 0, descriptionToSet, sinceVersionToSet, category, orderInCategory);
        }

        IntegerConnectionProperty(String propertyNameToSet, int defaultValueToSet, int lowerBoundToSet, int upperBoundToSet, String descriptionToSet, String sinceVersionToSet, String category, int orderInCategory) {
            super(propertyNameToSet, new Integer(defaultValueToSet), null, lowerBoundToSet, upperBoundToSet, descriptionToSet, sinceVersionToSet, category, orderInCategory);
        }

        String[] getAllowableValues() {
            return null;
        }

        int getLowerBound() {
            return this.lowerBound;
        }

        boolean isRangeBased() {
            return this.getUpperBound() != this.getLowerBound();
        }

        int getUpperBound() {
            return this.upperBound;
        }

        void setValue(int valueFlag) {
            this.valueAsObject = new Integer(valueFlag);
        }

        int getValueAsInt() {
            return (Integer)this.valueAsObject;
        }

        boolean hasValueConstraints() {
            return false;
        }

        void initializeFrom(String extractedValue) throws SQLException {
            if (extractedValue != null) {
                try {
                    int intValue = Double.valueOf(extractedValue).intValue();
                    this.valueAsObject = new Integer(intValue);
                }
                catch (NumberFormatException nfe) {
                    throw new SQLException("The connection property '" + this.getPropertyName() + "' only accepts integer values. The value '" + extractedValue + "' can not be converted to an integer.", "S1009");
                }
            } else {
                this.valueAsObject = this.defaultValue;
            }
        }
    }

    class BooleanConnectionProperty
    extends ConnectionProperty {
        BooleanConnectionProperty(String propertyNameToSet, boolean defaultValueToSet, String descriptionToSet, String sinceVersionToSet, String category, int orderInCategory) {
            super(propertyNameToSet, new Boolean(defaultValueToSet), null, 0, 0, descriptionToSet, sinceVersionToSet, category, orderInCategory);
        }

        String[] getAllowableValues() {
            return new String[]{"true", "false", "yes", "no"};
        }

        boolean isRangeBased() {
            return false;
        }

        void setValue(boolean valueFlag) {
            this.valueAsObject = new Boolean(valueFlag);
        }

        boolean getValueAsBoolean() {
            return (Boolean)this.valueAsObject;
        }

        boolean hasValueConstraints() {
            return true;
        }

        void initializeFrom(String extractedValue) throws SQLException {
            if (extractedValue != null) {
                this.validateStringValues(extractedValue);
                this.valueAsObject = new Boolean(extractedValue.equalsIgnoreCase("TRUE") || extractedValue.equalsIgnoreCase("YES"));
            } else {
                this.valueAsObject = this.defaultValue;
            }
        }
    }

    abstract class ConnectionProperty
    extends DriverPropertyInfo {
        Object defaultValue;
        Object valueAsObject;
        String propertyName;
        String sinceVersion;
        String[] allowableValues;
        int lowerBound;
        int upperBound;
        String categoryName;
        int order;

        ConnectionProperty(String propertyNameToSet, Object defaultValueToSet, String[] allowableValuesToSet, int lowerBoundToSet, int upperBoundToSet, String descriptionToSet, String sinceVersionToSet, String category, int orderInCategory) {
            super(propertyNameToSet, null);
            this.description = descriptionToSet;
            this.propertyName = propertyNameToSet;
            this.defaultValue = defaultValueToSet;
            this.valueAsObject = defaultValueToSet;
            this.allowableValues = allowableValuesToSet;
            this.lowerBound = lowerBoundToSet;
            this.upperBound = upperBoundToSet;
            this.required = false;
            this.sinceVersion = sinceVersionToSet;
            this.categoryName = category;
            this.order = orderInCategory;
        }

        String[] getAllowableValues() {
            return this.allowableValues;
        }

        int getLowerBound() {
            return this.lowerBound;
        }

        int getUpperBound() {
            return this.upperBound;
        }

        void initializeFrom(Properties extractFrom) throws SQLException {
            String extractedValue = extractFrom.getProperty(this.getPropertyName());
            extractFrom.remove(this.getPropertyName());
            this.initializeFrom(extractedValue);
        }

        void initializeFrom(Reference ref) throws SQLException {
            RefAddr refAddr = ref.get(this.getPropertyName());
            if (refAddr != null) {
                String refContentAsString = (String)refAddr.getContent();
                this.initializeFrom(refContentAsString);
            }
        }

        abstract void initializeFrom(String var1) throws SQLException;

        Object getDefaultValue() {
            return this.defaultValue;
        }

        String getPropertyName() {
            return this.propertyName;
        }

        abstract boolean isRangeBased();

        abstract boolean hasValueConstraints();

        void setValueAsObject(Object obj) {
            this.valueAsObject = obj;
        }

        Object getValueAsObject() {
            return this.valueAsObject;
        }

        void storeTo(Reference ref) {
            if (this.getValueAsObject() != null) {
                ref.add(new StringRefAddr(this.getPropertyName(), this.getValueAsObject().toString()));
            }
        }

        void syncDriverPropertyInfo() {
            this.choices = this.getAllowableValues();
            this.value = this.valueAsObject != null ? this.valueAsObject.toString() : null;
        }

        void validateStringValues(String valueToValidate) throws SQLException {
            String[] validateAgainst = this.getAllowableValues();
            if (valueToValidate == null) {
                return;
            }
            if (validateAgainst == null || validateAgainst.length == 0) {
                return;
            }
            for (int i = 0; i < validateAgainst.length; ++i) {
                if (validateAgainst[i] == null || !validateAgainst[i].equalsIgnoreCase(valueToValidate)) continue;
                return;
            }
            StringBuffer errorMessageBuf = new StringBuffer();
            errorMessageBuf.append("The connection property '");
            errorMessageBuf.append(this.getPropertyName());
            errorMessageBuf.append("' only accepts values of the form: ");
            if (validateAgainst.length != 0) {
                errorMessageBuf.append("'");
                errorMessageBuf.append(validateAgainst[0]);
                errorMessageBuf.append("'");
                for (int i = 1; i < validateAgainst.length - 1; ++i) {
                    errorMessageBuf.append(", ");
                    errorMessageBuf.append("'");
                    errorMessageBuf.append(validateAgainst[i]);
                    errorMessageBuf.append("'");
                }
                errorMessageBuf.append(" or '");
                errorMessageBuf.append(validateAgainst[validateAgainst.length - 1]);
                errorMessageBuf.append("'");
            }
            errorMessageBuf.append(". The value '");
            errorMessageBuf.append(valueToValidate);
            errorMessageBuf.append("' is not in this set.");
            throw new SQLException(errorMessageBuf.toString(), "S1009");
        }

        String getCategoryName() {
            return this.categoryName;
        }

        void setCategoryName(String categoryName) {
            this.categoryName = categoryName;
        }

        int getOrder() {
            return this.order;
        }

        void setOrder(int order) {
            this.order = order;
        }
    }
}

