/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.lookup;

import java.lang.reflect.Modifier;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseSourceLocation;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeFieldBinding;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeMemberFinder;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeMethodBinding;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.NewConstructorTypeMunger;
import org.aspectj.weaver.NewFieldTypeMunger;
import org.aspectj.weaver.NewMethodTypeMunger;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.ResolvedTypeX;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;

public class EclipseTypeMunger
extends ConcreteTypeMunger {
    private ResolvedTypeX targetTypeX;
    private AbstractMethodDeclaration sourceMethod;
    private EclipseFactory world;
    private ISourceLocation sourceLocation;

    public EclipseTypeMunger(EclipseFactory world, ResolvedTypeMunger munger, ResolvedTypeX aspectType, AbstractMethodDeclaration sourceMethod) {
        super(munger, aspectType);
        this.world = world;
        this.sourceMethod = sourceMethod;
        if (sourceMethod != null) {
            this.sourceLocation = new EclipseSourceLocation(sourceMethod.compilationResult, sourceMethod.sourceStart, sourceMethod.sourceEnd);
        }
        this.targetTypeX = munger.getSignature().getDeclaringType().resolve(world.getWorld());
    }

    public static boolean supportsKind(ResolvedTypeMunger.Kind kind) {
        return kind == ResolvedTypeMunger.Field || kind == ResolvedTypeMunger.Method || kind == ResolvedTypeMunger.Constructor;
    }

    public String toString() {
        return "(EclipseTypeMunger " + this.getMunger() + ")";
    }

    public boolean munge(SourceTypeBinding sourceType) {
        if (!this.world.fromEclipse(sourceType).equals(this.targetTypeX)) {
            return false;
        }
        if (this.munger.getKind() == ResolvedTypeMunger.Field) {
            this.mungeNewField(sourceType, (NewFieldTypeMunger)this.munger);
        } else if (this.munger.getKind() == ResolvedTypeMunger.Method) {
            this.mungeNewMethod(sourceType, (NewMethodTypeMunger)this.munger);
        } else if (this.munger.getKind() == ResolvedTypeMunger.Constructor) {
            this.mungeNewConstructor(sourceType, (NewConstructorTypeMunger)this.munger);
        } else {
            throw new RuntimeException("unimplemented: " + this.munger.getKind());
        }
        return true;
    }

    private void mungeNewMethod(SourceTypeBinding sourceType, NewMethodTypeMunger munger) {
        InterTypeMethodBinding binding = new InterTypeMethodBinding(this.world, munger.getSignature(), this.aspectType, this.sourceMethod);
        this.findOrCreateInterTypeMemberFinder(sourceType).addInterTypeMethod(binding);
    }

    private void mungeNewConstructor(SourceTypeBinding sourceType, NewConstructorTypeMunger munger) {
        if (this.shouldTreatAsPublic()) {
            MethodBinding binding = this.world.makeMethodBinding(munger.getSignature());
            this.findOrCreateInterTypeMemberFinder(sourceType).addInterTypeMethod(binding);
        } else {
            InterTypeMethodBinding binding = new InterTypeMethodBinding(this.world, munger.getSignature(), this.aspectType, this.sourceMethod);
            this.findOrCreateInterTypeMemberFinder(sourceType).addInterTypeMethod(binding);
        }
    }

    private void mungeNewField(SourceTypeBinding sourceType, NewFieldTypeMunger munger) {
        if (this.shouldTreatAsPublic() && !this.targetTypeX.isInterface()) {
            FieldBinding binding = this.world.makeFieldBinding(munger.getSignature());
            this.findOrCreateInterTypeMemberFinder(sourceType).addInterTypeField(binding);
        } else {
            InterTypeFieldBinding binding = new InterTypeFieldBinding(this.world, munger.getSignature(), this.aspectType, this.sourceMethod);
            this.findOrCreateInterTypeMemberFinder(sourceType).addInterTypeField(binding);
        }
    }

    private boolean shouldTreatAsPublic() {
        return Modifier.isPublic(this.munger.getSignature().getModifiers());
    }

    private InterTypeMemberFinder findOrCreateInterTypeMemberFinder(SourceTypeBinding sourceType) {
        InterTypeMemberFinder finder = (InterTypeMemberFinder)sourceType.memberFinder;
        if (finder == null) {
            finder = new InterTypeMemberFinder();
            sourceType.memberFinder = finder;
            finder.sourceTypeBinding = sourceType;
        }
        return finder;
    }

    public ISourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(ISourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    public AbstractMethodDeclaration getSourceMethod() {
        return this.sourceMethod;
    }
}

