/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.csp;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.wicket.csp.CSPDirective;
import org.apache.wicket.csp.CSPHeaderConfiguration;
import org.apache.wicket.csp.CSPRenderable;
import org.apache.wicket.csp.ContentSecurityPolicySettings;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.lang.Args;

public class ClonedCSPValue
implements CSPRenderable {
    private final CSPHeaderConfiguration headerConfiguration;
    private final CSPDirective sourceDirective;

    public ClonedCSPValue(CSPHeaderConfiguration headerConfiguration, CSPDirective sourceDirective) {
        this.headerConfiguration = Args.notNull(headerConfiguration, "headerConfiguration");
        this.sourceDirective = Args.notNull(sourceDirective, "sourceDirective");
    }

    @Override
    public String render(ContentSecurityPolicySettings settings, RequestCycle cycle) {
        List<CSPRenderable> values = this.headerConfiguration.getDirectives().get((Object)this.sourceDirective);
        if (values == null) {
            throw new IllegalStateException("CSP directive " + this.sourceDirective + " not set, cannot clone its value.");
        }
        return values.stream().map(r -> r.render(settings, cycle)).collect(Collectors.joining(" "));
    }

    public String toString() {
        return "clone(" + this.sourceDirective.getValue() + ")";
    }
}

