/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.core.request.handler.BufferedResponseRequestHandler;
import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.util.string.Strings;

public class BufferedResponseMapper
implements IRequestMapper {
    protected String getSessionId() {
        RequestCycle requestCycle;
        ISessionStore sessionStore;
        Session session;
        String sessionId = null;
        if (Application.exists() && RequestCycle.get() != null && (session = (sessionStore = Application.get().getSessionStore()).lookup((requestCycle = RequestCycle.get()).getRequest())) != null) {
            sessionId = session.getId();
        }
        return sessionId;
    }

    protected boolean hasBufferedResponse(Url url) {
        String sessionId = this.getSessionId();
        boolean hasResponse = false;
        if (!Strings.isEmpty(sessionId)) {
            hasResponse = WebApplication.get().hasBufferedResponse(sessionId, url);
        }
        return hasResponse;
    }

    protected BufferedWebResponse getAndRemoveBufferedResponse(Url url) {
        String sessionId = this.getSessionId();
        BufferedWebResponse response = null;
        if (!Strings.isEmpty(sessionId)) {
            response = WebApplication.get().getAndRemoveBufferedResponse(sessionId, url);
        }
        return response;
    }

    private Request getRequest(Request original) {
        if (RequestCycle.get() != null) {
            return RequestCycle.get().getRequest();
        }
        return original;
    }

    @Override
    public IRequestHandler mapRequest(Request request) {
        BufferedWebResponse response = this.getAndRemoveBufferedResponse((request = this.getRequest(request)).getUrl());
        if (response != null) {
            return new BufferedResponseRequestHandler(response);
        }
        return null;
    }

    @Override
    public Url mapHandler(IRequestHandler requestHandler) {
        return null;
    }

    @Override
    public int getCompatibilityScore(Request request) {
        if (this.hasBufferedResponse((request = this.getRequest(request)).getUrl())) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }
}

