package org.apache.dvsl;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Stack;

import org.apache.velocity.context.Context;
import org.apache.velocity.VelocityContext;

/**
 *  <p>
 *  Context implementation that is the outer context
 *  during the transformation.  Holds the node stack
 *  and also protects the 'special' context elements
 *  like 'node'
 *  </p>
 *  <p>
 *  There are special elements like 'node', which is
 *  readonly and corresponds to the current node, and
 *  'attrib', which corresponds to a map of attributes
 *  for the current node.
 *  </p>
 *
 *  @author <a href="mailto:geirm@apache.org">Geir Magnusson Jr.</a>
 */
class DVSLNodeContext extends VelocityContext
{

    /**
     *  Magic context entity that corresponds
     *  to the current node
     */
    private final static String NODE = "node";

    /**
     *  Magic context entity that corresponds to
     *  a Map of attributes for the current node
     */
    private final static String ATTRIB = "attrib";

    /**
     *  Used to hold the nodes as we get invoked from
     *  within the document for applyTemplates() duties
     */
    private Stack nodeStack = new Stack();

    protected Map ctx = new HashMap();


    public DVSLNodeContext( Context context )
    {
        super(context );
    }

    private DVSLNodeContext()
    {
    }

   /**
     *  retrieves value for key from internal
     *  storage
     *
     *  @param key name of value to get
     *  @return value as object
     */
    public Object internalGet( String key )
    {
        Object o = null;

        /*
         *  special token : NODE
         *
         *  returns current node
         */

        if ( key.equals( NODE ))
        {
            return peekNode();
        }

        /*
         *  ATTRIB - returns attribute map
         */

        if( key.equals( ATTRIB ) )
        {
            DVSLNode n = peekNode();

            return n.getAttribMap();
        }

        /*
         *  start with local storage
         */

        return ctx.get( key );
    }

    /**
     *  stores the value for key to internal
     *  storage
     *
     *  @param key name of value to store
     *  @param value value to store
     *  @return previous value of key as Object
     */
    public Object internalPut( String key, Object value )
    {
        /*
         *  protect both NODE and ATTRIB for now.  We
         *  might want to let people set ATTRIB, but
         *  I suspect not
         */

        if ( key.equals( NODE ))
            return null;

        if ( key.equals( ATTRIB ) )
            return null;

        return ctx.put( key, value );
    }

    /**
     *  determines if there is a value for the
     *  given key
     *
     *  @param key name of value to check
     *  @return true if non-null value in store
     */
    public  boolean internalContainsKey(Object key)
    {
        return ctx.containsKey( key );
    }

    /**
     *  returns array of keys
     *
     *  $$$ GMJ todo
     *
     *  @return keys as []
     */
    public  Object[] internalGetKeys()
    {
        return null;
    }

    /**
     *  remove a key/value pair from the
     *  internal storage
     *
     *  @param key name of value to remove
     *  @return value removed
     */
    public  Object internalRemove(Object key)
    {
        return ctx.remove( key );
    }


    /* === routines to manage current node stack === */

    DVSLNode pushNode( DVSLNode n )
    {
        nodeStack.push( n );
        return n;
    }

     DVSLNode peekNode()
    {
        return (DVSLNode) nodeStack.peek();
    }

     DVSLNode popNode()
    {
        return (DVSLNode) nodeStack.pop();
    }

     void clearNode()
    {
        nodeStack.clear();
        return;
    }

}
