/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionParser;
import org.elasticsearch.search.SearchExtBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicParser;
import org.elasticsearch.search.aggregations.pipeline.MovAvgModel;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.elasticsearch.search.rescore.RescorerBuilder;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestionBuilder;

public interface SearchPlugin {
    default public List<ScoreFunctionSpec<?>> getScoreFunctions() {
        return Collections.emptyList();
    }

    default public List<SearchExtensionSpec<SignificanceHeuristic, SignificanceHeuristicParser>> getSignificanceHeuristics() {
        return Collections.emptyList();
    }

    default public List<SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>> getMovingAverageModels() {
        return Collections.emptyList();
    }

    default public List<FetchSubPhase> getFetchSubPhases(FetchPhaseConstructionContext context) {
        return Collections.emptyList();
    }

    default public List<SearchExtSpec<?>> getSearchExts() {
        return Collections.emptyList();
    }

    default public Map<String, Highlighter> getHighlighters() {
        return Collections.emptyMap();
    }

    default public List<SuggesterSpec<?>> getSuggesters() {
        return Collections.emptyList();
    }

    default public List<QuerySpec<?>> getQueries() {
        return Collections.emptyList();
    }

    default public List<AggregationSpec> getAggregations() {
        return Collections.emptyList();
    }

    default public List<PipelineAggregationSpec> getPipelineAggregations() {
        return Collections.emptyList();
    }

    default public List<RescorerSpec<?>> getRescorers() {
        return Collections.emptyList();
    }

    public static class FetchPhaseConstructionContext {
        private final Map<String, Highlighter> highlighters;

        public FetchPhaseConstructionContext(Map<String, Highlighter> highlighters) {
            this.highlighters = highlighters;
        }

        public Map<String, Highlighter> getHighlighters() {
            return this.highlighters;
        }
    }

    public static class SearchExtensionSpec<W extends NamedWriteable, P> {
        private final ParseField name;
        private final Writeable.Reader<? extends W> reader;
        private final P parser;

        public SearchExtensionSpec(ParseField name, Writeable.Reader<? extends W> reader, P parser) {
            this.name = name;
            this.reader = reader;
            this.parser = parser;
        }

        public SearchExtensionSpec(String name, Writeable.Reader<? extends W> reader, P parser) {
            this(new ParseField(name, new String[0]), reader, parser);
        }

        public ParseField getName() {
            return this.name;
        }

        public Writeable.Reader<? extends W> getReader() {
            return this.reader;
        }

        public P getParser() {
            return this.parser;
        }
    }

    public static class RescorerSpec<T extends RescorerBuilder<T>>
    extends SearchExtensionSpec<T, CheckedFunction<XContentParser, T, IOException>> {
        public RescorerSpec(ParseField name, Writeable.Reader<? extends T> reader, CheckedFunction<XContentParser, T, IOException> parser) {
            super(name, reader, parser);
        }

        public RescorerSpec(String name, Writeable.Reader<? extends T> reader, CheckedFunction<XContentParser, T, IOException> parser) {
            super(name, reader, parser);
        }
    }

    public static class SearchExtSpec<T extends SearchExtBuilder>
    extends SearchExtensionSpec<T, CheckedFunction<XContentParser, T, IOException>> {
        public SearchExtSpec(ParseField name, Writeable.Reader<? extends T> reader, CheckedFunction<XContentParser, T, IOException> parser) {
            super(name, reader, parser);
        }

        public SearchExtSpec(String name, Writeable.Reader<? extends T> reader, CheckedFunction<XContentParser, T, IOException> parser) {
            super(name, reader, parser);
        }
    }

    public static class PipelineAggregationSpec
    extends SearchExtensionSpec<PipelineAggregationBuilder, PipelineAggregator.Parser> {
        private final Map<String, Writeable.Reader<? extends InternalAggregation>> resultReaders = new TreeMap<String, Writeable.Reader<? extends InternalAggregation>>();
        private final Writeable.Reader<? extends PipelineAggregator> aggregatorReader;

        public PipelineAggregationSpec(ParseField name, Writeable.Reader<? extends PipelineAggregationBuilder> builderReader, Writeable.Reader<? extends PipelineAggregator> aggregatorReader, PipelineAggregator.Parser parser) {
            super(name, builderReader, parser);
            this.aggregatorReader = aggregatorReader;
        }

        public PipelineAggregationSpec(String name, Writeable.Reader<? extends PipelineAggregationBuilder> builderReader, Writeable.Reader<? extends PipelineAggregator> aggregatorReader, PipelineAggregator.Parser parser) {
            super(name, builderReader, parser);
            this.aggregatorReader = aggregatorReader;
        }

        public PipelineAggregationSpec addResultReader(Writeable.Reader<? extends InternalAggregation> resultReader) {
            return this.addResultReader(this.getName().getPreferredName(), resultReader);
        }

        public PipelineAggregationSpec addResultReader(String writeableName, Writeable.Reader<? extends InternalAggregation> resultReader) {
            this.resultReaders.put(writeableName, resultReader);
            return this;
        }

        public Writeable.Reader<? extends PipelineAggregator> getAggregatorReader() {
            return this.aggregatorReader;
        }

        public Map<String, Writeable.Reader<? extends InternalAggregation>> getResultReaders() {
            return this.resultReaders;
        }
    }

    public static class AggregationSpec
    extends SearchExtensionSpec<AggregationBuilder, Aggregator.Parser> {
        private final Map<String, Writeable.Reader<? extends InternalAggregation>> resultReaders = new TreeMap<String, Writeable.Reader<? extends InternalAggregation>>();

        public AggregationSpec(ParseField name, Writeable.Reader<? extends AggregationBuilder> reader, Aggregator.Parser parser) {
            super(name, reader, parser);
        }

        public AggregationSpec(String name, Writeable.Reader<? extends AggregationBuilder> reader, Aggregator.Parser parser) {
            super(name, reader, parser);
        }

        public AggregationSpec addResultReader(Writeable.Reader<? extends InternalAggregation> resultReader) {
            return this.addResultReader(this.getName().getPreferredName(), resultReader);
        }

        public AggregationSpec addResultReader(String writeableName, Writeable.Reader<? extends InternalAggregation> resultReader) {
            this.resultReaders.put(writeableName, resultReader);
            return this;
        }

        public Map<String, Writeable.Reader<? extends InternalAggregation>> getResultReaders() {
            return this.resultReaders;
        }
    }

    public static class QuerySpec<T extends QueryBuilder>
    extends SearchExtensionSpec<T, QueryParser<T>> {
        public QuerySpec(ParseField name, Writeable.Reader<T> reader, QueryParser<T> parser) {
            super(name, reader, parser);
        }

        public QuerySpec(String name, Writeable.Reader<T> reader, QueryParser<T> parser) {
            super(name, reader, parser);
        }
    }

    public static class SuggesterSpec<T extends SuggestionBuilder<T>>
    extends SearchExtensionSpec<T, CheckedFunction<XContentParser, T, IOException>> {
        private Writeable.Reader<? extends Suggest.Suggestion> suggestionReader;

        public SuggesterSpec(ParseField name, Writeable.Reader<T> builderReader, CheckedFunction<XContentParser, T, IOException> builderParser, Writeable.Reader<? extends Suggest.Suggestion> suggestionReader) {
            super(name, builderReader, builderParser);
            this.setSuggestionReader(suggestionReader);
        }

        public SuggesterSpec(String name, Writeable.Reader<T> builderReader, CheckedFunction<XContentParser, T, IOException> builderParser, Writeable.Reader<? extends Suggest.Suggestion> suggestionReader) {
            super(name, builderReader, builderParser);
            this.setSuggestionReader(suggestionReader);
        }

        private void setSuggestionReader(Writeable.Reader<? extends Suggest.Suggestion> reader) {
            this.suggestionReader = reader;
        }

        public Writeable.Reader<? extends Suggest.Suggestion> getSuggestionReader() {
            return this.suggestionReader;
        }
    }

    public static class ScoreFunctionSpec<T extends ScoreFunctionBuilder<T>>
    extends SearchExtensionSpec<T, ScoreFunctionParser<T>> {
        public ScoreFunctionSpec(ParseField name, Writeable.Reader<T> reader, ScoreFunctionParser<T> parser) {
            super(name, reader, parser);
        }

        public ScoreFunctionSpec(String name, Writeable.Reader<T> reader, ScoreFunctionParser<T> parser) {
            super(name, reader, parser);
        }
    }
}

