/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Iterator;
import java.util.List;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedFailoverLoadBalancerMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.loadbalancer.ExceptionFailureStatistics;
import org.apache.camel.processor.loadbalancer.FailOverLoadBalancer;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed Failover LoadBalancer")
public class ManagedFailoverLoadBalancer
extends ManagedProcessor
implements ManagedFailoverLoadBalancerMBean {
    private final FailOverLoadBalancer processor;
    private String exceptions;

    public ManagedFailoverLoadBalancer(CamelContext context, FailOverLoadBalancer processor, LoadBalanceDefinition definition) {
        super(context, processor, definition);
        this.processor = processor;
    }

    public LoadBalanceDefinition getDefinition() {
        return (LoadBalanceDefinition)super.getDefinition();
    }

    @Override
    public void reset() {
        super.reset();
        this.processor.reset();
    }

    @Override
    public Boolean getSupportExtendedInformation() {
        return true;
    }

    @Override
    public Integer getSize() {
        return this.processor.getProcessors().size();
    }

    @Override
    public Boolean isRoundRobin() {
        return this.processor.isRoundRobin();
    }

    @Override
    public Boolean isSticky() {
        return this.processor.isSticky();
    }

    @Override
    public Integer getMaximumFailoverAttempts() {
        return this.processor.getMaximumFailoverAttempts();
    }

    @Override
    public String getExceptions() {
        if (this.exceptions != null) {
            return this.exceptions;
        }
        List<Class<?>> classes = this.processor.getExceptions();
        if (classes == null || classes.isEmpty()) {
            this.exceptions = "";
        } else {
            CollectionStringBuffer csb = new CollectionStringBuffer(",");
            for (Class<?> clazz : classes) {
                csb.append(clazz.getCanonicalName());
            }
            this.exceptions = csb.toString();
        }
        return this.exceptions;
    }

    @Override
    public String getLastGoodProcessorId() {
        LoadBalanceDefinition def;
        ProcessorDefinition<?> output;
        int idx = this.processor.getLastGoodIndex();
        if (idx != -1 && (output = (def = this.getDefinition()).getOutputs().get(idx)) != null) {
            return output.getId();
        }
        return null;
    }

    @Override
    public TabularData exceptionStatistics() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.loadbalancerExceptionsTabularType());
            ExceptionFailureStatistics statistics = this.processor.getExceptionFailureStatistics();
            Iterator<Class<?>> it = statistics.getExceptions();
            boolean empty = true;
            while (it.hasNext()) {
                empty = false;
                Class<?> exception = it.next();
                String name = ObjectHelper.name(exception);
                long counter = statistics.getFailureCounter(exception);
                CompositeType ct = CamelOpenMBeanTypes.loadbalancerExceptionsCompositeType();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"exception", "failures"}, new Object[]{name, counter});
                answer.put(data);
            }
            if (empty) {
                String name = ObjectHelper.name(Exception.class);
                long counter = statistics.getFailureCounter(Exception.class);
                CompositeType ct = CamelOpenMBeanTypes.loadbalancerExceptionsCompositeType();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"exception", "failures"}, new Object[]{name, counter});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }
}

