/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.DescribeGroupsResponse;

public class DescribeGroupsRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.DESCRIBE_GROUPS.id);
    private static final String GROUP_IDS_KEY_NAME = "group_ids";
    private final List<String> groupIds;

    public DescribeGroupsRequest(List<String> groupIds) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(GROUP_IDS_KEY_NAME, (Object)groupIds.toArray());
        this.groupIds = groupIds;
    }

    public DescribeGroupsRequest(Struct struct) {
        super(struct);
        this.groupIds = new ArrayList<String>();
        for (Object groupId : struct.getArray(GROUP_IDS_KEY_NAME)) {
            this.groupIds.add((String)groupId);
        }
    }

    public List<String> groupIds() {
        return this.groupIds;
    }

    @Override
    public AbstractRequestResponse getErrorResponse(int versionId, Throwable e) {
        switch (versionId) {
            case 0: {
                return DescribeGroupsResponse.fromError(Errors.forException(e), this.groupIds);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.DESCRIBE_GROUPS.id)));
    }

    public static DescribeGroupsRequest parse(ByteBuffer buffer, int versionId) {
        return new DescribeGroupsRequest(ProtoUtils.parseRequest(ApiKeys.DESCRIBE_GROUPS.id, versionId, buffer));
    }

    public static DescribeGroupsRequest parse(ByteBuffer buffer) {
        return new DescribeGroupsRequest(CURRENT_SCHEMA.read(buffer));
    }
}

