/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.stats;

public class Histogram {
    private final BinScheme binScheme;
    private final float[] hist;
    private double count;

    public Histogram(BinScheme binScheme) {
        this.hist = new float[binScheme.bins()];
        this.count = 0.0;
        this.binScheme = binScheme;
    }

    public void record(double value) {
        int n = this.binScheme.toBin(value);
        this.hist[n] = this.hist[n] + 1.0f;
        this.count += 1.0;
    }

    public double value(double quantile) {
        if (this.count == 0.0) {
            return Double.NaN;
        }
        float sum = 0.0f;
        float quant = (float)quantile;
        for (int i = 0; i < this.hist.length - 1; ++i) {
            if (!((double)(sum += this.hist[i]) / this.count > (double)quant)) continue;
            return this.binScheme.fromBin(i);
        }
        return Double.POSITIVE_INFINITY;
    }

    public float[] counts() {
        return this.hist;
    }

    public void clear() {
        for (int i = 0; i < this.hist.length; ++i) {
            this.hist[i] = 0.0f;
        }
        this.count = 0.0;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("{");
        for (int i = 0; i < this.hist.length - 1; ++i) {
            b.append(String.format("%.10f", this.binScheme.fromBin(i)));
            b.append(':');
            b.append(String.format("%.0f", Float.valueOf(this.hist[i])));
            b.append(',');
        }
        b.append(Float.POSITIVE_INFINITY);
        b.append(':');
        b.append(this.hist[this.hist.length - 1]);
        b.append('}');
        return b.toString();
    }

    public static class LinearBinScheme
    implements BinScheme {
        private final int bins;
        private final double max;
        private final double scale;

        public LinearBinScheme(int numBins, double max) {
            this.bins = numBins;
            this.max = max;
            this.scale = max / (double)(numBins * (numBins - 1) / 2);
        }

        @Override
        public int bins() {
            return this.bins;
        }

        @Override
        public double fromBin(int b) {
            if (b == this.bins - 1) {
                return Double.POSITIVE_INFINITY;
            }
            double unscaled = (double)b * ((double)b + 1.0) / 2.0;
            return unscaled * this.scale;
        }

        @Override
        public int toBin(double x) {
            if (x < 0.0) {
                throw new IllegalArgumentException("Values less than 0.0 not accepted.");
            }
            if (x > this.max) {
                return this.bins - 1;
            }
            double scaled = x / this.scale;
            return (int)(-0.5 + Math.sqrt(2.0 * scaled + 0.25));
        }
    }

    public static class ConstantBinScheme
    implements BinScheme {
        private final double min;
        private final double max;
        private final int bins;
        private final double bucketWidth;

        public ConstantBinScheme(int bins, double min, double max) {
            if (bins < 2) {
                throw new IllegalArgumentException("Must have at least 2 bins.");
            }
            this.min = min;
            this.max = max;
            this.bins = bins;
            this.bucketWidth = (max - min) / (double)(bins - 2);
        }

        @Override
        public int bins() {
            return this.bins;
        }

        @Override
        public double fromBin(int b) {
            if (b == 0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (b == this.bins - 1) {
                return Double.POSITIVE_INFINITY;
            }
            return this.min + (double)(b - 1) * this.bucketWidth;
        }

        @Override
        public int toBin(double x) {
            if (x < this.min) {
                return 0;
            }
            if (x > this.max) {
                return this.bins - 1;
            }
            return (int)((x - this.min) / this.bucketWidth) + 1;
        }
    }

    public static interface BinScheme {
        public int bins();

        public int toBin(double var1);

        public double fromBin(int var1);
    }
}

