/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.web;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.opencsv.CSVWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.services.ProfileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)ClientServlet.class.getName());
    private static final long serialVersionUID = 2928875960103325238L;
    private ProfileService profileService;
    private String profileIdCookieName = "context-profile-id";
    private String allowedProfileDownloadFormats;
    private final String FILE_NAME_WO_EXT = "my-profile";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        logger.info("ClientServlet initialized.");
    }

    public void destroy() {
        super.destroy();
        logger.info("Client servlet shutdown.");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String[] pathInfo = req.getPathInfo().substring(1).split("\\.");
        if (pathInfo != null && pathInfo.length > 0) {
            String operation = pathInfo[0];
            String param = pathInfo[1];
            switch (operation) {
                case "myprofile": {
                    if (this.allowedProfileDownloadFormats.contains(param)) {
                        this.donwloadCurrentProfile(req, resp, param);
                        break;
                    }
                    resp.setStatus(400);
                    break;
                }
                default: {
                    resp.setStatus(404);
                    break;
                }
            }
        } else {
            resp.setStatus(404);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    public void donwloadCurrentProfile(HttpServletRequest request, HttpServletResponse response, String downloadFileType) throws ServletException, IOException {
        Profile currentProfile;
        String cookieProfileId = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this.profileIdCookieName.equals(cookie.getName())) continue;
                cookieProfileId = cookie.getValue();
            }
        }
        if (cookieProfileId != null && (currentProfile = this.profileService.load(cookieProfileId)) != null) {
            switch (downloadFileType) {
                case "yaml": {
                    this.prepareYamlFileToDownload(response, currentProfile, false);
                    break;
                }
                case "json": {
                    this.prepareJsonFileToDownload(response, currentProfile);
                    break;
                }
                case "csv": {
                    this.prepareCsvFileToDownload(response, currentProfile, request.getParameter("vertical") != null);
                    break;
                }
                case "text": {
                    this.prepareYamlFileToDownload(response, currentProfile, true);
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private void prepareCsvFileToDownload(HttpServletResponse response, Profile currentProfile, boolean vertical) {
        response.setContentType("text/csv");
        response.setHeader("Content-Disposition", "attachment; filename=\"my-profile.csv\"");
        try {
            StringWriter writer = new StringWriter();
            CSVWriter csvWriter = new CSVWriter((Writer)writer);
            ServletOutputStream outputStream = response.getOutputStream();
            if (vertical) {
                csvWriter.writeNext(new String[]{"name", "value"});
                for (Map.Entry entry : currentProfile.getProperties().entrySet()) {
                    csvWriter.writeNext(new String[]{(String)entry.getKey(), entry.getValue().toString().trim().replace("\n", "")});
                }
            } else {
                Set keySet = currentProfile.getProperties().keySet();
                ArrayList<String> values = new ArrayList<String>();
                for (Object value : currentProfile.getProperties().values()) {
                    values.add(value.toString().trim().replace("\n", ""));
                }
                csvWriter.writeNext(keySet.toArray(new String[keySet.size()]));
                csvWriter.writeNext(values.toArray(new String[values.size()]));
            }
            outputStream.write(writer.toString().getBytes());
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void prepareJsonFileToDownload(HttpServletResponse response, Profile currentProfile) {
        response.setContentType("text/json");
        response.setHeader("Content-Disposition", "attachment; filename=\"my-profile.json\"");
        try {
            ObjectMapper mapper = new ObjectMapper();
            String jsonContent = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)currentProfile.getProperties());
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(jsonContent.getBytes());
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void prepareYamlFileToDownload(HttpServletResponse response, Profile currentProfile, boolean asTextFile) {
        response.setContentType("text/" + (asTextFile ? "plain" : "yaml"));
        response.setHeader("Content-Disposition", "attachment; filename=\"my-profile" + (asTextFile ? ".txt" : ".yml") + "\"");
        try {
            YAMLFactory yf = new YAMLFactory();
            ObjectMapper mapper = new ObjectMapper((JsonFactory)yf);
            String yamlContent = mapper.writeValueAsString((Object)currentProfile.getProperties());
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(yamlContent.getBytes());
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public void setAllowedProfileDownloadFormats(String allowedProfileDownloadFormats) {
        this.allowedProfileDownloadFormats = allowedProfileDownloadFormats;
    }

    public void setProfileIdCookieName(String profileIdCookieName) {
        this.profileIdCookieName = profileIdCookieName;
    }
}

