/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.Transactional;
import org.apache.aries.transaction.TransactionalAnnotationAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentTxData {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentTxData.class);
    private static final int BANNED_MODIFIERS = 10;
    private Map<Method, TransactionalAnnotationAttributes> txMap = new HashMap<Method, TransactionalAnnotationAttributes>();
    private boolean isTransactional;
    private Class<?> beanClass;

    public ComponentTxData(Class<?> c) {
        this.beanClass = c;
        this.isTransactional = false;
        for (Class<?> current = c; current != Object.class; current = current.getSuperclass()) {
            this.isTransactional |= this.parseTxData(current);
            for (Class<?> iface : current.getInterfaces()) {
                this.isTransactional |= this.parseTxData(iface);
            }
        }
    }

    TransactionalAnnotationAttributes getEffectiveType(Method m) {
        if (this.txMap.containsKey(m)) {
            return this.txMap.get(m);
        }
        try {
            Method effectiveMethod = this.beanClass.getDeclaredMethod(m.getName(), m.getParameterTypes());
            TransactionalAnnotationAttributes txData = this.txMap.get(effectiveMethod);
            this.txMap.put(m, txData);
            return txData;
        }
        catch (NoSuchMethodException e) {
            return this.getFromMethod(m);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Security exception when determining effective method", e);
        }
    }

    private TransactionalAnnotationAttributes getFromMethod(Method m) {
        try {
            Method effectiveMethod = this.beanClass.getMethod(m.getName(), m.getParameterTypes());
            TransactionalAnnotationAttributes txData = this.txMap.get(effectiveMethod);
            this.txMap.put(m, txData);
            return txData;
        }
        catch (NoSuchMethodException e1) {
            LOG.debug("No method found when scanning for transactions", (Throwable)e1);
            return null;
        }
        catch (SecurityException e1) {
            throw new RuntimeException("Security exception when determining effective method", e1);
        }
    }

    private boolean parseTxData(Class<?> c) {
        boolean shouldAssignInterceptor = false;
        Transactional classAnnotation = c.getAnnotation(Transactional.class);
        Transactional.TxType defaultType = ComponentTxData.getType(classAnnotation);
        if (defaultType != null) {
            shouldAssignInterceptor = true;
        }
        for (Method m : c.getDeclaredMethods()) {
            try {
                Transactional methodAnnotation = m.getAnnotation(Transactional.class);
                Transactional.TxType t = ComponentTxData.getType(methodAnnotation);
                if (t != null) {
                    TransactionalAnnotationAttributes txData = new TransactionalAnnotationAttributes(t, methodAnnotation.dontRollbackOn(), methodAnnotation.rollbackOn());
                    ComponentTxData.assertAllowedModifier(m);
                    this.txMap.put(m, txData);
                    shouldAssignInterceptor = true;
                    continue;
                }
                if (defaultType == null) continue;
                this.txMap.put(m, new TransactionalAnnotationAttributes(defaultType, classAnnotation.dontRollbackOn(), classAnnotation.rollbackOn()));
            }
            catch (IllegalStateException e) {
                LOG.warn("Invalid transaction annoation found", (Throwable)e);
            }
        }
        return shouldAssignInterceptor;
    }

    private static Transactional.TxType getType(Transactional jtaT) {
        return jtaT != null ? jtaT.value() : null;
    }

    private static void assertAllowedModifier(Method m) {
        if ((m.getModifiers() & 0xA) != 0) {
            throw new IllegalArgumentException("Transaction annotation is not allowed on private or static method " + m);
        }
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }
}

