/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.Platform;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.value.AtomicValue;

public class CollatingAtomicComparer
implements AtomicComparer {
    private StringCollator collator;
    private String collationURI;
    private Platform platform;
    private boolean canReturnCollationKeys;

    public CollatingAtomicComparer(StringCollator stringCollator, Platform platform) {
        if (stringCollator == null) {
            this.collator = CodepointCollator.getInstance();
            this.collationURI = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
        } else {
            this.collator = stringCollator;
            this.collationURI = "*unknown*";
        }
        this.platform = platform;
        this.canReturnCollationKeys = platform.canReturnCollationKeys(this.collator);
    }

    public String getCollationURI() {
        return this.collationURI;
    }

    public int compareAtomicValues(AtomicValue atomicValue, AtomicValue atomicValue2) {
        if (atomicValue == null) {
            if (atomicValue2 == null) {
                return 0;
            }
            return -1;
        }
        if (atomicValue2 == null) {
            return 1;
        }
        return this.collator.compareStrings(atomicValue.getStringValue(), atomicValue2.getStringValue());
    }

    public boolean comparesEqual(AtomicValue atomicValue, AtomicValue atomicValue2) {
        return this.compareAtomicValues(atomicValue, atomicValue2) == 0;
    }

    public ComparisonKey getComparisonKey(AtomicValue atomicValue) {
        if (this.canReturnCollationKeys) {
            return new ComparisonKey(513, this.collator.getCollationKey(atomicValue.getStringValue(), this.platform));
        }
        return new ComparisonKey(513, atomicValue.getStringValue());
    }
}

