/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger;

import java.util.LinkedList;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import org.apache.commons.messenger.DefaultServerSession;
import org.apache.commons.messenger.SessionFactory;

public class DefaultServerSessionPool
implements ServerSessionPool {
    private LinkedList list = new LinkedList();
    private SessionFactory sessionFactory;
    private MessageListener listener;
    private long timeout = 5000L;

    public DefaultServerSessionPool() {
    }

    public DefaultServerSessionPool(SessionFactory sessionFactory, MessageListener listener, int numberOfServerSessions) throws JMSException {
        this.sessionFactory = sessionFactory;
        this.listener = listener;
        int i = 0;
        while (i < numberOfServerSessions) {
            this.list.add(this.createServerSession());
            ++i;
        }
    }

    public synchronized ServerSession getServerSession() throws JMSException {
        while (this.list.isEmpty()) {
            try {
                this.wait(this.timeout);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        return (ServerSession)this.list.removeFirst();
    }

    public synchronized void putServerSession(ServerSession serverSession) {
        this.list.addLast(serverSession);
        this.notify();
    }

    protected ServerSession createServerSession() throws JMSException {
        Session session = this.sessionFactory.createSession();
        final DefaultServerSession serverSession = new DefaultServerSession(session);
        session.setMessageListener(new MessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(Message message) {
                try {
                    DefaultServerSessionPool.this.listener.onMessage(message);
                    Object var3_2 = null;
                    DefaultServerSessionPool.this.putServerSession(serverSession);
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    DefaultServerSessionPool.this.putServerSession(serverSession);
                    throw throwable;
                }
            }
        });
        return serverSession;
    }
}

