/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.monitoring;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import org.apache.openejb.util.Duration;

public class MBeanPojoWrapper
implements DynamicMBean {
    private final Object delegate;
    private final String name;
    private MBeanInfo info;
    private final Map<String, PropertyDescriptor> attributeMap = new HashMap<String, PropertyDescriptor>();
    private static final Set<Class<?>> SUPPORTED_PROPERTY_TYPES = new HashSet<Class<?>>(){
        {
            this.add(Integer.class);
            this.add(Boolean.class);
            this.add(Byte.class);
            this.add(Short.class);
            this.add(Float.class);
            this.add(Long.class);
            this.add(Double.class);
            this.add(Integer.TYPE);
            this.add(Boolean.TYPE);
            this.add(Byte.TYPE);
            this.add(Short.TYPE);
            this.add(Float.TYPE);
            this.add(Long.TYPE);
            this.add(Double.TYPE);
            this.add(String.class);
            this.add(Duration.class);
        }
    };

    public MBeanPojoWrapper(String name, Object delegate) {
        this.name = name;
        if (delegate == null) {
            throw new NullPointerException("Delegate cannot be null");
        }
        this.delegate = delegate;
        this.scan(delegate.getClass());
    }

    private void scan(Class clazz) {
        ArrayList<MBeanAttributeInfo> mBeanAttributeInfoList = new ArrayList<MBeanAttributeInfo>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String propertyName = propertyDescriptor.getName();
                Class<?> propertyType = propertyDescriptor.getPropertyType();
                if (!MBeanPojoWrapper.isSupported(propertyType)) continue;
                this.attributeMap.put(propertyName, propertyDescriptor);
                try {
                    mBeanAttributeInfoList.add(new MBeanAttributeInfo(propertyName, "", propertyDescriptor.getReadMethod(), null));
                }
                catch (javax.management.IntrospectionException introspectionException) {
                    // empty catch block
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        this.info = new MBeanInfo(this.name, "Auto-created by OpenEJB", mBeanAttributeInfoList.toArray(new MBeanAttributeInfo[mBeanAttributeInfoList.size()]), null, new MBeanOperationInfo[0], new MBeanNotificationInfo[0]);
    }

    private static boolean isSupported(Class<?> type) {
        return SUPPORTED_PROPERTY_TYPES.contains(type);
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (!this.attributeMap.containsKey(attribute)) {
            throw new AttributeNotFoundException();
        }
        try {
            return this.attributeMap.get(attribute).getReadMethod().invoke(this.delegate, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (String attribute : attributes) {
            try {
                list.add(new Attribute(attribute, this.getAttribute(attribute)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.info;
    }
}

