/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.metrics;

import io.smallrye.faulttolerance.ExecutorHolder;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MetricsProvider;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import io.smallrye.faulttolerance.core.metrics.MicroProfileMetricsRecorder;
import io.smallrye.faulttolerance.core.timer.Timer;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

@Singleton
public class MicroProfileMetricsProvider
implements MetricsProvider {
    @Inject
    @RegistryType(type=MetricRegistry.Type.BASE)
    MetricRegistry registry;
    @Inject
    @ConfigProperty(name="MP_Fault_Tolerance_Metrics_Enabled", defaultValue="true")
    boolean metricsEnabled;
    @Inject
    ExecutorHolder executorHolder;
    private final Map<Object, MetricsRecorder> cache = new ConcurrentHashMap<Object, MetricsRecorder>();

    @PostConstruct
    void init() {
        Metadata metadata = Metadata.builder().withName("ft.timer.scheduled").withUnit("none").build();
        Timer timer = this.executorHolder.getTimer();
        this.registry.gauge(metadata, (Object)timer, Timer::countScheduledTasks, new Tag[]{new Tag("id", "" + timer.getId())});
    }

    public boolean isEnabled() {
        return this.metricsEnabled;
    }

    public MetricsRecorder create(MeteredOperation operation) {
        if (this.metricsEnabled) {
            return this.cache.computeIfAbsent(operation.cacheKey(), ignored -> new MicroProfileMetricsRecorder(this.registry, operation));
        }
        return MetricsRecorder.NOOP;
    }
}

