/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util.classloader;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ClassLoaderAwareHandler
implements InvocationHandler {
    private final Object delegate;
    private final ClassLoader loader;
    private final String toString;

    public ClassLoaderAwareHandler(String toString, Object delegate, ClassLoader loader) {
        this.delegate = delegate;
        this.loader = loader;
        this.toString = toString;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.toString != null && method.getName().equals("toString")) {
            return this.toString;
        }
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(this.loader);
        try {
            Object object = method.invoke(this.delegate, args);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }
}

