/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.function.string;

import java.util.List;
import org.apache.qpid.server.query.engine.parsing.converter.DateTimeConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.AbstractFunctionExpression;
import org.apache.qpid.server.query.engine.validation.FunctionParameterTypePredicate;
import org.apache.qpid.server.query.engine.validation.FunctionParametersValidator;

public class LengthExpression<T, R>
extends AbstractFunctionExpression<T, Integer> {
    private final FunctionParameterTypePredicate<R> _typeValidator = FunctionParameterTypePredicate.builder().allowNulls().allowBooleans().allowEnums().allowDateTimeTypes().allowNumbers().allowStrings().build();

    public LengthExpression(String alias, List<ExpressionNode<T, ?>> args) {
        super(alias, args);
        FunctionParametersValidator.requireParameters(1, args, this);
    }

    @Override
    public Integer apply(T value) {
        R arg = this.evaluateChild(0, value, this._typeValidator);
        if (arg == null) {
            return 0;
        }
        String converted = DateTimeConverter.isDateTime(arg) ? DateTimeConverter.toStringMapper().apply(arg) : String.valueOf(arg);
        return converted.length();
    }
}

