/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.server.protocol.v1_0.codec.FixedFourWriter;
import org.apache.qpid.server.protocol.v1_0.codec.FixedOneWriter;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;

public class IntegerWriter {
    private static final byte EIGHT_BYTE_FORMAT_CODE = 113;
    private static final byte ONE_BYTE_FORMAT_CODE = 84;
    private static final ValueWriter.Factory<Integer> FACTORY = (registry, i) -> {
        if (i >= -128 && i <= 127) {
            return new IntegerFixedOneWriter((Integer)i);
        }
        return new IntegerFixedFourWriter((Integer)i);
    };

    public static void register(ValueWriter.Registry registry) {
        registry.register(Integer.class, FACTORY);
    }

    private static class IntegerFixedOneWriter
    extends FixedOneWriter<Integer> {
        public IntegerFixedOneWriter(Integer value) {
            super(value.byteValue());
        }

        @Override
        protected byte getFormatCode() {
            return 84;
        }
    }

    private static class IntegerFixedFourWriter
    extends FixedFourWriter<Integer> {
        public IntegerFixedFourWriter(Integer object) {
            super(object);
        }

        @Override
        byte getFormatCode() {
            return 113;
        }
    }
}

