/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.serialization;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.nifi.registry.serialization.SerializationException;
import org.apache.nifi.registry.serialization.Serializer;
import org.apache.nifi.registry.serialization.VersionedSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMultiVersionSerializer<T>
implements Serializer<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMultiVersionSerializer.class);
    private final Map<Integer, VersionedSerializer<T>> serializersByVersion;
    private final VersionedSerializer<T> defaultSerializer;
    private final List<Integer> descendingVersions;
    public static final int MAX_HEADER_BYTES = 1024;

    public AbstractMultiVersionSerializer() {
        Map<Integer, VersionedSerializer<T>> tempSerializers = this.createVersionedSerializers();
        this.serializersByVersion = Collections.unmodifiableMap(tempSerializers);
        this.defaultSerializer = tempSerializers.get(this.getCurrentDataModelVersion());
        ArrayList<Integer> sortedVersions = new ArrayList<Integer>(this.serializersByVersion.keySet());
        sortedVersions.sort(Collections.reverseOrder(Integer::compareTo));
        this.descendingVersions = sortedVersions;
    }

    protected abstract Map<Integer, VersionedSerializer<T>> createVersionedSerializers();

    protected abstract int getCurrentDataModelVersion();

    @Override
    public void serialize(T entity, OutputStream out) throws SerializationException {
        this.defaultSerializer.serialize(this.getCurrentDataModelVersion(), entity, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T deserialize(InputStream input) throws SerializationException {
        InputStream markSupportedInput = input.markSupported() ? input : new BufferedInputStream(input);
        markSupportedInput.mark(1024);
        for (int serializerVersion : this.descendingVersions) {
            int version;
            VersionedSerializer<T> serializer = this.serializersByVersion.get(serializerVersion);
            try {
                version = serializer.readDataModelVersion(markSupportedInput);
                if (!this.serializersByVersion.containsKey(version)) {
                    throw new SerializationException(String.format("Version %d was returned by %s, but no serializer is registered for that version.", version, serializer));
                }
            }
            catch (SerializationException e) {
                logger.debug("Deserialization failed with {}", serializer, (Object)e);
                continue;
            }
            finally {
                try {
                    markSupportedInput.reset();
                }
                catch (IOException resetException) {
                    logger.error("Unable to reset the input stream.", (Throwable)resetException);
                }
                continue;
            }
            return this.serializersByVersion.get(version).deserialize(markSupportedInput);
        }
        throw new SerializationException("Unable to find a serializer compatible with the input.");
    }
}

