/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Optional;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.internal.CollectionUtils;

public class Version
implements Comparable<Version> {
    private int[] parts;

    public static Version of(String value) {
        if (value == null) {
            return null;
        }
        return new Version(value);
    }

    public Version(String value) {
        if (StringUtils.isEmpty(value)) {
            value = "0";
        }
        String[] sParts = StringUtils.split(value, '.');
        this.parts = new int[sParts.length];
        for (int i = 0; i < sParts.length; ++i) {
            try {
                this.parts[i] = sParts[i].isEmpty() ? 0 : Integer.parseInt(sParts[i]);
                continue;
            }
            catch (NumberFormatException e) {
                this.parts[i] = Integer.MAX_VALUE;
            }
        }
    }

    public Optional<Integer> getPart(int index) {
        if (index < 0 || this.parts.length <= index) {
            return CollectionUtils.empty();
        }
        return CollectionUtils.optional(this.parts[index]);
    }

    public Optional<Integer> getMajor() {
        return this.getPart(0);
    }

    public Optional<Integer> getMinor() {
        return this.getPart(1);
    }

    public Optional<Integer> getMaintenance() {
        return this.getPart(2);
    }

    public boolean isAtLeast(Version v) {
        return this.isAtLeast(v, false);
    }

    public boolean isAtLeast(Version v, boolean exclusive) {
        int i;
        for (i = 0; i < Math.min(this.parts.length, v.parts.length); ++i) {
            int c = v.parts[i] - this.parts[i];
            if (c > 0) {
                return false;
            }
            if (c >= 0) continue;
            return true;
        }
        for (i = this.parts.length; i < v.parts.length; ++i) {
            if (v.parts[i] == 0) continue;
            return false;
        }
        return !exclusive;
    }

    public boolean isAtMost(Version v) {
        return this.isAtMost(v, false);
    }

    public boolean isAtMost(Version v, boolean exclusive) {
        int i;
        for (i = 0; i < Math.min(this.parts.length, v.parts.length); ++i) {
            int c = this.parts[i] - v.parts[i];
            if (c > 0) {
                return false;
            }
            if (c >= 0) continue;
            return true;
        }
        for (i = this.parts.length; i < v.parts.length; ++i) {
            if (v.parts[i] <= 0) continue;
            return true;
        }
        return !exclusive;
    }

    public boolean equals(Version v) {
        for (int i = 0; i < Math.min(this.parts.length, v.parts.length); ++i) {
            if (v.parts[i] - this.parts[i] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        return o instanceof Version && this.equals((Version)o);
    }

    public String toString() {
        return StringUtils.join(this.parts, '.');
    }

    @Override
    public int compareTo(Version v) {
        for (int i = 0; i < Math.min(this.parts.length, v.parts.length); ++i) {
            int c = this.parts[i] - v.parts[i];
            if (c == 0) continue;
            return c;
        }
        return this.parts.length - v.parts.length;
    }
}

