/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.james.mime4j.ExampleMail;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.apache.james.mime4j.stream.RecursionMode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MimeTokenStreamTest {
    MimeTokenStream stream;

    @Before
    public void setUp() throws Exception {
        this.stream = new MimeTokenStream();
    }

    @Test
    public void testSetRecursionModeBeforeParse() throws Exception {
        this.stream.setRecursionMode(RecursionMode.M_NO_RECURSE);
        this.stream.parse((InputStream)new ByteArrayInputStream(ExampleMail.MAIL_WITH_RFC822_PART_BYTES));
        this.checkNextIs(EntityState.T_START_HEADER);
        this.checkNextIs(EntityState.T_FIELD);
        this.checkNextIs(EntityState.T_FIELD);
        this.checkNextIs(EntityState.T_FIELD);
        this.checkNextIs(EntityState.T_FIELD);
        this.checkNextIs(EntityState.T_FIELD);
        this.checkNextIs(EntityState.T_FIELD);
        this.checkNextIs(EntityState.T_END_HEADER);
        this.checkNextIs(EntityState.T_START_MULTIPART);
        this.checkNextIs(EntityState.T_PREAMBLE);
        this.checkNextIs(EntityState.T_START_BODYPART);
        this.checkNextIs(EntityState.T_START_HEADER);
        this.checkNextIs(EntityState.T_END_HEADER);
        this.checkNextIs(EntityState.T_BODY);
        this.checkNextIs(EntityState.T_END_BODYPART);
        this.checkNextIs(EntityState.T_START_BODYPART);
        this.checkNextIs(EntityState.T_START_HEADER);
        this.checkNextIs(EntityState.T_FIELD);
        this.checkNextIs(EntityState.T_END_HEADER);
        this.checkNextIs(EntityState.T_BODY);
        this.checkNextIs(EntityState.T_END_BODYPART);
        this.checkNextIs(EntityState.T_START_BODYPART);
        this.checkNextIs(EntityState.T_START_HEADER);
        this.checkNextIs(EntityState.T_FIELD);
        this.checkNextIs(EntityState.T_END_HEADER);
        this.checkNextIs(EntityState.T_BODY);
        this.checkNextIs(EntityState.T_END_BODYPART);
        this.checkNextIs(EntityState.T_START_BODYPART);
        this.checkNextIs(EntityState.T_START_HEADER);
        this.checkNextIs(EntityState.T_FIELD);
        this.checkNextIs(EntityState.T_END_HEADER);
        this.checkNextIs(EntityState.T_BODY);
        this.checkNextIs(EntityState.T_END_BODYPART);
        this.checkNextIs(EntityState.T_EPILOGUE);
        this.checkNextIs(EntityState.T_END_MULTIPART);
        this.checkNextIs(EntityState.T_END_MESSAGE);
        this.checkNextIs(EntityState.T_END_OF_STREAM);
    }

    private void checkNextIs(EntityState expected) throws Exception {
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)expected), (Object)MimeTokenStream.stateToString((EntityState)this.stream.next()));
    }
}

