/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.polaris.core.entity.Identifiable;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;

public class EntityNameLookupRecord
implements Identifiable {
    private final long catalogId;
    private final long id;
    private final long parentId;
    private final String name;
    private final int typeCode;
    private final int subTypeCode;

    @Override
    public long getCatalogId() {
        return this.catalogId;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public long getParentId() {
        return this.parentId;
    }

    public String getName() {
        return this.name;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public PolarisEntityType getType() {
        return PolarisEntityType.fromCode(this.typeCode);
    }

    public int getSubTypeCode() {
        return this.subTypeCode;
    }

    public PolarisEntitySubType getSubType() {
        return PolarisEntitySubType.fromCode(this.subTypeCode);
    }

    @JsonCreator
    public EntityNameLookupRecord(@JsonProperty(value="catalogId") long catalogId, @JsonProperty(value="id") long id, @JsonProperty(value="parentId") long parentId, @JsonProperty(value="name") String name, @JsonProperty(value="typeCode") int typeCode, @JsonProperty(value="subTypeCode") int subTypeCode) {
        this.catalogId = catalogId;
        this.id = id;
        this.parentId = parentId;
        this.name = name;
        this.typeCode = typeCode;
        this.subTypeCode = subTypeCode;
    }

    public EntityNameLookupRecord(PolarisBaseEntity entity) {
        this.catalogId = entity.getCatalogId();
        this.id = entity.getId();
        this.parentId = entity.getParentId();
        this.typeCode = entity.getTypeCode();
        this.name = entity.getName();
        this.subTypeCode = entity.getSubTypeCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityNameLookupRecord)) {
            return false;
        }
        EntityNameLookupRecord that = (EntityNameLookupRecord)o;
        return this.catalogId == that.catalogId && this.id == that.id && this.parentId == that.parentId && this.typeCode == that.typeCode && this.subTypeCode == that.subTypeCode && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.catalogId, this.id, this.parentId, this.name, this.typeCode, this.subTypeCode);
    }

    public String toString() {
        return "PolarisEntitiesActiveRecord{catalogId=" + this.catalogId + ", id=" + this.id + ", parentId=" + this.parentId + ", name='" + this.name + "', typeCode=" + this.typeCode + ", subTypeCode=" + this.subTypeCode + "}";
    }
}

