/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.connection.iceberg;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.polaris.core.admin.model.ConnectionConfigInfo;
import org.apache.polaris.core.admin.model.IcebergRestConnectionConfigInfo;
import org.apache.polaris.core.admin.model.ServiceIdentityInfo;
import org.apache.polaris.core.connection.AuthenticationParametersDpo;
import org.apache.polaris.core.connection.ConnectionConfigInfoDpo;
import org.apache.polaris.core.connection.ConnectionType;
import org.apache.polaris.core.connection.iceberg.IcebergCatalogPropertiesProvider;
import org.apache.polaris.core.credentials.PolarisCredentialManager;
import org.apache.polaris.core.credentials.connection.ConnectionCredentials;
import org.apache.polaris.core.identity.dpo.ServiceIdentityInfoDpo;
import org.apache.polaris.core.identity.provider.ServiceIdentityProvider;

public class IcebergRestConnectionConfigInfoDpo
extends ConnectionConfigInfoDpo
implements IcebergCatalogPropertiesProvider {
    private final String remoteCatalogName;

    public IcebergRestConnectionConfigInfoDpo(@JsonProperty(value="uri", required=true) @Nonnull String uri, @JsonProperty(value="authenticationParameters", required=true) @Nonnull AuthenticationParametersDpo authenticationParameters, @JsonProperty(value="serviceIdentity", required=false) @Nullable ServiceIdentityInfoDpo serviceIdentityInfo, @JsonProperty(value="remoteCatalogName", required=false) @Nullable String remoteCatalogName) {
        super(ConnectionType.ICEBERG_REST.getCode(), uri, authenticationParameters, serviceIdentityInfo);
        this.remoteCatalogName = remoteCatalogName;
    }

    public String getRemoteCatalogName() {
        return this.remoteCatalogName;
    }

    @Override
    @Nonnull
    public Map<String, String> asIcebergCatalogProperties(PolarisCredentialManager credentialManager) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("uri", this.getUri());
        if (this.getRemoteCatalogName() != null) {
            properties.put("warehouse", this.getRemoteCatalogName());
        }
        properties.putAll(this.getAuthenticationParameters().asIcebergCatalogProperties(credentialManager));
        ConnectionCredentials connectionCredentials = credentialManager.getConnectionCredentials(this);
        properties.putAll(connectionCredentials.credentials());
        return properties;
    }

    @Override
    public ConnectionConfigInfoDpo withServiceIdentity(@Nonnull ServiceIdentityInfoDpo serviceIdentityInfo) {
        return new IcebergRestConnectionConfigInfoDpo(this.getUri(), this.getAuthenticationParameters(), serviceIdentityInfo, this.getRemoteCatalogName());
    }

    @Override
    public ConnectionConfigInfo asConnectionConfigInfoModel(ServiceIdentityProvider serviceIdentityProvider) {
        return IcebergRestConnectionConfigInfo.builder().setConnectionType(ConnectionConfigInfo.ConnectionTypeEnum.ICEBERG_REST).setUri(this.getUri()).setRemoteCatalogName(this.getRemoteCatalogName()).setAuthenticationParameters(this.getAuthenticationParameters().asAuthenticationParametersModel()).setServiceIdentity((ServiceIdentityInfo)Optional.ofNullable(this.getServiceIdentity()).map(serviceIdentityInfoDpo -> serviceIdentityInfoDpo.asServiceIdentityInfoModel(serviceIdentityProvider)).orElse(null)).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectionTypeCode", this.getConnectionTypeCode()).add("uri", (Object)this.getUri()).add("remoteCatalogName", (Object)this.getRemoteCatalogName()).add("authenticationParameters", (Object)this.getAuthenticationParameters().toString()).add("serviceIdentity", (Object)this.getServiceIdentity()).toString();
    }
}

