/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;

public final class PageBlobsGetPageRangesDiffHeaders {
    private String xMsVersion;
    private Long xMsBlobContentLength;
    private String eTag;
    private DateTimeRfc1123 lastModified;
    private String xMsRequestId;
    private String xMsClientRequestId;
    private DateTimeRfc1123 date;
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_BLOB_CONTENT_LENGTH = HttpHeaderName.fromString((String)"x-ms-blob-content-length");

    public PageBlobsGetPageRangesDiffHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        String xMsBlobContentLength = rawHeaders.getValue(X_MS_BLOB_CONTENT_LENGTH);
        this.xMsBlobContentLength = xMsBlobContentLength != null ? Long.valueOf(Long.parseLong(xMsBlobContentLength)) : null;
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        String lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED);
        this.lastModified = lastModified != null ? new DateTimeRfc1123(lastModified) : null;
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        this.xMsClientRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        this.date = date != null ? new DateTimeRfc1123(date) : null;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public PageBlobsGetPageRangesDiffHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public Long getXMsBlobContentLength() {
        return this.xMsBlobContentLength;
    }

    public PageBlobsGetPageRangesDiffHeaders setXMsBlobContentLength(Long xMsBlobContentLength) {
        this.xMsBlobContentLength = xMsBlobContentLength;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public PageBlobsGetPageRangesDiffHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public PageBlobsGetPageRangesDiffHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public PageBlobsGetPageRangesDiffHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public PageBlobsGetPageRangesDiffHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public PageBlobsGetPageRangesDiffHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }
}

