/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.ImmutableHTTPHeader;
import org.apache.iceberg.rest.ImmutableHTTPHeaders;
import org.immutables.value.Value;

@Value.Style(depluralize=true)
@Value.Immutable
public interface HTTPHeaders {
    public static final HTTPHeaders EMPTY = HTTPHeaders.of(new HTTPHeader[0]);

    public Set<HTTPHeader> entries();

    default public Set<HTTPHeader> entries(String name) {
        return this.entries().stream().filter(header -> header.name().equalsIgnoreCase(name)).collect(Collectors.toSet());
    }

    default public boolean contains(String name) {
        return this.entries().stream().anyMatch(header -> header.name().equalsIgnoreCase(name));
    }

    default public HTTPHeaders putIfAbsent(HTTPHeader header) {
        Preconditions.checkNotNull((Object)header, (Object)"header");
        return this.contains(header.name()) ? this : ImmutableHTTPHeaders.builder().from(this).addEntry(header).build();
    }

    default public HTTPHeaders putIfAbsent(HTTPHeaders headers) {
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        List newHeaders = headers.entries().stream().filter(e -> !this.contains(e.name())).collect(Collectors.toList());
        return newHeaders.isEmpty() ? this : ImmutableHTTPHeaders.builder().from(this).addAllEntries(newHeaders).build();
    }

    public static HTTPHeaders of(HTTPHeader ... headers) {
        return ImmutableHTTPHeaders.builder().addEntries(headers).build();
    }

    public static HTTPHeaders of(Map<String, String> headers) {
        return ImmutableHTTPHeaders.builder().entries(headers.entrySet().stream().map(e -> HTTPHeader.of((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList())).build();
    }

    @Value.Style(redactedMask="****", depluralize=true)
    @Value.Immutable
    public static interface HTTPHeader {
        public String name();

        @Value.Redacted
        public String value();

        @Value.Check
        default public void check() {
            if (this.name().isEmpty()) {
                throw new IllegalArgumentException("Header name cannot be empty");
            }
        }

        public static HTTPHeader of(String name, String value) {
            return ImmutableHTTPHeader.builder().name(name).value(value).build();
        }
    }
}

